//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  Word-wrap algorithm that takes into account beautifulness ;)
	///  That means:
	/// 
	/// <li>
	/// not letting a letter alone on the last line,
	/// </li>
	/// 
	/// <li>
	/// breaking at punctuation signs (not only at spaces)
	/// </li>
	/// 
	/// <li>
	/// improved handling of (), [] and {}
	/// </li>
	/// 
	/// <li>
	/// improved handling of '/' (e.g. for paths)
	/// </li>
	///  Usage: call the static method, formatText, with the text to
	///  wrap and the constraining rectangle etc., it will return an instance of KWordWrap
	///  containing internal data, result of the word-wrapping.
	///  From that instance you can retrieve the boundingRect, and invoke drawing.
	///  This design allows to call the word-wrap algorithm only when the text changes
	///  and not every time we want to know the bounding rect or draw the text.
	/// </remarks>		<author> David Faure <faure@kde.org>
	///  </author>
	/// 		<short>    Word-wrap algorithm that takes into account beautifulness ;) </short>

	[SmokeClass("KWordWrap")]
	public class KWordWrap : Object {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KWordWrap(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KWordWrap), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KWordWrap() {
			staticInterceptor = new SmokeInvocation(typeof(KWordWrap), null);
		}
		public const int FadeOut = 0x10000000;
		public const int Truncate = 0x20000000;

		/// <remarks>
		/// </remarks>		<return> the bounding rect, calculated by formatText. The width is the
		///          width of the widest text line, and never wider than
		///          the rectangle given to formatText. The height is the
		///          text block. X and Y are always 0.
		///      </return>
		/// 		<short>   </short>
		public QRect BoundingRect() {
			return (QRect) interceptor.Invoke("boundingRect", "boundingRect() const", typeof(QRect));
		}
		/// <remarks>
		/// </remarks>		<return> the original string, with '\n' inserted where
		///  the text is broken by the wordwrap algorithm.
		///      </return>
		/// 		<short>   </short>
		public string WrappedString() {
			return (string) interceptor.Invoke("wrappedString", "wrappedString() const", typeof(string));
		}
		/// <remarks>
		/// </remarks>		<return> the original string, truncated to the first line.
		///  If <code>dots</code> was set, '...' is appended in case the string was truncated.
		///  Bug: Note that the '...' come out of the bounding rect.
		///      </return>
		/// 		<short>   </short>
		public string TruncatedString(bool dots) {
			return (string) interceptor.Invoke("truncatedString$", "truncatedString(bool) const", typeof(string), typeof(bool), dots);
		}
		public string TruncatedString() {
			return (string) interceptor.Invoke("truncatedString", "truncatedString() const", typeof(string));
		}
		/// <remarks>
		///  Draw the text that has been previously wrapped, at position x,y.
		///  Flags are for alignment, e.g. Qt.AlignHCenter. Default is
		///  Qt.AlignAuto.
		/// <param> name="painter" the QPainter to use.
		/// </param><param> name="x" the horizontal position of the text
		/// </param><param> name="y" the vertical position of the text
		/// </param><param> name="flags" the ORed text alignment flags from the Qt namespace,
		///               ORed with FadeOut if you want the text to fade out if it
		///               does not fit (the <code>painter</code>'s background must be set
		///               accordingly)
		///      </param></remarks>		<short>    Draw the text that has been previously wrapped, at position x,y.</short>
		public void DrawText(QPainter painter, int x, int y, int flags) {
			interceptor.Invoke("drawText#$$$", "drawText(QPainter*, int, int, int) const", typeof(void), typeof(QPainter), painter, typeof(int), x, typeof(int), y, typeof(int), flags);
		}
		public void DrawText(QPainter painter, int x, int y) {
			interceptor.Invoke("drawText#$$", "drawText(QPainter*, int, int) const", typeof(void), typeof(QPainter), painter, typeof(int), x, typeof(int), y);
		}
		/// <remarks>
		///  Main method for wrapping text.
		/// <param> name="fm" Font metrics, for the chosen font. Better cache it, creating a QFontMetrics is expensive.
		/// </param><param> name="r" Constraining rectangle. Only the width and height matter. With
		///           negative height the complete text will be rendered
		/// </param><param> name="flags" currently unused
		/// </param><param> name="str" The text to be wrapped.
		/// </param><param> name="len" Length of text to wrap (default is -1 for all).
		/// </param></remarks>		<return> a KWordWrap instance. The caller is responsible for storing and deleting the result.
		///      </return>
		/// 		<short>    Main method for wrapping text.</short>
		public static KWordWrap FormatText(QFontMetrics fm, QRect r, int flags, string str, int len) {
			return (KWordWrap) staticInterceptor.Invoke("formatText##$$$", "formatText(QFontMetrics&, const QRect&, int, const QString&, int)", typeof(KWordWrap), typeof(QFontMetrics), fm, typeof(QRect), r, typeof(int), flags, typeof(string), str, typeof(int), len);
		}
		public static KWordWrap FormatText(QFontMetrics fm, QRect r, int flags, string str) {
			return (KWordWrap) staticInterceptor.Invoke("formatText##$$", "formatText(QFontMetrics&, const QRect&, int, const QString&)", typeof(KWordWrap), typeof(QFontMetrics), fm, typeof(QRect), r, typeof(int), flags, typeof(string), str);
		}
		/// <remarks>
		///  Draws the string <code>t</code> at the given coordinates, if it does not
		///  <code>fit</code> into <code>maxW</code> the text will be faded out.
		/// <param> name="p" the painter to use. Must have set the pen for the text
		///         color and the background for the color to fade out
		/// </param><param> name="x" the horizontal position of the text
		/// </param><param> name="y" the vertical position of the text
		/// </param><param> name="maxW" the maximum width of the text (including the fade-out
		///              effect)
		/// </param><param> name="t" the text to draw
		///      </param></remarks>		<short>    Draws the string <code>t</code> at the given coordinates, if it does not  <code>fit</code> into <code>maxW</code> the text will be faded out.</short>
		public static void DrawFadeoutText(QPainter p, int x, int y, int maxW, string t) {
			staticInterceptor.Invoke("drawFadeoutText#$$$$", "drawFadeoutText(QPainter*, int, int, int, const QString&)", typeof(void), typeof(QPainter), p, typeof(int), x, typeof(int), y, typeof(int), maxW, typeof(string), t);
		}
		/// <remarks>
		///  Draws the string <code>t</code> at the given coordinates, if it does not
		///  <code>fit</code> into <code>maxW</code> the text will be truncated.
		/// <param> name="p" the painter to use
		/// </param><param> name="x" the horizontal position of the text
		/// </param><param> name="y" the vertical position of the text
		/// </param><param> name="maxW" the maximum width of the text (including the '...')
		/// </param><param> name="t" the text to draw
		///      </param></remarks>		<short>    Draws the string <code>t</code> at the given coordinates, if it does not  <code>fit</code> into <code>maxW</code> the text will be truncated.</short>
		public static void DrawTruncateText(QPainter p, int x, int y, int maxW, string t) {
			staticInterceptor.Invoke("drawTruncateText#$$$$", "drawTruncateText(QPainter*, int, int, int, const QString&)", typeof(void), typeof(QPainter), p, typeof(int), x, typeof(int), y, typeof(int), maxW, typeof(string), t);
		}
	}
}
