//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;

	/// <remarks>
	///  Class representing data about an application startup notification.
	///  Such data include the icon of the starting application, the desktop on which
	///  the application should start, the binary name of the application, etc.
	/// </remarks>		<author> Lubos Lunak <l.lunak@kde.org>
	///  </author>
	/// 		<short>    Class representing data about an application startup notification.</short>
	/// 		<see> KStartupInfo</see>
	/// 		<see> KStartupInfoId</see>

	[SmokeClass("KStartupInfoData")]
	public class KStartupInfoData : Object, IDisposable {
		protected SmokeInvocation interceptor = null;
		private IntPtr smokeObject;
		protected KStartupInfoData(Type dummy) {}
		protected void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KStartupInfoData), this);
		}
		/// <remarks>
		/// 	 </remarks>		<short>   </short>
		public enum TriState {
			Yes = 0,
			No = 1,
			Unknown = 2,
		}
		// QList<pid_t> pids(); >>>> NOT CONVERTED
		/// <remarks>
		///  Sets the binary name of the application ( e.g. 'kcontrol' ).
		/// <param> name="bin" the new binary name of the application
		/// 	 </param></remarks>		<short>    Sets the binary name of the application ( e.</short>
		public void SetBin(string bin) {
			interceptor.Invoke("setBin$", "setBin(const QString&)", typeof(void), typeof(string), bin);
		}
		/// <remarks>
		///  Returns the binary name of the starting application
		/// </remarks>		<return> the new binary name of the application
		/// 	 </return>
		/// 		<short>    Returns the binary name of the starting application </short>
		public string Bin() {
			return (string) interceptor.Invoke("bin", "bin() const", typeof(string));
		}
		/// <remarks>
		///  Sets the name for the notification (e.g. 'Control Center')
		/// 	 </remarks>		<short>    Sets the name for the notification (e.</short>
		public void SetName(string name) {
			interceptor.Invoke("setName$", "setName(const QString&)", typeof(void), typeof(string), name);
		}
		/// <remarks>
		///  Returns the name of the startup notification. If it's not available,
		///  it tries to use other information (binary name).
		/// </remarks>		<return> the name of the startup notification
		/// 	 </return>
		/// 		<short>    Returns the name of the startup notification.</short>
		public string FindName() {
			return (string) interceptor.Invoke("findName", "findName() const", typeof(string));
		}
		/// <remarks>
		///  Returns the name of the startup notification, or empty if not available.
		/// </remarks>		<return> the name of the startup notification, or an empty string
		///          if not set.
		/// 	 </return>
		/// 		<short>    Returns the name of the startup notification, or empty if not available.</short>
		public string Name() {
			return (string) interceptor.Invoke("name", "name() const", typeof(string));
		}
		/// <remarks>
		///  Sets the description for the notification (e.g. 'Launching Control Center').
		///  I.e. name() describes what is being started, while description() is
		///  the actual action performed by the starting.
		/// 	 </remarks>		<short>    Sets the description for the notification (e.</short>
		public void SetDescription(string descr) {
			interceptor.Invoke("setDescription$", "setDescription(const QString&)", typeof(void), typeof(string), descr);
		}
		/// <remarks>
		///  Returns the description of the startup notification. If it's not available,
		///  it returns name().
		/// </remarks>		<return> the description of the startup notification
		/// 	 </return>
		/// 		<short>    Returns the description of the startup notification.</short>
		public string FindDescription() {
			return (string) interceptor.Invoke("findDescription", "findDescription() const", typeof(string));
		}
		/// <remarks>
		///  Returns the name of the startup notification, or empty if not available.
		/// </remarks>		<return> the name of the startup notificaiton, or an empty string
		///          if not set.
		/// 	 </return>
		/// 		<short>    Returns the name of the startup notification, or empty if not available.</short>
		public string Description() {
			return (string) interceptor.Invoke("description", "description() const", typeof(string));
		}
		/// <remarks>
		///  Sets the icon for the startup notification ( e.g. 'kcontrol' )
		/// <param> name="icon" the name of the icon
		/// 	 </param></remarks>		<short>    Sets the icon for the startup notification ( e.</short>
		public void SetIcon(string icon) {
			interceptor.Invoke("setIcon$", "setIcon(const QString&)", typeof(void), typeof(string), icon);
		}
		/// <remarks>
		///  Returns the icon of the startup notification, and if it's not available,
		///  tries to get it from the binary name.
		/// </remarks>		<return> the name of the startup notification's icon, or the name of
		///          the binary if not set
		/// 	 </return>
		/// 		<short>    Returns the icon of the startup notification, and if it's not available,  tries to get it from the binary name.</short>
		public string FindIcon() {
			return (string) interceptor.Invoke("findIcon", "findIcon() const", typeof(string));
		}
		/// <remarks>
		///  Returns the icon of the startup notification, or empty if not available.
		/// </remarks>		<return> the name of the icon, or an empty string if not set.
		/// 	 </return>
		/// 		<short>    Returns the icon of the startup notification, or empty if not available.</short>
		public string Icon() {
			return (string) interceptor.Invoke("icon", "icon() const", typeof(string));
		}
		/// <remarks>
		///  Sets the desktop for the startup notification ( i.e. the desktop on which
		///  the starting application should appear ).
		/// <param> name="desktop" the desktop for the startup notification
		/// 	 </param></remarks>		<short>    Sets the desktop for the startup notification ( i.</short>
		public void SetDesktop(int desktop) {
			interceptor.Invoke("setDesktop$", "setDesktop(int)", typeof(void), typeof(int), desktop);
		}
		/// <remarks>
		///  Returns the desktop for the startup notification.
		/// </remarks>		<return> the desktop for the startup notification
		/// 	 </return>
		/// 		<short>    Returns the desktop for the startup notification.</short>
		public int Desktop() {
			return (int) interceptor.Invoke("desktop", "desktop() const", typeof(int));
		}
		/// <remarks>
		///  Sets a WM_CLASS value for the startup notification, it may be used for increasing
		///  the chance that the windows created by the starting application will be
		///  detected correctly.
		/// <param> name="wmclass" the WM_CLASS value for the startup notification
		/// 	 </param></remarks>		<short>    Sets a WM_CLASS value for the startup notification, it may be used for increasing  the chance that the windows created by the starting application will be  detected correctly.</short>
		public void SetWMClass(QByteArray wmclass) {
			interceptor.Invoke("setWMClass#", "setWMClass(const QByteArray&)", typeof(void), typeof(QByteArray), wmclass);
		}
		/// <remarks>
		///  Returns the WM_CLASS value for the startup notification, or binary name if not
		///  available.
		/// </remarks>		<return> the WM_CLASS value for the startup notification, or the binary name
		///          if not set
		/// 	 </return>
		/// 		<short>    Returns the WM_CLASS value for the startup notification, or binary name if not  available.</short>
		public QByteArray FindWMClass() {
			return (QByteArray) interceptor.Invoke("findWMClass", "findWMClass() const", typeof(QByteArray));
		}
		/// <remarks>
		///  Returns the WM_CLASS value for the startup notification, or empty if not available.
		/// </remarks>		<return> the WM_CLASS value for the startup notification, or empty
		///          if not set
		/// 	 </return>
		/// 		<short>    Returns the WM_CLASS value for the startup notification, or empty if not available.</short>
		public QByteArray WMClass() {
			return (QByteArray) interceptor.Invoke("WMClass", "WMClass() const", typeof(QByteArray));
		}
		/// <remarks>
		///  Adds a PID to the list of processes that belong to the startup notification. It
		///  may be used to increase the chance that the windows created by the starting
		///  application will be detected correctly, and also for detecting if the application
		///  has quit without creating any window.
		/// <param> name="pid" the PID to add
		/// 	 </param></remarks>		<short>    Adds a PID to the list of processes that belong to the startup notification.</short>
		public void AddPid(int pid) {
			interceptor.Invoke("addPid$", "addPid(pid_t)", typeof(void), typeof(int), pid);
		}
		/// <remarks>
		///  Returns all PIDs for the startup notification.
		/// </remarks>		<return> the list of all PIDs
		/// 	 </return>
		/// 		<short>    Returns all PIDs for the startup notification.</short>
		/// <remarks>
		///  Checks whether the given <code>pid</code> is in the list of PIDs for starup
		///  notification.
		/// </remarks>		<return> true if the given <code>pid</code> is in the list of PIDs for the startup notification
		/// 	 </return>
		/// 		<short>    Checks whether the given <code>pid</code> is in the list of PIDs for starup  notification.</short>
		public bool Is_pid(int pid) {
			return (bool) interceptor.Invoke("is_pid$", "is_pid(pid_t) const", typeof(bool), typeof(int), pid);
		}
		/// <remarks>
		///  Sets the hostname on which the application is starting. It's necessary to set
		///  it if PIDs are set.
		/// <param> name="hostname" the application's hostname. If it's a null string, the current hostname is used
		/// 	 </param></remarks>		<short>    Sets the hostname on which the application is starting.</short>
		public void SetHostname(QByteArray hostname) {
			interceptor.Invoke("setHostname#", "setHostname(const QByteArray&)", typeof(void), typeof(QByteArray), hostname);
		}
		public void SetHostname() {
			interceptor.Invoke("setHostname", "setHostname()", typeof(void));
		}
		/// <remarks>
		///  Returns the hostname for the startup notification.
		/// </remarks>		<return> the hostname
		/// 	 </return>
		/// 		<short>    Returns the hostname for the startup notification.</short>
		public QByteArray Hostname() {
			return (QByteArray) interceptor.Invoke("hostname", "hostname() const", typeof(QByteArray));
		}
		/// <remarks>
		///  Sets whether the visual feedback for this startup notification
		///  should be silenced (temporarily suspended).
		/// 	 </remarks>		<short>    Sets whether the visual feedback for this startup notification  should be silenced (temporarily suspended).</short>
		public void SetSilent(KStartupInfoData.TriState state) {
			interceptor.Invoke("setSilent$", "setSilent(KStartupInfoData::TriState)", typeof(void), typeof(KStartupInfoData.TriState), state);
		}
		/// <remarks>
		///  Return the silence status for the startup notification.
		/// </remarks>		<return> KStartupInfoData.Yes if visual feedback is silenced
		/// 	 </return>
		/// 		<short>    Return the silence status for the startup notification.</short>
		public KStartupInfoData.TriState Silent() {
			return (KStartupInfoData.TriState) interceptor.Invoke("silent", "silent() const", typeof(KStartupInfoData.TriState));
		}
		/// <remarks>
		///  The X11 screen on which the startup notification is happening, -1 if unknown.
		///          </remarks>		<short>    The X11 screen on which the startup notification is happening, -1 if unknown.</short>
		public int Screen() {
			return (int) interceptor.Invoke("screen", "screen() const", typeof(int));
		}
		/// <remarks>
		///  Sets the X11 screen on which the startup notification should happen.
		///  This is usually not necessary to set, as it's set by default to QX11Info.Screen().
		///          </remarks>		<short>    Sets the X11 screen on which the startup notification should happen.</short>
		public void SetScreen(int screen) {
			interceptor.Invoke("setScreen$", "setScreen(int)", typeof(void), typeof(int), screen);
		}
		/// <remarks>
		///  The Xinerama screen for the startup notification, -1 if unknown.
		///          </remarks>		<short>    The Xinerama screen for the startup notification, -1 if unknown.</short>
		public int Xinerama() {
			return (int) interceptor.Invoke("xinerama", "xinerama() const", typeof(int));
		}
		/// <remarks>        
		///  Sets the Xinerama screen for the startup notification ( i.e. the screeen on which
		///  the starting application should appear ).
		/// <param> name="xinerama" the Xinerama screen for the startup notification
		///          </param></remarks>		<short>            Sets the Xinerama screen for the startup notification ( i.</short>
		public void SetXinerama(int xinerama) {
			interceptor.Invoke("setXinerama$", "setXinerama(int)", typeof(void), typeof(int), xinerama);
		}
		/// <remarks>
		///  The toplevel window of the application that caused this startup notification,
		///  0 if unknown.
		///          </remarks>		<short>    The toplevel window of the application that caused this startup notification,  0 if unknown.</short>
		public uint LaunchedBy() {
			return (uint) interceptor.Invoke("launchedBy", "launchedBy() const", typeof(uint));
		}
		/// <remarks>
		///  Sets the toplevel window of the application that caused this startup notification.
		/// <param> name="window" window ID of the toplevel window that is responsible for this startup
		///          </param></remarks>		<short>    Sets the toplevel window of the application that caused this startup notification.</short>
		public void SetLaunchedBy(uint window) {
			interceptor.Invoke("setLaunchedBy$", "setLaunchedBy(WId)", typeof(void), typeof(uint), window);
		}
		/// <remarks>
		///  Updates the notification data from the given data. Some data, such as the desktop
		///  or the name, won't be rewritten if already set.
		/// <param> name="data" the data to update
		/// 	 </param></remarks>		<short>    Updates the notification data from the given data.</short>
		public void Update(KStartupInfoData data) {
			interceptor.Invoke("update#", "update(const KStartupInfoData&)", typeof(void), typeof(KStartupInfoData), data);
		}
		/// <remarks>
		///  Constructor. Initializes all the data to their default empty values.
		/// 	 </remarks>		<short>    Constructor.</short>
		public KStartupInfoData() : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KStartupInfoData", "KStartupInfoData()", typeof(void));
		}
		/// <remarks>
		///  Copy constructor.
		/// 	 </remarks>		<short>    Copy constructor.</short>
		public KStartupInfoData(KStartupInfoData data) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KStartupInfoData#", "KStartupInfoData(const KStartupInfoData&)", typeof(void), typeof(KStartupInfoData), data);
		}
		~KStartupInfoData() {
			interceptor.Invoke("~KStartupInfoData", "~KStartupInfoData()", typeof(void));
		}
		public void Dispose() {
			interceptor.Invoke("~KStartupInfoData", "~KStartupInfoData()", typeof(void));
		}
	}
}
