//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {

	using System;
	using Qyoto;
	using System.Text;
	using System.Collections.Generic;

	/// <remarks>
	///  Provides a user (and developer) friendly way to
	///  select files and directories.
	///  The widget can be used as a drop in replacement for the
	///  QFileDialog widget, but has greater functionality and a nicer GUI.
	///  You will usually want to use one of the static methods
	///  getOpenFileName(), getSaveFileName(), getOpenUrl()
	///  or for multiple files getOpenFileNames() or getOpenUrls().
	///  The dialog has been designed to allow applications to customize it
	///  by subclassing. It uses geometry management to ensure that subclasses
	///  can easily add children that will be incorporated into the layout.
	///  \image html kfiledialog.png "KDE File Dialog"
	///  See <see cref="IKFileDialogSignals"></see> for signals emitted by KFileDialog
	/// </remarks>		<author> Richard J. Moore <rich@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
	///  </author>
	/// 		<short> A file selection dialog. </short>

	[SmokeClass("KFileDialog")]
	public class KFileDialog : KDialog, IDisposable {
 		protected KFileDialog(Type dummy) : base((Type) null) {}
		protected new void CreateProxy() {
			interceptor = new SmokeInvocation(typeof(KFileDialog), this);
		}
		private static SmokeInvocation staticInterceptor = null;
		static KFileDialog() {
			staticInterceptor = new SmokeInvocation(typeof(KFileDialog), null);
		}
		/// <remarks>
		///  Defines some default behavior of the filedialog.
		///  E.g. in mode <code>Opening</code> and <code>Saving</code>, the selected files/urls will
		///  be added to the "recent documents" list. The Saving mode also implies
		///  setKeepLocation() being set.
		///  <code>Other</code> means that no default actions are performed.
		/// </remarks>		<short>    Defines some default behavior of the filedialog.</short>
		/// 		<see> setOperationMode</see>
		/// 		<see> operationMode</see>
		public enum OperationMode {
			Other = 0,
			Opening = 1,
			Saving = 2,
		}
		// KMimeType::Ptr currentFilterMimeType(); >>>> NOT CONVERTED
		// void setMode(KFile::Modes arg1); >>>> NOT CONVERTED
		// KFile::Modes mode(); >>>> NOT CONVERTED
		// KAbstractFileWidget* fileWidget(); >>>> NOT CONVERTED
		/// <remarks>
		///  Constructs a file dialog.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="filter" A shell glob or a mime-type-filter that specifies
		///                which files to display.
		///  See setFilter() and setMimeFilter() for details on how to use this argument.
		/// </param><param> name="parent" The parent widget of this dialog
		/// </param><param> name="widget" A widget, or a widget of widgets, for displaying custom
		///                data in the dialog. This can be used, for example, to
		///                display a check box with the caption "Open as read-only".
		///                When creating this widget, you don't need to specify a parent,
		///                since the widget's parent will be set automatically by KFileDialog.
		///       </param></remarks>		<short>    Constructs a file dialog.</short>
		public KFileDialog(KUrl startDir, string filter, QWidget parent, QWidget widget) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KFileDialog#$##", "KFileDialog(const KUrl&, const QString&, QWidget*, QWidget*)", typeof(void), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent, typeof(QWidget), widget);
		}
		public KFileDialog(KUrl startDir, string filter, QWidget parent) : this((Type) null) {
			CreateProxy();
			interceptor.Invoke("KFileDialog#$#", "KFileDialog(const KUrl&, const QString&, QWidget*)", typeof(void), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent);
		}
		/// <remarks>
		/// </remarks>		<return> The selected fully qualified filename.
		///      </return>
		/// 		<short>   </short>
		public KUrl SelectedUrl() {
			return (KUrl) interceptor.Invoke("selectedUrl", "selectedUrl() const", typeof(KUrl));
		}
		/// <remarks>
		/// </remarks>		<return> The list of selected URLs.
		///      </return>
		/// 		<short>   </short>
		public List<KUrl> SelectedUrls() {
			return (List<KUrl>) interceptor.Invoke("selectedUrls", "selectedUrls() const", typeof(List<KUrl>));
		}
		/// <remarks>
		/// </remarks>		<return> the currently shown directory.
		///      </return>
		/// 		<short>   </short>
		public KUrl BaseUrl() {
			return (KUrl) interceptor.Invoke("baseUrl", "baseUrl() const", typeof(KUrl));
		}
		/// <remarks>
		///  Returns the full path of the selected file in the local filesystem.
		///  (Local files only)
		///      </remarks>		<short>    Returns the full path of the selected file in the local filesystem.</short>
		public string SelectedFile() {
			return (string) interceptor.Invoke("selectedFile", "selectedFile() const", typeof(string));
		}
		/// <remarks>
		///  Returns a list of all selected local files.
		///      </remarks>		<short>    Returns a list of all selected local files.</short>
		public List<string> SelectedFiles() {
			return (List<string>) interceptor.Invoke("selectedFiles", "selectedFiles() const", typeof(List<string>));
		}
		/// <remarks>
		///  Sets the directory to view.
		/// <param> name="url" URL to show.
		/// </param><param> name="clearforward" Indicates whether the forward queue
		///  should be cleared.
		///      </param></remarks>		<short>    Sets the directory to view.</short>
		public void SetUrl(KUrl url, bool clearforward) {
			interceptor.Invoke("setUrl#$", "setUrl(const KUrl&, bool)", typeof(void), typeof(KUrl), url, typeof(bool), clearforward);
		}
		public void SetUrl(KUrl url) {
			interceptor.Invoke("setUrl#", "setUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
		}
		/// <remarks>
		///  Sets the file name to preselect to <code>name</code>
		///  This takes absolute URLs and relative file names.
		///      </remarks>		<short>    Sets the file name to preselect to <code>name</code> </short>
		public void SetSelection(string name) {
			interceptor.Invoke("setSelection$", "setSelection(const QString&)", typeof(void), typeof(string), name);
		}
		/// <remarks>
		///  Sets the operational mode of the filedialog to <code>Saving</code>, <code>Opening</code>
		///  or <code>Other.</code> This will set some flags that are specific to loading
		///  or saving files. E.g. setKeepLocation() makes mostly sense for
		///  a save-as dialog. So setOperationMode( KFileDialog.Saving ); sets
		///  setKeepLocation for example.
		///  The mode <code>Saving</code>, together with a default filter set via
		///  setMimeFilter() will make the filter combobox read-only.
		///  The default mode is <code>Opening.</code>
		///  Call this method right after instantiating KFileDialog.
		/// </remarks>		<short>    Sets the operational mode of the filedialog to <code>Saving</code>, <code>Opening</code>  or <code>Other.</code></short>
		/// 		<see> operationMode</see>
		/// 		<see> KFileDialog.OperationMode</see>
		public void SetOperationMode(KFileDialog.OperationMode arg1) {
			interceptor.Invoke("setOperationMode$", "setOperationMode(KFileDialog::OperationMode)", typeof(void), typeof(KFileDialog.OperationMode), arg1);
		}
		/// <remarks>
		/// </remarks>		<return> the current operation mode, Opening, Saving or Other. Default
		///  is Other.
		/// </return>
		/// 		<short>   </short>
		/// 		<see> operationMode</see>
		/// 		<see> KFileDialog.OperationMode</see>
		public KFileDialog.OperationMode operationMode() {
			return (KFileDialog.OperationMode) interceptor.Invoke("operationMode", "operationMode() const", typeof(KFileDialog.OperationMode));
		}
		/// <remarks>
		///  Sets whether the filename/url should be kept when changing directories.
		///  This is for example useful when having a predefined filename where
		///  the full path for that file is searched.
		///  This is implicitly set when operationMode() is KFileDialog.Saving
		///  getSaveFileName() and getSaveUrl() set this to true by default, so that
		///  you can type in the filename and change the directory without having
		///  to type the name again.
		///      </remarks>		<short>    Sets whether the filename/url should be kept when changing directories.</short>
		public void SetKeepLocation(bool keep) {
			interceptor.Invoke("setKeepLocation$", "setKeepLocation(bool)", typeof(void), typeof(bool), keep);
		}
		/// <remarks>
		/// </remarks>		<return> whether the contents of the location edit are kept when
		///  changing directories.
		///      </return>
		/// 		<short>   </short>
		public bool KeepsLocation() {
			return (bool) interceptor.Invoke("keepsLocation", "keepsLocation() const", typeof(bool));
		}
		/// <remarks>
		///  Sets the filter to be used to <code>filter.</code>
		///  You can set more
		///  filters for the user to select separated by @c '\\n'. Every
		///  filter entry is defined through <code>namefilter</code>|text to display.
		///  If no @c '|' is found in the expression, just the namefilter is
		///  shown. Examples:
		///  <pre>
		///  kfile.SetFilter("*.cpp|C++ Source Files\n.h|Header files");
		///  kfile.SetFilter("*.cpp");
		///  kfile.SetFilter("*.cpp|Sources (.cpp)");
		///  kfile.SetFilter("*.cpp|" + i18n("Sources (.cpp)"));
		///  kfile.SetFilter("*.cpp .cc .C|C++ Source Files\n.h .H|Header files");
		///  </pre>
		///  Note: The text to display is not parsed in any way. So, if you
		///  want to show the suffix to select by a specific filter, you must
		///  repeat it.
		///  If the filter contains an unescaped @c '/', a mimetype-filter is assumed.
		///  If you would like a '/' visible in your filter it can be escaped with
		///  a @c '\'. You can specify multiple mimetypes like this (separated with
		///  space):
		///  <pre>
		///  kfile.SetFilter( "image/png text/html text/plain" );
		///  kfile.SetFilter( "*.cue|CUE\\/BIN Files (.cue)" );
		///  </pre>
		/// </remarks>		<short>    Sets the filter to be used to <code>filter.</code></short>
		/// 		<see> filterChanged</see>
		/// 		<see> setMimeFilter</see>
		public void SetFilter(string filter) {
			interceptor.Invoke("setFilter$", "setFilter(const QString&)", typeof(void), typeof(string), filter);
		}
		/// <remarks>
		///  Returns the current filter as entered by the user or one of the
		///  predefined set via setFilter().
		/// </remarks>		<short>    Returns the current filter as entered by the user or one of the  predefined set via setFilter().</short>
		/// 		<see> setFilter</see>
		/// 		<see> filterChanged</see>
		public string CurrentFilter() {
			return (string) interceptor.Invoke("currentFilter", "currentFilter() const", typeof(string));
		}
		/// <remarks>
		///  Returns the mimetype for the desired output format.
		///  This is only valid if setFilterMimeType() has been called
		///  previously.
		/// </remarks>		<short>    Returns the mimetype for the desired output format.</short>
		/// 		<see> setFilterMimeType</see>
		/// <remarks>
		///  Sets the filter up to specify the output type.
		/// <param> name="types" a list of mimetypes that can be used as output format
		/// </param><param> name="defaultType" the default mimetype to use as output format, if any.
		///  If <code>defaultType</code> is set, it will be set as the current item.
		///  Otherwise, a first item showing all the mimetypes will be created.
		///  Typically, <code>defaultType</code> should be empty for loading and set for saving.
		/// </param> Do not use in conjunction with setFilter()
		///      </remarks>		<short>    Sets the filter up to specify the output type.</short>
		public void SetMimeFilter(List<string> types, string defaultType) {
			interceptor.Invoke("setMimeFilter?$", "setMimeFilter(const QStringList&, const QString&)", typeof(void), typeof(List<string>), types, typeof(string), defaultType);
		}
		public void SetMimeFilter(List<string> types) {
			interceptor.Invoke("setMimeFilter?", "setMimeFilter(const QStringList&)", typeof(void), typeof(List<string>), types);
		}
		/// <remarks>
		///  The mimetype for the desired output format.
		///  This is only valid if setMimeFilter() has been called
		///  previously.
		/// </remarks>		<short>    The mimetype for the desired output format.</short>
		/// 		<see> setMimeFilter</see>
		public string CurrentMimeFilter() {
			return (string) interceptor.Invoke("currentMimeFilter", "currentMimeFilter() const", typeof(string));
		}
		/// <remarks>
		///   Clears any mime- or namefilter. Does not reload the directory.
		///      </remarks>		<short>     Clears any mime- or namefilter.</short>
		public void ClearFilter() {
			interceptor.Invoke("clearFilter", "clearFilter()", typeof(void));
		}
		/// <remarks>
		///  Adds a preview widget and enters the preview mode.
		///  In this mode the dialog is split and the right part contains your
		///  preview widget.
		///  Ownership is transferred to KFileDialog. You need to create the
		///  preview-widget with "new", i.e. on the heap.
		/// <param> name="w" The widget to be used for the preview.
		///      </param></remarks>		<short>    Adds a preview widget and enters the preview mode.</short>
		public void SetPreviewWidget(KPreviewWidgetBase w) {
			interceptor.Invoke("setPreviewWidget#", "setPreviewWidget(KPreviewWidgetBase*)", typeof(void), typeof(KPreviewWidgetBase), w);
		}
		/// <remarks> @see QWidget.SizeHint() </remarks>		<short>   @see QWidget.SizeHint() </short>
		[SmokeMethod("sizeHint() const")]
		public override QSize SizeHint() {
			return (QSize) interceptor.Invoke("sizeHint", "sizeHint() const", typeof(QSize));
		}
		/// <remarks>
		///  Sets the mode of the dialog.
		///  The mode is defined as (in kfile.h):
		///  <pre>
		///     enum Mode {
		///          File         = 1,
		///          Directory    = 2,
		///          Files        = 4,
		///          ExistingOnly = 8,
		///          LocalOnly    = 16
		///     }
		///  </pre>
		///  You can OR the values, e.g.
		///  <pre>
		///  KFile.Modes mode = KFile.Files |
		///                      KFile.ExistingOnly |
		///                      KFile.LocalOnly );
		///  setMode( mode );
		///  </pre>
		///      </remarks>		<short>    Sets the mode of the dialog.</short>
		/// <remarks>
		///  Returns the mode of the filedialog.
		/// </remarks>		<short>    Returns the mode of the filedialog.</short>
		/// 		<see> setMode</see>
		/// <remarks>
		///  Sets the text to be displayed in front of the selection.
		///  The default is "Location".
		///  Most useful if you want to make clear what
		///  the location is used for.
		///      </remarks>		<short>    Sets the text to be displayed in front of the selection.</short>
		public void SetLocationLabel(string text) {
			interceptor.Invoke("setLocationLabel$", "setLocationLabel(const QString&)", typeof(void), typeof(string), text);
		}
		/// <remarks>
		///  Returns the KFileWidget that implements most of this file dialog.
		///  If you link to libkfile you can cast this to a KFileWidget.
		///      </remarks>		<short>    Returns the KFileWidget that implements most of this file dialog.</short>
		/// <remarks>
		///  Returns a pointer to the toolbar.
		///  You can use this to insert custom
		///  items into it, e.g.:
		///  <pre>
		///       yourAction = new KAction( i18n("Your Action"), 0,
		///                                 this, SLOT("yourSlot()"),
		///                                 this, "action name" );
		///       yourAction.Plug( kfileDialog.ToolBar() );
		///  </pre>
		///      </remarks>		<short>    Returns a pointer to the toolbar.</short>
		public KToolBar ToolBar() {
			return (KToolBar) interceptor.Invoke("toolBar", "toolBar() const", typeof(KToolBar));
		}
		/// <remarks>
		/// </remarks>		<return> a pointer to the OK-Button in the filedialog. You may use it
		///  e.g. to set a custom text to it.
		///      </return>
		/// 		<short>   </short>
		public KPushButton OkButton() {
			return (KPushButton) interceptor.Invoke("okButton", "okButton() const", typeof(KPushButton));
		}
		/// <remarks>
		/// </remarks>		<return> a pointer to the Cancel-Button in the filedialog. You may use
		///  it e.g. to set a custom text to it.
		///      </return>
		/// 		<short>   </short>
		public KPushButton CancelButton() {
			return (KPushButton) interceptor.Invoke("cancelButton", "cancelButton() const", typeof(KPushButton));
		}
		/// <remarks>
		/// </remarks>		<return> the combobox used to type the filename or full location of the file.
		///  You need to link to libkfile to use this widget.
		///      </return>
		/// 		<short>   </short>
		public KUrlComboBox LocationEdit() {
			return (KUrlComboBox) interceptor.Invoke("locationEdit", "locationEdit() const", typeof(KUrlComboBox));
		}
		/// <remarks>
		/// </remarks>		<return> the combobox that contains the filters
		///  You need to link to libkfile to use this widget.
		///      </return>
		/// 		<short>   </short>
		public KFileFilterCombo FilterWidget() {
			return (KFileFilterCombo) interceptor.Invoke("filterWidget", "filterWidget() const", typeof(KFileFilterCombo));
		}
		/// <remarks>
		/// </remarks>		<return> a pointer to the action collection, holding all the used KActions.
		///      </return>
		/// 		<short>   </short>
		public KActionCollection ActionCollection() {
			return (KActionCollection) interceptor.Invoke("actionCollection", "actionCollection() const", typeof(KActionCollection));
		}
		/// <remarks>
		///  Reimplemented to animate the cancel button.
		///      </remarks>		<short>    Reimplemented to animate the cancel button.</short>
		[SmokeMethod("keyPressEvent(QKeyEvent*)")]
		protected override void KeyPressEvent(QKeyEvent e) {
			interceptor.Invoke("keyPressEvent#", "keyPressEvent(QKeyEvent*)", typeof(void), typeof(QKeyEvent), e);
		}
		[Q_SLOT("void slotOk()")]
		[SmokeMethod("slotOk()")]
		protected virtual void SlotOk() {
			interceptor.Invoke("slotOk", "slotOk()", typeof(void));
		}
		[Q_SLOT("void accept()")]
		[SmokeMethod("accept()")]
		protected new virtual void Accept() {
			interceptor.Invoke("accept", "accept()", typeof(void));
		}
		[Q_SLOT("void slotCancel()")]
		[SmokeMethod("slotCancel()")]
		protected virtual void SlotCancel() {
			interceptor.Invoke("slotCancel", "slotCancel()", typeof(void));
		}
		~KFileDialog() {
			interceptor.Invoke("~KFileDialog", "~KFileDialog()", typeof(void));
		}
		public new void Dispose() {
			interceptor.Invoke("~KFileDialog", "~KFileDialog()", typeof(void));
		}
		/// <remarks>
		///  Creates a modal file dialog and return the selected
		///  filename or an empty string if none was chosen.
		///  Note that with
		///  this method the user must select an existing filename.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="filter" A shell glob or a mime-type-filter that specifies which files to display.
		///     The preferred option is to set a list of mimetype names, see setMimeFilter() for details.
		///     Otherwise you can set the text to be displayed for the each glob, and
		///     provide multiple globs, see setFilter() for details.
		/// </param><param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		///      </param></remarks>		<short>    Creates a modal file dialog and return the selected  filename or an empty string if none was chosen.</short>
		public static string GetOpenFileName(KUrl startDir, string filter, QWidget parent, string caption) {
			return (string) staticInterceptor.Invoke("getOpenFileName#$#$", "getOpenFileName(const KUrl&, const QString&, QWidget*, const QString&)", typeof(string), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent, typeof(string), caption);
		}
		public static string GetOpenFileName(KUrl startDir, string filter, QWidget parent) {
			return (string) staticInterceptor.Invoke("getOpenFileName#$#", "getOpenFileName(const KUrl&, const QString&, QWidget*)", typeof(string), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent);
		}
		public static string GetOpenFileName(KUrl startDir, string filter) {
			return (string) staticInterceptor.Invoke("getOpenFileName#$", "getOpenFileName(const KUrl&, const QString&)", typeof(string), typeof(KUrl), startDir, typeof(string), filter);
		}
		public static string GetOpenFileName(KUrl startDir) {
			return (string) staticInterceptor.Invoke("getOpenFileName#", "getOpenFileName(const KUrl&)", typeof(string), typeof(KUrl), startDir);
		}
		public static string GetOpenFileName() {
			return (string) staticInterceptor.Invoke("getOpenFileName", "getOpenFileName()", typeof(string));
		}
		/// <remarks>
		///  Use this version only if you have no QWidget available as
		///  parent widget. This can be the case if the parent widget is
		///  a widget in another process or if the parent widget is a
		///  non-Qt widget. For example, in a GTK program.
		///     </remarks>		<short>    Use this version only if you have no QWidget available as  parent widget.</short>
		public static string GetOpenFileNameWId(KUrl startDir, string filter, uint parent_id, string caption) {
			return (string) staticInterceptor.Invoke("getOpenFileNameWId#$$$", "getOpenFileNameWId(const KUrl&, const QString&, WId, const QString&)", typeof(string), typeof(KUrl), startDir, typeof(string), filter, typeof(uint), parent_id, typeof(string), caption);
		}
		/// <remarks>
		///  Creates a modal file dialog and returns the selected
		///  filenames or an empty list if none was chosen.
		///  Note that with
		///  this method the user must select an existing filename.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="filter" A shell glob or a mime-type-filter that specifies which files to display.
		///     The preferred option is to set a list of mimetype names, see setMimeFilter() for details.
		///     Otherwise you can set the text to be displayed for the each glob, and
		///     provide multiple globs, see setFilter() for details.
		/// </param><param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		///      </param></remarks>		<short>    Creates a modal file dialog and returns the selected  filenames or an empty list if none was chosen.</short>
		public static List<string> GetOpenFileNames(KUrl startDir, string filter, QWidget parent, string caption) {
			return (List<string>) staticInterceptor.Invoke("getOpenFileNames#$#$", "getOpenFileNames(const KUrl&, const QString&, QWidget*, const QString&)", typeof(List<string>), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent, typeof(string), caption);
		}
		public static List<string> GetOpenFileNames(KUrl startDir, string filter, QWidget parent) {
			return (List<string>) staticInterceptor.Invoke("getOpenFileNames#$#", "getOpenFileNames(const KUrl&, const QString&, QWidget*)", typeof(List<string>), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent);
		}
		public static List<string> GetOpenFileNames(KUrl startDir, string filter) {
			return (List<string>) staticInterceptor.Invoke("getOpenFileNames#$", "getOpenFileNames(const KUrl&, const QString&)", typeof(List<string>), typeof(KUrl), startDir, typeof(string), filter);
		}
		public static List<string> GetOpenFileNames(KUrl startDir) {
			return (List<string>) staticInterceptor.Invoke("getOpenFileNames#", "getOpenFileNames(const KUrl&)", typeof(List<string>), typeof(KUrl), startDir);
		}
		public static List<string> GetOpenFileNames() {
			return (List<string>) staticInterceptor.Invoke("getOpenFileNames", "getOpenFileNames()", typeof(List<string>));
		}
		/// <remarks>
		///  Creates a modal file dialog and returns the selected
		///  URL or an empty string if none was chosen.
		///  Note that with
		///  this method the user must select an existing URL.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="filter" A shell glob or a mime-type-filter that specifies which files to display.
		///     The preferred option is to set a list of mimetype names, see setMimeFilter() for details.
		///     Otherwise you can set the text to be displayed for the each glob, and
		///     provide multiple globs, see setFilter() for details.
		/// </param><param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		///      </param></remarks>		<short>    Creates a modal file dialog and returns the selected  URL or an empty string if none was chosen.</short>
		public static KUrl GetOpenUrl(KUrl startDir, string filter, QWidget parent, string caption) {
			return (KUrl) staticInterceptor.Invoke("getOpenUrl#$#$", "getOpenUrl(const KUrl&, const QString&, QWidget*, const QString&)", typeof(KUrl), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent, typeof(string), caption);
		}
		public static KUrl GetOpenUrl(KUrl startDir, string filter, QWidget parent) {
			return (KUrl) staticInterceptor.Invoke("getOpenUrl#$#", "getOpenUrl(const KUrl&, const QString&, QWidget*)", typeof(KUrl), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent);
		}
		public static KUrl GetOpenUrl(KUrl startDir, string filter) {
			return (KUrl) staticInterceptor.Invoke("getOpenUrl#$", "getOpenUrl(const KUrl&, const QString&)", typeof(KUrl), typeof(KUrl), startDir, typeof(string), filter);
		}
		public static KUrl GetOpenUrl(KUrl startDir) {
			return (KUrl) staticInterceptor.Invoke("getOpenUrl#", "getOpenUrl(const KUrl&)", typeof(KUrl), typeof(KUrl), startDir);
		}
		public static KUrl GetOpenUrl() {
			return (KUrl) staticInterceptor.Invoke("getOpenUrl", "getOpenUrl()", typeof(KUrl));
		}
		/// <remarks>
		///  Creates a modal file dialog and returns the selected
		///  URLs or an empty list if none was chosen.
		///  Note that with
		///  this method the user must select an existing filename.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="filter" A shell glob or a mime-type-filter that specifies which files to display.
		///     The preferred option is to set a list of mimetype names, see setMimeFilter() for details.
		///     Otherwise you can set the text to be displayed for the each glob, and
		///     provide multiple globs, see setFilter() for details.
		/// </param><param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		///      </param></remarks>		<short>    Creates a modal file dialog and returns the selected  URLs or an empty list if none was chosen.</short>
		public static List<KUrl> GetOpenUrls(KUrl startDir, string filter, QWidget parent, string caption) {
			return (List<KUrl>) staticInterceptor.Invoke("getOpenUrls#$#$", "getOpenUrls(const KUrl&, const QString&, QWidget*, const QString&)", typeof(List<KUrl>), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent, typeof(string), caption);
		}
		public static List<KUrl> GetOpenUrls(KUrl startDir, string filter, QWidget parent) {
			return (List<KUrl>) staticInterceptor.Invoke("getOpenUrls#$#", "getOpenUrls(const KUrl&, const QString&, QWidget*)", typeof(List<KUrl>), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent);
		}
		public static List<KUrl> GetOpenUrls(KUrl startDir, string filter) {
			return (List<KUrl>) staticInterceptor.Invoke("getOpenUrls#$", "getOpenUrls(const KUrl&, const QString&)", typeof(List<KUrl>), typeof(KUrl), startDir, typeof(string), filter);
		}
		public static List<KUrl> GetOpenUrls(KUrl startDir) {
			return (List<KUrl>) staticInterceptor.Invoke("getOpenUrls#", "getOpenUrls(const KUrl&)", typeof(List<KUrl>), typeof(KUrl), startDir);
		}
		public static List<KUrl> GetOpenUrls() {
			return (List<KUrl>) staticInterceptor.Invoke("getOpenUrls", "getOpenUrls()", typeof(List<KUrl>));
		}
		/// <remarks>
		///  Creates a modal file dialog and returns the selected
		///  filename or an empty string if none was chosen.
		///  Note that with this
		///  method the user need not select an existing filename.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="filter" A shell glob or a mime-type-filter that specifies which files to display.
		///     The preferred option is to set a list of mimetype names, see setMimeFilter() for details.
		///     Otherwise you can set the text to be displayed for the each glob, and
		///     provide multiple globs, see setFilter() for details.
		/// </param><param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		///      </param></remarks>		<short>    Creates a modal file dialog and returns the selected  filename or an empty string if none was chosen.</short>
		public static string GetSaveFileName(KUrl startDir, string filter, QWidget parent, string caption) {
			return (string) staticInterceptor.Invoke("getSaveFileName#$#$", "getSaveFileName(const KUrl&, const QString&, QWidget*, const QString&)", typeof(string), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent, typeof(string), caption);
		}
		public static string GetSaveFileName(KUrl startDir, string filter, QWidget parent) {
			return (string) staticInterceptor.Invoke("getSaveFileName#$#", "getSaveFileName(const KUrl&, const QString&, QWidget*)", typeof(string), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent);
		}
		public static string GetSaveFileName(KUrl startDir, string filter) {
			return (string) staticInterceptor.Invoke("getSaveFileName#$", "getSaveFileName(const KUrl&, const QString&)", typeof(string), typeof(KUrl), startDir, typeof(string), filter);
		}
		public static string GetSaveFileName(KUrl startDir) {
			return (string) staticInterceptor.Invoke("getSaveFileName#", "getSaveFileName(const KUrl&)", typeof(string), typeof(KUrl), startDir);
		}
		public static string GetSaveFileName() {
			return (string) staticInterceptor.Invoke("getSaveFileName", "getSaveFileName()", typeof(string));
		}
		/// <remarks>
		///  This function accepts the window id of the parent window, instead
		///  of QWidget. It should be used only when necessary.
		///      </remarks>		<short>    This function accepts the window id of the parent window, instead  of QWidget .</short>
		public static string GetSaveFileNameWId(KUrl startDir, string filter, uint parent_id, string caption) {
			return (string) staticInterceptor.Invoke("getSaveFileNameWId#$$$", "getSaveFileNameWId(const KUrl&, const QString&, WId, const QString&)", typeof(string), typeof(KUrl), startDir, typeof(string), filter, typeof(uint), parent_id, typeof(string), caption);
		}
		/// <remarks>
		///  Creates a modal file dialog and returns the selected
		///  filename or an empty string if none was chosen.
		///  Note that with this
		///  method the user need not select an existing filename.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="filter" A shell glob or a mime-type-filter that specifies which files to display.
		///     The preferred option is to set a list of mimetype names, see setMimeFilter() for details.
		///     Otherwise you can set the text to be displayed for the each glob, and
		///     provide multiple globs, see setFilter() for details.
		/// </param><param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		///      </param></remarks>		<short>    Creates a modal file dialog and returns the selected  filename or an empty string if none was chosen.</short>
		public static KUrl GetSaveUrl(KUrl startDir, string filter, QWidget parent, string caption) {
			return (KUrl) staticInterceptor.Invoke("getSaveUrl#$#$", "getSaveUrl(const KUrl&, const QString&, QWidget*, const QString&)", typeof(KUrl), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent, typeof(string), caption);
		}
		public static KUrl GetSaveUrl(KUrl startDir, string filter, QWidget parent) {
			return (KUrl) staticInterceptor.Invoke("getSaveUrl#$#", "getSaveUrl(const KUrl&, const QString&, QWidget*)", typeof(KUrl), typeof(KUrl), startDir, typeof(string), filter, typeof(QWidget), parent);
		}
		public static KUrl GetSaveUrl(KUrl startDir, string filter) {
			return (KUrl) staticInterceptor.Invoke("getSaveUrl#$", "getSaveUrl(const KUrl&, const QString&)", typeof(KUrl), typeof(KUrl), startDir, typeof(string), filter);
		}
		public static KUrl GetSaveUrl(KUrl startDir) {
			return (KUrl) staticInterceptor.Invoke("getSaveUrl#", "getSaveUrl(const KUrl&)", typeof(KUrl), typeof(KUrl), startDir);
		}
		public static KUrl GetSaveUrl() {
			return (KUrl) staticInterceptor.Invoke("getSaveUrl", "getSaveUrl()", typeof(KUrl));
		}
		/// <remarks>
		///  Creates a modal directory-selection dialog and returns the selected
		///  directory (local only) or an empty string if none was chosen.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		/// </param></remarks>		<return> the path to an existing local directory.
		///      </return>
		/// 		<short>    Creates a modal directory-selection dialog and returns the selected  directory (local only) or an empty string if none was chosen.</short>
		public static string GetExistingDirectory(KUrl startDir, QWidget parent, string caption) {
			return (string) staticInterceptor.Invoke("getExistingDirectory##$", "getExistingDirectory(const KUrl&, QWidget*, const QString&)", typeof(string), typeof(KUrl), startDir, typeof(QWidget), parent, typeof(string), caption);
		}
		public static string GetExistingDirectory(KUrl startDir, QWidget parent) {
			return (string) staticInterceptor.Invoke("getExistingDirectory##", "getExistingDirectory(const KUrl&, QWidget*)", typeof(string), typeof(KUrl), startDir, typeof(QWidget), parent);
		}
		public static string GetExistingDirectory(KUrl startDir) {
			return (string) staticInterceptor.Invoke("getExistingDirectory#", "getExistingDirectory(const KUrl&)", typeof(string), typeof(KUrl), startDir);
		}
		public static string GetExistingDirectory() {
			return (string) staticInterceptor.Invoke("getExistingDirectory", "getExistingDirectory()", typeof(string));
		}
		/// <remarks>
		///  Creates a modal directory-selection dialog and returns the selected
		///  directory or an empty string if none was chosen.
		///  This version supports remote urls.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		/// </param></remarks>		<return> the url to an existing directory (local or remote).
		///      </return>
		/// 		<short>    Creates a modal directory-selection dialog and returns the selected  directory or an empty string if none was chosen.</short>
		public static KUrl GetExistingDirectoryUrl(KUrl startDir, QWidget parent, string caption) {
			return (KUrl) staticInterceptor.Invoke("getExistingDirectoryUrl##$", "getExistingDirectoryUrl(const KUrl&, QWidget*, const QString&)", typeof(KUrl), typeof(KUrl), startDir, typeof(QWidget), parent, typeof(string), caption);
		}
		public static KUrl GetExistingDirectoryUrl(KUrl startDir, QWidget parent) {
			return (KUrl) staticInterceptor.Invoke("getExistingDirectoryUrl##", "getExistingDirectoryUrl(const KUrl&, QWidget*)", typeof(KUrl), typeof(KUrl), startDir, typeof(QWidget), parent);
		}
		public static KUrl GetExistingDirectoryUrl(KUrl startDir) {
			return (KUrl) staticInterceptor.Invoke("getExistingDirectoryUrl#", "getExistingDirectoryUrl(const KUrl&)", typeof(KUrl), typeof(KUrl), startDir);
		}
		public static KUrl GetExistingDirectoryUrl() {
			return (KUrl) staticInterceptor.Invoke("getExistingDirectoryUrl", "getExistingDirectoryUrl()", typeof(KUrl));
		}
		/// <remarks>
		///  Creates a modal file dialog with an image previewer and returns the
		///  selected url or an empty string if none was chosen.
		/// <param> name="startDir" This can either be
		/// </param>
		/// <li>
		/// The URL of the directory to start in.
		/// </li>
		/// 
		/// <li>
		/// A KUrl() to start in the current working
		///              directory, or the last directory where a file has been
		///              selected.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;' to start in the
		///              directory last used by a filedialog in the same application that specified
		///              the same keyword.
		/// </li>
		/// 
		/// <li>
		/// An URL starting with 'kfiledialog:///&lt;keyword&gt;?global' to start
		///              in the directory last used by a filedialog in any application that specified the
		///              same keyword.
		/// </li>
		/// <param> name="parent" The widget the dialog will be centered on initially.
		/// </param><param> name="caption" The name of the dialog widget.
		///      </param></remarks>		<short>    Creates a modal file dialog with an image previewer and returns the  selected url or an empty string if none was chosen.</short>
		public static KUrl GetImageOpenUrl(KUrl startDir, QWidget parent, string caption) {
			return (KUrl) staticInterceptor.Invoke("getImageOpenUrl##$", "getImageOpenUrl(const KUrl&, QWidget*, const QString&)", typeof(KUrl), typeof(KUrl), startDir, typeof(QWidget), parent, typeof(string), caption);
		}
		public static KUrl GetImageOpenUrl(KUrl startDir, QWidget parent) {
			return (KUrl) staticInterceptor.Invoke("getImageOpenUrl##", "getImageOpenUrl(const KUrl&, QWidget*)", typeof(KUrl), typeof(KUrl), startDir, typeof(QWidget), parent);
		}
		public static KUrl GetImageOpenUrl(KUrl startDir) {
			return (KUrl) staticInterceptor.Invoke("getImageOpenUrl#", "getImageOpenUrl(const KUrl&)", typeof(KUrl), typeof(KUrl), startDir);
		}
		public static KUrl GetImageOpenUrl() {
			return (KUrl) staticInterceptor.Invoke("getImageOpenUrl", "getImageOpenUrl()", typeof(KUrl));
		}
		/// <remarks>
		///  This method implements the logic to determine the user's default directory
		///  to be listed. E.g. the documents directory, home directory or a recently
		///  used directory.
		/// <param> name="startDir" A url, to be used. May use the 'kfiledialog:///keyword' and
		///                  'kfiledialog:///keyword?global' syntax
		///                  as documented in the KFileDialog() constructor.
		/// </param><param> name="recentDirClass" If the 'kfiledialog:///' syntax is used, recentDirClass
		///         will contain the string to be used later for KRecentDir.Dir()
		/// </param></remarks>		<return> The URL that should be listed by default (e.g. by KFileDialog or
		///          KDirSelectDialog).
		///      </return>
		/// 		<short>    This method implements the logic to determine the user's default directory  to be listed.</short>
		public static KUrl GetStartUrl(KUrl startDir, StringBuilder recentDirClass) {
			return (KUrl) staticInterceptor.Invoke("getStartUrl#$", "getStartUrl(const KUrl&, QString&)", typeof(KUrl), typeof(KUrl), startDir, typeof(StringBuilder), recentDirClass);
		}
		/// <remarks>
		///  Used by KDirSelectDialog to share the dialog's start directory.
		///      </remarks>		<short>   </short>
		public static void SetStartDir(KUrl directory) {
			staticInterceptor.Invoke("setStartDir#", "setStartDir(const KUrl&)", typeof(void), typeof(KUrl), directory);
		}
		protected new IKFileDialogSignals Emit {
			get { return (IKFileDialogSignals) Q_EMIT; }
		}
	}

	public interface IKFileDialogSignals : IKDialogSignals {
		/// <remarks>
		///  Emitted when the user selects a file. It is only emitted in single-
		///  selection mode. The best way to get notified about selected file(s)
		///  is to connect to the okClicked() signal inherited from KDialog
		///  and call selectedFile(), selectedFiles(),
		///  selectedUrl() or selectedUrls().
		///       </remarks>		<short>    Emitted when the user selects a file.</short>
		[Q_SIGNAL("void fileSelected(const QString&)")]
		void FileSelected(string arg1);
		/// <remarks>
		///  Emitted when the user highlights a file.
		///       </remarks>		<short>    Emitted when the user highlights a file.</short>
		[Q_SIGNAL("void fileHighlighted(const QString&)")]
		void FileHighlighted(string arg1);
		/// <remarks>
		///  Emitted when the user hilights one or more files in multiselection mode.
		///  Note: fileHighlighted() or fileSelected() are <b>not</b>
		///  emitted in multiselection mode. You may use selectedItems() to
		///  ask for the current highlighted items.
		/// </remarks>		<short>    Emitted when the user hilights one or more files in multiselection mode.</short>
		/// 		<see> fileSelected</see>
		[Q_SIGNAL("void selectionChanged()")]
		void SelectionChanged();
		/// <remarks>
		///  Emitted when the filter changed, i.e. the user entered an own filter
		///  or chose one of the predefined set via setFilter().
		/// <param> name="filter" contains the new filter (only the extension part,
		///  not the explanation), i.e. "*.cpp" or "*.cpp .cc".
		/// </param></remarks>		<short>    Emitted when the filter changed, i.</short>
		/// 		<see> setFilter</see>
		/// 		<see> currentFilter</see>
		[Q_SIGNAL("void filterChanged(const QString&)")]
		void FilterChanged(string filter);
	}
}
