/*  This file is part of the KDE project
    Copyright (C) 2007 Kevin Ottens <ervin@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/
#ifndef KFILEPLACESITEM_P_H
#define KFILEPLACESITEM_P_H


#include <QtCore/QObject>
#include <QtCore/QModelIndex>
#include <kbookmark.h>
#include <solid/device.h>

class KFilePlacesItem : public QObject
{
    Q_OBJECT
public:
    KFilePlacesItem(KBookmarkManager *manager,
                    const QString &address,
                    const QString &udi = QString());
    ~KFilePlacesItem();

    QString id() const;

    bool isDevice() const;
    KBookmark bookmark() const;
    Solid::Device device() const;
    QVariant data(int role) const;

    static KBookmark createBookmark(KBookmarkManager *manager,
                                    const QString &label,
                                    const KUrl &url,
                                    const QString &iconName);
    static KBookmark createDeviceBookmark(KBookmarkManager *manager,
                                          const QString &udi);

Q_SIGNALS:
    void deviceChanged(const QString &udi);

private Q_SLOTS:
    void onAccessibilityChanged();

private:
    QVariant bookmarkData(int role) const;
    QVariant deviceData(int role) const;

    static QString generateNewId();

    KBookmarkManager *m_manager;
    KBookmark m_bookmark;
};

#endif
