#!/usr/bin/python
###########################################################################
# setup - description                                                     #
# ------------------------------                                          #
# begin     : Fri Jun 27 2003                                             #
# copyright : (C) 2003-2006 by Simon Edwards                              #
# email     : simon@simonzone.com                                         #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

from distutils.core import Extension
import kdedistutils

###########################################################################
def doit():
    kdedistutils.setup(name="guidance",
        version="0.8.0",
        author="Simon Edwards",
        author_email="simon@simonzone.com",
        url="http://www.simonzone.com/software/guidance/",
        min_kde_version = "3.0.0",
        min_qt_version = "3.0.0",
        license = "GPL",
        executable_links = [('serviceconfig','serviceconfig.py'),
            ('userconfig','userconfig.py'),
            ('mountconfig','mountconfig.py'),
            ('displayconfig','displayconfig.py'),
            ('displayconfig-restore','displayconfig-restore.py'),
	    ('wineconfig','wineconfig.py'),
	    ('grubconfig','grubconfig.py')],
            
        data_files = [# Icons for in KControl
                      ('share/icons/crystalsvg/16x16/apps',['kde/serviceconfig/pics/16x16/daemons.png',
                        'kde/mountconfig/pics/16x16/disksfilesystems.png',
                        'kde/userconfig/pics/16x16/userconfig.png',
                        'kde/displayconfig/pics/16x16/displayconfig.png',
			'kde/wineconfig/pics/16x16/wineconfig.svg']),
                      ('/etc/X11/Xsession.d',['displayconfig/40guidance-displayconfig_restore'])],

        i18n = ('po',['mountconfig','userconfig','serviceconfig','displayconfig','wineconfig','powermanager']),

        application_data = [('pics',
                                ['kde/serviceconfig/pics/laserwarn.png',
                                'kde/serviceconfig/pics/hi32-app-daemons.png',
                                'kde/userconfig/pics/hi16-encrypted.png',
                                'kde/userconfig/pics/hi32-user.png',
                                'kde/userconfig/pics/hi32-group.png',
                                'kde/userconfig/pics/hi32-identity.png',
                                'kde/userconfig/pics/hi32-password.png',
                                'kde/mountconfig/pics/kcmpartitions.png',
                                'kde/mountconfig/pics/kde1.png',
                                'kde/mountconfig/pics/kde2.png',
                                'kde/mountconfig/pics/kde3.png',
                                'kde/mountconfig/pics/kde4.png',
                                'kde/mountconfig/pics/kde5.png',
                                'kde/mountconfig/pics/kde6.png',
                                'kde/mountconfig/pics/hi32-samba.png',
                                'kde/mountconfig/pics/hi16-hdd.png',
                                'kde/mountconfig/pics/hi16-cdrom.png',
                                'kde/mountconfig/pics/hi16-burner.png',
                                'kde/mountconfig/pics/hi16-floppy.png',
                                'kde/mountconfig/pics/hi16-blockdevice.png',
                                'kde/mountconfig/pics/hi16-password.png',
                                'kde/mountconfig/pics/hi16-memory.png',
                                'kde/mountconfig/pics/hi16-network.png',
                                'kde/mountconfig/pics/hi16-lock.png',
                                'kde/mountconfig/pics/hi16-usbpen.png',
                                'kde/mountconfig/pics/greenled.png',
                                'kde/mountconfig/pics/greyled.png',
                                'kde/mountconfig/pics/exec.png',
                                'kde/mountconfig/pics/file.png',
                                'kde/mountconfig/pics/important.png',
                                'kde/mountconfig/pics/tux.png',
                                'kde/mountconfig/pics/user.png',
                                'kde/displayconfig/pics/energystar.png',
                                'kde/displayconfig/pics/hi32-gfxcard.png',
                                'kde/displayconfig/pics/hi32-display.png',
                                'kde/wineconfig/pics/32-wine.png',
                                'kde/wineconfig/pics/kdewinewizard.png',
                                'kde/powermanager/pics/ac-adapter.png',
                                'kde/powermanager/pics/ac-adapter.svg',
                                'kde/powermanager/pics/battery-charging-000.png',
                                'kde/powermanager/pics/battery-charging-010.png',
                                'kde/powermanager/pics/battery-charging-020.png',
                                'kde/powermanager/pics/battery-charging-030.png',
                                'kde/powermanager/pics/battery-charging-040.png',
                                'kde/powermanager/pics/battery-charging-050.png',
                                'kde/powermanager/pics/battery-charging-060.png',
                                'kde/powermanager/pics/battery-charging-070.png',
                                'kde/powermanager/pics/battery-charging-090.png',
                                'kde/powermanager/pics/battery_charging_0.svg',
                                'kde/powermanager/pics/battery-charging-100.png',
                                'kde/powermanager/pics/battery_charging_1.svg',
                                'kde/powermanager/pics/battery_charging_2.svg',
                                'kde/powermanager/pics/battery_charging_3.svg',
                                'kde/powermanager/pics/battery_charging_4.svg',
                                'kde/powermanager/pics/battery_charging_5.svg',
                                'kde/powermanager/pics/battery_charging_6.svg',
                                'kde/powermanager/pics/battery_charging_7.svg',
                                'kde/powermanager/pics/battery_charging_8.svg',
                                'kde/powermanager/pics/battery_charging_9.svg',
                                'kde/powermanager/pics/battery-discharging-000.png',
                                'kde/powermanager/pics/battery-discharging-010.png',
                                'kde/powermanager/pics/battery-discharging-020.png',
                                'kde/powermanager/pics/battery-discharging-020.svg',
                                'kde/powermanager/pics/battery-discharging-030.png',
                                'kde/powermanager/pics/battery-discharging-040.png',
                                'kde/powermanager/pics/battery-discharging-050.png',
                                'kde/powermanager/pics/battery-discharging-060.png',
                                'kde/powermanager/pics/battery-discharging-070.png',
                                'kde/powermanager/pics/battery-discharging-090.png',
                                'kde/powermanager/pics/battery_discharging_0.svg',
                                'kde/powermanager/pics/battery-discharging-100.png',
                                'kde/powermanager/pics/battery_discharging_1.svg',
                                'kde/powermanager/pics/battery_discharging_2.svg',
                                'kde/powermanager/pics/battery_discharging_3.svg',
                                'kde/powermanager/pics/battery_discharging_4.svg',
                                'kde/powermanager/pics/battery_discharging_5.svg',
                                'kde/powermanager/pics/battery_discharging_6.svg',
                                'kde/powermanager/pics/battery_discharging_7.svg',
                                'kde/powermanager/pics/battery_discharging_8.svg',
                                'kde/powermanager/pics/battery_discharging_9.svg',
                                'kde/powermanager/pics/processor.png',
                                'kde/powermanager/pics/processor.svg']),
                            ('pics/displayconfig/dualhead',
                                ['kde/displayconfig/pics/dualhead/monitor_1.png',
                                'kde/displayconfig/pics/dualhead/monitor_2.png']),
                            ('pics/displayconfig/monitor_resizable',
                                ['kde/displayconfig/pics/monitor_resizable/background.png',
                                'kde/displayconfig/pics/monitor_resizable/background_r90.png',
                                'kde/displayconfig/pics/monitor_resizable/background_wide.png',
                                'kde/displayconfig/pics/monitor_resizable/background_wide_r90.png',
                                'kde/displayconfig/pics/monitor_resizable/monitor.png',
                                'kde/displayconfig/pics/monitor_resizable/monitor_r90.png',
                                'kde/displayconfig/pics/monitor_resizable/monitor_wide.png',
                                'kde/displayconfig/pics/monitor_resizable/monitor_wide_r90.png',
                                'kde/displayconfig/pics/monitor_resizable/window_4th.png',
                                'kde/displayconfig/pics/monitor_resizable/window_bottom_left_4th.png',
                                'kde/displayconfig/pics/monitor_resizable/window_bottom_right_4th.png']),
                            ('pics/displayconfig/gammapics',
                                ['kde/displayconfig/pics/gammapics/MGam14.png',
                                'kde/displayconfig/pics/gammapics/MGam16.png',
                                'kde/displayconfig/pics/gammapics/MGam18.png',
                                'kde/displayconfig/pics/gammapics/MGam20.png',
                                'kde/displayconfig/pics/gammapics/MGam22.png',
                                'kde/displayconfig/pics/gammapics/MGam24.png']),
                            'serviceconfig/serviceconfig.py',
                            'userconfig/userconfig.py',
                            'userconfig/unixauthdb.py',
                            'mountconfig/mountconfig.py',
                            'mountconfig/MicroHAL.py',
                            'mountconfig/SMBShareSelectDialog.py',
                            'mountconfig/SimpleCommandRunner.py',
                            'mountconfig/fuser.py',
                            'mountconfig/fuser_ui.ui',
                            'mountconfig/sizeview.py',
                            'displayconfig/displayconfig.py',
                            'displayconfig/displayconfigabstraction.py',
                            'displayconfig/displayconfigwidgets.py',
                            'displayconfig/displayconfig-restore.py',
                            'displayconfig/execwithcapture.py',
                            'displayconfig/infimport.py',
                            'displayconfig/ScanPCI.py',
                            'displayconfig/ktimerdialog.py',
                            'displayconfig/servertestdialog.py',
                            'displayconfig/xorgconfig.py',
                            'displayconfig/vesamodes',
                            'displayconfig/extramodes',
                            'displayconfig/widescreenmodes',
                            'displayconfig/ldetect-lst/Cards+',
                            'displayconfig/ldetect-lst/MonitorsDB',
                            'displayconfig/ldetect-lst/pcitable',
			    'wineconfig/wineconfig.py',
			    'wineconfig/wineread.py',
			    'wineconfig/winewrite.py',
                            'wineconfig/drivedetect.py',
                            'powermanager/guidance-power-manager.py',
                            'powermanager/powermanage.py',
                            'powermanager/guidance_power_manager_ui.ui',
                            'powermanager/powermanager_ui.ui',
                            'grubconfig/grubconfig.py'],
                  
        kcontrol_modules = [ \
            ('serviceconfig/serviceconfig.desktop','serviceconfig.py'),
            ('userconfig/userconfig.desktop','userconfig.py'),
            ('mountconfig/mountconfig.desktop','mountconfig.py'),
            ('displayconfig/displayconfig.desktop','displayconfig.py'),
	    ('wineconfig/wineconfig.desktop','wineconfig.py')],

        docbooks = [ ('doc/en','en') ],

        package_dir={'':'modules'},
        py_modules=['xf86misc'],
        ext_modules=[\
            Extension('ixf86misc',\
                sources=['modules/ixf86misc.c'],\
                library_dirs=['/usr/X11R6/lib'],\
                libraries=['X11','Xxf86vm','Xext','Xrandr','Xrender','Xss'])]
        )
doit()
