Captures and holds incoming TCP connections using no local
per-connection resources. Connections are accepted, but immediately
switched to the persist state (0 byte window), in which the remote
side stops sending data and asks to continue every 60-240 seconds.
Attempts to close the connection are ignored, forcing the remote side
to time out the connection in 12-24 minutes.

(Please note: This target requires kernel support that
might not be available in official Linux kernel sources or
Debian's packaged Linux kernel sources.
And if support for this target is available for the 
specific Linux kernel source version, that support might 
not be enabled in the current Linux kernel binary.)

This offers similar functionality to LaBrea
<http://www.hackbusters.net/LaBrea/> but doesn't require dedicated
hardware or IPs. Any TCP port that you would normally DROP or REJECT
can instead become a tarpit.

To tarpit connections to TCP port 80 destined for the current machine:
.IP
iptables -A INPUT -p tcp -m tcp --dport 80 -j TARPIT
.P
To significantly slow down Code Red/Nimda-style scans of unused address
space, forward unused ip addresses to a Linux box not acting as a router
(e.g. "ip route 10.0.0.0 255.0.0.0 ip.of.linux.box" on a Cisco), enable IP
forwarding on the Linux box, and add:
.IP
iptables -A FORWARD -p tcp -j TARPIT
.IP
iptables -A FORWARD -j DROP
.TP
NOTE:
If you use the conntrack module while you are using TARPIT, you should
also use the NOTRACK target, or the kernel will unnecessarily allocate
resources for each TARPITted connection. To TARPIT incoming
connections to the standard IRC port while using conntrack, you could:
.IP
iptables -t raw -A PREROUTING -p tcp --dport 6667 -j NOTRACK
.IP
iptables -A INPUT -p tcp --dport 6667 -j TARPIT
