/* mpris2-interfaces.c generated by valac 0.12.0, the Vala compiler
 * generated from mpris2-interfaces.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.
Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_MPRIS_ROOT (mpris_root_get_type ())
#define MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_ROOT, MprisRoot))
#define IS_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_ROOT))
#define MPRIS_ROOT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_ROOT, MprisRootIface))

typedef struct _MprisRoot MprisRoot;
typedef struct _MprisRootIface MprisRootIface;

#define TYPE_MPRIS_ROOT_PROXY (mpris_root_proxy_get_type ())
typedef GDBusProxy MprisRootProxy;
typedef GDBusProxyClass MprisRootProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MPRIS_PLAYER (mpris_player_get_type ())
#define MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_PLAYER, MprisPlayer))
#define IS_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_PLAYER))
#define MPRIS_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_PLAYER, MprisPlayerIface))

typedef struct _MprisPlayer MprisPlayer;
typedef struct _MprisPlayerIface MprisPlayerIface;

#define TYPE_MPRIS_PLAYER_PROXY (mpris_player_proxy_get_type ())
typedef GDBusProxy MprisPlayerProxy;
typedef GDBusProxyClass MprisPlayerProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_PLAYLIST_DETAILS (playlist_details_get_type ())
typedef struct _PlaylistDetails PlaylistDetails;

#define TYPE_ACTIVE_PLAYLIST_CONTAINER (active_playlist_container_get_type ())
typedef struct _ActivePlaylistContainer ActivePlaylistContainer;

#define TYPE_MPRIS_PLAYLISTS (mpris_playlists_get_type ())
#define MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_PLAYLISTS, MprisPlaylists))
#define IS_MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_PLAYLISTS))
#define MPRIS_PLAYLISTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_PLAYLISTS, MprisPlaylistsIface))

typedef struct _MprisPlaylists MprisPlaylists;
typedef struct _MprisPlaylistsIface MprisPlaylistsIface;

#define TYPE_MPRIS_PLAYLISTS_PROXY (mpris_playlists_proxy_get_type ())
typedef GDBusProxy MprisPlaylistsProxy;
typedef GDBusProxyClass MprisPlaylistsProxyClass;

struct _MprisRootIface {
	GTypeInterface parent_iface;
	void (*Quit) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Quit_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	void (*Raise) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Raise_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_HasTracklist) (MprisRoot* self);
	void (*set_HasTracklist) (MprisRoot* self, gboolean value);
	gboolean (*get_CanQuit) (MprisRoot* self);
	void (*set_CanQuit) (MprisRoot* self, gboolean value);
	gboolean (*get_CanRaise) (MprisRoot* self);
	void (*set_CanRaise) (MprisRoot* self, gboolean value);
	gchar* (*get_Identity) (MprisRoot* self);
	void (*set_Identity) (MprisRoot* self, const gchar* value);
	gchar* (*get_DesktopEntry) (MprisRoot* self);
	void (*set_DesktopEntry) (MprisRoot* self, const gchar* value);
};

struct _MprisPlayerIface {
	GTypeInterface parent_iface;
	void (*PlayPause) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*PlayPause_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Next) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Next_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Previous) (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Previous_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	void (*Seek) (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Seek_finish) (MprisPlayer* self, GAsyncResult* _res_, GError** error);
	GHashTable* (*get_Metadata) (MprisPlayer* self);
	void (*set_Metadata) (MprisPlayer* self, GHashTable* value);
	gint32 (*get_Position) (MprisPlayer* self);
	void (*set_Position) (MprisPlayer* self, gint32 value);
	gchar* (*get_PlaybackStatus) (MprisPlayer* self);
	void (*set_PlaybackStatus) (MprisPlayer* self, const gchar* value);
};

struct _PlaylistDetails {
	char* path;
	gchar* name;
	gchar* icon_path;
};

struct _ActivePlaylistContainer {
	gboolean valid;
	PlaylistDetails details;
};

struct _MprisPlaylistsIface {
	GTypeInterface parent_iface;
	void (*ActivatePlaylist) (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ActivatePlaylist_finish) (MprisPlaylists* self, GAsyncResult* _res_, GError** error);
	void (*GetPlaylists) (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
	PlaylistDetails* (*GetPlaylists_finish) (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
	gchar** (*get_Orderings) (MprisPlaylists* self, int* result_length1);
	void (*set_Orderings) (MprisPlaylists* self, gchar** value, int value_length1);
	guint32 (*get_PlaylistCount) (MprisPlaylists* self);
	void (*set_PlaylistCount) (MprisPlaylists* self, guint32 value);
	void (*get_ActivePlaylist) (MprisPlaylists* self, ActivePlaylistContainer* value);
	void (*set_ActivePlaylist) (MprisPlaylists* self, ActivePlaylistContainer* value);
};



#define MPRIS_PREFIX "org.mpris.MediaPlayer2."
#define MPRIS_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
GType mpris_root_proxy_get_type (void) G_GNUC_CONST;
guint mpris_root_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_root_get_type (void) G_GNUC_CONST;
void mpris_root_Quit (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_root_Quit_finish (MprisRoot* self, GAsyncResult* _res_, GError** error);
void mpris_root_Raise (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_root_Raise_finish (MprisRoot* self, GAsyncResult* _res_, GError** error);
gboolean mpris_root_get_HasTracklist (MprisRoot* self);
void mpris_root_set_HasTracklist (MprisRoot* self, gboolean value);
gboolean mpris_root_get_CanQuit (MprisRoot* self);
void mpris_root_set_CanQuit (MprisRoot* self, gboolean value);
gboolean mpris_root_get_CanRaise (MprisRoot* self);
void mpris_root_set_CanRaise (MprisRoot* self, gboolean value);
gchar* mpris_root_get_Identity (MprisRoot* self);
void mpris_root_set_Identity (MprisRoot* self, const gchar* value);
gchar* mpris_root_get_DesktopEntry (MprisRoot* self);
void mpris_root_set_DesktopEntry (MprisRoot* self, const gchar* value);
static void mpris_root_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void mpris_root_proxy_Quit_async (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_root_proxy_Quit_finish (MprisRoot* self, GAsyncResult* _res_, GError** error);
static void mpris_root_proxy_Raise_async (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_root_proxy_Raise_finish (MprisRoot* self, GAsyncResult* _res_, GError** error);
static gboolean mpris_root_dbus_proxy_get_HasTracklist (MprisRoot* self);
static void mpris_root_dbus_proxy_set_HasTracklist (MprisRoot* self, gboolean value);
static gboolean mpris_root_dbus_proxy_get_CanQuit (MprisRoot* self);
static void mpris_root_dbus_proxy_set_CanQuit (MprisRoot* self, gboolean value);
static gboolean mpris_root_dbus_proxy_get_CanRaise (MprisRoot* self);
static void mpris_root_dbus_proxy_set_CanRaise (MprisRoot* self, gboolean value);
static gchar* mpris_root_dbus_proxy_get_Identity (MprisRoot* self);
static void mpris_root_dbus_proxy_set_Identity (MprisRoot* self, const gchar* value);
static gchar* mpris_root_dbus_proxy_get_DesktopEntry (MprisRoot* self);
static void mpris_root_dbus_proxy_set_DesktopEntry (MprisRoot* self, const gchar* value);
static void mpris_root_proxy_mpris_root_interface_init (MprisRootIface* iface);
static void _dbus_mpris_root_Quit (MprisRoot* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_mpris_root_Quit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_mpris_root_Raise (MprisRoot* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_mpris_root_Raise_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void mpris_root_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* mpris_root_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_mpris_root_get_HasTracklist (MprisRoot* self);
static GVariant* _dbus_mpris_root_get_CanQuit (MprisRoot* self);
static GVariant* _dbus_mpris_root_get_CanRaise (MprisRoot* self);
static GVariant* _dbus_mpris_root_get_Identity (MprisRoot* self);
static GVariant* _dbus_mpris_root_get_DesktopEntry (MprisRoot* self);
static gboolean mpris_root_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_mpris_root_set_HasTracklist (MprisRoot* self, GVariant* _value);
static void _dbus_mpris_root_set_CanQuit (MprisRoot* self, GVariant* _value);
static void _dbus_mpris_root_set_CanRaise (MprisRoot* self, GVariant* _value);
static void _dbus_mpris_root_set_Identity (MprisRoot* self, GVariant* _value);
static void _dbus_mpris_root_set_DesktopEntry (MprisRoot* self, GVariant* _value);
static void _mpris_root_unregister_object (gpointer user_data);
GType mpris_player_proxy_get_type (void) G_GNUC_CONST;
guint mpris_player_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_player_get_type (void) G_GNUC_CONST;
void mpris_player_PlayPause (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_PlayPause_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Next (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Next_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Previous (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Previous_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
void mpris_player_Seek (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_player_Seek_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
GHashTable* mpris_player_get_Metadata (MprisPlayer* self);
void mpris_player_set_Metadata (MprisPlayer* self, GHashTable* value);
gint32 mpris_player_get_Position (MprisPlayer* self);
void mpris_player_set_Position (MprisPlayer* self, gint32 value);
gchar* mpris_player_get_PlaybackStatus (MprisPlayer* self);
void mpris_player_set_PlaybackStatus (MprisPlayer* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void mpris_player_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_mpris_player_seeked (MprisPlayer* self, GVariant* parameters);
static void mpris_player_proxy_PlayPause_async (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_player_proxy_PlayPause_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
static void mpris_player_proxy_Next_async (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_player_proxy_Next_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
static void mpris_player_proxy_Previous_async (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_player_proxy_Previous_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
static void mpris_player_proxy_Seek_async (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_player_proxy_Seek_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error);
static GHashTable* mpris_player_dbus_proxy_get_Metadata (MprisPlayer* self);
static void mpris_player_dbus_proxy_set_Metadata (MprisPlayer* self, GHashTable* value);
static gint32 mpris_player_dbus_proxy_get_Position (MprisPlayer* self);
static void mpris_player_dbus_proxy_set_Position (MprisPlayer* self, gint32 value);
static gchar* mpris_player_dbus_proxy_get_PlaybackStatus (MprisPlayer* self);
static void mpris_player_dbus_proxy_set_PlaybackStatus (MprisPlayer* self, const gchar* value);
static void mpris_player_proxy_mpris_player_interface_init (MprisPlayerIface* iface);
static void _dbus_mpris_player_PlayPause (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_mpris_player_PlayPause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_mpris_player_Next (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_mpris_player_Next_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_mpris_player_Previous (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_mpris_player_Previous_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_mpris_player_Seek (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_mpris_player_Seek_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void mpris_player_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* mpris_player_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_mpris_player_get_Metadata (MprisPlayer* self);
static GVariant* _dbus_mpris_player_get_Position (MprisPlayer* self);
static GVariant* _dbus_mpris_player_get_PlaybackStatus (MprisPlayer* self);
static gboolean mpris_player_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_mpris_player_set_Metadata (MprisPlayer* self, GVariant* _value);
static void _dbus_mpris_player_set_Position (MprisPlayer* self, GVariant* _value);
static void _dbus_mpris_player_set_PlaybackStatus (MprisPlayer* self, GVariant* _value);
static void _dbus_mpris_player_seeked (GObject* _sender, gint64 new_position, gpointer* _data);
static void _mpris_player_unregister_object (gpointer user_data);
GType playlist_details_get_type (void) G_GNUC_CONST;
PlaylistDetails* playlist_details_dup (const PlaylistDetails* self);
void playlist_details_free (PlaylistDetails* self);
void playlist_details_copy (const PlaylistDetails* self, PlaylistDetails* dest);
void playlist_details_destroy (PlaylistDetails* self);
GType active_playlist_container_get_type (void) G_GNUC_CONST;
ActivePlaylistContainer* active_playlist_container_dup (const ActivePlaylistContainer* self);
void active_playlist_container_free (ActivePlaylistContainer* self);
void active_playlist_container_copy (const ActivePlaylistContainer* self, ActivePlaylistContainer* dest);
void active_playlist_container_destroy (ActivePlaylistContainer* self);
GType mpris_playlists_proxy_get_type (void) G_GNUC_CONST;
guint mpris_playlists_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_playlists_get_type (void) G_GNUC_CONST;
void mpris_playlists_ActivatePlaylist (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_playlists_ActivatePlaylist_finish (MprisPlaylists* self, GAsyncResult* _res_, GError** error);
void mpris_playlists_GetPlaylists (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
PlaylistDetails* mpris_playlists_GetPlaylists_finish (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
gchar** mpris_playlists_get_Orderings (MprisPlaylists* self, int* result_length1);
void mpris_playlists_set_Orderings (MprisPlaylists* self, gchar** value, int value_length1);
guint32 mpris_playlists_get_PlaylistCount (MprisPlaylists* self);
void mpris_playlists_set_PlaylistCount (MprisPlaylists* self, guint32 value);
void mpris_playlists_get_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* result);
void mpris_playlists_set_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* value);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void mpris_playlists_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_mpris_playlists_playlist_changed (MprisPlaylists* self, GVariant* parameters);
static void mpris_playlists_proxy_ActivatePlaylist_async (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_playlists_proxy_ActivatePlaylist_finish (MprisPlaylists* self, GAsyncResult* _res_, GError** error);
static void mpris_playlists_proxy_GetPlaylists_async (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
static PlaylistDetails* mpris_playlists_proxy_GetPlaylists_finish (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gchar** mpris_playlists_dbus_proxy_get_Orderings (MprisPlaylists* self, int* result_length1);
static void mpris_playlists_dbus_proxy_set_Orderings (MprisPlaylists* self, gchar** value, int value_length1);
static guint32 mpris_playlists_dbus_proxy_get_PlaylistCount (MprisPlaylists* self);
static void mpris_playlists_dbus_proxy_set_PlaylistCount (MprisPlaylists* self, guint32 value);
static void mpris_playlists_dbus_proxy_get_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* result);
static void mpris_playlists_dbus_proxy_set_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* value);
static void mpris_playlists_proxy_mpris_playlists_interface_init (MprisPlaylistsIface* iface);
static void _dbus_mpris_playlists_ActivatePlaylist (MprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_mpris_playlists_ActivatePlaylist_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_mpris_playlists_GetPlaylists (MprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _vala_PlaylistDetails_array_free (PlaylistDetails* array, gint array_length);
static void _dbus_mpris_playlists_GetPlaylists_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void mpris_playlists_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* mpris_playlists_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_mpris_playlists_get_Orderings (MprisPlaylists* self);
static GVariant* _dbus_mpris_playlists_get_PlaylistCount (MprisPlaylists* self);
static GVariant* _dbus_mpris_playlists_get_ActivePlaylist (MprisPlaylists* self);
static gboolean mpris_playlists_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_mpris_playlists_set_Orderings (MprisPlaylists* self, GVariant* _value);
static void _dbus_mpris_playlists_set_PlaylistCount (MprisPlaylists* self, GVariant* _value);
static void _dbus_mpris_playlists_set_ActivePlaylist (MprisPlaylists* self, GVariant* _value);
static void _dbus_mpris_playlists_playlist_changed (GObject* _sender, PlaylistDetails* details, gpointer* _data);
static void _mpris_playlists_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo * const _mpris_root_dbus_arg_info_Quit_in[] = {NULL};
static const GDBusArgInfo * const _mpris_root_dbus_arg_info_Quit_out[] = {NULL};
static const GDBusMethodInfo _mpris_root_dbus_method_info_Quit = {-1, "Quit", (GDBusArgInfo **) (&_mpris_root_dbus_arg_info_Quit_in), (GDBusArgInfo **) (&_mpris_root_dbus_arg_info_Quit_out)};
static const GDBusArgInfo * const _mpris_root_dbus_arg_info_Raise_in[] = {NULL};
static const GDBusArgInfo * const _mpris_root_dbus_arg_info_Raise_out[] = {NULL};
static const GDBusMethodInfo _mpris_root_dbus_method_info_Raise = {-1, "Raise", (GDBusArgInfo **) (&_mpris_root_dbus_arg_info_Raise_in), (GDBusArgInfo **) (&_mpris_root_dbus_arg_info_Raise_out)};
static const GDBusMethodInfo * const _mpris_root_dbus_method_info[] = {&_mpris_root_dbus_method_info_Quit, &_mpris_root_dbus_method_info_Raise, NULL};
static const GDBusSignalInfo * const _mpris_root_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _mpris_root_dbus_property_info_HasTracklist = {-1, "HasTracklist", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_root_dbus_property_info_CanQuit = {-1, "CanQuit", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_root_dbus_property_info_CanRaise = {-1, "CanRaise", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_root_dbus_property_info_Identity = {-1, "Identity", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_root_dbus_property_info_DesktopEntry = {-1, "DesktopEntry", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _mpris_root_dbus_property_info[] = {&_mpris_root_dbus_property_info_HasTracklist, &_mpris_root_dbus_property_info_CanQuit, &_mpris_root_dbus_property_info_CanRaise, &_mpris_root_dbus_property_info_Identity, &_mpris_root_dbus_property_info_DesktopEntry, NULL};
static const GDBusInterfaceInfo _mpris_root_dbus_interface_info = {-1, "org.mpris.MediaPlayer2", (GDBusMethodInfo **) (&_mpris_root_dbus_method_info), (GDBusSignalInfo **) (&_mpris_root_dbus_signal_info), (GDBusPropertyInfo **) (&_mpris_root_dbus_property_info)};
static const GDBusInterfaceVTable _mpris_root_dbus_interface_vtable = {mpris_root_dbus_interface_method_call, mpris_root_dbus_interface_get_property, mpris_root_dbus_interface_set_property};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_PlayPause_in[] = {NULL};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_PlayPause_out[] = {NULL};
static const GDBusMethodInfo _mpris_player_dbus_method_info_PlayPause = {-1, "PlayPause", (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_PlayPause_in), (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_PlayPause_out)};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_Next_in[] = {NULL};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_Next_out[] = {NULL};
static const GDBusMethodInfo _mpris_player_dbus_method_info_Next = {-1, "Next", (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_Next_in), (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_Next_out)};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_Previous_in[] = {NULL};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_Previous_out[] = {NULL};
static const GDBusMethodInfo _mpris_player_dbus_method_info_Previous = {-1, "Previous", (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_Previous_in), (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_Previous_out)};
static const GDBusArgInfo _mpris_player_dbus_arg_info_Seek_offset = {-1, "offset", "x"};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_Seek_in[] = {&_mpris_player_dbus_arg_info_Seek_offset, NULL};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_Seek_out[] = {NULL};
static const GDBusMethodInfo _mpris_player_dbus_method_info_Seek = {-1, "Seek", (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_Seek_in), (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_Seek_out)};
static const GDBusMethodInfo * const _mpris_player_dbus_method_info[] = {&_mpris_player_dbus_method_info_PlayPause, &_mpris_player_dbus_method_info_Next, &_mpris_player_dbus_method_info_Previous, &_mpris_player_dbus_method_info_Seek, NULL};
static const GDBusArgInfo _mpris_player_dbus_arg_info_seeked_new_position = {-1, "new_position", "x"};
static const GDBusArgInfo * const _mpris_player_dbus_arg_info_seeked[] = {&_mpris_player_dbus_arg_info_seeked_new_position, NULL};
static const GDBusSignalInfo _mpris_player_dbus_signal_info_seeked = {-1, "Seeked", (GDBusArgInfo **) (&_mpris_player_dbus_arg_info_seeked)};
static const GDBusSignalInfo * const _mpris_player_dbus_signal_info[] = {&_mpris_player_dbus_signal_info_seeked, NULL};
static const GDBusPropertyInfo _mpris_player_dbus_property_info_Metadata = {-1, "Metadata", "a{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_player_dbus_property_info_Position = {-1, "Position", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_player_dbus_property_info_PlaybackStatus = {-1, "PlaybackStatus", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _mpris_player_dbus_property_info[] = {&_mpris_player_dbus_property_info_Metadata, &_mpris_player_dbus_property_info_Position, &_mpris_player_dbus_property_info_PlaybackStatus, NULL};
static const GDBusInterfaceInfo _mpris_player_dbus_interface_info = {-1, "org.mpris.MediaPlayer2.Player", (GDBusMethodInfo **) (&_mpris_player_dbus_method_info), (GDBusSignalInfo **) (&_mpris_player_dbus_signal_info), (GDBusPropertyInfo **) (&_mpris_player_dbus_property_info)};
static const GDBusInterfaceVTable _mpris_player_dbus_interface_vtable = {mpris_player_dbus_interface_method_call, mpris_player_dbus_interface_get_property, mpris_player_dbus_interface_set_property};
static const GDBusArgInfo _mpris_playlists_dbus_arg_info_ActivatePlaylist_playlist_id = {-1, "playlist_id", "o"};
static const GDBusArgInfo * const _mpris_playlists_dbus_arg_info_ActivatePlaylist_in[] = {&_mpris_playlists_dbus_arg_info_ActivatePlaylist_playlist_id, NULL};
static const GDBusArgInfo * const _mpris_playlists_dbus_arg_info_ActivatePlaylist_out[] = {NULL};
static const GDBusMethodInfo _mpris_playlists_dbus_method_info_ActivatePlaylist = {-1, "ActivatePlaylist", (GDBusArgInfo **) (&_mpris_playlists_dbus_arg_info_ActivatePlaylist_in), (GDBusArgInfo **) (&_mpris_playlists_dbus_arg_info_ActivatePlaylist_out)};
static const GDBusArgInfo _mpris_playlists_dbus_arg_info_GetPlaylists_index = {-1, "index", "u"};
static const GDBusArgInfo _mpris_playlists_dbus_arg_info_GetPlaylists_max_count = {-1, "max_count", "u"};
static const GDBusArgInfo _mpris_playlists_dbus_arg_info_GetPlaylists_order = {-1, "order", "s"};
static const GDBusArgInfo _mpris_playlists_dbus_arg_info_GetPlaylists_reverse_order = {-1, "reverse_order", "b"};
static const GDBusArgInfo _mpris_playlists_dbus_arg_info_GetPlaylists_result = {-1, "result", "a(oss)"};
static const GDBusArgInfo * const _mpris_playlists_dbus_arg_info_GetPlaylists_in[] = {&_mpris_playlists_dbus_arg_info_GetPlaylists_index, &_mpris_playlists_dbus_arg_info_GetPlaylists_max_count, &_mpris_playlists_dbus_arg_info_GetPlaylists_order, &_mpris_playlists_dbus_arg_info_GetPlaylists_reverse_order, NULL};
static const GDBusArgInfo * const _mpris_playlists_dbus_arg_info_GetPlaylists_out[] = {&_mpris_playlists_dbus_arg_info_GetPlaylists_result, NULL};
static const GDBusMethodInfo _mpris_playlists_dbus_method_info_GetPlaylists = {-1, "GetPlaylists", (GDBusArgInfo **) (&_mpris_playlists_dbus_arg_info_GetPlaylists_in), (GDBusArgInfo **) (&_mpris_playlists_dbus_arg_info_GetPlaylists_out)};
static const GDBusMethodInfo * const _mpris_playlists_dbus_method_info[] = {&_mpris_playlists_dbus_method_info_ActivatePlaylist, &_mpris_playlists_dbus_method_info_GetPlaylists, NULL};
static const GDBusArgInfo _mpris_playlists_dbus_arg_info_playlist_changed_details = {-1, "details", "(oss)"};
static const GDBusArgInfo * const _mpris_playlists_dbus_arg_info_playlist_changed[] = {&_mpris_playlists_dbus_arg_info_playlist_changed_details, NULL};
static const GDBusSignalInfo _mpris_playlists_dbus_signal_info_playlist_changed = {-1, "PlaylistChanged", (GDBusArgInfo **) (&_mpris_playlists_dbus_arg_info_playlist_changed)};
static const GDBusSignalInfo * const _mpris_playlists_dbus_signal_info[] = {&_mpris_playlists_dbus_signal_info_playlist_changed, NULL};
static const GDBusPropertyInfo _mpris_playlists_dbus_property_info_Orderings = {-1, "Orderings", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_playlists_dbus_property_info_PlaylistCount = {-1, "PlaylistCount", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_playlists_dbus_property_info_ActivePlaylist = {-1, "ActivePlaylist", "(b(oss))", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _mpris_playlists_dbus_property_info[] = {&_mpris_playlists_dbus_property_info_Orderings, &_mpris_playlists_dbus_property_info_PlaylistCount, &_mpris_playlists_dbus_property_info_ActivePlaylist, NULL};
static const GDBusInterfaceInfo _mpris_playlists_dbus_interface_info = {-1, "org.mpris.MediaPlayer2.Playlists", (GDBusMethodInfo **) (&_mpris_playlists_dbus_method_info), (GDBusSignalInfo **) (&_mpris_playlists_dbus_signal_info), (GDBusPropertyInfo **) (&_mpris_playlists_dbus_property_info)};
static const GDBusInterfaceVTable _mpris_playlists_dbus_interface_vtable = {mpris_playlists_dbus_interface_method_call, mpris_playlists_dbus_interface_get_property, mpris_playlists_dbus_interface_set_property};

void mpris_root_Quit (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_ROOT_GET_INTERFACE (self)->Quit (self, _callback_, _user_data_);
}


void mpris_root_Quit_finish (MprisRoot* self, GAsyncResult* _res_, GError** error) {
	MPRIS_ROOT_GET_INTERFACE (self)->Quit_finish (self, _res_, error);
}


void mpris_root_Raise (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_ROOT_GET_INTERFACE (self)->Raise (self, _callback_, _user_data_);
}


void mpris_root_Raise_finish (MprisRoot* self, GAsyncResult* _res_, GError** error) {
	MPRIS_ROOT_GET_INTERFACE (self)->Raise_finish (self, _res_, error);
}


gboolean mpris_root_get_HasTracklist (MprisRoot* self) {
	return MPRIS_ROOT_GET_INTERFACE (self)->get_HasTracklist (self);
}


void mpris_root_set_HasTracklist (MprisRoot* self, gboolean value) {
	MPRIS_ROOT_GET_INTERFACE (self)->set_HasTracklist (self, value);
}


gboolean mpris_root_get_CanQuit (MprisRoot* self) {
	return MPRIS_ROOT_GET_INTERFACE (self)->get_CanQuit (self);
}


void mpris_root_set_CanQuit (MprisRoot* self, gboolean value) {
	MPRIS_ROOT_GET_INTERFACE (self)->set_CanQuit (self, value);
}


gboolean mpris_root_get_CanRaise (MprisRoot* self) {
	return MPRIS_ROOT_GET_INTERFACE (self)->get_CanRaise (self);
}


void mpris_root_set_CanRaise (MprisRoot* self, gboolean value) {
	MPRIS_ROOT_GET_INTERFACE (self)->set_CanRaise (self, value);
}


gchar* mpris_root_get_Identity (MprisRoot* self) {
	return MPRIS_ROOT_GET_INTERFACE (self)->get_Identity (self);
}


void mpris_root_set_Identity (MprisRoot* self, const gchar* value) {
	MPRIS_ROOT_GET_INTERFACE (self)->set_Identity (self, value);
}


gchar* mpris_root_get_DesktopEntry (MprisRoot* self) {
	return MPRIS_ROOT_GET_INTERFACE (self)->get_DesktopEntry (self);
}


void mpris_root_set_DesktopEntry (MprisRoot* self, const gchar* value) {
	MPRIS_ROOT_GET_INTERFACE (self)->set_DesktopEntry (self, value);
}


static void mpris_root_base_init (MprisRootIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType mpris_root_get_type (void) {
	static volatile gsize mpris_root_type_id__volatile = 0;
	if (g_once_init_enter (&mpris_root_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MprisRootIface), (GBaseInitFunc) mpris_root_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType mpris_root_type_id;
		mpris_root_type_id = g_type_register_static (G_TYPE_INTERFACE, "MprisRoot", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (mpris_root_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (mpris_root_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) mpris_root_proxy_get_type);
		g_type_set_qdata (mpris_root_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.mpris.MediaPlayer2");
		g_type_set_qdata (mpris_root_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) mpris_root_register_object);
		g_once_init_leave (&mpris_root_type_id__volatile, mpris_root_type_id);
	}
	return mpris_root_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MprisRootProxy, mpris_root_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MPRIS_ROOT, mpris_root_proxy_mpris_root_interface_init) )
static void mpris_root_proxy_class_init (MprisRootProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = mpris_root_proxy_g_signal;
}


static void mpris_root_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void mpris_root_proxy_init (MprisRootProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void mpris_root_proxy_Quit_async (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2", "Quit");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_root_proxy_Quit_finish (MprisRoot* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void mpris_root_proxy_Raise_async (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2", "Raise");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_root_proxy_Raise_finish (MprisRoot* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gboolean mpris_root_dbus_proxy_get_HasTracklist (MprisRoot* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "HasTracklist");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasTracklist"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_root_dbus_proxy_set_HasTracklist (MprisRoot* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasTracklist"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gboolean mpris_root_dbus_proxy_get_CanQuit (MprisRoot* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanQuit");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanQuit"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_root_dbus_proxy_set_CanQuit (MprisRoot* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanQuit"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gboolean mpris_root_dbus_proxy_get_CanRaise (MprisRoot* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanRaise");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanRaise"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_root_dbus_proxy_set_CanRaise (MprisRoot* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanRaise"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gchar* mpris_root_dbus_proxy_get_Identity (MprisRoot* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Identity");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Identity"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_root_dbus_proxy_set_Identity (MprisRoot* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Identity"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gchar* mpris_root_dbus_proxy_get_DesktopEntry (MprisRoot* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "DesktopEntry");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DesktopEntry"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_root_dbus_proxy_set_DesktopEntry (MprisRoot* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DesktopEntry"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void mpris_root_proxy_mpris_root_interface_init (MprisRootIface* iface) {
	iface->Quit = mpris_root_proxy_Quit_async;
	iface->Quit_finish = mpris_root_proxy_Quit_finish;
	iface->Raise = mpris_root_proxy_Raise_async;
	iface->Raise_finish = mpris_root_proxy_Raise_finish;
	iface->get_HasTracklist = mpris_root_dbus_proxy_get_HasTracklist;
	iface->set_HasTracklist = mpris_root_dbus_proxy_set_HasTracklist;
	iface->get_CanQuit = mpris_root_dbus_proxy_get_CanQuit;
	iface->set_CanQuit = mpris_root_dbus_proxy_set_CanQuit;
	iface->get_CanRaise = mpris_root_dbus_proxy_get_CanRaise;
	iface->set_CanRaise = mpris_root_dbus_proxy_set_CanRaise;
	iface->get_Identity = mpris_root_dbus_proxy_get_Identity;
	iface->set_Identity = mpris_root_dbus_proxy_set_Identity;
	iface->get_DesktopEntry = mpris_root_dbus_proxy_get_DesktopEntry;
	iface->set_DesktopEntry = mpris_root_dbus_proxy_set_DesktopEntry;
}


static void _dbus_mpris_root_Quit (MprisRoot* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	mpris_root_Quit (self, (GAsyncReadyCallback) _dbus_mpris_root_Quit_ready, invocation);
}


static void _dbus_mpris_root_Quit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_root_Quit_finish ((MprisRoot*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_mpris_root_Raise (MprisRoot* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	mpris_root_Raise (self, (GAsyncReadyCallback) _dbus_mpris_root_Raise_ready, invocation);
}


static void _dbus_mpris_root_Raise_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_root_Raise_finish ((MprisRoot*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void mpris_root_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Quit") == 0) {
		_dbus_mpris_root_Quit (object, parameters, invocation);
	} else if (strcmp (method_name, "Raise") == 0) {
		_dbus_mpris_root_Raise (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_mpris_root_get_HasTracklist (MprisRoot* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_root_get_HasTracklist (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_root_get_CanQuit (MprisRoot* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_root_get_CanQuit (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_root_get_CanRaise (MprisRoot* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_root_get_CanRaise (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_root_get_Identity (MprisRoot* self) {
	gchar* result;
	GVariant* _reply;
	result = mpris_root_get_Identity (self);
	_reply = g_variant_new_string (result);
	_g_free0 ( result);
	return _reply;
}


static GVariant* _dbus_mpris_root_get_DesktopEntry (MprisRoot* self) {
	gchar* result;
	GVariant* _reply;
	result = mpris_root_get_DesktopEntry (self);
	_reply = g_variant_new_string (result);
	_g_free0 ( result);
	return _reply;
}


static GVariant* mpris_root_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "HasTracklist") == 0) {
		return _dbus_mpris_root_get_HasTracklist (object);
	} else if (strcmp (property_name, "CanQuit") == 0) {
		return _dbus_mpris_root_get_CanQuit (object);
	} else if (strcmp (property_name, "CanRaise") == 0) {
		return _dbus_mpris_root_get_CanRaise (object);
	} else if (strcmp (property_name, "Identity") == 0) {
		return _dbus_mpris_root_get_Identity (object);
	} else if (strcmp (property_name, "DesktopEntry") == 0) {
		return _dbus_mpris_root_get_DesktopEntry (object);
	}
	return NULL;
}


static void _dbus_mpris_root_set_HasTracklist (MprisRoot* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	mpris_root_set_HasTracklist (self, value);
}


static void _dbus_mpris_root_set_CanQuit (MprisRoot* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	mpris_root_set_CanQuit (self, value);
}


static void _dbus_mpris_root_set_CanRaise (MprisRoot* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	mpris_root_set_CanRaise (self, value);
}


static void _dbus_mpris_root_set_Identity (MprisRoot* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	mpris_root_set_Identity (self, value);
	_g_free0 (value);
}


static void _dbus_mpris_root_set_DesktopEntry (MprisRoot* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	mpris_root_set_DesktopEntry (self, value);
	_g_free0 (value);
}


static gboolean mpris_root_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "HasTracklist") == 0) {
		_dbus_mpris_root_set_HasTracklist (object, value);
		return TRUE;
	} else if (strcmp (property_name, "CanQuit") == 0) {
		_dbus_mpris_root_set_CanQuit (object, value);
		return TRUE;
	} else if (strcmp (property_name, "CanRaise") == 0) {
		_dbus_mpris_root_set_CanRaise (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Identity") == 0) {
		_dbus_mpris_root_set_Identity (object, value);
		return TRUE;
	} else if (strcmp (property_name, "DesktopEntry") == 0) {
		_dbus_mpris_root_set_DesktopEntry (object, value);
		return TRUE;
	}
	return FALSE;
}


guint mpris_root_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_mpris_root_dbus_interface_info), &_mpris_root_dbus_interface_vtable, data, _mpris_root_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _mpris_root_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void mpris_player_PlayPause (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_PLAYER_GET_INTERFACE (self)->PlayPause (self, _callback_, _user_data_);
}


void mpris_player_PlayPause_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	MPRIS_PLAYER_GET_INTERFACE (self)->PlayPause_finish (self, _res_, error);
}


void mpris_player_Next (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_PLAYER_GET_INTERFACE (self)->Next (self, _callback_, _user_data_);
}


void mpris_player_Next_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	MPRIS_PLAYER_GET_INTERFACE (self)->Next_finish (self, _res_, error);
}


void mpris_player_Previous (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_PLAYER_GET_INTERFACE (self)->Previous (self, _callback_, _user_data_);
}


void mpris_player_Previous_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	MPRIS_PLAYER_GET_INTERFACE (self)->Previous_finish (self, _res_, error);
}


void mpris_player_Seek (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_PLAYER_GET_INTERFACE (self)->Seek (self, offset, _callback_, _user_data_);
}


void mpris_player_Seek_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	MPRIS_PLAYER_GET_INTERFACE (self)->Seek_finish (self, _res_, error);
}


GHashTable* mpris_player_get_Metadata (MprisPlayer* self) {
	return MPRIS_PLAYER_GET_INTERFACE (self)->get_Metadata (self);
}


void mpris_player_set_Metadata (MprisPlayer* self, GHashTable* value) {
	MPRIS_PLAYER_GET_INTERFACE (self)->set_Metadata (self, value);
}


gint32 mpris_player_get_Position (MprisPlayer* self) {
	return MPRIS_PLAYER_GET_INTERFACE (self)->get_Position (self);
}


void mpris_player_set_Position (MprisPlayer* self, gint32 value) {
	MPRIS_PLAYER_GET_INTERFACE (self)->set_Position (self, value);
}


gchar* mpris_player_get_PlaybackStatus (MprisPlayer* self) {
	return MPRIS_PLAYER_GET_INTERFACE (self)->get_PlaybackStatus (self);
}


void mpris_player_set_PlaybackStatus (MprisPlayer* self, const gchar* value) {
	MPRIS_PLAYER_GET_INTERFACE (self)->set_PlaybackStatus (self, value);
}


static void g_cclosure_user_marshal_VOID__INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT64) (gpointer data1, gint64 arg_1, gpointer data2);
	register GMarshalFunc_VOID__INT64 callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int64 (param_values + 1), data2);
}


static void mpris_player_base_init (MprisPlayerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("seeked", TYPE_MPRIS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT64, G_TYPE_NONE, 1, G_TYPE_INT64);
	}
}


GType mpris_player_get_type (void) {
	static volatile gsize mpris_player_type_id__volatile = 0;
	if (g_once_init_enter (&mpris_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MprisPlayerIface), (GBaseInitFunc) mpris_player_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType mpris_player_type_id;
		mpris_player_type_id = g_type_register_static (G_TYPE_INTERFACE, "MprisPlayer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (mpris_player_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (mpris_player_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) mpris_player_proxy_get_type);
		g_type_set_qdata (mpris_player_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.mpris.MediaPlayer2.Player");
		g_type_set_qdata (mpris_player_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) mpris_player_register_object);
		g_once_init_leave (&mpris_player_type_id__volatile, mpris_player_type_id);
	}
	return mpris_player_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MprisPlayerProxy, mpris_player_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MPRIS_PLAYER, mpris_player_proxy_mpris_player_interface_init) )
static void mpris_player_proxy_class_init (MprisPlayerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = mpris_player_proxy_g_signal;
}


static void _dbus_handle_mpris_player_seeked (MprisPlayer* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gint64 new_position = 0LL;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	new_position = g_variant_get_int64 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "seeked", new_position);
}


static void mpris_player_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Seeked") == 0) {
		_dbus_handle_mpris_player_seeked ((MprisPlayer*) proxy, parameters);
	}
}


static void mpris_player_proxy_init (MprisPlayerProxy* self) {
}


static void mpris_player_proxy_PlayPause_async (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "PlayPause");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_player_proxy_PlayPause_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void mpris_player_proxy_Next_async (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Next");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_player_proxy_Next_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void mpris_player_proxy_Previous_async (MprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Previous");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_player_proxy_Previous_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void mpris_player_proxy_Seek_async (MprisPlayer* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Seek");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int64 (offset));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_player_proxy_Seek_finish (MprisPlayer* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static GHashTable* mpris_player_dbus_proxy_get_Metadata (MprisPlayer* self) {
	GVariant *_inner_reply;
	GHashTable* _result;
	GHashTable* _tmp1_;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Metadata");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Metadata"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp2_, _inner_reply);
	while (g_variant_iter_loop (&_tmp2_, "{?*}", &_tmp3_, &_tmp4_)) {
		g_hash_table_insert (_tmp1_, g_variant_dup_string (_tmp3_, NULL), g_variant_get_variant (_tmp4_));
	}
	_result = _tmp1_;
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_player_dbus_proxy_set_Metadata (MprisPlayer* self, GHashTable* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp5_;
	GHashTableIter _tmp6_;
	gpointer _tmp7_;
	gpointer _tmp8_;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Metadata"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_hash_table_iter_init (&_tmp6_, value);
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp6_, &_tmp7_, &_tmp8_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp7_;
		_value = (GVariant*) _tmp8_;
		g_variant_builder_add (&_tmp5_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp5_));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gint32 mpris_player_dbus_proxy_get_Position (MprisPlayer* self) {
	GVariant *_inner_reply;
	gint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Position");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Position"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_player_dbus_proxy_set_Position (MprisPlayer* self, gint32 value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Position"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gchar* mpris_player_dbus_proxy_get_PlaybackStatus (MprisPlayer* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PlaybackStatus");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PlaybackStatus"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_player_dbus_proxy_set_PlaybackStatus (MprisPlayer* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PlaybackStatus"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void mpris_player_proxy_mpris_player_interface_init (MprisPlayerIface* iface) {
	iface->PlayPause = mpris_player_proxy_PlayPause_async;
	iface->PlayPause_finish = mpris_player_proxy_PlayPause_finish;
	iface->Next = mpris_player_proxy_Next_async;
	iface->Next_finish = mpris_player_proxy_Next_finish;
	iface->Previous = mpris_player_proxy_Previous_async;
	iface->Previous_finish = mpris_player_proxy_Previous_finish;
	iface->Seek = mpris_player_proxy_Seek_async;
	iface->Seek_finish = mpris_player_proxy_Seek_finish;
	iface->get_Metadata = mpris_player_dbus_proxy_get_Metadata;
	iface->set_Metadata = mpris_player_dbus_proxy_set_Metadata;
	iface->get_Position = mpris_player_dbus_proxy_get_Position;
	iface->set_Position = mpris_player_dbus_proxy_set_Position;
	iface->get_PlaybackStatus = mpris_player_dbus_proxy_get_PlaybackStatus;
	iface->set_PlaybackStatus = mpris_player_dbus_proxy_set_PlaybackStatus;
}


static void _dbus_mpris_player_PlayPause (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	mpris_player_PlayPause (self, (GAsyncReadyCallback) _dbus_mpris_player_PlayPause_ready, invocation);
}


static void _dbus_mpris_player_PlayPause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_player_PlayPause_finish ((MprisPlayer*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_mpris_player_Next (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	mpris_player_Next (self, (GAsyncReadyCallback) _dbus_mpris_player_Next_ready, invocation);
}


static void _dbus_mpris_player_Next_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_player_Next_finish ((MprisPlayer*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_mpris_player_Previous (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	mpris_player_Previous (self, (GAsyncReadyCallback) _dbus_mpris_player_Previous_ready, invocation);
}


static void _dbus_mpris_player_Previous_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_player_Previous_finish ((MprisPlayer*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_mpris_player_Seek (MprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint64 offset = 0LL;
	GVariant* _tmp9_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	offset = g_variant_get_int64 (_tmp9_);
	g_variant_unref (_tmp9_);
	mpris_player_Seek (self, offset, (GAsyncReadyCallback) _dbus_mpris_player_Seek_ready, invocation);
}


static void _dbus_mpris_player_Seek_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_player_Seek_finish ((MprisPlayer*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void mpris_player_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PlayPause") == 0) {
		_dbus_mpris_player_PlayPause (object, parameters, invocation);
	} else if (strcmp (method_name, "Next") == 0) {
		_dbus_mpris_player_Next (object, parameters, invocation);
	} else if (strcmp (method_name, "Previous") == 0) {
		_dbus_mpris_player_Previous (object, parameters, invocation);
	} else if (strcmp (method_name, "Seek") == 0) {
		_dbus_mpris_player_Seek (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_mpris_player_get_Metadata (MprisPlayer* self) {
	GHashTable* result;
	GVariantBuilder _tmp10_;
	GHashTableIter _tmp11_;
	gpointer _tmp12_;
	gpointer _tmp13_;
	GVariant* _reply;
	result = mpris_player_get_Metadata (self);
	g_hash_table_iter_init (&_tmp11_, result);
	g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp11_, &_tmp12_, &_tmp13_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp12_;
		_value = (GVariant*) _tmp13_;
		g_variant_builder_add (&_tmp10_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	_reply = g_variant_builder_end (&_tmp10_);
	_g_hash_table_unref0 ( result);
	return _reply;
}


static GVariant* _dbus_mpris_player_get_Position (MprisPlayer* self) {
	gint32 result;
	GVariant* _reply;
	result = mpris_player_get_Position (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}


static GVariant* _dbus_mpris_player_get_PlaybackStatus (MprisPlayer* self) {
	gchar* result;
	GVariant* _reply;
	result = mpris_player_get_PlaybackStatus (self);
	_reply = g_variant_new_string (result);
	_g_free0 ( result);
	return _reply;
}


static GVariant* mpris_player_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Metadata") == 0) {
		return _dbus_mpris_player_get_Metadata (object);
	} else if (strcmp (property_name, "Position") == 0) {
		return _dbus_mpris_player_get_Position (object);
	} else if (strcmp (property_name, "PlaybackStatus") == 0) {
		return _dbus_mpris_player_get_PlaybackStatus (object);
	}
	return NULL;
}


static void _dbus_mpris_player_set_Metadata (MprisPlayer* self, GVariant* _value) {
	GHashTable* value = NULL;
	GHashTable* _tmp14_;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	_tmp14_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	g_variant_iter_init (&_tmp15_, _value);
	while (g_variant_iter_loop (&_tmp15_, "{?*}", &_tmp16_, &_tmp17_)) {
		g_hash_table_insert (_tmp14_, g_variant_dup_string (_tmp16_, NULL), g_variant_get_variant (_tmp17_));
	}
	value = _tmp14_;
	mpris_player_set_Metadata (self, value);
	_g_hash_table_unref0 (value);
}


static void _dbus_mpris_player_set_Position (MprisPlayer* self, GVariant* _value) {
	gint32 value = 0;
	value = g_variant_get_int32 (_value);
	mpris_player_set_Position (self, value);
}


static void _dbus_mpris_player_set_PlaybackStatus (MprisPlayer* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	mpris_player_set_PlaybackStatus (self, value);
	_g_free0 (value);
}


static gboolean mpris_player_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Metadata") == 0) {
		_dbus_mpris_player_set_Metadata (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Position") == 0) {
		_dbus_mpris_player_set_Position (object, value);
		return TRUE;
	} else if (strcmp (property_name, "PlaybackStatus") == 0) {
		_dbus_mpris_player_set_PlaybackStatus (object, value);
		return TRUE;
	}
	return FALSE;
}


static void _dbus_mpris_player_seeked (GObject* _sender, gint64 new_position, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int64 (new_position));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.mpris.MediaPlayer2.Player", "Seeked", _arguments, NULL);
}


guint mpris_player_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_mpris_player_dbus_interface_info), &_mpris_player_dbus_interface_vtable, data, _mpris_player_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "seeked", (GCallback) _dbus_mpris_player_seeked, data);
	return result;
}


static void _mpris_player_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void playlist_details_copy (const PlaylistDetails* self, PlaylistDetails* dest) {
	dest->path = g_strdup (self->path);
	dest->name = g_strdup (self->name);
	dest->icon_path = g_strdup (self->icon_path);
}


void playlist_details_destroy (PlaylistDetails* self) {
	_g_free0 ((*self).path);
	_g_free0 ((*self).name);
	_g_free0 ((*self).icon_path);
}


PlaylistDetails* playlist_details_dup (const PlaylistDetails* self) {
	PlaylistDetails* dup;
	dup = g_new0 (PlaylistDetails, 1);
	playlist_details_copy (self, dup);
	return dup;
}


void playlist_details_free (PlaylistDetails* self) {
	playlist_details_destroy (self);
	g_free (self);
}


GType playlist_details_get_type (void) {
	static volatile gsize playlist_details_type_id__volatile = 0;
	if (g_once_init_enter (&playlist_details_type_id__volatile)) {
		GType playlist_details_type_id;
		playlist_details_type_id = g_boxed_type_register_static ("PlaylistDetails", (GBoxedCopyFunc) playlist_details_dup, (GBoxedFreeFunc) playlist_details_free);
		g_once_init_leave (&playlist_details_type_id__volatile, playlist_details_type_id);
	}
	return playlist_details_type_id__volatile;
}


void active_playlist_container_copy (const ActivePlaylistContainer* self, ActivePlaylistContainer* dest) {
	PlaylistDetails _tmp0_ = {0};
	dest->valid = self->valid;
	playlist_details_copy (&self->details, &_tmp0_);
	dest->details = _tmp0_;
}


void active_playlist_container_destroy (ActivePlaylistContainer* self) {
	playlist_details_destroy (&(*self).details);
}


ActivePlaylistContainer* active_playlist_container_dup (const ActivePlaylistContainer* self) {
	ActivePlaylistContainer* dup;
	dup = g_new0 (ActivePlaylistContainer, 1);
	active_playlist_container_copy (self, dup);
	return dup;
}


void active_playlist_container_free (ActivePlaylistContainer* self) {
	active_playlist_container_destroy (self);
	g_free (self);
}


GType active_playlist_container_get_type (void) {
	static volatile gsize active_playlist_container_type_id__volatile = 0;
	if (g_once_init_enter (&active_playlist_container_type_id__volatile)) {
		GType active_playlist_container_type_id;
		active_playlist_container_type_id = g_boxed_type_register_static ("ActivePlaylistContainer", (GBoxedCopyFunc) active_playlist_container_dup, (GBoxedFreeFunc) active_playlist_container_free);
		g_once_init_leave (&active_playlist_container_type_id__volatile, active_playlist_container_type_id);
	}
	return active_playlist_container_type_id__volatile;
}


void mpris_playlists_ActivatePlaylist (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_PLAYLISTS_GET_INTERFACE (self)->ActivatePlaylist (self, playlist_id, _callback_, _user_data_);
}


void mpris_playlists_ActivatePlaylist_finish (MprisPlaylists* self, GAsyncResult* _res_, GError** error) {
	MPRIS_PLAYLISTS_GET_INTERFACE (self)->ActivatePlaylist_finish (self, _res_, error);
}


void mpris_playlists_GetPlaylists (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_PLAYLISTS_GET_INTERFACE (self)->GetPlaylists (self, index, max_count, order, reverse_order, _callback_, _user_data_);
}


PlaylistDetails* mpris_playlists_GetPlaylists_finish (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return MPRIS_PLAYLISTS_GET_INTERFACE (self)->GetPlaylists_finish (self, _res_, result_length1, error);
}


gchar** mpris_playlists_get_Orderings (MprisPlaylists* self, int* result_length1) {
	return MPRIS_PLAYLISTS_GET_INTERFACE (self)->get_Orderings (self, result_length1);
}


void mpris_playlists_set_Orderings (MprisPlaylists* self, gchar** value, int value_length1) {
	MPRIS_PLAYLISTS_GET_INTERFACE (self)->set_Orderings (self, value, value_length1);
}


guint32 mpris_playlists_get_PlaylistCount (MprisPlaylists* self) {
	return MPRIS_PLAYLISTS_GET_INTERFACE (self)->get_PlaylistCount (self);
}


void mpris_playlists_set_PlaylistCount (MprisPlaylists* self, guint32 value) {
	MPRIS_PLAYLISTS_GET_INTERFACE (self)->set_PlaylistCount (self, value);
}


void mpris_playlists_get_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* result) {
	MPRIS_PLAYLISTS_GET_INTERFACE (self)->get_ActivePlaylist (self, result);
}


void mpris_playlists_set_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* value) {
	MPRIS_PLAYLISTS_GET_INTERFACE (self)->set_ActivePlaylist (self, value);
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static void mpris_playlists_base_init (MprisPlaylistsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("playlist_changed", TYPE_MPRIS_PLAYLISTS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, TYPE_PLAYLIST_DETAILS);
	}
}


GType mpris_playlists_get_type (void) {
	static volatile gsize mpris_playlists_type_id__volatile = 0;
	if (g_once_init_enter (&mpris_playlists_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MprisPlaylistsIface), (GBaseInitFunc) mpris_playlists_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType mpris_playlists_type_id;
		mpris_playlists_type_id = g_type_register_static (G_TYPE_INTERFACE, "MprisPlaylists", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (mpris_playlists_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (mpris_playlists_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) mpris_playlists_proxy_get_type);
		g_type_set_qdata (mpris_playlists_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.mpris.MediaPlayer2.Playlists");
		g_type_set_qdata (mpris_playlists_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) mpris_playlists_register_object);
		g_once_init_leave (&mpris_playlists_type_id__volatile, mpris_playlists_type_id);
	}
	return mpris_playlists_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MprisPlaylistsProxy, mpris_playlists_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MPRIS_PLAYLISTS, mpris_playlists_proxy_mpris_playlists_interface_init) )
static void mpris_playlists_proxy_class_init (MprisPlaylistsProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = mpris_playlists_proxy_g_signal;
}


static void _dbus_handle_mpris_playlists_playlist_changed (MprisPlaylists* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	PlaylistDetails details = {0};
	GVariant* _tmp18_;
	PlaylistDetails _tmp19_;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp20_, _tmp18_);
	_tmp21_ = g_variant_iter_next_value (&_tmp20_);
	_tmp19_.path = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_tmp20_);
	_tmp19_.name = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_tmp20_);
	_tmp19_.icon_path = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	details = _tmp19_;
	g_variant_unref (_tmp18_);
	g_signal_emit_by_name (self, "playlist-changed", &details);
	playlist_details_destroy (&details);
}


static void mpris_playlists_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "PlaylistChanged") == 0) {
		_dbus_handle_mpris_playlists_playlist_changed ((MprisPlaylists*) proxy, parameters);
	}
}


static void mpris_playlists_proxy_init (MprisPlaylistsProxy* self) {
}


static void mpris_playlists_proxy_ActivatePlaylist_async (MprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Playlists", "ActivatePlaylist");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (playlist_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_playlists_proxy_ActivatePlaylist_finish (MprisPlaylists* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void mpris_playlists_proxy_GetPlaylists_async (MprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Playlists", "GetPlaylists");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (index));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (max_count));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (order));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (reverse_order));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static PlaylistDetails* mpris_playlists_proxy_GetPlaylists_finish (MprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	PlaylistDetails* _result;
	int _result_length1;
	GVariant* _tmp24_;
	PlaylistDetails* _tmp25_;
	int _tmp25__length;
	int _tmp25__size;
	int _tmp25__length1;
	GVariantIter _tmp26_;
	GVariant* _tmp27_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp24_ = g_variant_iter_next_value (&_reply_iter);
	_tmp25_ = g_new (PlaylistDetails, 5);
	_tmp25__length = 0;
	_tmp25__size = 4;
	_tmp25__length1 = 0;
	g_variant_iter_init (&_tmp26_, _tmp24_);
	for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
		PlaylistDetails _tmp28_;
		GVariantIter _tmp29_;
		GVariant* _tmp30_;
		GVariant* _tmp31_;
		GVariant* _tmp32_;
		if (_tmp25__size == _tmp25__length) {
			_tmp25__size = 2 * _tmp25__size;
			_tmp25_ = g_renew (PlaylistDetails, _tmp25_, _tmp25__size + 1);
		}
		g_variant_iter_init (&_tmp29_, _tmp27_);
		_tmp30_ = g_variant_iter_next_value (&_tmp29_);
		_tmp28_.path = g_variant_dup_string (_tmp30_, NULL);
		g_variant_unref (_tmp30_);
		_tmp31_ = g_variant_iter_next_value (&_tmp29_);
		_tmp28_.name = g_variant_dup_string (_tmp31_, NULL);
		g_variant_unref (_tmp31_);
		_tmp32_ = g_variant_iter_next_value (&_tmp29_);
		_tmp28_.icon_path = g_variant_dup_string (_tmp32_, NULL);
		g_variant_unref (_tmp32_);
		_tmp25_[_tmp25__length++] = _tmp28_;
		g_variant_unref (_tmp27_);
	}
	_result_length1 = _tmp25__length1;
	_result = _tmp25_;
	g_variant_unref (_tmp24_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gchar** mpris_playlists_dbus_proxy_get_Orderings (MprisPlaylists* self, int* result_length1) {
	GVariant *_inner_reply;
	gchar** _result;
	int _result_length1;
	gchar** _tmp33_;
	int _tmp33__length;
	int _tmp33__size;
	int _tmp33__length1;
	GVariantIter _tmp34_;
	GVariant* _tmp35_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Orderings");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Playlists"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Orderings"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp33_ = g_new (gchar*, 5);
	_tmp33__length = 0;
	_tmp33__size = 4;
	_tmp33__length1 = 0;
	g_variant_iter_init (&_tmp34_, _inner_reply);
	for (; (_tmp35_ = g_variant_iter_next_value (&_tmp34_)) != NULL; _tmp33__length1++) {
		if (_tmp33__size == _tmp33__length) {
			_tmp33__size = 2 * _tmp33__size;
			_tmp33_ = g_renew (gchar*, _tmp33_, _tmp33__size + 1);
		}
		_tmp33_[_tmp33__length++] = g_variant_dup_string (_tmp35_, NULL);
		g_variant_unref (_tmp35_);
	}
	_result_length1 = _tmp33__length1;
	_tmp33_[_tmp33__length] = NULL;
	_result = _tmp33_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_playlists_dbus_proxy_set_Orderings (MprisPlaylists* self, gchar** value, int value_length1) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	gchar** _tmp36_;
	GVariantBuilder _tmp37_;
	int _tmp38_;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Playlists"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Orderings"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	_tmp36_ = value;
	g_variant_builder_init (&_tmp37_, G_VARIANT_TYPE ("as"));
	for (_tmp38_ = 0; _tmp38_ < value_length1; _tmp38_++) {
		g_variant_builder_add_value (&_tmp37_, g_variant_new_string (*_tmp36_));
		_tmp36_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp37_));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static guint32 mpris_playlists_dbus_proxy_get_PlaylistCount (MprisPlaylists* self) {
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PlaylistCount");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Playlists"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PlaylistCount"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0U;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_playlists_dbus_proxy_set_PlaylistCount (MprisPlaylists* self, guint32 value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Playlists"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PlaylistCount"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void mpris_playlists_dbus_proxy_get_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* result) {
	GVariant *_inner_reply;
	ActivePlaylistContainer _tmp39_;
	GVariantIter _tmp40_;
	GVariant* _tmp41_;
	GVariant* _tmp42_;
	PlaylistDetails _tmp43_;
	GVariantIter _tmp44_;
	GVariant* _tmp45_;
	GVariant* _tmp46_;
	GVariant* _tmp47_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "ActivePlaylist");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Playlists"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ActivePlaylist"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	g_variant_iter_init (&_tmp40_, _inner_reply);
	_tmp41_ = g_variant_iter_next_value (&_tmp40_);
	_tmp39_.valid = g_variant_get_boolean (_tmp41_);
	g_variant_unref (_tmp41_);
	_tmp42_ = g_variant_iter_next_value (&_tmp40_);
	g_variant_iter_init (&_tmp44_, _tmp42_);
	_tmp45_ = g_variant_iter_next_value (&_tmp44_);
	_tmp43_.path = g_variant_dup_string (_tmp45_, NULL);
	g_variant_unref (_tmp45_);
	_tmp46_ = g_variant_iter_next_value (&_tmp44_);
	_tmp43_.name = g_variant_dup_string (_tmp46_, NULL);
	g_variant_unref (_tmp46_);
	_tmp47_ = g_variant_iter_next_value (&_tmp44_);
	_tmp43_.icon_path = g_variant_dup_string (_tmp47_, NULL);
	g_variant_unref (_tmp47_);
	_tmp39_.details = _tmp43_;
	g_variant_unref (_tmp42_);
	*result = _tmp39_;
	g_variant_unref (_inner_reply);
	return;
}


static void mpris_playlists_dbus_proxy_set_ActivePlaylist (MprisPlaylists* self, ActivePlaylistContainer* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp48_;
	GVariantBuilder _tmp49_;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Playlists"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("ActivePlaylist"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_init (&_tmp48_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp48_, g_variant_new_boolean ((*value).valid));
	g_variant_builder_init (&_tmp49_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp49_, g_variant_new_object_path ((*value).details.path));
	g_variant_builder_add_value (&_tmp49_, g_variant_new_string ((*value).details.name));
	g_variant_builder_add_value (&_tmp49_, g_variant_new_string ((*value).details.icon_path));
	g_variant_builder_add_value (&_tmp48_, g_variant_builder_end (&_tmp49_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp48_));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void mpris_playlists_proxy_mpris_playlists_interface_init (MprisPlaylistsIface* iface) {
	iface->ActivatePlaylist = mpris_playlists_proxy_ActivatePlaylist_async;
	iface->ActivatePlaylist_finish = mpris_playlists_proxy_ActivatePlaylist_finish;
	iface->GetPlaylists = mpris_playlists_proxy_GetPlaylists_async;
	iface->GetPlaylists_finish = mpris_playlists_proxy_GetPlaylists_finish;
	iface->get_Orderings = mpris_playlists_dbus_proxy_get_Orderings;
	iface->set_Orderings = mpris_playlists_dbus_proxy_set_Orderings;
	iface->get_PlaylistCount = mpris_playlists_dbus_proxy_get_PlaylistCount;
	iface->set_PlaylistCount = mpris_playlists_dbus_proxy_set_PlaylistCount;
	iface->get_ActivePlaylist = mpris_playlists_dbus_proxy_get_ActivePlaylist;
	iface->set_ActivePlaylist = mpris_playlists_dbus_proxy_set_ActivePlaylist;
}


static void _dbus_mpris_playlists_ActivatePlaylist (MprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	char* playlist_id = NULL;
	GVariant* _tmp50_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp50_ = g_variant_iter_next_value (&_arguments_iter);
	playlist_id = g_variant_dup_string (_tmp50_, NULL);
	g_variant_unref (_tmp50_);
	mpris_playlists_ActivatePlaylist (self, playlist_id, (GAsyncReadyCallback) _dbus_mpris_playlists_ActivatePlaylist_ready, invocation);
	_g_free0 (playlist_id);
}


static void _dbus_mpris_playlists_ActivatePlaylist_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_playlists_ActivatePlaylist_finish ((MprisPlaylists*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_mpris_playlists_GetPlaylists (MprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	guint32 index = 0U;
	GVariant* _tmp51_;
	guint32 max_count = 0U;
	GVariant* _tmp52_;
	gchar* order = NULL;
	GVariant* _tmp53_;
	gboolean reverse_order = FALSE;
	GVariant* _tmp54_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp51_ = g_variant_iter_next_value (&_arguments_iter);
	index = g_variant_get_uint32 (_tmp51_);
	g_variant_unref (_tmp51_);
	_tmp52_ = g_variant_iter_next_value (&_arguments_iter);
	max_count = g_variant_get_uint32 (_tmp52_);
	g_variant_unref (_tmp52_);
	_tmp53_ = g_variant_iter_next_value (&_arguments_iter);
	order = g_variant_dup_string (_tmp53_, NULL);
	g_variant_unref (_tmp53_);
	_tmp54_ = g_variant_iter_next_value (&_arguments_iter);
	reverse_order = g_variant_get_boolean (_tmp54_);
	g_variant_unref (_tmp54_);
	mpris_playlists_GetPlaylists (self, index, max_count, order, reverse_order, (GAsyncReadyCallback) _dbus_mpris_playlists_GetPlaylists_ready, invocation);
	_g_free0 (order);
}


static void _vala_PlaylistDetails_array_free (PlaylistDetails* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			playlist_details_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_mpris_playlists_GetPlaylists_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	PlaylistDetails* result;
	int result_length1 = 0;
	PlaylistDetails* _tmp55_;
	GVariantBuilder _tmp56_;
	int _tmp57_;
	invocation = _user_data_;
	result = mpris_playlists_GetPlaylists_finish ((MprisPlaylists*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp55_ = result;
	g_variant_builder_init (&_tmp56_, G_VARIANT_TYPE ("a(oss)"));
	for (_tmp57_ = 0; _tmp57_ < result_length1; _tmp57_++) {
		GVariantBuilder _tmp58_;
		g_variant_builder_init (&_tmp58_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp58_, g_variant_new_object_path ((*_tmp55_).path));
		g_variant_builder_add_value (&_tmp58_, g_variant_new_string ((*_tmp55_).name));
		g_variant_builder_add_value (&_tmp58_, g_variant_new_string ((*_tmp55_).icon_path));
		g_variant_builder_add_value (&_tmp56_, g_variant_builder_end (&_tmp58_));
		_tmp55_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp56_));
	 result = (_vala_PlaylistDetails_array_free ( result,  result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void mpris_playlists_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ActivatePlaylist") == 0) {
		_dbus_mpris_playlists_ActivatePlaylist (object, parameters, invocation);
	} else if (strcmp (method_name, "GetPlaylists") == 0) {
		_dbus_mpris_playlists_GetPlaylists (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_mpris_playlists_get_Orderings (MprisPlaylists* self) {
	gchar** result;
	int result_length1;
	gchar** _tmp59_;
	GVariantBuilder _tmp60_;
	int _tmp61_;
	GVariant* _reply;
	result = mpris_playlists_get_Orderings (self, &result_length1);
	_tmp59_ = result;
	g_variant_builder_init (&_tmp60_, G_VARIANT_TYPE ("as"));
	for (_tmp61_ = 0; _tmp61_ < result_length1; _tmp61_++) {
		g_variant_builder_add_value (&_tmp60_, g_variant_new_string (*_tmp59_));
		_tmp59_++;
	}
	_reply = g_variant_builder_end (&_tmp60_);
	 result = (_vala_array_free ( result,  result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}


static GVariant* _dbus_mpris_playlists_get_PlaylistCount (MprisPlaylists* self) {
	guint32 result;
	GVariant* _reply;
	result = mpris_playlists_get_PlaylistCount (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* _dbus_mpris_playlists_get_ActivePlaylist (MprisPlaylists* self) {
	ActivePlaylistContainer result = {0};
	GVariantBuilder _tmp62_;
	GVariantBuilder _tmp63_;
	GVariant* _reply;
	mpris_playlists_get_ActivePlaylist (self, &result);
	g_variant_builder_init (&_tmp62_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp62_, g_variant_new_boolean (result.valid));
	g_variant_builder_init (&_tmp63_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp63_, g_variant_new_object_path (result.details.path));
	g_variant_builder_add_value (&_tmp63_, g_variant_new_string (result.details.name));
	g_variant_builder_add_value (&_tmp63_, g_variant_new_string (result.details.icon_path));
	g_variant_builder_add_value (&_tmp62_, g_variant_builder_end (&_tmp63_));
	_reply = g_variant_builder_end (&_tmp62_);
	active_playlist_container_destroy (& result);
	return _reply;
}


static GVariant* mpris_playlists_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Orderings") == 0) {
		return _dbus_mpris_playlists_get_Orderings (object);
	} else if (strcmp (property_name, "PlaylistCount") == 0) {
		return _dbus_mpris_playlists_get_PlaylistCount (object);
	} else if (strcmp (property_name, "ActivePlaylist") == 0) {
		return _dbus_mpris_playlists_get_ActivePlaylist (object);
	}
	return NULL;
}


static void _dbus_mpris_playlists_set_Orderings (MprisPlaylists* self, GVariant* _value) {
	gchar** value = NULL;
	int value_length1;
	gchar** _tmp64_;
	int _tmp64__length;
	int _tmp64__size;
	int _tmp64__length1;
	GVariantIter _tmp65_;
	GVariant* _tmp66_;
	_tmp64_ = g_new (gchar*, 5);
	_tmp64__length = 0;
	_tmp64__size = 4;
	_tmp64__length1 = 0;
	g_variant_iter_init (&_tmp65_, _value);
	for (; (_tmp66_ = g_variant_iter_next_value (&_tmp65_)) != NULL; _tmp64__length1++) {
		if (_tmp64__size == _tmp64__length) {
			_tmp64__size = 2 * _tmp64__size;
			_tmp64_ = g_renew (gchar*, _tmp64_, _tmp64__size + 1);
		}
		_tmp64_[_tmp64__length++] = g_variant_dup_string (_tmp66_, NULL);
		g_variant_unref (_tmp66_);
	}
	value_length1 = _tmp64__length1;
	_tmp64_[_tmp64__length] = NULL;
	value = _tmp64_;
	mpris_playlists_set_Orderings (self, value, value_length1);
	value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_mpris_playlists_set_PlaylistCount (MprisPlaylists* self, GVariant* _value) {
	guint32 value = 0U;
	value = g_variant_get_uint32 (_value);
	mpris_playlists_set_PlaylistCount (self, value);
}


static void _dbus_mpris_playlists_set_ActivePlaylist (MprisPlaylists* self, GVariant* _value) {
	ActivePlaylistContainer value = {0};
	ActivePlaylistContainer _tmp67_;
	GVariantIter _tmp68_;
	GVariant* _tmp69_;
	GVariant* _tmp70_;
	PlaylistDetails _tmp71_;
	GVariantIter _tmp72_;
	GVariant* _tmp73_;
	GVariant* _tmp74_;
	GVariant* _tmp75_;
	g_variant_iter_init (&_tmp68_, _value);
	_tmp69_ = g_variant_iter_next_value (&_tmp68_);
	_tmp67_.valid = g_variant_get_boolean (_tmp69_);
	g_variant_unref (_tmp69_);
	_tmp70_ = g_variant_iter_next_value (&_tmp68_);
	g_variant_iter_init (&_tmp72_, _tmp70_);
	_tmp73_ = g_variant_iter_next_value (&_tmp72_);
	_tmp71_.path = g_variant_dup_string (_tmp73_, NULL);
	g_variant_unref (_tmp73_);
	_tmp74_ = g_variant_iter_next_value (&_tmp72_);
	_tmp71_.name = g_variant_dup_string (_tmp74_, NULL);
	g_variant_unref (_tmp74_);
	_tmp75_ = g_variant_iter_next_value (&_tmp72_);
	_tmp71_.icon_path = g_variant_dup_string (_tmp75_, NULL);
	g_variant_unref (_tmp75_);
	_tmp67_.details = _tmp71_;
	g_variant_unref (_tmp70_);
	value = _tmp67_;
	mpris_playlists_set_ActivePlaylist (self, &value);
	active_playlist_container_destroy (&value);
}


static gboolean mpris_playlists_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Orderings") == 0) {
		_dbus_mpris_playlists_set_Orderings (object, value);
		return TRUE;
	} else if (strcmp (property_name, "PlaylistCount") == 0) {
		_dbus_mpris_playlists_set_PlaylistCount (object, value);
		return TRUE;
	} else if (strcmp (property_name, "ActivePlaylist") == 0) {
		_dbus_mpris_playlists_set_ActivePlaylist (object, value);
		return TRUE;
	}
	return FALSE;
}


static void _dbus_mpris_playlists_playlist_changed (GObject* _sender, PlaylistDetails* details, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp76_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp76_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp76_, g_variant_new_object_path ((*details).path));
	g_variant_builder_add_value (&_tmp76_, g_variant_new_string ((*details).name));
	g_variant_builder_add_value (&_tmp76_, g_variant_new_string ((*details).icon_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp76_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.mpris.MediaPlayer2.Playlists", "PlaylistChanged", _arguments, NULL);
}


guint mpris_playlists_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_mpris_playlists_dbus_interface_info), &_mpris_playlists_dbus_interface_vtable, data, _mpris_playlists_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "playlist-changed", (GCallback) _dbus_mpris_playlists_playlist_changed, data);
	return result;
}


static void _mpris_playlists_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



