# - Uninstall target.
# Use this module to provide uninstall target.
#
# Define following targets
#   uninstall: For uninstalling the package.
#

IF(NOT DEFINED _MANAGE_UNINSTALL_CMAKE_)
    SET(_MANAGE_UNINSTALL_CMAKE_ "DEFINED")
    SET(CMAKE_UNINSTALL_IN_SEARCH_PATH ${CMAKE_MODULE_PATH} ${CMAKE_ROOT}/Modules ${CMAKE_SOURCE_DIR} ${CMAKE_SOURCE_DIR}/Modules)
    FIND_FILE(CMAKE_UNINSTALL_IN cmake_uninstall.cmake.in
	PATHS ${CMAKE_UNINSTALL_IN_SEARCH_PATH})

    # MESSAGE("CMAKE_UNINSTALL_IN=${CMAKE_UNINSTALL_IN}")
    IF(CMAKE_UNINSTALL_IN STREQUAL "CMAKE_UNINSTALL_IN-NOTFOUND")
	MESSAGE(FATAL_ERROR "Cannot find cmake_uninstall.cmake.in in"
	    "${CMAKE_UNINSTALL_IN_SEARCH_PATH}")
    ENDIF(CMAKE_UNINSTALL_IN STREQUAL "CMAKE_UNINSTALL_IN-NOTFOUND")

    CONFIGURE_FILE("${CMAKE_UNINSTALL_IN}"
	"${CMAKE_CURRENT_BINARY_DIR}/cmake_uninstall.cmake"
	IMMEDIATE @ONLY)

    ADD_CUSTOM_TARGET(uninstall
	"${CMAKE_COMMAND}" -P "${CMAKE_CURRENT_BINARY_DIR}/cmake_uninstall.cmake"
	)
ENDIF(NOT DEFINED _MANAGE_UNINSTALL_CMAKE_)

