/* Generated by GOB (v2.0.16)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"

/*
 * Copyright © 2009  Red Hat, Inc. All rights reserved.
 * Copyright © 2009  Ding-Yi Chen <dchen at redhat.com>
 *
 * This file is part of the ibus-chewing Project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include <stdlib.h>
#include <libintl.h>
#include <ibus.h>
#include <chewing.h>
#include <string.h>
#include <stdio.h>
#define GETTEXT_PACKAGE "gtk20"
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <X11/extensions/XTest.h>
#include <X11/Xlib.h>
#include <ctype.h>

#line 42 "ibus-chewing-engine.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 16

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "ibus-chewing-engine.h"

#include "ibus-chewing-engine-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
static const GEnumValue _chewing_kbtype_values[] = {
	{ CHEWING_KBTYPE_INVALID, (char *)"CHEWING_KBTYPE_INVALID", (char *)"invalid" },
	{ CHEWING_KBTYPE_DEFAULT, (char *)"CHEWING_KBTYPE_DEFAULT", (char *)"default" },
	{ CHEWING_KBTYPE_HSU, (char *)"CHEWING_KBTYPE_HSU", (char *)"hsu" },
	{ CHEWING_KBTYPE_IBM, (char *)"CHEWING_KBTYPE_IBM", (char *)"ibm" },
	{ CHEWING_KBTYPE_GIN_YIEH, (char *)"CHEWING_KBTYPE_GIN_YIEH", (char *)"gin-yieh" },
	{ CHEWING_KBTYPE_ETEN, (char *)"CHEWING_KBTYPE_ETEN", (char *)"eten" },
	{ CHEWING_KBTYPE_ETEN26, (char *)"CHEWING_KBTYPE_ETEN26", (char *)"eten26" },
	{ CHEWING_KBTYPE_DVORAK, (char *)"CHEWING_KBTYPE_DVORAK", (char *)"dvorak" },
	{ CHEWING_KBTYPE_DVORAK_HSU, (char *)"CHEWING_KBTYPE_DVORAK_HSU", (char *)"dvorak-hsu" },
	{ CHEWING_KBTYPE_DACHEN_CP26, (char *)"CHEWING_KBTYPE_DACHEN_CP26", (char *)"dachen-cp26" },
	{ CHEWING_KBTYPE_HAN_YU, (char *)"CHEWING_KBTYPE_HAN_YU", (char *)"han-yu" },
	{ 0, NULL, NULL }
};

GType
chewing_kbtype_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("ChewingKbType", _chewing_kbtype_values);
	return type;
}

static const GEnumValue _chewing_modifier_sync_values[] = {
	{ CHEWING_MODIFIER_SYNC_DISABLE, (char *)"CHEWING_MODIFIER_SYNC_DISABLE", (char *)"disable" },
	{ CHEWING_MODIFIER_SYNC_FROM_KEYBOARD, (char *)"CHEWING_MODIFIER_SYNC_FROM_KEYBOARD", (char *)"from-keyboard" },
	{ CHEWING_MODIFIER_SYNC_FROM_IM, (char *)"CHEWING_MODIFIER_SYNC_FROM_IM", (char *)"from-im" },
	{ 0, NULL, NULL }
};

GType
chewing_modifier_sync_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("ChewingModifierSync", _chewing_modifier_sync_values);
	return type;
}

static const GEnumValue _chewing_input_mode_values[] = {
	{ CHEWING_INPUT_MODE_BYPASS, (char *)"CHEWING_INPUT_MODE_BYPASS", (char *)"bypass" },
	{ CHEWING_INPUT_MODE_EDITING, (char *)"CHEWING_INPUT_MODE_EDITING", (char *)"editing" },
	{ CHEWING_INPUT_MODE_SELECTING, (char *)"CHEWING_INPUT_MODE_SELECTING", (char *)"selecting" },
	{ CHEWING_INPUT_MODE_SELECTING_DONE, (char *)"CHEWING_INPUT_MODE_SELECTING_DONE", (char *)"selecting-done" },
	{ 0, NULL, NULL }
};

GType
chewing_input_mode_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("ChewingInputMode", _chewing_input_mode_values);
	return type;
}

static const GEnumValue _chewing_output_charset_values[] = {
	{ CHEWING_OUTPUT_CHARSET_AUTO, (char *)"CHEWING_OUTPUT_CHARSET_AUTO", (char *)"auto" },
	{ CHEWING_OUTPUT_CHARSET_BIG5, (char *)"CHEWING_OUTPUT_CHARSET_BIG5", (char *)"big5" },
	{ CHEWING_OUTPUT_CHARSET_UTF8, (char *)"CHEWING_OUTPUT_CHARSET_UTF8", (char *)"utf8" },
	{ 0, NULL, NULL }
};

GType
chewing_output_charset_get_type (void)
{
	static GType type = 0;
	if ___GOB_UNLIKELY(type == 0)
		type = g_enum_register_static ("ChewingOutputCharset", _chewing_output_charset_values);
	return type;
}


#line 120 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"

extern gboolean ibus_chewing_verbose;
//extern IBusConfig *iConfig;

#define IBUS_CHEWING_MAIN
#include "IBusChewingEngine-def.c"

#ifdef IBUS_1_1
IBusKeymap *ibus_keymap_new(gchar *keymap_name){
    return NULL;
}

#endif /* IBUS_1_1 */

#line 151 "ibus-chewing-engine.c"
/* self casting macros */
#define SELF(x) IBUS_CHEWING_ENGINE(x)
#define SELF_CONST(x) IBUS_CHEWING_ENGINE_CONST(x)
#define IS_SELF(x) IBUS_IS_CHEWING_ENGINE(x)
#define TYPE_SELF IBUS_TYPE_CHEWING_ENGINE
#define SELF_CLASS(x) IBUS_CHEWING_ENGINE_CLASS(x)

#define SELF_GET_CLASS(x) IBUS_CHEWING_ENGINE_GET_CLASS(x)

/* self typedefs */
typedef IBusChewingEngine Self;
typedef IBusChewingEngineClass SelfClass;

/* here are local prototypes */
#line 209 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_init (IBusChewingEngine * self) G_GNUC_UNUSED;
#line 168 "ibus-chewing-engine.c"
#line 232 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_class_init (IBusChewingEngineClass * klass) G_GNUC_UNUSED;
#line 171 "ibus-chewing-engine.c"
#line 240 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_load_setting (IBusChewingEngine * self) G_GNUC_UNUSED;
#line 174 "ibus-chewing-engine.c"
#line 323 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static gchar * ibus_chewing_engine_make_preedit_string (IBusChewingEngine * self, glong * zhuyin_item_written_ptr) G_GNUC_UNUSED;
#line 177 "ibus-chewing-engine.c"
#line 390 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_show_lookup_table (IBusChewingEngine * self, gboolean isShow) G_GNUC_UNUSED;
#line 180 "ibus-chewing-engine.c"
#line 401 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_update_lookup_table (IBusChewingEngine * self) G_GNUC_UNUSED;
#line 183 "ibus-chewing-engine.c"
#line 429 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_update_aux_string (IBusChewingEngine * self) G_GNUC_UNUSED;
#line 186 "ibus-chewing-engine.c"
#line 448 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_update_preedit (IBusChewingEngine * self) G_GNUC_UNUSED;
#line 189 "ibus-chewing-engine.c"
#line 613 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static IBusProperty * ibus_chewing_engine_get_iBusProperty (IBusChewingEngine * self, const gchar * prop_name) G_GNUC_UNUSED;
#line 192 "ibus-chewing-engine.c"
#line 658 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_determine_input_mode (IBusChewingEngine * self) G_GNUC_UNUSED;
#line 195 "ibus-chewing-engine.c"
#line 695 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ibus_chewing_engine_force_commit (IBusChewingEngine * self) G_GNUC_UNUSED;
#line 198 "ibus-chewing-engine.c"
#line 716 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___17_ibus_chewing_engine_reset (IBusEngine * engine) G_GNUC_UNUSED;
#line 201 "ibus-chewing-engine.c"
#line 730 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___18_ibus_chewing_engine_page_up (IBusEngine * engine) G_GNUC_UNUSED;
#line 204 "ibus-chewing-engine.c"
#line 738 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___19_ibus_chewing_engine_page_down (IBusEngine * engine) G_GNUC_UNUSED;
#line 207 "ibus-chewing-engine.c"
#line 745 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___1a_ibus_chewing_engine_cursor_up (IBusEngine * engine) G_GNUC_UNUSED;
#line 210 "ibus-chewing-engine.c"
#line 752 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___1b_ibus_chewing_engine_cursor_down (IBusEngine * engine) G_GNUC_UNUSED;
#line 213 "ibus-chewing-engine.c"
#line 759 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___1c_ibus_chewing_engine_enable (IBusEngine * engine) G_GNUC_UNUSED;
#line 216 "ibus-chewing-engine.c"
#line 779 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___1d_ibus_chewing_engine_disable (IBusEngine * engine) G_GNUC_UNUSED;
#line 219 "ibus-chewing-engine.c"
#line 789 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___1e_ibus_chewing_engine_focus_in (IBusEngine * engine) G_GNUC_UNUSED;
#line 222 "ibus-chewing-engine.c"
#line 821 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___1f_ibus_chewing_engine_focus_out (IBusEngine * engine) G_GNUC_UNUSED;
#line 225 "ibus-chewing-engine.c"
#line 830 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___20_ibus_chewing_engine_property_activate (IBusEngine * engine, const gchar * prop_name, guint prop_state) G_GNUC_UNUSED;
#line 228 "ibus-chewing-engine.c"
#line 857 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___21_ibus_chewing_engine_property_show (IBusEngine * engine, const gchar * prop_name) G_GNUC_UNUSED;
#line 231 "ibus-chewing-engine.c"
#line 866 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void ___22_ibus_chewing_engine_property_hide (IBusEngine * engine, const gchar * prop_name) G_GNUC_UNUSED;
#line 234 "ibus-chewing-engine.c"

/* pointer to the class of our parent */
static IBusEngineClass *parent_class = NULL;

/* Short form macros */
#define self_load_setting ibus_chewing_engine_load_setting
#define self_commit ibus_chewing_engine_commit
#define self_set_lookup_table_label ibus_chewing_engine_set_lookup_table_label
#define self_make_preedit_string ibus_chewing_engine_make_preedit_string
#define self_show_lookup_table ibus_chewing_engine_show_lookup_table
#define self_update_lookup_table ibus_chewing_engine_update_lookup_table
#define self_update_aux_string ibus_chewing_engine_update_aux_string
#define self_update_preedit ibus_chewing_engine_update_preedit
#define self_update ibus_chewing_engine_update
#define self_refresh_property ibus_chewing_engine_refresh_property
#define self_refresh_property_list ibus_chewing_engine_refresh_property_list
#define self_hide_property_list ibus_chewing_engine_hide_property_list
#define self_save_config ibus_chewing_engine_save_config
#define self_save_config_all ibus_chewing_engine_save_config_all
#define self_is_selectKey ibus_chewing_engine_is_selectKey
#define self_set_selKeys_string ibus_chewing_engine_set_selKeys_string
#define self_get_iBusProperty ibus_chewing_engine_get_iBusProperty
#define self_handle_Default ibus_chewing_engine_handle_Default
#define self_determine_input_mode ibus_chewing_engine_determine_input_mode
#define self_force_commit ibus_chewing_engine_force_commit
GType
ibus_chewing_engine_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (IBusChewingEngineClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) ibus_chewing_engine_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (IBusChewingEngine),
			0 /* n_preallocs */,
			(GInstanceInitFunc) ibus_chewing_engine_init,
			NULL
		};

		type = g_type_register_static (IBUS_TYPE_ENGINE, "IBusChewingEngine", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((IBusChewingEngine *)g_object_new(ibus_chewing_engine_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static IBusChewingEngine * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static IBusChewingEngine *
GET_NEW_VARG (const char *first, ...)
{
	IBusChewingEngine *ret;
	va_list ap;
	va_start (ap, first);
	ret = (IBusChewingEngine *)g_object_new_valist (ibus_chewing_engine_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::finalize"
	IBusChewingEngine *self G_GNUC_UNUSED = IBUS_CHEWING_ENGINE (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 137 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	if(self->context) { chewing_delete ((gpointer) self->context); self->context = NULL; }
#line 313 "ibus-chewing-engine.c"
#line 162 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	if(self->table) { ibus_lookup_table_clear ((gpointer) self->table); self->table = NULL; }
#line 316 "ibus-chewing-engine.c"
#line 170 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	if(self->chieng_prop) { g_object_unref ((gpointer) self->chieng_prop); self->chieng_prop = NULL; }
#line 319 "ibus-chewing-engine.c"
#line 178 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	if(self->alnumSize_prop) { g_object_unref ((gpointer) self->alnumSize_prop); self->alnumSize_prop = NULL; }
#line 322 "ibus-chewing-engine.c"
#line 186 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	if(self->settings_prop) { g_object_unref ((gpointer) self->settings_prop); self->settings_prop = NULL; }
#line 325 "ibus-chewing-engine.c"
#line 189 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	if(self->prop_list) { g_object_unref ((gpointer) self->prop_list); self->prop_list = NULL; }
#line 328 "ibus-chewing-engine.c"
#line 196 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	if(self->_priv->pDisplay) { XCloseDisplay ((gpointer) self->_priv->pDisplay); self->_priv->pDisplay = NULL; }
#line 331 "ibus-chewing-engine.c"
}
#undef __GOB_FUNCTION__

#line 209 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_init (IBusChewingEngine * self G_GNUC_UNUSED)
{
#line 339 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,IBUS_TYPE_CHEWING_ENGINE,IBusChewingEnginePrivate);
#line 120 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->context = NULL;
#line 344 "ibus-chewing-engine.c"
#line 120 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->syncCapsLock_local = CHEWING_MODIFIER_SYNC_FROM_KEYBOARD;
#line 347 "ibus-chewing-engine.c"
#line 141 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->setting_dialog = 
	GTK_WIDGET(maker_dialog_new_full(_("Setting"),3,page_labels,1,button_labels,button_responses));
#line 351 "ibus-chewing-engine.c"
#line 141 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->plainZhuyin = FALSE;
#line 354 "ibus-chewing-engine.c"
#line 141 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->inputMode = CHEWING_INPUT_MODE_BYPASS;
#line 357 "ibus-chewing-engine.c"
#line 141 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->forceLowercaseEnglish = FALSE;
#line 360 "ibus-chewing-engine.c"
#line 141 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->numpadAlwaysNumber = TRUE;
#line 363 "ibus-chewing-engine.c"
#line 141 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->_priv->flags = 0;
#line 366 "ibus-chewing-engine.c"
#line 141 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->table = NULL;
#line 369 "ibus-chewing-engine.c"
#line 164 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->chieng_prop = 
        ibus_property_new("chewing_chieng_prop",PROP_TYPE_NORMAL,
		SELF_GET_CLASS(self)->chieng_prop_label_chi,
		NULL, NULL, TRUE, TRUE,
		PROP_STATE_UNCHECKED, NULL)
        ;
#line 377 "ibus-chewing-engine.c"
#line 172 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->alnumSize_prop = 
        ibus_property_new("chewing_alnumSize_prop",PROP_TYPE_NORMAL,
	       	SELF_GET_CLASS(self)->alnumSize_prop_label_half,
	      	NULL, NULL, TRUE, TRUE,
		PROP_STATE_UNCHECKED, NULL);
        ;
#line 385 "ibus-chewing-engine.c"
#line 180 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->settings_prop = 
	ibus_property_new("chewing_settings_prop",PROP_TYPE_TOGGLE,
	       	SELF_GET_CLASS(self)->settings_prop_label,
		PKGDATADIR "/icons/settings.png", NULL, TRUE, TRUE,
		PROP_STATE_UNCHECKED, NULL);
        ;
#line 393 "ibus-chewing-engine.c"
#line 188 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->prop_list = ibus_prop_list_new();
#line 396 "ibus-chewing-engine.c"
#line 188 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->config = NULL;
#line 399 "ibus-chewing-engine.c"
#line 193 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->keymap_us = ibus_keymap_new("us");
#line 402 "ibus-chewing-engine.c"
#line 195 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->_priv->pDisplay = XOpenDisplay( NULL );
#line 405 "ibus-chewing-engine.c"
#line 195 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	self->_priv->key_last = 0;
#line 408 "ibus-chewing-engine.c"
 {
#line 209 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"

          /* initialize the object here */
	G_DEBUG_MSG(1,"[I1] init()");
	if (!(self->_priv->flags & ENGINE_FLAG_INITIALIZED)){
	    maker_dialog_set_verbose_level(MAKER_DIALOG(self->setting_dialog),ibus_chewing_verbose);
	    gchar buf[100];
	    g_snprintf(buf,100,"%s/.chewing",getenv("HOME"));

	    chewing_Init(CHEWING_DATADIR, buf);

	    self->context=chewing_new();
	    chewing_set_ChiEngMode(self->context,CHINESE_MODE);
	    self->inputMode=CHEWING_INPUT_MODE_EDITING;

	    /* init properties */
	    ibus_prop_list_append(self->prop_list,self->chieng_prop);
	    ibus_prop_list_append(self->prop_list,self->alnumSize_prop);
	    ibus_prop_list_append(self->prop_list,self->settings_prop);

	    ibus_chewing_engine_set_flag(self,ENGINE_FLAG_INITIALIZED);
	}
    
#line 433 "ibus-chewing-engine.c"
 }
}
#undef __GOB_FUNCTION__
#line 232 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_class_init (IBusChewingEngineClass * klass G_GNUC_UNUSED)
{
#line 441 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) klass;
	IBusEngineClass *ibus_engine_class = (IBusEngineClass *)klass;

	g_type_class_add_private(klass,sizeof(IBusChewingEnginePrivate));
#line 201 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	klass->chieng_prop_label_chi = ibus_text_new_from_static_string(_("Chi"));
#line 449 "ibus-chewing-engine.c"
#line 202 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	klass->chieng_prop_label_eng = ibus_text_new_from_static_string(_("Eng"));
#line 452 "ibus-chewing-engine.c"
#line 204 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	klass->alnumSize_prop_label_full = ibus_text_new_from_static_string(_("Full"));
#line 455 "ibus-chewing-engine.c"
#line 205 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	klass->alnumSize_prop_label_half = ibus_text_new_from_static_string(_("Half"));
#line 458 "ibus-chewing-engine.c"
#line 207 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	klass->settings_prop_label = ibus_text_new_from_static_string(_("Settings"));
#line 461 "ibus-chewing-engine.c"

	parent_class = g_type_class_ref (IBUS_TYPE_ENGINE);

#line 716 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->reset = ___17_ibus_chewing_engine_reset;
#line 730 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->page_up = ___18_ibus_chewing_engine_page_up;
#line 738 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->page_down = ___19_ibus_chewing_engine_page_down;
#line 745 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->cursor_up = ___1a_ibus_chewing_engine_cursor_up;
#line 752 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->cursor_down = ___1b_ibus_chewing_engine_cursor_down;
#line 759 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->enable = ___1c_ibus_chewing_engine_enable;
#line 779 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->disable = ___1d_ibus_chewing_engine_disable;
#line 789 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->focus_in = ___1e_ibus_chewing_engine_focus_in;
#line 821 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->focus_out = ___1f_ibus_chewing_engine_focus_out;
#line 830 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->property_activate = ___20_ibus_chewing_engine_property_activate;
#line 857 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->property_show = ___21_ibus_chewing_engine_property_show;
#line 866 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	ibus_engine_class->property_hide = ___22_ibus_chewing_engine_property_hide;
#line 489 "ibus-chewing-engine.c"
	g_object_class->finalize = ___finalize;
 {
#line 232 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"

#ifdef IBUS_1_1
	ibus_engine_class->process_key_event = ibus_chewing_engine_process_key_event;
#else
	ibus_engine_class->process_key_event = ibus_chewing_engine_process_key_event_1_2;
#endif /* IBUS_1_1 */
    
#line 500 "ibus-chewing-engine.c"
 }
}
#undef __GOB_FUNCTION__



#line 240 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_load_setting (IBusChewingEngine * self)
{
#line 511 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::load_setting"
#line 240 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 240 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 517 "ibus-chewing-engine.c"
{
#line 240 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
#define BUFFER_SIZE_LOCAL 200
	G_DEBUG_MSG(3,"[I3] load_setting()");
	int i;
	gchar buf[BUFFER_SIZE_LOCAL];
	GValue gValue={0};

	for (i=0; propSpecs[i].valueType!=G_TYPE_INVALID;i++){
	    G_DEBUG_MSG(4,"[I4] load_setting(), i=%d",i);
	    if (ibus_config_get_value(self->config, "engine/Chewing",propSpecs[i].key, &gValue)){
		switch(propSpecs[i].valueType){
		    case G_TYPE_BOOLEAN:
			buf[0]=(g_value_get_boolean(&gValue))? '1' : '0';
			buf[1]='\0';
			break;
		    case G_TYPE_UINT:
			g_snprintf(buf,BUFFER_SIZE_LOCAL,"%u",
				g_value_get_uint(&gValue));
			break;
		    case G_TYPE_INT:
			g_snprintf(buf,BUFFER_SIZE_LOCAL,"%d",
				g_value_get_int(&gValue));
			break;
		    case G_TYPE_STRING:
			g_strlcpy(buf,g_value_get_string(&gValue), BUFFER_SIZE_LOCAL);
			break;
		    default:
			break;

		}
	    }else{
		g_warning("[WW] %s /desktop/ibus/engine/Chewing/%s, %s %s",
			_("Warning: cannot load configure key"),
			propSpecs[i].key,
			(propSpecs[i].defaultValue)? _(" Use default value:") : _(" No default value, skipped.") ,
			(propSpecs[i].defaultValue)? propSpecs[i].defaultValue : ""
			);
		if (propSpecs[i].defaultValue){
		    g_strlcpy(buf,propSpecs[i].defaultValue, BUFFER_SIZE_LOCAL);
		}else{
		    continue;
		}
	    }
	    /* Add property to dialog */
	    maker_dialog_add_property(MAKER_DIALOG(self->setting_dialog),&propSpecs[i],buf,self);
	    maker_dialog_apply_widget_value(MAKER_DIALOG(self->setting_dialog),propSpecs[i].key);
	    g_value_unset(&gValue);
	}

	for (i=0; page_labels[i]!=NULL;i++){
	    maker_dialog_align_labels(MAKER_DIALOG(self->setting_dialog),page_labels[i],1.0f, 0.5f);
	}
	gtk_widget_hide(self->setting_dialog);
#undef BUFFER_SIZE_LOCAL
    }}
#line 575 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 297 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
gboolean 
ibus_chewing_engine_commit (IBusChewingEngine * self)
{
#line 582 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::commit"
#line 297 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 297 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (IBUS_IS_CHEWING_ENGINE (self), (gboolean )0);
#line 588 "ibus-chewing-engine.c"
{
#line 297 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	gboolean commit=chewing_commit_Check(self->context);
	G_DEBUG_MSG(2,"[I2] commit() %s", (commit) ? "TRUE": "FALSE");
	if (commit){
	    IBusText *iText=NULL;

	    gchar *commit_string=chewing_commit_String(self->context);
	    G_DEBUG_MSG(3,"[I3] commit() commit_string=%s", commit_string);

	    iText=ibus_text_new_from_string(commit_string);
	    ibus_engine_commit_text(IBUS_ENGINE(self),iText);
	    g_free(commit_string);
	    g_object_unref(iText);
	}
	return commit;
    }}
#line 607 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 314 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 
ibus_chewing_engine_set_lookup_table_label (IBusChewingEngine * self, const gchar * labels)
{
#line 614 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::set_lookup_table_label"
#line 314 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 314 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 620 "ibus-chewing-engine.c"
{
#line 314 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	int i,len=strlen(labels);
	g_array_set_size(self->table->labels,0);
	for(i=0;i<len;i++){
	    IBusText *text=ibus_text_new_from_unichar((gunichar) labels[i]);
	    ibus_lookup_table_append_label (self->table,text);
	}
    }}
#line 631 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 323 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static gchar * 
ibus_chewing_engine_make_preedit_string (IBusChewingEngine * self, glong * zhuyin_item_written_ptr)
{
#line 638 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::make_preedit_string"
#line 323 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (self != NULL, (gchar * )0);
#line 323 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (IBUS_IS_CHEWING_ENGINE (self), (gchar * )0);
#line 644 "ibus-chewing-engine.c"
{
#line 323 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(4, "[I3] make_preedit_string()");
	gchar *buff_str=chewing_buffer_String(self->context);
	G_DEBUG_MSG(4, "[I4] make_preedit_string(): chewing_buffer_String=%s ",
		buff_str);

	int chiSymbolCursor = chewing_cursor_Current(self->context);
	int zhuyin_count;
        int zhuyin_tone=-1;

	gchar *zhuyin_str=chewing_zuin_String(self->context,&zhuyin_count);
	*zhuyin_item_written_ptr= (glong) zhuyin_count;
	G_DEBUG_MSG(4, "[I4] make_preedit_string(): chewing_zuin_String=%s count=%d inputMode=%d",
		zhuyin_str,zhuyin_count,self->inputMode);

	switch(self->inputMode){
	    case CHEWING_INPUT_MODE_EDITING:
		g_strlcpy(self->_priv->zhuyin_latest,zhuyin_str,ZHUYIN_BUFFER_SIZE);
		zhuyin_tone=0;
		break;
	    case CHEWING_INPUT_MODE_SELECTING:
		zhuyin_tone=get_tone(chewing_get_KBType(self->context),self->_priv->key_last);
		add_tone(self->_priv->zhuyin_latest,zhuyin_tone);
		if (zhuyin_tone>0 ){
		    if (self->plainZhuyin){
			/* Open candidate selection window */
			if (chewing_get_spaceAsSelection(self->context)){
			    chewing_handle_Space(self->context);
			}else{
			    chewing_handle_Down(self->context);
			}
		    }
		}
		break;
	    case CHEWING_INPUT_MODE_SELECTING_DONE:
		self->_priv->zhuyin_latest[0]='\0';
		zhuyin_tone=-1;
		self->inputMode=CHEWING_INPUT_MODE_EDITING;
		break;
	    default:
		/* BYPASS */
		break;

	}

	gsize len=strlen(zhuyin_str)+strlen(buff_str);
	gchar *preeditBuf=g_new(gchar, len+1);
        preeditBuf[0]='\0';
	if (chiSymbolCursor>0){
	    g_utf8_strncpy(preeditBuf, buff_str, chiSymbolCursor);
	}
	gsize zhuyin_start=strlen(preeditBuf);
	/* Inserting zhuyinBuf */
	if (zhuyin_count>0){
	    g_strlcat(preeditBuf,zhuyin_str,len+1);
	}
	/* Append rest chiSymbolBuf */
	g_strlcat(preeditBuf,buff_str+zhuyin_start, len+1);

	g_free(buff_str);
	g_free(zhuyin_str);
	G_DEBUG_MSG(4, "[I4] make_preedit_string(): return preedit=%s zhuyin_latest=%s zhuyin_tone=%d inputMode=%d",
		preeditBuf, self->_priv->zhuyin_latest,zhuyin_tone,self->inputMode);

	return preeditBuf;
    }}
#line 713 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 390 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_show_lookup_table (IBusChewingEngine * self, gboolean isShow)
{
#line 720 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::show_lookup_table"
#line 390 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 390 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 726 "ibus-chewing-engine.c"
{
#line 390 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	ibus_engine_update_lookup_table(IBUS_ENGINE(self),self->table,isShow);
	if (isShow){
	    ibus_engine_show_lookup_table(IBUS_ENGINE(self));
	    ibus_chewing_engine_set_flag(self,ENGINE_FLAG_SHOW_CANDIDATE);
	}else{
	    ibus_engine_hide_lookup_table(IBUS_ENGINE(self));
	    ibus_chewing_engine_clear_flag(self,ENGINE_FLAG_SHOW_CANDIDATE);
	}
    }}
#line 739 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 401 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_update_lookup_table (IBusChewingEngine * self)
{
#line 746 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::update_lookup_table"
#line 401 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 401 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 752 "ibus-chewing-engine.c"
{
#line 401 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	ibus_lookup_table_clear(self->table);
	int choicePerPage=chewing_cand_ChoicePerPage(self->context);
	int i=0;
	char *candidate=NULL;
	IBusText *iText=NULL;

	G_DEBUG_MSG(4,"[I4] update_lookup_table() TotalChoice=%d CurrentPage=%d",
		chewing_cand_TotalChoice(self->context),chewing_cand_CurrentPage(self->context));
	if (chewing_cand_TotalChoice(self->context) >0){
	    chewing_cand_Enumerate(self->context);
	    for(i=0;i<choicePerPage;i++){
		if (chewing_cand_hasNext(self->context)){
		    candidate=chewing_cand_String(self->context);
		    iText=ibus_text_new_from_string (candidate);
		    ibus_lookup_table_append_candidate(self->table,iText);
		    g_free(candidate);
		    g_object_unref (iText);
		}else{
		    break;
		}
	    }
	    self_show_lookup_table(self, TRUE);
	}else{
	    self_show_lookup_table(self, FALSE);
	}
    }}
#line 782 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 429 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_update_aux_string (IBusChewingEngine * self)
{
#line 789 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::update_aux_string"
#line 429 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 429 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 795 "ibus-chewing-engine.c"
{
#line 429 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(4,"[I4] update_aux_string()");
	IBusText *iText=NULL;
	if (chewing_aux_Length(self->context)>0){
	    gchar *aux_string=chewing_aux_String(self->context);
	    iText=ibus_text_new_from_string (aux_string);
	    ibus_engine_update_auxiliary_text(IBUS_ENGINE(self),iText,TRUE);
	    g_object_unref (iText);
	    ibus_engine_show_auxiliary_text(IBUS_ENGINE(self));
	    g_free(aux_string);
	}else{
	    ibus_engine_hide_auxiliary_text(IBUS_ENGINE(self));
//            iText=ibus_text_new_from_string(self->_priv->zhuyin_latest);
//            ibus_engine_update_auxiliary_text(IBUS_ENGINE(self),iText,TRUE);
//            g_object_unref (iText);
//            ibus_engine_show_auxiliary_text(IBUS_ENGINE(self));
	}
    }}
#line 816 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 448 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_update_preedit (IBusChewingEngine * self)
{
#line 823 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::update_preedit"
#line 448 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 448 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 829 "ibus-chewing-engine.c"
{
#line 448 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(5,"[I5] update_preedit()");
	glong zhuyin_item_written;
	gchar *preeditBuf=self_make_preedit_string(self, &zhuyin_item_written);
	IBusText *iText=ibus_text_new_from_string(preeditBuf);
	int chiSymbolCursor = chewing_cursor_Current(self->context);
	G_DEBUG_MSG(4,"[I4] update_preedit() chiSymbolCursor=%d preeditBuf=%s",chiSymbolCursor,preeditBuf );
	g_free(preeditBuf);
	gint cursorRight=chiSymbolCursor + MAX(zhuyin_item_written,1);
	ibus_text_append_attribute (iText, IBUS_ATTR_TYPE_FOREGROUND, 0x00ffffff,
		chiSymbolCursor, cursorRight);
	ibus_text_append_attribute (iText, IBUS_ATTR_TYPE_BACKGROUND, 0x00000000,
		chiSymbolCursor, cursorRight);

	IntervalType it;
	chewing_interval_Enumerate(self->context);
	while(chewing_interval_hasNext(self->context)){
	    chewing_interval_Get(self->context,&it);
	    ibus_text_append_attribute (iText, IBUS_ATTR_TYPE_UNDERLINE, IBUS_ATTR_UNDERLINE_DOUBLE,
		    it.from, it.to);
	}
	ibus_text_append_attribute (iText, IBUS_ATTR_TYPE_UNDERLINE, IBUS_ATTR_UNDERLINE_SINGLE,
		0, -1);
	ibus_engine_update_preedit_text (IBUS_ENGINE(self),iText, chiSymbolCursor, TRUE);
	g_object_unref (iText);
	G_DEBUG_MSG(5,"[I5] update_preedit(): return");
    }}
#line 859 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 476 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
gboolean 
ibus_chewing_engine_update (IBusChewingEngine * self)
{
#line 866 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::update"
#line 476 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 476 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (IBUS_IS_CHEWING_ENGINE (self), (gboolean )0);
#line 872 "ibus-chewing-engine.c"
{
#line 476 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(3,"[I3] update()");

	self_update_aux_string(self);
	self_determine_input_mode(self);
	self_update_preedit(self);
	uint16 *phoneSeq=(chewing_get_phoneSeqLen(self->context)>0)? chewing_get_phoneSeq(self->context): NULL;
	G_DEBUG_MSG(4,"[I4] update() inputMode=%d nPhoneSeq=%d",self->inputMode,
		chewing_get_phoneSeqLen(self->context));
        if (phoneSeq){
	    int i=0;
	    for(i=0;i<chewing_get_phoneSeqLen(self->context);i++){
		G_DEBUG_MSG(5,"[I5] update() phoneSeq[%d]=%x",i,phoneSeq[i]);
	    }
	    free(phoneSeq);
	}
	self_update_lookup_table(self);
	self_commit(self);
	gboolean ret=TRUE;

	if (chewing_keystroke_CheckAbsorb(self->context)){
	    ret=TRUE;
	}else if (chewing_keystroke_CheckIgnore(self->context)){
	    ret=FALSE;
	}
	G_DEBUG_MSG(4,"[I4] update() return %s",(ret)? "TRUE": "FALSE");
	return ret;
    }}
#line 903 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 505 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 
ibus_chewing_engine_refresh_property (IBusChewingEngine * self, const gchar * prop_name)
{
#line 910 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::refresh_property"
#line 505 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 505 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 916 "ibus-chewing-engine.c"
{
#line 505 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(2,"[I2] refresh_property(%s)",prop_name);
	if (strcmp(prop_name,"chewing_chieng_prop")==0){
	    if (chewing_get_ChiEngMode(self->context)){
		/* Chinese  */
		ibus_property_set_label(self->chieng_prop,SELF_GET_CLASS(self)->chieng_prop_label_chi);
	    }else{
		/* English */
		ibus_property_set_label(self->chieng_prop,SELF_GET_CLASS(self)->chieng_prop_label_eng);
	    }
	    ibus_engine_update_property(IBUS_ENGINE(self),self->chieng_prop);
	}else if (strcmp(prop_name,"chewing_alnumSize_prop")==0){
	    if (chewing_get_ShapeMode(self->context)){
		/* Full-Sized Shape */
		ibus_property_set_label(self->alnumSize_prop,SELF_GET_CLASS(self)->alnumSize_prop_label_full);
	    }else{
		/* Half-Sized Shape */
		ibus_property_set_label(self->alnumSize_prop,SELF_GET_CLASS(self)->alnumSize_prop_label_half);
	    }
	    ibus_engine_update_property(IBUS_ENGINE(self),self->alnumSize_prop);
	}
    }}
#line 941 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

/**
 * ibus_chewing_engine_refresh_property_list:
 * @self: this instances.
 *
 * Refresh the property list (language bar).
 **/
#line 534 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 
ibus_chewing_engine_refresh_property_list (IBusChewingEngine * self)
{
#line 954 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::refresh_property_list"
#line 534 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 534 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 960 "ibus-chewing-engine.c"
{
#line 534 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	self_refresh_property(self,"chewing_chieng_prop");

	self_refresh_property(self,"chewing_alnumSize_prop");

	self_refresh_property(self,"chewing_settings_prop");
	if (self->_priv->flags & (ENGINE_FLAG_ENABLED | ENGINE_FLAG_FOCUS_IN)){
	    ibus_engine_register_properties(IBUS_ENGINE(self),self->prop_list);
	    IBUS_ENGINE_GET_CLASS(self)->property_show(IBUS_ENGINE(self),"chewing_chieng_prop");
	    IBUS_ENGINE_GET_CLASS(self)->property_show(IBUS_ENGINE(self),"chewing_alnumSize_prop");
	    IBUS_ENGINE_GET_CLASS(self)->property_show(IBUS_ENGINE(self),"chewing_settings_prop");
	}
    }}
#line 976 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

/**
 * ibus_chewing_engine_hide_property_list:
 * @self: this instances.
 *
 * Hide the property list (language bar).
 **/
#line 554 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 
ibus_chewing_engine_hide_property_list (IBusChewingEngine * self)
{
#line 989 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::hide_property_list"
#line 554 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 554 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 995 "ibus-chewing-engine.c"
{
#line 554 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	IBUS_ENGINE_GET_CLASS(self)->property_hide(IBUS_ENGINE(self),"chewing_chieng_prop");
	IBUS_ENGINE_GET_CLASS(self)->property_hide(IBUS_ENGINE(self),"chewing_alnumSize_prop");
	IBUS_ENGINE_GET_CLASS(self)->property_hide(IBUS_ENGINE(self),"chewing_settings_prop");
    }}
#line 1003 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

/**
 * ibus_chewing_engine_save_config:
 * @self: this instances.
 * @key_suffix: key to be set.
 * @returns: TRUE if successful, FALSE otherwise.
 *
 * Save the property value to disk.
 **/
#line 568 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
gboolean 
ibus_chewing_engine_save_config (IBusChewingEngine * self, const gchar * key_suffix)
{
#line 1018 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::save_config"
#line 568 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 568 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (IBUS_IS_CHEWING_ENGINE (self), (gboolean )0);
#line 1024 "ibus-chewing-engine.c"
{
#line 568 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(1,"[I1] save_config(%s,-)",key_suffix);
	GValue gValue={0};
	maker_dialog_get_widget_value(MAKER_DIALOG(self->setting_dialog),key_suffix,&gValue);
	return ibus_config_set_value (self->config,"engine/Chewing",key_suffix,&gValue);
    }}
#line 1033 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

/**
 * ibus_chewing_engine_save_config_all:
 * @self: this instances.
 * @key_suffix: key to be set.
 * @returns: TRUE if all successful, FALSE otherwise.
 *
 * Save alll property values to disk.
 **/
#line 583 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
gboolean 
ibus_chewing_engine_save_config_all (IBusChewingEngine * self)
{
#line 1048 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::save_config_all"
#line 583 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 583 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (IBUS_IS_CHEWING_ENGINE (self), (gboolean )0);
#line 1054 "ibus-chewing-engine.c"
{
#line 583 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	int i;
	gboolean success=TRUE;
	for(i=0;propSpecs[i].valueType!=G_TYPE_INVALID;i++){
	    if (!self_save_config(self,propSpecs[i].key)){
		success=FALSE;
	    }
	}
	return success;
    }}
#line 1067 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 594 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
gboolean 
ibus_chewing_engine_is_selectKey (IBusChewingEngine * self, guint keyval)
{
#line 1074 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::is_selectKey"
#line 594 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 594 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (IBUS_IS_CHEWING_ENGINE (self), (gboolean )0);
#line 1080 "ibus-chewing-engine.c"
{
#line 594 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	int j;
	for (j=0;j< MAX_SELKEY;j++){
	    if (self->selKeys[j]==keyval){
		return TRUE;
	    }
	}
	return FALSE;
    }}
#line 1092 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 604 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 
ibus_chewing_engine_set_selKeys_string (IBusChewingEngine * self, const gchar * selKeys_str)
{
#line 1099 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::set_selKeys_string"
#line 604 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 604 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 1105 "ibus-chewing-engine.c"
{
#line 604 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	int j;
	int len_min= MIN(strlen(selKeys_str), MAX_SELKEY);
	for (j=0;j< len_min;j++){
	    self->selKeys[j]=(int) selKeys_str[j];
	}
	chewing_set_selKey(self->context, self->selKeys,len_min);
    }}
#line 1116 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 613 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static IBusProperty * 
ibus_chewing_engine_get_iBusProperty (IBusChewingEngine * self, const gchar * prop_name)
{
#line 1123 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::get_iBusProperty"
#line 613 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (self != NULL, (IBusProperty * )0);
#line 613 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_val_if_fail (IBUS_IS_CHEWING_ENGINE (self), (IBusProperty * )0);
#line 1129 "ibus-chewing-engine.c"
{
#line 613 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	if (strcmp(prop_name,"chewing_chieng_prop")==0){
	    return self->chieng_prop;
	}else if (strcmp(prop_name,"chewing_alnumSize_prop")==0){
	    return self->alnumSize_prop;
	}else if (strcmp(prop_name,"chewing_settings_prop")==0){
	    return self->settings_prop;
	}
	G_DEBUG_MSG(2,"[I2] get_iBusProperty(%s): NULL is returned",prop_name);
	return NULL;
    }}
#line 1143 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 625 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
void 
ibus_chewing_engine_handle_Default (IBusChewingEngine * self, guint keyval, gboolean shiftPressed)
{
#line 1150 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::handle_Default"
#line 625 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 625 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 1156 "ibus-chewing-engine.c"
{
#line 625 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(2,"[I2] IBusChewingEngine::handle_Default(-,%u) plainZhuyin=%s inputMode=%d",
		keyval,(self->plainZhuyin)? "TRUE": "FALSE",self->inputMode);
#ifdef EASY_SYMBOL_INPUT_WORK_AROUND
	if (self->_priv->easySymbolInput){
	    /* If shift is pressed, turn on the  easySymbolInput, turn off
	     * otherwise
	     */
	    chewing_set_easySymbolInput(self->context,(shiftPressed)? 1:0);
	}
#endif
	if (self->forceLowercaseEnglish){
	    if (isupper(keyval) && !shiftPressed){
		keyval=tolower(keyval);
	    }else if (islower(keyval) && shiftPressed){
		keyval=toupper(keyval);
	    }
	}
	chewing_handle_Default(self->context,keyval);
	if (self->plainZhuyin){
	    if (self_is_selectKey(self,self->_priv->key_last) &&
		    self->inputMode==CHEWING_INPUT_MODE_SELECTING){
		chewing_handle_Enter(self->context);
		self->inputMode= CHEWING_INPUT_MODE_SELECTING_DONE;
	    }
	}
    }}
#line 1186 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 658 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_determine_input_mode (IBusChewingEngine * self)
{
#line 1193 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::determine_input_mode"
#line 658 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 658 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 1199 "ibus-chewing-engine.c"
{
#line 658 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	gint zhuyin_count=-1;
	gchar *str_ptr=chewing_zuin_String(self->context,&zhuyin_count);
	G_DEBUG_MSG(3, "[I3] determine_input_mode(): chewing_zuin_String=%s count=%d inputMode=%d",
		str_ptr,zhuyin_count,self->inputMode);

	int zhuyin_tone=-1;
	if (zhuyin_count>0){
	    /* Incomplete Character*/
	    self->inputMode=CHEWING_INPUT_MODE_EDITING;
	}else{
	    /* Character/Phrase is completed. */
	    if (self->inputMode==CHEWING_INPUT_MODE_EDITING){
		/* In EDITING mode */
		zhuyin_tone=get_tone(chewing_get_KBType(self->context),self->_priv->key_last);
		if (zhuyin_tone>0 ){
		    /* Enter SELECTING mode */
		    self->inputMode=CHEWING_INPUT_MODE_SELECTING;
		}
	    }else if (self->inputMode==CHEWING_INPUT_MODE_SELECTING_DONE){
		/* In SELECTING_DONE mode */
		/* One of selection keys is pressed */
	    }else{
		/* In SELECTING mode */
	    }
	}

	if (chewing_buffer_Len(self->context)+ zhuyin_count==0){
	    /* If preedit buffer is empty, then enter BYPASS mode.*/
	    /* So cursor keys can be used freely. */
	    self->inputMode=CHEWING_INPUT_MODE_BYPASS;
	}
	g_free(str_ptr);
	G_DEBUG_MSG(3, "[I3] determine_input_mode() return: zhuyin_latest=%s zhuyin_tone=%d inputMode=%d",
		self->_priv->zhuyin_latest,zhuyin_tone,self->inputMode);
    }}
#line 1238 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 695 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
ibus_chewing_engine_force_commit (IBusChewingEngine * self)
{
#line 1245 "ibus-chewing-engine.c"
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::force_commit"
#line 695 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (self != NULL);
#line 695 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	g_return_if_fail (IBUS_IS_CHEWING_ENGINE (self));
#line 1251 "ibus-chewing-engine.c"
{
#line 695 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(3,"[I3] force_commit() buffer=%d, commit=%d",
		chewing_buffer_Check(self->context),chewing_commit_Check(self->context));
	/* Remove the incomplete zhuyin symbol */
	if (self->inputMode==CHEWING_INPUT_MODE_EDITING)
	    chewing_handle_Esc(self->context);
	if (chewing_buffer_Check(self->context)){
	    if (!chewing_commit_Check(self->context)){
		/* Close candidate window */
		if (self->_priv->flags & ENGINE_FLAG_SHOW_CANDIDATE){
		    chewing_handle_Esc(self->context);
		}
		chewing_handle_Enter(self->context);
	    }
	    self_update(self);
	}
    }}
#line 1271 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__

#line 716 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___17_ibus_chewing_engine_reset (IBusEngine * engine G_GNUC_UNUSED)
#line 1277 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->reset) \
		(* IBUS_ENGINE_CLASS(parent_class)->reset)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::reset"
{
#line 717 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(1,"[I1] reset");
	Self *self=SELF(engine);
	ibus_lookup_table_clear(self->table);
	/* Save KBType type, becaue chewing_Reset() will reset it to default.
	 */
	int kbType=chewing_get_KBType(self->context);
	chewing_Reset(self->context);
	chewing_set_KBType(self->context,kbType);
	ibus_engine_hide_auxiliary_text(IBUS_ENGINE(engine));
	ibus_engine_hide_lookup_table(IBUS_ENGINE(self));
    }}
#line 1297 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 730 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___18_ibus_chewing_engine_page_up (IBusEngine * engine G_GNUC_UNUSED)
#line 1304 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->page_up) \
		(* IBUS_ENGINE_CLASS(parent_class)->page_up)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::page_up"
{
#line 731 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	Self *self=SELF(engine);
	chewing_handle_PageUp(self->context);
	self_update(self);
    }}
#line 1317 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 738 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___19_ibus_chewing_engine_page_down (IBusEngine * engine G_GNUC_UNUSED)
#line 1324 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->page_down) \
		(* IBUS_ENGINE_CLASS(parent_class)->page_down)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::page_down"
{
#line 739 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	Self *self=SELF(engine);
	chewing_handle_PageDown(self->context);
	self_update(self);
    }}
#line 1337 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 745 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___1a_ibus_chewing_engine_cursor_up (IBusEngine * engine G_GNUC_UNUSED)
#line 1344 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->cursor_up) \
		(* IBUS_ENGINE_CLASS(parent_class)->cursor_up)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::cursor_up"
{
#line 746 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	Self *self=SELF(engine);
	chewing_handle_Up(self->context);
	self_update(self);
    }}
#line 1357 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 752 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___1b_ibus_chewing_engine_cursor_down (IBusEngine * engine G_GNUC_UNUSED)
#line 1364 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->cursor_down) \
		(* IBUS_ENGINE_CLASS(parent_class)->cursor_down)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::cursor_down"
{
#line 753 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	Self *self=SELF(engine);
	chewing_handle_Down(self->context);
	self_update(self);
    }}
#line 1377 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 759 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___1c_ibus_chewing_engine_enable (IBusEngine * engine G_GNUC_UNUSED)
#line 1384 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->enable) \
		(* IBUS_ENGINE_CLASS(parent_class)->enable)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::enable"
{
#line 760 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(2,"[I2] enable()");
        Self *self=SELF(engine);

        if (!self->config){

            /* connections_list is not avail in init, so we put it here */
	    GList  *connections_list=ibus_service_get_connections(IBUS_SERVICE(engine));
	    g_assert(connections_list);
	    g_assert(connections_list->data);
	    IBusConnection *iConnection=(IBusConnection *) connections_list->data;
	    self->config=ibus_config_new(iConnection);
	    self_load_setting(self);
        }
	self_refresh_property_list(self);
	self->inputMode=CHEWING_INPUT_MODE_EDITING;
	ibus_chewing_engine_set_flag(self, ENGINE_FLAG_ENABLED);
    }}
#line 1410 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 779 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___1d_ibus_chewing_engine_disable (IBusEngine * engine G_GNUC_UNUSED)
#line 1417 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->disable) \
		(* IBUS_ENGINE_CLASS(parent_class)->disable)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::disable"
{
#line 780 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(2,"[I2] disable()");
	Self *self=SELF(engine);
	self_force_commit(self);
	self_hide_property_list(self);
	self->inputMode=CHEWING_INPUT_MODE_BYPASS;
	ibus_chewing_engine_clear_flag(self,ENGINE_FLAG_ENABLED);
    }}
#line 1433 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 789 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___1e_ibus_chewing_engine_focus_in (IBusEngine * engine G_GNUC_UNUSED)
#line 1440 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->focus_in) \
		(* IBUS_ENGINE_CLASS(parent_class)->focus_in)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::focus_in"
{
#line 790 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	Self *self=SELF(engine);

	/* Sync Caps_Lock and ChiEngMode */
	guint modifiers=keyModifier_get(self->_priv->pDisplay);
	gint caps_is_lock=(modifiers & IBUS_LOCK_MASK)!=0;
	G_DEBUG_MSG(2,"[I2] focus_in(): flags=%d ChiEng=%d IBUS_LOCK=%d",
		self->_priv->flags,
		chewing_get_ChiEngMode(self->context),caps_is_lock);
	if (chewing_get_ChiEngMode(self->context)==caps_is_lock){
	    /* Caps_lock and ChiEngMode does not agree each other */
	    switch(self->syncCapsLock_local){
		case CHEWING_MODIFIER_SYNC_FROM_KEYBOARD:
		    chewing_set_ChiEngMode(self->context,!caps_is_lock);
		    break;
		case CHEWING_MODIFIER_SYNC_FROM_IM:
		    /* fake event won't go through process_key_event */
		    key_send_fake_event(IBUS_Caps_Lock,self->_priv->pDisplay);
		    break;
		default:
		    g_warning("Caps_lock and ChiEngMode does not agree each other!");
		    break;

	    }
	}
	self_refresh_property_list(self);
	self_update_preedit(self);
	ibus_chewing_engine_set_flag(self, ENGINE_FLAG_FOCUS_IN);
	G_DEBUG_MSG(4,"[I4] focus_in(): return");
    }}
#line 1478 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 821 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___1f_ibus_chewing_engine_focus_out (IBusEngine * engine G_GNUC_UNUSED)
#line 1485 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->focus_out) \
		(* IBUS_ENGINE_CLASS(parent_class)->focus_out)(___engine); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::focus_out"
{
#line 822 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	Self *self=SELF(engine);
	G_DEBUG_MSG(2,"[I2] focus_out(): flags=%d",self->_priv->flags);
	self_force_commit(self);
	ibus_chewing_engine_clear_flag(self, ENGINE_FLAG_FOCUS_IN);
	G_DEBUG_MSG(4,"[I4] focus_out(): return");
    }}
#line 1500 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 830 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___20_ibus_chewing_engine_property_activate (IBusEngine * engine G_GNUC_UNUSED, const gchar * prop_name, guint prop_state)
#line 1507 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine,___prop_name,___prop_state) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->property_activate) \
		(* IBUS_ENGINE_CLASS(parent_class)->property_activate)(___engine,___prop_name,___prop_state); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::property_activate"
{
#line 831 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(2,"[I2] property_activate(-, %s, %u)", prop_name, prop_state);
	Self *self=SELF(engine);
	gboolean needRefresh=TRUE;
	if (strcmp(prop_name,"chewing_chieng_prop")==0){
	    /* Toggle Chinese <-> English */
	    chewing_set_ChiEngMode(self->context, !chewing_get_ChiEngMode(self->context));
	}else if (strcmp(prop_name,"chewing_alnumSize_prop")==0){
	    /* Toggle Full <-> Half */
	    chewing_set_ShapeMode(self->context, !chewing_get_ShapeMode(self->context));
	}else if (strcmp(prop_name,"chewing_settings_prop")==0){
	    if (self->settings_prop->state==PROP_STATE_UNCHECKED){
		if (gtk_dialog_run(GTK_DIALOG(self->setting_dialog))==GTK_RESPONSE_OK){
		    self_save_config_all(self);
		}
		gtk_widget_hide(self->setting_dialog);
		self->settings_prop->state=PROP_STATE_UNCHECKED;
	    }
	}else{
	    G_DEBUG_MSG(2,"[I2] property_activate(-, %s, %u) not recognized",prop_name, prop_state);
	    needRefresh=FALSE;
	}
	if (needRefresh)
	    self_refresh_property(self,prop_name);
    }}
#line 1540 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 857 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___21_ibus_chewing_engine_property_show (IBusEngine * engine G_GNUC_UNUSED, const gchar * prop_name)
#line 1547 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine,___prop_name) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->property_show) \
		(* IBUS_ENGINE_CLASS(parent_class)->property_show)(___engine,___prop_name); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::property_show"
{
#line 858 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(2,"[I2] property_show(-, %s)",prop_name);
	Self *self=SELF(engine);
	IBusProperty *prop=self_get_iBusProperty(self, prop_name);
	ibus_property_set_visible(prop,TRUE);
	ibus_engine_update_property(engine,prop);
    }}
#line 1562 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 866 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
static void 
___22_ibus_chewing_engine_property_hide (IBusEngine * engine G_GNUC_UNUSED, const gchar * prop_name)
#line 1569 "ibus-chewing-engine.c"
#define PARENT_HANDLER(___engine,___prop_name) \
	{ if(IBUS_ENGINE_CLASS(parent_class)->property_hide) \
		(* IBUS_ENGINE_CLASS(parent_class)->property_hide)(___engine,___prop_name); }
{
#define __GOB_FUNCTION__ "IBus:Chewing:Engine::property_hide"
{
#line 867 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"
	
	G_DEBUG_MSG(2,"[I2] property_hide(-, %s)",prop_name);
	Self *self=SELF(engine);
	IBusProperty *prop=self_get_iBusProperty(self, prop_name);
	ibus_property_set_visible(prop,FALSE);
	ibus_engine_update_property(engine,prop);
    }}
#line 1584 "ibus-chewing-engine.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 876 "/home/dchen/ibus-chewing/src/IBusChewingEngine.gob"

#include "IBusChewingEngine-keys.c"

#line 1592 "ibus-chewing-engine.c"
