/* 
* This is part of the source for i855crt driver
* copyright(c) Merello Andrea 2004
* <andreamrl@tiscali.it>
*
* this is released under the terms of GPL (General Public Licence)
*
* some parts of this driver are taken/based  from/on the 'i810switch' driver
* many thanks to the original author.
*
* some parts of this driver are taken/based  from/on the 855GM-fb driver
* many thanks to the original author.
* 
* plase note that this driver is still experimental
*
* feedbacks are VERY appreciated
*/

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "vmodes.h"
#define MAXBUF 512
#define MAXVAL 15

#define fatal() {fprintf(stderr,"Fatal: Parse error in conf file\n");return 0;}

double parsed(char *c)
{
	int i,f,d,frac,j;
	for (i=0;i<strlen(c);i++)
		if(c[i]=='.') break;
	if(c[i]=='.') 
	{	
		i++;
		f=atoi(i+c);
		d=atoi(c);
		
		frac=1;
	
		
		for(j=0,frac=1;j<strlen(c+i);j++) frac=frac*10;

	//	printf("%d %d %d\n",d,f,frac);
		return (float)d +(float)f /(double)frac;
	}
	else return (double)atoi(c);
}

short getVMode(char* name, struct vmode *mode)
{
	int fd;
	char buf[MAXBUF];
	short eof=0;
	int i;
	fd=open ("~/.i855crt.conf",O_RDONLY);
	if(-1==fd)fd=open ("/etc/i855crt.conf",O_RDONLY);
	if(-1==fd)fd=open ("/etc/X11/i855crt.conf",O_RDONLY);
	if(-1==fd)fd=open ("./i855crt.conf",O_RDONLY);
	if(-1==fd)
	{
	 	fprintf(stderr,"No config file found\n");
		return 0;
	}
	for(;;)
	{	
		if(eof) 
		{
			fprintf(stderr,"Couldn't find video mode %s\n",name);
			return 0;	
		}
		if((eof=(1!=read(fd,buf,1)))) continue;
		
		switch (*buf)
		{
			case '#':
			while(!(eof=(read(fd,buf,1)!=1)))
				if(*buf=='\n')break;
			continue;
			break;//--!
			
			case '"':
			for(i=0;!(eof=(read(fd,buf+i,1)!=1));i++)
			{
				if(buf[i]=='\n')
				{
					fprintf(stderr,"ignoring parse error in config file\n");
					break;
				}
				if(buf[i]=='"')
				{
					if(0==strncmp(buf,name,i) && i==strlen(name)) //found
					{
						printf("found mode %s\n",name);
						char values[MAXVAL][9];
						for(i=0;i<9;i++)
						{	int j=0;
							while(!(eof=(read(fd,buf+j,1)!=1)))
							{
								if(buf[j]!=' '&&j<MAXVAL) //allow precision loss
									j++;
								else if(j!=0) break;
								
							}
							if(eof) fatal();
							buf[j]='\0';
							strcpy(values[i],buf);
							//printf("%s ",values[i]);
						}//H,V act start end tot
						
						mode->hactive=atoi(values[1]);
						mode->hsyncstart=atoi(values[2]);
						mode->hsyncend=atoi(values[3]);
						mode->htotal=atoi(values[4]);
						
						mode->vactive=atoi(values[5]);
						mode->vsyncstart=atoi(values[6]);
						mode->vsyncend=atoi(values[7]);
						mode->vtotal=atoi(values[8]);
						
						mode->clock=parsed(values[0]);
						//fprintf(stderr,"%s %f\n",values[0],mode->clock);
						close(fd);
						return 1;
					}
					else while(!(eof=(read(fd,buf,1)!=1)))
						if(*buf=='\n') break;
						
					break;
				}
			}
			continue;
			break;
		}
				
	}
}


