/* utils.c generated by valac 0.16.0, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "gwibber.h"
#include <time.h>
#include <glib/gi18n-lib.h>


#define GWIBBER_TYPE_DBUS_IFACE (gwibber_dbus_iface_get_type ())
#define GWIBBER_DBUS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TYPE_DBUS_IFACE, GwibberDBusIface))
#define GWIBBER_IS_DBUS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TYPE_DBUS_IFACE))
#define GWIBBER_DBUS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GWIBBER_TYPE_DBUS_IFACE, GwibberDBusIfaceIface))

typedef struct _GwibberDBusIface GwibberDBusIface;
typedef struct _GwibberDBusIfaceIface GwibberDBusIfaceIface;

#define GWIBBER_TYPE_DBUS_IFACE_PROXY (gwibber_dbus_iface_proxy_get_type ())
typedef GDBusProxy GwibberDBusIfaceProxy;
typedef GDBusProxyClass GwibberDBusIfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GwibberUtilsCheckNamesData GwibberUtilsCheckNamesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GwibberUtilsOnReadyData GwibberUtilsOnReadyData;
typedef struct _GwibberUtilsDoSetupData GwibberUtilsDoSetupData;

struct _GwibberDBusIfaceIface {
	GTypeInterface parent_iface;
	void (*list_names) (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _GwibberUtilsPrivate {
	GwibberDBusIface* bus;
	gchar* interface_name;
};

struct _GwibberUtilsCheckNamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberUtils* self;
	gchar** names;
	gint names_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** name_collection;
	gint name_collection_length1;
	gint _name_collection_size_;
	gint name_it;
	gchar* _tmp1_;
	gchar* name;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
};

struct _GwibberUtilsOnReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberUtils* self;
	gboolean result;
	GwibberDBusIface* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** n;
	gint n_length1;
	gint _n_size_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_;
};

struct _GwibberUtilsDoSetupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GwibberUtils* self;
	gchar* name;
	GwibberDBusIface* _tmp0_;
	GwibberDBusIface* _tmp1_;
	GwibberDBusIface* _tmp2_;
	GError * _inner_error_;
};


static gpointer gwibber_utils_parent_class = NULL;

GType gwibber_dbus_iface_proxy_get_type (void) G_GNUC_CONST;
guint gwibber_dbus_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gwibber_dbus_iface_get_type (void) G_GNUC_CONST;
void gwibber_dbus_iface_list_names (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** gwibber_dbus_iface_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gwibber_dbus_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void gwibber_dbus_iface_proxy_list_names_async (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** gwibber_dbus_iface_proxy_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void gwibber_dbus_iface_proxy_gwibber_dbus_iface_interface_init (GwibberDBusIfaceIface* iface);
static void _dbus_gwibber_dbus_iface_list_names (GwibberDBusIface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_gwibber_dbus_iface_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void gwibber_dbus_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* gwibber_dbus_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean gwibber_dbus_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_gwibber_dbus_iface_name_owner_changed (GObject* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer* _data);
static void _gwibber_dbus_iface_unregister_object (gpointer user_data);
#define GWIBBER_UTILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_TYPE_UTILS, GwibberUtilsPrivate))
enum  {
	GWIBBER_UTILS_DUMMY_PROPERTY
};
static void gwibber_utils_on_name_owner_changed (GwibberUtils* self, const gchar* name, const gchar* old_owner, const gchar* new_owner);
static void gwibber_utils_check_names_data_free (gpointer _data);
static void gwibber_utils_check_names (GwibberUtils* self, gchar** names, int names_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_utils_check_names_finish (GwibberUtils* self, GAsyncResult* _res_);
static gboolean gwibber_utils_check_names_co (GwibberUtilsCheckNamesData* _data_);
static void gwibber_utils_on_ready_data_free (gpointer _data);
static void gwibber_utils_on_ready (GwibberUtils* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean gwibber_utils_on_ready_finish (GwibberUtils* self, GAsyncResult* _res_);
static gboolean gwibber_utils_on_ready_co (GwibberUtilsOnReadyData* _data_);
static void gwibber_utils_on_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gwibber_utils_do_setup_data_free (gpointer _data);
static void gwibber_utils_do_setup (GwibberUtils* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gwibber_utils_do_setup_finish (GwibberUtils* self, GAsyncResult* _res_, GError** error);
static gboolean gwibber_utils_do_setup_co (GwibberUtilsDoSetupData* _data_);
static void gwibber_utils_do_setup_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _gwibber_utils_on_name_owner_changed_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer self);
void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error);
static void gwibber_utils_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_list_names_result = {-1, "result", "as"};
static const GDBusArgInfo * const _gwibber_dbus_iface_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _gwibber_dbus_iface_dbus_arg_info_list_names_out[] = {&_gwibber_dbus_iface_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _gwibber_dbus_iface_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_gwibber_dbus_iface_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_gwibber_dbus_iface_dbus_arg_info_list_names_out)};
static const GDBusMethodInfo * const _gwibber_dbus_iface_dbus_method_info[] = {&_gwibber_dbus_iface_dbus_method_info_list_names, NULL};
static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_name_owner_changed_name = {-1, "name", "s"};
static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_name_owner_changed_oldowner = {-1, "oldowner", "s"};
static const GDBusArgInfo _gwibber_dbus_iface_dbus_arg_info_name_owner_changed_newowner = {-1, "newowner", "s"};
static const GDBusArgInfo * const _gwibber_dbus_iface_dbus_arg_info_name_owner_changed[] = {&_gwibber_dbus_iface_dbus_arg_info_name_owner_changed_name, &_gwibber_dbus_iface_dbus_arg_info_name_owner_changed_oldowner, &_gwibber_dbus_iface_dbus_arg_info_name_owner_changed_newowner, NULL};
static const GDBusSignalInfo _gwibber_dbus_iface_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_gwibber_dbus_iface_dbus_arg_info_name_owner_changed)};
static const GDBusSignalInfo * const _gwibber_dbus_iface_dbus_signal_info[] = {&_gwibber_dbus_iface_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _gwibber_dbus_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gwibber_dbus_iface_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_gwibber_dbus_iface_dbus_method_info), (GDBusSignalInfo **) (&_gwibber_dbus_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_gwibber_dbus_iface_dbus_property_info)};
static const GDBusInterfaceVTable _gwibber_dbus_iface_dbus_interface_vtable = {gwibber_dbus_iface_dbus_interface_method_call, gwibber_dbus_iface_dbus_interface_get_property, gwibber_dbus_iface_dbus_interface_set_property};

void gwibber_dbus_iface_list_names (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GWIBBER_DBUS_IFACE_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
}


gchar** gwibber_dbus_iface_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return GWIBBER_DBUS_IFACE_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void gwibber_dbus_iface_base_init (GwibberDBusIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", GWIBBER_TYPE_DBUS_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	}
}


GType gwibber_dbus_iface_get_type (void) {
	static volatile gsize gwibber_dbus_iface_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_dbus_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberDBusIfaceIface), (GBaseInitFunc) gwibber_dbus_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gwibber_dbus_iface_type_id;
		gwibber_dbus_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "GwibberDBusIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gwibber_dbus_iface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (gwibber_dbus_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gwibber_dbus_iface_proxy_get_type);
		g_type_set_qdata (gwibber_dbus_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (gwibber_dbus_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gwibber_dbus_iface_register_object);
		g_once_init_leave (&gwibber_dbus_iface_type_id__volatile, gwibber_dbus_iface_type_id);
	}
	return gwibber_dbus_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (GwibberDBusIfaceProxy, gwibber_dbus_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GWIBBER_TYPE_DBUS_IFACE, gwibber_dbus_iface_proxy_gwibber_dbus_iface_interface_init) )
static void gwibber_dbus_iface_proxy_class_init (GwibberDBusIfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = gwibber_dbus_iface_proxy_g_signal;
}


static void _dbus_handle_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp57_;
	gchar* oldowner = NULL;
	GVariant* _tmp58_;
	gchar* newowner = NULL;
	GVariant* _tmp59_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp57_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp57_, NULL);
	g_variant_unref (_tmp57_);
	_tmp58_ = g_variant_iter_next_value (&_arguments_iter);
	oldowner = g_variant_dup_string (_tmp58_, NULL);
	g_variant_unref (_tmp58_);
	_tmp59_ = g_variant_iter_next_value (&_arguments_iter);
	newowner = g_variant_dup_string (_tmp59_, NULL);
	g_variant_unref (_tmp59_);
	g_signal_emit_by_name (self, "name-owner-changed", name, oldowner, newowner);
	_g_free0 (name);
	_g_free0 (oldowner);
	_g_free0 (newowner);
}


static void gwibber_dbus_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_gwibber_dbus_iface_name_owner_changed ((GwibberDBusIface*) proxy, parameters);
	}
}


static void gwibber_dbus_iface_proxy_init (GwibberDBusIfaceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void gwibber_dbus_iface_proxy_list_names_async (GwibberDBusIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar** gwibber_dbus_iface_proxy_list_names_finish (GwibberDBusIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp60_;
	gchar** _tmp61_;
	int _tmp61__length;
	int _tmp61__size;
	int _tmp61__length1;
	GVariantIter _tmp62_;
	GVariant* _tmp63_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp60_ = g_variant_iter_next_value (&_reply_iter);
	_tmp61_ = g_new (gchar*, 5);
	_tmp61__length = 0;
	_tmp61__size = 4;
	_tmp61__length1 = 0;
	g_variant_iter_init (&_tmp62_, _tmp60_);
	for (; (_tmp63_ = g_variant_iter_next_value (&_tmp62_)) != NULL; _tmp61__length1++) {
		if (_tmp61__size == _tmp61__length) {
			_tmp61__size = 2 * _tmp61__size;
			_tmp61_ = g_renew (gchar*, _tmp61_, _tmp61__size + 1);
		}
		_tmp61_[_tmp61__length++] = g_variant_dup_string (_tmp63_, NULL);
		g_variant_unref (_tmp63_);
	}
	_result_length1 = _tmp61__length1;
	_tmp61_[_tmp61__length] = NULL;
	_result = _tmp61_;
	g_variant_unref (_tmp60_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void gwibber_dbus_iface_proxy_gwibber_dbus_iface_interface_init (GwibberDBusIfaceIface* iface) {
	iface->list_names = gwibber_dbus_iface_proxy_list_names_async;
	iface->list_names_finish = gwibber_dbus_iface_proxy_list_names_finish;
}


static void _dbus_gwibber_dbus_iface_list_names (GwibberDBusIface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	gwibber_dbus_iface_list_names (self, (GAsyncReadyCallback) _dbus_gwibber_dbus_iface_list_names_ready, invocation);
}


static void _dbus_gwibber_dbus_iface_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp64_;
	GVariantBuilder _tmp65_;
	int _tmp66_;
	invocation = _user_data_;
	result = gwibber_dbus_iface_list_names_finish ((GwibberDBusIface*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp64_ = result;
	g_variant_builder_init (&_tmp65_, G_VARIANT_TYPE ("as"));
	for (_tmp66_ = 0; _tmp66_ < result_length1; _tmp66_++) {
		g_variant_builder_add_value (&_tmp65_, g_variant_new_string (*_tmp64_));
		_tmp64_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp65_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void gwibber_dbus_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListNames") == 0) {
		_dbus_gwibber_dbus_iface_list_names (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* gwibber_dbus_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean gwibber_dbus_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_gwibber_dbus_iface_name_owner_changed (GObject* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (oldowner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (newowner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}


guint gwibber_dbus_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gwibber_dbus_iface_dbus_interface_info), &_gwibber_dbus_iface_dbus_interface_vtable, data, _gwibber_dbus_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_gwibber_dbus_iface_name_owner_changed, data);
	return result;
}


static void _gwibber_dbus_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gwibber_dbus_iface_name_owner_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void gwibber_utils_on_name_owner_changed (GwibberUtils* self, const gchar* name, const gchar* old_owner, const gchar* new_owner) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (old_owner != NULL);
	g_return_if_fail (new_owner != NULL);
	_tmp0_ = name;
	_tmp1_ = self->priv->interface_name;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		gboolean _tmp5_;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gboolean _tmp10_;
		_tmp3_ = new_owner;
		if (g_strcmp0 (_tmp3_, "") != 0) {
			const gchar* _tmp4_;
			_tmp4_ = old_owner;
			_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp5_ = _tmp2_;
		if (_tmp5_) {
			const gchar* _tmp6_;
			_tmp6_ = name;
			g_debug ("utils.vala:48: %s is available", _tmp6_);
			g_signal_emit_by_name (self, "available", TRUE);
		}
		_tmp8_ = old_owner;
		if (g_strcmp0 (_tmp8_, "") != 0) {
			const gchar* _tmp9_;
			_tmp9_ = new_owner;
			_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			const gchar* _tmp11_;
			g_signal_emit_by_name (self, "available", FALSE);
			_tmp11_ = name;
			g_debug ("utils.vala:54: %s is no longer available", _tmp11_);
		}
	}
}


static void gwibber_utils_check_names_data_free (gpointer _data) {
	GwibberUtilsCheckNamesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GwibberUtilsCheckNamesData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gwibber_utils_check_names (GwibberUtils* self, gchar** names, int names_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberUtilsCheckNamesData* _data_;
	GwibberUtils* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (GwibberUtilsCheckNamesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_utils_check_names);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_utils_check_names_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = names;
	_tmp1__length1 = names_length1;
	_data_->names = _tmp1_;
	_data_->names_length1 = _tmp1__length1;
	gwibber_utils_check_names_co (_data_);
}


static void gwibber_utils_check_names_finish (GwibberUtils* self, GAsyncResult* _res_) {
	GwibberUtilsCheckNamesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean gwibber_utils_check_names_co (GwibberUtilsCheckNamesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->names;
	_data_->_tmp0__length1 = _data_->names_length1;
	{
		_data_->name_collection_length1 = 0;
		_data_->_name_collection_size_ = 0;
		_data_->name_collection = _data_->_tmp0_;
		_data_->name_collection_length1 = _data_->_tmp0__length1;
		for (_data_->name_it = 0; _data_->name_it < _data_->_tmp0__length1; _data_->name_it = _data_->name_it + 1) {
			_data_->_tmp1_ = g_strdup (_data_->name_collection[_data_->name_it]);
			_data_->name = _data_->_tmp1_;
			{
				_data_->_tmp2_ = _data_->name;
				_data_->_tmp3_ = _data_->self->priv->interface_name;
				if (g_strcmp0 (_data_->_tmp2_, _data_->_tmp3_) == 0) {
					g_signal_emit_by_name (_data_->self, "available", TRUE);
					_g_free0 (_data_->name);
					break;
				}
				_g_free0 (_data_->name);
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void gwibber_utils_on_ready_data_free (gpointer _data) {
	GwibberUtilsOnReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GwibberUtilsOnReadyData, _data_);
}


static void gwibber_utils_on_ready (GwibberUtils* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberUtilsOnReadyData* _data_;
	GwibberUtils* _tmp0_;
	_data_ = g_slice_new0 (GwibberUtilsOnReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_utils_on_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_utils_on_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	gwibber_utils_on_ready_co (_data_);
}


static gboolean gwibber_utils_on_ready_finish (GwibberUtils* self, GAsyncResult* _res_) {
	gboolean result;
	GwibberUtilsOnReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void gwibber_utils_on_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GwibberUtilsOnReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gwibber_utils_on_ready_co (_data_);
}


static gboolean gwibber_utils_on_ready_co (GwibberUtilsOnReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->bus;
		_data_->_tmp1_ = 0;
		_data_->_state_ = 1;
		gwibber_dbus_iface_list_names (_data_->_tmp0_, gwibber_utils_on_ready_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = gwibber_dbus_iface_list_names_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error_);
		_data_->n = _data_->_tmp2_;
		_data_->n_length1 = _data_->_tmp1_;
		_data_->_n_size_ = _data_->n_length1;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch63_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		gwibber_utils_check_names (_data_->self, _data_->n, _data_->n_length1, NULL, NULL);
		_data_->n = (_vala_array_free (_data_->n, _data_->n_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally63;
	__catch63_g_io_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("utils.vala:75: Can't list: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally63:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


gchar* gwibber_utils_generate_time_string (GwibberUtils* self, guint t) {
	gchar* result = NULL;
	time_t _tmp0_;
	time_t _t;
	time_t _tmp1_;
	struct tm _tmp2_ = {0};
	struct tm n;
	time_t _tmp3_;
	struct tm _tmp4_ = {0};
	struct tm lt;
	struct tm _tmp5_;
	gint _tmp6_;
	time_t _tmp7_ = 0;
	gint now;
	gint _tmp8_;
	guint _tmp9_;
	gint d;
	gint _tmp10_;
	gint _tmp13_;
	gint _tmp18_;
	gint _tmp23_;
	const gchar* _tmp24_ = NULL;
	gint _tmp25_;
	gchar* _tmp26_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = time (NULL);
	_t = _tmp0_;
	_tmp1_ = _t;
	g_time_gm (_tmp1_, &_tmp2_);
	n = _tmp2_;
	_tmp3_ = _t;
	g_time_local (_tmp3_, &_tmp4_);
	lt = _tmp4_;
	_tmp5_ = lt;
	_tmp6_ = _tmp5_.tm_isdst;
	n.tm_isdst = _tmp6_;
	_tmp7_ = mktime (&n);
	now = (gint) _tmp7_;
	_tmp8_ = now;
	_tmp9_ = t;
	d = (gint) (_tmp8_ - _tmp9_);
	_tmp10_ = d;
	if (_tmp10_ < 60) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp11_ = _ ("a few seconds ago");
		_tmp12_ = g_strdup (_tmp11_);
		result = _tmp12_;
		return result;
	}
	_tmp13_ = d;
	if (_tmp13_ < 3600) {
		gint _tmp14_;
		const gchar* _tmp15_ = NULL;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp14_ = d;
		_tmp15_ = ngettext ("%i minute ago", "%i minutes ago", (gulong) (((gint) _tmp14_) / 60));
		_tmp16_ = d;
		_tmp17_ = g_strdup_printf (_tmp15_, _tmp16_ / 60);
		result = _tmp17_;
		return result;
	}
	_tmp18_ = d;
	if (_tmp18_ < 86400) {
		gint _tmp19_;
		const gchar* _tmp20_ = NULL;
		gint _tmp21_;
		gchar* _tmp22_ = NULL;
		_tmp19_ = d;
		_tmp20_ = ngettext ("%i hour ago", "%i hours ago", (gulong) (((gint) _tmp19_) / 3600));
		_tmp21_ = d;
		_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_ / 3600);
		result = _tmp22_;
		return result;
	}
	_tmp23_ = d;
	_tmp24_ = ngettext ("%i day ago", "%i days ago", (gulong) (((gint) _tmp23_) / 86400));
	_tmp25_ = d;
	_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_ / 86400);
	result = _tmp26_;
	return result;
}


gchar* gwibber_utils_avatar_path (GwibberUtils* self, const gchar* url) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _avatar_cache_image;
	const gchar* _tmp6_;
	GFile* _tmp7_ = NULL;
	GFile* file;
	GFile* _tmp8_;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = url;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp1_, (gsize) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, "gwibber/avatars", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_avatar_cache_image = _tmp5_;
	_tmp6_ = _avatar_cache_image;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	file = _tmp7_;
	_tmp8_ = file;
	_tmp9_ = g_file_query_exists (_tmp8_, NULL);
	if (_tmp9_) {
		result = _avatar_cache_image;
		_g_object_unref0 (file);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (file);
		_g_free0 (_avatar_cache_image);
		return result;
	}
	_g_object_unref0 (file);
	_g_free0 (_avatar_cache_image);
}


static void gwibber_utils_do_setup_data_free (gpointer _data) {
	GwibberUtilsDoSetupData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (GwibberUtilsDoSetupData, _data_);
}


static void gwibber_utils_do_setup (GwibberUtils* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GwibberUtilsDoSetupData* _data_;
	GwibberUtils* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (GwibberUtilsDoSetupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gwibber_utils_do_setup);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gwibber_utils_do_setup_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->name = _tmp2_;
	gwibber_utils_do_setup_co (_data_);
}


static void gwibber_utils_do_setup_finish (GwibberUtils* self, GAsyncResult* _res_, GError** error) {
	GwibberUtilsDoSetupData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void gwibber_utils_do_setup_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GwibberUtilsDoSetupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gwibber_utils_do_setup_co (_data_);
}


static void _gwibber_utils_on_name_owner_changed_gwibber_dbus_iface_name_owner_changed (GwibberDBusIface* _sender, const gchar* name, const gchar* oldowner, const gchar* newowner, gpointer self) {
	gwibber_utils_on_name_owner_changed (self, name, oldowner, newowner);
}


static gboolean gwibber_utils_do_setup_co (GwibberUtilsDoSetupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	g_async_initable_new_async (GWIBBER_TYPE_DBUS_IFACE_PROXY, 0, NULL, gwibber_utils_do_setup_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp1_ = (GwibberDBusIface*) _data_->_tmp0_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->self->priv->bus);
	_data_->self->priv->bus = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->bus;
	g_signal_connect_object (_data_->_tmp2_, "name-owner-changed", (GCallback) _gwibber_utils_on_name_owner_changed_gwibber_dbus_iface_name_owner_changed, _data_->self, 0);
	_data_->_state_ = 2;
	gwibber_utils_on_ready (_data_->self, gwibber_utils_do_setup_ready, _data_);
	return FALSE;
	_state_2:
	gwibber_utils_on_ready_finish (_data_->self, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void gwibber_utils_setup (GwibberUtils* self, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->interface_name);
	self->priv->interface_name = _tmp1_;
	_tmp2_ = name;
	gwibber_utils_do_setup (self, _tmp2_, NULL, NULL);
}


GwibberUtils* gwibber_utils_construct (GType object_type) {
	GwibberUtils * self = NULL;
	self = (GwibberUtils*) g_object_new (object_type, NULL);
	return self;
}


GwibberUtils* gwibber_utils_new (void) {
	return gwibber_utils_construct (GWIBBER_TYPE_UTILS);
}


static void gwibber_utils_class_init (GwibberUtilsClass * klass) {
	gwibber_utils_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberUtilsPrivate));
	G_OBJECT_CLASS (klass)->finalize = gwibber_utils_finalize;
	/** 
	            Utils::available:
	    @arg0: bool
	            Emitted when the DBus service becomes available
	        */
	g_signal_new ("available", GWIBBER_TYPE_UTILS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void gwibber_utils_instance_init (GwibberUtils * self) {
	self->priv = GWIBBER_UTILS_GET_PRIVATE (self);
}


static void gwibber_utils_finalize (GObject* obj) {
	GwibberUtils * self;
	self = GWIBBER_UTILS (obj);
	_g_object_unref0 (self->priv->bus);
	_g_free0 (self->priv->interface_name);
	G_OBJECT_CLASS (gwibber_utils_parent_class)->finalize (obj);
}


GType gwibber_utils_get_type (void) {
	static volatile gsize gwibber_utils_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberUtils), 0, (GInstanceInitFunc) gwibber_utils_instance_init, NULL };
		GType gwibber_utils_type_id;
		gwibber_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "GwibberUtils", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_utils_type_id__volatile, gwibber_utils_type_id);
	}
	return gwibber_utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



