/* entry.c generated by valac 0.12.1, the Vala compiler
 * generated from entry.vala, do not modify */

/*
 * Copyright (C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber-gtk.h"
#include <gwibber.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtkspell/gtkspell.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _0(var) ((var == NULL) ? NULL : (var = ( (var), NULL)))
typedef struct _Block1Data Block1Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _GwibberGtkEntryPrivate {
	GwibberGtkAccountTargetBar* target_bar;
};

struct _GwibberGtkSimpleEntryPrivate {
	GwibberGtkInputTextView* text_view;
	GwibberGtkSendBar* send_bar;
};

struct _GwibberGtkInputTextViewPrivate {
	gboolean last_was_shortened;
	gchar* _mid;
	gchar* _action;
};

struct _GwibberGtkAccountToggleButtonPrivate {
	gchar* _color;
};

struct _GwibberGtkAccountTargetBarPrivate {
	GtkHBox* abox;
	gchar* _selected;
};

struct _Block1Data {
	int _ref_count_;
	GwibberGtkAccountTargetBar * self;
	GwibberGtkAccountToggleButton* account_button;
	GwibberAccount* account;
};

struct _GwibberGtkSendBarPrivate {
	GwibberService* _service;
};


static gpointer gwibber_gtk_entry_parent_class = NULL;
static gpointer gwibber_gtk_simple_entry_parent_class = NULL;
static gpointer gwibber_gtk_input_text_view_parent_class = NULL;
static gpointer gwibber_gtk_account_toggle_button_parent_class = NULL;
static gpointer gwibber_gtk_account_target_bar_parent_class = NULL;
static gpointer gwibber_gtk_send_bar_parent_class = NULL;

#define GWIBBER_GTK_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_ENTRY, GwibberGtkEntryPrivate))
enum  {
	GWIBBER_GTK_ENTRY_DUMMY_PROPERTY
};
static GObject * gwibber_gtk_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda12_ (GwibberGtkEntry* self);
static void __lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda13_ (GwibberGtkEntry* self);
static void __lambda13__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void gwibber_gtk_entry_finalize (GObject* obj);
#define GWIBBER_GTK_SIMPLE_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_SIMPLE_ENTRY, GwibberGtkSimpleEntryPrivate))
enum  {
	GWIBBER_GTK_SIMPLE_ENTRY_DUMMY_PROPERTY
};
static GObject * gwibber_gtk_simple_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda14_ (GwibberGtkSimpleEntry* self);
static void __lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gwibber_gtk_simple_entry_finalize (GObject* obj);
#define GWIBBER_GTK_INPUT_TEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW, GwibberGtkInputTextViewPrivate))
enum  {
	GWIBBER_GTK_INPUT_TEXT_VIEW_DUMMY_PROPERTY,
	GWIBBER_GTK_INPUT_TEXT_VIEW_MID,
	GWIBBER_GTK_INPUT_TEXT_VIEW_ACTION
};
static gboolean _lambda5_ (GwibberGtkInputTextView* self);
static gboolean __lambda5__gsource_func (gpointer self);
static void gwibber_gtk_input_text_view_on_connection_changed (GwibberGtkInputTextView* self, gboolean is_connected);
static void gwibber_gtk_input_text_view_on_text_changed (GwibberGtkInputTextView* self);
static void gwibber_gtk_input_text_view_on_text_inserted (GwibberGtkInputTextView* self, GtkTextIter* iter, const gchar* text, gint len);
static void gwibber_gtk_input_text_view_real_clear (GwibberGtkInputTextView* self);
static void gwibber_gtk_input_text_view_real_submit (GwibberGtkInputTextView* self);
static GObject * gwibber_gtk_input_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _gwibber_gtk_input_text_view_on_text_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void _gwibber_gtk_input_text_view_on_text_inserted_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* new_text, gint new_text_length, gpointer self);
static void _lambda6_ (gboolean source, GwibberGtkInputTextView* self);
static void __lambda6__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self);
static void gwibber_gtk_input_text_view_finalize (GObject* obj);
static void _vala_gwibber_gtk_input_text_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_input_text_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_ACCOUNT_TOGGLE_BUTTON, GwibberGtkAccountToggleButtonPrivate))
enum  {
	GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_DUMMY_PROPERTY,
	GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR
};
static gboolean gwibber_gtk_account_toggle_button_real_draw (GtkWidget* base, cairo_t* context);
static GObject * gwibber_gtk_account_toggle_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_gtk_account_toggle_button_finalize (GObject* obj);
static void _vala_gwibber_gtk_account_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_account_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_GTK_ACCOUNT_TARGET_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_ACCOUNT_TARGET_BAR, GwibberGtkAccountTargetBarPrivate))
enum  {
	GWIBBER_GTK_ACCOUNT_TARGET_BAR_DUMMY_PROPERTY,
	GWIBBER_GTK_ACCOUNT_TARGET_BAR_SELECTED
};
static GwibberGtkAccountToggleButton* gwibber_gtk_account_target_bar_create_button (GwibberGtkAccountTargetBar* self, GwibberAccount* account);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda7_ (GtkButton* source, Block1Data* _data1_);
static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void gwibber_gtk_account_target_bar_account_updated (GwibberGtkAccountTargetBar* self, GeeHashMap* accounts_buttons_map, GwibberAccount* account);
static void gwibber_gtk_account_target_bar_account_created (GwibberGtkAccountTargetBar* self, GeeHashMap* accounts_buttons_map, GwibberAccount* account);
static void gwibber_gtk_account_target_bar_account_deleted (GwibberGtkAccountTargetBar* self, GeeHashMap* accounts_buttons_map, const gchar* id);
static void gwibber_gtk_account_target_bar_on_connection_changed (GwibberGtkAccountTargetBar* self, gboolean is_connected);
static GObject * gwibber_gtk_account_target_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _lambda8_ (gboolean source, GwibberGtkAccountTargetBar* self);
static void __lambda8__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self);
static void _lambda9_ (GwibberAccount* source, GwibberGtkAccountTargetBar* self);
static void __lambda9__gwibber_accounts_updated (GwibberAccounts* _sender, GwibberAccount* account, gpointer self);
static void _lambda10_ (GwibberAccount* source, GwibberGtkAccountTargetBar* self);
static void __lambda10__gwibber_accounts_created (GwibberAccounts* _sender, GwibberAccount* account, gpointer self);
static void _lambda11_ (const gchar* source, GwibberGtkAccountTargetBar* self);
static void __lambda11__gwibber_accounts_deleted (GwibberAccounts* _sender, const gchar* id, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void gwibber_gtk_account_target_bar_finalize (GObject* obj);
static void _vala_gwibber_gtk_account_target_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_account_target_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GWIBBER_GTK_SEND_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_SEND_BAR, GwibberGtkSendBarPrivate))
enum  {
	GWIBBER_GTK_SEND_BAR_DUMMY_PROPERTY,
	GWIBBER_GTK_SEND_BAR_SERVICE
};
static GObject * gwibber_gtk_send_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gwibber_gtk_send_bar_finalize (GObject* obj);
static void _vala_gwibber_gtk_send_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_send_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GwibberGtkEntry* gwibber_gtk_entry_construct (GType object_type) {
	GwibberGtkEntry * self = NULL;
	self = (GwibberGtkEntry*) g_object_new (object_type, NULL);
	return self;
}


GwibberGtkEntry* gwibber_gtk_entry_new (void) {
	return gwibber_gtk_entry_construct (GWIBBER_GTK_TYPE_ENTRY);
}


static void _lambda12_ (GwibberGtkEntry* self) {
	g_signal_emit_by_name (self->text_view, "submit");
}


static void __lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda12_ (self);
}


static void _lambda13_ (GwibberGtkEntry* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gint _tmp1_;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->text_view);
	_tmp1_ = gtk_text_buffer_get_char_count (_tmp0_);
	gwibber_gtk_account_target_bar_set_counter (self->priv->target_bar, _tmp1_);
}


static void __lambda13__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda13_ (self);
}


static GObject * gwibber_gtk_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkEntry * self;
	GwibberService* _tmp0_ = NULL;
	GwibberGtkInputTextView* _tmp1_ = NULL;
	GwibberGtkAccountTargetBar* _tmp2_ = NULL;
	GtkHBox* _tmp3_ = NULL;
	GtkHBox* spacer;
	GtkTextBuffer* _tmp4_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ENTRY (obj);
	_tmp0_ = gwibber_service_new ();
	_g_object_unref0 (self->service);
	self->service = _tmp0_;
	_tmp1_ = gwibber_gtk_input_text_view_new (self->service);
	_g_object_unref0 (self->text_view);
	self->text_view = g_object_ref_sink (_tmp1_);
	_tmp2_ = gwibber_gtk_account_target_bar_new ();
	_g_object_unref0 (self->priv->target_bar);
	self->priv->target_bar = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->text_view);
	gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) self->priv->target_bar, "expand", FALSE, NULL);
	gtk_widget_show ((GtkWidget*) self->text_view);
	gtk_widget_show ((GtkWidget*) self->priv->target_bar);
	g_signal_connect_object (self->priv->target_bar->send, "clicked", (GCallback) __lambda12__gtk_button_clicked, self, 0);
	_tmp3_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	spacer = g_object_ref_sink (_tmp3_);
	gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) spacer, "padding", 2, "expand", FALSE, NULL);
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self->text_view);
	g_signal_connect_object (_tmp4_, "changed", (GCallback) __lambda13__gtk_text_buffer_changed, self, 0);
	_g_object_unref0 (spacer);
	return obj;
}


static void gwibber_gtk_entry_class_init (GwibberGtkEntryClass * klass) {
	gwibber_gtk_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_entry_finalize;
}


static void gwibber_gtk_entry_instance_init (GwibberGtkEntry * self) {
	self->priv = GWIBBER_GTK_ENTRY_GET_PRIVATE (self);
}


static void gwibber_gtk_entry_finalize (GObject* obj) {
	GwibberGtkEntry * self;
	self = GWIBBER_GTK_ENTRY (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->text_view);
	_g_object_unref0 (self->priv->target_bar);
	G_OBJECT_CLASS (gwibber_gtk_entry_parent_class)->finalize (obj);
}


GType gwibber_gtk_entry_get_type (void) {
	static volatile gsize gwibber_gtk_entry_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkEntry), 0, (GInstanceInitFunc) gwibber_gtk_entry_instance_init, NULL };
		GType gwibber_gtk_entry_type_id;
		gwibber_gtk_entry_type_id = g_type_register_static (GTK_TYPE_VBOX, "GwibberGtkEntry", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_entry_type_id__volatile, gwibber_gtk_entry_type_id);
	}
	return gwibber_gtk_entry_type_id__volatile;
}


GwibberGtkSimpleEntry* gwibber_gtk_simple_entry_construct (GType object_type) {
	GwibberGtkSimpleEntry * self = NULL;
	self = (GwibberGtkSimpleEntry*) g_object_new (object_type, NULL);
	return self;
}


GwibberGtkSimpleEntry* gwibber_gtk_simple_entry_new (void) {
	return gwibber_gtk_simple_entry_construct (GWIBBER_GTK_TYPE_SIMPLE_ENTRY);
}


static void _lambda14_ (GwibberGtkSimpleEntry* self) {
	g_signal_emit_by_name (self->priv->text_view, "submit");
}


static void __lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda14_ (self);
}


static GObject * gwibber_gtk_simple_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkSimpleEntry * self;
	GwibberService* _tmp0_ = NULL;
	GwibberGtkInputTextView* _tmp1_ = NULL;
	GwibberGtkSendBar* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_simple_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_SIMPLE_ENTRY (obj);
	_tmp0_ = gwibber_service_new ();
	_g_object_unref0 (self->service);
	self->service = _tmp0_;
	_tmp1_ = gwibber_gtk_input_text_view_new (self->service);
	_g_object_unref0 (self->priv->text_view);
	self->priv->text_view = g_object_ref_sink (_tmp1_);
	_tmp2_ = gwibber_gtk_send_bar_new (self->service);
	_g_object_unref0 (self->priv->send_bar);
	self->priv->send_bar = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->text_view);
	gtk_container_add_with_properties ((GtkContainer*) self, (GtkWidget*) self->priv->send_bar, "expand", FALSE, NULL);
	gtk_widget_show ((GtkWidget*) self->priv->text_view);
	gtk_widget_show ((GtkWidget*) self->priv->send_bar);
	g_signal_connect_object (self->priv->send_bar->send, "clicked", (GCallback) __lambda14__gtk_button_clicked, self, 0);
	return obj;
}


static void gwibber_gtk_simple_entry_class_init (GwibberGtkSimpleEntryClass * klass) {
	gwibber_gtk_simple_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkSimpleEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_simple_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_simple_entry_finalize;
}


static void gwibber_gtk_simple_entry_instance_init (GwibberGtkSimpleEntry * self) {
	self->priv = GWIBBER_GTK_SIMPLE_ENTRY_GET_PRIVATE (self);
}


static void gwibber_gtk_simple_entry_finalize (GObject* obj) {
	GwibberGtkSimpleEntry * self;
	self = GWIBBER_GTK_SIMPLE_ENTRY (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->send_bar);
	G_OBJECT_CLASS (gwibber_gtk_simple_entry_parent_class)->finalize (obj);
}


GType gwibber_gtk_simple_entry_get_type (void) {
	static volatile gsize gwibber_gtk_simple_entry_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_simple_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkSimpleEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_simple_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkSimpleEntry), 0, (GInstanceInitFunc) gwibber_gtk_simple_entry_instance_init, NULL };
		GType gwibber_gtk_simple_entry_type_id;
		gwibber_gtk_simple_entry_type_id = g_type_register_static (GTK_TYPE_VBOX, "GwibberGtkSimpleEntry", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_simple_entry_type_id__volatile, gwibber_gtk_simple_entry_type_id);
	}
	return gwibber_gtk_simple_entry_type_id__volatile;
}


GwibberGtkInputTextView* gwibber_gtk_input_text_view_construct (GType object_type, GwibberService* service) {
	GwibberGtkInputTextView * self = NULL;
	g_return_val_if_fail (service != NULL, NULL);
	self = (GwibberGtkInputTextView*) g_object_new (object_type, "border-width", 5, "accepts-tab", TRUE, "editable", TRUE, "cursor-visible", TRUE, "wrap-mode", GTK_WRAP_WORD_CHAR, "left-margin", 2, "right-margin", 2, "pixels-above-lines", 2, "pixels-below-lines", 2, NULL);
	return self;
}


GwibberGtkInputTextView* gwibber_gtk_input_text_view_new (GwibberService* service) {
	return gwibber_gtk_input_text_view_construct (GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW, service);
}


static gboolean _lambda5_ (GwibberGtkInputTextView* self) {
	gboolean result = FALSE;
	gwibber_gtk_input_text_view_set_mid (self, NULL);
	gwibber_gtk_input_text_view_set_action (self, NULL);
	g_signal_emit_by_name (self, "clear");
	result = FALSE;
	return result;
}


static gboolean __lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda5_ (self);
	return result;
}


void gwibber_gtk_input_text_view_reset (GwibberGtkInputTextView* self) {
	g_return_if_fail (self != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, __lambda5__gsource_func, g_object_ref (self), g_object_unref);
}


static void gwibber_gtk_input_text_view_on_connection_changed (GwibberGtkInputTextView* self, gboolean is_connected) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self, is_connected);
}


static void gwibber_gtk_input_text_view_on_text_changed (GwibberGtkInputTextView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gint _tmp1_;
	gint chars;
	GdkColor _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = gtk_text_buffer_get_char_count (_tmp0_);
	chars = _tmp1_;
	if (chars > GWIBBER_GTK_MAX_MESSAGE_LENGTH) {
		_tmp2_ = self->error_color;
	} else {
		_tmp2_ = self->fg_color;
	}
	gtk_widget_modify_fg ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp2_);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gwibber_gtk_input_text_view_on_text_inserted (GwibberGtkInputTextView* self, GtkTextIter* iter, const gchar* text, gint len) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->last_was_shortened == FALSE) {
		_tmp2_ = len > 30;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = text != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = string_slice (text, (glong) 0, (glong) 4);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "http") == 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTextBuffer* _tmp5_ = NULL;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* buf;
		gchar* _tmp7_ = NULL;
		gchar* shrt;
		_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		buf = _tmp6_;
		g_signal_stop_emission_by_name (buf, "insert-text");
		_tmp7_ = gwibber_url_shorten_shorten (self->urlshorten, text);
		shrt = _tmp7_;
		self->priv->last_was_shortened = TRUE;
		gtk_text_buffer_insert (buf, iter, shrt, -1);
		_g_free0 (shrt);
		_g_object_unref0 (buf);
	} else {
		self->priv->last_was_shortened = FALSE;
	}
}


const gchar* gwibber_gtk_input_text_view_get_mid (GwibberGtkInputTextView* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mid;
	return result;
}


void gwibber_gtk_input_text_view_set_mid (GwibberGtkInputTextView* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (self->priv->_mid, value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mid);
		self->priv->_mid = _tmp0_;
	}
	g_object_notify ((GObject *) self, "mid");
}


const gchar* gwibber_gtk_input_text_view_get_action (GwibberGtkInputTextView* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_action;
	return result;
}


void gwibber_gtk_input_text_view_set_action (GwibberGtkInputTextView* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (self->priv->_action, value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_action);
		self->priv->_action = _tmp0_;
	}
	g_object_notify ((GObject *) self, "action");
}


static void gwibber_gtk_input_text_view_real_clear (GwibberGtkInputTextView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	gtk_text_buffer_set_text (_tmp0_, "", -1);
}


static void gwibber_gtk_input_text_view_real_submit (GwibberGtkInputTextView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* msg;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	g_object_get (_tmp0_, "text", &_tmp1_, NULL);
	msg = _tmp1_;
	_tmp2_ = strlen (msg);
	if (_tmp2_ < 1) {
		g_debug ("entry.vala:182: SEND FAILED, empty post");
		_g_free0 (msg);
		return;
	}
	_tmp4_ = gwibber_gtk_input_text_view_get_mid (self);
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = gwibber_gtk_input_text_view_get_action (self);
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp6_ = gwibber_gtk_input_text_view_get_action (self);
		_tmp7_ = gwibber_gtk_input_text_view_get_mid (self);
		g_debug ("entry.vala:186: Sending %s for %s", _tmp6_, _tmp7_);
		_tmp8_ = gwibber_gtk_input_text_view_get_mid (self);
		_tmp9_ = gwibber_gtk_input_text_view_get_action (self);
		gwibber_service_send_message (self->service, msg, _tmp8_, _tmp9_, NULL, 0);
		gwibber_gtk_input_text_view_set_mid (self, NULL);
		gwibber_gtk_input_text_view_set_action (self, NULL);
	} else {
		gwibber_service_send_message (self->service, msg, NULL, NULL, NULL, 0);
	}
	g_debug ("entry.vala:193: (submit) Message: %s posted", msg);
	gwibber_gtk_input_text_view_reset (self);
	_g_free0 (msg);
}


static void _gwibber_gtk_input_text_view_on_text_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	gwibber_gtk_input_text_view_on_text_changed (self);
}


static void _gwibber_gtk_input_text_view_on_text_inserted_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* new_text, gint new_text_length, gpointer self) {
	gwibber_gtk_input_text_view_on_text_inserted (self, pos, new_text, new_text_length);
}


static void _lambda6_ (gboolean source, GwibberGtkInputTextView* self) {
	gwibber_gtk_input_text_view_on_connection_changed (self, source);
}


static void __lambda6__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self) {
	_lambda6_ (is_online, self);
}


static GObject * gwibber_gtk_input_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkInputTextView * self;
	GwibberService* _tmp0_ = NULL;
	GwibberConnection* _tmp1_ = NULL;
	GwibberURLShorten* _tmp2_ = NULL;
	GtkBindingSet* binding_set = NULL;
	GTypeClass* _tmp3_ = NULL;
	GTypeClass* _tmp4_;
	GtkBindingSet* _tmp5_ = NULL;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	GtkStyle* _tmp9_ = NULL;
	GdkColor _tmp10_ = {0};
	GtkTextBuffer* _tmp11_ = NULL;
	GtkTextBuffer* _tmp12_ = NULL;
	gboolean _tmp13_;
	GtkSpell* _tmp14_ = NULL;
	GtkSpell* spell;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_input_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_INPUT_TEXT_VIEW (obj);
	_tmp0_ = gwibber_service_new ();
	_g_object_unref0 (self->service);
	self->service = _tmp0_;
	_tmp1_ = gwibber_connection_new ();
	_g_object_unref0 (self->conn_service);
	self->conn_service = _tmp1_;
	_tmp2_ = gwibber_url_shorten_new ();
	_g_object_unref0 (self->urlshorten);
	self->urlshorten = _tmp2_;
	_tmp3_ = g_type_class_ref (GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_binding_set_by_class (_tmp4_);
	binding_set = _tmp5_;
	_g_type_class_unref0 (_tmp4_);
	_tmp6_ = gdk_keyval_from_name ("Return");
	gtk_binding_entry_add_signal (binding_set, _tmp6_, 0, "submit", (guint) 0);
	_tmp7_ = gdk_keyval_from_name ("KP_Enter");
	gtk_binding_entry_add_signal (binding_set, _tmp7_, 0, "submit", (guint) 0);
	_tmp8_ = gdk_keyval_from_name ("Escape");
	gtk_binding_entry_add_signal (binding_set, _tmp8_, 0, "clear", (guint) 0);
	_tmp9_ = gtk_widget_get_style ((GtkWidget*) self);
	self->fg_color = _tmp9_->fg[GTK_STATE_NORMAL];
	gdk_color_parse ("indianred", &_tmp10_);
	self->error_color = _tmp10_;
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	g_signal_connect_object (_tmp11_, "changed", (GCallback) _gwibber_gtk_input_text_view_on_text_changed_gtk_text_buffer_changed, self, 0);
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	g_signal_connect_object (_tmp12_, "insert-text", (GCallback) _gwibber_gtk_input_text_view_on_text_inserted_gtk_text_buffer_insert_text, self, 0);
	_tmp13_ = gwibber_connection_is_connected (self->conn_service);
	gtk_widget_set_sensitive ((GtkWidget*) self, _tmp13_);
	g_signal_connect_object (self->conn_service, "connection-changed", (GCallback) __lambda6__gwibber_connection_connection_changed, self, 0);
	_tmp14_ = gtkspell_new_attach ((GtkTextView*) self, NULL, &_inner_error_);
	spell = _tmp14_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_0 (spell);
	return obj;
}


static void gwibber_gtk_input_text_view_class_init (GwibberGtkInputTextViewClass * klass) {
	gwibber_gtk_input_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkInputTextViewPrivate));
	GWIBBER_GTK_INPUT_TEXT_VIEW_CLASS (klass)->clear = gwibber_gtk_input_text_view_real_clear;
	GWIBBER_GTK_INPUT_TEXT_VIEW_CLASS (klass)->submit = gwibber_gtk_input_text_view_real_submit;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_input_text_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_input_text_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_input_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_input_text_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_INPUT_TEXT_VIEW_MID, g_param_spec_string ("mid", "mid", "mid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_INPUT_TEXT_VIEW_ACTION, g_param_spec_string ("action", "action", "action", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("clear", GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberGtkInputTextViewClass, clear), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("submit", GWIBBER_GTK_TYPE_INPUT_TEXT_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberGtkInputTextViewClass, submit), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gwibber_gtk_input_text_view_instance_init (GwibberGtkInputTextView * self) {
	self->priv = GWIBBER_GTK_INPUT_TEXT_VIEW_GET_PRIVATE (self);
	self->priv->last_was_shortened = FALSE;
	self->priv->_mid = NULL;
	self->priv->_action = NULL;
}


static void gwibber_gtk_input_text_view_finalize (GObject* obj) {
	GwibberGtkInputTextView * self;
	self = GWIBBER_GTK_INPUT_TEXT_VIEW (obj);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->conn_service);
	_g_object_unref0 (self->urlshorten);
	_g_free0 (self->priv->_mid);
	_g_free0 (self->priv->_action);
	G_OBJECT_CLASS (gwibber_gtk_input_text_view_parent_class)->finalize (obj);
}


GType gwibber_gtk_input_text_view_get_type (void) {
	static volatile gsize gwibber_gtk_input_text_view_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_input_text_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkInputTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_input_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkInputTextView), 0, (GInstanceInitFunc) gwibber_gtk_input_text_view_instance_init, NULL };
		GType gwibber_gtk_input_text_view_type_id;
		gwibber_gtk_input_text_view_type_id = g_type_register_static (GTK_TYPE_TEXT_VIEW, "GwibberGtkInputTextView", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_input_text_view_type_id__volatile, gwibber_gtk_input_text_view_type_id);
	}
	return gwibber_gtk_input_text_view_type_id__volatile;
}


static void _vala_gwibber_gtk_input_text_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkInputTextView * self;
	self = GWIBBER_GTK_INPUT_TEXT_VIEW (object);
	switch (property_id) {
		case GWIBBER_GTK_INPUT_TEXT_VIEW_MID:
		g_value_set_string (value, gwibber_gtk_input_text_view_get_mid (self));
		break;
		case GWIBBER_GTK_INPUT_TEXT_VIEW_ACTION:
		g_value_set_string (value, gwibber_gtk_input_text_view_get_action (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_input_text_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkInputTextView * self;
	self = GWIBBER_GTK_INPUT_TEXT_VIEW (object);
	switch (property_id) {
		case GWIBBER_GTK_INPUT_TEXT_VIEW_MID:
		gwibber_gtk_input_text_view_set_mid (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_INPUT_TEXT_VIEW_ACTION:
		gwibber_gtk_input_text_view_set_action (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberGtkAccountToggleButton* gwibber_gtk_account_toggle_button_construct (GType object_type, const gchar* color) {
	GwibberGtkAccountToggleButton * self = NULL;
	g_return_val_if_fail (color != NULL, NULL);
	self = (GwibberGtkAccountToggleButton*) g_object_new (object_type, "color", color, NULL);
	return self;
}


GwibberGtkAccountToggleButton* gwibber_gtk_account_toggle_button_new (const gchar* color) {
	return gwibber_gtk_account_toggle_button_construct (GWIBBER_GTK_TYPE_ACCOUNT_TOGGLE_BUTTON, color);
}


static gboolean gwibber_gtk_account_toggle_button_real_draw (GtkWidget* base, cairo_t* context) {
	GwibberGtkAccountToggleButton * self;
	gboolean result = FALSE;
	gdouble factor;
	gboolean _tmp0_;
	GtkAllocation a = {0};
	GtkAllocation _tmp3_ = {0};
	GdkRGBA c = {0};
	GtkWidget* _tmp4_ = NULL;
	self = (GwibberGtkAccountToggleButton*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	factor = 0.3;
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	if (_tmp0_) {
		cairo_translate (context, (gdouble) (-1), (gdouble) (-1));
		factor = 1.0;
	} else {
		GtkStateType _tmp1_;
		_tmp1_ = gtk_widget_get_state ((GtkWidget*) self);
		if (_tmp1_ == 2) {
			factor = 0.3;
		} else {
			GtkStateType _tmp2_;
			_tmp2_ = gtk_widget_get_state ((GtkWidget*) self);
			if (_tmp2_ == 1) {
				factor = 0.5;
			}
		}
	}
	cairo_push_group (context);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
	a = _tmp3_;
	memset (&c, 0, sizeof (GdkRGBA));
	c.red = (gdouble) 1.0f;
	c.green = (gdouble) 1.0f;
	c.blue = (gdouble) 1.0f;
	c.alpha = (gdouble) 1.0f;
	gdk_rgba_parse (&c, self->priv->_color);
	cairo_set_source_rgba (context, c.red, c.green, c.blue, (gdouble) 1.0f);
	cairo_rectangle (context, (gdouble) (a.width - 2), (gdouble) (a.height - 6), (gdouble) 2, (gdouble) 6);
	cairo_rectangle (context, (gdouble) (a.width - 6), (gdouble) (a.height - 2), (gdouble) 6, (gdouble) 2);
	cairo_fill (context);
	_tmp4_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_container_propagate_draw ((GtkContainer*) self, _tmp4_, context);
	cairo_pop_group_to_source (context);
	cairo_paint_with_alpha (context, factor);
	result = TRUE;
	return result;
}


const gchar* gwibber_gtk_account_toggle_button_get_color (GwibberGtkAccountToggleButton* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_color;
	return result;
}


static void gwibber_gtk_account_toggle_button_set_color (GwibberGtkAccountToggleButton* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_color);
	self->priv->_color = _tmp0_;
	g_object_notify ((GObject *) self, "color");
}


static GObject * gwibber_gtk_account_toggle_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkAccountToggleButton * self;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_account_toggle_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (obj);
	gtk_widget_set_size_request ((GtkWidget*) self, 24, 24);
	return obj;
}


static void gwibber_gtk_account_toggle_button_class_init (GwibberGtkAccountToggleButtonClass * klass) {
	gwibber_gtk_account_toggle_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkAccountToggleButtonPrivate));
	GTK_WIDGET_CLASS (klass)->draw = gwibber_gtk_account_toggle_button_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_account_toggle_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_account_toggle_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_account_toggle_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_account_toggle_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR, g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gwibber_gtk_account_toggle_button_instance_init (GwibberGtkAccountToggleButton * self) {
	self->priv = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_GET_PRIVATE (self);
}


static void gwibber_gtk_account_toggle_button_finalize (GObject* obj) {
	GwibberGtkAccountToggleButton * self;
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (obj);
	_g_free0 (self->priv->_color);
	G_OBJECT_CLASS (gwibber_gtk_account_toggle_button_parent_class)->finalize (obj);
}


GType gwibber_gtk_account_toggle_button_get_type (void) {
	static volatile gsize gwibber_gtk_account_toggle_button_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_account_toggle_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkAccountToggleButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_account_toggle_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkAccountToggleButton), 0, (GInstanceInitFunc) gwibber_gtk_account_toggle_button_instance_init, NULL };
		GType gwibber_gtk_account_toggle_button_type_id;
		gwibber_gtk_account_toggle_button_type_id = g_type_register_static (GTK_TYPE_TOGGLE_BUTTON, "GwibberGtkAccountToggleButton", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_account_toggle_button_type_id__volatile, gwibber_gtk_account_toggle_button_type_id);
	}
	return gwibber_gtk_account_toggle_button_type_id__volatile;
}


static void _vala_gwibber_gtk_account_toggle_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkAccountToggleButton * self;
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (object);
	switch (property_id) {
		case GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR:
		g_value_set_string (value, gwibber_gtk_account_toggle_button_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_account_toggle_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkAccountToggleButton * self;
	self = GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON (object);
	switch (property_id) {
		case GWIBBER_GTK_ACCOUNT_TOGGLE_BUTTON_COLOR:
		gwibber_gtk_account_toggle_button_set_color (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberGtkAccountTargetBar* gwibber_gtk_account_target_bar_construct (GType object_type) {
	GwibberGtkAccountTargetBar * self = NULL;
	self = (GwibberGtkAccountTargetBar*) g_object_new (object_type, "spacing", 0, NULL);
	return self;
}


GwibberGtkAccountTargetBar* gwibber_gtk_account_target_bar_new (void) {
	return gwibber_gtk_account_target_bar_construct (GWIBBER_GTK_TYPE_ACCOUNT_TARGET_BAR);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->account_button);
		_g_object_unref0 (_data1_->account);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda7_ (GtkButton* source, Block1Data* _data1_) {
	GwibberGtkAccountTargetBar * self;
	const gchar* _tmp0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = gwibber_account_get_id (_data1_->account);
	gwibber_gtk_account_target_bar_on_account_toggled (self, _data1_->account_button, _tmp0_);
}


static void __lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static GwibberGtkAccountToggleButton* gwibber_gtk_account_target_bar_create_button (GwibberGtkAccountTargetBar* self, GwibberAccount* account) {
	GwibberGtkAccountToggleButton* result = NULL;
	Block1Data* _data1_;
	gchar* _tmp0_ = NULL;
	gchar* service_icon_path;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkImage* _tmp6_ = NULL;
	GtkImage* icon_service;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GwibberGtkAccountToggleButton* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GwibberGtkAccountToggleButton* _tmp36_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->account = _g_object_ref0 (account);
	_tmp0_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "share", "gwibber", "ui", "icons", "breakdance", "16x16", G_DIR_SEPARATOR_S, NULL);
	service_icon_path = _tmp0_;
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "local", "share", "gwibber", "ui", "icons", "breakdance", "22x22", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_build_path (G_DIR_SEPARATOR_S, G_DIR_SEPARATOR_S, "usr", "local", "share", "gwibber", "ui", "icons", "breakdance", "16x16", G_DIR_SEPARATOR_S, NULL);
		_g_free0 (service_icon_path);
		service_icon_path = _tmp5_;
	}
	_tmp6_ = (GtkImage*) gtk_image_new ();
	icon_service = g_object_ref_sink (_tmp6_);
	_tmp7_ = gwibber_account_get_service (_data1_->account);
	_tmp8_ = g_strconcat (service_icon_path, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ".png", NULL);
	_tmp11_ = _tmp10_;
	gtk_image_set_from_file (icon_service, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	gtk_widget_show ((GtkWidget*) icon_service);
	_tmp12_ = gwibber_account_get_color (_data1_->account);
	_tmp13_ = gwibber_gtk_account_toggle_button_new (_tmp12_);
	_data1_->account_button = g_object_ref_sink (_tmp13_);
	_tmp15_ = gwibber_account_get_send_enabled (_data1_->account);
	if (g_strcmp0 (_tmp15_, "1") == 0) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = FALSE;
	}
	gtk_toggle_button_set_active ((GtkToggleButton*) _data1_->account_button, _tmp14_);
	_tmp16_ = gwibber_account_get_send_enabled (_data1_->account);
	if (g_strcmp0 (_tmp16_, "1") != 0) {
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp17_ = gwibber_account_get_service (_data1_->account);
		_tmp18_ = g_strconcat (_tmp17_, " (", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = gwibber_account_get_username (_data1_->account);
		_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, ") - ", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = _ ("Disabled");
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _data1_->account_button, _tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
	} else {
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp28_ = gwibber_account_get_service (_data1_->account);
		_tmp29_ = g_strconcat (_tmp28_, " (", NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = gwibber_account_get_username (_data1_->account);
		_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat (_tmp33_, ")", NULL);
		_tmp35_ = _tmp34_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _data1_->account_button, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
	}
	gtk_button_set_image ((GtkButton*) _data1_->account_button, (GtkWidget*) icon_service);
	g_signal_connect_data ((GtkButton*) _data1_->account_button, "clicked", (GCallback) __lambda7__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_box_pack_start ((GtkBox*) self->priv->abox, (GtkWidget*) _data1_->account_button, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) _data1_->account_button);
	_tmp36_ = _g_object_ref0 (_data1_->account_button);
	result = _tmp36_;
	_g_object_unref0 (icon_service);
	_g_free0 (service_icon_path);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


void gwibber_gtk_account_target_bar_set_counter (GwibberGtkAccountTargetBar* self, gint chars) {
	g_return_if_fail (self != NULL);
	if (chars > GWIBBER_GTK_MAX_MESSAGE_LENGTH) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = g_strdup_printf ("%i", chars - GWIBBER_GTK_MAX_MESSAGE_LENGTH);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat ("<b> -", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "</b>", NULL);
		_tmp5_ = _tmp4_;
		gtk_label_set_markup (self->count, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = g_strdup_printf ("%i", GWIBBER_GTK_MAX_MESSAGE_LENGTH - chars);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("<b>", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "</b>", NULL);
		_tmp11_ = _tmp10_;
		gtk_label_set_markup (self->count, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
	}
}


void gwibber_gtk_account_target_bar_on_account_toggled (GwibberGtkAccountTargetBar* self, GwibberGtkAccountToggleButton* account_button, const gchar* id) {
	GwibberAccount* _tmp0_ = NULL;
	GwibberAccount* account;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account_button != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = gwibber_accounts_lookup_by_id (self->accounts_service, id);
	account = _tmp0_;
	_tmp2_ = gwibber_account_get_send_enabled (account);
	if (g_strcmp0 (_tmp2_, "1") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) account_button);
	if (_tmp1_ != _tmp3_) {
		gwibber_accounts_send_enabled (self->accounts_service, id);
	}
	_g_object_unref0 (account);
}


static void gwibber_gtk_account_target_bar_account_updated (GwibberGtkAccountTargetBar* self, GeeHashMap* accounts_buttons_map, GwibberAccount* account) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	GwibberGtkAccountToggleButton* account_button;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (accounts_buttons_map != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = gwibber_account_get_id (account);
	_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) accounts_buttons_map, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gwibber_account_get_id (account);
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) accounts_buttons_map, _tmp2_);
	account_button = (GwibberGtkAccountToggleButton*) _tmp3_;
	_tmp4_ = gwibber_account_get_send_enabled (account);
	if (g_strcmp0 (_tmp4_, "1") != 0) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp5_ = gwibber_account_get_service (account);
		_tmp6_ = g_strconcat (_tmp5_, " (", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = gwibber_account_get_username (account);
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, ") - ", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = _ ("Disabled");
		_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		gtk_widget_set_tooltip_text ((GtkWidget*) account_button, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp16_ = gwibber_account_get_service (account);
		_tmp17_ = g_strconcat (_tmp16_, " (", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = gwibber_account_get_username (account);
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, ")", NULL);
		_tmp23_ = _tmp22_;
		gtk_widget_set_tooltip_text ((GtkWidget*) account_button, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
	}
	_tmp25_ = gwibber_account_get_send_enabled (account);
	if (g_strcmp0 (_tmp25_, "1") == 0) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp26_ = gtk_toggle_button_get_active ((GtkToggleButton*) account_button);
	if (_tmp24_ != _tmp26_) {
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_ = NULL;
		_tmp28_ = gwibber_account_get_send_enabled (account);
		if (g_strcmp0 (_tmp28_, "1") == 0) {
			_tmp27_ = TRUE;
		} else {
			_tmp27_ = FALSE;
		}
		gtk_toggle_button_set_active ((GtkToggleButton*) account_button, _tmp27_);
	}
	_g_object_unref0 (account_button);
}


static void gwibber_gtk_account_target_bar_account_created (GwibberGtkAccountTargetBar* self, GeeHashMap* accounts_buttons_map, GwibberAccount* account) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GwibberGtkAccountToggleButton* _tmp2_ = NULL;
	GwibberGtkAccountToggleButton* account_button;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (accounts_buttons_map != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = gwibber_account_get_id (account);
	_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) accounts_buttons_map, _tmp0_);
	if (_tmp1_) {
		gwibber_gtk_account_target_bar_account_updated (self, accounts_buttons_map, account);
		return;
	}
	_tmp2_ = gwibber_gtk_account_target_bar_create_button (self, account);
	account_button = _tmp2_;
	_tmp3_ = gwibber_account_get_id (account);
	gee_abstract_map_set ((GeeAbstractMap*) accounts_buttons_map, _tmp3_, account_button);
	_g_object_unref0 (account_button);
}


static void gwibber_gtk_account_target_bar_account_deleted (GwibberGtkAccountTargetBar* self, GeeHashMap* accounts_buttons_map, const gchar* id) {
	gboolean _tmp0_;
	gpointer _tmp1_ = NULL;
	GwibberGtkAccountToggleButton* account_button;
	gpointer _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (accounts_buttons_map != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) accounts_buttons_map, id);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) accounts_buttons_map, id);
	account_button = (GwibberGtkAccountToggleButton*) _tmp1_;
	gtk_widget_destroy ((GtkWidget*) account_button);
	gee_abstract_map_unset ((GeeAbstractMap*) accounts_buttons_map, id, &_tmp2_);
	_g_object_unref0 (account_button);
	account_button = _tmp2_;
	_g_object_unref0 (account_button);
}


static void gwibber_gtk_account_target_bar_on_connection_changed (GwibberGtkAccountTargetBar* self, gboolean is_connected) {
	g_return_if_fail (self != NULL);
	gtk_widget_set_sensitive ((GtkWidget*) self->send, is_connected);
}


const gchar* gwibber_gtk_account_target_bar_get_selected (GwibberGtkAccountTargetBar* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_selected;
	return result;
}


void gwibber_gtk_account_target_bar_set_selected (GwibberGtkAccountTargetBar* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (self->priv->_selected, value) != 0) {
	}
	{
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_selected);
		self->priv->_selected = _tmp0_;
		if (self->priv->_selected != NULL) {
			{
				GeeSet* _tmp1_ = NULL;
				GeeSet* _tmp2_;
				GeeIterator* _tmp3_ = NULL;
				GeeIterator* _tmp4_;
				GeeIterator* _k_it;
				_tmp1_ = gee_map_get_keys ((GeeMap*) self->accounts_buttons_map);
				_tmp2_ = _tmp1_;
				_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
				_tmp4_ = _tmp3_;
				_g_object_unref0 (_tmp2_);
				_k_it = _tmp4_;
				while (TRUE) {
					gboolean _tmp5_;
					gpointer _tmp6_ = NULL;
					gchar* k;
					gpointer _tmp13_ = NULL;
					GwibberGtkAccountToggleButton* _tmp14_;
					_tmp5_ = gee_iterator_next (_k_it);
					if (!_tmp5_) {
						break;
					}
					_tmp6_ = gee_iterator_get (_k_it);
					k = (gchar*) _tmp6_;
					if (g_strcmp0 (self->priv->_selected, k) != 0) {
						gpointer _tmp7_ = NULL;
						GwibberGtkAccountToggleButton* _tmp8_;
						_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) self->accounts_buttons_map, k);
						_tmp8_ = (GwibberGtkAccountToggleButton*) _tmp7_;
						gtk_widget_hide ((GtkWidget*) _tmp8_);
						_g_object_unref0 (_tmp8_);
					} else {
						gpointer _tmp9_ = NULL;
						GwibberGtkAccountToggleButton* _tmp10_;
						gpointer _tmp11_ = NULL;
						GwibberGtkAccountToggleButton* _tmp12_;
						_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) self->accounts_buttons_map, k);
						_tmp10_ = (GwibberGtkAccountToggleButton*) _tmp9_;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp10_, TRUE);
						_g_object_unref0 (_tmp10_);
						_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) self->accounts_buttons_map, k);
						_tmp12_ = (GwibberGtkAccountToggleButton*) _tmp11_;
						gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
						_g_object_unref0 (_tmp12_);
					}
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) self->accounts_buttons_map, self->priv->_selected);
					_tmp14_ = (GwibberGtkAccountToggleButton*) _tmp13_;
					gtk_widget_show_all ((GtkWidget*) _tmp14_);
					_g_object_unref0 (_tmp14_);
					_g_free0 (k);
				}
				_g_object_unref0 (_k_it);
			}
		} else {
			{
				GeeSet* _tmp15_ = NULL;
				GeeSet* _tmp16_;
				GeeIterator* _tmp17_ = NULL;
				GeeIterator* _tmp18_;
				GeeIterator* _k_it;
				_tmp15_ = gee_map_get_keys ((GeeMap*) self->accounts_buttons_map);
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp16_);
				_k_it = _tmp18_;
				while (TRUE) {
					gboolean _tmp19_;
					gpointer _tmp20_ = NULL;
					gchar* k;
					gpointer _tmp21_ = NULL;
					GwibberGtkAccountToggleButton* _tmp22_;
					_tmp19_ = gee_iterator_next (_k_it);
					if (!_tmp19_) {
						break;
					}
					_tmp20_ = gee_iterator_get (_k_it);
					k = (gchar*) _tmp20_;
					_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) self->accounts_buttons_map, k);
					_tmp22_ = (GwibberGtkAccountToggleButton*) _tmp21_;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, TRUE);
					_g_object_unref0 (_tmp22_);
					_g_free0 (k);
				}
				_g_object_unref0 (_k_it);
			}
			gtk_widget_show_all ((GtkWidget*) self);
		}
	}
	g_object_notify ((GObject *) self, "selected");
}


static void _lambda8_ (gboolean source, GwibberGtkAccountTargetBar* self) {
	gwibber_gtk_account_target_bar_on_connection_changed (self, source);
}


static void __lambda8__gwibber_connection_connection_changed (GwibberConnection* _sender, gboolean is_online, gpointer self) {
	_lambda8_ (is_online, self);
}


static void _lambda9_ (GwibberAccount* source, GwibberGtkAccountTargetBar* self) {
	g_return_if_fail (source != NULL);
	gwibber_gtk_account_target_bar_account_updated (self, self->accounts_buttons_map, source);
}


static void __lambda9__gwibber_accounts_updated (GwibberAccounts* _sender, GwibberAccount* account, gpointer self) {
	_lambda9_ (account, self);
}


static void _lambda10_ (GwibberAccount* source, GwibberGtkAccountTargetBar* self) {
	g_return_if_fail (source != NULL);
	gwibber_gtk_account_target_bar_account_created (self, self->accounts_buttons_map, source);
}


static void __lambda10__gwibber_accounts_created (GwibberAccounts* _sender, GwibberAccount* account, gpointer self) {
	_lambda10_ (account, self);
}


static void _lambda11_ (const gchar* source, GwibberGtkAccountTargetBar* self) {
	g_return_if_fail (source != NULL);
	gwibber_gtk_account_target_bar_account_deleted (self, self->accounts_buttons_map, source);
}


static void __lambda11__gwibber_accounts_deleted (GwibberAccounts* _sender, const gchar* id, gpointer self) {
	_lambda11_ (id, self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GObject * gwibber_gtk_account_target_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkAccountTargetBar * self;
	GwibberAccounts* _tmp0_ = NULL;
	GwibberConnection* _tmp1_ = NULL;
	GtkHBox* _tmp2_ = NULL;
	GtkHBox* box;
	const gchar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* send_with_label;
	GeeHashMap* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* accounts_list;
	GtkHBox* _tmp7_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_account_target_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ACCOUNT_TARGET_BAR (obj);
	_tmp0_ = gwibber_accounts_new ();
	_g_object_unref0 (self->accounts_service);
	self->accounts_service = _tmp0_;
	_tmp1_ = gwibber_connection_new ();
	_g_object_unref0 (self->conn_service);
	self->conn_service = _tmp1_;
	_tmp2_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	box = g_object_ref_sink (_tmp2_);
	_tmp3_ = _ ("Send with:");
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	send_with_label = g_object_ref_sink (_tmp4_);
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GWIBBER_GTK_TYPE_ACCOUNT_TOGGLE_BUTTON, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->accounts_buttons_map);
	self->accounts_buttons_map = _tmp5_;
	_tmp6_ = gwibber_accounts_list (self->accounts_service);
	accounts_list = _tmp6_;
	_tmp7_ = (GtkHBox*) gtk_hbox_new (TRUE, 6);
	_g_object_unref0 (self->priv->abox);
	self->priv->abox = g_object_ref_sink (_tmp7_);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->abox, FALSE, FALSE, (guint) 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				guint _tmp9_;
				gconstpointer _tmp10_ = NULL;
				GwibberAccount* _tmp11_;
				GwibberAccount* account;
				const gchar* _tmp12_ = NULL;
				GwibberGtkAccountToggleButton* _tmp13_ = NULL;
				GwibberGtkAccountToggleButton* account_button;
				const gchar* _tmp14_ = NULL;
				if (!_tmp8_) {
					i++;
				}
				_tmp8_ = FALSE;
				_tmp9_ = g_list_length (accounts_list);
				if (!(i < _tmp9_)) {
					break;
				}
				_tmp10_ = g_list_nth_data (accounts_list, (guint) i);
				_tmp11_ = _g_object_ref0 ((GwibberAccount*) _tmp10_);
				account = _tmp11_;
				if (account == NULL) {
					_g_object_unref0 (account);
					continue;
				}
				_tmp12_ = gwibber_account_get_send_enabled (account);
				if (_tmp12_ == NULL) {
					_g_object_unref0 (account);
					continue;
				}
				_tmp13_ = gwibber_gtk_account_target_bar_create_button (self, account);
				account_button = _tmp13_;
				_tmp14_ = gwibber_account_get_id (account);
				gee_abstract_map_set ((GeeAbstractMap*) self->accounts_buttons_map, _tmp14_, account_button);
				_g_object_unref0 (account_button);
				_g_object_unref0 (account);
			}
		}
	}
	_tmp15_ = _ ("Send");
	_tmp16_ = (GtkButton*) gtk_button_new_with_label (_tmp15_);
	_g_object_unref0 (self->send);
	self->send = g_object_ref_sink (_tmp16_);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) self->send, FALSE, FALSE, (guint) 0);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->count);
	self->count = g_object_ref_sink (_tmp17_);
	_tmp18_ = g_strdup_printf ("%i", GWIBBER_GTK_MAX_MESSAGE_LENGTH);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat ("<b>", _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, "</b>", NULL);
	_tmp23_ = _tmp22_;
	gtk_label_set_markup (self->count, _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) self->count, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_tmp24_ = gwibber_connection_is_connected (self->conn_service);
	gtk_widget_set_sensitive ((GtkWidget*) self->send, _tmp24_);
	g_signal_connect_object (self->conn_service, "connection-changed", (GCallback) __lambda8__gwibber_connection_connection_changed, self, 0);
	g_signal_connect_object (self->accounts_service, "updated", (GCallback) __lambda9__gwibber_accounts_updated, self, 0);
	g_signal_connect_object (self->accounts_service, "created", (GCallback) __lambda10__gwibber_accounts_created, self, 0);
	g_signal_connect_object (self->accounts_service, "deleted", (GCallback) __lambda11__gwibber_accounts_deleted, self, 0);
	__g_list_free__g_object_unref0_0 (accounts_list);
	_g_object_unref0 (send_with_label);
	_g_object_unref0 (box);
	return obj;
}


static void gwibber_gtk_account_target_bar_class_init (GwibberGtkAccountTargetBarClass * klass) {
	gwibber_gtk_account_target_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkAccountTargetBarPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_account_target_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_account_target_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_account_target_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_account_target_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACCOUNT_TARGET_BAR_SELECTED, g_param_spec_string ("selected", "selected", "selected", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gwibber_gtk_account_target_bar_instance_init (GwibberGtkAccountTargetBar * self) {
	self->priv = GWIBBER_GTK_ACCOUNT_TARGET_BAR_GET_PRIVATE (self);
	self->priv->_selected = NULL;
}


static void gwibber_gtk_account_target_bar_finalize (GObject* obj) {
	GwibberGtkAccountTargetBar * self;
	self = GWIBBER_GTK_ACCOUNT_TARGET_BAR (obj);
	_g_object_unref0 (self->accounts_service);
	_g_object_unref0 (self->conn_service);
	_g_object_unref0 (self->send);
	_g_object_unref0 (self->count);
	_g_object_unref0 (self->accounts_buttons_map);
	_g_object_unref0 (self->priv->abox);
	_g_free0 (self->priv->_selected);
	G_OBJECT_CLASS (gwibber_gtk_account_target_bar_parent_class)->finalize (obj);
}


GType gwibber_gtk_account_target_bar_get_type (void) {
	static volatile gsize gwibber_gtk_account_target_bar_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_account_target_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkAccountTargetBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_account_target_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkAccountTargetBar), 0, (GInstanceInitFunc) gwibber_gtk_account_target_bar_instance_init, NULL };
		GType gwibber_gtk_account_target_bar_type_id;
		gwibber_gtk_account_target_bar_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberGtkAccountTargetBar", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_account_target_bar_type_id__volatile, gwibber_gtk_account_target_bar_type_id);
	}
	return gwibber_gtk_account_target_bar_type_id__volatile;
}


static void _vala_gwibber_gtk_account_target_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkAccountTargetBar * self;
	self = GWIBBER_GTK_ACCOUNT_TARGET_BAR (object);
	switch (property_id) {
		case GWIBBER_GTK_ACCOUNT_TARGET_BAR_SELECTED:
		g_value_set_string (value, gwibber_gtk_account_target_bar_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_account_target_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkAccountTargetBar * self;
	self = GWIBBER_GTK_ACCOUNT_TARGET_BAR (object);
	switch (property_id) {
		case GWIBBER_GTK_ACCOUNT_TARGET_BAR_SELECTED:
		gwibber_gtk_account_target_bar_set_selected (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GwibberGtkSendBar* gwibber_gtk_send_bar_construct (GType object_type, GwibberService* service) {
	GwibberGtkSendBar * self = NULL;
	g_return_val_if_fail (service != NULL, NULL);
	self = (GwibberGtkSendBar*) g_object_new (object_type, "service", service, "spacing", 5, NULL);
	return self;
}


GwibberGtkSendBar* gwibber_gtk_send_bar_new (GwibberService* service) {
	return gwibber_gtk_send_bar_construct (GWIBBER_GTK_TYPE_SEND_BAR, service);
}


GwibberService* gwibber_gtk_send_bar_get_service (GwibberGtkSendBar* self) {
	GwibberService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


static void gwibber_gtk_send_bar_set_service (GwibberGtkSendBar* self, GwibberService* value) {
	GwibberService* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp0_;
	g_object_notify ((GObject *) self, "service");
}


static GObject * gwibber_gtk_send_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkSendBar * self;
	GtkHBox* _tmp0_ = NULL;
	GtkHBox* box;
	const gchar* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_send_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_SEND_BAR (obj);
	_tmp0_ = (GtkHBox*) gtk_hbox_new (FALSE, 0);
	box = g_object_ref_sink (_tmp0_);
	_tmp1_ = _ ("Send");
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_tmp1_);
	_g_object_unref0 (self->send);
	self->send = g_object_ref_sink (_tmp2_);
	gtk_box_pack_end ((GtkBox*) box, (GtkWidget*) self->send, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_g_object_unref0 (box);
	return obj;
}


static void gwibber_gtk_send_bar_class_init (GwibberGtkSendBarClass * klass) {
	gwibber_gtk_send_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkSendBarPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_send_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_send_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_send_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_send_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_SEND_BAR_SERVICE, g_param_spec_object ("service", "service", "service", GWIBBER_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gwibber_gtk_send_bar_instance_init (GwibberGtkSendBar * self) {
	self->priv = GWIBBER_GTK_SEND_BAR_GET_PRIVATE (self);
}


static void gwibber_gtk_send_bar_finalize (GObject* obj) {
	GwibberGtkSendBar * self;
	self = GWIBBER_GTK_SEND_BAR (obj);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->send);
	G_OBJECT_CLASS (gwibber_gtk_send_bar_parent_class)->finalize (obj);
}


GType gwibber_gtk_send_bar_get_type (void) {
	static volatile gsize gwibber_gtk_send_bar_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_send_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkSendBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_send_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkSendBar), 0, (GInstanceInitFunc) gwibber_gtk_send_bar_instance_init, NULL };
		GType gwibber_gtk_send_bar_type_id;
		gwibber_gtk_send_bar_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberGtkSendBar", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_send_bar_type_id__volatile, gwibber_gtk_send_bar_type_id);
	}
	return gwibber_gtk_send_bar_type_id__volatile;
}


static void _vala_gwibber_gtk_send_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkSendBar * self;
	self = GWIBBER_GTK_SEND_BAR (object);
	switch (property_id) {
		case GWIBBER_GTK_SEND_BAR_SERVICE:
		g_value_set_object (value, gwibber_gtk_send_bar_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_send_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkSendBar * self;
	self = GWIBBER_GTK_SEND_BAR (object);
	switch (property_id) {
		case GWIBBER_GTK_SEND_BAR_SERVICE:
		gwibber_gtk_send_bar_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



