/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

public class PublicItem : TabBarStreamItem
{
  public PublicItem (Gee.HashMap streams)
  {
    Object (stream:"public", icon_name:"emblem-web", tooltip:_("Public"), streams:streams);
  }

  construct
  {
    set_no_show_all (true);
    view.model.row_added.connect (on_row_added);
  }

  private void on_row_added ()
  {
    set_no_show_all (false);
    show_all();
  }

  public override Gtk.Widget? get_toolbar ()
  {
    return null;
  }
  
  public override Gtk.Widget? get_view ()
  {
    return view;
  }
}
