
# Generated by genmk.rb, please don't edit!
# -*- makefile -*-

COMMON_ASFLAGS += -nostdinc
COMMON_CFLAGS += -ffreestanding -mexplicit-relocs -mflush-func=grub_cpu_flush_cache
COMMON_LDFLAGS += -nostdlib

# Used by various components.  These rules need to precede them.
script/lexer.c_DEPENDENCIES = grub_script.tab.h

# Images.

MOSTLYCLEANFILES += symlist.c kernel_syms.lst
DEFSYMFILES += kernel_syms.lst

kernel_img_HEADERS += boot.h cache.h device.h disk.h dl.h elf.h elfload.h \
	env.h err.h file.h fs.h kernel.h misc.h mm.h net.h parser.h reader.h \
	symbol.h term.h time.h types.h loader.h partition.h \
	msdos_partition.h machine/kernel.h handler.h list.h \
	command.h machine/memory.h cpu/libgcc.h cpu/cache.h i18n.h env_private.h

ifeq ($(platform), yeeloong)
kernel_img_HEADERS += pci.h
endif

symlist.c: $(addprefix include/grub/,$(kernel_img_HEADERS)) config.h gensymlist.sh
	/bin/sh gensymlist.sh $(filter %.h,$^) > $@ || (rm -f $@; exit 1)

kernel_syms.lst: $(addprefix include/grub/,$(kernel_img_HEADERS)) config.h genkernsyms.sh
	/bin/sh genkernsyms.sh $(filter %.h,$^) > $@ || (rm -f $@; exit 1)

# Scripts.
sbin_SCRIPTS = 
bin_SCRIPTS = 

# For grub-mkimage.
bin_UTILITIES += grub-mkimage
grub_mkimage_SOURCES = gnulib/progname.c util/grub-mkrawimage.c util/misc.c \
	util/resolve.c lib/LzmaEnc.c lib/LzFind.c

clean-utility-grub-mkimage.1:
	rm -f grub-mkimage$(EXEEXT) grub_mkimage-gnulib_progname.o grub_mkimage-util_grub_mkrawimage.o grub_mkimage-util_misc.o grub_mkimage-util_resolve.o grub_mkimage-lib_LzmaEnc.o grub_mkimage-lib_LzFind.o

CLEAN_UTILITY_TARGETS += clean-utility-grub-mkimage.1

mostlyclean-utility-grub-mkimage.1:
	rm -f grub_mkimage-gnulib_progname.d grub_mkimage-util_grub_mkrawimage.d grub_mkimage-util_misc.d grub_mkimage-util_resolve.d grub_mkimage-lib_LzmaEnc.d grub_mkimage-lib_LzFind.d

MOSTLYCLEAN_UTILITY_TARGETS += mostlyclean-utility-grub-mkimage.1

grub_mkimage_OBJECTS += grub_mkimage-gnulib_progname.o grub_mkimage-util_grub_mkrawimage.o grub_mkimage-util_misc.o grub_mkimage-util_resolve.o grub_mkimage-lib_LzmaEnc.o grub_mkimage-lib_LzFind.o

grub_mkimage-gnulib_progname.o: gnulib/progname.c $(gnulib/progname.c_DEPENDENCIES)
	$(CC) -Ignulib -I$(srcdir)/gnulib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-gnulib_progname.d

grub_mkimage-util_grub_mkrawimage.o: util/grub-mkrawimage.c $(util/grub-mkrawimage.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-util_grub_mkrawimage.d

grub_mkimage-util_misc.o: util/misc.c $(util/misc.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-util_misc.d

grub_mkimage-util_resolve.o: util/resolve.c $(util/resolve.c_DEPENDENCIES)
	$(CC) -Iutil -I$(srcdir)/util $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-util_resolve.d

grub_mkimage-lib_LzmaEnc.o: lib/LzmaEnc.c $(lib/LzmaEnc.c_DEPENDENCIES)
	$(CC) -Ilib -I$(srcdir)/lib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-lib_LzmaEnc.d

grub_mkimage-lib_LzFind.o: lib/LzFind.c $(lib/LzFind.c_DEPENDENCIES)
	$(CC) -Ilib -I$(srcdir)/lib $(CPPFLAGS) $(CFLAGS) -DGRUB_UTIL=1 $(grub_mkimage_CFLAGS) -MD -c -o $@ $<
-include grub_mkimage-lib_LzFind.d

grub_mkimage_CFLAGS = -DGRUB_KERNEL_MACHINE_LINK_ADDR=$(LINK_BASE)
util/grub-mkrawimage.c_DEPENDENCIES = Makefile

# Modules.
pkglib_MODULES = memdisk.mod \
	lsmmap.mod

# For boot.mod.
pkglib_MODULES += boot.mod 
boot_mod_SOURCES = commands/boot.c lib/i386/pc/biosnum.c

clean-module-boot.mod.1:
	rm -f boot.mod mod-boot.o mod-boot.c pre-boot.o boot_mod-commands_boot.o boot_mod-lib_i386_pc_biosnum.o und-boot.lst

CLEAN_MODULE_TARGETS += clean-module-boot.mod.1

clean-module-boot.mod-symbol.1:
	rm -f def-boot.lst

CLEAN_MODULE_TARGETS += clean-module-boot.mod-symbol.1
DEFSYMFILES += def-boot.lst
mostlyclean-module-boot.mod.1:
	rm -f boot_mod-commands_boot.d boot_mod-lib_i386_pc_biosnum.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-boot.mod.1
UNDSYMFILES += und-boot.lst

ifneq ($(TARGET_APPLE_CC),1)
boot.mod: pre-boot.o mod-boot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(boot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-boot.o mod-boot.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
boot.mod: pre-boot.o mod-boot.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(boot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-boot.o mod-boot.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-boot.o: $(boot_mod_DEPENDENCIES) boot_mod-commands_boot.o boot_mod-lib_i386_pc_biosnum.o
	-rm -f $@
	$(TARGET_CC) $(boot_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ boot_mod-commands_boot.o boot_mod-lib_i386_pc_biosnum.o

mod-boot.o: mod-boot.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -c -o $@ $<

mod-boot.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'boot' $< > $@ || (rm -f $@; exit 1)

ifneq ($(TARGET_APPLE_CC),1)
def-boot.lst: pre-boot.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 boot/' > $@
else
def-boot.lst: pre-boot.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 boot/' > $@
endif

und-boot.lst: pre-boot.o
	echo 'boot' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

boot_mod-commands_boot.o: commands/boot.c $(commands/boot.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -MD -c -o $@ $<
-include boot_mod-commands_boot.d

clean-module-boot_mod-commands_boot-extra.1:
	rm -f cmd-boot_mod-commands_boot.lst fs-boot_mod-commands_boot.lst partmap-boot_mod-commands_boot.lst handler-boot_mod-commands_boot.lst parttool-boot_mod-commands_boot.lst video-boot_mod-commands_boot.lst terminal-boot_mod-commands_boot.lst

CLEAN_MODULE_TARGETS += clean-module-boot_mod-commands_boot-extra.1

COMMANDFILES += cmd-boot_mod-commands_boot.lst
FSFILES += fs-boot_mod-commands_boot.lst
PARTTOOLFILES += parttool-boot_mod-commands_boot.lst
PARTMAPFILES += partmap-boot_mod-commands_boot.lst
HANDLERFILES += handler-boot_mod-commands_boot.lst
TERMINALFILES += terminal-boot_mod-commands_boot.lst
VIDEOFILES += video-boot_mod-commands_boot.lst

cmd-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh boot > $@ || (rm -f $@; exit 1)

fs-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh boot > $@ || (rm -f $@; exit 1)

parttool-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh boot > $@ || (rm -f $@; exit 1)

partmap-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh boot > $@ || (rm -f $@; exit 1)

handler-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh boot > $@ || (rm -f $@; exit 1)

terminal-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genterminallist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genterminallist.sh boot > $@ || (rm -f $@; exit 1)

video-boot_mod-commands_boot.lst: commands/boot.c $(commands/boot.c_DEPENDENCIES) genvideolist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genvideolist.sh boot > $@ || (rm -f $@; exit 1)

boot_mod-lib_i386_pc_biosnum.o: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES)
	$(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -MD -c -o $@ $<
-include boot_mod-lib_i386_pc_biosnum.d

clean-module-boot_mod-lib_i386_pc_biosnum-extra.1:
	rm -f cmd-boot_mod-lib_i386_pc_biosnum.lst fs-boot_mod-lib_i386_pc_biosnum.lst partmap-boot_mod-lib_i386_pc_biosnum.lst handler-boot_mod-lib_i386_pc_biosnum.lst parttool-boot_mod-lib_i386_pc_biosnum.lst video-boot_mod-lib_i386_pc_biosnum.lst terminal-boot_mod-lib_i386_pc_biosnum.lst

CLEAN_MODULE_TARGETS += clean-module-boot_mod-lib_i386_pc_biosnum-extra.1

COMMANDFILES += cmd-boot_mod-lib_i386_pc_biosnum.lst
FSFILES += fs-boot_mod-lib_i386_pc_biosnum.lst
PARTTOOLFILES += parttool-boot_mod-lib_i386_pc_biosnum.lst
PARTMAPFILES += partmap-boot_mod-lib_i386_pc_biosnum.lst
HANDLERFILES += handler-boot_mod-lib_i386_pc_biosnum.lst
TERMINALFILES += terminal-boot_mod-lib_i386_pc_biosnum.lst
VIDEOFILES += video-boot_mod-lib_i386_pc_biosnum.lst

cmd-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh boot > $@ || (rm -f $@; exit 1)

fs-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh boot > $@ || (rm -f $@; exit 1)

parttool-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh boot > $@ || (rm -f $@; exit 1)

partmap-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh boot > $@ || (rm -f $@; exit 1)

handler-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh boot > $@ || (rm -f $@; exit 1)

terminal-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genterminallist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genterminallist.sh boot > $@ || (rm -f $@; exit 1)

video-boot_mod-lib_i386_pc_biosnum.lst: lib/i386/pc/biosnum.c $(lib/i386/pc/biosnum.c_DEPENDENCIES) genvideolist.sh
	set -e; 	  $(TARGET_CC) -Ilib/i386/pc -I$(srcdir)/lib/i386/pc $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(boot_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genvideolist.sh boot > $@ || (rm -f $@; exit 1)

boot_mod_CFLAGS = $(COMMON_CFLAGS)
boot_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For memdisk.mod.
memdisk_mod_SOURCES = disk/memdisk.c

clean-module-memdisk.mod.1:
	rm -f memdisk.mod mod-memdisk.o mod-memdisk.c pre-memdisk.o memdisk_mod-disk_memdisk.o und-memdisk.lst

CLEAN_MODULE_TARGETS += clean-module-memdisk.mod.1

clean-module-memdisk.mod-symbol.1:
	rm -f def-memdisk.lst

CLEAN_MODULE_TARGETS += clean-module-memdisk.mod-symbol.1
DEFSYMFILES += def-memdisk.lst
mostlyclean-module-memdisk.mod.1:
	rm -f memdisk_mod-disk_memdisk.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-memdisk.mod.1
UNDSYMFILES += und-memdisk.lst

ifneq ($(TARGET_APPLE_CC),1)
memdisk.mod: pre-memdisk.o mod-memdisk.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(memdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-memdisk.o mod-memdisk.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
memdisk.mod: pre-memdisk.o mod-memdisk.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(memdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-memdisk.o mod-memdisk.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-memdisk.o: $(memdisk_mod_DEPENDENCIES) memdisk_mod-disk_memdisk.o
	-rm -f $@
	$(TARGET_CC) $(memdisk_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ memdisk_mod-disk_memdisk.o

mod-memdisk.o: mod-memdisk.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -c -o $@ $<

mod-memdisk.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'memdisk' $< > $@ || (rm -f $@; exit 1)

ifneq ($(TARGET_APPLE_CC),1)
def-memdisk.lst: pre-memdisk.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 memdisk/' > $@
else
def-memdisk.lst: pre-memdisk.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 memdisk/' > $@
endif

und-memdisk.lst: pre-memdisk.o
	echo 'memdisk' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

memdisk_mod-disk_memdisk.o: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES)
	$(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -MD -c -o $@ $<
-include memdisk_mod-disk_memdisk.d

clean-module-memdisk_mod-disk_memdisk-extra.1:
	rm -f cmd-memdisk_mod-disk_memdisk.lst fs-memdisk_mod-disk_memdisk.lst partmap-memdisk_mod-disk_memdisk.lst handler-memdisk_mod-disk_memdisk.lst parttool-memdisk_mod-disk_memdisk.lst video-memdisk_mod-disk_memdisk.lst terminal-memdisk_mod-disk_memdisk.lst

CLEAN_MODULE_TARGETS += clean-module-memdisk_mod-disk_memdisk-extra.1

COMMANDFILES += cmd-memdisk_mod-disk_memdisk.lst
FSFILES += fs-memdisk_mod-disk_memdisk.lst
PARTTOOLFILES += parttool-memdisk_mod-disk_memdisk.lst
PARTMAPFILES += partmap-memdisk_mod-disk_memdisk.lst
HANDLERFILES += handler-memdisk_mod-disk_memdisk.lst
TERMINALFILES += terminal-memdisk_mod-disk_memdisk.lst
VIDEOFILES += video-memdisk_mod-disk_memdisk.lst

cmd-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh memdisk > $@ || (rm -f $@; exit 1)

fs-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh memdisk > $@ || (rm -f $@; exit 1)

parttool-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh memdisk > $@ || (rm -f $@; exit 1)

partmap-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh memdisk > $@ || (rm -f $@; exit 1)

handler-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh memdisk > $@ || (rm -f $@; exit 1)

terminal-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genterminallist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genterminallist.sh memdisk > $@ || (rm -f $@; exit 1)

video-memdisk_mod-disk_memdisk.lst: disk/memdisk.c $(disk/memdisk.c_DEPENDENCIES) genvideolist.sh
	set -e; 	  $(TARGET_CC) -Idisk -I$(srcdir)/disk $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(memdisk_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genvideolist.sh memdisk > $@ || (rm -f $@; exit 1)

memdisk_mod_CFLAGS = $(COMMON_CFLAGS)
memdisk_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For lsmmap.mod
lsmmap_mod_SOURCES = commands/lsmmap.c

clean-module-lsmmap.mod.1:
	rm -f lsmmap.mod mod-lsmmap.o mod-lsmmap.c pre-lsmmap.o lsmmap_mod-commands_lsmmap.o und-lsmmap.lst

CLEAN_MODULE_TARGETS += clean-module-lsmmap.mod.1

clean-module-lsmmap.mod-symbol.1:
	rm -f def-lsmmap.lst

CLEAN_MODULE_TARGETS += clean-module-lsmmap.mod-symbol.1
DEFSYMFILES += def-lsmmap.lst
mostlyclean-module-lsmmap.mod.1:
	rm -f lsmmap_mod-commands_lsmmap.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-lsmmap.mod.1
UNDSYMFILES += und-lsmmap.lst

ifneq ($(TARGET_APPLE_CC),1)
lsmmap.mod: pre-lsmmap.o mod-lsmmap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(lsmmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-lsmmap.o mod-lsmmap.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
lsmmap.mod: pre-lsmmap.o mod-lsmmap.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(lsmmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-lsmmap.o mod-lsmmap.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-lsmmap.o: $(lsmmap_mod_DEPENDENCIES) lsmmap_mod-commands_lsmmap.o
	-rm -f $@
	$(TARGET_CC) $(lsmmap_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ lsmmap_mod-commands_lsmmap.o

mod-lsmmap.o: mod-lsmmap.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -c -o $@ $<

mod-lsmmap.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'lsmmap' $< > $@ || (rm -f $@; exit 1)

ifneq ($(TARGET_APPLE_CC),1)
def-lsmmap.lst: pre-lsmmap.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 lsmmap/' > $@
else
def-lsmmap.lst: pre-lsmmap.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 lsmmap/' > $@
endif

und-lsmmap.lst: pre-lsmmap.o
	echo 'lsmmap' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

lsmmap_mod-commands_lsmmap.o: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES)
	$(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -MD -c -o $@ $<
-include lsmmap_mod-commands_lsmmap.d

clean-module-lsmmap_mod-commands_lsmmap-extra.1:
	rm -f cmd-lsmmap_mod-commands_lsmmap.lst fs-lsmmap_mod-commands_lsmmap.lst partmap-lsmmap_mod-commands_lsmmap.lst handler-lsmmap_mod-commands_lsmmap.lst parttool-lsmmap_mod-commands_lsmmap.lst video-lsmmap_mod-commands_lsmmap.lst terminal-lsmmap_mod-commands_lsmmap.lst

CLEAN_MODULE_TARGETS += clean-module-lsmmap_mod-commands_lsmmap-extra.1

COMMANDFILES += cmd-lsmmap_mod-commands_lsmmap.lst
FSFILES += fs-lsmmap_mod-commands_lsmmap.lst
PARTTOOLFILES += parttool-lsmmap_mod-commands_lsmmap.lst
PARTMAPFILES += partmap-lsmmap_mod-commands_lsmmap.lst
HANDLERFILES += handler-lsmmap_mod-commands_lsmmap.lst
TERMINALFILES += terminal-lsmmap_mod-commands_lsmmap.lst
VIDEOFILES += video-lsmmap_mod-commands_lsmmap.lst

cmd-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh lsmmap > $@ || (rm -f $@; exit 1)

fs-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh lsmmap > $@ || (rm -f $@; exit 1)

parttool-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh lsmmap > $@ || (rm -f $@; exit 1)

partmap-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh lsmmap > $@ || (rm -f $@; exit 1)

handler-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh lsmmap > $@ || (rm -f $@; exit 1)

terminal-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genterminallist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genterminallist.sh lsmmap > $@ || (rm -f $@; exit 1)

video-lsmmap_mod-commands_lsmmap.lst: commands/lsmmap.c $(commands/lsmmap.c_DEPENDENCIES) genvideolist.sh
	set -e; 	  $(TARGET_CC) -Icommands -I$(srcdir)/commands $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(lsmmap_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genvideolist.sh lsmmap > $@ || (rm -f $@; exit 1)

lsmmap_mod_CFLAGS = $(COMMON_CFLAGS)
lsmmap_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For serial.mod.
pkglib_MODULES += serial.mod
serial_mod_SOURCES = term/serial.c

clean-module-serial.mod.1:
	rm -f serial.mod mod-serial.o mod-serial.c pre-serial.o serial_mod-term_serial.o und-serial.lst

CLEAN_MODULE_TARGETS += clean-module-serial.mod.1

clean-module-serial.mod-symbol.1:
	rm -f def-serial.lst

CLEAN_MODULE_TARGETS += clean-module-serial.mod-symbol.1
DEFSYMFILES += def-serial.lst
mostlyclean-module-serial.mod.1:
	rm -f serial_mod-term_serial.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-serial.mod.1
UNDSYMFILES += und-serial.lst

ifneq ($(TARGET_APPLE_CC),1)
serial.mod: pre-serial.o mod-serial.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(serial_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-serial.o mod-serial.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
serial.mod: pre-serial.o mod-serial.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(serial_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-serial.o mod-serial.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-serial.o: $(serial_mod_DEPENDENCIES) serial_mod-term_serial.o
	-rm -f $@
	$(TARGET_CC) $(serial_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ serial_mod-term_serial.o

mod-serial.o: mod-serial.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -c -o $@ $<

mod-serial.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'serial' $< > $@ || (rm -f $@; exit 1)

ifneq ($(TARGET_APPLE_CC),1)
def-serial.lst: pre-serial.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 serial/' > $@
else
def-serial.lst: pre-serial.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 serial/' > $@
endif

und-serial.lst: pre-serial.o
	echo 'serial' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

serial_mod-term_serial.o: term/serial.c $(term/serial.c_DEPENDENCIES)
	$(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -MD -c -o $@ $<
-include serial_mod-term_serial.d

clean-module-serial_mod-term_serial-extra.1:
	rm -f cmd-serial_mod-term_serial.lst fs-serial_mod-term_serial.lst partmap-serial_mod-term_serial.lst handler-serial_mod-term_serial.lst parttool-serial_mod-term_serial.lst video-serial_mod-term_serial.lst terminal-serial_mod-term_serial.lst

CLEAN_MODULE_TARGETS += clean-module-serial_mod-term_serial-extra.1

COMMANDFILES += cmd-serial_mod-term_serial.lst
FSFILES += fs-serial_mod-term_serial.lst
PARTTOOLFILES += parttool-serial_mod-term_serial.lst
PARTMAPFILES += partmap-serial_mod-term_serial.lst
HANDLERFILES += handler-serial_mod-term_serial.lst
TERMINALFILES += terminal-serial_mod-term_serial.lst
VIDEOFILES += video-serial_mod-term_serial.lst

cmd-serial_mod-term_serial.lst: term/serial.c $(term/serial.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh serial > $@ || (rm -f $@; exit 1)

fs-serial_mod-term_serial.lst: term/serial.c $(term/serial.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh serial > $@ || (rm -f $@; exit 1)

parttool-serial_mod-term_serial.lst: term/serial.c $(term/serial.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh serial > $@ || (rm -f $@; exit 1)

partmap-serial_mod-term_serial.lst: term/serial.c $(term/serial.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh serial > $@ || (rm -f $@; exit 1)

handler-serial_mod-term_serial.lst: term/serial.c $(term/serial.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh serial > $@ || (rm -f $@; exit 1)

terminal-serial_mod-term_serial.lst: term/serial.c $(term/serial.c_DEPENDENCIES) genterminallist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genterminallist.sh serial > $@ || (rm -f $@; exit 1)

video-serial_mod-term_serial.lst: term/serial.c $(term/serial.c_DEPENDENCIES) genvideolist.sh
	set -e; 	  $(TARGET_CC) -Iterm -I$(srcdir)/term $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(serial_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genvideolist.sh serial > $@ || (rm -f $@; exit 1)

serial_mod_CFLAGS = $(COMMON_CFLAGS)
serial_mod_LDFLAGS = $(COMMON_LDFLAGS)

# For relocator.mod.
pkglib_MODULES += relocator.mod
relocator_mod_SOURCES = lib/$(target_cpu)/relocator.c lib/$(target_cpu)/relocator_asm.S

clean-module-relocator.mod.1:
	rm -f relocator.mod mod-relocator.o mod-relocator.c pre-relocator.o relocator_mod-lib___target_cpu__relocator.o relocator_mod-lib___target_cpu__relocator_asm.o und-relocator.lst

CLEAN_MODULE_TARGETS += clean-module-relocator.mod.1

clean-module-relocator.mod-symbol.1:
	rm -f def-relocator.lst

CLEAN_MODULE_TARGETS += clean-module-relocator.mod-symbol.1
DEFSYMFILES += def-relocator.lst
mostlyclean-module-relocator.mod.1:
	rm -f relocator_mod-lib___target_cpu__relocator.d relocator_mod-lib___target_cpu__relocator_asm.d

MOSTLYCLEAN_MODULE_TARGETS += mostlyclean-module-relocator.mod.1
UNDSYMFILES += und-relocator.lst

ifneq ($(TARGET_APPLE_CC),1)
relocator.mod: pre-relocator.o mod-relocator.o $(TARGET_OBJ2ELF)
	-rm -f $@
	$(TARGET_CC) $(relocator_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ pre-relocator.o mod-relocator.o
	if test ! -z "$(TARGET_OBJ2ELF)"; then ./$(TARGET_OBJ2ELF) $@ || (rm -f $@; exit 1); fi
	$(STRIP) --strip-unneeded -K grub_mod_init -K grub_mod_fini -K _grub_mod_init -K _grub_mod_fini -R .note -R .comment $@
else
relocator.mod: pre-relocator.o mod-relocator.o $(TARGET_OBJ2ELF)
	-rm -f $@
	-rm -f $@.bin
	$(TARGET_CC) $(relocator_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@.bin pre-relocator.o mod-relocator.o
	$(OBJCONV) -f$(TARGET_MODULE_FORMAT) -nr:_grub_mod_init:grub_mod_init -nr:_grub_mod_fini:grub_mod_fini -wd1106 -nu -nd $@.bin $@
	-rm -f $@.bin
endif

pre-relocator.o: $(relocator_mod_DEPENDENCIES) relocator_mod-lib___target_cpu__relocator.o relocator_mod-lib___target_cpu__relocator_asm.o
	-rm -f $@
	$(TARGET_CC) $(relocator_mod_LDFLAGS) $(TARGET_LDFLAGS) -Wl,-r,-d -o $@ relocator_mod-lib___target_cpu__relocator.o relocator_mod-lib___target_cpu__relocator_asm.o

mod-relocator.o: mod-relocator.c
	$(TARGET_CC) $(TARGET_CPPFLAGS) $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -c -o $@ $<

mod-relocator.c: $(builddir)/moddep.lst $(srcdir)/genmodsrc.sh
	sh $(srcdir)/genmodsrc.sh 'relocator' $< > $@ || (rm -f $@; exit 1)

ifneq ($(TARGET_APPLE_CC),1)
def-relocator.lst: pre-relocator.o
	$(NM) -g --defined-only -P -p $< | sed 's/^\([^ ]*\).*/\1 relocator/' > $@
else
def-relocator.lst: pre-relocator.o
	$(NM) -g -P -p $< | grep -E '^[a-zA-Z0-9_]* [TDS]'  | sed 's/^\([^ ]*\).*/\1 relocator/' > $@
endif

und-relocator.lst: pre-relocator.o
	echo 'relocator' > $@
	$(NM) -u -P -p $< | cut -f1 -d' ' >> $@

relocator_mod-lib___target_cpu__relocator.o: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES)
	$(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -MD -c -o $@ $<
-include relocator_mod-lib___target_cpu__relocator.d

clean-module-relocator_mod-lib___target_cpu__relocator-extra.1:
	rm -f cmd-relocator_mod-lib___target_cpu__relocator.lst fs-relocator_mod-lib___target_cpu__relocator.lst partmap-relocator_mod-lib___target_cpu__relocator.lst handler-relocator_mod-lib___target_cpu__relocator.lst parttool-relocator_mod-lib___target_cpu__relocator.lst video-relocator_mod-lib___target_cpu__relocator.lst terminal-relocator_mod-lib___target_cpu__relocator.lst

CLEAN_MODULE_TARGETS += clean-module-relocator_mod-lib___target_cpu__relocator-extra.1

COMMANDFILES += cmd-relocator_mod-lib___target_cpu__relocator.lst
FSFILES += fs-relocator_mod-lib___target_cpu__relocator.lst
PARTTOOLFILES += parttool-relocator_mod-lib___target_cpu__relocator.lst
PARTMAPFILES += partmap-relocator_mod-lib___target_cpu__relocator.lst
HANDLERFILES += handler-relocator_mod-lib___target_cpu__relocator.lst
TERMINALFILES += terminal-relocator_mod-lib___target_cpu__relocator.lst
VIDEOFILES += video-relocator_mod-lib___target_cpu__relocator.lst

cmd-relocator_mod-lib___target_cpu__relocator.lst: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh relocator > $@ || (rm -f $@; exit 1)

fs-relocator_mod-lib___target_cpu__relocator.lst: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh relocator > $@ || (rm -f $@; exit 1)

parttool-relocator_mod-lib___target_cpu__relocator.lst: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh relocator > $@ || (rm -f $@; exit 1)

partmap-relocator_mod-lib___target_cpu__relocator.lst: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh relocator > $@ || (rm -f $@; exit 1)

handler-relocator_mod-lib___target_cpu__relocator.lst: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh relocator > $@ || (rm -f $@; exit 1)

terminal-relocator_mod-lib___target_cpu__relocator.lst: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES) genterminallist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genterminallist.sh relocator > $@ || (rm -f $@; exit 1)

video-relocator_mod-lib___target_cpu__relocator.lst: lib/$(target_cpu)/relocator.c $(lib/$(target_cpu)/relocator.c_DEPENDENCIES) genvideolist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS)  $(TARGET_CFLAGS) $(relocator_mod_CFLAGS) -E $< 	  | sh $(srcdir)/genvideolist.sh relocator > $@ || (rm -f $@; exit 1)

relocator_mod-lib___target_cpu__relocator_asm.o: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES)
	$(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -MD -c -o $@ $<
-include relocator_mod-lib___target_cpu__relocator_asm.d

clean-module-relocator_mod-lib___target_cpu__relocator_asm-extra.1:
	rm -f cmd-relocator_mod-lib___target_cpu__relocator_asm.lst fs-relocator_mod-lib___target_cpu__relocator_asm.lst partmap-relocator_mod-lib___target_cpu__relocator_asm.lst handler-relocator_mod-lib___target_cpu__relocator_asm.lst parttool-relocator_mod-lib___target_cpu__relocator_asm.lst video-relocator_mod-lib___target_cpu__relocator_asm.lst terminal-relocator_mod-lib___target_cpu__relocator_asm.lst

CLEAN_MODULE_TARGETS += clean-module-relocator_mod-lib___target_cpu__relocator_asm-extra.1

COMMANDFILES += cmd-relocator_mod-lib___target_cpu__relocator_asm.lst
FSFILES += fs-relocator_mod-lib___target_cpu__relocator_asm.lst
PARTTOOLFILES += parttool-relocator_mod-lib___target_cpu__relocator_asm.lst
PARTMAPFILES += partmap-relocator_mod-lib___target_cpu__relocator_asm.lst
HANDLERFILES += handler-relocator_mod-lib___target_cpu__relocator_asm.lst
TERMINALFILES += terminal-relocator_mod-lib___target_cpu__relocator_asm.lst
VIDEOFILES += video-relocator_mod-lib___target_cpu__relocator_asm.lst

cmd-relocator_mod-lib___target_cpu__relocator_asm.lst: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES) gencmdlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/gencmdlist.sh relocator > $@ || (rm -f $@; exit 1)

fs-relocator_mod-lib___target_cpu__relocator_asm.lst: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES) genfslist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genfslist.sh relocator > $@ || (rm -f $@; exit 1)

parttool-relocator_mod-lib___target_cpu__relocator_asm.lst: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES) genparttoollist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genparttoollist.sh relocator > $@ || (rm -f $@; exit 1)

partmap-relocator_mod-lib___target_cpu__relocator_asm.lst: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES) genpartmaplist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genpartmaplist.sh relocator > $@ || (rm -f $@; exit 1)

handler-relocator_mod-lib___target_cpu__relocator_asm.lst: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES) genhandlerlist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genhandlerlist.sh relocator > $@ || (rm -f $@; exit 1)

terminal-relocator_mod-lib___target_cpu__relocator_asm.lst: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES) genterminallist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genterminallist.sh relocator > $@ || (rm -f $@; exit 1)

video-relocator_mod-lib___target_cpu__relocator_asm.lst: lib/$(target_cpu)/relocator_asm.S $(lib/$(target_cpu)/relocator_asm.S_DEPENDENCIES) genvideolist.sh
	set -e; 	  $(TARGET_CC) -Ilib/$(target_cpu) -I$(srcdir)/lib/$(target_cpu) $(TARGET_CPPFLAGS) -DASM_FILE=1 $(TARGET_ASFLAGS) $(relocator_mod_ASFLAGS) -E $< 	  | sh $(srcdir)/genvideolist.sh relocator > $@ || (rm -f $@; exit 1)

relocator_mod_CFLAGS = $(COMMON_CFLAGS)
relocator_mod_ASFLAGS = $(COMMON_ASFLAGS)
relocator_mod_LDFLAGS = $(COMMON_LDFLAGS)

include $(srcdir)/conf/common.mk
grub-mkimage: $(grub_mkimage_DEPENDENCIES) $(grub_mkimage_OBJECTS)
	$(CC) -o $@ $(grub_mkimage_OBJECTS) $(LDFLAGS) $(grub_mkimage_LDFLAGS)

