#ifndef FRAME_MOCK_H
#define FRAME_MOCK_H

#include <oif/frame.h>
#include <oif/frame_x11.h>
#include <map>
#include <vector>
#include <memory>

struct UFHandle_
{
  int fd;
};

struct UFEvent_
{
  UFEvent_() {ref_count = 1;}
  UFEventType type;
  std::shared_ptr<struct UFDevice_> device_ptr;
  std::unique_ptr<struct UFFrame_> frame_ptr;
  uint64_t time;
  int ref_count;
};

struct UFFrame_
{
  std::shared_ptr<struct UFDevice_> device_ptr;
  UFWindowId window_id;
  std::vector<struct UFTouch_> touches;
};

struct UFTouch_
{
  UFTouchId id;
  UFTouchState state;
  float window_x;
  float window_y;
  float device_x;
  float device_y;
  uint64_t time;
  uint64_t start_time;
  int owned;
  int pending_end;
};

struct UFDevice_
{
  int direct;
  std::vector<struct UFAxis_> axes;
  float window_resolution_x;
  float window_resolution_y;
  std::map<UFWindowId, std::map<UFTouchId, bool> > x11_touch_acceptance;
};

struct UFAxis_
{
  UFAxisType type;
  float resolution;
};

#endif
