/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#include <config.h>
#include <glib.h>
#include <libgnomevfs/gnome-vfs.h>

#include "ovu-cap-parser.h"

int
main (int argc, char **argv)
{
	gchar *buf;
	gsize len;
	GError *error = NULL;
	OvuCaps *caps;
	GList *entries, *tmp;

	if (argc != 2) {
		g_printerr ("usage: parse-obex-caps filename.xml\n");
		return 1;
	}

	if (!g_file_get_contents (argv[1], &buf, &len, &error)) {
		g_printerr ("Could not read %s: %s\n",
			    argv[1], error->message);
		g_error_free (error);
		return 1;
	}

	caps = ovu_caps_parser_parse (buf, len, &error);
	g_free (buf);
	if (error) {
		g_print ("Parse error: %s\n", error->message);
		g_error_free (error);
		if (caps != NULL) {
			g_print ("Capabilities returned even though "
				 "error set.\n");
			ovu_caps_free (caps);
		}
		return 0;
	}

	/* Print information from the capabilities file.  Currently
	 * this is just the memory information. */
	entries = ovu_caps_get_memory_entries (caps);
	for (tmp = entries; tmp != NULL; tmp = tmp->next) {
		OvuCapsMemory *memory = tmp->data;

		g_print ("MemType: %s\n", ovu_caps_memory_get_type (memory));
		if (ovu_caps_memory_has_used (memory)) {
			g_print ("Used: %" GNOME_VFS_SIZE_FORMAT_STR "\n",
				 ovu_caps_memory_get_used (memory));
		} else {
			g_print ("Used: unknown\n");
		}
		if (ovu_caps_memory_has_free (memory)) {
			g_print ("Free: %" GNOME_VFS_SIZE_FORMAT_STR "\n",
				 ovu_caps_memory_get_free (memory));
		} else {
			g_print ("Free: unknown\n");
		}
		g_print ("Case sensitive: %s\n\n",
			 ovu_caps_memory_get_case_sensitive (memory) ?
			 "True" : "False");
	}
	ovu_caps_free (caps);

	return 0;
}

