/* cc-credentials-providers-model.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-providers-model.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libaccounts-glib/accounts-glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define CC_CREDENTIALS_TYPE_PROVIDERS_MODEL (cc_credentials_providers_model_get_type ())
#define CC_CREDENTIALS_PROVIDERS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL, CcCredentialsProvidersModel))
#define CC_CREDENTIALS_PROVIDERS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL, CcCredentialsProvidersModelClass))
#define CC_CREDENTIALS_IS_PROVIDERS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL))
#define CC_CREDENTIALS_IS_PROVIDERS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL))
#define CC_CREDENTIALS_PROVIDERS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL, CcCredentialsProvidersModelClass))

typedef struct _CcCredentialsProvidersModel CcCredentialsProvidersModel;
typedef struct _CcCredentialsProvidersModelClass CcCredentialsProvidersModelClass;
typedef struct _CcCredentialsProvidersModelPrivate CcCredentialsProvidersModelPrivate;

#define CC_CREDENTIALS_PROVIDERS_MODEL_TYPE_MODEL_COLUMNS (cc_credentials_providers_model_model_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_AgApplication_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgApplication_free (var), NULL)))
#define __vala_AgProvider_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgProvider_free (var), NULL)))
#define __g_list_free___vala_AgApplication_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_AgApplication_free0_ (var), NULL)))
#define __vala_AgService_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgService_free (var), NULL)))
#define __g_list_free___vala_AgProvider_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_AgProvider_free0_ (var), NULL)))
#define __g_list_free___vala_AgService_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_AgService_free0_ (var), NULL)))

struct _CcCredentialsProvidersModel {
	GtkListStore parent_instance;
	CcCredentialsProvidersModelPrivate * priv;
};

struct _CcCredentialsProvidersModelClass {
	GtkListStoreClass parent_class;
};

struct _CcCredentialsProvidersModelPrivate {
	AgManager* manager;
};

typedef enum  {
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_NAME = 0,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_ICON = 1,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_DESCRIPTION = 2,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_NAME = 3,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_ICON = 4,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_DESCRIPTION = 5,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_TOOLTIP = 6,
	CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_ROW_SORT = 7
} CcCredentialsProvidersModelModelColumns;


static gpointer cc_credentials_providers_model_parent_class = NULL;

GType cc_credentials_providers_model_get_type (void) G_GNUC_CONST;
#define CC_CREDENTIALS_PROVIDERS_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_PROVIDERS_MODEL, CcCredentialsProvidersModelPrivate))
enum  {
	CC_CREDENTIALS_PROVIDERS_MODEL_DUMMY_PROPERTY
};
GType cc_credentials_providers_model_model_columns_get_type (void) G_GNUC_CONST;
CcCredentialsProvidersModel* cc_credentials_providers_model_new (void);
CcCredentialsProvidersModel* cc_credentials_providers_model_construct (GType object_type);
static void cc_credentials_providers_model_populate_model (CcCredentialsProvidersModel* self);
static void cc_credentials_providers_model_add_provider (CcCredentialsProvidersModel* self, AgProvider* provider);
static void _cc_credentials_providers_model_add_provider_gfunc (gconstpointer data, gpointer self);
static AgService* _vala_AgService_copy (AgService* self);
static AgApplication* _vala_AgApplication_copy (AgApplication* self);
static void _vala_AgApplication_free (AgApplication* self);
static void _vala_AgProvider_free (AgProvider* self);
static void __vala_AgApplication_free0_ (gpointer var);
static void _g_list_free___vala_AgApplication_free0_ (GList* self);
static void _vala_AgService_free (AgService* self);
static void __vala_AgProvider_free0_ (gpointer var);
static void _g_list_free___vala_AgProvider_free0_ (GList* self);
static void __vala_AgService_free0_ (gpointer var);
static void _g_list_free___vala_AgService_free0_ (GList* self);
static gint cc_credentials_providers_model_determine_sort_order_gwibber (CcCredentialsProvidersModel* self, const gchar* provider_name);
static gint cc_credentials_providers_model_determine_sort_order_empathy (CcCredentialsProvidersModel* self, const gchar* provider_name);
static gint cc_credentials_providers_model_determine_sort_order_shotwell (CcCredentialsProvidersModel* self, const gchar* provider_name);
static gint cc_credentials_providers_model_determine_sort_order_thunderbird (CcCredentialsProvidersModel* self, const gchar* provider_name);
static gint cc_credentials_providers_model_determine_sort_order_dash (CcCredentialsProvidersModel* self, const gchar* provider_name);
static gchar* cc_credentials_providers_model_format_provider_description (CcCredentialsProvidersModel* self, AgProvider* provider);
static gchar* cc_credentials_providers_model_format_provider_tooltip (CcCredentialsProvidersModel* self, AgProvider* provider);
static GObject * cc_credentials_providers_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void cc_credentials_providers_model_finalize (GObject* obj);


/**
     * Identifiers for columns in the providers model.
     *
     * @param APPLICATION_NAME the name of the application, for passing to
     * Ag.Manager.get_application ()
     * @param APPLICATION_ICON the icon of the application
     * @param APPLICATION_DESCRIPTION the description of the application
     * @param PROVIDER_NAME the name of the provider, for passing to
     * Ag.Manager.get_provider ()
     * @param PROVIDER_ICON the icon of the account provider
     * @param PROVIDER_DESCRIPTION the description of the provider
     * @param TOOLTIP the tooltip to show for the row
     * @param ROW_SORT the sort priority of the row, with more negative numbers
     * being sorted first
     */
GType cc_credentials_providers_model_model_columns_get_type (void) {
	static volatile gsize cc_credentials_providers_model_model_columns_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_providers_model_model_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_NAME, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_NAME", "application-name"}, {CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_ICON, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_ICON", "application-icon"}, {CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_DESCRIPTION, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_DESCRIPTION", "application-description"}, {CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_NAME, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_NAME", "provider-name"}, {CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_ICON", "provider-icon"}, {CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_DESCRIPTION, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_DESCRIPTION", "provider-description"}, {CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_TOOLTIP, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_TOOLTIP", "tooltip"}, {CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_ROW_SORT, "CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_ROW_SORT", "row-sort"}, {0, NULL, NULL}};
		GType cc_credentials_providers_model_model_columns_type_id;
		cc_credentials_providers_model_model_columns_type_id = g_enum_register_static ("CcCredentialsProvidersModelModelColumns", values);
		g_once_init_leave (&cc_credentials_providers_model_model_columns_type_id__volatile, cc_credentials_providers_model_model_columns_type_id);
	}
	return cc_credentials_providers_model_model_columns_type_id__volatile;
}


/**
     * Create a new data model for the list of providers.
     */
CcCredentialsProvidersModel* cc_credentials_providers_model_construct (GType object_type) {
	CcCredentialsProvidersModel * self = NULL;
	self = (CcCredentialsProvidersModel*) g_object_new (object_type, NULL);
	return self;
}


CcCredentialsProvidersModel* cc_credentials_providers_model_new (void) {
	return cc_credentials_providers_model_construct (CC_CREDENTIALS_TYPE_PROVIDERS_MODEL);
}


/**
     * Populate the model with the current list of providers and associated
     * application, by querying for available services and then listing the
     * applications available for each service.
     */
static void _cc_credentials_providers_model_add_provider_gfunc (gconstpointer data, gpointer self) {
	cc_credentials_providers_model_add_provider (self, data);
}


static AgService* _vala_AgService_copy (AgService* self) {
	return g_boxed_copy (ag_service_get_type (), self);
}


static gpointer __vala_AgService_copy0 (gpointer self) {
	return self ? _vala_AgService_copy (self) : NULL;
}


static AgApplication* _vala_AgApplication_copy (AgApplication* self) {
	return g_boxed_copy (ag_application_get_type (), self);
}


static gpointer __vala_AgApplication_copy0 (gpointer self) {
	return self ? _vala_AgApplication_copy (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_AgApplication_free (AgApplication* self) {
	g_boxed_free (ag_application_get_type (), self);
}


static void _vala_AgProvider_free (AgProvider* self) {
	g_boxed_free (ag_provider_get_type (), self);
}


static void __vala_AgApplication_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_AgApplication_free (var), NULL));
}


static void _g_list_free___vala_AgApplication_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_AgApplication_free0_, NULL);
	g_list_free (self);
}


static void _vala_AgService_free (AgService* self) {
	g_boxed_free (ag_service_get_type (), self);
}


static void __vala_AgProvider_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_AgProvider_free (var), NULL));
}


static void _g_list_free___vala_AgProvider_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_AgProvider_free0_, NULL);
	g_list_free (self);
}


static void __vala_AgService_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_AgService_free (var), NULL));
}


static void _g_list_free___vala_AgService_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_AgService_free0_, NULL);
	g_list_free (self);
}


static void cc_credentials_providers_model_populate_model (CcCredentialsProvidersModel* self) {
	AgManager* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* services;
	AgManager* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* providers;
	GList* _tmp4_;
	GList* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = ag_manager_list_services (_tmp0_);
	services = _tmp1_;
	_tmp2_ = self->priv->manager;
	_tmp3_ = ag_manager_list_providers (_tmp2_);
	providers = _tmp3_;
	_tmp4_ = providers;
	g_list_foreach (_tmp4_, _cc_credentials_providers_model_add_provider_gfunc, self);
	_tmp5_ = services;
	{
		GList* service_collection = NULL;
		GList* service_it = NULL;
		service_collection = _tmp5_;
		for (service_it = service_collection; service_it != NULL; service_it = service_it->next) {
			AgService* _tmp6_;
			AgService* service = NULL;
			_tmp6_ = __vala_AgService_copy0 ((AgService*) service_it->data);
			service = _tmp6_;
			{
				AgManager* _tmp7_;
				AgService* _tmp8_;
				GList* _tmp9_ = NULL;
				GList* applications;
				AgService* _tmp10_;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* provider_name;
				AgManager* _tmp13_;
				const gchar* _tmp14_;
				AgProvider* _tmp15_ = NULL;
				AgProvider* provider;
				GList* _tmp16_;
				_tmp7_ = self->priv->manager;
				_tmp8_ = service;
				_tmp9_ = ag_manager_list_applications_by_service (_tmp7_, _tmp8_);
				applications = _tmp9_;
				_tmp10_ = service;
				_tmp11_ = ag_service_get_provider (_tmp10_);
				_tmp12_ = g_strdup (_tmp11_);
				provider_name = _tmp12_;
				_tmp13_ = self->priv->manager;
				_tmp14_ = provider_name;
				_tmp15_ = ag_manager_get_provider (_tmp13_, _tmp14_);
				provider = _tmp15_;
				_tmp16_ = applications;
				{
					GList* application_collection = NULL;
					GList* application_it = NULL;
					application_collection = _tmp16_;
					for (application_it = application_collection; application_it != NULL; application_it = application_it->next) {
						AgApplication* _tmp17_;
						AgApplication* application = NULL;
						_tmp17_ = __vala_AgApplication_copy0 ((AgApplication*) application_it->data);
						application = _tmp17_;
						{
							AgApplication* _tmp18_;
							GDesktopAppInfo* _tmp19_ = NULL;
							GDesktopAppInfo* desktop_info;
							AgApplication* _tmp20_;
							const gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							gchar* application_name;
							GIcon* app_icon;
							gchar* _tmp23_;
							gchar* application_description;
							GDesktopAppInfo* _tmp24_;
							GIcon* provider_icon;
							gint sort_order = 0;
							const gchar* _tmp44_;
							AgApplication* _tmp58_;
							const gchar* _tmp59_ = NULL;
							GIcon* _tmp60_;
							const gchar* _tmp61_;
							AgProvider* _tmp62_;
							const gchar* _tmp63_ = NULL;
							GIcon* _tmp64_;
							AgProvider* _tmp65_;
							gchar* _tmp66_ = NULL;
							gchar* _tmp67_;
							AgProvider* _tmp68_;
							gchar* _tmp69_ = NULL;
							gchar* _tmp70_;
							gint _tmp71_;
							_tmp18_ = application;
							_tmp19_ = ag_application_get_desktop_app_info (_tmp18_);
							desktop_info = _tmp19_;
							_tmp20_ = application;
							_tmp21_ = ag_application_get_name (_tmp20_);
							_tmp22_ = g_strdup (_tmp21_);
							application_name = _tmp22_;
							app_icon = NULL;
							_tmp23_ = g_strdup ("");
							application_description = _tmp23_;
							_tmp24_ = desktop_info;
							if (_tmp24_ == NULL) {
								const gchar* _tmp25_;
								_tmp25_ = application_name;
								g_message ("cc-credentials-providers-model.vala:108: No desktop app info found for" \
" application name: %s", _tmp25_);
							} else {
								GDesktopAppInfo* _tmp26_;
								GIcon* _tmp27_ = NULL;
								GIcon* _tmp28_;
								GDesktopAppInfo* _tmp29_;
								const gchar* _tmp30_ = NULL;
								gchar* _tmp31_;
								gchar* _tmp32_;
								GDesktopAppInfo* _tmp33_;
								const gchar* _tmp34_ = NULL;
								gchar* _tmp35_;
								gchar* _tmp36_;
								gchar* _tmp37_;
								_tmp26_ = desktop_info;
								_tmp27_ = g_app_info_get_icon ((GAppInfo*) _tmp26_);
								_tmp28_ = _g_object_ref0 (_tmp27_);
								_g_object_unref0 (app_icon);
								app_icon = _tmp28_;
								_tmp29_ = desktop_info;
								_tmp30_ = g_app_info_get_display_name ((GAppInfo*) _tmp29_);
								_tmp31_ = g_strconcat (_tmp30_, "\n<small>", NULL);
								_tmp32_ = _tmp31_;
								_tmp33_ = desktop_info;
								_tmp34_ = g_app_info_get_description ((GAppInfo*) _tmp33_);
								_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
								_tmp36_ = _tmp35_;
								_tmp37_ = g_strconcat (_tmp36_, "</small>", NULL);
								_g_free0 (application_description);
								application_description = _tmp37_;
								_g_free0 (_tmp36_);
								_g_free0 (_tmp32_);
							}
							provider_icon = NULL;
							{
								AgProvider* _tmp38_;
								const gchar* _tmp39_ = NULL;
								GIcon* _tmp40_ = NULL;
								GIcon* _tmp41_;
								_tmp38_ = provider;
								_tmp39_ = ag_provider_get_icon_name (_tmp38_);
								_tmp40_ = g_icon_new_for_string (_tmp39_, &_inner_error_);
								_tmp41_ = _tmp40_;
								if (_inner_error_ != NULL) {
									goto __catch12_g_error;
								}
								_g_object_unref0 (provider_icon);
								provider_icon = _tmp41_;
							}
							goto __finally12;
							__catch12_g_error:
							{
								GError* _error_ = NULL;
								GError* _tmp42_;
								const gchar* _tmp43_;
								_error_ = _inner_error_;
								_inner_error_ = NULL;
								_tmp42_ = _error_;
								_tmp43_ = _tmp42_->message;
								g_message ("cc-credentials-providers-model.vala:132: Failed to load provider icon:" \
" %s", _tmp43_);
								_g_error_free0 (_error_);
							}
							__finally12:
							if (_inner_error_ != NULL) {
								_g_object_unref0 (provider_icon);
								_g_free0 (application_description);
								_g_object_unref0 (app_icon);
								_g_free0 (application_name);
								_g_object_unref0 (desktop_info);
								__vala_AgApplication_free0 (application);
								__vala_AgProvider_free0 (provider);
								_g_free0 (provider_name);
								__g_list_free___vala_AgApplication_free0_0 (applications);
								__vala_AgService_free0 (service);
								__g_list_free___vala_AgProvider_free0_0 (providers);
								__g_list_free___vala_AgService_free0_0 (services);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
							_tmp44_ = application_name;
							if (g_strcmp0 (_tmp44_, "gwibber") == 0) {
								const gchar* _tmp45_;
								gint _tmp46_ = 0;
								_tmp45_ = provider_name;
								_tmp46_ = cc_credentials_providers_model_determine_sort_order_gwibber (self, _tmp45_);
								sort_order = _tmp46_;
							} else {
								const gchar* _tmp47_;
								_tmp47_ = application_name;
								if (g_strcmp0 (_tmp47_, "empathy") == 0) {
									const gchar* _tmp48_;
									gint _tmp49_ = 0;
									_tmp48_ = provider_name;
									_tmp49_ = cc_credentials_providers_model_determine_sort_order_empathy (self, _tmp48_);
									sort_order = _tmp49_;
								} else {
									const gchar* _tmp50_;
									_tmp50_ = application_name;
									if (g_strcmp0 (_tmp50_, "shotwell") == 0) {
										const gchar* _tmp51_;
										gint _tmp52_ = 0;
										_tmp51_ = provider_name;
										_tmp52_ = cc_credentials_providers_model_determine_sort_order_shotwell (self, _tmp51_);
										sort_order = _tmp52_;
									} else {
										const gchar* _tmp53_;
										_tmp53_ = application_name;
										if (g_strcmp0 (_tmp53_, "thunderbird") == 0) {
											const gchar* _tmp54_;
											gint _tmp55_ = 0;
											_tmp54_ = provider_name;
											_tmp55_ = cc_credentials_providers_model_determine_sort_order_thunderbird (self, _tmp54_);
											sort_order = _tmp55_;
										} else {
											const gchar* _tmp56_;
											gint _tmp57_ = 0;
											_tmp56_ = provider_name;
											_tmp57_ = cc_credentials_providers_model_determine_sort_order_dash (self, _tmp56_);
											sort_order = _tmp57_;
										}
									}
								}
							}
							_tmp58_ = application;
							_tmp59_ = ag_application_get_name (_tmp58_);
							_tmp60_ = app_icon;
							_tmp61_ = application_description;
							_tmp62_ = provider;
							_tmp63_ = ag_provider_get_name (_tmp62_);
							_tmp64_ = provider_icon;
							_tmp65_ = provider;
							_tmp66_ = cc_credentials_providers_model_format_provider_description (self, _tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = provider;
							_tmp69_ = cc_credentials_providers_model_format_provider_tooltip (self, _tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = sort_order;
							gtk_list_store_insert_with_values ((GtkListStore*) self, NULL, 0, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_NAME, _tmp59_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_ICON, _tmp60_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_DESCRIPTION, _tmp61_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_NAME, _tmp63_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, _tmp64_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_DESCRIPTION, _tmp67_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_TOOLTIP, _tmp70_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_ROW_SORT, _tmp71_, -1, -1);
							_g_free0 (_tmp70_);
							_g_free0 (_tmp67_);
							_g_object_unref0 (provider_icon);
							_g_free0 (application_description);
							_g_object_unref0 (app_icon);
							_g_free0 (application_name);
							_g_object_unref0 (desktop_info);
							__vala_AgApplication_free0 (application);
						}
					}
				}
				__vala_AgProvider_free0 (provider);
				_g_free0 (provider_name);
				__g_list_free___vala_AgApplication_free0_0 (applications);
				__vala_AgService_free0 (service);
			}
		}
	}
	__g_list_free___vala_AgProvider_free0_0 (providers);
	__g_list_free___vala_AgService_free0_0 (services);
}


/**
     * Add the supplied provider to the store of providers.
     *
     * This method is intended to be used with the foreach method of GLib
     * containers.
     *
     * @param provider an Ag.Provider to add to the list of providers
     */
static void cc_credentials_providers_model_add_provider (CcCredentialsProvidersModel* self, AgProvider* provider) {
	GIcon* provider_icon;
	AgProvider* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* provider_name;
	gint _tmp9_ = 0;
	gint sort_order;
	GIcon* _tmp10_;
	AgProvider* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	AgProvider* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (provider != NULL);
	provider_icon = NULL;
	{
		AgProvider* _tmp0_;
		const gchar* _tmp1_ = NULL;
		GIcon* _tmp2_ = NULL;
		GIcon* _tmp3_;
		_tmp0_ = provider;
		_tmp1_ = ag_provider_get_icon_name (_tmp0_);
		_tmp2_ = g_icon_new_for_string (_tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		_g_object_unref0 (provider_icon);
		provider_icon = _tmp3_;
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_message ("cc-credentials-providers-model.vala:182: Failed to load provider icon:" \
" %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (provider_icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = provider;
	_tmp7_ = ag_provider_get_name (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	provider_name = _tmp8_;
	_tmp9_ = cc_credentials_providers_model_determine_sort_order_dash (self, provider_name);
	sort_order = _tmp9_;
	_tmp10_ = provider_icon;
	_tmp11_ = provider;
	_tmp12_ = cc_credentials_providers_model_format_provider_description (self, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = provider;
	_tmp15_ = cc_credentials_providers_model_format_provider_tooltip (self, _tmp14_);
	_tmp16_ = _tmp15_;
	gtk_list_store_insert_with_values ((GtkListStore*) self, NULL, 0, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_APPLICATION_NAME, "all", CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_NAME, provider_name, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, _tmp10_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_PROVIDER_DESCRIPTION, _tmp13_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_TOOLTIP, _tmp16_, CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_ROW_SORT, sort_order, -1, -1);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (provider_name);
	_g_object_unref0 (provider_icon);
}


/**
     * Determine the sort order for service providers for an unspecified
     * application, or the dash, given a provider name.
     *
     * @param provider_name the provider name
     * @return the sort order, with a more negative number coming before others
     */
static gint cc_credentials_providers_model_determine_sort_order_dash (CcCredentialsProvidersModel* self, const gchar* provider_name) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (provider_name != NULL, 0);
	_tmp0_ = provider_name;
	if (g_strcmp0 (_tmp0_, "facebook") == 0) {
		result = -5;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = provider_name;
		if (g_strcmp0 (_tmp1_, "flickr") == 0) {
			result = -4;
			return result;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = provider_name;
			if (g_strcmp0 (_tmp2_, "google") == 0) {
				result = -3;
				return result;
			} else {
				const gchar* _tmp3_;
				_tmp3_ = provider_name;
				if (g_strcmp0 (_tmp3_, "twitter") == 0) {
					result = -2;
					return result;
				} else {
					result = 0;
					return result;
				}
			}
		}
	}
}


/**
     * Determine the sort order for service providers for Gwibber, given a
     * provider name.
     *
     * @param provider_name the provider name
     * @return the sort order, with a more negative number coming before others
     */
static gint cc_credentials_providers_model_determine_sort_order_gwibber (CcCredentialsProvidersModel* self, const gchar* provider_name) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (provider_name != NULL, 0);
	_tmp0_ = provider_name;
	if (g_strcmp0 (_tmp0_, "facebook") == 0) {
		result = -5;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = provider_name;
		if (g_strcmp0 (_tmp1_, "google") == 0) {
			result = -4;
			return result;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = provider_name;
			if (g_strcmp0 (_tmp2_, "identica") == 0) {
				result = -3;
				return result;
			} else {
				const gchar* _tmp3_;
				_tmp3_ = provider_name;
				if (g_strcmp0 (_tmp3_, "twitter") == 0) {
					result = -2;
					return result;
				} else {
					result = 0;
					return result;
				}
			}
		}
	}
}


/**
     * Determine the sort order for service providers for Empathy, given a
     * provider name.
     *
     * @param provider_name the provider name
     * @return the sort order, with a more negative number coming before others
     */
static gint cc_credentials_providers_model_determine_sort_order_empathy (CcCredentialsProvidersModel* self, const gchar* provider_name) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (provider_name != NULL, 0);
	_tmp0_ = provider_name;
	if (g_strcmp0 (_tmp0_, "salut") == 0) {
		result = -5;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = provider_name;
		if (g_strcmp0 (_tmp1_, "facebook") == 0) {
			result = -4;
			return result;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = provider_name;
			if (g_strcmp0 (_tmp2_, "google") == 0) {
				result = -3;
				return result;
			} else {
				result = 0;
				return result;
			}
		}
	}
}


/**
     * Determine the sort order for service providers for Shotwell, given a
     * provider name.
     *
     * @param provider_name the provider name
     * @return the sort order, with a more negative number coming before others
     */
static gint cc_credentials_providers_model_determine_sort_order_shotwell (CcCredentialsProvidersModel* self, const gchar* provider_name) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (provider_name != NULL, 0);
	_tmp0_ = provider_name;
	if (g_strcmp0 (_tmp0_, "facebook") == 0) {
		result = -5;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = provider_name;
		if (g_strcmp0 (_tmp1_, "flickr") == 0) {
			result = -4;
			return result;
		} else {
			const gchar* _tmp2_;
			_tmp2_ = provider_name;
			if (g_strcmp0 (_tmp2_, "google") == 0) {
				result = -3;
				return result;
			} else {
				result = 0;
				return result;
			}
		}
	}
}


/**
     * Determine the sort order for service providers for Thunderbird, given a
     * provider name.
     *
     * @param provider_name the provider name
     * @return the sort order, with a more negative number coming before others
     */
static gint cc_credentials_providers_model_determine_sort_order_thunderbird (CcCredentialsProvidersModel* self, const gchar* provider_name) {
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (provider_name != NULL, 0);
	_tmp0_ = provider_name;
	if (g_strcmp0 (_tmp0_, "google") == 0) {
		result = -5;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = provider_name;
		if (g_strcmp0 (_tmp1_, "yahoo") == 0) {
			result = -4;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


/**
     * Provide a Pango-markup description of the provider for adding to the
     * model.
     *
     * Add a second line of descriptive text if the provider supplies a
     * description.
     *
     * @param provider the provider to add
     * @return the description, with Pango markup
     */
static gchar* cc_credentials_providers_model_format_provider_description (CcCredentialsProvidersModel* self, AgProvider* provider) {
	gchar* result = NULL;
	AgProvider* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* description;
	gchar* provider_description = NULL;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (provider != NULL, NULL);
	_tmp0_ = provider;
	_tmp1_ = ag_provider_get_description (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	description = _tmp2_;
	_tmp3_ = description;
	if (_tmp3_ == NULL) {
		AgProvider* _tmp4_;
		const gchar* _tmp5_ = NULL;
		AgProvider* _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp4_ = provider;
		_tmp5_ = ag_provider_get_i18n_domain (_tmp4_);
		_tmp6_ = provider;
		_tmp7_ = ag_provider_get_display_name (_tmp6_);
		_tmp8_ = g_dgettext (_tmp5_, _tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (provider_description);
		provider_description = _tmp9_;
	} else {
		AgProvider* _tmp10_;
		const gchar* _tmp11_ = NULL;
		AgProvider* _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		AgProvider* _tmp19_;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp10_ = provider;
		_tmp11_ = ag_provider_get_i18n_domain (_tmp10_);
		_tmp12_ = provider;
		_tmp13_ = ag_provider_get_display_name (_tmp12_);
		_tmp14_ = g_dgettext (_tmp11_, _tmp13_);
		_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "<small>", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = provider;
		_tmp20_ = ag_provider_get_i18n_domain (_tmp19_);
		_tmp21_ = description;
		_tmp22_ = g_dgettext (_tmp20_, _tmp21_);
		_tmp23_ = g_strconcat (_tmp18_, _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "</small>", NULL);
		_g_free0 (provider_description);
		provider_description = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
	}
	result = provider_description;
	_g_free0 (description);
	return result;
}


/**
     * Provider a description for the tooltip for each provider, for display
     * when hovering over a row in the tree view.
     *
     * @param provider the provider for which to create tooltip text
     * @return the tooltip text
     */
static gchar* cc_credentials_providers_model_format_provider_tooltip (CcCredentialsProvidersModel* self, AgProvider* provider) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	AgProvider* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (provider != NULL, NULL);
	_tmp0_ = _ ("Select to configure a new %s account");
	_tmp1_ = provider;
	_tmp2_ = ag_provider_get_display_name (_tmp1_);
	_tmp3_ = g_strdup_printf (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}


static GObject * cc_credentials_providers_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CcCredentialsProvidersModel * self;
	GType* _tmp0_ = NULL;
	GType* types;
	gint types_length1;
	gint _types_size_;
	GType* _tmp1_;
	gint _tmp1__length1;
	AgManager* _tmp2_;
	parent_class = G_OBJECT_CLASS (cc_credentials_providers_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CC_CREDENTIALS_PROVIDERS_MODEL (obj);
	_tmp0_ = g_new0 (GType, 8);
	_tmp0_[0] = G_TYPE_STRING;
	_tmp0_[1] = G_TYPE_ICON;
	_tmp0_[2] = G_TYPE_STRING;
	_tmp0_[3] = G_TYPE_STRING;
	_tmp0_[4] = G_TYPE_ICON;
	_tmp0_[5] = G_TYPE_STRING;
	_tmp0_[6] = G_TYPE_STRING;
	_tmp0_[7] = G_TYPE_INT;
	types = _tmp0_;
	types_length1 = 8;
	_types_size_ = types_length1;
	_tmp1_ = types;
	_tmp1__length1 = types_length1;
	gtk_list_store_set_column_types ((GtkListStore*) self, _tmp1__length1, _tmp1_);
	_tmp2_ = ag_manager_new ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp2_;
	cc_credentials_providers_model_populate_model (self);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, (gint) CC_CREDENTIALS_PROVIDERS_MODEL_MODEL_COLUMNS_ROW_SORT, GTK_SORT_ASCENDING);
	types = (g_free (types), NULL);
	return obj;
}


static void cc_credentials_providers_model_class_init (CcCredentialsProvidersModelClass * klass) {
	cc_credentials_providers_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsProvidersModelPrivate));
	G_OBJECT_CLASS (klass)->constructor = cc_credentials_providers_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_providers_model_finalize;
}


static void cc_credentials_providers_model_instance_init (CcCredentialsProvidersModel * self) {
	self->priv = CC_CREDENTIALS_PROVIDERS_MODEL_GET_PRIVATE (self);
}


static void cc_credentials_providers_model_finalize (GObject* obj) {
	CcCredentialsProvidersModel * self;
	self = CC_CREDENTIALS_PROVIDERS_MODEL (obj);
	_g_object_unref0 (self->priv->manager);
	G_OBJECT_CLASS (cc_credentials_providers_model_parent_class)->finalize (obj);
}


/**
 * Web credentials providers Gtk.ListStore. Used as a model for the providers
 * managed by libaccounts-glib.
 */
GType cc_credentials_providers_model_get_type (void) {
	static volatile gsize cc_credentials_providers_model_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_providers_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsProvidersModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_providers_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsProvidersModel), 0, (GInstanceInitFunc) cc_credentials_providers_model_instance_init, NULL };
		GType cc_credentials_providers_model_type_id;
		cc_credentials_providers_model_type_id = g_type_register_static (GTK_TYPE_LIST_STORE, "CcCredentialsProvidersModel", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_providers_model_type_id__volatile, cc_credentials_providers_model_type_id);
	}
	return cc_credentials_providers_model_type_id__volatile;
}



