/* cc-credentials-preferences.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-preferences.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libaccounts-glib/accounts-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libaccount-plugin/account-plugin.h>
#include <gio/gdesktopappinfo.h>


#define CC_CREDENTIALS_TYPE_PREFERENCES (cc_credentials_preferences_get_type ())
#define CC_CREDENTIALS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_PREFERENCES, CcCredentialsPreferences))
#define CC_CREDENTIALS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_PREFERENCES, CcCredentialsPreferencesClass))
#define CC_CREDENTIALS_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_PREFERENCES))
#define CC_CREDENTIALS_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_PREFERENCES))
#define CC_CREDENTIALS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_PREFERENCES, CcCredentialsPreferencesClass))

typedef struct _CcCredentialsPreferences CcCredentialsPreferences;
typedef struct _CcCredentialsPreferencesClass CcCredentialsPreferencesClass;
typedef struct _CcCredentialsPreferencesPrivate CcCredentialsPreferencesPrivate;

#define CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE (cc_credentials_authorization_page_get_type ())
#define CC_CREDENTIALS_AUTHORIZATION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, CcCredentialsAuthorizationPage))
#define CC_CREDENTIALS_AUTHORIZATION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, CcCredentialsAuthorizationPageClass))
#define CC_CREDENTIALS_IS_AUTHORIZATION_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE))
#define CC_CREDENTIALS_IS_AUTHORIZATION_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE))
#define CC_CREDENTIALS_AUTHORIZATION_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_AUTHORIZATION_PAGE, CcCredentialsAuthorizationPageClass))

typedef struct _CcCredentialsAuthorizationPage CcCredentialsAuthorizationPage;
typedef struct _CcCredentialsAuthorizationPageClass CcCredentialsAuthorizationPageClass;

#define CC_CREDENTIALS_TYPE_LOGIN_CAPTURE (cc_credentials_login_capture_get_type ())
#define CC_CREDENTIALS_LOGIN_CAPTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_LOGIN_CAPTURE, CcCredentialsLoginCapture))
#define CC_CREDENTIALS_LOGIN_CAPTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_LOGIN_CAPTURE, CcCredentialsLoginCaptureClass))
#define CC_CREDENTIALS_IS_LOGIN_CAPTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_LOGIN_CAPTURE))
#define CC_CREDENTIALS_IS_LOGIN_CAPTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_LOGIN_CAPTURE))
#define CC_CREDENTIALS_LOGIN_CAPTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_LOGIN_CAPTURE, CcCredentialsLoginCaptureClass))

typedef struct _CcCredentialsLoginCapture CcCredentialsLoginCapture;
typedef struct _CcCredentialsLoginCaptureClass CcCredentialsLoginCaptureClass;

#define CC_CREDENTIALS_PREFERENCES_TYPE_PREFERENCES_PAGE (cc_credentials_preferences_preferences_page_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_ROW (cc_credentials_account_application_row_get_type ())
typedef struct _CcCredentialsAccountApplicationRow CcCredentialsAccountApplicationRow;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE (cc_credentials_accounts_page_get_type ())
#define CC_CREDENTIALS_ACCOUNTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, CcCredentialsAccountsPage))
#define CC_CREDENTIALS_ACCOUNTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, CcCredentialsAccountsPageClass))
#define CC_CREDENTIALS_IS_ACCOUNTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE))
#define CC_CREDENTIALS_IS_ACCOUNTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE))
#define CC_CREDENTIALS_ACCOUNTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, CcCredentialsAccountsPageClass))

typedef struct _CcCredentialsAccountsPage CcCredentialsAccountsPage;
typedef struct _CcCredentialsAccountsPageClass CcCredentialsAccountsPageClass;

struct _CcCredentialsPreferences {
	GtkNotebook parent_instance;
	CcCredentialsPreferencesPrivate * priv;
};

struct _CcCredentialsPreferencesClass {
	GtkNotebookClass parent_class;
};

struct _CcCredentialsPreferencesPrivate {
	CcCredentialsAuthorizationPage* authorization_page;
	AgManager* accounts_manager;
	CcCredentialsLoginCapture* login_capture;
	guint _account_details_id;
	gchar* _application_id;
};

typedef enum  {
	CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNTS = 0,
	CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_AUTHORIZATION = 1,
	CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNT_OPTIONS = 2
} CcCredentialsPreferencesPreferencesPage;

struct _CcCredentialsAccountApplicationRow {
	gchar* name;
	GIcon* icon;
	gchar* description;
	ApApplicationPlugin* plugin;
	GtkWidget* plugin_widget;
};


static gpointer cc_credentials_preferences_parent_class = NULL;

GType cc_credentials_preferences_get_type (void) G_GNUC_CONST;
GType cc_credentials_authorization_page_get_type (void) G_GNUC_CONST;
GType cc_credentials_login_capture_get_type (void) G_GNUC_CONST;
guint cc_credentials_login_capture_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define CC_CREDENTIALS_PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_PREFERENCES, CcCredentialsPreferencesPrivate))
enum  {
	CC_CREDENTIALS_PREFERENCES_DUMMY_PROPERTY,
	CC_CREDENTIALS_PREFERENCES_ACCOUNT_DETAILS_ID,
	CC_CREDENTIALS_PREFERENCES_APPLICATION_ID
};
static GType cc_credentials_preferences_preferences_page_get_type (void) G_GNUC_UNUSED;
CcCredentialsPreferences* cc_credentials_preferences_new (void);
CcCredentialsPreferences* cc_credentials_preferences_construct (GType object_type);
CcCredentialsPreferences* cc_credentials_preferences_new_with_account_details (AgAccountId account_id);
CcCredentialsPreferences* cc_credentials_preferences_construct_with_account_details (GType object_type, AgAccountId account_id);
CcCredentialsPreferences* cc_credentials_preferences_new_with_application (const gchar* application);
CcCredentialsPreferences* cc_credentials_preferences_construct_with_application (GType object_type, const gchar* application);
static void cc_credentials_preferences_on_login_capture_new_account_request (CcCredentialsPreferences* self, const gchar* provider_name, const gchar* username, const gchar* password, GHashTable* cookies);
void cc_credentials_authorization_page_set_account (CcCredentialsAuthorizationPage* self, AgAccount* value);
void cc_credentials_authorization_page_set_login_data (CcCredentialsAuthorizationPage* self, const gchar* username, const gchar* password, GHashTable* cookies);
static void cc_credentials_preferences_on_accounts_page_new_account_request (CcCredentialsPreferences* self, const gchar* provider_name);
static void cc_credentials_preferences_on_accounts_page_reauthenticate_account_request (CcCredentialsPreferences* self, AgAccount* account);
void cc_credentials_authorization_page_reauthenticate_account (CcCredentialsAuthorizationPage* self, AgAccount* account);
static void cc_credentials_preferences_on_authorization_page_cancelled (CcCredentialsPreferences* self);
GType cc_credentials_account_application_row_get_type (void) G_GNUC_CONST;
CcCredentialsAccountApplicationRow* cc_credentials_account_application_row_dup (const CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_free (CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_copy (const CcCredentialsAccountApplicationRow* self, CcCredentialsAccountApplicationRow* dest);
void cc_credentials_account_application_row_destroy (CcCredentialsAccountApplicationRow* self);
static void cc_credentials_preferences_on_accounts_page_account_options_request (CcCredentialsPreferences* self, CcCredentialsAccountApplicationRow* application_row);
static void cc_credentials_preferences_on_account_application_options_finished (CcCredentialsPreferences* self, ApApplicationPlugin* plugin);
static void _cc_credentials_preferences_on_account_application_options_finished_ap_application_plugin_finished (ApApplicationPlugin* _sender, gpointer self);
static void cc_credentials_preferences_on_accounts_page_account_edit_options_request (CcCredentialsPreferences* self, ApPlugin* plugin);
static void cc_credentials_preferences_on_account_edit_options_finished (CcCredentialsPreferences* self, ApPlugin* plugin);
static void _cc_credentials_preferences_on_account_edit_options_finished_ap_plugin_finished (ApPlugin* _sender, gpointer self);
guint cc_credentials_preferences_get_account_details_id (CcCredentialsPreferences* self);
static void cc_credentials_preferences_set_account_details_id (CcCredentialsPreferences* self, guint value);
const gchar* cc_credentials_preferences_get_application_id (CcCredentialsPreferences* self);
static void cc_credentials_preferences_set_application_id (CcCredentialsPreferences* self, const gchar* value);
static GObject * cc_credentials_preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GType cc_credentials_accounts_page_get_type (void) G_GNUC_CONST;
CcCredentialsAccountsPage* cc_credentials_accounts_page_new_with_account_details (AgAccountId account_id);
CcCredentialsAccountsPage* cc_credentials_accounts_page_construct_with_account_details (GType object_type, AgAccountId account_id);
CcCredentialsAccountsPage* cc_credentials_accounts_page_new_with_application (const gchar* application);
CcCredentialsAccountsPage* cc_credentials_accounts_page_construct_with_application (GType object_type, const gchar* application);
CcCredentialsAccountsPage* cc_credentials_accounts_page_new (void);
CcCredentialsAccountsPage* cc_credentials_accounts_page_construct (GType object_type);
static void _cc_credentials_preferences_on_accounts_page_new_account_request_cc_credentials_accounts_page_new_account_request (CcCredentialsAccountsPage* _sender, const gchar* provider_name, gpointer self);
static void _cc_credentials_preferences_on_accounts_page_reauthenticate_account_request_cc_credentials_accounts_page_reauthenticate_account_request (CcCredentialsAccountsPage* _sender, AgAccount* account, gpointer self);
static void _cc_credentials_preferences_on_accounts_page_account_options_request_cc_credentials_accounts_page_account_options_request (CcCredentialsAccountsPage* _sender, CcCredentialsAccountApplicationRow* application_row, gpointer self);
static void _cc_credentials_preferences_on_accounts_page_account_edit_options_request_cc_credentials_accounts_page_account_edit_options_request (CcCredentialsAccountsPage* _sender, ApPlugin* plugin, gpointer self);
CcCredentialsAuthorizationPage* cc_credentials_authorization_page_new (void);
CcCredentialsAuthorizationPage* cc_credentials_authorization_page_construct (GType object_type);
static void _cc_credentials_preferences_on_authorization_page_cancelled_cc_credentials_authorization_page_cancelled (CcCredentialsAuthorizationPage* _sender, gpointer self);
CcCredentialsLoginCapture* cc_credentials_login_capture_new (void);
CcCredentialsLoginCapture* cc_credentials_login_capture_construct (GType object_type);
static void _cc_credentials_preferences_on_login_capture_new_account_request_cc_credentials_login_capture_new_account_request (CcCredentialsLoginCapture* _sender, const gchar* provider_name, const gchar* username, const gchar* password, GHashTable* cookies, gpointer self);
static void cc_credentials_preferences_finalize (GObject* obj);
static void _vala_cc_credentials_preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_cc_credentials_preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Select the desired page of @link Preferences to query the current
     * accounts and providers, or to authorize an account.
     *
     * @param ACCOUNTS select an account or provider in a two-pane view
     * @param AUTHORIZATION authorize an account in a full-size widget, such as
     * a WebKit view
     * @param ACCOUNT_OPTIONS set options on an account for either a specific
     * application or for the account globally
     */
static GType cc_credentials_preferences_preferences_page_get_type (void) {
	static volatile gsize cc_credentials_preferences_preferences_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_preferences_preferences_page_type_id__volatile)) {
		static const GEnumValue values[] = {{CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNTS, "CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNTS", "accounts"}, {CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_AUTHORIZATION, "CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_AUTHORIZATION", "authorization"}, {CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNT_OPTIONS, "CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNT_OPTIONS", "account-options"}, {0, NULL, NULL}};
		GType cc_credentials_preferences_preferences_page_type_id;
		cc_credentials_preferences_preferences_page_type_id = g_enum_register_static ("CcCredentialsPreferencesPreferencesPage", values);
		g_once_init_leave (&cc_credentials_preferences_preferences_page_type_id__volatile, cc_credentials_preferences_preferences_page_type_id);
	}
	return cc_credentials_preferences_preferences_page_type_id__volatile;
}


CcCredentialsPreferences* cc_credentials_preferences_construct (GType object_type) {
	CcCredentialsPreferences * self = NULL;
	self = (CcCredentialsPreferences*) g_object_new (object_type, NULL);
	return self;
}


CcCredentialsPreferences* cc_credentials_preferences_new (void) {
	return cc_credentials_preferences_construct (CC_CREDENTIALS_TYPE_PREFERENCES);
}


CcCredentialsPreferences* cc_credentials_preferences_construct_with_account_details (GType object_type, AgAccountId account_id) {
	CcCredentialsPreferences * self = NULL;
	AgAccountId _tmp0_;
	_tmp0_ = account_id;
	self = (CcCredentialsPreferences*) g_object_new (object_type, "account-details-id", _tmp0_, NULL);
	return self;
}


CcCredentialsPreferences* cc_credentials_preferences_new_with_account_details (AgAccountId account_id) {
	return cc_credentials_preferences_construct_with_account_details (CC_CREDENTIALS_TYPE_PREFERENCES, account_id);
}


CcCredentialsPreferences* cc_credentials_preferences_construct_with_application (GType object_type, const gchar* application) {
	CcCredentialsPreferences * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = application;
	self = (CcCredentialsPreferences*) g_object_new (object_type, "application-id", _tmp0_, NULL);
	return self;
}


CcCredentialsPreferences* cc_credentials_preferences_new_with_application (const gchar* application) {
	return cc_credentials_preferences_construct_with_application (CC_CREDENTIALS_TYPE_PREFERENCES, application);
}


/**
     * Handle the new-account-request signal from LoginCapture, switching
     * notebook page to the new account view.
     *
     * @param provider_name the name of the provider for which to add an
     * account.
     * @param username the user login name.
     * @param password the user password.
     * @param cookies a dictionary of cookies.
     */
static void cc_credentials_preferences_on_login_capture_new_account_request (CcCredentialsPreferences* self, const gchar* provider_name, const gchar* username, const gchar* password, GHashTable* cookies) {
	AgManager* _tmp0_;
	const gchar* _tmp1_;
	AgAccount* _tmp2_ = NULL;
	AgAccount* account;
	CcCredentialsAuthorizationPage* _tmp3_;
	CcCredentialsAuthorizationPage* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GHashTable* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (provider_name != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (cookies != NULL);
	_tmp0_ = self->priv->accounts_manager;
	_tmp1_ = provider_name;
	_tmp2_ = ag_manager_create_account (_tmp0_, _tmp1_);
	account = _tmp2_;
	_tmp3_ = self->priv->authorization_page;
	cc_credentials_authorization_page_set_account (_tmp3_, account);
	_tmp4_ = self->priv->authorization_page;
	_tmp5_ = username;
	_tmp6_ = password;
	_tmp7_ = cookies;
	cc_credentials_authorization_page_set_login_data (_tmp4_, _tmp5_, _tmp6_, _tmp7_);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_AUTHORIZATION);
	_g_object_unref0 (account);
}


/**
     * Handle the new-account-request signal from AccountsPage (and in turn
     * ProvidersPage), switching notebook page to the new account view.
     *
     * @param provider_name the name of the provider for which to add an
     * account
     */
static void cc_credentials_preferences_on_accounts_page_new_account_request (CcCredentialsPreferences* self, const gchar* provider_name) {
	AgManager* _tmp0_;
	const gchar* _tmp1_;
	AgAccount* _tmp2_ = NULL;
	AgAccount* account;
	CcCredentialsAuthorizationPage* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (provider_name != NULL);
	_tmp0_ = self->priv->accounts_manager;
	_tmp1_ = provider_name;
	_tmp2_ = ag_manager_create_account (_tmp0_, _tmp1_);
	account = _tmp2_;
	_tmp3_ = self->priv->authorization_page;
	cc_credentials_authorization_page_set_account (_tmp3_, account);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_AUTHORIZATION);
	_g_object_unref0 (account);
}


/**
     * Handle the reauthenticate-account-request signal from AccountsPage (and
     * in turn AccountDetailsPage), switching notebook page to the account
     * authentication view.
     *
     * @param account the account to authenticate
     */
static void cc_credentials_preferences_on_accounts_page_reauthenticate_account_request (CcCredentialsPreferences* self, AgAccount* account) {
	CcCredentialsAuthorizationPage* _tmp0_;
	AgAccount* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = self->priv->authorization_page;
	_tmp1_ = account;
	cc_credentials_authorization_page_reauthenticate_account (_tmp0_, _tmp1_);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_AUTHORIZATION);
}


/**
     * Handle the authorization process for a new account being cancelled,
     * switching the current notebook page to the provider selection view.
     */
static void cc_credentials_preferences_on_authorization_page_cancelled (CcCredentialsPreferences* self) {
	g_return_if_fail (self != NULL);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNTS);
}


/**
     * Handle the account-options-request signal from AccountsPage (and in turn
     * AccountDetailsPage), switching notebook page to the application account
     * options view.
     *
     * @param application_row the AccountApplicationRow to show options for
     */
static void _cc_credentials_preferences_on_account_application_options_finished_ap_application_plugin_finished (ApApplicationPlugin* _sender, gpointer self) {
	cc_credentials_preferences_on_account_application_options_finished (self, _sender);
}


static void cc_credentials_preferences_on_accounts_page_account_options_request (CcCredentialsPreferences* self, CcCredentialsAccountApplicationRow* application_row) {
	CcCredentialsAccountApplicationRow _tmp0_;
	GtkWidget* _tmp1_;
	CcCredentialsAccountApplicationRow _tmp2_;
	GtkWidget* _tmp3_;
	CcCredentialsAccountApplicationRow _tmp4_;
	ApApplicationPlugin* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (application_row != NULL);
	_tmp0_ = *application_row;
	_tmp1_ = _tmp0_.plugin_widget;
	g_assert (_tmp1_ != NULL);
	_tmp2_ = *application_row;
	_tmp3_ = _tmp2_.plugin_widget;
	gtk_notebook_append_page ((GtkNotebook*) self, _tmp3_, NULL);
	_tmp4_ = *application_row;
	_tmp5_ = _tmp4_.plugin;
	g_signal_connect_object (_tmp5_, "finished", (GCallback) _cc_credentials_preferences_on_account_application_options_finished_ap_application_plugin_finished, self, 0);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNT_OPTIONS);
}


/**
     * Handle the account options editing process finishing, and switch back to
     * the accounts view.
     *
     * @param plugin the plugin that emitted the finished signal
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void cc_credentials_preferences_on_account_application_options_finished (CcCredentialsPreferences* self, ApApplicationPlugin* plugin) {
	ApApplicationPlugin* _tmp0_;
	GError* _tmp1_ = NULL;
	GError* _tmp2_;
	GError* plugin_err;
	GError* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	_tmp1_ = ap_application_plugin_get_error (_tmp0_);
	_tmp2_ = _g_error_copy0 (_tmp1_);
	plugin_err = _tmp2_;
	_tmp3_ = plugin_err;
	if (_tmp3_ != NULL) {
		GError* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = plugin_err;
		_tmp5_ = _tmp4_->message;
		g_warning ("cc-credentials-preferences.vala:216: Error during account application " \
"options process: %s", _tmp5_);
	}
	gtk_notebook_remove_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNT_OPTIONS);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNTS);
	_g_error_free0 (plugin_err);
}


/**
     * Handle the account-edit-options-request signal from AccountsPage (and ini
     * turn AccountDetailsPage), switching notebook page to the application
     * account options view.
     *
     * @param application_row the AccountApplicationRow to show options for
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cc_credentials_preferences_on_account_edit_options_finished_ap_plugin_finished (ApPlugin* _sender, gpointer self) {
	cc_credentials_preferences_on_account_edit_options_finished (self, _sender);
}


static void cc_credentials_preferences_on_accounts_page_account_edit_options_request (CcCredentialsPreferences* self, ApPlugin* plugin) {
	ApPlugin* _tmp0_;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* widget;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	ApPlugin* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	_tmp1_ = ap_plugin_build_widget (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	widget = _tmp2_;
	_tmp3_ = widget;
	if (_tmp3_ == NULL) {
		g_critical ("cc-credentials-preferences.vala:237: Error building configuration widg" \
"et");
		_g_object_unref0 (widget);
		return;
	}
	_tmp4_ = widget;
	gtk_widget_show (_tmp4_);
	_tmp5_ = widget;
	gtk_notebook_append_page ((GtkNotebook*) self, _tmp5_, NULL);
	_tmp6_ = plugin;
	g_signal_connect_object (_tmp6_, "finished", (GCallback) _cc_credentials_preferences_on_account_edit_options_finished_ap_plugin_finished, self, 0);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNT_OPTIONS);
	_g_object_unref0 (widget);
}


/**
     * Handle the account options editing process finishing, and switch back to
     * the accounts view.
     *
     * @param plugin the plugin that emitted the finished signal
     */
static void cc_credentials_preferences_on_account_edit_options_finished (CcCredentialsPreferences* self, ApPlugin* plugin) {
	ApPlugin* _tmp0_;
	GError* _tmp1_ = NULL;
	GError* _tmp2_;
	GError* plugin_err;
	GError* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	_tmp1_ = ap_plugin_get_error (_tmp0_);
	_tmp2_ = _g_error_copy0 (_tmp1_);
	plugin_err = _tmp2_;
	_tmp3_ = plugin_err;
	if (_tmp3_ != NULL) {
		GError* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = plugin_err;
		_tmp5_ = _tmp4_->message;
		g_warning ("cc-credentials-preferences.vala:259: Error during account edit options" \
" process: %s", _tmp5_);
	}
	gtk_notebook_remove_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNT_OPTIONS);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNTS);
	_g_error_free0 (plugin_err);
}


guint cc_credentials_preferences_get_account_details_id (CcCredentialsPreferences* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_account_details_id;
	result = _tmp0_;
	return result;
}


static void cc_credentials_preferences_set_account_details_id (CcCredentialsPreferences* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_account_details_id = _tmp0_;
	g_object_notify ((GObject *) self, "account-details-id");
}


const gchar* cc_credentials_preferences_get_application_id (CcCredentialsPreferences* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application_id;
	result = _tmp0_;
	return result;
}


static void cc_credentials_preferences_set_application_id (CcCredentialsPreferences* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_application_id);
	self->priv->_application_id = _tmp1_;
	g_object_notify ((GObject *) self, "application-id");
}


static void _cc_credentials_preferences_on_accounts_page_new_account_request_cc_credentials_accounts_page_new_account_request (CcCredentialsAccountsPage* _sender, const gchar* provider_name, gpointer self) {
	cc_credentials_preferences_on_accounts_page_new_account_request (self, provider_name);
}


static void _cc_credentials_preferences_on_accounts_page_reauthenticate_account_request_cc_credentials_accounts_page_reauthenticate_account_request (CcCredentialsAccountsPage* _sender, AgAccount* account, gpointer self) {
	cc_credentials_preferences_on_accounts_page_reauthenticate_account_request (self, account);
}


static void _cc_credentials_preferences_on_accounts_page_account_options_request_cc_credentials_accounts_page_account_options_request (CcCredentialsAccountsPage* _sender, CcCredentialsAccountApplicationRow* application_row, gpointer self) {
	cc_credentials_preferences_on_accounts_page_account_options_request (self, application_row);
}


static void _cc_credentials_preferences_on_accounts_page_account_edit_options_request_cc_credentials_accounts_page_account_edit_options_request (CcCredentialsAccountsPage* _sender, ApPlugin* plugin, gpointer self) {
	cc_credentials_preferences_on_accounts_page_account_edit_options_request (self, plugin);
}


static void _cc_credentials_preferences_on_authorization_page_cancelled_cc_credentials_authorization_page_cancelled (CcCredentialsAuthorizationPage* _sender, gpointer self) {
	cc_credentials_preferences_on_authorization_page_cancelled (self);
}


static void _cc_credentials_preferences_on_login_capture_new_account_request_cc_credentials_login_capture_new_account_request (CcCredentialsLoginCapture* _sender, const gchar* provider_name, const gchar* username, const gchar* password, GHashTable* cookies, gpointer self) {
	cc_credentials_preferences_on_login_capture_new_account_request (self, provider_name, username, password, cookies);
}


static GObject * cc_credentials_preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CcCredentialsPreferences * self;
	AgManager* _tmp0_;
	CcCredentialsAccountsPage* accounts_page = NULL;
	guint _tmp5_;
	CcCredentialsAccountsPage* _tmp15_;
	CcCredentialsAccountsPage* _tmp16_;
	CcCredentialsAccountsPage* _tmp17_;
	CcCredentialsAccountsPage* _tmp18_;
	CcCredentialsAccountsPage* _tmp19_;
	CcCredentialsAuthorizationPage* _tmp20_;
	CcCredentialsAuthorizationPage* _tmp21_;
	CcCredentialsAuthorizationPage* _tmp22_;
	CcCredentialsAuthorizationPage* _tmp23_;
	CcCredentialsLoginCapture* _tmp24_;
	CcCredentialsLoginCapture* _tmp25_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (cc_credentials_preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CC_CREDENTIALS_PREFERENCES (obj);
	gtk_notebook_set_show_tabs ((GtkNotebook*) self, FALSE);
	gtk_notebook_set_show_border ((GtkNotebook*) self, FALSE);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 18);
	_tmp0_ = ag_manager_new ();
	_g_object_unref0 (self->priv->accounts_manager);
	self->priv->accounts_manager = _tmp0_;
	{
		GDesktopAppInfo* _tmp1_;
		GDesktopAppInfo* appInfo;
		GDesktopAppInfo* _tmp2_;
		_tmp1_ = g_desktop_app_info_new ("update-accounts.desktop");
		appInfo = _tmp1_;
		_tmp2_ = appInfo;
		g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (appInfo);
			goto __catch11_g_error;
		}
		_g_object_unref0 (appInfo);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("cc-credentials-preferences.vala:90: Error launching update-accounts to" \
"ol: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp5_ = self->priv->_account_details_id;
	if (_tmp5_ != ((guint) 0)) {
		guint _tmp6_;
		CcCredentialsAccountsPage* _tmp7_;
		CcCredentialsAccountsPage* _tmp8_;
		_tmp6_ = self->priv->_account_details_id;
		_tmp7_ = cc_credentials_accounts_page_new_with_account_details ((AgAccountId) _tmp6_);
		_tmp8_ = g_object_ref_sink (_tmp7_);
		_g_object_unref0 (accounts_page);
		accounts_page = _tmp8_;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = self->priv->_application_id;
		if (_tmp9_ != NULL) {
			const gchar* _tmp10_;
			CcCredentialsAccountsPage* _tmp11_;
			CcCredentialsAccountsPage* _tmp12_;
			_tmp10_ = self->priv->_application_id;
			_tmp11_ = cc_credentials_accounts_page_new_with_application (_tmp10_);
			_tmp12_ = g_object_ref_sink (_tmp11_);
			_g_object_unref0 (accounts_page);
			accounts_page = _tmp12_;
		} else {
			CcCredentialsAccountsPage* _tmp13_;
			CcCredentialsAccountsPage* _tmp14_;
			_tmp13_ = cc_credentials_accounts_page_new ();
			_tmp14_ = g_object_ref_sink (_tmp13_);
			_g_object_unref0 (accounts_page);
			accounts_page = _tmp14_;
		}
	}
	_tmp15_ = accounts_page;
	g_signal_connect_object (_tmp15_, "new-account-request", (GCallback) _cc_credentials_preferences_on_accounts_page_new_account_request_cc_credentials_accounts_page_new_account_request, self, 0);
	_tmp16_ = accounts_page;
	g_signal_connect_object (_tmp16_, "reauthenticate-account-request", (GCallback) _cc_credentials_preferences_on_accounts_page_reauthenticate_account_request_cc_credentials_accounts_page_reauthenticate_account_request, self, 0);
	_tmp17_ = accounts_page;
	g_signal_connect_object (_tmp17_, "account-options-request", (GCallback) _cc_credentials_preferences_on_accounts_page_account_options_request_cc_credentials_accounts_page_account_options_request, self, 0);
	_tmp18_ = accounts_page;
	g_signal_connect_object (_tmp18_, "account-edit-options-request", (GCallback) _cc_credentials_preferences_on_accounts_page_account_edit_options_request_cc_credentials_accounts_page_account_edit_options_request, self, 0);
	_tmp19_ = accounts_page;
	gtk_notebook_append_page ((GtkNotebook*) self, (GtkWidget*) _tmp19_, NULL);
	_tmp20_ = cc_credentials_authorization_page_new ();
	_tmp21_ = g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->authorization_page);
	self->priv->authorization_page = _tmp21_;
	_tmp22_ = self->priv->authorization_page;
	g_signal_connect_object (_tmp22_, "cancelled", (GCallback) _cc_credentials_preferences_on_authorization_page_cancelled_cc_credentials_authorization_page_cancelled, self, 0);
	_tmp23_ = self->priv->authorization_page;
	gtk_notebook_append_page ((GtkNotebook*) self, (GtkWidget*) _tmp23_, NULL);
	gtk_notebook_set_current_page ((GtkNotebook*) self, (gint) CC_CREDENTIALS_PREFERENCES_PREFERENCES_PAGE_ACCOUNTS);
	gtk_widget_set_size_request ((GtkWidget*) self, -1, 400);
	gtk_widget_show ((GtkWidget*) self);
	_tmp24_ = cc_credentials_login_capture_new ();
	_g_object_unref0 (self->priv->login_capture);
	self->priv->login_capture = _tmp24_;
	_tmp25_ = self->priv->login_capture;
	g_signal_connect_object (_tmp25_, "new-account-request", (GCallback) _cc_credentials_preferences_on_login_capture_new_account_request_cc_credentials_login_capture_new_account_request, self, 0);
	_g_object_unref0 (accounts_page);
	return obj;
}


static void cc_credentials_preferences_class_init (CcCredentialsPreferencesClass * klass) {
	cc_credentials_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsPreferencesPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_cc_credentials_preferences_set_property;
	G_OBJECT_CLASS (klass)->constructor = cc_credentials_preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_PREFERENCES_ACCOUNT_DETAILS_ID, g_param_spec_uint ("account-details-id", "account-details-id", "account-details-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_PREFERENCES_APPLICATION_ID, g_param_spec_string ("application-id", "application-id", "application-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void cc_credentials_preferences_instance_init (CcCredentialsPreferences * self) {
	self->priv = CC_CREDENTIALS_PREFERENCES_GET_PRIVATE (self);
}


static void cc_credentials_preferences_finalize (GObject* obj) {
	CcCredentialsPreferences * self;
	self = CC_CREDENTIALS_PREFERENCES (obj);
	_g_object_unref0 (self->priv->authorization_page);
	_g_object_unref0 (self->priv->accounts_manager);
	_g_object_unref0 (self->priv->login_capture);
	_g_free0 (self->priv->_application_id);
	G_OBJECT_CLASS (cc_credentials_preferences_parent_class)->finalize (obj);
}


/**
 * Web credentials preferences widget. This can be packed into the GNOME
 * Control Center or used in a standalone application.
 */
GType cc_credentials_preferences_get_type (void) {
	static volatile gsize cc_credentials_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsPreferences), 0, (GInstanceInitFunc) cc_credentials_preferences_instance_init, NULL };
		GType cc_credentials_preferences_type_id;
		cc_credentials_preferences_type_id = g_type_register_static (GTK_TYPE_NOTEBOOK, "CcCredentialsPreferences", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_preferences_type_id__volatile, cc_credentials_preferences_type_id);
	}
	return cc_credentials_preferences_type_id__volatile;
}


static void _vala_cc_credentials_preferences_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsPreferences * self;
	self = CC_CREDENTIALS_PREFERENCES (object);
	switch (property_id) {
		case CC_CREDENTIALS_PREFERENCES_ACCOUNT_DETAILS_ID:
		g_value_set_uint (value, cc_credentials_preferences_get_account_details_id (self));
		break;
		case CC_CREDENTIALS_PREFERENCES_APPLICATION_ID:
		g_value_set_string (value, cc_credentials_preferences_get_application_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_cc_credentials_preferences_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CcCredentialsPreferences * self;
	self = CC_CREDENTIALS_PREFERENCES (object);
	switch (property_id) {
		case CC_CREDENTIALS_PREFERENCES_ACCOUNT_DETAILS_ID:
		cc_credentials_preferences_set_account_details_id (self, g_value_get_uint (value));
		break;
		case CC_CREDENTIALS_PREFERENCES_APPLICATION_ID:
		cc_credentials_preferences_set_application_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



