/* cc-credentials-accounts-page.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-accounts-page.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <libaccounts-glib/accounts-glib.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <libaccount-plugin/account-plugin.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE (cc_credentials_accounts_page_get_type ())
#define CC_CREDENTIALS_ACCOUNTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, CcCredentialsAccountsPage))
#define CC_CREDENTIALS_ACCOUNTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, CcCredentialsAccountsPageClass))
#define CC_CREDENTIALS_IS_ACCOUNTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE))
#define CC_CREDENTIALS_IS_ACCOUNTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE))
#define CC_CREDENTIALS_ACCOUNTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, CcCredentialsAccountsPageClass))

typedef struct _CcCredentialsAccountsPage CcCredentialsAccountsPage;
typedef struct _CcCredentialsAccountsPageClass CcCredentialsAccountsPageClass;
typedef struct _CcCredentialsAccountsPagePrivate CcCredentialsAccountsPagePrivate;

#define CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL (cc_credentials_accounts_model_get_type ())
#define CC_CREDENTIALS_ACCOUNTS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModel))
#define CC_CREDENTIALS_ACCOUNTS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModelClass))
#define CC_CREDENTIALS_IS_ACCOUNTS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL))
#define CC_CREDENTIALS_IS_ACCOUNTS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL))
#define CC_CREDENTIALS_ACCOUNTS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModelClass))

typedef struct _CcCredentialsAccountsModel CcCredentialsAccountsModel;
typedef struct _CcCredentialsAccountsModelClass CcCredentialsAccountsModelClass;

#define CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE (cc_credentials_account_details_page_get_type ())
#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, CcCredentialsAccountDetailsPage))
#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, CcCredentialsAccountDetailsPageClass))
#define CC_CREDENTIALS_IS_ACCOUNT_DETAILS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE))
#define CC_CREDENTIALS_IS_ACCOUNT_DETAILS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE))
#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, CcCredentialsAccountDetailsPageClass))

typedef struct _CcCredentialsAccountDetailsPage CcCredentialsAccountDetailsPage;
typedef struct _CcCredentialsAccountDetailsPageClass CcCredentialsAccountDetailsPageClass;

#define CC_CREDENTIALS_ACCOUNTS_PAGE_TYPE_NOTEBOOK_PAGE (cc_credentials_accounts_page_notebook_page_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CC_CREDENTIALS_ACCOUNTS_MODEL_TYPE_MODEL_COLUMNS (cc_credentials_accounts_model_model_columns_get_type ())

#define CC_CREDENTIALS_TYPE_PROVIDERS_PAGE (cc_credentials_providers_page_get_type ())
#define CC_CREDENTIALS_PROVIDERS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, CcCredentialsProvidersPage))
#define CC_CREDENTIALS_PROVIDERS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, CcCredentialsProvidersPageClass))
#define CC_CREDENTIALS_IS_PROVIDERS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE))
#define CC_CREDENTIALS_IS_PROVIDERS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE))
#define CC_CREDENTIALS_PROVIDERS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_PROVIDERS_PAGE, CcCredentialsProvidersPageClass))

typedef struct _CcCredentialsProvidersPage CcCredentialsProvidersPage;
typedef struct _CcCredentialsProvidersPageClass CcCredentialsProvidersPageClass;

#define CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_ROW (cc_credentials_account_application_row_get_type ())
typedef struct _CcCredentialsAccountApplicationRow CcCredentialsAccountApplicationRow;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _CcCredentialsAccountsPage {
	GtkGrid parent_instance;
	CcCredentialsAccountsPagePrivate * priv;
};

struct _CcCredentialsAccountsPageClass {
	GtkGridClass parent_class;
};

struct _CcCredentialsAccountsPagePrivate {
	guint _account_details_id;
	gchar* _application_id;
	GtkTreeView* accounts_tree;
	CcCredentialsAccountsModel* accounts_store;
	GtkNotebook* accounts_notebook;
	CcCredentialsAccountDetailsPage* account_details_page;
};

typedef enum  {
	CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_SELECT_PROVIDER = 0,
	CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_ACCOUNT_DETAILS = 1
} CcCredentialsAccountsPageNotebookPage;

typedef enum  {
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID = 0,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT = 1,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON = 2,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF = 3,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION = 4,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED = 5,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION = 6
} CcCredentialsAccountsModelModelColumns;

struct _CcCredentialsAccountApplicationRow {
	gchar* name;
	GIcon* icon;
	gchar* description;
	ApApplicationPlugin* plugin;
	GtkWidget* plugin_widget;
};


static gpointer cc_credentials_accounts_page_parent_class = NULL;

GType cc_credentials_accounts_page_get_type (void) G_GNUC_CONST;
GType cc_credentials_accounts_model_get_type (void) G_GNUC_CONST;
GType cc_credentials_account_details_page_get_type (void) G_GNUC_CONST;
#define CC_CREDENTIALS_ACCOUNTS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, CcCredentialsAccountsPagePrivate))
enum  {
	CC_CREDENTIALS_ACCOUNTS_PAGE_DUMMY_PROPERTY,
	CC_CREDENTIALS_ACCOUNTS_PAGE_ACCOUNT_DETAILS_ID,
	CC_CREDENTIALS_ACCOUNTS_PAGE_APPLICATION_ID
};
static GType cc_credentials_accounts_page_notebook_page_get_type (void) G_GNUC_UNUSED;
CcCredentialsAccountsPage* cc_credentials_accounts_page_new (void);
CcCredentialsAccountsPage* cc_credentials_accounts_page_construct (GType object_type);
CcCredentialsAccountsPage* cc_credentials_accounts_page_new_with_account_details (AgAccountId account_id);
CcCredentialsAccountsPage* cc_credentials_accounts_page_construct_with_account_details (GType object_type, AgAccountId account_id);
CcCredentialsAccountsPage* cc_credentials_accounts_page_new_with_application (const gchar* application);
CcCredentialsAccountsPage* cc_credentials_accounts_page_construct_with_application (GType object_type, const gchar* application);
static GtkWidget* cc_credentials_accounts_page_create_legal_button (CcCredentialsAccountsPage* self);
static GtkWidget* cc_credentials_accounts_page_create_accounts_tree (CcCredentialsAccountsPage* self);
CcCredentialsAccountsModel* cc_credentials_accounts_model_new (void);
CcCredentialsAccountsModel* cc_credentials_accounts_model_construct (GType object_type);
static void cc_credentials_accounts_page_provider_icon_cell_data_func (CcCredentialsAccountsPage* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter);
static void _cc_credentials_accounts_page_provider_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
GType cc_credentials_accounts_model_model_columns_get_type (void) G_GNUC_CONST;
guint cc_credentials_accounts_page_get_account_details_id (CcCredentialsAccountsPage* self);
gboolean cc_credentials_accounts_model_find_iter_for_account_id (CcCredentialsAccountsModel* self, AgAccountId account_id, GtkTreeIter* iter);
static void cc_credentials_accounts_page_on_accounts_store_row_changed (CcCredentialsAccountsPage* self, GtkTreeModel* tree_model, GtkTreePath* path, GtkTreeIter* iter);
static void _cc_credentials_accounts_page_on_accounts_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void cc_credentials_accounts_page_on_accounts_selection_changed (CcCredentialsAccountsPage* self, GtkTreeSelection* selection);
static void _cc_credentials_accounts_page_on_accounts_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GtkWidget* cc_credentials_accounts_page_create_accounts_notebook (CcCredentialsAccountsPage* self);
GType cc_credentials_providers_page_get_type (void) G_GNUC_CONST;
const gchar* cc_credentials_accounts_page_get_application_id (CcCredentialsAccountsPage* self);
CcCredentialsProvidersPage* cc_credentials_providers_page_new_with_application (const gchar* application);
CcCredentialsProvidersPage* cc_credentials_providers_page_construct_with_application (GType object_type, const gchar* application);
CcCredentialsProvidersPage* cc_credentials_providers_page_new (void);
CcCredentialsProvidersPage* cc_credentials_providers_page_construct (GType object_type);
static GtkWidget* cc_credentials_accounts_page_create_account_details_page (CcCredentialsAccountsPage* self);
static void cc_credentials_accounts_page_on_providers_page_new_account_request (CcCredentialsAccountsPage* self, const gchar* provider_name);
static void _cc_credentials_accounts_page_on_providers_page_new_account_request_cc_credentials_providers_page_new_account_request (CcCredentialsProvidersPage* _sender, const gchar* provider_name, gpointer self);
static void cc_credentials_accounts_page_on_account_details_page_reauthenticate_account_request (CcCredentialsAccountsPage* self, AgAccount* account);
static void _cc_credentials_accounts_page_on_account_details_page_reauthenticate_account_request_cc_credentials_account_details_page_reauthenticate_account_request (CcCredentialsAccountDetailsPage* _sender, AgAccount* account, gpointer self);
GType cc_credentials_account_application_row_get_type (void) G_GNUC_CONST;
CcCredentialsAccountApplicationRow* cc_credentials_account_application_row_dup (const CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_free (CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_copy (const CcCredentialsAccountApplicationRow* self, CcCredentialsAccountApplicationRow* dest);
void cc_credentials_account_application_row_destroy (CcCredentialsAccountApplicationRow* self);
static void cc_credentials_accounts_page_on_account_details_page_account_options_request (CcCredentialsAccountsPage* self, CcCredentialsAccountApplicationRow* application_row);
static void _cc_credentials_accounts_page_on_account_details_page_account_options_request_cc_credentials_account_details_page_account_options_request (CcCredentialsAccountDetailsPage* _sender, CcCredentialsAccountApplicationRow* application_row, gpointer self);
static void cc_credentials_accounts_page_on_account_details_page_account_edit_options_request (CcCredentialsAccountsPage* self, ApPlugin* plugin);
static void _cc_credentials_accounts_page_on_account_details_page_account_edit_options_request_cc_credentials_account_details_page_account_edit_options_request (CcCredentialsAccountDetailsPage* _sender, ApPlugin* plugin, gpointer self);
CcCredentialsAccountDetailsPage* cc_credentials_account_details_page_new (CcCredentialsAccountsModel* accounts_store);
CcCredentialsAccountDetailsPage* cc_credentials_account_details_page_construct (GType object_type, CcCredentialsAccountsModel* accounts_store);
void cc_credentials_account_details_page_set_account_iter (CcCredentialsAccountDetailsPage* self, GtkTreeIter* value);
static gboolean _gtk_tree_iter_equal (const GtkTreeIter* s1, const GtkTreeIter* s2);
static void cc_credentials_accounts_page_set_account_details_id (CcCredentialsAccountsPage* self, guint value);
static void cc_credentials_accounts_page_set_application_id (CcCredentialsAccountsPage* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * cc_credentials_accounts_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void cc_credentials_accounts_page_finalize (GObject* obj);
static void _vala_cc_credentials_accounts_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_cc_credentials_accounts_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Select the desired page of @link accounts_notebook to select an account
     * to view settings of, or for showing details of an existing account.
     *
     * @param SELECT_PROVIDER select a provider for a new account
     * @param ACCOUNT_DETAILS display details of an existing account
     */
static GType cc_credentials_accounts_page_notebook_page_get_type (void) {
	static volatile gsize cc_credentials_accounts_page_notebook_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_accounts_page_notebook_page_type_id__volatile)) {
		static const GEnumValue values[] = {{CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_SELECT_PROVIDER, "CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_SELECT_PROVIDER", "select-provider"}, {CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_ACCOUNT_DETAILS, "CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_ACCOUNT_DETAILS", "account-details"}, {0, NULL, NULL}};
		GType cc_credentials_accounts_page_notebook_page_type_id;
		cc_credentials_accounts_page_notebook_page_type_id = g_enum_register_static ("CcCredentialsAccountsPageNotebookPage", values);
		g_once_init_leave (&cc_credentials_accounts_page_notebook_page_type_id__volatile, cc_credentials_accounts_page_notebook_page_type_id);
	}
	return cc_credentials_accounts_page_notebook_page_type_id__volatile;
}


CcCredentialsAccountsPage* cc_credentials_accounts_page_construct (GType object_type) {
	CcCredentialsAccountsPage * self = NULL;
	self = (CcCredentialsAccountsPage*) g_object_new (object_type, NULL);
	return self;
}


CcCredentialsAccountsPage* cc_credentials_accounts_page_new (void) {
	return cc_credentials_accounts_page_construct (CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE);
}


CcCredentialsAccountsPage* cc_credentials_accounts_page_construct_with_account_details (GType object_type, AgAccountId account_id) {
	CcCredentialsAccountsPage * self = NULL;
	AgAccountId _tmp0_;
	_tmp0_ = account_id;
	self = (CcCredentialsAccountsPage*) g_object_new (object_type, "account-details-id", _tmp0_, NULL);
	return self;
}


CcCredentialsAccountsPage* cc_credentials_accounts_page_new_with_account_details (AgAccountId account_id) {
	return cc_credentials_accounts_page_construct_with_account_details (CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, account_id);
}


CcCredentialsAccountsPage* cc_credentials_accounts_page_construct_with_application (GType object_type, const gchar* application) {
	CcCredentialsAccountsPage * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = application;
	self = (CcCredentialsAccountsPage*) g_object_new (object_type, "application-id", _tmp0_, NULL);
	return self;
}


CcCredentialsAccountsPage* cc_credentials_accounts_page_new_with_application (const gchar* application) {
	return cc_credentials_accounts_page_construct_with_application (CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, application);
}


/**
     * Create the buttonbox containing the button to display a legal notice.
     *
     * @return a Gtk.ButtonBox for presecting the legal notice button
     */
static GtkWidget* cc_credentials_accounts_page_create_legal_button (CcCredentialsAccountsPage* self) {
	GtkWidget* result = NULL;
	GtkButtonBox* _tmp0_;
	GtkButtonBox* _tmp1_;
	GtkButtonBox* buttonbox;
	const gchar* _tmp2_ = NULL;
	GtkLinkButton* _tmp3_;
	GtkLinkButton* _tmp4_;
	GtkLinkButton* legal_button;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	buttonbox = _tmp1_;
	_tmp2_ = _ ("Legal notice");
	_tmp3_ = (GtkLinkButton*) gtk_link_button_new_with_label ("help:" "web-credentials" "/legal-notice", _tmp2_);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	legal_button = _tmp4_;
	g_object_set (buttonbox, "layout-style", GTK_BUTTONBOX_END, NULL);
	gtk_container_add ((GtkContainer*) buttonbox, (GtkWidget*) legal_button);
	gtk_widget_show_all ((GtkWidget*) buttonbox);
	result = (GtkWidget*) buttonbox;
	_g_object_unref0 (legal_button);
	return result;
}


/**
     * Create the treeview for the list of accounts and show it.
     *
     * @return a Gtk.ScrolledWindow containing a treeview of accounts
     */
static void _cc_credentials_accounts_page_provider_icon_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	cc_credentials_accounts_page_provider_icon_cell_data_func (self, cell_layout, cell, tree_model, iter);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cc_credentials_accounts_page_on_accounts_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	cc_credentials_accounts_page_on_accounts_store_row_changed (self, _sender, path, iter);
}


static void _cc_credentials_accounts_page_on_accounts_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	cc_credentials_accounts_page_on_accounts_selection_changed (self, _sender);
}


static GtkWidget* cc_credentials_accounts_page_create_accounts_tree (CcCredentialsAccountsPage* self) {
	GtkWidget* result = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	CcCredentialsAccountsModel* _tmp2_;
	GtkTreeView* _tmp3_;
	CcCredentialsAccountsModel* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkCellRendererPixbuf* _tmp6_;
	GtkCellRendererPixbuf* _tmp7_;
	GtkCellRendererPixbuf* provider_icon_renderer;
	GtkCellRendererPixbuf* _tmp8_;
	GtkCellRendererPixbuf* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkCellRendererText* _tmp11_;
	GtkCellRendererText* text_renderer;
	GtkCellRendererText* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkTreeViewColumn* _tmp14_;
	GtkTreeViewColumn* accounts_tree_column;
	GtkTreeViewColumn* _tmp15_;
	GtkCellRendererPixbuf* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkCellRendererPixbuf* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	GtkCellRendererText* _tmp22_;
	GtkCellRendererPixbuf* _tmp23_;
	GtkCellRendererPixbuf* _tmp24_;
	GtkCellRendererPixbuf* attention_icon_renderer;
	GtkCellRendererPixbuf* _tmp25_;
	GtkTreeViewColumn* _tmp26_;
	GtkCellRendererPixbuf* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	GtkCellRendererPixbuf* _tmp29_;
	GtkTreeView* _tmp30_;
	GtkTreeViewColumn* _tmp31_;
	GtkScrolledWindow* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkScrolledWindow* scrolled_window;
	GtkScrolledWindow* _tmp34_;
	GtkScrolledWindow* _tmp35_;
	GtkScrolledWindow* _tmp36_;
	GtkScrolledWindow* _tmp37_;
	GtkTreeView* _tmp38_;
	GtkTreeView* _tmp39_;
	GtkTreeSelection* _tmp40_ = NULL;
	GtkTreeSelection* _tmp41_;
	GtkTreeSelection* accounts_selection;
	guint _tmp42_;
	CcCredentialsAccountsModel* _tmp50_;
	GtkTreeSelection* _tmp51_;
	GtkScrolledWindow* _tmp52_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->accounts_tree);
	self->priv->accounts_tree = _tmp1_;
	_tmp2_ = cc_credentials_accounts_model_new ();
	_g_object_unref0 (self->priv->accounts_store);
	self->priv->accounts_store = _tmp2_;
	_tmp3_ = self->priv->accounts_tree;
	_tmp4_ = self->priv->accounts_store;
	gtk_tree_view_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = self->priv->accounts_tree;
	gtk_tree_view_set_headers_visible (_tmp5_, FALSE);
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	provider_icon_renderer = _tmp7_;
	_tmp8_ = provider_icon_renderer;
	g_object_set (_tmp8_, "stock-size", (guint) GTK_ICON_SIZE_DND, NULL);
	_tmp9_ = provider_icon_renderer;
	gtk_cell_renderer_set_padding ((GtkCellRenderer*) _tmp9_, 8, 8);
	_tmp10_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp11_ = g_object_ref_sink (_tmp10_);
	text_renderer = _tmp11_;
	_tmp12_ = text_renderer;
	g_object_set (_tmp12_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp13_ = gtk_tree_view_column_new ();
	_tmp14_ = g_object_ref_sink (_tmp13_);
	accounts_tree_column = _tmp14_;
	_tmp15_ = accounts_tree_column;
	_tmp16_ = provider_icon_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) _tmp16_, FALSE);
	_tmp17_ = accounts_tree_column;
	_tmp18_ = provider_icon_renderer;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp17_, (GtkCellRenderer*) _tmp18_, _cc_credentials_accounts_page_provider_icon_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp19_ = accounts_tree_column;
	_tmp20_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp19_, (GtkCellRenderer*) _tmp20_, TRUE);
	_tmp21_ = accounts_tree_column;
	_tmp22_ = text_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp21_, (GtkCellRenderer*) _tmp22_, "markup", (gint) CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION);
	_tmp23_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp24_ = g_object_ref_sink (_tmp23_);
	attention_icon_renderer = _tmp24_;
	_tmp25_ = attention_icon_renderer;
	g_object_set (_tmp25_, "icon-name", "dialog-error-symbolic", NULL);
	_tmp26_ = accounts_tree_column;
	_tmp27_ = attention_icon_renderer;
	gtk_cell_layout_pack_end ((GtkCellLayout*) _tmp26_, (GtkCellRenderer*) _tmp27_, FALSE);
	_tmp28_ = accounts_tree_column;
	_tmp29_ = attention_icon_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp28_, (GtkCellRenderer*) _tmp29_, "visible", (gint) CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION);
	_tmp30_ = self->priv->accounts_tree;
	_tmp31_ = accounts_tree_column;
	gtk_tree_view_append_column (_tmp30_, _tmp31_);
	_tmp32_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp33_ = g_object_ref_sink (_tmp32_);
	scrolled_window = _tmp33_;
	_tmp34_ = scrolled_window;
	gtk_scrolled_window_set_min_content_height (_tmp34_, 250);
	_tmp35_ = scrolled_window;
	gtk_scrolled_window_set_min_content_width (_tmp35_, 250);
	_tmp36_ = scrolled_window;
	gtk_scrolled_window_set_shadow_type (_tmp36_, GTK_SHADOW_ETCHED_IN);
	_tmp37_ = scrolled_window;
	_tmp38_ = self->priv->accounts_tree;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = self->priv->accounts_tree;
	_tmp40_ = gtk_tree_view_get_selection (_tmp39_);
	_tmp41_ = _g_object_ref0 (_tmp40_);
	accounts_selection = _tmp41_;
	_tmp42_ = self->priv->_account_details_id;
	if (_tmp42_ != ((guint) 0)) {
		GtkTreeIter iter = {0};
		CcCredentialsAccountsModel* _tmp43_;
		guint _tmp44_;
		GtkTreeIter _tmp45_ = {0};
		gboolean _tmp46_ = FALSE;
		_tmp43_ = self->priv->accounts_store;
		_tmp44_ = self->priv->_account_details_id;
		_tmp46_ = cc_credentials_accounts_model_find_iter_for_account_id (_tmp43_, (AgAccountId) _tmp44_, &_tmp45_);
		iter = _tmp45_;
		if (_tmp46_) {
			GtkTreeSelection* _tmp47_;
			GtkTreeIter _tmp48_;
			_tmp47_ = accounts_selection;
			_tmp48_ = iter;
			gtk_tree_selection_select_iter (_tmp47_, &_tmp48_);
		} else {
			guint _tmp49_;
			_tmp49_ = self->priv->_account_details_id;
			g_warning ("cc-credentials-accounts-page.vala:192: Passed-in account ID '%u' not f" \
"ound.", (guint) _tmp49_);
		}
	}
	_tmp50_ = self->priv->accounts_store;
	g_signal_connect_object ((GtkTreeModel*) _tmp50_, "row-changed", (GCallback) _cc_credentials_accounts_page_on_accounts_store_row_changed_gtk_tree_model_row_changed, self, 0);
	_tmp51_ = accounts_selection;
	g_signal_connect_object (_tmp51_, "changed", (GCallback) _cc_credentials_accounts_page_on_accounts_selection_changed_gtk_tree_selection_changed, self, 0);
	_tmp52_ = scrolled_window;
	gtk_widget_show_all ((GtkWidget*) _tmp52_);
	result = (GtkWidget*) scrolled_window;
	_g_object_unref0 (accounts_selection);
	_g_object_unref0 (attention_icon_renderer);
	_g_object_unref0 (accounts_tree_column);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (provider_icon_renderer);
	return result;
}


/**
     * Create the notebook with a page for adding providers.
     *
     * @return a Gtk.Notebook containing a provider selection tree view
     */
static void _cc_credentials_accounts_page_on_providers_page_new_account_request_cc_credentials_providers_page_new_account_request (CcCredentialsProvidersPage* _sender, const gchar* provider_name, gpointer self) {
	cc_credentials_accounts_page_on_providers_page_new_account_request (self, provider_name);
}


static void _cc_credentials_accounts_page_on_account_details_page_reauthenticate_account_request_cc_credentials_account_details_page_reauthenticate_account_request (CcCredentialsAccountDetailsPage* _sender, AgAccount* account, gpointer self) {
	cc_credentials_accounts_page_on_account_details_page_reauthenticate_account_request (self, account);
}


static void _cc_credentials_accounts_page_on_account_details_page_account_options_request_cc_credentials_account_details_page_account_options_request (CcCredentialsAccountDetailsPage* _sender, CcCredentialsAccountApplicationRow* application_row, gpointer self) {
	cc_credentials_accounts_page_on_account_details_page_account_options_request (self, application_row);
}


static void _cc_credentials_accounts_page_on_account_details_page_account_edit_options_request_cc_credentials_account_details_page_account_edit_options_request (CcCredentialsAccountDetailsPage* _sender, ApPlugin* plugin, gpointer self) {
	cc_credentials_accounts_page_on_account_details_page_account_edit_options_request (self, plugin);
}


static GtkWidget* cc_credentials_accounts_page_create_accounts_notebook (CcCredentialsAccountsPage* self) {
	GtkWidget* result = NULL;
	GtkNotebook* _tmp0_;
	GtkNotebook* _tmp1_;
	GtkNotebook* _tmp2_;
	GtkNotebook* _tmp3_;
	GtkNotebook* _tmp4_;
	CcCredentialsProvidersPage* providers_page = NULL;
	const gchar* _tmp5_;
	GtkWidget* _tmp11_ = NULL;
	CcCredentialsAccountDetailsPage* account_details_page;
	CcCredentialsProvidersPage* _tmp12_;
	GtkNotebook* _tmp13_;
	CcCredentialsProvidersPage* _tmp14_;
	GtkNotebook* _tmp15_;
	GtkNotebook* _tmp16_;
	GtkNotebook* _tmp17_;
	GtkNotebook* _tmp18_;
	GtkWidget* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkNotebook*) gtk_notebook_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->accounts_notebook);
	self->priv->accounts_notebook = _tmp1_;
	_tmp2_ = self->priv->accounts_notebook;
	gtk_notebook_set_show_tabs (_tmp2_, FALSE);
	_tmp3_ = self->priv->accounts_notebook;
	gtk_notebook_set_show_border (_tmp3_, FALSE);
	_tmp4_ = self->priv->accounts_notebook;
	g_object_set ((GtkWidget*) _tmp4_, "expand", TRUE, NULL);
	_tmp5_ = self->priv->_application_id;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		CcCredentialsProvidersPage* _tmp7_;
		CcCredentialsProvidersPage* _tmp8_;
		_tmp6_ = self->priv->_application_id;
		_tmp7_ = cc_credentials_providers_page_new_with_application (_tmp6_);
		_tmp8_ = g_object_ref_sink (_tmp7_);
		_g_object_unref0 (providers_page);
		providers_page = _tmp8_;
	} else {
		CcCredentialsProvidersPage* _tmp9_;
		CcCredentialsProvidersPage* _tmp10_;
		_tmp9_ = cc_credentials_providers_page_new ();
		_tmp10_ = g_object_ref_sink (_tmp9_);
		_g_object_unref0 (providers_page);
		providers_page = _tmp10_;
	}
	_tmp11_ = cc_credentials_accounts_page_create_account_details_page (self);
	account_details_page = CC_CREDENTIALS_IS_ACCOUNT_DETAILS_PAGE (_tmp11_) ? ((CcCredentialsAccountDetailsPage*) _tmp11_) : NULL;
	_tmp12_ = providers_page;
	g_signal_connect_object (_tmp12_, "new-account-request", (GCallback) _cc_credentials_accounts_page_on_providers_page_new_account_request_cc_credentials_providers_page_new_account_request, self, 0);
	g_signal_connect_object (account_details_page, "reauthenticate-account-request", (GCallback) _cc_credentials_accounts_page_on_account_details_page_reauthenticate_account_request_cc_credentials_account_details_page_reauthenticate_account_request, self, 0);
	g_signal_connect_object (account_details_page, "account-options-request", (GCallback) _cc_credentials_accounts_page_on_account_details_page_account_options_request_cc_credentials_account_details_page_account_options_request, self, 0);
	g_signal_connect_object (account_details_page, "account-edit-options-request", (GCallback) _cc_credentials_accounts_page_on_account_details_page_account_edit_options_request_cc_credentials_account_details_page_account_edit_options_request, self, 0);
	_tmp13_ = self->priv->accounts_notebook;
	_tmp14_ = providers_page;
	gtk_notebook_append_page (_tmp13_, (GtkWidget*) _tmp14_, NULL);
	_tmp15_ = self->priv->accounts_notebook;
	gtk_notebook_append_page (_tmp15_, (GtkWidget*) account_details_page, NULL);
	_tmp16_ = self->priv->accounts_notebook;
	gtk_notebook_set_current_page (_tmp16_, (gint) CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_SELECT_PROVIDER);
	_tmp17_ = self->priv->accounts_notebook;
	gtk_widget_show_all ((GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->accounts_notebook;
	_tmp19_ = _g_object_ref0 ((GtkWidget*) _tmp18_);
	result = _tmp19_;
	_g_object_unref0 (account_details_page);
	_g_object_unref0 (providers_page);
	return result;
}


/**
     * Create a notebook page for showing details for an account, such as the
     * list of applications which use that account.
     *
     * @return a Gtk.Grid containing widgets for listing account details 
     */
static GtkWidget* cc_credentials_accounts_page_create_account_details_page (CcCredentialsAccountsPage* self) {
	GtkWidget* result = NULL;
	CcCredentialsAccountsModel* _tmp0_;
	CcCredentialsAccountDetailsPage* _tmp1_;
	CcCredentialsAccountDetailsPage* _tmp2_;
	CcCredentialsAccountDetailsPage* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->accounts_store;
	_tmp1_ = cc_credentials_account_details_page_new (_tmp0_);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->account_details_page);
	self->priv->account_details_page = _tmp2_;
	_tmp3_ = self->priv->account_details_page;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) _tmp3_);
	result = _tmp4_;
	return result;
}


/**
     * Show the translucent provider icon if the account is disabled, and the
     * standard icon when the account is enabled.
     *
     * @param column the TreeModelColumn. Unused
     * @param cell the Gtk.CellRendererPixbuf for the column
     * @param model the AccountsModel to get data from
     * @param iter the oter in AccountsModel to get data from
     */
static void cc_credentials_accounts_page_provider_icon_cell_data_func (CcCredentialsAccountsPage* self, GtkCellLayout* column, GtkCellRenderer* cell, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean enabled = FALSE;
	GIcon* icon = NULL;
	GdkPixbuf* pixbuf = NULL;
	GtkCellRenderer* _tmp0_;
	GtkCellRendererPixbuf* _tmp1_;
	GtkCellRendererPixbuf* renderer;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = cell;
	_tmp1_ = _g_object_ref0 (GTK_IS_CELL_RENDERER_PIXBUF (_tmp0_) ? ((GtkCellRendererPixbuf*) _tmp0_) : NULL);
	renderer = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = *iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED, &enabled, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON, &icon, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF, &pixbuf, -1, -1);
	_tmp4_ = enabled;
	if (_tmp4_) {
		GtkCellRendererPixbuf* _tmp5_;
		GtkCellRendererPixbuf* _tmp6_;
		GIcon* _tmp7_;
		_tmp5_ = renderer;
		g_object_set (_tmp5_, "pixbuf", NULL, NULL);
		_tmp6_ = renderer;
		_tmp7_ = icon;
		g_object_set (_tmp6_, "gicon", _tmp7_, NULL);
	} else {
		GtkCellRendererPixbuf* _tmp8_;
		GtkCellRendererPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp8_ = renderer;
		g_object_set (_tmp8_, "gicon", NULL, NULL);
		_tmp9_ = renderer;
		_tmp10_ = pixbuf;
		g_object_set (_tmp9_, "pixbuf", _tmp10_, NULL);
	}
	_g_object_unref0 (renderer);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (icon);
}


/**
     * Reload the account details page if the currently-selected row changed.
     *
     * @param tree_model the AccountsModel
     * @param path the Gtk.TreePath of the changed row
     * @param iter the Gtk.TreeIter of the changed row
     */
static void cc_credentials_accounts_page_on_accounts_store_row_changed (CcCredentialsAccountsPage* self, GtkTreeModel* tree_model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->accounts_tree;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp4_ = path;
	_tmp5_ = gtk_tree_selection_path_is_selected (_tmp3_, _tmp4_);
	if (_tmp5_) {
		CcCredentialsAccountDetailsPage* _tmp6_;
		GtkTreeIter _tmp7_;
		_tmp6_ = self->priv->account_details_page;
		_tmp7_ = *iter;
		cc_credentials_account_details_page_set_account_iter (_tmp6_, &_tmp7_);
	}
	_g_object_unref0 (selection);
}


/**
     * Show an appropriate page in the notebook, depending on which row was
     * selected in the accounts treeview.
     *
     * @param selection the selection of the accounts treeview
     */
static gboolean _gtk_tree_iter_equal (const GtkTreeIter* s1, const GtkTreeIter* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->stamp != s2->stamp) {
		return FALSE;
	}
	if (s1->user_data != s2->user_data) {
		return FALSE;
	}
	if (s1->user_data2 != s2->user_data2) {
		return FALSE;
	}
	if (s1->user_data3 != s2->user_data3) {
		return FALSE;
	}
	return TRUE;
}


static void cc_credentials_accounts_page_on_accounts_selection_changed (CcCredentialsAccountsPage* self, GtkTreeSelection* selection) {
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_tmp0_ = selection;
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (_tmp3_) {
		GtkTreeIter test_iter = {0};
		GtkTreeModel* _tmp5_;
		gint _tmp6_ = 0;
		gint n_rows;
		GtkTreeModel* _tmp7_;
		gint _tmp8_;
		GtkTreeIter _tmp9_ = {0};
		gboolean _tmp10_ = FALSE;
		_tmp5_ = model;
		_tmp6_ = gtk_tree_model_iter_n_children (_tmp5_, NULL);
		n_rows = _tmp6_;
		_tmp7_ = model;
		_tmp8_ = n_rows;
		_tmp10_ = gtk_tree_model_iter_nth_child (_tmp7_, &_tmp9_, NULL, _tmp8_ - 1);
		test_iter = _tmp9_;
		if (_tmp10_) {
			GtkTreeIter _tmp11_;
			GtkTreeIter _tmp12_;
			_tmp11_ = iter;
			_tmp12_ = test_iter;
			if (_gtk_tree_iter_equal (&_tmp11_, &_tmp12_) == TRUE) {
				GtkNotebook* _tmp13_;
				_tmp13_ = self->priv->accounts_notebook;
				gtk_notebook_set_current_page (_tmp13_, (gint) CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_SELECT_PROVIDER);
			} else {
				CcCredentialsAccountDetailsPage* _tmp14_;
				GtkTreeIter _tmp15_;
				GtkNotebook* _tmp16_;
				_tmp14_ = self->priv->account_details_page;
				_tmp15_ = iter;
				cc_credentials_account_details_page_set_account_iter (_tmp14_, &_tmp15_);
				_tmp16_ = self->priv->accounts_notebook;
				gtk_notebook_set_current_page (_tmp16_, (gint) CC_CREDENTIALS_ACCOUNTS_PAGE_NOTEBOOK_PAGE_ACCOUNT_DETAILS);
			}
		} else {
			g_assert_not_reached ();
		}
	} else {
		GtkTreeModel* _tmp17_;
		gint _tmp18_ = 0;
		_tmp17_ = model;
		_tmp18_ = gtk_tree_model_iter_n_children (_tmp17_, NULL);
		if (_tmp18_ > 0) {
			GtkTreeSelection* _tmp19_;
			GtkTreePath* _tmp20_;
			GtkTreePath* _tmp21_;
			_tmp19_ = selection;
			_tmp20_ = gtk_tree_path_new_first ();
			_tmp21_ = _tmp20_;
			gtk_tree_selection_select_path (_tmp19_, _tmp21_);
			_gtk_tree_path_free0 (_tmp21_);
		}
	}
	_g_object_unref0 (model);
}


/**
     * Tell the main panel to show a new account page for the provider selected
     * in the tree view of available providers.
     *
     * @param provider_name the name of the provider for which to add an
     * account
     */
static void cc_credentials_accounts_page_on_providers_page_new_account_request (CcCredentialsAccountsPage* self, const gchar* provider_name) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (provider_name != NULL);
	_tmp0_ = provider_name;
	g_signal_emit_by_name (self, "new-account-request", _tmp0_);
}


/**
     * Tell the main panel to show the authentication page for an account that
     * requires attention in the account details view.
     *
     * @param account the account to reauthenticate
     */
static void cc_credentials_accounts_page_on_account_details_page_reauthenticate_account_request (CcCredentialsAccountsPage* self, AgAccount* account) {
	AgAccount* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_tmp0_ = account;
	g_signal_emit_by_name (self, "reauthenticate-account-request", _tmp0_);
}


/**
     * Tell the main panel to show the options page for an application that
     * required configuration in the account details view.
     *
     * @param application_row the AccountApplicationRow of the application to
     * show options for
     */
static void cc_credentials_accounts_page_on_account_details_page_account_options_request (CcCredentialsAccountsPage* self, CcCredentialsAccountApplicationRow* application_row) {
	CcCredentialsAccountApplicationRow _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (application_row != NULL);
	_tmp0_ = *application_row;
	g_signal_emit_by_name (self, "account-options-request", &_tmp0_);
}


/**
     * Tell the main panel to show the options page for an account that
     * required configuration in the account details view.
     *
     * @param plugin the Ap.Plugin of the account to show options for
     */
static void cc_credentials_accounts_page_on_account_details_page_account_edit_options_request (CcCredentialsAccountsPage* self, ApPlugin* plugin) {
	ApPlugin* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = plugin;
	g_signal_emit_by_name (self, "account-edit-options-request", _tmp0_);
}


guint cc_credentials_accounts_page_get_account_details_id (CcCredentialsAccountsPage* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_account_details_id;
	result = _tmp0_;
	return result;
}


static void cc_credentials_accounts_page_set_account_details_id (CcCredentialsAccountsPage* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_account_details_id = _tmp0_;
	g_object_notify ((GObject *) self, "account-details-id");
}


const gchar* cc_credentials_accounts_page_get_application_id (CcCredentialsAccountsPage* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application_id;
	result = _tmp0_;
	return result;
}


static void cc_credentials_accounts_page_set_application_id (CcCredentialsAccountsPage* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_application_id);
	self->priv->_application_id = _tmp1_;
	g_object_notify ((GObject *) self, "application-id");
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static GObject * cc_credentials_accounts_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CcCredentialsAccountsPage * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp9_;
	parent_class = G_OBJECT_CLASS (cc_credentials_accounts_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CC_CREDENTIALS_ACCOUNTS_PAGE (obj);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 6);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp0_ = cc_credentials_accounts_page_create_accounts_tree (self);
	_tmp1_ = _tmp0_;
	gtk_grid_attach ((GtkGrid*) self, _tmp1_, 0, 0, 1, 1);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = cc_credentials_accounts_page_create_accounts_notebook (self);
	_tmp3_ = _tmp2_;
	gtk_grid_attach ((GtkGrid*) self, _tmp3_, 1, 0, 1, 1);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = cc_credentials_accounts_page_create_legal_button (self);
	_tmp5_ = _tmp4_;
	gtk_grid_attach ((GtkGrid*) self, _tmp5_, 0, 1, 2, 1);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->accounts_tree;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	selection = _tmp8_;
	_tmp9_ = selection;
	cc_credentials_accounts_page_on_accounts_selection_changed (self, _tmp9_);
	gtk_widget_set_size_request ((GtkWidget*) self, -1, 400);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (selection);
	return obj;
}


static void cc_credentials_accounts_page_class_init (CcCredentialsAccountsPageClass * klass) {
	cc_credentials_accounts_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsAccountsPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_accounts_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_cc_credentials_accounts_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = cc_credentials_accounts_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_accounts_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNTS_PAGE_ACCOUNT_DETAILS_ID, g_param_spec_uint ("account-details-id", "account-details-id", "account-details-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNTS_PAGE_APPLICATION_ID, g_param_spec_string ("application-id", "application-id", "application-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * Emitted when a new account should be added. Copied from ProvidersPage,
	     * to be emitted again to the main panel.
	     *
	     * @param provider_name the name of the provider for which an account
	     * should be added
	     */
	g_signal_new ("new_account_request", CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	/**
	     * Emitted when an existing account needs to be reauthenticated. Copied
	     * from AccountDetailsPage, to be emitted again to the main panel.
	     *
	     * @param account the account to authenticate
	     */
	g_signal_new ("reauthenticate_account_request", CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ag_account_get_type ());
	/**
	     * Emitted when an application needs to show options. Copied from
	     * AccountDetailsPage, to be emitted again to the main panel.
	     * 
	     * @param application_row the AccountApplicationRow for the application
	     * that needs configuration
	     */
	g_signal_new ("account_options_request", CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_ROW);
	/**
	     * Emitted when an account needs to show options. Copied from
	     * AccountDetailsPage, to be emitted again to the main panel.
	     *
	     * @param plugin the Ap.Plugin for the account that needs configuration
	     */
	g_signal_new ("account_edit_options_request", CC_CREDENTIALS_TYPE_ACCOUNTS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ap_plugin_get_type ());
}


static void cc_credentials_accounts_page_instance_init (CcCredentialsAccountsPage * self) {
	self->priv = CC_CREDENTIALS_ACCOUNTS_PAGE_GET_PRIVATE (self);
}


static void cc_credentials_accounts_page_finalize (GObject* obj) {
	CcCredentialsAccountsPage * self;
	self = CC_CREDENTIALS_ACCOUNTS_PAGE (obj);
	_g_free0 (self->priv->_application_id);
	_g_object_unref0 (self->priv->accounts_tree);
	_g_object_unref0 (self->priv->accounts_store);
	_g_object_unref0 (self->priv->accounts_notebook);
	_g_object_unref0 (self->priv->account_details_page);
	G_OBJECT_CLASS (cc_credentials_accounts_page_parent_class)->finalize (obj);
}


/**
 * Web credentials accounts page. This is for selecting an account, or for
 * showing details of an existing account.
 */
GType cc_credentials_accounts_page_get_type (void) {
	static volatile gsize cc_credentials_accounts_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_accounts_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsAccountsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_accounts_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsAccountsPage), 0, (GInstanceInitFunc) cc_credentials_accounts_page_instance_init, NULL };
		GType cc_credentials_accounts_page_type_id;
		cc_credentials_accounts_page_type_id = g_type_register_static (GTK_TYPE_GRID, "CcCredentialsAccountsPage", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_accounts_page_type_id__volatile, cc_credentials_accounts_page_type_id);
	}
	return cc_credentials_accounts_page_type_id__volatile;
}


static void _vala_cc_credentials_accounts_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountsPage * self;
	self = CC_CREDENTIALS_ACCOUNTS_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNTS_PAGE_ACCOUNT_DETAILS_ID:
		g_value_set_uint (value, cc_credentials_accounts_page_get_account_details_id (self));
		break;
		case CC_CREDENTIALS_ACCOUNTS_PAGE_APPLICATION_ID:
		g_value_set_string (value, cc_credentials_accounts_page_get_application_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_cc_credentials_accounts_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountsPage * self;
	self = CC_CREDENTIALS_ACCOUNTS_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNTS_PAGE_ACCOUNT_DETAILS_ID:
		cc_credentials_accounts_page_set_account_details_id (self, g_value_get_uint (value));
		break;
		case CC_CREDENTIALS_ACCOUNTS_PAGE_APPLICATION_ID:
		cc_credentials_accounts_page_set_application_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



