/* cc-credentials-account-details-page.c generated by valac 0.16.1, the Vala compiler
 * generated from cc-credentials-account-details-page.vala, do not modify */

/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License version 3, as published 
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along 
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      David King <david.king@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libaccount-plugin/account-plugin.h>
#include <libaccounts-glib/accounts-glib.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON (cc_credentials_account_application_button_get_type ())
#define CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON, CcCredentialsAccountApplicationButton))
#define CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON, CcCredentialsAccountApplicationButtonClass))
#define CC_CREDENTIALS_IS_ACCOUNT_APPLICATION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON))
#define CC_CREDENTIALS_IS_ACCOUNT_APPLICATION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON))
#define CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON, CcCredentialsAccountApplicationButtonClass))

typedef struct _CcCredentialsAccountApplicationButton CcCredentialsAccountApplicationButton;
typedef struct _CcCredentialsAccountApplicationButtonClass CcCredentialsAccountApplicationButtonClass;
typedef struct _CcCredentialsAccountApplicationButtonPrivate CcCredentialsAccountApplicationButtonPrivate;

#define CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_ROW (cc_credentials_account_application_row_get_type ())
typedef struct _CcCredentialsAccountApplicationRow CcCredentialsAccountApplicationRow;

#define CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE (cc_credentials_account_details_page_get_type ())
#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, CcCredentialsAccountDetailsPage))
#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, CcCredentialsAccountDetailsPageClass))
#define CC_CREDENTIALS_IS_ACCOUNT_DETAILS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE))
#define CC_CREDENTIALS_IS_ACCOUNT_DETAILS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE))
#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, CcCredentialsAccountDetailsPageClass))

typedef struct _CcCredentialsAccountDetailsPage CcCredentialsAccountDetailsPage;
typedef struct _CcCredentialsAccountDetailsPageClass CcCredentialsAccountDetailsPageClass;
typedef struct _CcCredentialsAccountDetailsPagePrivate CcCredentialsAccountDetailsPagePrivate;

#define CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL (cc_credentials_accounts_model_get_type ())
#define CC_CREDENTIALS_ACCOUNTS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModel))
#define CC_CREDENTIALS_ACCOUNTS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModelClass))
#define CC_CREDENTIALS_IS_ACCOUNTS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL))
#define CC_CREDENTIALS_IS_ACCOUNTS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL))
#define CC_CREDENTIALS_ACCOUNTS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNTS_MODEL, CcCredentialsAccountsModelClass))

typedef struct _CcCredentialsAccountsModel CcCredentialsAccountsModel;
typedef struct _CcCredentialsAccountsModelClass CcCredentialsAccountsModelClass;

#define CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL (cc_credentials_account_applications_model_get_type ())
#define CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL, CcCredentialsAccountApplicationsModel))
#define CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL, CcCredentialsAccountApplicationsModelClass))
#define CC_CREDENTIALS_IS_ACCOUNT_APPLICATIONS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL))
#define CC_CREDENTIALS_IS_ACCOUNT_APPLICATIONS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL))
#define CC_CREDENTIALS_ACCOUNT_APPLICATIONS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATIONS_MODEL, CcCredentialsAccountApplicationsModelClass))

typedef struct _CcCredentialsAccountApplicationsModel CcCredentialsAccountApplicationsModel;
typedef struct _CcCredentialsAccountApplicationsModelClass CcCredentialsAccountApplicationsModelClass;

#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_TYPE_ACTION_PAGE (cc_credentials_account_details_page_action_page_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _CcCredentialsAccountApplicationsModelPrivate CcCredentialsAccountApplicationsModelPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_AgProvider_free0(var) ((var == NULL) ? NULL : (var = (_vala_AgProvider_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define CC_CREDENTIALS_ACCOUNTS_MODEL_TYPE_MODEL_COLUMNS (cc_credentials_accounts_model_model_columns_get_type ())

struct _CcCredentialsAccountApplicationButton {
	GtkButton parent_instance;
	CcCredentialsAccountApplicationButtonPrivate * priv;
};

struct _CcCredentialsAccountApplicationButtonClass {
	GtkButtonClass parent_class;
};

struct _CcCredentialsAccountApplicationRow {
	gchar* name;
	GIcon* icon;
	gchar* description;
	ApApplicationPlugin* plugin;
	GtkWidget* plugin_widget;
};

struct _CcCredentialsAccountApplicationButtonPrivate {
	CcCredentialsAccountApplicationRow _application_row;
};

struct _CcCredentialsAccountDetailsPage {
	GtkGrid parent_instance;
	CcCredentialsAccountDetailsPagePrivate * priv;
};

struct _CcCredentialsAccountDetailsPageClass {
	GtkGridClass parent_class;
};

struct _CcCredentialsAccountDetailsPagePrivate {
	CcCredentialsAccountsModel* accounts_store;
	ApPlugin* plugin;
	GtkInfoBar* infobar;
	GtkLabel* infobar_label;
	GtkNotebook* action_notebook;
	GtkSwitch* enabled_switch;
	GtkButton* grant_button;
	GtkLabel* applications_grid_description;
	GtkScrolledWindow* applications_scroll;
	GtkGrid* applications_grid;
	GtkButtonBox* buttonbox;
	GtkButton* edit_options_button;
	CcCredentialsAccountApplicationsModel* applications_model;
	AgAccount* current_account;
	gboolean edit_options_button_present;
	gboolean needs_attention;
};

typedef enum  {
	CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ENABLED_SWITCH = 0,
	CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ACCESS_BUTTON = 1
} CcCredentialsAccountDetailsPageActionPage;

struct _CcCredentialsAccountApplicationsModel {
	GObject parent_instance;
	CcCredentialsAccountApplicationsModelPrivate * priv;
	GList* application_rows;
};

struct _CcCredentialsAccountApplicationsModelClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	CcCredentialsAccountDetailsPage * self;
	ApPlugin* plugin;
};

typedef enum  {
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID = 0,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT = 1,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_PROVIDER_ICON = 2,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_TRANSLUCENT_PIXBUF = 3,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_DESCRIPTION = 4,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ENABLED = 5,
	CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION = 6
} CcCredentialsAccountsModelModelColumns;


static gpointer cc_credentials_account_application_button_parent_class = NULL;
static gpointer cc_credentials_account_details_page_parent_class = NULL;

GType cc_credentials_account_application_button_get_type (void) G_GNUC_CONST;
GType cc_credentials_account_application_row_get_type (void) G_GNUC_CONST;
CcCredentialsAccountApplicationRow* cc_credentials_account_application_row_dup (const CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_free (CcCredentialsAccountApplicationRow* self);
void cc_credentials_account_application_row_copy (const CcCredentialsAccountApplicationRow* self, CcCredentialsAccountApplicationRow* dest);
void cc_credentials_account_application_row_destroy (CcCredentialsAccountApplicationRow* self);
#define CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON, CcCredentialsAccountApplicationButtonPrivate))
enum  {
	CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_DUMMY_PROPERTY,
	CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_APPLICATION_ROW
};
CcCredentialsAccountApplicationButton* cc_credentials_account_application_button_new (const gchar* label, CcCredentialsAccountApplicationRow* row);
CcCredentialsAccountApplicationButton* cc_credentials_account_application_button_construct (GType object_type, const gchar* label, CcCredentialsAccountApplicationRow* row);
void cc_credentials_account_application_button_get_application_row (CcCredentialsAccountApplicationButton* self, CcCredentialsAccountApplicationRow* result);
static void cc_credentials_account_application_button_set_application_row (CcCredentialsAccountApplicationButton* self, CcCredentialsAccountApplicationRow* value);
static void cc_credentials_account_application_button_finalize (GObject* obj);
static void _vala_cc_credentials_account_application_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_cc_credentials_account_application_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType cc_credentials_account_details_page_get_type (void) G_GNUC_CONST;
GType cc_credentials_accounts_model_get_type (void) G_GNUC_CONST;
GType cc_credentials_account_applications_model_get_type (void) G_GNUC_CONST;
#define CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, CcCredentialsAccountDetailsPagePrivate))
enum  {
	CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_DUMMY_PROPERTY,
	CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACCOUNT_ITER,
	CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACCOUNT
};
static GType cc_credentials_account_details_page_action_page_get_type (void) G_GNUC_UNUSED;
CcCredentialsAccountDetailsPage* cc_credentials_account_details_page_new (CcCredentialsAccountsModel* accounts_store);
CcCredentialsAccountDetailsPage* cc_credentials_account_details_page_construct (GType object_type, CcCredentialsAccountsModel* accounts_store);
static void cc_credentials_account_details_page_on_accounts_store_row_changed (CcCredentialsAccountDetailsPage* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void _cc_credentials_account_details_page_on_accounts_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static GtkWidget* cc_credentials_account_details_page_create_applications_frame (CcCredentialsAccountDetailsPage* self);
static GtkWidget* cc_credentials_account_details_page_create_applications_grid_description (CcCredentialsAccountDetailsPage* self);
static GtkWidget* cc_credentials_account_details_page_create_applications_grid (CcCredentialsAccountDetailsPage* self);
static GtkWidget* cc_credentials_account_details_page_create_remove_account_box (CcCredentialsAccountDetailsPage* self);
static GtkWidget* cc_credentials_account_details_page_create_infobar (CcCredentialsAccountDetailsPage* self);
static void cc_credentials_account_details_page_on_enabled_switch_activated (CcCredentialsAccountDetailsPage* self);
static void _cc_credentials_account_details_page_on_enabled_switch_activated_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void cc_credentials_account_details_page_on_grant_button_clicked (CcCredentialsAccountDetailsPage* self);
static void _cc_credentials_account_details_page_on_grant_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
CcCredentialsAccountApplicationsModel* cc_credentials_account_applications_model_new (void);
CcCredentialsAccountApplicationsModel* cc_credentials_account_applications_model_construct (GType object_type);
static void cc_credentials_account_details_page_populate_applications_grid (CcCredentialsAccountDetailsPage* self);
static void cc_credentials_account_details_page_on_remove_account_clicked (CcCredentialsAccountDetailsPage* self);
static void _cc_credentials_account_details_page_on_remove_account_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void cc_credentials_account_details_page_on_edit_options_button_clicked (CcCredentialsAccountDetailsPage* self);
static void _cc_credentials_account_details_page_on_edit_options_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void cc_credentials_account_details_page_add_application (CcCredentialsAccountDetailsPage* self, CcCredentialsAccountApplicationRow* application);
static void _cc_credentials_account_details_page_add_application_gfunc (gconstpointer data, gpointer self);
static void cc_credentials_account_details_page_on_options_button_clicked (CcCredentialsAccountDetailsPage* self, GtkButton* button);
static void _cc_credentials_account_details_page_on_options_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void cc_credentials_account_details_page_update_needs_attention_ui_state (CcCredentialsAccountDetailsPage* self);
AgManager* cc_credentials_accounts_model_get_manager (CcCredentialsAccountsModel* self);
static void _vala_AgProvider_free (AgProvider* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda2_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void cc_credentials_account_details_page_on_remove_account_finished (CcCredentialsAccountDetailsPage* self, AgAccount* account);
static void ____lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
AgAccount* cc_credentials_account_details_page_get_account (CcCredentialsAccountDetailsPage* self);
static void cc_credentials_account_details_page_on_account_enabled (CcCredentialsAccountDetailsPage* self);
GType cc_credentials_accounts_model_model_columns_get_type (void) G_GNUC_CONST;
void cc_credentials_account_details_page_set_account_iter (CcCredentialsAccountDetailsPage* self, GtkTreeIter* value);
void cc_credentials_account_details_page_set_account (CcCredentialsAccountDetailsPage* self, AgAccount* value);
static void _cc_credentials_account_details_page_on_account_enabled_ag_account_enabled (AgAccount* _sender, const gchar* service, gboolean enabled, gpointer self);
void cc_credentials_account_applications_model_set_account (CcCredentialsAccountApplicationsModel* self, AgAccount* value);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * cc_credentials_account_details_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void cc_credentials_account_details_page_finalize (GObject* obj);
static void _vala_cc_credentials_account_details_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_cc_credentials_account_details_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


CcCredentialsAccountApplicationButton* cc_credentials_account_application_button_construct (GType object_type, const gchar* label, CcCredentialsAccountApplicationRow* row) {
	CcCredentialsAccountApplicationButton * self = NULL;
	const gchar* _tmp0_;
	CcCredentialsAccountApplicationRow _tmp1_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (row != NULL, NULL);
	_tmp0_ = label;
	_tmp1_ = *row;
	self = (CcCredentialsAccountApplicationButton*) g_object_new (object_type, "label", _tmp0_, "application-row", &_tmp1_, NULL);
	return self;
}


CcCredentialsAccountApplicationButton* cc_credentials_account_application_button_new (const gchar* label, CcCredentialsAccountApplicationRow* row) {
	return cc_credentials_account_application_button_construct (CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_BUTTON, label, row);
}


void cc_credentials_account_application_button_get_application_row (CcCredentialsAccountApplicationButton* self, CcCredentialsAccountApplicationRow* result) {
	CcCredentialsAccountApplicationRow _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_application_row;
	*result = _tmp0_;
	return;
}


static void cc_credentials_account_application_button_set_application_row (CcCredentialsAccountApplicationButton* self, CcCredentialsAccountApplicationRow* value) {
	CcCredentialsAccountApplicationRow _tmp0_;
	CcCredentialsAccountApplicationRow _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	cc_credentials_account_application_row_copy (&_tmp0_, &_tmp1_);
	cc_credentials_account_application_row_destroy (&self->priv->_application_row);
	self->priv->_application_row = _tmp1_;
	g_object_notify ((GObject *) self, "application-row");
}


static void cc_credentials_account_application_button_class_init (CcCredentialsAccountApplicationButtonClass * klass) {
	cc_credentials_account_application_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsAccountApplicationButtonPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_account_application_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_cc_credentials_account_application_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_account_application_button_finalize;
	/**
	     * An AccountApplicationRow, for showing the configuration widget from
	     * on_options_button_clicked().
	     * 
	     * This property is necessary because Vala generates incorrect C code if
	     * using g_object_set_data() and g_object_get_data() with a boxed type.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_APPLICATION_ROW, g_param_spec_boxed ("application-row", "application-row", "application-row", CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_ROW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void cc_credentials_account_application_button_instance_init (CcCredentialsAccountApplicationButton * self) {
	self->priv = CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_GET_PRIVATE (self);
}


static void cc_credentials_account_application_button_finalize (GObject* obj) {
	CcCredentialsAccountApplicationButton * self;
	self = CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON (obj);
	cc_credentials_account_application_row_destroy (&self->priv->_application_row);
	G_OBJECT_CLASS (cc_credentials_account_application_button_parent_class)->finalize (obj);
}


/**
 * Button widget, additionally storing an AccountApplicationRow.
 */
GType cc_credentials_account_application_button_get_type (void) {
	static volatile gsize cc_credentials_account_application_button_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_account_application_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsAccountApplicationButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_account_application_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsAccountApplicationButton), 0, (GInstanceInitFunc) cc_credentials_account_application_button_instance_init, NULL };
		GType cc_credentials_account_application_button_type_id;
		cc_credentials_account_application_button_type_id = g_type_register_static (GTK_TYPE_BUTTON, "CcCredentialsAccountApplicationButton", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_account_application_button_type_id__volatile, cc_credentials_account_application_button_type_id);
	}
	return cc_credentials_account_application_button_type_id__volatile;
}


static void _vala_cc_credentials_account_application_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountApplicationButton * self;
	self = CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_APPLICATION_ROW:
		{
			CcCredentialsAccountApplicationRow boxed;
			cc_credentials_account_application_button_get_application_row (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_cc_credentials_account_application_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountApplicationButton * self;
	self = CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNT_APPLICATION_BUTTON_APPLICATION_ROW:
		cc_credentials_account_application_button_set_application_row (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
     * Pages for the action widget notebook.
     *
     * @param ENABLED_SWITCH the page containing the switch to enable or
     * disable the current account
     * @param ACCESS_BUTTON the page containing the button to trigger
     * reauthentication
     */
static GType cc_credentials_account_details_page_action_page_get_type (void) {
	static volatile gsize cc_credentials_account_details_page_action_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_account_details_page_action_page_type_id__volatile)) {
		static const GEnumValue values[] = {{CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ENABLED_SWITCH, "CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ENABLED_SWITCH", "enabled-switch"}, {CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ACCESS_BUTTON, "CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ACCESS_BUTTON", "access-button"}, {0, NULL, NULL}};
		GType cc_credentials_account_details_page_action_page_type_id;
		cc_credentials_account_details_page_action_page_type_id = g_enum_register_static ("CcCredentialsAccountDetailsPageActionPage", values);
		g_once_init_leave (&cc_credentials_account_details_page_action_page_type_id__volatile, cc_credentials_account_details_page_action_page_type_id);
	}
	return cc_credentials_account_details_page_action_page_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _cc_credentials_account_details_page_on_accounts_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	cc_credentials_account_details_page_on_accounts_store_row_changed (self, _sender, path, iter);
}


CcCredentialsAccountDetailsPage* cc_credentials_account_details_page_construct (GType object_type, CcCredentialsAccountsModel* accounts_store) {
	CcCredentialsAccountDetailsPage * self = NULL;
	CcCredentialsAccountsModel* _tmp0_;
	CcCredentialsAccountsModel* _tmp1_;
	CcCredentialsAccountsModel* _tmp2_;
	g_return_val_if_fail (accounts_store != NULL, NULL);
	self = (CcCredentialsAccountDetailsPage*) g_object_new (object_type, NULL);
	_tmp0_ = accounts_store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->accounts_store);
	self->priv->accounts_store = _tmp1_;
	_tmp2_ = accounts_store;
	g_signal_connect_object ((GtkTreeModel*) _tmp2_, "row-changed", (GCallback) _cc_credentials_account_details_page_on_accounts_store_row_changed_gtk_tree_model_row_changed, self, 0);
	return self;
}


CcCredentialsAccountDetailsPage* cc_credentials_account_details_page_new (CcCredentialsAccountsModel* accounts_store) {
	return cc_credentials_account_details_page_construct (CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, accounts_store);
}


/**
     * Create the frame to contain the other widgets for the account and show
     * it.
     *
     * @return a Gtk.Frame for presenting details of the account
     */
static GtkWidget* cc_credentials_account_details_page_create_applications_frame (CcCredentialsAccountDetailsPage* self) {
	GtkWidget* result = NULL;
	GtkEventBox* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkEventBox* eventbox;
	GtkFrame* _tmp2_;
	GtkFrame* _tmp3_;
	GtkFrame* frame;
	GtkFrame* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* grid;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_;
	GtkGrid* _tmp11_;
	GtkWidget* _tmp12_ = NULL;
	GtkWidget* _tmp13_;
	GtkGrid* _tmp14_;
	GtkWidget* _tmp15_ = NULL;
	GtkWidget* _tmp16_;
	GtkFrame* _tmp17_;
	GtkGrid* _tmp18_;
	GtkEventBox* _tmp19_;
	GtkFrame* _tmp20_;
	GdkRGBA color = {0};
	GtkEventBox* _tmp21_;
	GtkStyleContext* _tmp22_ = NULL;
	GtkStyleContext* _tmp23_;
	GtkStyleContext* context;
	GtkStyleContext* _tmp24_;
	GdkRGBA _tmp25_ = {0};
	gboolean _tmp26_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	eventbox = _tmp1_;
	_tmp2_ = (GtkFrame*) gtk_frame_new (NULL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	frame = _tmp3_;
	_tmp4_ = frame;
	gtk_frame_set_shadow_type (_tmp4_, GTK_SHADOW_ETCHED_IN);
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	_tmp6_ = g_object_ref_sink (_tmp5_);
	grid = _tmp6_;
	_tmp7_ = grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp7_, GTK_ORIENTATION_VERTICAL);
	_tmp8_ = grid;
	_tmp9_ = cc_credentials_account_details_page_create_applications_grid_description (self);
	_tmp10_ = _tmp9_;
	gtk_container_add ((GtkContainer*) _tmp8_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = grid;
	_tmp12_ = cc_credentials_account_details_page_create_applications_grid (self);
	_tmp13_ = _tmp12_;
	gtk_container_add ((GtkContainer*) _tmp11_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = grid;
	_tmp15_ = cc_credentials_account_details_page_create_remove_account_box (self);
	_tmp16_ = _tmp15_;
	gtk_container_add ((GtkContainer*) _tmp14_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = frame;
	_tmp18_ = grid;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = eventbox;
	_tmp20_ = frame;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = eventbox;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	context = _tmp23_;
	_tmp24_ = context;
	_tmp26_ = gtk_style_context_lookup_color (_tmp24_, "base_color", &_tmp25_);
	color = _tmp25_;
	if (_tmp26_) {
		GtkEventBox* _tmp27_;
		GdkRGBA _tmp28_;
		_tmp27_ = eventbox;
		_tmp28_ = color;
		gtk_widget_override_background_color ((GtkWidget*) _tmp27_, GTK_STATE_FLAG_NORMAL, &_tmp28_);
	} else {
		g_warning ("cc-credentials-account-details-page.vala:258: Error looking up theme c" \
"olor");
	}
	result = (GtkWidget*) eventbox;
	_g_object_unref0 (context);
	_g_object_unref0 (grid);
	_g_object_unref0 (frame);
	return result;
}


/**
     * Create the infobar for the account and show it.
     *
     * @return a Gtk.InfoBar for presenting details of the account
     */
static void _cc_credentials_account_details_page_on_enabled_switch_activated_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	cc_credentials_account_details_page_on_enabled_switch_activated (self);
}


static void _cc_credentials_account_details_page_on_grant_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	cc_credentials_account_details_page_on_grant_button_clicked (self);
}


static GtkWidget* cc_credentials_account_details_page_create_infobar (CcCredentialsAccountDetailsPage* self) {
	GtkWidget* result = NULL;
	GtkInfoBar* _tmp0_;
	GtkInfoBar* _tmp1_;
	GtkNotebook* _tmp2_;
	GtkNotebook* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkInfoBar* _tmp8_;
	GtkWidget* _tmp9_ = NULL;
	GtkContainer* _tmp10_;
	GtkContainer* content_area;
	GtkInfoBar* _tmp11_;
	GtkWidget* _tmp12_ = NULL;
	GtkContainer* _tmp13_;
	GtkContainer* action_area;
	GtkNotebook* _tmp14_;
	GtkNotebook* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkInfoBar* _tmp20_;
	GtkInfoBar* _tmp21_;
	GtkNotebook* _tmp22_;
	GtkSwitch* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkNotebook* _tmp27_;
	GtkButton* _tmp28_;
	GtkNotebook* _tmp29_;
	GtkSwitch* _tmp30_;
	GtkButton* _tmp31_;
	GtkInfoBar* _tmp39_;
	GtkInfoBar* _tmp40_;
	GtkInfoBar* _tmp41_;
	GtkWidget* _tmp42_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkInfoBar*) gtk_info_bar_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->infobar);
	self->priv->infobar = _tmp1_;
	_tmp2_ = (GtkNotebook*) gtk_notebook_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->action_notebook);
	self->priv->action_notebook = _tmp3_;
	_tmp4_ = (GtkSwitch*) gtk_switch_new ();
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->enabled_switch);
	self->priv->enabled_switch = _tmp5_;
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->infobar_label);
	self->priv->infobar_label = _tmp7_;
	_tmp8_ = self->priv->infobar;
	_tmp9_ = gtk_info_bar_get_content_area (_tmp8_);
	_tmp10_ = _g_object_ref0 (GTK_IS_CONTAINER (_tmp9_) ? ((GtkContainer*) _tmp9_) : NULL);
	content_area = _tmp10_;
	_tmp11_ = self->priv->infobar;
	_tmp12_ = gtk_info_bar_get_action_area (_tmp11_);
	_tmp13_ = _g_object_ref0 (GTK_IS_CONTAINER (_tmp12_) ? ((GtkContainer*) _tmp12_) : NULL);
	action_area = _tmp13_;
	_tmp14_ = self->priv->action_notebook;
	gtk_notebook_set_show_tabs (_tmp14_, FALSE);
	_tmp15_ = self->priv->action_notebook;
	gtk_notebook_set_show_border (_tmp15_, FALSE);
	gtk_widget_set_halign ((GtkWidget*) action_area, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) action_area, GTK_ALIGN_CENTER);
	_tmp16_ = self->priv->infobar_label;
	gtk_label_set_use_markup (_tmp16_, TRUE);
	_tmp17_ = self->priv->infobar_label;
	g_object_set (_tmp17_, "wrap", TRUE, NULL);
	_tmp18_ = self->priv->infobar_label;
	g_object_set ((GtkMisc*) _tmp18_, "xalign", 0.0f, NULL);
	_tmp19_ = self->priv->infobar_label;
	gtk_container_add (content_area, (GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->infobar;
	gtk_info_bar_set_message_type (_tmp20_, GTK_MESSAGE_INFO);
	_tmp21_ = self->priv->infobar;
	gtk_widget_set_name ((GtkWidget*) _tmp21_, "account-details-infobar");
	_tmp22_ = self->priv->action_notebook;
	_tmp23_ = self->priv->enabled_switch;
	gtk_notebook_append_page (_tmp22_, (GtkWidget*) _tmp23_, NULL);
	_tmp24_ = _ ("Grant access");
	_tmp25_ = (GtkButton*) gtk_button_new_with_label (_tmp24_);
	_tmp26_ = g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->grant_button);
	self->priv->grant_button = _tmp26_;
	_tmp27_ = self->priv->action_notebook;
	_tmp28_ = self->priv->grant_button;
	gtk_notebook_append_page (_tmp27_, (GtkWidget*) _tmp28_, NULL);
	_tmp29_ = self->priv->action_notebook;
	gtk_container_add (action_area, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->enabled_switch;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::active", (GCallback) _cc_credentials_account_details_page_on_enabled_switch_activated_g_object_notify, self, 0);
	_tmp31_ = self->priv->grant_button;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) _cc_credentials_account_details_page_on_grant_button_clicked_gtk_button_clicked, self, 0);
	{
		GtkCssProvider* _tmp32_;
		GtkCssProvider* css;
		GtkInfoBar* _tmp33_;
		GtkStyleContext* _tmp34_ = NULL;
		GtkStyleContext* _tmp35_;
		GtkStyleContext* context;
		GtkStyleContext* _tmp36_;
		_tmp32_ = gtk_css_provider_new ();
		css = _tmp32_;
		gtk_css_provider_load_from_data (css, "@define-color warning_bg_color rgb (222, 222, 222); @define-color info" \
"_bg_color @warning_bg_color; GtkInfoBar#account-details-infobar { colo" \
"r: @fg_color; -GtkInfoBar-action-area-border: 10 }", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (css);
			goto __catch0_g_error;
		}
		_tmp33_ = self->priv->infobar;
		_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) _tmp33_);
		_tmp35_ = _g_object_ref0 (_tmp34_);
		context = _tmp35_;
		_tmp36_ = context;
		gtk_style_context_add_provider (_tmp36_, (GtkStyleProvider*) css, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (context);
		_g_object_unref0 (css);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp37_;
		const gchar* _tmp38_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp37_ = err;
		_tmp38_ = _tmp37_->message;
		g_warning ("cc-credentials-account-details-page.vala:308: Error processing CSS the" \
"me override: %s", _tmp38_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (action_area);
		_g_object_unref0 (content_area);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp39_ = self->priv->infobar;
	gtk_widget_set_size_request ((GtkWidget*) _tmp39_, -1, 48);
	_tmp40_ = self->priv->infobar;
	gtk_widget_show_all ((GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->infobar;
	_tmp42_ = _g_object_ref0 ((GtkWidget*) _tmp41_);
	result = _tmp42_;
	_g_object_unref0 (action_area);
	_g_object_unref0 (content_area);
	return result;
}


/**
     * Create a description to place above the applications grid.
     *
     * @return a Gtk.Label for a description of the applications grid
     */
static GtkWidget* cc_credentials_account_details_page_create_applications_grid_description (CcCredentialsAccountDetailsPage* self) {
	GtkWidget* result = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkWidget* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->applications_grid_description);
	self->priv->applications_grid_description = _tmp1_;
	_tmp2_ = self->priv->applications_grid_description;
	g_object_set ((GtkWidget*) _tmp2_, "margin", 6, NULL);
	_tmp3_ = self->priv->applications_grid_description;
	g_object_set ((GtkMisc*) _tmp3_, "xalign", 0.0f, NULL);
	_tmp4_ = self->priv->applications_grid_description;
	gtk_label_set_line_wrap (_tmp4_, TRUE);
	_tmp5_ = self->priv->applications_grid_description;
	gtk_widget_set_size_request ((GtkWidget*) _tmp5_, 414, -1);
	_tmp6_ = self->priv->applications_grid_description;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->applications_grid_description;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	result = _tmp8_;
	return result;
}


/**
     * Create the grid with a list of applications using the current account.
     *
     * @return a Gtk.Grid containing a list of applications
     */
static GtkWidget* cc_credentials_account_details_page_create_applications_grid (CcCredentialsAccountDetailsPage* self) {
	GtkWidget* result = NULL;
	CcCredentialsAccountApplicationsModel* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GdkRGBA color = {0};
	GtkScrolledWindow* _tmp4_;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_;
	GtkWidget* viewport;
	GtkWidget* _tmp7_;
	GtkStyleContext* _tmp8_ = NULL;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* context;
	GtkStyleContext* _tmp10_;
	GdkRGBA _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	GtkScrolledWindow* _tmp15_;
	GtkWidget* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cc_credentials_account_applications_model_new ();
	_g_object_unref0 (self->priv->applications_model);
	self->priv->applications_model = _tmp0_;
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->applications_scroll);
	self->priv->applications_scroll = _tmp2_;
	cc_credentials_account_details_page_populate_applications_grid (self);
	_tmp3_ = self->priv->applications_scroll;
	g_object_set (_tmp3_, "window-placement-set", TRUE, NULL);
	_tmp4_ = self->priv->applications_scroll;
	_tmp5_ = gtk_bin_get_child ((GtkBin*) _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	viewport = _tmp6_;
	_tmp7_ = viewport;
	_tmp8_ = gtk_widget_get_style_context (_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	context = _tmp9_;
	_tmp10_ = context;
	_tmp12_ = gtk_style_context_lookup_color (_tmp10_, "base_color", &_tmp11_);
	color = _tmp11_;
	if (_tmp12_) {
		GtkWidget* _tmp13_;
		GdkRGBA _tmp14_;
		_tmp13_ = viewport;
		_tmp14_ = color;
		gtk_widget_override_background_color (_tmp13_, GTK_STATE_FLAG_NORMAL, &_tmp14_);
	} else {
		g_warning ("cc-credentials-account-details-page.vala:362: Error looking up theme c" \
"olor");
	}
	_tmp15_ = self->priv->applications_scroll;
	_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
	result = _tmp16_;
	_g_object_unref0 (context);
	_g_object_unref0 (viewport);
	return result;
}


/**
     * Create a button box for the account editing buttons.
     *
     * @return a Gtk.ButtonBox for the remove or edit account buttons
     */
static void _cc_credentials_account_details_page_on_remove_account_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	cc_credentials_account_details_page_on_remove_account_clicked (self);
}


static void _cc_credentials_account_details_page_on_edit_options_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	cc_credentials_account_details_page_on_edit_options_button_clicked (self);
}


static GtkWidget* cc_credentials_account_details_page_create_remove_account_box (CcCredentialsAccountDetailsPage* self) {
	GtkWidget* result = NULL;
	GtkButtonBox* _tmp0_;
	GtkButtonBox* _tmp1_;
	GtkButtonBox* _tmp2_;
	GtkButtonBox* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* remove_button;
	const gchar* _tmp7_ = NULL;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButtonBox* _tmp11_;
	GtkButtonBox* _tmp12_;
	GtkButton* _tmp13_;
	GtkButtonBox* _tmp14_;
	GtkWidget* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->buttonbox);
	self->priv->buttonbox = _tmp1_;
	_tmp2_ = self->priv->buttonbox;
	gtk_button_box_set_layout (_tmp2_, GTK_BUTTONBOX_END);
	_tmp3_ = self->priv->buttonbox;
	g_object_set ((GtkWidget*) _tmp3_, "margin", 6, NULL);
	_tmp4_ = _ ("Remove account");
	_tmp5_ = (GtkButton*) gtk_button_new_with_label (_tmp4_);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	remove_button = _tmp6_;
	_tmp7_ = _ ("Edit options");
	_tmp8_ = (GtkButton*) gtk_button_new_with_label (_tmp7_);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->edit_options_button);
	self->priv->edit_options_button = _tmp9_;
	g_signal_connect_object (remove_button, "clicked", (GCallback) _cc_credentials_account_details_page_on_remove_account_clicked_gtk_button_clicked, self, 0);
	_tmp10_ = self->priv->edit_options_button;
	g_signal_connect_object (_tmp10_, "clicked", (GCallback) _cc_credentials_account_details_page_on_edit_options_button_clicked_gtk_button_clicked, self, 0);
	_tmp11_ = self->priv->buttonbox;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) remove_button);
	_tmp12_ = self->priv->buttonbox;
	gtk_widget_show_all ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->edit_options_button;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->buttonbox;
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
	result = _tmp15_;
	_g_object_unref0 (remove_button);
	return result;
}


/**
     * Populate the grid of applications from the model. Instantiates
     * applications_grid.
     */
static void _cc_credentials_account_details_page_add_application_gfunc (gconstpointer data, gpointer self) {
	cc_credentials_account_details_page_add_application (self, data);
}


static void cc_credentials_account_details_page_populate_applications_grid (CcCredentialsAccountDetailsPage* self) {
	GtkGrid* _tmp0_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	CcCredentialsAccountApplicationsModel* _tmp8_;
	GList* _tmp9_;
	GList* applications;
	GtkScrolledWindow* _tmp10_;
	GtkGrid* _tmp11_;
	GtkScrolledWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applications_grid;
	if (_tmp0_ != NULL) {
		GtkGrid* _tmp1_;
		_tmp1_ = self->priv->applications_grid;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->applications_grid);
	self->priv->applications_grid = _tmp3_;
	_tmp4_ = self->priv->applications_grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 6);
	_tmp5_ = self->priv->applications_grid;
	gtk_grid_set_column_spacing (_tmp5_, 12);
	_tmp6_ = self->priv->applications_grid;
	gtk_grid_set_row_spacing (_tmp6_, 12);
	_tmp7_ = self->priv->applications_grid;
	g_object_set ((GtkWidget*) _tmp7_, "expand", TRUE, NULL);
	_tmp8_ = self->priv->applications_model;
	_tmp9_ = _tmp8_->application_rows;
	applications = _tmp9_;
	g_list_foreach (applications, _cc_credentials_account_details_page_add_application_gfunc, self);
	_tmp10_ = self->priv->applications_scroll;
	_tmp11_ = self->priv->applications_grid;
	gtk_scrolled_window_add_with_viewport (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->applications_scroll;
	gtk_widget_show_all ((GtkWidget*) _tmp12_);
}


/**
     * Add an individual application from the model to the applications grid.
     *
     * @param application the description of the application
     */
static void _cc_credentials_account_details_page_on_options_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	cc_credentials_account_details_page_on_options_button_clicked (self, _sender);
}


static void cc_credentials_account_details_page_add_application (CcCredentialsAccountDetailsPage* self, CcCredentialsAccountApplicationRow* application) {
	GtkGrid* _tmp0_;
	CcCredentialsAccountApplicationRow* _tmp1_;
	GIcon* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* image;
	GtkImage* _tmp5_;
	GtkGrid* _tmp6_;
	GtkImage* _tmp7_;
	CcCredentialsAccountApplicationRow* _tmp8_;
	const gchar* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* label;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkGrid* _tmp15_;
	GtkLabel* _tmp16_;
	GtkImage* _tmp17_;
	CcCredentialsAccountApplicationRow* _tmp18_;
	GtkWidget* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applications_grid;
	gtk_grid_insert_row (_tmp0_, 0);
	_tmp1_ = application;
	_tmp2_ = (*_tmp1_).icon;
	_tmp3_ = (GtkImage*) gtk_image_new_from_gicon (_tmp2_, GTK_ICON_SIZE_DND);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	image = _tmp4_;
	_tmp5_ = image;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp5_, 4);
	_tmp6_ = self->priv->applications_grid;
	_tmp7_ = image;
	gtk_grid_attach (_tmp6_, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
	_tmp8_ = application;
	_tmp9_ = (*_tmp8_).description;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	_tmp11_ = g_object_ref_sink (_tmp10_);
	label = _tmp11_;
	_tmp12_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = label;
	gtk_label_set_use_markup (_tmp13_, TRUE);
	_tmp14_ = label;
	g_object_set ((GtkMisc*) _tmp14_, "xalign", 0.0f, NULL);
	_tmp15_ = self->priv->applications_grid;
	_tmp16_ = label;
	_tmp17_ = image;
	gtk_grid_attach_next_to (_tmp15_, (GtkWidget*) _tmp16_, (GtkWidget*) _tmp17_, GTK_POS_RIGHT, 1, 1);
	_tmp18_ = application;
	_tmp19_ = (*_tmp18_).plugin_widget;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_ = NULL;
		CcCredentialsAccountApplicationRow* _tmp21_;
		CcCredentialsAccountApplicationRow _tmp22_;
		CcCredentialsAccountApplicationButton* _tmp23_;
		CcCredentialsAccountApplicationButton* _tmp24_;
		CcCredentialsAccountApplicationButton* button;
		GtkGrid* _tmp25_;
		CcCredentialsAccountApplicationButton* _tmp26_;
		GtkLabel* _tmp27_;
		CcCredentialsAccountApplicationButton* _tmp28_;
		_tmp20_ = _ ("Options");
		_tmp21_ = application;
		_tmp22_ = *_tmp21_;
		_tmp23_ = cc_credentials_account_application_button_new (_tmp20_, &_tmp22_);
		_tmp24_ = g_object_ref_sink (_tmp23_);
		button = _tmp24_;
		_tmp25_ = self->priv->applications_grid;
		_tmp26_ = button;
		_tmp27_ = label;
		gtk_grid_attach_next_to (_tmp25_, (GtkWidget*) _tmp26_, (GtkWidget*) _tmp27_, GTK_POS_RIGHT, 1, 1);
		_tmp28_ = button;
		g_signal_connect_object ((GtkButton*) _tmp28_, "clicked", (GCallback) _cc_credentials_account_details_page_on_options_button_clicked_gtk_button_clicked, self, 0);
		_g_object_unref0 (button);
	}
	_g_object_unref0 (label);
	_g_object_unref0 (image);
}


/**
     * Update the state of the action notebook and infobar label when the
     * needs-attention state changes.
     */
static void _vala_AgProvider_free (AgProvider* self) {
	g_boxed_free (ag_provider_get_type (), self);
}


static void cc_credentials_account_details_page_update_needs_attention_ui_state (CcCredentialsAccountDetailsPage* self) {
	CcCredentialsAccountsModel* _tmp0_;
	AgManager* _tmp1_;
	AgManager* _tmp2_;
	AgManager* _tmp3_;
	AgManager* manager;
	AgManager* _tmp4_;
	AgAccount* _tmp5_;
	const gchar* _tmp6_ = NULL;
	AgProvider* _tmp7_ = NULL;
	AgProvider* provider;
	AgProvider* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* provider_display_name;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->accounts_store;
	_tmp1_ = cc_credentials_accounts_model_get_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	manager = _tmp3_;
	_tmp4_ = manager;
	_tmp5_ = self->priv->current_account;
	_tmp6_ = ag_account_get_provider_name (_tmp5_);
	_tmp7_ = ag_manager_get_provider (_tmp4_, _tmp6_);
	provider = _tmp7_;
	_tmp8_ = provider;
	_tmp9_ = ag_provider_get_display_name (_tmp8_);
	_tmp10_ = g_strdup (_tmp9_);
	provider_display_name = _tmp10_;
	_tmp11_ = self->priv->needs_attention;
	if (_tmp11_) {
		GtkLabel* _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GtkInfoBar* _tmp17_;
		GtkNotebook* _tmp18_;
		_tmp12_ = self->priv->infobar_label;
		_tmp13_ = _ ("Please authorize Ubuntu to access your %s account:");
		_tmp14_ = provider_display_name;
		_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_label (_tmp12_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = self->priv->infobar;
		gtk_info_bar_set_message_type (_tmp17_, GTK_MESSAGE_WARNING);
		_tmp18_ = self->priv->action_notebook;
		g_object_set (_tmp18_, "page", (gint) CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ACCESS_BUTTON, NULL);
	} else {
		GtkLabel* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		AgAccount* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GtkInfoBar* _tmp33_;
		GtkNotebook* _tmp34_;
		_tmp19_ = self->priv->infobar_label;
		_tmp20_ = provider_display_name;
		_tmp21_ = g_strconcat ("<b>", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, "</b>\n", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "<small><span foreground=\"#555555\">", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->current_account;
		_tmp28_ = ag_account_get_display_name (_tmp27_);
		_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp30_, "</span></small>", NULL);
		_tmp32_ = _tmp31_;
		gtk_label_set_label (_tmp19_, _tmp32_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp33_ = self->priv->infobar;
		gtk_info_bar_set_message_type (_tmp33_, GTK_MESSAGE_INFO);
		_tmp34_ = self->priv->action_notebook;
		g_object_set (_tmp34_, "page", (gint) CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACTION_PAGE_ENABLED_SWITCH, NULL);
	}
	_g_free0 (provider_display_name);
	__vala_AgProvider_free0 (provider);
	_g_object_unref0 (manager);
}


/**
     * Handle the remove account button being clicked. The removal is
     * asynchronous, and on_remove_account_finished() is called when the
     * operation is complete.
     *
     * @see AccountDetailsPage.on_remove_account_finished
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CcCredentialsAccountDetailsPage * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->plugin);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda2_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	CcCredentialsAccountDetailsPage * self;
	AgAccount* _tmp4_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		ApPlugin* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data1_->plugin;
		_tmp1_ = res;
		ap_plugin_delete_account_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_critical ("cc-credentials-account-details-page.vala:540: Error deleting account: " \
"%s", _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->current_account;
	cc_credentials_account_details_page_on_remove_account_finished (self, _tmp4_);
}


static void ____lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda2_ (self, source_object, res);
	block1_data_unref (self);
}


static void cc_credentials_account_details_page_on_remove_account_clicked (CcCredentialsAccountDetailsPage* self) {
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* confirmation;
	CcCredentialsAccountsModel* _tmp3_;
	AgManager* _tmp4_;
	AgManager* _tmp5_;
	AgManager* _tmp6_;
	AgManager* manager;
	AgManager* _tmp7_;
	AgAccount* _tmp8_;
	const gchar* _tmp9_ = NULL;
	AgProvider* _tmp10_ = NULL;
	AgProvider* provider;
	AgProvider* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* provider_display_name;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* secondary_text;
	GtkMessageDialog* _tmp26_;
	const gchar* _tmp27_;
	GtkMessageDialog* _tmp28_;
	GtkMessageDialog* _tmp29_;
	gint _tmp30_ = 0;
	gint response;
	gint _tmp31_;
	GtkMessageDialog* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Are you sure that you wish to remove this Ubuntu Web Account?");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp0_);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	confirmation = _tmp2_;
	_tmp3_ = self->priv->accounts_store;
	_tmp4_ = cc_credentials_accounts_model_get_manager (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	manager = _tmp6_;
	_tmp7_ = manager;
	_tmp8_ = self->priv->current_account;
	_tmp9_ = ag_account_get_provider_name (_tmp8_);
	_tmp10_ = ag_manager_get_provider (_tmp7_, _tmp9_);
	provider = _tmp10_;
	_tmp11_ = provider;
	_tmp12_ = ag_provider_get_display_name (_tmp11_);
	_tmp13_ = g_strdup (_tmp12_);
	provider_display_name = _tmp13_;
	_tmp14_ = _ ("The Web Account which manages the integration of %s with your applicat" \
"ions will be removed.");
	_tmp15_ = provider_display_name;
	_tmp16_ = g_strdup_printf (_tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, "\n\n", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = _ ("Your online %s account is not affected.");
	_tmp21_ = provider_display_name;
	_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	secondary_text = _tmp25_;
	_tmp26_ = confirmation;
	_tmp27_ = secondary_text;
	g_object_set (_tmp26_, "secondary-text", _tmp27_, NULL);
	_tmp28_ = confirmation;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp28_, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_REMOVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp29_ = confirmation;
	_tmp30_ = gtk_dialog_run ((GtkDialog*) _tmp29_);
	response = _tmp30_;
	_tmp31_ = response;
	switch (_tmp31_) {
		case GTK_RESPONSE_ACCEPT:
		{
			Block1Data* _data1_;
			AgAccount* _tmp32_;
			ApPlugin* _tmp33_ = NULL;
			ApPlugin* _tmp34_;
			ApPlugin* _tmp37_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp32_ = self->priv->current_account;
			_tmp33_ = ap_client_load_plugin (_tmp32_);
			_data1_->plugin = _tmp33_;
			_tmp34_ = _data1_->plugin;
			if (_tmp34_ == NULL) {
				AgAccount* _tmp35_;
				const gchar* _tmp36_ = NULL;
				_tmp35_ = self->priv->current_account;
				_tmp36_ = ag_account_get_provider_name (_tmp35_);
				g_warning ("cc-credentials-account-details-page.vala:527: No valid plugin found fo" \
"r provider %s", _tmp36_);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				break;
			}
			_tmp37_ = _data1_->plugin;
			ap_plugin_delete_account (_tmp37_, ____lambda2__gasync_ready_callback, block1_data_ref (_data1_));
			block1_data_unref (_data1_);
			_data1_ = NULL;
			break;
		}
		case GTK_RESPONSE_CANCEL:
		case GTK_RESPONSE_DELETE_EVENT:
		{
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp38_ = confirmation;
	gtk_widget_destroy ((GtkWidget*) _tmp38_);
	_g_free0 (secondary_text);
	_g_free0 (provider_display_name);
	__vala_AgProvider_free0 (provider);
	_g_object_unref0 (manager);
	_g_object_unref0 (confirmation);
}


/**
     * Handle the completion of the asynchronous account removal operation.
     *
     * @param account the account that was removed
     */
static void cc_credentials_account_details_page_on_remove_account_finished (CcCredentialsAccountDetailsPage* self, AgAccount* account) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
}


/**
     * Handle the account enabled switch being activated. Change the current
     * account to be the same state as the switch.
     */
static void cc_credentials_account_details_page_on_enabled_switch_activated (CcCredentialsAccountDetailsPage* self) {
	AgAccount* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_account;
	_tmp1_ = self->priv->enabled_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	ag_account_set_enabled (_tmp0_, _tmp3_);
	{
		AgAccount* _tmp4_;
		_tmp4_ = self->priv->current_account;
		ag_account_store_blocking (_tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == AG_ACCOUNTS_ERROR) {
				goto __catch2_ag_accounts_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_ag_accounts_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = err;
		if (g_error_matches (_tmp5_, AG_ACCOUNTS_ERROR, AG_ACCOUNTS_ERROR_DELETED)) {
			AgAccount* _tmp6_;
			AgAccount* _tmp7_;
			guint _tmp8_ = 0U;
			guint _tmp9_;
			_tmp6_ = cc_credentials_account_details_page_get_account (self);
			_tmp7_ = _tmp6_;
			g_object_get (_tmp7_, "id", &_tmp8_, NULL);
			_tmp9_ = _tmp8_;
			g_debug ("cc-credentials-account-details-page.vala:584: Enabled state changed du" \
"ring deletion of account ID: %u", _tmp9_);
			_g_error_free0 (err);
			return;
		} else {
			AgAccount* _tmp10_;
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			_tmp10_ = self->priv->current_account;
			_tmp11_ = ag_account_get_display_name (_tmp10_);
			_tmp12_ = err;
			_tmp13_ = _tmp12_->message;
			g_critical ("cc-credentials-account-details-page.vala:590: Error changing enabled s" \
"tate of account: %s\n" \
"Message: %s", _tmp11_, _tmp13_);
		}
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * Handle the reauthentication button being clicked.
     */
static void cc_credentials_account_details_page_on_grant_button_clicked (CcCredentialsAccountDetailsPage* self) {
	AgAccount* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_account;
	g_signal_emit_by_name (self, "reauthenticate-account-request", _tmp0_);
}


/**
     * Handle the account being enabled or disabled from elsewhere, and update
     * the switch state accordingly.
     */
static void cc_credentials_account_details_page_on_account_enabled (CcCredentialsAccountDetailsPage* self) {
	AgAccount* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean enabled;
	gboolean _tmp2_;
	GtkSwitch* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_account;
	_tmp1_ = ag_account_get_enabled (_tmp0_);
	enabled = _tmp1_;
	_tmp2_ = enabled;
	_tmp3_ = self->priv->enabled_switch;
	_tmp4_ = gtk_switch_get_active (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ != _tmp5_) {
		GtkSwitch* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = self->priv->enabled_switch;
		_tmp7_ = enabled;
		gtk_switch_set_active (_tmp6_, _tmp7_);
	}
}


/**
     * Handle the options button for an application being clicked.
     *
     * @param button the AccountApplicationButton that emitted the clicked
     * signal. The account application plugin is a property on the button.
     */
static void cc_credentials_account_details_page_on_options_button_clicked (CcCredentialsAccountDetailsPage* self, GtkButton* button) {
	GtkButton* _tmp0_;
	CcCredentialsAccountApplicationButton* _tmp1_;
	CcCredentialsAccountApplicationButton* app_button;
	CcCredentialsAccountApplicationButton* _tmp2_;
	CcCredentialsAccountApplicationRow _tmp3_;
	CcCredentialsAccountApplicationRow _tmp4_;
	CcCredentialsAccountApplicationRow _tmp5_ = {0};
	CcCredentialsAccountApplicationRow application_row;
	CcCredentialsAccountApplicationRow _tmp6_;
	GtkWidget* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = _g_object_ref0 (CC_CREDENTIALS_IS_ACCOUNT_APPLICATION_BUTTON (_tmp0_) ? ((CcCredentialsAccountApplicationButton*) _tmp0_) : NULL);
	app_button = _tmp1_;
	_tmp2_ = app_button;
	cc_credentials_account_application_button_get_application_row (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	cc_credentials_account_application_row_copy (&_tmp4_, &_tmp5_);
	application_row = _tmp5_;
	_tmp6_ = application_row;
	_tmp7_ = _tmp6_.plugin_widget;
	if (_tmp7_ != NULL) {
		CcCredentialsAccountApplicationRow _tmp8_;
		_tmp8_ = application_row;
		g_signal_emit_by_name (self, "account-options-request", &_tmp8_);
	}
	cc_credentials_account_application_row_destroy (&application_row);
	_g_object_unref0 (app_button);
}


/**
     * Handle the edit options button for an account being clicked.
     */
static void cc_credentials_account_details_page_on_edit_options_button_clicked (CcCredentialsAccountDetailsPage* self) {
	ApPlugin* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->plugin;
	g_signal_emit_by_name (self, "account-edit-options-request", _tmp0_);
}


/**
     * Handle a row in the accounts model being changed.
     *
     * Check to see whether the current account was changed, and then check to
     * see if the needs-attention flag is set, and update the action notebook
     * state accordingly.
     *
     * @param model the Gtk.TreeModel
     * @param path the Gtk.TreePath of the changed row
     * @param iter the Gtk.TreeIter of the changed row
     */
static void cc_credentials_account_details_page_on_accounts_store_row_changed (CcCredentialsAccountDetailsPage* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	AgAccountId account_id = 0U;
	gboolean changed_account_needs_attention = FALSE;
	CcCredentialsAccountsModel* _tmp0_;
	GtkTreeIter _tmp1_;
	AgAccount* _tmp2_;
	guint _tmp3_ = 0U;
	guint _tmp4_;
	AgAccountId _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->accounts_store;
	_tmp1_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID, &account_id, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION, &changed_account_needs_attention, -1, -1);
	_tmp2_ = self->priv->current_account;
	g_object_get (_tmp2_, "id", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = account_id;
	if (_tmp4_ == ((guint) _tmp5_)) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = changed_account_needs_attention;
		_tmp7_ = self->priv->needs_attention;
		if (_tmp6_ != _tmp7_) {
			gboolean _tmp8_;
			_tmp8_ = changed_account_needs_attention;
			self->priv->needs_attention = _tmp8_;
			cc_credentials_account_details_page_update_needs_attention_ui_state (self);
		}
	}
}


void cc_credentials_account_details_page_set_account_iter (CcCredentialsAccountDetailsPage* self, GtkTreeIter* value) {
	AgAccountId account_id = 0U;
	gboolean iter_needs_attention = FALSE;
	CcCredentialsAccountsModel* _tmp0_;
	GtkTreeIter _tmp1_;
	CcCredentialsAccountsModel* _tmp2_;
	AgManager* _tmp3_;
	AgManager* _tmp4_;
	AgAccountId _tmp5_;
	AgAccount* _tmp6_ = NULL;
	AgAccount* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->accounts_store;
	_tmp1_ = *value;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_ACCOUNT_ID, &account_id, CC_CREDENTIALS_ACCOUNTS_MODEL_MODEL_COLUMNS_NEEDS_ATTENTION, &iter_needs_attention, -1, -1);
	_tmp2_ = self->priv->accounts_store;
	_tmp3_ = cc_credentials_accounts_model_get_manager (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = account_id;
	_tmp6_ = ag_manager_get_account (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	cc_credentials_account_details_page_set_account (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = iter_needs_attention;
	_tmp9_ = self->priv->needs_attention;
	if (_tmp8_ != _tmp9_) {
		gboolean _tmp10_;
		_tmp10_ = iter_needs_attention;
		self->priv->needs_attention = _tmp10_;
		cc_credentials_account_details_page_update_needs_attention_ui_state (self);
	}
	g_object_notify ((GObject *) self, "account-iter");
}


AgAccount* cc_credentials_account_details_page_get_account (CcCredentialsAccountDetailsPage* self) {
	AgAccount* result;
	AgAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_account;
	result = _tmp0_;
	return result;
}


static void _cc_credentials_account_details_page_on_account_enabled_ag_account_enabled (AgAccount* _sender, const gchar* service, gboolean enabled, gpointer self) {
	cc_credentials_account_details_page_on_account_enabled (self);
}


void cc_credentials_account_details_page_set_account (CcCredentialsAccountDetailsPage* self, AgAccount* value) {
	gboolean _tmp0_ = FALSE;
	AgAccount* _tmp1_;
	gboolean _tmp8_;
	AgAccount* _tmp9_;
	AgAccount* _tmp10_;
	AgAccount* _tmp11_;
	ApPlugin* _tmp12_ = NULL;
	ApPlugin* _tmp13_;
	GtkSwitch* _tmp31_;
	AgAccount* _tmp32_;
	gboolean _tmp33_ = FALSE;
	AgAccount* _tmp34_;
	CcCredentialsAccountsModel* _tmp35_;
	AgManager* _tmp36_;
	AgManager* _tmp37_;
	AgManager* _tmp38_;
	AgManager* manager;
	AgManager* _tmp39_;
	AgAccount* _tmp40_;
	const gchar* _tmp41_ = NULL;
	AgProvider* _tmp42_ = NULL;
	AgProvider* provider;
	AgProvider* _tmp43_;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gchar* provider_display_name;
	CcCredentialsAccountApplicationsModel* _tmp46_;
	AgAccount* _tmp47_;
	CcCredentialsAccountApplicationsModel* _tmp48_;
	GList* _tmp49_;
	GList* applications;
	GList* _tmp50_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->current_account;
	if (_tmp1_ != NULL) {
		AgAccount* _tmp2_;
		guint _tmp3_ = 0U;
		guint _tmp4_;
		AgAccount* _tmp5_;
		guint _tmp6_ = 0U;
		guint _tmp7_;
		_tmp2_ = self->priv->current_account;
		g_object_get (_tmp2_, "id", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = value;
		g_object_get (_tmp5_, "id", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp4_ == _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		return;
	}
	_tmp9_ = value;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->priv->current_account);
	self->priv->current_account = _tmp10_;
	_tmp11_ = value;
	_tmp12_ = ap_client_load_plugin (_tmp11_);
	_g_object_unref0 (self->priv->plugin);
	self->priv->plugin = _tmp12_;
	_tmp13_ = self->priv->plugin;
	if (_tmp13_ == NULL) {
		AgAccount* _tmp14_;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = value;
		_tmp15_ = ag_account_get_provider_name (_tmp14_);
		g_warning ("cc-credentials-account-details-page.vala:145: No valid plugin found fo" \
"r provider %s", _tmp15_);
	} else {
		ApPlugin* _tmp16_;
		GtkWidget* _tmp17_ = NULL;
		GtkWidget* _tmp18_;
		GtkWidget* widget;
		GtkWidget* _tmp19_;
		_tmp16_ = self->priv->plugin;
		_tmp17_ = ap_plugin_build_widget (_tmp16_);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		widget = _tmp18_;
		_tmp19_ = widget;
		if (_tmp19_ == NULL) {
			AgAccount* _tmp20_;
			const gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			_tmp20_ = value;
			_tmp21_ = ag_account_get_provider_name (_tmp20_);
			g_debug ("cc-credentials-account-details-page.vala:153: No configuration widget " \
"for provider %s", _tmp21_);
			_tmp22_ = self->priv->edit_options_button_present;
			if (_tmp22_) {
				GtkButtonBox* _tmp23_;
				GtkButton* _tmp24_;
				_tmp23_ = self->priv->buttonbox;
				_tmp24_ = self->priv->edit_options_button;
				gtk_container_remove ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
				self->priv->edit_options_button_present = FALSE;
			}
		} else {
			gboolean _tmp25_;
			GtkWidget* _tmp30_;
			_tmp25_ = self->priv->edit_options_button_present;
			if (!_tmp25_) {
				GtkButtonBox* _tmp26_;
				GtkButton* _tmp27_;
				GtkButtonBox* _tmp28_;
				GtkButton* _tmp29_;
				_tmp26_ = self->priv->buttonbox;
				_tmp27_ = self->priv->edit_options_button;
				gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
				_tmp28_ = self->priv->buttonbox;
				_tmp29_ = self->priv->edit_options_button;
				gtk_button_box_set_child_secondary (_tmp28_, (GtkWidget*) _tmp29_, TRUE);
				self->priv->edit_options_button_present = TRUE;
			}
			_tmp30_ = widget;
			gtk_widget_destroy (_tmp30_);
		}
		_g_object_unref0 (widget);
	}
	_tmp31_ = self->priv->enabled_switch;
	_tmp32_ = value;
	_tmp33_ = ag_account_get_enabled (_tmp32_);
	gtk_switch_set_active (_tmp31_, _tmp33_);
	_tmp34_ = value;
	g_signal_connect_object (_tmp34_, "enabled", (GCallback) _cc_credentials_account_details_page_on_account_enabled_ag_account_enabled, self, 0);
	_tmp35_ = self->priv->accounts_store;
	_tmp36_ = cc_credentials_accounts_model_get_manager (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _g_object_ref0 (_tmp37_);
	manager = _tmp38_;
	_tmp39_ = manager;
	_tmp40_ = value;
	_tmp41_ = ag_account_get_provider_name (_tmp40_);
	_tmp42_ = ag_manager_get_provider (_tmp39_, _tmp41_);
	provider = _tmp42_;
	_tmp43_ = provider;
	_tmp44_ = ag_provider_get_display_name (_tmp43_);
	_tmp45_ = g_strdup (_tmp44_);
	provider_display_name = _tmp45_;
	cc_credentials_account_details_page_update_needs_attention_ui_state (self);
	_tmp46_ = self->priv->applications_model;
	_tmp47_ = value;
	cc_credentials_account_applications_model_set_account (_tmp46_, _tmp47_);
	_tmp48_ = self->priv->applications_model;
	_tmp49_ = _tmp48_->application_rows;
	applications = _tmp49_;
	_tmp50_ = applications;
	if (_tmp50_ == NULL) {
		GtkLabel* _tmp51_;
		const gchar* _tmp52_ = NULL;
		const gchar* _tmp53_;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		_tmp51_ = self->priv->applications_grid_description;
		_tmp52_ = _ ("There are currently no applications installed which integrate with you" \
"r %s account.");
		_tmp53_ = provider_display_name;
		_tmp54_ = g_strdup_printf (_tmp52_, _tmp53_);
		_tmp55_ = _tmp54_;
		gtk_label_set_label (_tmp51_, _tmp55_);
		_g_free0 (_tmp55_);
	} else {
		GtkLabel* _tmp56_;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp58_;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_;
		_tmp56_ = self->priv->applications_grid_description;
		_tmp57_ = _ ("The following applications integrate with your %s account:");
		_tmp58_ = provider_display_name;
		_tmp59_ = g_strdup_printf (_tmp57_, _tmp58_);
		_tmp60_ = _tmp59_;
		gtk_label_set_label (_tmp56_, _tmp60_);
		_g_free0 (_tmp60_);
	}
	cc_credentials_account_details_page_populate_applications_grid (self);
	_g_free0 (provider_display_name);
	__vala_AgProvider_free0 (provider);
	_g_object_unref0 (manager);
	g_object_notify ((GObject *) self, "account");
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static GObject * cc_credentials_account_details_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CcCredentialsAccountDetailsPage * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_;
	parent_class = G_OBJECT_CLASS (cc_credentials_account_details_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE (obj);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	_tmp0_ = cc_credentials_account_details_page_create_infobar (self);
	_tmp1_ = _tmp0_;
	gtk_container_add ((GtkContainer*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = cc_credentials_account_details_page_create_applications_frame (self);
	_tmp3_ = _tmp2_;
	gtk_container_add ((GtkContainer*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	gtk_widget_show ((GtkWidget*) self);
	return obj;
}


static void cc_credentials_account_details_page_class_init (CcCredentialsAccountDetailsPageClass * klass) {
	cc_credentials_account_details_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CcCredentialsAccountDetailsPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_cc_credentials_account_details_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_cc_credentials_account_details_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = cc_credentials_account_details_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = cc_credentials_account_details_page_finalize;
	/**
	     * Index of the selected account in the model.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACCOUNT_ITER, g_param_spec_boxed ("account-iter", "account-iter", "account-iter", GTK_TYPE_TREE_ITER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	/**
	     * Keep the UI state consistent when the account is changed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACCOUNT, g_param_spec_object ("account", "account", "account", ag_account_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Signal the preferences widget to switch to the authentication page.
	     */
	g_signal_new ("reauthenticate_account_request", CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ag_account_get_type ());
	/**
	     * Signal the preferences widget to switch to the options page.
	     */
	g_signal_new ("account_options_request", CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, CC_CREDENTIALS_TYPE_ACCOUNT_APPLICATION_ROW);
	/**
	     * Signal the preferences widget to switch to the options page and show the
	     * edit options widget.
	     */
	g_signal_new ("account_edit_options_request", CC_CREDENTIALS_TYPE_ACCOUNT_DETAILS_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ap_plugin_get_type ());
}


static void cc_credentials_account_details_page_instance_init (CcCredentialsAccountDetailsPage * self) {
	self->priv = CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_GET_PRIVATE (self);
	self->priv->edit_options_button_present = FALSE;
	self->priv->needs_attention = FALSE;
}


static void cc_credentials_account_details_page_finalize (GObject* obj) {
	CcCredentialsAccountDetailsPage * self;
	self = CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE (obj);
	_g_object_unref0 (self->priv->accounts_store);
	_g_object_unref0 (self->priv->plugin);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->infobar_label);
	_g_object_unref0 (self->priv->action_notebook);
	_g_object_unref0 (self->priv->enabled_switch);
	_g_object_unref0 (self->priv->grant_button);
	_g_object_unref0 (self->priv->applications_grid_description);
	_g_object_unref0 (self->priv->applications_scroll);
	_g_object_unref0 (self->priv->applications_grid);
	_g_object_unref0 (self->priv->buttonbox);
	_g_object_unref0 (self->priv->edit_options_button);
	_g_object_unref0 (self->priv->applications_model);
	_g_object_unref0 (self->priv->current_account);
	G_OBJECT_CLASS (cc_credentials_account_details_page_parent_class)->finalize (obj);
}


/**
 * Web credentials account details widget. Used inside a notebook page to list
 * the applications that use an account, provide a switch to enable or disable
 * the account and to provide a button for removing the account.
 */
GType cc_credentials_account_details_page_get_type (void) {
	static volatile gsize cc_credentials_account_details_page_type_id__volatile = 0;
	if (g_once_init_enter (&cc_credentials_account_details_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CcCredentialsAccountDetailsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cc_credentials_account_details_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CcCredentialsAccountDetailsPage), 0, (GInstanceInitFunc) cc_credentials_account_details_page_instance_init, NULL };
		GType cc_credentials_account_details_page_type_id;
		cc_credentials_account_details_page_type_id = g_type_register_static (GTK_TYPE_GRID, "CcCredentialsAccountDetailsPage", &g_define_type_info, 0);
		g_once_init_leave (&cc_credentials_account_details_page_type_id__volatile, cc_credentials_account_details_page_type_id);
	}
	return cc_credentials_account_details_page_type_id__volatile;
}


static void _vala_cc_credentials_account_details_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountDetailsPage * self;
	self = CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACCOUNT:
		g_value_set_object (value, cc_credentials_account_details_page_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_cc_credentials_account_details_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CcCredentialsAccountDetailsPage * self;
	self = CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE (object);
	switch (property_id) {
		case CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACCOUNT_ITER:
		cc_credentials_account_details_page_set_account_iter (self, g_value_get_boxed (value));
		break;
		case CC_CREDENTIALS_ACCOUNT_DETAILS_PAGE_ACCOUNT:
		cc_credentials_account_details_page_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



