#include <glib-object.h>

#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_stringlist.h>
#include <gmyth/gmyth_common.h>

#include "common.h"

static          gboolean
test_string_list()
{
    gboolean        ret = TRUE;
    gchar          *str_list_param = NULL;
    GString        *str = NULL;

    GMythStringList *str_list = gmyth_string_list_new();

    gmyth_string_list_append_int(str_list, 54);

    gmyth_string_list_append_uint64(str_list, 39282L);

    gmyth_string_list_append_int64(str_list, -123445L);

    gmyth_string_list_append_char_array(str_list, "lloollabbee");

    gmyth_string_list_append_string(str_list, g_string_new("minarrai"));

    if (gmyth_string_list_length(str_list) != 5) {
        ret = FALSE;
        goto done;
    }

    if (gmyth_string_list_get_int(str_list, 0) != 54) {
        ret = FALSE;
        goto done;
    }

    if (gmyth_string_list_get_uint64(str_list, 1) != 39282L) {
        ret = FALSE;
        goto done;
    }


    if (gmyth_string_list_get_int64(str_list, 2) != -123445L) {
        ret = FALSE;
        goto done;
    }


    str_list_param = gmyth_string_list_get_char_array(str_list, 3);

    if (strcmp(str_list_param, "lloollabbee") != 0) {
        ret = FALSE;
        goto done;
    }


    str = gmyth_string_list_get_string(str_list, 4);

    if (g_string_equal(str, g_string_new("minarrai"))) {
        ret = FALSE;
        goto done;
    }

  done:
    if (str_list != NULL)
        g_object_unref(str_list);

    if (str_list_param != NULL)
        g_free(str_list_param);

    if (str != NULL)
        g_string_free(str, TRUE);

    return ret;
}

int
main(int args, const char **argv)
{

    g_type_init();
    g_thread_init(NULL);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    g_debug("******** Testing main string list function ***********\n");
    if (!test_string_list()) {
        return -1;
    }

    return (0);

}
