/**
 * GMyth Library
 *
 * @file gmyth/gmyth_tvchain.h
 * 
 * @brief <p> This component contains functions for creating and accessing
 * the tvchain functions for live tv playback.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Hallyson Luiz de Morais Melo <hallyson.melo@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIVETVCHAIN_H_
#define LIVETVCHAIN_H_

#include <glib-object.h>
#include <time.h>

#include "gmyth_common.h"
#include "gmyth_backendinfo.h"

G_BEGIN_DECLS
#define GMYTH_TVCHAIN_TYPE               (gmyth_tvchain_get_type ())
#define GMYTH_TVCHAIN(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_TVCHAIN_TYPE, GMythTVChain))
#define GMYTH_TVCHAIN_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_TVCHAIN_TYPE, GMythTVChainClass))
#define IS_GMYTH_TVCHAIN(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_TVCHAIN_TYPE))
#define IS_GMYTH_TVCHAIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_TVCHAIN_TYPE))
#define GMYTH_TVCHAIN_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_TVCHAIN_TYPE, GMythTVChainClass))
typedef struct _GMythTVChain GMythTVChain;
typedef struct _GMythTVChainClass GMythTVChainClass;


struct LiveTVChainEntry {
    GString        *chanid;

    GTimeVal       *starttime;
    GTimeVal       *endtime;

    gboolean        discontinuity;  // if true, can't play smooth from
    // last entry
    GString        *hostprefix;
    GString        *cardtype;
    GString        *channum;
    GString        *inputname;
};


struct _GMythTVChainClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
    /*
     * no one for now 
     */
};

struct _GMythTVChain {
    GObject         parent;

    GString        *tvchain_id;
    GList          *tvchain_list;

    GTimeVal       *cur_startts;
    GString        *cur_chanid;
    gint            cur_pos;

    GMythBackendInfo *backend_info;

    GMutex         *mutex;
};

GType           gmyth_tvchain_get_type(void);

GMythTVChain   *gmyth_tvchain_new();

gboolean        gmyth_tvchain_initialize(GMythTVChain * tvchain,
                                         GMythBackendInfo * backend_info);
gboolean        gmyth_tvchain_reload_all(GMythTVChain * tvchain);
GString        *gmyth_tvchain_get_id(GMythTVChain * tvchain);
gint            gmyth_tvchain_program_is_at(GMythTVChain * tvchain,
                                            GString * chanid,
                                            GTimeVal * startts);

struct LiveTVChainEntry *gmyth_tvchain_get_entry_at(GMythTVChain * tvchain,
                                                    gint index);

GMythProgramInfo *gmyth_tvchain_entry_to_program(GMythTVChain * tvchain, struct LiveTVChainEntry
                                                 *entry);
GMythProgramInfo *gmyth_tvchain_get_program_at(GMythTVChain * tvchain,
                                               gint index);

GList          *gmyth_tvchain_get_program_info_from_channel(GMythTVChain *
                                                            tvchain,
                                                            const gchar *
                                                            channel);

GList          *gmyth_tvchain_get_program_info_list(GMythTVChain *
                                                    tvchain);

G_END_DECLS
#endif                          /* LIVETVCHAIN_H_ */
