/**
 * GMyth Library
 *
 * @file gmyth/gmyth_http.h
 * 
 * @brief <p> GMythHttp library provides a wrapper to access
 * data from the database using http+xml
 *
 * Copyright (C) 2007 INdT - Instituto Nokia de Tecnologia.
 * @author Artur Duque de Souza <artur.souza@indt.org.br>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_HTTP_H__
#define __GMYTH_HTTP_H__

#include <glib-object.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <glib.h>
#include <glib/gprintf.h>

#include "gmyth_backendinfo.h"
#include "gmyth_util.h"
#include "gmyth_recprofile.h"

#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

G_BEGIN_DECLS
#define MYTH_PORT_STATUS 6544
#define JOB_UNKNOWN   0x0000
#define JOB_QUEUED    0x0001
#define JOB_PENDING   0x0002
#define JOB_STARTING  0x0003
#define JOB_RUNNING   0x0004
#define JOB_STOPPING  0x0005
#define JOB_PAUSED    0x0006
#define JOB_RETRY     0x0007
#define JOB_ERRORING  0x0008
#define JOB_ABORTING  0x0009
    // JOB_DONE is a mask to indicate the job is done
    // whatever the status is
#define JOB_DONE      0x0100
#define JOB_FINISHED  0x0110
#define JOB_ABORTED   0x0120
#define JOB_ERRORED   0x0130
#define JOB_CANCELLED 0x0140
typedef struct _GMythRecorded_Recording GMythRecorded_Recording;
typedef struct _GMythRecorded_Channel GMythRecorded_Channel;
typedef struct _GMythRecorded_Program GMythRecorded_Program;
typedef struct _GMythRecorded GMythRecorded;
typedef struct _GMythProgram GMythProgram;
typedef struct _GMythChannel GMythChannel;
typedef struct _GMythEpg GMythEpg;
typedef struct _MemoryStruct MemoryStruct;

struct _MemoryStruct {
    char           *memory;
    size_t          size;
};

struct _GMythProgram {
    gchar          *title;
    gchar          *subtitle;
    gchar          *catType;
    gchar          *category;
    gint            repeat;
    GTimeVal       *startTime;
    GTimeVal       *endTime;
};

struct _GMythChannel {
    gchar          *channelName;
    gchar          *chanNum;
    gint            chanId;
    gint            callSign;
    GSList         *programList;
};

struct _GMythEpg {
    gint            startChanId;
    gint            endChanId;
    gchar          *version;
    gint            protoVer;
    gint            totalCount;
    gint            numOfChannels;
    GTimeVal       *asOf;
    GTimeVal       *startTime;
    GTimeVal       *endTime;
    gint            details;
    GSList         *channelList;
};


struct _GMythRecorded_Recording {
    gint            dupInType;
    gint            dupMethod;
    gchar          *playGroup;
    gchar          *recGroup;
    gchar          *recProfile;
    gint            recPriority;
    gint            recStatus;
    gint            encoderId;
    gint            recordId;
    gint            recType;
    GTimeVal       *recStartTs;
    GTimeVal       *recEndTs;
};


struct _GMythRecorded_Channel {
    gchar          *chanFilters;
    gchar          *channelName;
    gint            chanNum;
    gint            sourceId;
    gint            commFree;
    gint            inputId;
    gint            chanId;
    gint            callSign;
};


struct _GMythRecorded_Program {
    gint            programFlags;
    gchar          *title;
    gint            programId;
    gchar          *catType;
    gchar          *category;
    gint            seriesId;
    GTimeVal       *startTime;
    GTimeVal       *endTime;
    GTimeVal       *airdate;    // ?
    GTimeVal       *lastModified;
    gchar          *subTitle;
    gint            stars;
    gint            repeat;
    gint            fileSize;
    gchar          *hostname;
    GMythRecorded_Channel channel;
    GMythRecorded_Recording recording;
};

struct _GMythRecorded {
    gchar          *version;
    gint            protoVer;
    gint            totalCount;
    GTimeVal       *asOf;
    GSList         *programList;
};


gint            gmyth_http_retrieve_job_status(GMythBackendInfo *
                                               backend_info, gint chanid,
                                               GTimeVal * start);

gchar          *gmyth_http_retrieve_setting(GMythBackendInfo *
                                            backend_info, gchar * key,
                                            gchar * hostname);

GMythEpg        gmyth_http_retrieve_epg(GMythBackendInfo * backend_info,
                                        GTimeVal * StartTime,
                                        GTimeVal * EndTime,
                                        gint StartChanId,
                                        gint NumOfChannels,
                                        gchar * Details);

GMythRecorded   gmyth_http_retrieve_recorded(GMythBackendInfo *
                                             backend_info);

GSList         *gmyth_http_retrieve_rec_profiles(GMythBackendInfo *
                                                 backend_info,
                                                 gchar * groupname);

gint            gmyth_http_create_rec_profile(GMythBackendInfo *
                                              backend_info,
                                              GMythRecProfile * profile);

gint            gmyth_http_del_rec_profile(GMythBackendInfo * backend_info,
                                           gint id);

MemoryStruct    gmyth_http_request(GMythBackendInfo * backend_info,
                                   GString * command);

G_END_DECLS
#endif                          /* __GMYTH_HTTP_H__ */
