/* 
 * File: message.h
 * Author: Jason Short
 * Project: GGZCards Server
 * Date: 06/20/2001
 * Desc: Functions and data for messaging system
 * $Id: score.h 8458 2006-08-02 06:50:51Z jdorje $
 *
 * Right now GGZCards uses a super-generic "messaging" system.  Text
 * messages are generated by the server and sent to the client for
 * direct display.  This makes i18n basically impossible.  It also
 * makes really cool client displays basically impossible.  However,
 * it makes it really easy to add new games - you don't even have to
 * change the client!
 *
 * A more complicated alternate messaging system is in planning.
 *
 * Copyright (C) 2001-2002 Brent Hendricks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-130
 */

#ifndef __SCORE_H
#define __SCORE_H

/** @brief Return the team's score. */
int get_team_score(team_t t);

/** @brief Return the player's score. */
int get_player_score(player_t p);

/** @brief Zero all scores. */
void clear_score(team_t t);

/** @brief Change the score for this team. */
void change_score(team_t t, int scorediff);

/** @brief Change the full scores for this team. */
void change_score_full(team_t t, score_data_t scorediff);

/* initialized the "cumulative scores" tracking */
void init_cumulative_scores(void);

/* updates the "cumulative scores", and sends new one */
void update_cumulative_scores(void);

#endif
