<?

	/**
	 * Check the build environment for missing
	 * dependencies.
	 */
	function checkEnvironment() {
		// binaries to use
		$binaries = array(
			array('convert', 'Imagemagick convert'),
			array('montage', 'Imagemagick montage'),
			array('composite', 'Imagemagick composite'),
			array('inkscape', 'Inkscape Vector Illustrator'),
			array('jar', 'Java Archive generator'),
			array('file', 'File type identifier')
		);
		
		// check for each binary
		foreach($binaries as $binary) {
			$bin = $binary[0];
			$name = $binary[1];
		
			$which = system("which $bin");
			if($which) {
				echo "$name: $which\n";
			} else {
				echo "Fatal error: no binary for $name '$bin'\n";
				die(1);				
			}				
		}
			
	}

?>