/*
 * Copyright (c) 2003, 2007-11 Matteo Frigo
 * Copyright (c) 2003, 2007-11 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 28 11:03:40 EDT 2012 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2cdft.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 32 -dit -name hc2cfdft2_32 -include hc2cf.h */

/*
 * This function contains 552 FP additions, 414 FP multiplications,
 * (or, 300 additions, 162 multiplications, 252 fused multiply/add),
 * 196 stack variables, 8 constants, and 128 memory accesses
 */
#include "hc2cf.h"

static void hc2cfdft2_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 8, MAKE_VOLATILE_STRIDE(rs)) {
	       E Tax, TaA;
	       {
		    E T1, Th, T2, T5, Ti, Ty, T1t, T3, Tb, Tj, TY, TK, Tl, T4, Tk;
		    T1 = W[0];
		    Th = W[4];
		    T2 = W[2];
		    T5 = W[3];
		    Ti = W[6];
		    Ty = T1 * Th;
		    T1t = T2 * Th;
		    T3 = T1 * T2;
		    Tb = T1 * T5;
		    Tj = Th * Ti;
		    TY = T2 * Ti;
		    TK = T1 * Ti;
		    Tl = W[7];
		    T4 = W[1];
		    Tk = W[5];
		    {
			 E T3j, T7Z, T5b, T93, T6B, T8V, T4d, T8J, T8r, T6e, T8l, T1T, T8C, T54, T8i;
			 E T5O, T94, T31, T8K, T6w, T8U, T3Y, T80, T5g, T8B, T69, T8h, T1s, T8q, T4T;
			 E T8k, T5J, Tx, T8a, T5y, T8d, T4s, T5Y, T8v, T8E, T2k, T82, T6l, T3z, T83;
			 E T5m, T8X, T8O, T2F, T86, T6q, T3M, T85, T5r, T8Y, T8R, TW, T8e, T8x, T4B;
			 E T5D, T8b, T63, T8w;
			 {
			      E TL, T2l, T1c, Tc, T1a, T6, Tm, T2v, Tz, T2q, TR, Ts, T2A, TF, T1H;
			      E T1g, T1d, T1F, T34, T3F, T3B, T32, T3w, T3s, T4p, T4l, T2f, T29, T4K, T4S;
			      E T5G, T5I;
			      {
				   E TZ, T2R, T2H, T15, T2W, T2M, T4I, T4E, T3V, T3S, T4Q, T4M, T1n, T1h, T4X;
				   E T53, T5L, T5N, T5d, T5f;
				   {
					E T1u, T1A, T51, T4Y, T28, T25, T44, T40, T1O, T1I, T3b, T35, T4b, T3i, T45;
					E T38, T39, T58, T49, T3e, T41;
					{
					     E T3g, T3h, T36, T37, TQ;
					     T3g = Ip[0];
					     TZ = FNMS(T5, Tl, TY);
					     T2R = FMA(T5, Tl, TY);
					     TQ = T1 * Tl;
					     {
						  E T14, Tr, T1z, TE;
						  T14 = T2 * Tl;
						  Tr = Th * Tl;
						  TL = FMA(T4, Tl, TK);
						  T2l = FNMS(T4, Tl, TK);
						  T1c = FMA(T4, T2, Tb);
						  Tc = FNMS(T4, T2, Tb);
						  T1a = FNMS(T4, T5, T3);
						  T6 = FMA(T4, T5, T3);
						  Tm = FMA(Tk, Tl, Tj);
						  T2v = FNMS(T5, Tk, T1t);
						  T1u = FMA(T5, Tk, T1t);
						  Tz = FNMS(T4, Tk, Ty);
						  T2H = FMA(T4, Tk, Ty);
						  T1z = T2 * Tk;
						  TE = T1 * Tk;
						  T2q = FMA(T4, Ti, TQ);
						  TR = FNMS(T4, Ti, TQ);
						  T15 = FMA(T5, Ti, T14);
						  T2W = FNMS(T5, Ti, T14);
						  Ts = FNMS(Tk, Ti, Tr);
						  {
						       E T1f, T4H, T4D, T1b;
						       T1f = T1a * Tk;
						       T4H = T1a * Tl;
						       T4D = T1a * Ti;
						       T1b = T1a * Th;
						       {
							    E T27, T3E, T3A, T24;
							    T27 = T6 * Tk;
							    T3E = T6 * Tl;
							    T3A = T6 * Ti;
							    T24 = T6 * Th;
							    {
								 E T3v, T3r, T4P, T4L;
								 T3v = T1u * Tl;
								 T3r = T1u * Ti;
								 T4P = T2v * Tl;
								 T4L = T2v * Ti;
								 {
								      E T4o, T4k, T43, T3Z;
								      T4o = T2H * Tl;
								      T4k = T2H * Ti;
								      T43 = Tz * Tl;
								      T3Z = Tz * Ti;
								      T1A = FNMS(T5, Th, T1z);
								      T2A = FMA(T5, Th, T1z);
								      T2M = FNMS(T4, Th, TE);
								      TF = FMA(T4, Th, TE);
								      T1H = FNMS(T1c, Th, T1f);
								      T1g = FMA(T1c, Th, T1f);
								      T51 = FNMS(T1c, Ti, T4H);
								      T4I = FMA(T1c, Ti, T4H);
								      T4Y = FMA(T1c, Tl, T4D);
								      T4E = FNMS(T1c, Tl, T4D);
								      T1d = FNMS(T1c, Tk, T1b);
								      T1F = FMA(T1c, Tk, T1b);
								      T34 = FMA(Tc, Th, T27);
								      T28 = FNMS(Tc, Th, T27);
								      T3V = FNMS(Tc, Ti, T3E);
								      T3F = FMA(Tc, Ti, T3E);
								      T3S = FMA(Tc, Tl, T3A);
								      T3B = FNMS(Tc, Tl, T3A);
								      T25 = FMA(Tc, Tk, T24);
								      T32 = FNMS(Tc, Tk, T24);
								      T3w = FNMS(T1A, Ti, T3v);
								      T3s = FMA(T1A, Tl, T3r);
								      T4Q = FNMS(T2A, Ti, T4P);
								      T4M = FMA(T2A, Tl, T4L);
								      T4p = FNMS(T2M, Ti, T4o);
								      T4l = FMA(T2M, Tl, T4k);
								      T44 = FNMS(TF, Ti, T43);
								      T40 = FMA(TF, Tl, T3Z);
								      {
									   E T1m, T1e, T1N, T1G;
									   T1m = T1d * Tl;
									   T1e = T1d * Ti;
									   T1N = T1F * Tl;
									   T1G = T1F * Ti;
									   {
										E T2e, T26, T3a, T33;
										T2e = T25 * Tl;
										T26 = T25 * Ti;
										T3a = T32 * Tl;
										T33 = T32 * Ti;
										T1n = FNMS(T1g, Ti, T1m);
										T1h = FMA(T1g, Tl, T1e);
										T1O = FNMS(T1H, Ti, T1N);
										T1I = FMA(T1H, Tl, T1G);
										T2f = FNMS(T28, Ti, T2e);
										T29 = FMA(T28, Tl, T26);
										T3b = FNMS(T34, Ti, T3a);
										T35 = FMA(T34, Tl, T33);
										T3h = Im[0];
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					     T36 = Ip[WS(rs, 8)];
					     T37 = Im[WS(rs, 8)];
					     {
						  E T47, T48, T3c, T3d;
						  T47 = Rm[0];
						  T4b = T3g + T3h;
						  T3i = T3g - T3h;
						  T45 = T36 + T37;
						  T38 = T36 - T37;
						  T48 = Rp[0];
						  T3c = Rp[WS(rs, 8)];
						  T3d = Rm[WS(rs, 8)];
						  T39 = T35 * T38;
						  T58 = T48 + T47;
						  T49 = T47 - T48;
						  T3e = T3c + T3d;
						  T41 = T3d - T3c;
					     }
					}
					{
					     E T4W, T1x, T1y, T6a, T4U, T1D, T1P, T4V, T5K, T52, T1L, T1Q;
					     {
						  E T1B, T1C, T1J, T1K;
						  {
						       E T1v, T6A, T4c, T5a, T6y, T46, T1w, T6z, T4a;
						       T1v = Ip[WS(rs, 3)];
						       T6z = T4 * T49;
						       T4a = T1 * T49;
						       {
							    E T3f, T59, T6x, T42;
							    T3f = FNMS(T3b, T3e, T39);
							    T59 = T35 * T3e;
							    T6x = T44 * T41;
							    T42 = T40 * T41;
							    T6A = FMA(T1, T4b, T6z);
							    T4c = FNMS(T4, T4b, T4a);
							    T3j = T3f + T3i;
							    T7Z = T3i - T3f;
							    T5a = FMA(T3b, T38, T59);
							    T6y = FMA(T40, T45, T6x);
							    T46 = FNMS(T44, T45, T42);
							    T1w = Im[WS(rs, 3)];
						       }
						       T5b = T58 + T5a;
						       T93 = T58 - T5a;
						       T6B = T6y + T6A;
						       T8V = T6A - T6y;
						       T4d = T46 + T4c;
						       T8J = T4c - T46;
						       T4W = T1v + T1w;
						       T1x = T1v - T1w;
						  }
						  T1B = Rp[WS(rs, 3)];
						  T1C = Rm[WS(rs, 3)];
						  T1y = T1u * T1x;
						  T6a = T25 * T4W;
						  T1J = Ip[WS(rs, 11)];
						  T4U = T1B - T1C;
						  T1D = T1B + T1C;
						  T1K = Im[WS(rs, 11)];
						  T1P = Rp[WS(rs, 11)];
						  T4V = T25 * T4U;
						  T5K = T1u * T1D;
						  T52 = T1J + T1K;
						  T1L = T1J - T1K;
						  T1Q = Rm[WS(rs, 11)];
					     }
					     {
						  E T1E, T6c, T1M, T4Z, T1R, T6b;
						  T1E = FNMS(T1A, T1D, T1y);
						  T6c = T4Y * T52;
						  T1M = T1I * T1L;
						  T4Z = T1P - T1Q;
						  T1R = T1P + T1Q;
						  T6b = FNMS(T28, T4U, T6a);
						  {
						       E T5M, T6d, T50, T1S;
						       T4X = FMA(T28, T4W, T4V);
						       T6d = FNMS(T51, T4Z, T6c);
						       T50 = T4Y * T4Z;
						       T1S = FNMS(T1O, T1R, T1M);
						       T5M = T1I * T1R;
						       T8r = T6d - T6b;
						       T6e = T6b + T6d;
						       T8l = T1E - T1S;
						       T1T = T1E + T1S;
						       T53 = FMA(T51, T52, T50);
						       T5L = FMA(T1A, T1x, T5K);
						       T5N = FMA(T1O, T1L, T5M);
						  }
					     }
					}
				   }
				   {
					E T3Q, T2K, T2P, T2L, T6s, T3P, T5c, T3W, T2U, T2X, T2Y, T2V;
					{
					     E T2I, T2J, T2N, T2O, T2S, T3O, T2T;
					     T2I = Ip[WS(rs, 4)];
					     T8C = T53 - T4X;
					     T54 = T4X + T53;
					     T8i = T5L - T5N;
					     T5O = T5L + T5N;
					     T2J = Im[WS(rs, 4)];
					     T2N = Rp[WS(rs, 4)];
					     T2O = Rm[WS(rs, 4)];
					     T2S = Ip[WS(rs, 12)];
					     T3Q = T2I + T2J;
					     T2K = T2I - T2J;
					     T3O = T2O - T2N;
					     T2P = T2N + T2O;
					     T2T = Im[WS(rs, 12)];
					     T2L = T2H * T2K;
					     T6s = Tk * T3O;
					     T3P = Th * T3O;
					     T5c = T2H * T2P;
					     T3W = T2S + T2T;
					     T2U = T2S - T2T;
					     T2X = Rp[WS(rs, 12)];
					     T2Y = Rm[WS(rs, 12)];
					     T2V = T2R * T2U;
					}
					{
					     E T2Q, T6t, T3T, T2Z, T3R, T6u, T3U;
					     T2Q = FNMS(T2M, T2P, T2L);
					     T6t = FMA(Th, T3Q, T6s);
					     T3T = T2Y - T2X;
					     T2Z = T2X + T2Y;
					     T3R = FNMS(Tk, T3Q, T3P);
					     T5d = FMA(T2M, T2K, T5c);
					     T6u = T3V * T3T;
					     T3U = T3S * T3T;
					     {
						  E T30, T5e, T6v, T3X;
						  T30 = FNMS(T2W, T2Z, T2V);
						  T5e = T2R * T2Z;
						  T6v = FMA(T3S, T3W, T6u);
						  T3X = FNMS(T3V, T3W, T3U);
						  T94 = T2Q - T30;
						  T31 = T2Q + T30;
						  T8K = T6t - T6v;
						  T6w = T6t + T6v;
						  T8U = T3R - T3X;
						  T3Y = T3R + T3X;
						  T5f = FMA(T2W, T2U, T5e);
					     }
					}
				   }
				   {
					E T4J, T12, T65, T13, T4F, T18, T1o, T4G, T5F, T4R, T1k, T1p;
					{
					     E T16, T17, T10, T11, T1i, T1j;
					     T10 = Ip[WS(rs, 15)];
					     T11 = Im[WS(rs, 15)];
					     T16 = Rp[WS(rs, 15)];
					     T80 = T5d - T5f;
					     T5g = T5d + T5f;
					     T4J = T10 + T11;
					     T12 = T10 - T11;
					     T17 = Rm[WS(rs, 15)];
					     T1i = Ip[WS(rs, 7)];
					     T65 = T4E * T4J;
					     T13 = TZ * T12;
					     T4F = T16 - T17;
					     T18 = T16 + T17;
					     T1j = Im[WS(rs, 7)];
					     T1o = Rp[WS(rs, 7)];
					     T4G = T4E * T4F;
					     T5F = TZ * T18;
					     T4R = T1i + T1j;
					     T1k = T1i - T1j;
					     T1p = Rm[WS(rs, 7)];
					}
					{
					     E T19, T67, T1l, T4N, T1q, T66;
					     T19 = FNMS(T15, T18, T13);
					     T67 = T4M * T4R;
					     T1l = T1h * T1k;
					     T4N = T1o - T1p;
					     T1q = T1o + T1p;
					     T66 = FNMS(T4I, T4F, T65);
					     {
						  E T5H, T68, T4O, T1r;
						  T4K = FMA(T4I, T4J, T4G);
						  T68 = FNMS(T4Q, T4N, T67);
						  T4O = T4M * T4N;
						  T1r = FNMS(T1n, T1q, T1l);
						  T5H = T1h * T1q;
						  T8B = T66 - T68;
						  T69 = T66 + T68;
						  T8h = T19 - T1r;
						  T1s = T19 + T1r;
						  T4S = FMA(T4Q, T4R, T4O);
						  T5G = FMA(T15, T12, T5F);
						  T5I = FMA(T1n, T1k, T5H);
					     }
					}
				   }
			      }
			      {
				   E T2c, T3x, T2d, T23, T5j, T3q, T2i, T3t, T6i, T8t, T5V, T5X;
				   {
					E Tn, T4i, T9, T4g, Tf, T5U, Ta, T4h, T5u, To, Tt, Tu;
					{
					     E T7, T8, Td, Te;
					     T7 = Ip[WS(rs, 1)];
					     T8q = T4S - T4K;
					     T4T = T4K + T4S;
					     T8k = T5G - T5I;
					     T5J = T5G + T5I;
					     T8 = Im[WS(rs, 1)];
					     Td = Rp[WS(rs, 1)];
					     Te = Rm[WS(rs, 1)];
					     Tn = Ip[WS(rs, 9)];
					     T4i = T7 + T8;
					     T9 = T7 - T8;
					     T4g = Td - Te;
					     Tf = Td + Te;
					     T5U = T2 * T4i;
					     Ta = T6 * T9;
					     T4h = T2 * T4g;
					     T5u = T6 * Tf;
					     To = Im[WS(rs, 9)];
					     Tt = Rp[WS(rs, 9)];
					     Tu = Rm[WS(rs, 9)];
					}
					{
					     E Tg, T4q, Tp, T4m, Tv, T5W, Tq, T4n, T5w;
					     Tg = FNMS(Tc, Tf, Ta);
					     T4q = Tn + To;
					     Tp = Tn - To;
					     T4m = Tt - Tu;
					     Tv = Tt + Tu;
					     T5W = T4l * T4q;
					     Tq = Tm * Tp;
					     T4n = T4l * T4m;
					     T5w = Tm * Tv;
					     {
						  E T5v, Tw, T4j, T5x, T4r;
						  T5v = FMA(Tc, T9, T5u);
						  Tw = FNMS(Ts, Tv, Tq);
						  T4j = FMA(T5, T4i, T4h);
						  T5x = FMA(Ts, Tp, T5w);
						  T4r = FMA(T4p, T4q, T4n);
						  Tx = Tg + Tw;
						  T8a = Tg - Tw;
						  T5y = T5v + T5x;
						  T8d = T5v - T5x;
						  T4s = T4j + T4r;
						  T8t = T4r - T4j;
						  T5V = FNMS(T5, T4g, T5U);
						  T5X = FNMS(T4p, T4m, T5W);
					     }
					}
				   }
				   {
					E T3p, T1Y, T1Z, T22, T2g, T6h, T3o, T5i, T2h;
					{
					     E T20, T21, T1W, T1X, T8u, T2a, T2b, T3n;
					     T1W = Ip[WS(rs, 2)];
					     T1X = Im[WS(rs, 2)];
					     T8u = T5V - T5X;
					     T5Y = T5V + T5X;
					     T20 = Rp[WS(rs, 2)];
					     T3p = T1W + T1X;
					     T1Y = T1W - T1X;
					     T8v = T8t - T8u;
					     T8E = T8u + T8t;
					     T21 = Rm[WS(rs, 2)];
					     T1Z = T1a * T1Y;
					     T2a = Ip[WS(rs, 10)];
					     T2b = Im[WS(rs, 10)];
					     T3n = T21 - T20;
					     T22 = T20 + T21;
					     T2g = Rp[WS(rs, 10)];
					     T2c = T2a - T2b;
					     T3x = T2a + T2b;
					     T6h = T1H * T3n;
					     T3o = T1F * T3n;
					     T5i = T1a * T22;
					     T2d = T29 * T2c;
					     T2h = Rm[WS(rs, 10)];
					}
					T23 = FNMS(T1c, T22, T1Z);
					T5j = FMA(T1c, T1Y, T5i);
					T3q = FNMS(T1H, T3p, T3o);
					T2i = T2g + T2h;
					T3t = T2h - T2g;
					T6i = FMA(T1F, T3p, T6h);
				   }
				   {
					E T2y, T3K, T2z, T2u, T5o, T3H, T2D, T3I, T6n;
					{
					     E T3G, T2o, T2p, T2t, T6m, T3D, T5n, T2B, T2C;
					     {
						  E T2r, T2s, T2m, T2n, T3C, T2w, T2x;
						  {
						       E T8N, T8M, T6j, T3u, T2j;
						       T2m = Ip[WS(rs, 14)];
						       T6j = T3w * T3t;
						       T3u = T3s * T3t;
						       T2j = FNMS(T2f, T2i, T2d);
						       {
							    E T5k, T6k, T3y, T5l;
							    T5k = T29 * T2i;
							    T6k = FMA(T3s, T3x, T6j);
							    T3y = FNMS(T3w, T3x, T3u);
							    T2k = T23 + T2j;
							    T82 = T23 - T2j;
							    T5l = FMA(T2f, T2c, T5k);
							    T6l = T6i + T6k;
							    T8N = T6i - T6k;
							    T3z = T3q + T3y;
							    T8M = T3q - T3y;
							    T83 = T5j - T5l;
							    T5m = T5j + T5l;
							    T2n = Im[WS(rs, 14)];
						       }
						       T8X = T8M + T8N;
						       T8O = T8M - T8N;
						  }
						  T2r = Rp[WS(rs, 14)];
						  T3G = T2m + T2n;
						  T2o = T2m - T2n;
						  T2s = Rm[WS(rs, 14)];
						  T2w = Ip[WS(rs, 6)];
						  T2x = Im[WS(rs, 6)];
						  T2p = T2l * T2o;
						  T3C = T2s - T2r;
						  T2t = T2r + T2s;
						  T2y = T2w - T2x;
						  T3K = T2w + T2x;
						  T6m = T3F * T3C;
						  T3D = T3B * T3C;
						  T5n = T2l * T2t;
						  T2z = T2v * T2y;
						  T2B = Rp[WS(rs, 6)];
						  T2C = Rm[WS(rs, 6)];
					     }
					     T2u = FNMS(T2q, T2t, T2p);
					     T5o = FMA(T2q, T2o, T5n);
					     T3H = FNMS(T3F, T3G, T3D);
					     T2D = T2B + T2C;
					     T3I = T2C - T2B;
					     T6n = FMA(T3B, T3G, T6m);
					}
					{
					     E T4v, TC, T5Z, TD, T4t, TI, TS, T4u, T5z, T4z, TO, TT;
					     {
						  E TG, TH, TA, TB, TM, TN;
						  {
						       E T8Q, T8P, T6o, T3J, T2E;
						       TA = Ip[WS(rs, 5)];
						       T6o = T1g * T3I;
						       T3J = T1d * T3I;
						       T2E = FNMS(T2A, T2D, T2z);
						       {
							    E T5p, T6p, T3L, T5q;
							    T5p = T2v * T2D;
							    T6p = FMA(T1d, T3K, T6o);
							    T3L = FNMS(T1g, T3K, T3J);
							    T2F = T2u + T2E;
							    T86 = T2u - T2E;
							    T5q = FMA(T2A, T2y, T5p);
							    T6q = T6n + T6p;
							    T8Q = T6n - T6p;
							    T3M = T3H + T3L;
							    T8P = T3H - T3L;
							    T85 = T5o - T5q;
							    T5r = T5o + T5q;
							    TB = Im[WS(rs, 5)];
						       }
						       T8Y = T8Q - T8P;
						       T8R = T8P + T8Q;
						  }
						  TG = Rp[WS(rs, 5)];
						  T4v = TA + TB;
						  TC = TA - TB;
						  TH = Rm[WS(rs, 5)];
						  TM = Ip[WS(rs, 13)];
						  T5Z = T32 * T4v;
						  TD = Tz * TC;
						  T4t = TG - TH;
						  TI = TG + TH;
						  TN = Im[WS(rs, 13)];
						  TS = Rp[WS(rs, 13)];
						  T4u = T32 * T4t;
						  T5z = Tz * TI;
						  T4z = TM + TN;
						  TO = TM - TN;
						  TT = Rm[WS(rs, 13)];
					     }
					     {
						  E TJ, T61, TP, T4x, TU;
						  TJ = FNMS(TF, TI, TD);
						  T61 = Ti * T4z;
						  TP = TL * TO;
						  T4x = TS - TT;
						  TU = TS + TT;
						  {
						       E T5A, T60, T5C, T62;
						       T5A = FMA(TF, TC, T5z);
						       {
							    E T4w, T4y, TV, T5B, T4A;
							    T4w = FMA(T34, T4v, T4u);
							    T4y = Ti * T4x;
							    TV = FNMS(TR, TU, TP);
							    T5B = TL * TU;
							    T60 = FNMS(T34, T4t, T5Z);
							    T4A = FMA(Tl, T4z, T4y);
							    TW = TJ + TV;
							    T8e = TJ - TV;
							    T5C = FMA(TR, TO, T5B);
							    T8x = T4w - T4A;
							    T4B = T4w + T4A;
							    T62 = FNMS(Tl, T4x, T61);
						       }
						       T5D = T5A + T5C;
						       T8b = T5A - T5C;
						       T63 = T60 + T62;
						       T8w = T62 - T60;
						  }
					     }
					}
				   }
			      }
			 }
			 {
			      E T74, T78, T8F, T8y, T7s, T72, T75, T77, T7r, T71, T7f, T7d, T7c, T7g, T7m;
			      E T7k, T7j, T7n, T6V, T6Y, T7T, T7W;
			      {
				   E T6S, T1V, T6I, T3l, T6H, T5Q, T6R, T5t, T56, T6g, T6N, T4f, T6M, T6W, T6D;
				   E T6O;
				   {
					E T2G, T3k, T5E, T5P, TX, T1U, T5h, T5s;
					T74 = Tx - TW;
					TX = Tx + TW;
					T1U = T1s + T1T;
					T78 = T1s - T1T;
					T8F = T8w - T8x;
					T8y = T8w + T8x;
					T7s = T2k - T2F;
					T2G = T2k + T2F;
					T6S = TX - T1U;
					T1V = TX + T1U;
					T3k = T31 + T3j;
					T72 = T3j - T31;
					T75 = T5y - T5D;
					T5E = T5y + T5D;
					T5P = T5J + T5O;
					T77 = T5J - T5O;
					T7r = T5b - T5g;
					T5h = T5b + T5g;
					T6I = T3k - T2G;
					T3l = T2G + T3k;
					T6H = T5P - T5E;
					T5Q = T5E + T5P;
					T5s = T5m + T5r;
					T71 = T5r - T5m;
					{
					     E T64, T6L, T6f, T4C, T55;
					     T7f = T4B - T4s;
					     T4C = T4s + T4B;
					     T55 = T4T + T54;
					     T7d = T54 - T4T;
					     T7c = T63 - T5Y;
					     T64 = T5Y + T63;
					     T6R = T5h - T5s;
					     T5t = T5h + T5s;
					     T6L = T4C - T55;
					     T56 = T4C + T55;
					     T7g = T69 - T6e;
					     T6f = T69 + T6e;
					     {
						  E T6r, T6C, T3N, T4e, T6K;
						  T7m = T3z - T3M;
						  T3N = T3z + T3M;
						  T4e = T3Y + T4d;
						  T7k = T4d - T3Y;
						  T6K = T6f - T64;
						  T6g = T64 + T6f;
						  T7j = T6q - T6l;
						  T6r = T6l + T6q;
						  T6N = T4e - T3N;
						  T4f = T3N + T4e;
						  T7n = T6B - T6w;
						  T6C = T6w + T6B;
						  T6M = T6K + T6L;
						  T6W = T6K - T6L;
						  T6D = T6r + T6C;
						  T6O = T6C - T6r;
					     }
					}
				   }
				   {
					E T5T, T6X, T6P, T6E;
					{
					     E T5S, T5R, T6F, T6G, T3m, T57;
					     T5T = T3l - T1V;
					     T3m = T1V + T3l;
					     T57 = T4f - T56;
					     T5S = T56 + T4f;
					     T6X = T6N + T6O;
					     T6P = T6N - T6O;
					     T5R = T5t - T5Q;
					     T6F = T5t + T5Q;
					     Im[WS(rs, 15)] = KP500000000 * (T57 - T3m);
					     Ip[0] = KP500000000 * (T3m + T57);
					     T6G = T6g + T6D;
					     T6E = T6g - T6D;
					     Rp[0] = KP500000000 * (T6F + T6G);
					     Rm[WS(rs, 15)] = KP500000000 * (T6F - T6G);
					     Rp[WS(rs, 8)] = KP500000000 * (T5R + T5S);
					     Rm[WS(rs, 7)] = KP500000000 * (T5R - T5S);
					}
					{
					     E T6U, T6T, T6Z, T70, T6J, T6Q;
					     T6V = T6I - T6H;
					     T6J = T6H + T6I;
					     T6Q = T6M + T6P;
					     T6U = T6P - T6M;
					     T6T = T6R - T6S;
					     T6Z = T6R + T6S;
					     Im[WS(rs, 7)] = KP500000000 * (T6E - T5T);
					     Ip[WS(rs, 8)] = KP500000000 * (T5T + T6E);
					     Im[WS(rs, 11)] = -(KP500000000 * (FNMS(KP707106781, T6Q, T6J)));
					     Ip[WS(rs, 4)] = KP500000000 * (FMA(KP707106781, T6Q, T6J));
					     T70 = T6W + T6X;
					     T6Y = T6W - T6X;
					     Rp[WS(rs, 4)] = KP500000000 * (FMA(KP707106781, T70, T6Z));
					     Rm[WS(rs, 11)] = KP500000000 * (FNMS(KP707106781, T70, T6Z));
					     Rp[WS(rs, 12)] = KP500000000 * (FMA(KP707106781, T6U, T6T));
					     Rm[WS(rs, 3)] = KP500000000 * (FNMS(KP707106781, T6U, T6T));
					}
				   }
			      }
			      {
				   E T7F, T73, T7P, T7t, T7G, T7w, T7Q, T7a, T7L, T7l, T7K, T7U, T7A, T7i, T7u;
				   E T76;
				   Im[WS(rs, 3)] = -(KP500000000 * (FNMS(KP707106781, T6Y, T6V)));
				   Ip[WS(rs, 12)] = KP500000000 * (FMA(KP707106781, T6Y, T6V));
				   T7F = T72 - T71;
				   T73 = T71 + T72;
				   T7P = T7r - T7s;
				   T7t = T7r + T7s;
				   T7u = T75 + T74;
				   T76 = T74 - T75;
				   {
					E T7I, T7e, T7v, T79, T7J, T7h;
					T7v = T77 - T78;
					T79 = T77 + T78;
					T7I = T7c - T7d;
					T7e = T7c + T7d;
					T7G = T7v - T7u;
					T7w = T7u + T7v;
					T7Q = T76 - T79;
					T7a = T76 + T79;
					T7J = T7g - T7f;
					T7h = T7f + T7g;
					T7L = T7k - T7j;
					T7l = T7j + T7k;
					T7K = FMA(KP414213562, T7J, T7I);
					T7U = FNMS(KP414213562, T7I, T7J);
					T7A = FNMS(KP414213562, T7e, T7h);
					T7i = FMA(KP414213562, T7h, T7e);
				   }
				   {
					E T7z, T7b, T7D, T7x, T7M, T7o;
					T7z = FNMS(KP707106781, T7a, T73);
					T7b = FMA(KP707106781, T7a, T73);
					T7D = FMA(KP707106781, T7w, T7t);
					T7x = FNMS(KP707106781, T7w, T7t);
					T7M = T7n - T7m;
					T7o = T7m + T7n;
					{
					     E T7S, T7R, T7X, T7Y;
					     {
						  E T7H, T7V, T7B, T7p, T7O, T7N;
						  T7T = FMA(KP707106781, T7G, T7F);
						  T7H = FNMS(KP707106781, T7G, T7F);
						  T7N = FMA(KP414213562, T7M, T7L);
						  T7V = FNMS(KP414213562, T7L, T7M);
						  T7B = FMA(KP414213562, T7l, T7o);
						  T7p = FNMS(KP414213562, T7o, T7l);
						  T7O = T7K - T7N;
						  T7S = T7K + T7N;
						  T7R = FMA(KP707106781, T7Q, T7P);
						  T7X = FNMS(KP707106781, T7Q, T7P);
						  {
						       E T7C, T7E, T7y, T7q;
						       T7C = T7A - T7B;
						       T7E = T7A + T7B;
						       T7y = T7p - T7i;
						       T7q = T7i + T7p;
						       Im[WS(rs, 1)] = -(KP500000000 * (FNMS(KP923879532, T7O, T7H)));
						       Ip[WS(rs, 14)] = KP500000000 * (FMA(KP923879532, T7O, T7H));
						       Im[WS(rs, 5)] = -(KP500000000 * (FNMS(KP923879532, T7C, T7z)));
						       Ip[WS(rs, 10)] = KP500000000 * (FMA(KP923879532, T7C, T7z));
						       Rp[WS(rs, 2)] = KP500000000 * (FMA(KP923879532, T7E, T7D));
						       Rm[WS(rs, 13)] = KP500000000 * (FNMS(KP923879532, T7E, T7D));
						       Rp[WS(rs, 10)] = KP500000000 * (FMA(KP923879532, T7y, T7x));
						       Rm[WS(rs, 5)] = KP500000000 * (FNMS(KP923879532, T7y, T7x));
						       Im[WS(rs, 13)] = -(KP500000000 * (FNMS(KP923879532, T7q, T7b)));
						       Ip[WS(rs, 2)] = KP500000000 * (FMA(KP923879532, T7q, T7b));
						       T7Y = T7U + T7V;
						       T7W = T7U - T7V;
						  }
					     }
					     Rm[WS(rs, 1)] = KP500000000 * (FMA(KP923879532, T7Y, T7X));
					     Rp[WS(rs, 14)] = KP500000000 * (FNMS(KP923879532, T7Y, T7X));
					     Rp[WS(rs, 6)] = KP500000000 * (FMA(KP923879532, T7S, T7R));
					     Rm[WS(rs, 9)] = KP500000000 * (FNMS(KP923879532, T7S, T7R));
					}
				   }
			      }
			      {
				   E Ta7, Tat, T9l, T89, T9H, Taj, T9v, T99, T9m, T9c, T9w, T8o, Tao, Tay, Tae;
				   E Ta3, T9q, T9A, T9g, T8I, T8Z, T8W, Tak, Taa, Tau, T9O, T9r, T8T, Tar, Taz;
				   E Taf, T9W;
				   {
					E T9M, T9L, T9J, T9I, T8s, T8G, T8D, Ta0, Tam, T9Z, Ta1, T8z, Ta9, T9K;
					{
					     E T9F, T81, Ta5, T95, T96, T97, Ta6, T88, T84, T87;
					     T9F = T80 + T7Z;
					     T81 = T7Z - T80;
					     Ta5 = T93 - T94;
					     T95 = T93 + T94;
					     T96 = T83 + T82;
					     T84 = T82 - T83;
					     Im[WS(rs, 9)] = -(KP500000000 * (FNMS(KP923879532, T7W, T7T)));
					     Ip[WS(rs, 6)] = KP500000000 * (FMA(KP923879532, T7W, T7T));
					     T87 = T85 + T86;
					     T97 = T85 - T86;
					     Ta6 = T84 - T87;
					     T88 = T84 + T87;
					     {
						  E T8j, T9a, T8g, T8m;
						  {
						       E T8c, T9G, T98, T8f;
						       T9M = T8a + T8b;
						       T8c = T8a - T8b;
						       Ta7 = FMA(KP707106781, Ta6, Ta5);
						       Tat = FNMS(KP707106781, Ta6, Ta5);
						       T9l = FNMS(KP707106781, T88, T81);
						       T89 = FMA(KP707106781, T88, T81);
						       T9G = T97 - T96;
						       T98 = T96 + T97;
						       T8f = T8d + T8e;
						       T9L = T8d - T8e;
						       T9J = T8h + T8i;
						       T8j = T8h - T8i;
						       T9H = FMA(KP707106781, T9G, T9F);
						       Taj = FNMS(KP707106781, T9G, T9F);
						       T9v = FNMS(KP707106781, T98, T95);
						       T99 = FMA(KP707106781, T98, T95);
						       T9a = FMA(KP414213562, T8c, T8f);
						       T8g = FNMS(KP414213562, T8f, T8c);
						       T8m = T8k + T8l;
						       T9I = T8k - T8l;
						  }
						  {
						       E T9X, T9Y, T9b, T8n;
						       T8s = T8q + T8r;
						       T9X = T8r - T8q;
						       T9Y = T8F - T8E;
						       T8G = T8E + T8F;
						       T8D = T8B + T8C;
						       Ta0 = T8B - T8C;
						       T9b = FNMS(KP414213562, T8j, T8m);
						       T8n = FMA(KP414213562, T8m, T8j);
						       Tam = FMA(KP707106781, T9Y, T9X);
						       T9Z = FNMS(KP707106781, T9Y, T9X);
						       T9m = T9b - T9a;
						       T9c = T9a + T9b;
						       T9w = T8g - T8n;
						       T8o = T8g + T8n;
						       Ta1 = T8y - T8v;
						       T8z = T8v + T8y;
						  }
					     }
					}
					{
					     E T9o, T8A, Tan, Ta2, T9p, T8H;
					     Tan = FMA(KP707106781, Ta1, Ta0);
					     Ta2 = FNMS(KP707106781, Ta1, Ta0);
					     T9o = FNMS(KP707106781, T8z, T8s);
					     T8A = FMA(KP707106781, T8z, T8s);
					     Tao = FMA(KP198912367, Tan, Tam);
					     Tay = FNMS(KP198912367, Tam, Tan);
					     Tae = FMA(KP668178637, T9Z, Ta2);
					     Ta3 = FNMS(KP668178637, Ta2, T9Z);
					     T9p = FNMS(KP707106781, T8G, T8D);
					     T8H = FMA(KP707106781, T8G, T8D);
					     Ta9 = FNMS(KP414213562, T9I, T9J);
					     T9K = FMA(KP414213562, T9J, T9I);
					     T9q = FNMS(KP668178637, T9p, T9o);
					     T9A = FMA(KP668178637, T9o, T9p);
					     T9g = FNMS(KP198912367, T8A, T8H);
					     T8I = FMA(KP198912367, T8H, T8A);
					}
					{
					     E T8L, T9T, Tap, T9S, T9U, T8S, Taq, T9V;
					     {
						  E T9Q, T9R, Ta8, T9N;
						  T8L = T8J - T8K;
						  T9Q = T8K + T8J;
						  T9R = T8X - T8Y;
						  T8Z = T8X + T8Y;
						  T8W = T8U + T8V;
						  T9T = T8V - T8U;
						  Ta8 = FMA(KP414213562, T9L, T9M);
						  T9N = FNMS(KP414213562, T9M, T9L);
						  Tap = FMA(KP707106781, T9R, T9Q);
						  T9S = FNMS(KP707106781, T9R, T9Q);
						  Tak = Ta8 + Ta9;
						  Taa = Ta8 - Ta9;
						  Tau = T9N + T9K;
						  T9O = T9K - T9N;
						  T9U = T8R - T8O;
						  T8S = T8O + T8R;
					     }
					     Taq = FMA(KP707106781, T9U, T9T);
					     T9V = FNMS(KP707106781, T9U, T9T);
					     T9r = FNMS(KP707106781, T8S, T8L);
					     T8T = FMA(KP707106781, T8S, T8L);
					     Tar = FMA(KP198912367, Taq, Tap);
					     Taz = FNMS(KP198912367, Tap, Taq);
					     Taf = FMA(KP668178637, T9S, T9V);
					     T9W = FNMS(KP668178637, T9V, T9S);
					}
				   }
				   {
					E T9z, T9C, Tad, Tag;
					{
					     E T9f, T8p, T9j, T9d, T9s, T90;
					     T9f = FNMS(KP923879532, T8o, T89);
					     T8p = FMA(KP923879532, T8o, T89);
					     T9j = FMA(KP923879532, T9c, T99);
					     T9d = FNMS(KP923879532, T9c, T99);
					     T9s = FNMS(KP707106781, T8Z, T8W);
					     T90 = FMA(KP707106781, T8Z, T8W);
					     {
						  E T9y, T9x, T9D, T9E;
						  {
						       E T9n, T9B, T9h, T91, T9u, T9t;
						       T9z = FMA(KP923879532, T9m, T9l);
						       T9n = FNMS(KP923879532, T9m, T9l);
						       T9t = FMA(KP668178637, T9s, T9r);
						       T9B = FNMS(KP668178637, T9r, T9s);
						       T9h = FMA(KP198912367, T8T, T90);
						       T91 = FNMS(KP198912367, T90, T8T);
						       T9u = T9q + T9t;
						       T9y = T9t - T9q;
						       T9x = FMA(KP923879532, T9w, T9v);
						       T9D = FNMS(KP923879532, T9w, T9v);
						       {
							    E T9i, T9k, T9e, T92;
							    T9i = T9g - T9h;
							    T9k = T9g + T9h;
							    T9e = T91 - T8I;
							    T92 = T8I + T91;
							    Im[WS(rs, 2)] = -(KP500000000 * (FMA(KP831469612, T9u, T9n)));
							    Ip[WS(rs, 13)] = KP500000000 * (FNMS(KP831469612, T9u, T9n));
							    Im[WS(rs, 6)] = -(KP500000000 * (FNMS(KP980785280, T9i, T9f)));
							    Ip[WS(rs, 9)] = KP500000000 * (FMA(KP980785280, T9i, T9f));
							    Rp[WS(rs, 1)] = KP500000000 * (FMA(KP980785280, T9k, T9j));
							    Rm[WS(rs, 14)] = KP500000000 * (FNMS(KP980785280, T9k, T9j));
							    Rp[WS(rs, 9)] = KP500000000 * (FMA(KP980785280, T9e, T9d));
							    Rm[WS(rs, 6)] = KP500000000 * (FNMS(KP980785280, T9e, T9d));
							    Im[WS(rs, 14)] = -(KP500000000 * (FNMS(KP980785280, T92, T8p)));
							    Ip[WS(rs, 1)] = KP500000000 * (FMA(KP980785280, T92, T8p));
							    T9E = T9A + T9B;
							    T9C = T9A - T9B;
						       }
						  }
						  Rm[WS(rs, 2)] = KP500000000 * (FMA(KP831469612, T9E, T9D));
						  Rp[WS(rs, 13)] = KP500000000 * (FNMS(KP831469612, T9E, T9D));
						  Rp[WS(rs, 5)] = KP500000000 * (FMA(KP831469612, T9y, T9x));
						  Rm[WS(rs, 10)] = KP500000000 * (FNMS(KP831469612, T9y, T9x));
					     }
					}
					{
					     E Tac, Tab, Tah, Tai, T9P, Ta4;
					     Tad = FNMS(KP923879532, T9O, T9H);
					     T9P = FMA(KP923879532, T9O, T9H);
					     Ta4 = T9W - Ta3;
					     Tac = Ta3 + T9W;
					     Tab = FNMS(KP923879532, Taa, Ta7);
					     Tah = FMA(KP923879532, Taa, Ta7);
					     Im[WS(rs, 10)] = -(KP500000000 * (FNMS(KP831469612, T9C, T9z)));
					     Ip[WS(rs, 5)] = KP500000000 * (FMA(KP831469612, T9C, T9z));
					     Im[WS(rs, 12)] = -(KP500000000 * (FNMS(KP831469612, Ta4, T9P)));
					     Ip[WS(rs, 3)] = KP500000000 * (FMA(KP831469612, Ta4, T9P));
					     Tai = Tae + Taf;
					     Tag = Tae - Taf;
					     Rp[WS(rs, 3)] = KP500000000 * (FMA(KP831469612, Tai, Tah));
					     Rm[WS(rs, 12)] = KP500000000 * (FNMS(KP831469612, Tai, Tah));
					     Rp[WS(rs, 11)] = KP500000000 * (FMA(KP831469612, Tac, Tab));
					     Rm[WS(rs, 4)] = KP500000000 * (FNMS(KP831469612, Tac, Tab));
					}
					{
					     E Taw, Tav, TaB, TaC, Tal, Tas;
					     Tax = FNMS(KP923879532, Tak, Taj);
					     Tal = FMA(KP923879532, Tak, Taj);
					     Tas = Tao - Tar;
					     Taw = Tao + Tar;
					     Tav = FNMS(KP923879532, Tau, Tat);
					     TaB = FMA(KP923879532, Tau, Tat);
					     Im[WS(rs, 4)] = -(KP500000000 * (FNMS(KP831469612, Tag, Tad)));
					     Ip[WS(rs, 11)] = KP500000000 * (FMA(KP831469612, Tag, Tad));
					     Im[0] = -(KP500000000 * (FNMS(KP980785280, Tas, Tal)));
					     Ip[WS(rs, 15)] = KP500000000 * (FMA(KP980785280, Tas, Tal));
					     TaC = Tay + Taz;
					     TaA = Tay - Taz;
					     Rm[0] = KP500000000 * (FMA(KP980785280, TaC, TaB));
					     Rp[WS(rs, 15)] = KP500000000 * (FNMS(KP980785280, TaC, TaB));
					     Rp[WS(rs, 7)] = KP500000000 * (FMA(KP980785280, Taw, Tav));
					     Rm[WS(rs, 8)] = KP500000000 * (FNMS(KP980785280, Taw, Tav));
					}
				   }
			      }
			 }
		    }
	       }
	       Im[WS(rs, 8)] = -(KP500000000 * (FNMS(KP980785280, TaA, Tax)));
	       Ip[WS(rs, 7)] = KP500000000 * (FMA(KP980785280, TaA, Tax));
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 27},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cfdft2_32", twinstr, &GENUS, {300, 162, 252, 0} };

void X(codelet_hc2cfdft2_32) (planner *p) {
     X(khc2c_register) (p, hc2cfdft2_32, &desc, HC2C_VIA_DFT);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2cdft.native -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 32 -dit -name hc2cfdft2_32 -include hc2cf.h */

/*
 * This function contains 552 FP additions, 300 FP multiplications,
 * (or, 440 additions, 188 multiplications, 112 fused multiply/add),
 * 166 stack variables, 9 constants, and 128 memory accesses
 */
#include "hc2cf.h"

static void hc2cfdft2_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP277785116, +0.277785116509801112371415406974266437187468595);
     DK(KP415734806, +0.415734806151272618539394188808952878369280406);
     DK(KP097545161, +0.097545161008064133924142434238511120463845809);
     DK(KP490392640, +0.490392640201615224563091118067119518486966865);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP191341716, +0.191341716182544885864229992015199433380672281);
     DK(KP461939766, +0.461939766255643378064091594698394143411208313);
     DK(KP353553390, +0.353553390593273762200422181052424519642417969);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 8, MAKE_VOLATILE_STRIDE(rs)) {
	       E T1, T4, T2, T5, T7, T1b, T1d, Td, Ti, Tk, Tj, Tl, TL, TR, T2h;
	       E T2O, T16, T2l, T10, T2K, Tm, Tq, T3s, T3K, T3w, T3M, T4e, T4u, T4i, T4w;
	       E Ty, TE, T3h, T3j, T2q, T2u, T4l, T4n, T1v, T1B, T3E, T3G, T2B, T2F, T3Y;
	       E T40, T1f, T1G, T1i, T1H, T1j, T1M, T1n, T1I, T23, T2U, T26, T2V, T27, T30;
	       E T2b, T2W;
	       {
		    E Tw, T1A, TD, T1t, Tx, T1z, TC, T1u, TJ, T15, TQ, TY, TK, T14, TP;
		    E TZ;
		    {
			 E T3, Tc, T6, Tb;
			 T1 = W[0];
			 T4 = W[1];
			 T2 = W[2];
			 T5 = W[3];
			 T3 = T1 * T2;
			 Tc = T4 * T2;
			 T6 = T4 * T5;
			 Tb = T1 * T5;
			 T7 = T3 + T6;
			 T1b = T3 - T6;
			 T1d = Tb + Tc;
			 Td = Tb - Tc;
			 Ti = W[4];
			 Tw = T1 * Ti;
			 T1A = T5 * Ti;
			 TD = T4 * Ti;
			 T1t = T2 * Ti;
			 Tk = W[5];
			 Tx = T4 * Tk;
			 T1z = T2 * Tk;
			 TC = T1 * Tk;
			 T1u = T5 * Tk;
			 Tj = W[6];
			 TJ = T1 * Tj;
			 T15 = T5 * Tj;
			 TQ = T4 * Tj;
			 TY = T2 * Tj;
			 Tl = W[7];
			 TK = T4 * Tl;
			 T14 = T2 * Tl;
			 TP = T1 * Tl;
			 TZ = T5 * Tl;
		    }
		    TL = TJ + TK;
		    TR = TP - TQ;
		    T2h = TJ - TK;
		    T2O = T14 - T15;
		    T16 = T14 + T15;
		    T2l = TP + TQ;
		    T10 = TY - TZ;
		    T2K = TY + TZ;
		    Tm = FMA(Ti, Tj, Tk * Tl);
		    Tq = FNMS(Tk, Tj, Ti * Tl);
		    {
			 E T3q, T3r, T3u, T3v;
			 T3q = T7 * Tj;
			 T3r = Td * Tl;
			 T3s = T3q + T3r;
			 T3K = T3q - T3r;
			 T3u = T7 * Tl;
			 T3v = Td * Tj;
			 T3w = T3u - T3v;
			 T3M = T3u + T3v;
		    }
		    {
			 E T4c, T4d, T4g, T4h;
			 T4c = T1b * Tj;
			 T4d = T1d * Tl;
			 T4e = T4c - T4d;
			 T4u = T4c + T4d;
			 T4g = T1b * Tl;
			 T4h = T1d * Tj;
			 T4i = T4g + T4h;
			 T4w = T4g - T4h;
			 Ty = Tw - Tx;
			 TE = TC + TD;
			 T3h = FMA(Ty, Tj, TE * Tl);
			 T3j = FNMS(TE, Tj, Ty * Tl);
		    }
		    T2q = T1t - T1u;
		    T2u = T1z + T1A;
		    T4l = FMA(T2q, Tj, T2u * Tl);
		    T4n = FNMS(T2u, Tj, T2q * Tl);
		    T1v = T1t + T1u;
		    T1B = T1z - T1A;
		    T3E = FMA(T1v, Tj, T1B * Tl);
		    T3G = FNMS(T1B, Tj, T1v * Tl);
		    T2B = Tw + Tx;
		    T2F = TC - TD;
		    T3Y = FMA(T2B, Tj, T2F * Tl);
		    T40 = FNMS(T2F, Tj, T2B * Tl);
		    {
			 E T1c, T1e, T1g, T1h;
			 T1c = T1b * Ti;
			 T1e = T1d * Tk;
			 T1f = T1c - T1e;
			 T1G = T1c + T1e;
			 T1g = T1b * Tk;
			 T1h = T1d * Ti;
			 T1i = T1g + T1h;
			 T1H = T1g - T1h;
		    }
		    T1j = FMA(T1f, Tj, T1i * Tl);
		    T1M = FNMS(T1H, Tj, T1G * Tl);
		    T1n = FNMS(T1i, Tj, T1f * Tl);
		    T1I = FMA(T1G, Tj, T1H * Tl);
		    {
			 E T21, T22, T24, T25;
			 T21 = T7 * Ti;
			 T22 = Td * Tk;
			 T23 = T21 + T22;
			 T2U = T21 - T22;
			 T24 = T7 * Tk;
			 T25 = Td * Ti;
			 T26 = T24 - T25;
			 T2V = T24 + T25;
		    }
		    T27 = FMA(T23, Tj, T26 * Tl);
		    T30 = FNMS(T2V, Tj, T2U * Tl);
		    T2b = FNMS(T26, Tj, T23 * Tl);
		    T2W = FMA(T2U, Tj, T2V * Tl);
	       }
	       {
		    E T38, T7l, T7S, T8Y, T7Z, T91, T3A, T6k, T4F, T83, T5C, T6n, T2T, T84, T4I;
		    E T7m, T2g, T4M, T4P, T2z, T3T, T6m, T7O, T7V, T7j, T87, T5v, T6j, T7L, T7U;
		    E T7g, T86, Tv, TW, T61, T4U, T4X, T62, T4b, T6c, T7v, T7C, T5g, T6f, T74;
		    E T8G, T7s, T7B, T71, T8F, T1s, T1R, T65, T51, T54, T64, T4A, T6g, T7G, T8U;
		    E T5n, T6d, T7b, T8J, T7z, T8R, T78, T8I;
		    {
			 E T2E, T2I, T3p, T5w, T37, T4D, T3g, T5A, T2N, T2R, T3y, T5x, T2Z, T33, T3l;
			 E T5z;
			 {
			      E T2C, T2D, T3o, T2G, T2H, T3n;
			      T2C = Ip[WS(rs, 4)];
			      T2D = Im[WS(rs, 4)];
			      T3o = T2C + T2D;
			      T2G = Rp[WS(rs, 4)];
			      T2H = Rm[WS(rs, 4)];
			      T3n = T2G - T2H;
			      T2E = T2C - T2D;
			      T2I = T2G + T2H;
			      T3p = FMA(Ti, T3n, Tk * T3o);
			      T5w = FNMS(Tk, T3n, Ti * T3o);
			 }
			 {
			      E T35, T36, T3f, T3c, T3d, T3e;
			      T35 = Ip[0];
			      T36 = Im[0];
			      T3f = T35 + T36;
			      T3c = Rm[0];
			      T3d = Rp[0];
			      T3e = T3c - T3d;
			      T37 = T35 - T36;
			      T4D = T3d + T3c;
			      T3g = FNMS(T4, T3f, T1 * T3e);
			      T5A = FMA(T4, T3e, T1 * T3f);
			 }
			 {
			      E T2L, T2M, T3x, T2P, T2Q, T3t;
			      T2L = Ip[WS(rs, 12)];
			      T2M = Im[WS(rs, 12)];
			      T3x = T2L + T2M;
			      T2P = Rp[WS(rs, 12)];
			      T2Q = Rm[WS(rs, 12)];
			      T3t = T2P - T2Q;
			      T2N = T2L - T2M;
			      T2R = T2P + T2Q;
			      T3y = FMA(T3s, T3t, T3w * T3x);
			      T5x = FNMS(T3w, T3t, T3s * T3x);
			 }
			 {
			      E T2X, T2Y, T3k, T31, T32, T3i;
			      T2X = Ip[WS(rs, 8)];
			      T2Y = Im[WS(rs, 8)];
			      T3k = T2X + T2Y;
			      T31 = Rp[WS(rs, 8)];
			      T32 = Rm[WS(rs, 8)];
			      T3i = T31 - T32;
			      T2Z = T2X - T2Y;
			      T33 = T31 + T32;
			      T3l = FMA(T3h, T3i, T3j * T3k);
			      T5z = FNMS(T3j, T3i, T3h * T3k);
			 }
			 {
			      E T34, T7Q, T7R, T4E, T5y, T5B;
			      T34 = FNMS(T30, T33, T2W * T2Z);
			      T38 = T34 + T37;
			      T7l = T37 - T34;
			      T7Q = T3l + T3g;
			      T7R = T5w - T5x;
			      T7S = T7Q - T7R;
			      T8Y = T7R + T7Q;
			      {
				   E T7X, T7Y, T3m, T3z;
				   T7X = T3y - T3p;
				   T7Y = T5A - T5z;
				   T7Z = T7X + T7Y;
				   T91 = T7Y - T7X;
				   T3m = T3g - T3l;
				   T3z = T3p + T3y;
				   T3A = T3m - T3z;
				   T6k = T3z + T3m;
			      }
			      T4E = FMA(T2W, T33, T30 * T2Z);
			      T4F = T4D + T4E;
			      T83 = T4D - T4E;
			      T5y = T5w + T5x;
			      T5B = T5z + T5A;
			      T5C = T5y + T5B;
			      T6n = T5B - T5y;
			      {
				   E T2J, T2S, T4G, T4H;
				   T2J = FNMS(T2F, T2I, T2B * T2E);
				   T2S = FNMS(T2O, T2R, T2K * T2N);
				   T2T = T2J + T2S;
				   T84 = T2J - T2S;
				   T4G = FMA(T2B, T2I, T2F * T2E);
				   T4H = FMA(T2K, T2R, T2O * T2N);
				   T4I = T4G + T4H;
				   T7m = T4G - T4H;
			      }
			 }
		    }
		    {
			 E T20, T5p, T3D, T4K, T2y, T5t, T3R, T4O, T2f, T5q, T3I, T4L, T2p, T5s, T3O;
			 E T4N;
			 {
			      E T1W, T3C, T1Z, T3B;
			      {
				   E T1U, T1V, T1X, T1Y;
				   T1U = Ip[WS(rs, 2)];
				   T1V = Im[WS(rs, 2)];
				   T1W = T1U - T1V;
				   T3C = T1U + T1V;
				   T1X = Rp[WS(rs, 2)];
				   T1Y = Rm[WS(rs, 2)];
				   T1Z = T1X + T1Y;
				   T3B = T1X - T1Y;
			      }
			      T20 = FNMS(T1d, T1Z, T1b * T1W);
			      T5p = FNMS(T1H, T3B, T1G * T3C);
			      T3D = FMA(T1G, T3B, T1H * T3C);
			      T4K = FMA(T1b, T1Z, T1d * T1W);
			 }
			 {
			      E T2t, T3Q, T2x, T3P;
			      {
				   E T2r, T2s, T2v, T2w;
				   T2r = Ip[WS(rs, 6)];
				   T2s = Im[WS(rs, 6)];
				   T2t = T2r - T2s;
				   T3Q = T2r + T2s;
				   T2v = Rp[WS(rs, 6)];
				   T2w = Rm[WS(rs, 6)];
				   T2x = T2v + T2w;
				   T3P = T2v - T2w;
			      }
			      T2y = FNMS(T2u, T2x, T2q * T2t);
			      T5t = FNMS(T1i, T3P, T1f * T3Q);
			      T3R = FMA(T1f, T3P, T1i * T3Q);
			      T4O = FMA(T2q, T2x, T2u * T2t);
			 }
			 {
			      E T2a, T3H, T2e, T3F;
			      {
				   E T28, T29, T2c, T2d;
				   T28 = Ip[WS(rs, 10)];
				   T29 = Im[WS(rs, 10)];
				   T2a = T28 - T29;
				   T3H = T28 + T29;
				   T2c = Rp[WS(rs, 10)];
				   T2d = Rm[WS(rs, 10)];
				   T2e = T2c + T2d;
				   T3F = T2c - T2d;
			      }
			      T2f = FNMS(T2b, T2e, T27 * T2a);
			      T5q = FNMS(T3G, T3F, T3E * T3H);
			      T3I = FMA(T3E, T3F, T3G * T3H);
			      T4L = FMA(T27, T2e, T2b * T2a);
			 }
			 {
			      E T2k, T3N, T2o, T3L;
			      {
				   E T2i, T2j, T2m, T2n;
				   T2i = Ip[WS(rs, 14)];
				   T2j = Im[WS(rs, 14)];
				   T2k = T2i - T2j;
				   T3N = T2i + T2j;
				   T2m = Rp[WS(rs, 14)];
				   T2n = Rm[WS(rs, 14)];
				   T2o = T2m + T2n;
				   T3L = T2m - T2n;
			      }
			      T2p = FNMS(T2l, T2o, T2h * T2k);
			      T5s = FNMS(T3M, T3L, T3K * T3N);
			      T3O = FMA(T3K, T3L, T3M * T3N);
			      T4N = FMA(T2h, T2o, T2l * T2k);
			 }
			 {
			      E T3J, T3S, T5r, T5u;
			      T2g = T20 + T2f;
			      T4M = T4K + T4L;
			      T4P = T4N + T4O;
			      T2z = T2p + T2y;
			      T3J = T3D + T3I;
			      T3S = T3O + T3R;
			      T3T = T3J + T3S;
			      T6m = T3S - T3J;
			      {
				   E T7M, T7N, T7h, T7i;
				   T7M = T5s - T5t;
				   T7N = T3R - T3O;
				   T7O = T7M + T7N;
				   T7V = T7M - T7N;
				   T7h = T4N - T4O;
				   T7i = T2p - T2y;
				   T7j = T7h + T7i;
				   T87 = T7h - T7i;
			      }
			      T5r = T5p + T5q;
			      T5u = T5s + T5t;
			      T5v = T5r + T5u;
			      T6j = T5u - T5r;
			      {
				   E T7J, T7K, T7e, T7f;
				   T7J = T3I - T3D;
				   T7K = T5p - T5q;
				   T7L = T7J - T7K;
				   T7U = T7K + T7J;
				   T7e = T20 - T2f;
				   T7f = T4K - T4L;
				   T7g = T7e - T7f;
				   T86 = T7f + T7e;
			      }
			 }
		    }
		    {
			 E Th, T5a, T3X, T4S, TV, T5e, T49, T4W, Tu, T5b, T42, T4T, TI, T5d, T46;
			 E T4V;
			 {
			      E Ta, T3W, Tg, T3V;
			      {
				   E T8, T9, Te, Tf;
				   T8 = Ip[WS(rs, 1)];
				   T9 = Im[WS(rs, 1)];
				   Ta = T8 - T9;
				   T3W = T8 + T9;
				   Te = Rp[WS(rs, 1)];
				   Tf = Rm[WS(rs, 1)];
				   Tg = Te + Tf;
				   T3V = Te - Tf;
			      }
			      Th = FNMS(Td, Tg, T7 * Ta);
			      T5a = FNMS(T5, T3V, T2 * T3W);
			      T3X = FMA(T2, T3V, T5 * T3W);
			      T4S = FMA(T7, Tg, Td * Ta);
			 }
			 {
			      E TO, T48, TU, T47;
			      {
				   E TM, TN, TS, TT;
				   TM = Ip[WS(rs, 13)];
				   TN = Im[WS(rs, 13)];
				   TO = TM - TN;
				   T48 = TM + TN;
				   TS = Rp[WS(rs, 13)];
				   TT = Rm[WS(rs, 13)];
				   TU = TS + TT;
				   T47 = TS - TT;
			      }
			      TV = FNMS(TR, TU, TL * TO);
			      T5e = FNMS(Tl, T47, Tj * T48);
			      T49 = FMA(Tj, T47, Tl * T48);
			      T4W = FMA(TL, TU, TR * TO);
			 }
			 {
			      E Tp, T41, Tt, T3Z;
			      {
				   E Tn, To, Tr, Ts;
				   Tn = Ip[WS(rs, 9)];
				   To = Im[WS(rs, 9)];
				   Tp = Tn - To;
				   T41 = Tn + To;
				   Tr = Rp[WS(rs, 9)];
				   Ts = Rm[WS(rs, 9)];
				   Tt = Tr + Ts;
				   T3Z = Tr - Ts;
			      }
			      Tu = FNMS(Tq, Tt, Tm * Tp);
			      T5b = FNMS(T40, T3Z, T3Y * T41);
			      T42 = FMA(T3Y, T3Z, T40 * T41);
			      T4T = FMA(Tm, Tt, Tq * Tp);
			 }
			 {
			      E TB, T45, TH, T44;
			      {
				   E Tz, TA, TF, TG;
				   Tz = Ip[WS(rs, 5)];
				   TA = Im[WS(rs, 5)];
				   TB = Tz - TA;
				   T45 = Tz + TA;
				   TF = Rp[WS(rs, 5)];
				   TG = Rm[WS(rs, 5)];
				   TH = TF + TG;
				   T44 = TF - TG;
			      }
			      TI = FNMS(TE, TH, Ty * TB);
			      T5d = FNMS(T2V, T44, T2U * T45);
			      T46 = FMA(T2U, T44, T2V * T45);
			      T4V = FMA(Ty, TH, TE * TB);
			 }
			 Tv = Th + Tu;
			 TW = TI + TV;
			 T61 = Tv - TW;
			 T4U = T4S + T4T;
			 T4X = T4V + T4W;
			 T62 = T4U - T4X;
			 {
			      E T43, T4a, T7t, T7u;
			      T43 = T3X + T42;
			      T4a = T46 + T49;
			      T4b = T43 + T4a;
			      T6c = T4a - T43;
			      T7t = T5e - T5d;
			      T7u = T46 - T49;
			      T7v = T7t + T7u;
			      T7C = T7t - T7u;
			 }
			 {
			      E T5c, T5f, T72, T73;
			      T5c = T5a + T5b;
			      T5f = T5d + T5e;
			      T5g = T5c + T5f;
			      T6f = T5f - T5c;
			      T72 = T4S - T4T;
			      T73 = TI - TV;
			      T74 = T72 + T73;
			      T8G = T72 - T73;
			 }
			 {
			      E T7q, T7r, T6Z, T70;
			      T7q = T42 - T3X;
			      T7r = T5a - T5b;
			      T7s = T7q - T7r;
			      T7B = T7r + T7q;
			      T6Z = Th - Tu;
			      T70 = T4V - T4W;
			      T71 = T6Z - T70;
			      T8F = T6Z + T70;
			 }
		    }
		    {
			 E T1a, T5h, T4k, T4Z, T1Q, T5l, T4y, T53, T1r, T5i, T4p, T50, T1F, T5k, T4t;
			 E T52;
			 {
			      E T13, T4j, T19, T4f;
			      {
				   E T11, T12, T17, T18;
				   T11 = Ip[WS(rs, 15)];
				   T12 = Im[WS(rs, 15)];
				   T13 = T11 - T12;
				   T4j = T11 + T12;
				   T17 = Rp[WS(rs, 15)];
				   T18 = Rm[WS(rs, 15)];
				   T19 = T17 + T18;
				   T4f = T17 - T18;
			      }
			      T1a = FNMS(T16, T19, T10 * T13);
			      T5h = FNMS(T4i, T4f, T4e * T4j);
			      T4k = FMA(T4e, T4f, T4i * T4j);
			      T4Z = FMA(T10, T19, T16 * T13);
			 }
			 {
			      E T1L, T4x, T1P, T4v;
			      {
				   E T1J, T1K, T1N, T1O;
				   T1J = Ip[WS(rs, 11)];
				   T1K = Im[WS(rs, 11)];
				   T1L = T1J - T1K;
				   T4x = T1J + T1K;
				   T1N = Rp[WS(rs, 11)];
				   T1O = Rm[WS(rs, 11)];
				   T1P = T1N + T1O;
				   T4v = T1N - T1O;
			      }
			      T1Q = FNMS(T1M, T1P, T1I * T1L);
			      T5l = FNMS(T4w, T4v, T4u * T4x);
			      T4y = FMA(T4u, T4v, T4w * T4x);
			      T53 = FMA(T1I, T1P, T1M * T1L);
			 }
			 {
			      E T1m, T4o, T1q, T4m;
			      {
				   E T1k, T1l, T1o, T1p;
				   T1k = Ip[WS(rs, 7)];
				   T1l = Im[WS(rs, 7)];
				   T1m = T1k - T1l;
				   T4o = T1k + T1l;
				   T1o = Rp[WS(rs, 7)];
				   T1p = Rm[WS(rs, 7)];
				   T1q = T1o + T1p;
				   T4m = T1o - T1p;
			      }
			      T1r = FNMS(T1n, T1q, T1j * T1m);
			      T5i = FNMS(T4n, T4m, T4l * T4o);
			      T4p = FMA(T4l, T4m, T4n * T4o);
			      T50 = FMA(T1j, T1q, T1n * T1m);
			 }
			 {
			      E T1y, T4s, T1E, T4r;
			      {
				   E T1w, T1x, T1C, T1D;
				   T1w = Ip[WS(rs, 3)];
				   T1x = Im[WS(rs, 3)];
				   T1y = T1w - T1x;
				   T4s = T1w + T1x;
				   T1C = Rp[WS(rs, 3)];
				   T1D = Rm[WS(rs, 3)];
				   T1E = T1C + T1D;
				   T4r = T1C - T1D;
			      }
			      T1F = FNMS(T1B, T1E, T1v * T1y);
			      T5k = FNMS(T26, T4r, T23 * T4s);
			      T4t = FMA(T23, T4r, T26 * T4s);
			      T52 = FMA(T1v, T1E, T1B * T1y);
			 }
			 T1s = T1a + T1r;
			 T1R = T1F + T1Q;
			 T65 = T1s - T1R;
			 T51 = T4Z + T50;
			 T54 = T52 + T53;
			 T64 = T51 - T54;
			 {
			      E T4q, T4z, T7E, T7F;
			      T4q = T4k + T4p;
			      T4z = T4t + T4y;
			      T4A = T4q + T4z;
			      T6g = T4z - T4q;
			      T7E = T5h - T5i;
			      T7F = T4y - T4t;
			      T7G = T7E + T7F;
			      T8U = T7E - T7F;
			 }
			 {
			      E T5j, T5m, T79, T7a;
			      T5j = T5h + T5i;
			      T5m = T5k + T5l;
			      T5n = T5j + T5m;
			      T6d = T5j - T5m;
			      T79 = T4Z - T50;
			      T7a = T1F - T1Q;
			      T7b = T79 + T7a;
			      T8J = T79 - T7a;
			 }
			 {
			      E T7x, T7y, T76, T77;
			      T7x = T4p - T4k;
			      T7y = T5k - T5l;
			      T7z = T7x - T7y;
			      T8R = T7x + T7y;
			      T76 = T1a - T1r;
			      T77 = T52 - T53;
			      T78 = T76 - T77;
			      T8I = T76 + T77;
			 }
		    }
		    {
			 E T1T, T5S, T5M, T5W, T5P, T5X, T3a, T5I, T4C, T58, T56, T5H, T5E, T5G, T4R;
			 E T5R;
			 {
			      E TX, T1S, T5K, T5L;
			      TX = Tv + TW;
			      T1S = T1s + T1R;
			      T1T = TX + T1S;
			      T5S = TX - T1S;
			      T5K = T5n - T5g;
			      T5L = T4b - T4A;
			      T5M = T5K + T5L;
			      T5W = T5K - T5L;
			 }
			 {
			      E T5N, T5O, T2A, T39;
			      T5N = T3T + T3A;
			      T5O = T5C - T5v;
			      T5P = T5N - T5O;
			      T5X = T5N + T5O;
			      T2A = T2g + T2z;
			      T39 = T2T + T38;
			      T3a = T2A + T39;
			      T5I = T39 - T2A;
			 }
			 {
			      E T3U, T4B, T4Y, T55;
			      T3U = T3A - T3T;
			      T4B = T4b + T4A;
			      T4C = T3U - T4B;
			      T58 = T4B + T3U;
			      T4Y = T4U + T4X;
			      T55 = T51 + T54;
			      T56 = T4Y + T55;
			      T5H = T55 - T4Y;
			 }
			 {
			      E T5o, T5D, T4J, T4Q;
			      T5o = T5g + T5n;
			      T5D = T5v + T5C;
			      T5E = T5o - T5D;
			      T5G = T5o + T5D;
			      T4J = T4F + T4I;
			      T4Q = T4M + T4P;
			      T4R = T4J + T4Q;
			      T5R = T4J - T4Q;
			 }
			 {
			      E T3b, T5F, T57, T59;
			      T3b = T1T + T3a;
			      Ip[0] = KP500000000 * (T3b + T4C);
			      Im[WS(rs, 15)] = KP500000000 * (T4C - T3b);
			      T5F = T4R + T56;
			      Rm[WS(rs, 15)] = KP500000000 * (T5F - T5G);
			      Rp[0] = KP500000000 * (T5F + T5G);
			      T57 = T4R - T56;
			      Rm[WS(rs, 7)] = KP500000000 * (T57 - T58);
			      Rp[WS(rs, 8)] = KP500000000 * (T57 + T58);
			      T59 = T3a - T1T;
			      Ip[WS(rs, 8)] = KP500000000 * (T59 + T5E);
			      Im[WS(rs, 7)] = KP500000000 * (T5E - T59);
			 }
			 {
			      E T5J, T5Q, T5Z, T60;
			      T5J = KP500000000 * (T5H + T5I);
			      T5Q = KP353553390 * (T5M + T5P);
			      Ip[WS(rs, 4)] = T5J + T5Q;
			      Im[WS(rs, 11)] = T5Q - T5J;
			      T5Z = KP500000000 * (T5R + T5S);
			      T60 = KP353553390 * (T5W + T5X);
			      Rm[WS(rs, 11)] = T5Z - T60;
			      Rp[WS(rs, 4)] = T5Z + T60;
			 }
			 {
			      E T5T, T5U, T5V, T5Y;
			      T5T = KP500000000 * (T5R - T5S);
			      T5U = KP353553390 * (T5P - T5M);
			      Rm[WS(rs, 3)] = T5T - T5U;
			      Rp[WS(rs, 12)] = T5T + T5U;
			      T5V = KP500000000 * (T5I - T5H);
			      T5Y = KP353553390 * (T5W - T5X);
			      Ip[WS(rs, 12)] = T5V + T5Y;
			      Im[WS(rs, 3)] = T5Y - T5V;
			 }
		    }
		    {
			 E T67, T6Q, T6K, T6U, T6N, T6V, T6a, T6G, T6i, T6A, T6t, T6P, T6w, T6F, T6p;
			 E T6B;
			 {
			      E T63, T66, T6I, T6J;
			      T63 = T61 - T62;
			      T66 = T64 + T65;
			      T67 = KP353553390 * (T63 + T66);
			      T6Q = KP353553390 * (T63 - T66);
			      T6I = T6d - T6c;
			      T6J = T6g - T6f;
			      T6K = FMA(KP461939766, T6I, KP191341716 * T6J);
			      T6U = FNMS(KP461939766, T6J, KP191341716 * T6I);
			 }
			 {
			      E T6L, T6M, T68, T69;
			      T6L = T6k - T6j;
			      T6M = T6n - T6m;
			      T6N = FNMS(KP461939766, T6M, KP191341716 * T6L);
			      T6V = FMA(KP461939766, T6L, KP191341716 * T6M);
			      T68 = T4P - T4M;
			      T69 = T38 - T2T;
			      T6a = KP500000000 * (T68 + T69);
			      T6G = KP500000000 * (T69 - T68);
			 }
			 {
			      E T6e, T6h, T6r, T6s;
			      T6e = T6c + T6d;
			      T6h = T6f + T6g;
			      T6i = FMA(KP191341716, T6e, KP461939766 * T6h);
			      T6A = FNMS(KP191341716, T6h, KP461939766 * T6e);
			      T6r = T4F - T4I;
			      T6s = T2g - T2z;
			      T6t = KP500000000 * (T6r + T6s);
			      T6P = KP500000000 * (T6r - T6s);
			 }
			 {
			      E T6u, T6v, T6l, T6o;
			      T6u = T62 + T61;
			      T6v = T64 - T65;
			      T6w = KP353553390 * (T6u + T6v);
			      T6F = KP353553390 * (T6v - T6u);
			      T6l = T6j + T6k;
			      T6o = T6m + T6n;
			      T6p = FNMS(KP191341716, T6o, KP461939766 * T6l);
			      T6B = FMA(KP191341716, T6l, KP461939766 * T6o);
			 }
			 {
			      E T6b, T6q, T6D, T6E;
			      T6b = T67 + T6a;
			      T6q = T6i + T6p;
			      Ip[WS(rs, 2)] = T6b + T6q;
			      Im[WS(rs, 13)] = T6q - T6b;
			      T6D = T6t + T6w;
			      T6E = T6A + T6B;
			      Rm[WS(rs, 13)] = T6D - T6E;
			      Rp[WS(rs, 2)] = T6D + T6E;
			 }
			 {
			      E T6x, T6y, T6z, T6C;
			      T6x = T6t - T6w;
			      T6y = T6p - T6i;
			      Rm[WS(rs, 5)] = T6x - T6y;
			      Rp[WS(rs, 10)] = T6x + T6y;
			      T6z = T6a - T67;
			      T6C = T6A - T6B;
			      Ip[WS(rs, 10)] = T6z + T6C;
			      Im[WS(rs, 5)] = T6C - T6z;
			 }
			 {
			      E T6H, T6O, T6X, T6Y;
			      T6H = T6F + T6G;
			      T6O = T6K + T6N;
			      Ip[WS(rs, 6)] = T6H + T6O;
			      Im[WS(rs, 9)] = T6O - T6H;
			      T6X = T6P + T6Q;
			      T6Y = T6U + T6V;
			      Rm[WS(rs, 9)] = T6X - T6Y;
			      Rp[WS(rs, 6)] = T6X + T6Y;
			 }
			 {
			      E T6R, T6S, T6T, T6W;
			      T6R = T6P - T6Q;
			      T6S = T6N - T6K;
			      Rm[WS(rs, 1)] = T6R - T6S;
			      Rp[WS(rs, 14)] = T6R + T6S;
			      T6T = T6G - T6F;
			      T6W = T6U - T6V;
			      Ip[WS(rs, 14)] = T6T + T6W;
			      Im[WS(rs, 1)] = T6W - T6T;
			 }
		    }
		    {
			 E T7d, T8w, T7o, T8m, T8c, T8l, T89, T8v, T81, T8B, T8h, T8t, T7I, T8A, T8g;
			 E T8q;
			 {
			      E T75, T7c, T85, T88;
			      T75 = FNMS(KP191341716, T74, KP461939766 * T71);
			      T7c = FMA(KP461939766, T78, KP191341716 * T7b);
			      T7d = T75 + T7c;
			      T8w = T75 - T7c;
			      {
				   E T7k, T7n, T8a, T8b;
				   T7k = KP353553390 * (T7g + T7j);
				   T7n = KP500000000 * (T7l - T7m);
				   T7o = T7k + T7n;
				   T8m = T7n - T7k;
				   T8a = FMA(KP191341716, T71, KP461939766 * T74);
				   T8b = FNMS(KP191341716, T78, KP461939766 * T7b);
				   T8c = T8a + T8b;
				   T8l = T8b - T8a;
			      }
			      T85 = KP500000000 * (T83 + T84);
			      T88 = KP353553390 * (T86 + T87);
			      T89 = T85 + T88;
			      T8v = T85 - T88;
			      {
				   E T7T, T8r, T80, T8s, T7P, T7W;
				   T7P = KP707106781 * (T7L + T7O);
				   T7T = T7P + T7S;
				   T8r = T7S - T7P;
				   T7W = KP707106781 * (T7U + T7V);
				   T80 = T7W + T7Z;
				   T8s = T7Z - T7W;
				   T81 = FNMS(KP097545161, T80, KP490392640 * T7T);
				   T8B = FMA(KP415734806, T8r, KP277785116 * T8s);
				   T8h = FMA(KP097545161, T7T, KP490392640 * T80);
				   T8t = FNMS(KP415734806, T8s, KP277785116 * T8r);
			      }
			      {
				   E T7A, T8o, T7H, T8p, T7w, T7D;
				   T7w = KP707106781 * (T7s + T7v);
				   T7A = T7w + T7z;
				   T8o = T7z - T7w;
				   T7D = KP707106781 * (T7B + T7C);
				   T7H = T7D + T7G;
				   T8p = T7G - T7D;
				   T7I = FMA(KP490392640, T7A, KP097545161 * T7H);
				   T8A = FNMS(KP415734806, T8o, KP277785116 * T8p);
				   T8g = FNMS(KP097545161, T7A, KP490392640 * T7H);
				   T8q = FMA(KP277785116, T8o, KP415734806 * T8p);
			      }
			 }
			 {
			      E T7p, T82, T8j, T8k;
			      T7p = T7d + T7o;
			      T82 = T7I + T81;
			      Ip[WS(rs, 1)] = T7p + T82;
			      Im[WS(rs, 14)] = T82 - T7p;
			      T8j = T89 + T8c;
			      T8k = T8g + T8h;
			      Rm[WS(rs, 14)] = T8j - T8k;
			      Rp[WS(rs, 1)] = T8j + T8k;
			 }
			 {
			      E T8d, T8e, T8f, T8i;
			      T8d = T89 - T8c;
			      T8e = T81 - T7I;
			      Rm[WS(rs, 6)] = T8d - T8e;
			      Rp[WS(rs, 9)] = T8d + T8e;
			      T8f = T7o - T7d;
			      T8i = T8g - T8h;
			      Ip[WS(rs, 9)] = T8f + T8i;
			      Im[WS(rs, 6)] = T8i - T8f;
			 }
			 {
			      E T8n, T8u, T8D, T8E;
			      T8n = T8l + T8m;
			      T8u = T8q + T8t;
			      Ip[WS(rs, 5)] = T8n + T8u;
			      Im[WS(rs, 10)] = T8u - T8n;
			      T8D = T8v + T8w;
			      T8E = T8A + T8B;
			      Rm[WS(rs, 10)] = T8D - T8E;
			      Rp[WS(rs, 5)] = T8D + T8E;
			 }
			 {
			      E T8x, T8y, T8z, T8C;
			      T8x = T8v - T8w;
			      T8y = T8t - T8q;
			      Rm[WS(rs, 2)] = T8x - T8y;
			      Rp[WS(rs, 13)] = T8x + T8y;
			      T8z = T8m - T8l;
			      T8C = T8A - T8B;
			      Ip[WS(rs, 13)] = T8z + T8C;
			      Im[WS(rs, 2)] = T8C - T8z;
			 }
		    }
		    {
			 E T8L, T9u, T8O, T9k, T9a, T9j, T97, T9t, T93, T9z, T9f, T9r, T8W, T9y, T9e;
			 E T9o;
			 {
			      E T8H, T8K, T95, T96;
			      T8H = FNMS(KP461939766, T8G, KP191341716 * T8F);
			      T8K = FMA(KP191341716, T8I, KP461939766 * T8J);
			      T8L = T8H + T8K;
			      T9u = T8H - T8K;
			      {
				   E T8M, T8N, T98, T99;
				   T8M = KP353553390 * (T87 - T86);
				   T8N = KP500000000 * (T7m + T7l);
				   T8O = T8M + T8N;
				   T9k = T8N - T8M;
				   T98 = FMA(KP461939766, T8F, KP191341716 * T8G);
				   T99 = FNMS(KP461939766, T8I, KP191341716 * T8J);
				   T9a = T98 + T99;
				   T9j = T99 - T98;
			      }
			      T95 = KP500000000 * (T83 - T84);
			      T96 = KP353553390 * (T7g - T7j);
			      T97 = T95 + T96;
			      T9t = T95 - T96;
			      {
				   E T8Z, T9p, T92, T9q, T8X, T90;
				   T8X = KP707106781 * (T7V - T7U);
				   T8Z = T8X + T8Y;
				   T9p = T8Y - T8X;
				   T90 = KP707106781 * (T7L - T7O);
				   T92 = T90 + T91;
				   T9q = T91 - T90;
				   T93 = FNMS(KP277785116, T92, KP415734806 * T8Z);
				   T9z = FMA(KP490392640, T9p, KP097545161 * T9q);
				   T9f = FMA(KP277785116, T8Z, KP415734806 * T92);
				   T9r = FNMS(KP490392640, T9q, KP097545161 * T9p);
			      }
			      {
				   E T8S, T9m, T8V, T9n, T8Q, T8T;
				   T8Q = KP707106781 * (T7C - T7B);
				   T8S = T8Q + T8R;
				   T9m = T8R - T8Q;
				   T8T = KP707106781 * (T7s - T7v);
				   T8V = T8T + T8U;
				   T9n = T8U - T8T;
				   T8W = FMA(KP415734806, T8S, KP277785116 * T8V);
				   T9y = FNMS(KP490392640, T9m, KP097545161 * T9n);
				   T9e = FNMS(KP277785116, T8S, KP415734806 * T8V);
				   T9o = FMA(KP097545161, T9m, KP490392640 * T9n);
			      }
			 }
			 {
			      E T8P, T94, T9h, T9i;
			      T8P = T8L + T8O;
			      T94 = T8W + T93;
			      Ip[WS(rs, 3)] = T8P + T94;
			      Im[WS(rs, 12)] = T94 - T8P;
			      T9h = T97 + T9a;
			      T9i = T9e + T9f;
			      Rm[WS(rs, 12)] = T9h - T9i;
			      Rp[WS(rs, 3)] = T9h + T9i;
			 }
			 {
			      E T9b, T9c, T9d, T9g;
			      T9b = T97 - T9a;
			      T9c = T93 - T8W;
			      Rm[WS(rs, 4)] = T9b - T9c;
			      Rp[WS(rs, 11)] = T9b + T9c;
			      T9d = T8O - T8L;
			      T9g = T9e - T9f;
			      Ip[WS(rs, 11)] = T9d + T9g;
			      Im[WS(rs, 4)] = T9g - T9d;
			 }
			 {
			      E T9l, T9s, T9B, T9C;
			      T9l = T9j + T9k;
			      T9s = T9o + T9r;
			      Ip[WS(rs, 7)] = T9l + T9s;
			      Im[WS(rs, 8)] = T9s - T9l;
			      T9B = T9t + T9u;
			      T9C = T9y + T9z;
			      Rm[WS(rs, 8)] = T9B - T9C;
			      Rp[WS(rs, 7)] = T9B + T9C;
			 }
			 {
			      E T9v, T9w, T9x, T9A;
			      T9v = T9t - T9u;
			      T9w = T9r - T9o;
			      Rm[0] = T9v - T9w;
			      Rp[WS(rs, 15)] = T9v + T9w;
			      T9x = T9k - T9j;
			      T9A = T9y - T9z;
			      Ip[WS(rs, 15)] = T9x + T9A;
			      Im[0] = T9A - T9x;
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 27},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cfdft2_32", twinstr, &GENUS, {440, 188, 112, 0} };

void X(codelet_hc2cfdft2_32) (planner *p) {
     X(khc2c_register) (p, hc2cfdft2_32, &desc, HC2C_VIA_DFT);
}
#endif				/* HAVE_FMA */
