
if (CHOLMOD_INCLUDES AND CHOLMOD_LIBRARIES)
  set(CHOLMOD_FIND_QUIETLY TRUE)
endif (CHOLMOD_INCLUDES AND CHOLMOD_LIBRARIES)

find_path(CHOLMOD_INCLUDES
  NAMES
  cholmod.h
  PATHS
  $ENV{CHOLMODDIR}
  ${INCLUDE_INSTALL_DIR}
  PATH_SUFFIXES
  suitesparse
)

find_library(CHOLMOD_LIBRARIES cholmod PATHS $ENV{CHOLMODDIR} ${LIB_INSTALL_DIR})

if(CHOLMOD_LIBRARIES)

  get_filename_component(CHOLMOD_LIBDIR ${CHOLMOD_LIBRARIES} PATH)

  find_library(AMD_LIBRARY amd PATHS ${CHOLMOD_LIBDIR} $ENV{CHOLMODDIR} ${LIB_INSTALL_DIR})
  if (AMD_LIBRARY)
    set(CHOLMOD_LIBRARIES ${CHOLMOD_LIBRARIES} ${AMD_LIBRARY})
  else (AMD_LIBRARY)
    set(CHOLMOD_LIBRARIES FALSE)
  endif (AMD_LIBRARY)

endif(CHOLMOD_LIBRARIES)

if(CHOLMOD_LIBRARIES)

  find_library(COLAMD_LIBRARY colamd PATHS ${CHOLMOD_LIBDIR} $ENV{CHOLMODDIR} ${LIB_INSTALL_DIR})
  if (COLAMD_LIBRARY)
    set(CHOLMOD_LIBRARIES ${CHOLMOD_LIBRARIES} ${COLAMD_LIBRARY})
  else (COLAMD_LIBRARY)
    set(CHOLMOD_LIBRARIES FALSE)
  endif (COLAMD_LIBRARY)

endif(CHOLMOD_LIBRARIES)

if(CHOLMOD_LIBRARIES)

  find_library(CAMD_LIBRARY camd PATHS ${CHOLMOD_LIBDIR} $ENV{CHOLMODDIR} ${LIB_INSTALL_DIR})
  if (CAMD_LIBRARY)
    set(CHOLMOD_LIBRARIES ${CHOLMOD_LIBRARIES} ${CAMD_LIBRARY})
  else (CAMD_LIBRARY)
    set(CHOLMOD_LIBRARIES FALSE)
  endif (CAMD_LIBRARY)

endif(CHOLMOD_LIBRARIES)

if(CHOLMOD_LIBRARIES)

  find_library(CCOLAMD_LIBRARY colamd PATHS ${CHOLMOD_LIBDIR} $ENV{CHOLMODDIR} ${LIB_INSTALL_DIR})
  if (CCOLAMD_LIBRARY)
    set(CHOLMOD_LIBRARIES ${CHOLMOD_LIBRARIES} ${CCOLAMD_LIBRARY})
  else (CCOLAMD_LIBRARY)
    set(CHOLMOD_LIBRARIES FALSE)
  endif (CCOLAMD_LIBRARY)

endif(CHOLMOD_LIBRARIES)

if(CHOLMOD_LIBRARIES AND CMAKE_COMPILER_IS_GNUCXX)
  set(CHOLMOD_LIBRARIES ${CHOLMOD_LIBRARIES} -lgfortran)
endif(CHOLMOD_LIBRARIES AND CMAKE_COMPILER_IS_GNUCXX)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(CHOLMOD DEFAULT_MSG
                                  CHOLMOD_INCLUDES CHOLMOD_LIBRARIES)

mark_as_advanced(CHOLMOD_INCLUDES CHOLMOD_LIBRARIES AMD_LIBRARY COLAMD_LIBRARY)
