package org.drools.ruleflow.core.impl;

/*
 * Copyright 2005 JBoss Inc
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.drools.ruleflow.core.RuleFlowProcessValidationError;

/**
 * Default implementation of a RuleFlow validation error.
 * 
 * @author <a href="mailto:kris_verlaenen@hotmail.com">Kris Verlaenen</a>
 */
public class RuleFlowProcessValidationErrorImpl
    implements
    RuleFlowProcessValidationError {

    private String type;
    private String text;

    public RuleFlowProcessValidationErrorImpl(final String type) {
        this.type = type;
    }

    public RuleFlowProcessValidationErrorImpl(final String type, String text) {
        this.type = type;
        this.text = text;
    }

    public String toString() {
        return this.type + (text == null ? "" : text);
    }

    public String getType() {
        return this.type;
    }
}
