# Copyright 2009-2010 Canonical Ltd.
#
# This file is part of desktopcouch-notes.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Nicola Larosa <nicola.larosa@canonical.com>
#          Rodrigo Moya <rodrigo.moya@canonical.com>
#          Vincenzo Di Somma <vincenzo.di.somma@canonical.com>

"""Tests for the NoteDocument class"""

from time import strftime, gmtime
from unittest import TestCase

from desktopcouch.recordtypes.notes import Note, NOTE_RECORD_TYPE

FIELDS = {
    # String fields
    'note_format': 'string',
    'title': 'string',
    'content': 'string',
    # Date fields
    'last_change_date': 'date',
    'create_date': 'date'}


class TestNoteRecord(TestCase):
    """Test the Note Record object."""

    def test_note_record(self):
        """Test that we get the correct record type."""
        note = Note()
        self.assertEqual(NOTE_RECORD_TYPE, note.record_type)
        for field_name in FIELDS:
            self.assert_(hasattr(note, field_name))
        now = gmtime()
        now_str = strftime("%Y-%m-%dT%H:%M:%S", now)
        note.last_change_date = now_str
        # For some reason that I ignore strptime and strftime return
        # different timezones so we remove the timezone value
        # before asserting equal
        self.assertEqual(now[0:-1], note.last_change_date[0:-1])
