# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Author: Manuel de la Pena <manuel.delapena@canonical.com>
"""Generilize the base dirs so that is multiplatform."""
import os

import xdg.BaseDirectory as xdg_base_dirs

CACHE_HOME = xdg_base_dirs.xdg_cache_home
CONFIG_HOME = xdg_base_dirs.xdg_config_home

# disable pylint because this are methods
# pylint: disable=C0103
save_config_path = xdg_base_dirs.save_config_path
save_data_path = xdg_base_dirs.save_data_path
# pylint: enable=C0103


def load_config_paths(ctx):
    """This is xdg/BaseDirectory.py load_config_paths() with hard-code to
    use desktop-couch resource and read from this context."""
    yield ctx.config_dir
    for config_dir in \
            os.environ.get('XDG_CONFIG_DIRS', '/etc/xdg').split(':'):
        path = os.path.join(config_dir, "desktop-couch")
        if os.path.exists(path):
            yield path
