/* OperationRestore.c generated by valac 0.12.1, the Vala compiler
 * generated from OperationRestore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;
typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;

#define DEJA_DUP_TYPE_OPERATION_RESTORE (deja_dup_operation_restore_get_type ())
#define DEJA_DUP_OPERATION_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestore))
#define DEJA_DUP_OPERATION_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestoreClass))
#define DEJA_DUP_IS_OPERATION_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE))
#define DEJA_DUP_IS_OPERATION_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION_RESTORE))
#define DEJA_DUP_OPERATION_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestoreClass))

typedef struct _DejaDupOperationRestore DejaDupOperationRestore;
typedef struct _DejaDupOperationRestoreClass DejaDupOperationRestoreClass;
typedef struct _DejaDupOperationRestorePrivate DejaDupOperationRestorePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupOperationRestoreStartData DejaDupOperationRestoreStartData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define DEJA_DUP_TYPE_TIMESTAMP_TYPE (deja_dup_timestamp_type_get_type ())
typedef struct _DejaDupOperationRestoreOperationFinishedData DejaDupOperationRestoreOperationFinishedData;

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupDuplicity* dup;
	gchar* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	void (*connect_to_dup) (DejaDupOperation* self);
	void (*operation_finished) (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*operation_finished_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	GList* (*make_argv) (DejaDupOperation* self, GError** error);
};

struct _DejaDupOperationRestore {
	DejaDupOperation parent_instance;
	DejaDupOperationRestorePrivate * priv;
};

struct _DejaDupOperationRestoreClass {
	DejaDupOperationClass parent_class;
};

struct _DejaDupOperationRestorePrivate {
	gchar* _dest;
	gchar* _time;
	GList* _restore_files;
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST,
	DEJA_DUP_OPERATION_MODE_FILEHISTORY
} DejaDupOperationMode;

struct _DejaDupOperationRestoreStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperationRestore* self;
	const gchar* _tmp0_;
};

typedef enum  {
	DEJA_DUP_TIMESTAMP_TYPE_NONE,
	DEJA_DUP_TIMESTAMP_TYPE_BACKUP,
	DEJA_DUP_TIMESTAMP_TYPE_RESTORE
} DejaDupTimestampType;

struct _DejaDupOperationRestoreOperationFinishedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperationRestore* self;
	DejaDupDuplicity* dup;
	gboolean success;
	gboolean cancelled;
};


static gpointer deja_dup_operation_restore_parent_class = NULL;

GType deja_dup_operation_get_type (void) G_GNUC_CONST;
GType deja_dup_duplicity_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_restore_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestorePrivate))
enum  {
	DEJA_DUP_OPERATION_RESTORE_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_RESTORE_DEST,
	DEJA_DUP_OPERATION_RESTORE_TIME,
	DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
DejaDupOperationRestore* deja_dup_operation_restore_new (const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid);
DejaDupOperationRestore* deja_dup_operation_restore_construct (GType object_type, const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid);
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
static void deja_dup_operation_restore_real_start_data_free (gpointer _data);
static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_operation_restore_real_start_co (DejaDupOperationRestoreStartData* data);
void deja_dup_operation_start (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_start_finish (DejaDupOperation* self, GAsyncResult* _res_);
static void deja_dup_operation_restore_real_connect_to_dup (DejaDupOperation* base);
void deja_dup_operation_connect_to_dup (DejaDupOperation* self);
GList* deja_dup_operation_restore_get_restore_files (DejaDupOperationRestore* self);
void deja_dup_duplicity_set_restore_files (DejaDupDuplicity* self, GList* value);
static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error);
const gchar* deja_dup_operation_restore_get_time (DejaDupOperationRestore* self);
const gchar* deja_dup_operation_restore_get_dest (DejaDupOperationRestore* self);
void deja_dup_duplicity_set_local (DejaDupDuplicity* self, GFile* value);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void deja_dup_operation_restore_real_operation_finished_data_free (gpointer _data);
static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_operation_restore_real_operation_finished_co (DejaDupOperationRestoreOperationFinishedData* data);
GType deja_dup_timestamp_type_get_type (void) G_GNUC_CONST;
void deja_dup_update_last_run_timestamp (DejaDupTimestampType type);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_);
static void deja_dup_operation_restore_set_dest (DejaDupOperationRestore* self, const gchar* value);
static void deja_dup_operation_restore_set_time (DejaDupOperationRestore* self, const gchar* value);
static void deja_dup_operation_restore_set_restore_files (DejaDupOperationRestore* self, GList* value);
static void deja_dup_operation_restore_finalize (GObject* obj);
static void _vala_deja_dup_operation_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_operation_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


DejaDupOperationRestore* deja_dup_operation_restore_construct (GType object_type, const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid) {
	DejaDupOperationRestore * self = NULL;
	g_return_val_if_fail (dest_in != NULL, NULL);
	self = (DejaDupOperationRestore*) g_object_new (object_type, "xid", xid, "dest", dest_in, "time", time_in, "restore-files", files_in, "mode", DEJA_DUP_OPERATION_MODE_RESTORE, NULL);
	return self;
}


DejaDupOperationRestore* deja_dup_operation_restore_new (const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid) {
	return deja_dup_operation_restore_construct (DEJA_DUP_TYPE_OPERATION_RESTORE, dest_in, time_in, files_in, xid);
}


static void deja_dup_operation_restore_real_start_data_free (gpointer _data) {
	DejaDupOperationRestoreStartData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupOperationRestoreStartData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationRestore * self;
	DejaDupOperationRestoreStartData* _data_;
	self = (DejaDupOperationRestore*) base;
	_data_ = g_slice_new0 (DejaDupOperationRestoreStartData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_restore_real_start);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_restore_real_start_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_operation_restore_real_start_co (_data_);
}


static void deja_dup_operation_restore_real_start_finish (DejaDupOperation* base, GAsyncResult* _res_) {
	DejaDupOperationRestoreStartData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_operation_restore_real_start_co (DejaDupOperationRestoreStartData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = _ ("Restoring files…");
	g_signal_emit_by_name ((DejaDupOperation*) data->self, "action-desc-changed", data->_tmp0_);
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->start (DEJA_DUP_OPERATION (data->self), NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_operation_restore_real_connect_to_dup (DejaDupOperation* base) {
	DejaDupOperationRestore * self;
	GList* _tmp0_ = NULL;
	self = (DejaDupOperationRestore*) base;
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->connect_to_dup (DEJA_DUP_OPERATION (self));
	_tmp0_ = deja_dup_operation_restore_get_restore_files (self);
	deja_dup_duplicity_set_restore_files (((DejaDupOperation*) self)->dup, _tmp0_);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error) {
	DejaDupOperationRestore * self;
	GList* result = NULL;
	GList* argv;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	self = (DejaDupOperationRestore*) base;
	argv = NULL;
	if (self->priv->_time != NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup_printf ("--restore-time=%s", self->priv->_time);
		argv = g_list_append (argv, _tmp0_);
	}
	_tmp1_ = g_file_new_for_path (self->priv->_dest);
	_tmp2_ = _tmp1_;
	deja_dup_duplicity_set_local (((DejaDupOperation*) self)->dup, _tmp2_);
	_g_object_unref0 (_tmp2_);
	result = argv;
	return result;
}


static void deja_dup_operation_restore_real_operation_finished_data_free (gpointer _data) {
	DejaDupOperationRestoreOperationFinishedData* data;
	data = _data;
	_g_object_unref0 (data->dup);
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupOperationRestoreOperationFinishedData, data);
}


static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationRestore * self;
	DejaDupOperationRestoreOperationFinishedData* _data_;
	self = (DejaDupOperationRestore*) base;
	_data_ = g_slice_new0 (DejaDupOperationRestoreOperationFinishedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_restore_real_operation_finished);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_restore_real_operation_finished_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->dup = _g_object_ref0 (dup);
	_data_->success = success;
	_data_->cancelled = cancelled;
	deja_dup_operation_restore_real_operation_finished_co (_data_);
}


static void deja_dup_operation_restore_real_operation_finished_finish (DejaDupOperation* base, GAsyncResult* _res_) {
	DejaDupOperationRestoreOperationFinishedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_operation_restore_real_operation_finished_co (DejaDupOperationRestoreOperationFinishedData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->success) {
		deja_dup_update_last_run_timestamp (DEJA_DUP_TIMESTAMP_TYPE_RESTORE);
	}
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->operation_finished (DEJA_DUP_OPERATION (data->self), data->dup, data->success, data->cancelled, NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


const gchar* deja_dup_operation_restore_get_dest (DejaDupOperationRestore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dest;
	return result;
}


static void deja_dup_operation_restore_set_dest (DejaDupOperationRestore* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dest);
	self->priv->_dest = _tmp0_;
	g_object_notify ((GObject *) self, "dest");
}


const gchar* deja_dup_operation_restore_get_time (DejaDupOperationRestore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_time;
	return result;
}


static void deja_dup_operation_restore_set_time (DejaDupOperationRestore* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_time);
	self->priv->_time = _tmp0_;
	g_object_notify ((GObject *) self, "time");
}


GList* deja_dup_operation_restore_get_restore_files (DejaDupOperationRestore* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_restore_files;
	return result;
}


static void deja_dup_operation_restore_set_restore_files (DejaDupOperationRestore* self, GList* value) {
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp0_;
			GFile* f;
			_tmp0_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp0_;
			{
				g_object_unref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	_tmp1_ = g_list_copy (value);
	__g_list_free__g_object_unref0_0 (self->priv->_restore_files);
	self->priv->_restore_files = _tmp1_;
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp2_;
			GFile* f;
			_tmp2_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp2_;
			{
				g_object_ref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static void deja_dup_operation_restore_class_init (DejaDupOperationRestoreClass * klass) {
	deja_dup_operation_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationRestorePrivate));
	DEJA_DUP_OPERATION_CLASS (klass)->start = deja_dup_operation_restore_real_start;
	DEJA_DUP_OPERATION_CLASS (klass)->start_finish = deja_dup_operation_restore_real_start_finish;
	DEJA_DUP_OPERATION_CLASS (klass)->connect_to_dup = deja_dup_operation_restore_real_connect_to_dup;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_restore_real_make_argv;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_restore_real_operation_finished;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished_finish = deja_dup_operation_restore_real_operation_finished_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_operation_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_operation_restore_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_restore_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_DEST, g_param_spec_string ("dest", "dest", "dest", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_TIME, g_param_spec_string ("time", "time", "time", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_operation_restore_instance_init (DejaDupOperationRestore * self) {
	self->priv = DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE (self);
}


static void deja_dup_operation_restore_finalize (GObject* obj) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (obj);
	_g_free0 (self->priv->_dest);
	_g_free0 (self->priv->_time);
	__g_list_free__g_object_unref0_0 (self->priv->_restore_files);
	G_OBJECT_CLASS (deja_dup_operation_restore_parent_class)->finalize (obj);
}


GType deja_dup_operation_restore_get_type (void) {
	static volatile gsize deja_dup_operation_restore_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_restore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationRestore), 0, (GInstanceInitFunc) deja_dup_operation_restore_instance_init, NULL };
		GType deja_dup_operation_restore_type_id;
		deja_dup_operation_restore_type_id = g_type_register_static (DEJA_DUP_TYPE_OPERATION, "DejaDupOperationRestore", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_operation_restore_type_id__volatile, deja_dup_operation_restore_type_id);
	}
	return deja_dup_operation_restore_type_id__volatile;
}


static void _vala_deja_dup_operation_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_DEST:
		g_value_set_string (value, deja_dup_operation_restore_get_dest (self));
		break;
		case DEJA_DUP_OPERATION_RESTORE_TIME:
		g_value_set_string (value, deja_dup_operation_restore_get_time (self));
		break;
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, deja_dup_operation_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_operation_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_DEST:
		deja_dup_operation_restore_set_dest (self, g_value_get_string (value));
		break;
		case DEJA_DUP_OPERATION_RESTORE_TIME:
		deja_dup_operation_restore_set_time (self, g_value_get_string (value));
		break;
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		deja_dup_operation_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



