/* DuplicityInfo.c generated by valac 0.12.1, the Vala compiler
 * generated from DuplicityInfo.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
typedef struct _DejaDupDuplicityInfoPrivate DejaDupDuplicityInfoPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DejaDupDuplicityInfo {
	GObject parent_instance;
	DejaDupDuplicityInfoPrivate * priv;
};

struct _DejaDupDuplicityInfoClass {
	GObjectClass parent_class;
};

struct _DejaDupDuplicityInfoPrivate {
	gboolean _reports_encryption;
	gchar* version_string;
	gint major;
	gint minor;
	gint micro;
};


static gpointer deja_dup_duplicity_info_parent_class = NULL;
static DejaDupDuplicityInfo* deja_dup_duplicity_info_info;
static DejaDupDuplicityInfo* deja_dup_duplicity_info_info = NULL;

GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoPrivate))
enum  {
	DEJA_DUP_DUPLICITY_INFO_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INFO_REPORTS_ENCRYPTION
};
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR 0
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR 6
#define DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO 14
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
DejaDupDuplicityInfo* deja_dup_duplicity_info_new (void);
DejaDupDuplicityInfo* deja_dup_duplicity_info_construct (GType object_type);
gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, gchar** header, gchar** msg);
static void deja_dup_duplicity_info_set_missing_duplicity_error (DejaDupDuplicityInfo* self, gchar** header, gchar** msg, const gchar* msg_in);
static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_set_bad_version_error (DejaDupDuplicityInfo* self, gchar** header, gchar** msg);
static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic);
gboolean deja_dup_duplicity_info_get_reports_encryption (DejaDupDuplicityInfo* self);
static void deja_dup_duplicity_info_set_reports_encryption (DejaDupDuplicityInfo* self, gboolean value);
static void deja_dup_duplicity_info_finalize (GObject* obj);
static void _vala_deja_dup_duplicity_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_duplicity_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void) {
	DejaDupDuplicityInfo* result = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	if (deja_dup_duplicity_info_info == NULL) {
		DejaDupDuplicityInfo* _tmp0_ = NULL;
		_tmp0_ = deja_dup_duplicity_info_new ();
		_g_object_unref0 (deja_dup_duplicity_info_info);
		deja_dup_duplicity_info_info = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (deja_dup_duplicity_info_info);
	result = _tmp1_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean deja_dup_duplicity_info_check_duplicity_version (DejaDupDuplicityInfo* self, gchar** header, gchar** msg) {
	gchar* _header = NULL;
	gchar* _msg = NULL;
	gboolean result = FALSE;
	gchar* output = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** ver_tokens;
	gint ver_tokens_length1;
	gint _ver_tokens_size_;
	gboolean _tmp12_ = FALSE;
	gint _tmp15_;
	gboolean _tmp18_;
	gboolean good_enough;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_spawn_command_line_sync ("duplicity --version", &_tmp0_, NULL, NULL, &_inner_error_);
	_g_free0 (output);
	output = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch29_g_error;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError * e;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		deja_dup_duplicity_info_set_missing_duplicity_error (self, &_tmp1_, &_tmp2_, e->message);
		_g_free0 (_header);
		_header = _tmp1_;
		_g_free0 (_msg);
		_msg = _tmp2_;
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (output);
		if (header) {
			*header = _header;
		} else {
			_g_free0 (_header);
		}
		if (msg) {
			*msg = _msg;
		} else {
			_g_free0 (_msg);
		}
		return result;
	}
	__finally29:
	if (_inner_error_ != NULL) {
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp4_ = _tmp3_ = g_strsplit (output, " ", 2);
	tokens = _tmp4_;
	tokens_length1 = _vala_array_length (_tmp3_);
	_tokens_size_ = _vala_array_length (_tmp3_);
	if (tokens == NULL) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = tokens[0] == NULL;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = tokens[1] == NULL;
	}
	if (_tmp5_) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		deja_dup_duplicity_info_set_missing_duplicity_error (self, &_tmp7_, &_tmp8_, NULL);
		_g_free0 (_header);
		_header = _tmp7_;
		_g_free0 (_msg);
		_msg = _tmp8_;
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		if (header) {
			*header = _header;
		} else {
			_g_free0 (_header);
		}
		if (msg) {
			*msg = _msg;
		} else {
			_g_free0 (_msg);
		}
		return result;
	}
	_tmp9_ = string_strip (tokens[1]);
	_g_free0 (self->priv->version_string);
	self->priv->version_string = _tmp9_;
	_tmp11_ = _tmp10_ = g_strsplit (self->priv->version_string, ".", 0);
	ver_tokens = _tmp11_;
	ver_tokens_length1 = _vala_array_length (_tmp10_);
	_ver_tokens_size_ = _vala_array_length (_tmp10_);
	if (ver_tokens == NULL) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = ver_tokens[0] == NULL;
	}
	if (_tmp12_) {
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		deja_dup_duplicity_info_set_missing_duplicity_error (self, &_tmp13_, &_tmp14_, NULL);
		_g_free0 (_header);
		_header = _tmp13_;
		_g_free0 (_msg);
		_msg = _tmp14_;
		result = FALSE;
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		if (header) {
			*header = _header;
		} else {
			_g_free0 (_header);
		}
		if (msg) {
			*msg = _msg;
		} else {
			_g_free0 (_msg);
		}
		return result;
	}
	_tmp15_ = atoi (ver_tokens[0]);
	self->priv->major = _tmp15_;
	if (ver_tokens[1] != NULL) {
		gint _tmp16_;
		_tmp16_ = atoi (ver_tokens[1]);
		self->priv->minor = _tmp16_;
		if (ver_tokens[2] != NULL) {
			gint _tmp17_;
			_tmp17_ = atoi (ver_tokens[2]);
			self->priv->micro = _tmp17_;
		}
	}
	_tmp18_ = deja_dup_duplicity_info_meets_requirements (self);
	good_enough = _tmp18_;
	if (!good_enough) {
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		deja_dup_duplicity_info_set_bad_version_error (self, &_tmp19_, &_tmp20_);
		_g_free0 (_header);
		_header = _tmp19_;
		_g_free0 (_msg);
		_msg = _tmp20_;
		result = FALSE;
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (output);
		if (header) {
			*header = _header;
		} else {
			_g_free0 (_header);
		}
		if (msg) {
			*msg = _msg;
		} else {
			_g_free0 (_msg);
		}
		return result;
	}
	result = TRUE;
	ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (output);
	if (header) {
		*header = _header;
	} else {
		_g_free0 (_header);
	}
	if (msg) {
		*msg = _msg;
	} else {
		_g_free0 (_msg);
	}
	return result;
}


static gboolean deja_dup_duplicity_info_meets_version (DejaDupDuplicityInfo* self, gint vmaj, gint vmin, gint vmic) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->major > vmaj) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->major == vmaj) {
			_tmp2_ = self->priv->minor > vmin;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (self->priv->major == vmaj) {
			_tmp4_ = self->priv->minor == vmin;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = self->priv->micro >= vmic;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}


static gboolean deja_dup_duplicity_info_meets_requirements (DejaDupDuplicityInfo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_duplicity_info_meets_version (self, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO);
	result = _tmp0_;
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static void deja_dup_duplicity_info_set_missing_duplicity_error (DejaDupDuplicityInfo* self, gchar** header, gchar** msg, const gchar* msg_in) {
	gchar* _header = NULL;
	gchar* _msg = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Could not run duplicity");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_header);
	_header = _tmp1_;
	_tmp2_ = g_strdup (msg_in);
	_g_free0 (_msg);
	_msg = _tmp2_;
	if (_msg != NULL) {
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = string_chomp (_msg);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "\n\n", NULL);
		_g_free0 (_msg);
		_msg = _tmp5_;
		_g_free0 (_tmp4_);
	} else {
		if (self->priv->version_string == NULL) {
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = _ ("Could not understand duplicity version.\n\n");
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (_msg);
			_msg = _tmp7_;
		} else {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp8_ = _ ("Could not understand duplicity version ‘%s’.\n\n");
			_tmp9_ = g_strdup_printf (_tmp8_, self->priv->version_string);
			_g_free0 (_msg);
			_msg = _tmp9_;
		}
	}
	_tmp10_ = _ ("Without duplicity, Déjà Dup Backup Tool cannot function. It will close" \
" now.");
	_tmp11_ = g_strconcat (_msg, _tmp10_, NULL);
	_g_free0 (_msg);
	_msg = _tmp11_;
	if (header) {
		*header = _header;
	} else {
		_g_free0 (_header);
	}
	if (msg) {
		*msg = _msg;
	} else {
		_g_free0 (_msg);
	}
}


static void deja_dup_duplicity_info_set_bad_version_error (DejaDupDuplicityInfo* self, gchar** header, gchar** msg) {
	gchar* _header = NULL;
	gchar* _msg = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Duplicity’s version is too old");
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_header);
	_header = _tmp1_;
	_tmp2_ = _ ("Déjà Dup Backup Tool requires at least version %d.%d.%.2d of duplicity" \
", but only found version %d.%d.%.2d");
	_tmp3_ = g_strdup_printf (_tmp2_, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MAJOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MINOR, DEJA_DUP_DUPLICITY_INFO_REQUIRED_MICRO, self->priv->major, self->priv->minor, self->priv->micro);
	_g_free0 (_msg);
	_msg = _tmp3_;
	if (header) {
		*header = _header;
	} else {
		_g_free0 (_header);
	}
	if (msg) {
		*msg = _msg;
	} else {
		_g_free0 (_msg);
	}
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_construct (GType object_type) {
	DejaDupDuplicityInfo * self = NULL;
	self = (DejaDupDuplicityInfo*) g_object_new (object_type, NULL);
	return self;
}


DejaDupDuplicityInfo* deja_dup_duplicity_info_new (void) {
	return deja_dup_duplicity_info_construct (DEJA_DUP_TYPE_DUPLICITY_INFO);
}


gboolean deja_dup_duplicity_info_get_reports_encryption (DejaDupDuplicityInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_reports_encryption;
	return result;
}


static void deja_dup_duplicity_info_set_reports_encryption (DejaDupDuplicityInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_reports_encryption = value;
	g_object_notify ((GObject *) self, "reports-encryption");
}


static void deja_dup_duplicity_info_class_init (DejaDupDuplicityInfoClass * klass) {
	deja_dup_duplicity_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_duplicity_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_duplicity_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INFO_REPORTS_ENCRYPTION, g_param_spec_boolean ("reports-encryption", "reports-encryption", "reports-encryption", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void deja_dup_duplicity_info_instance_init (DejaDupDuplicityInfo * self) {
	self->priv = DEJA_DUP_DUPLICITY_INFO_GET_PRIVATE (self);
	self->priv->_reports_encryption = FALSE;
	self->priv->version_string = NULL;
	self->priv->major = 0;
	self->priv->minor = 0;
	self->priv->micro = 0;
}


static void deja_dup_duplicity_info_finalize (GObject* obj) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (obj);
	_g_free0 (self->priv->version_string);
	G_OBJECT_CLASS (deja_dup_duplicity_info_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_info_get_type (void) {
	static volatile gsize deja_dup_duplicity_info_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_duplicity_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInfo), 0, (GInstanceInitFunc) deja_dup_duplicity_info_instance_init, NULL };
		GType deja_dup_duplicity_info_type_id;
		deja_dup_duplicity_info_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInfo", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_duplicity_info_type_id__volatile, deja_dup_duplicity_info_type_id);
	}
	return deja_dup_duplicity_info_type_id__volatile;
}


static void _vala_deja_dup_duplicity_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_REPORTS_ENCRYPTION:
		g_value_set_boolean (value, deja_dup_duplicity_info_get_reports_encryption (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_duplicity_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInfo * self;
	self = DEJA_DUP_DUPLICITY_INFO (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INFO_REPORTS_ENCRYPTION:
		deja_dup_duplicity_info_set_reports_encryption (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



