/* Preferences.c generated by valac 0.12.1, the Vala compiler
 * generated from Preferences.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <common.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <atk/atk.h>
#include <widgets.h>


#define DEJA_DUP_TYPE_PREFERENCES (deja_dup_preferences_get_type ())
#define DEJA_DUP_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_PREFERENCES, DejaDupPreferences))
#define DEJA_DUP_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_PREFERENCES, DejaDupPreferencesClass))
#define DEJA_DUP_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_PREFERENCES))
#define DEJA_DUP_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_PREFERENCES))
#define DEJA_DUP_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_PREFERENCES, DejaDupPreferencesClass))

typedef struct _DejaDupPreferences DejaDupPreferences;
typedef struct _DejaDupPreferencesClass DejaDupPreferencesClass;
typedef struct _DejaDupPreferencesPrivate DejaDupPreferencesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;

struct _DejaDupPreferences {
	GtkGrid parent_instance;
	DejaDupPreferencesPrivate * priv;
};

struct _DejaDupPreferencesClass {
	GtkGridClass parent_class;
};

struct _DejaDupPreferencesPrivate {
	GtkWidget* backup_button;
	GtkWidget* restore_button;
	guint bus_watch_id;
};

struct _Block1Data {
	int _ref_count_;
	DejaDupPreferences * self;
	GtkAlignment* page;
};

struct _Block2Data {
	int _ref_count_;
	DejaDupPreferences * self;
	GtkNotebook* notebook;
	GtkListStore* cat_model;
	GtkTreeView* tree;
};


static gpointer deja_dup_preferences_parent_class = NULL;

GType deja_dup_preferences_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_PREFERENCES, DejaDupPreferencesPrivate))
enum  {
	DEJA_DUP_PREFERENCES_DUMMY_PROPERTY
};
static GtkWidget* deja_dup_preferences_make_welcome_page (DejaDupPreferences* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (GtkButton* b, DejaDupPreferences* self);
static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda1_ (Block1Data* _data1_);
static GtkWidget* deja_dup_preferences_make_settings_page (DejaDupPreferences* self);
static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda2_ (Block2Data* _data2_);
static void __lambda2__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void _lambda3_ (GtkButton* b, DejaDupPreferences* self);
static void __lambda3__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda4_ (GtkButton* b, DejaDupPreferences* self);
static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda5_ (DejaDupPreferences* self);
static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda6_ (DejaDupPreferences* self);
static void __lambda6__gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void _lambda7_ (DejaDupPreferences* self);
static void __lambda7__gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static gboolean deja_dup_preferences_should_show_welcome (DejaDupPreferences* self);
DejaDupPreferences* deja_dup_preferences_new (void);
DejaDupPreferences* deja_dup_preferences_construct (GType object_type);
static GObject * deja_dup_preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_preferences_finalize (GObject* obj);


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->page);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (GtkButton* b, DejaDupPreferences* self) {
	GdkDisplay* _tmp0_ = NULL;
	GdkAppLaunchContext* _tmp1_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) b);
	_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
	deja_dup_run_deja_dup ("--restore", (GAppLaunchContext*) _tmp1_, NULL);
}


static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (Block1Data* _data1_) {
	DejaDupPreferences * self;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_;
	self = _data1_->self;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	deja_dup_simple_settings_set_boolean (settings, DEJA_DUP_WELCOMED_KEY, TRUE);
	gtk_container_remove ((GtkContainer*) self, (GtkWidget*) _data1_->page);
	_tmp1_ = deja_dup_preferences_make_settings_page (self);
	_tmp2_ = _tmp1_;
	gtk_container_add ((GtkContainer*) self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (settings);
}


static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda1_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkWidget* deja_dup_preferences_make_welcome_page (DejaDupPreferences* self) {
	GtkWidget* result = NULL;
	Block1Data* _data1_;
	GtkAlignment* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* restore_button;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	GtkLabel* restore_label;
	GtkButton* _tmp7_ = NULL;
	GtkButton* continue_button;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_;
	GtkLabel* continue_label;
	GtkButtonBox* _tmp13_ = NULL;
	GtkButtonBox* bbox;
	GtkAlignment* _tmp14_ = NULL;
	GtkAlignment* balign;
	GtkImage* _tmp15_ = NULL;
	GtkImage* icon;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_;
	GtkLabel* label;
	GtkBox* _tmp21_ = NULL;
	GtkBox* ibox;
	GtkAlignment* _tmp22_ = NULL;
	GtkAlignment* ialign;
	GtkBox* _tmp23_ = NULL;
	GtkBox* hbox;
	GtkWidget* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 1.0f, 0.0f);
	_data1_->page = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkButton*) gtk_button_new ();
	restore_button = g_object_ref_sink (_tmp1_);
	g_signal_connect_object (restore_button, "clicked", (GCallback) __lambda0__gtk_button_clicked, self, 0);
	_tmp2_ = _ ("I want to _restore files from a previous backup…");
	_tmp3_ = g_strdup_printf ("<big>%s</big>", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	_tmp6_ = g_object_ref_sink (_tmp5_);
	_g_free0 (_tmp4_);
	restore_label = _tmp6_;
	g_object_set ((GObject*) restore_label, "mnemonic-widget", restore_button, "wrap", TRUE, "justify", GTK_JUSTIFY_CENTER, "xpad", 6, "ypad", 6, "width-request", 300, "use-markup", TRUE, "use-underline", TRUE, NULL);
	gtk_container_add ((GtkContainer*) restore_button, (GtkWidget*) restore_label);
	_tmp7_ = (GtkButton*) gtk_button_new ();
	continue_button = g_object_ref_sink (_tmp7_);
	g_signal_connect_data (continue_button, "clicked", (GCallback) __lambda1__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp8_ = _ ("Just show my backup _settings");
	_tmp9_ = g_strdup_printf ("<big>%s</big>", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_g_free0 (_tmp10_);
	continue_label = _tmp12_;
	g_object_set ((GObject*) continue_label, "mnemonic-widget", continue_button, "wrap", TRUE, "justify", GTK_JUSTIFY_CENTER, "xpad", 6, "ypad", 6, "width-request", 300, "use-markup", TRUE, "use-underline", TRUE, NULL);
	gtk_container_add ((GtkContainer*) continue_button, (GtkWidget*) continue_label);
	_tmp13_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_VERTICAL);
	bbox = g_object_ref_sink (_tmp13_);
	gtk_box_set_spacing ((GtkBox*) bbox, 24);
	g_object_set (bbox, "layout-style", GTK_BUTTONBOX_CENTER, NULL);
	gtk_container_add ((GtkContainer*) bbox, (GtkWidget*) restore_button);
	gtk_container_add ((GtkContainer*) bbox, (GtkWidget*) continue_button);
	_tmp14_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	balign = g_object_ref_sink (_tmp14_);
	gtk_container_add ((GtkContainer*) balign, (GtkWidget*) bbox);
	_tmp15_ = (GtkImage*) gtk_image_new ();
	icon = g_object_ref_sink (_tmp15_);
	g_object_set ((GObject*) icon, "icon-name", "deja-dup", "pixel-size", 256, NULL);
	_tmp16_ = _ ("Déjà Dup Backup Tool");
	_tmp17_ = g_strdup_printf ("<b><big>%s</big></b>", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	_tmp20_ = g_object_ref_sink (_tmp19_);
	_g_free0 (_tmp18_);
	label = _tmp20_;
	g_object_set ((GObject*) label, "wrap", TRUE, "justify", GTK_JUSTIFY_CENTER, "use-markup", TRUE, NULL);
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	ibox = g_object_ref_sink (_tmp21_);
	gtk_box_pack_start (ibox, (GtkWidget*) icon, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (ibox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp22_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	ialign = g_object_ref_sink (_tmp22_);
	gtk_container_add ((GtkContainer*) ialign, (GtkWidget*) ibox);
	_tmp23_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	hbox = g_object_ref_sink (_tmp23_);
	g_object_set ((GObject*) hbox, "homogeneous", TRUE, NULL);
	gtk_box_pack_start (hbox, (GtkWidget*) ialign, TRUE, FALSE, (guint) 0);
	gtk_box_pack_start (hbox, (GtkWidget*) balign, TRUE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) _data1_->page, (GtkWidget*) hbox);
	g_object_set ((GObject*) continue_button, "has-focus", TRUE, NULL);
	gtk_container_set_border_width ((GtkContainer*) _data1_->page, (guint) 24);
	gtk_widget_show ((GtkWidget*) _data1_->page);
	_tmp24_ = _g_object_ref0 ((GtkWidget*) _data1_->page);
	result = _tmp24_;
	_g_object_unref0 (hbox);
	_g_object_unref0 (ialign);
	_g_object_unref0 (ibox);
	_g_object_unref0 (label);
	_g_object_unref0 (icon);
	_g_object_unref0 (balign);
	_g_object_unref0 (bbox);
	_g_object_unref0 (continue_label);
	_g_object_unref0 (continue_button);
	_g_object_unref0 (restore_label);
	_g_object_unref0 (restore_button);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->tree);
		_g_object_unref0 (_data2_->cat_model);
		_g_object_unref0 (_data2_->notebook);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda2_ (Block2Data* _data2_) {
	DejaDupPreferences * self;
	GtkTreeIter sel_iter = {0};
	gint page = 0;
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	self = _data2_->self;
	_tmp0_ = gtk_tree_view_get_selection (_data2_->tree);
	_tmp2_ = gtk_tree_selection_get_selected (_tmp0_, NULL, &_tmp1_);
	sel_iter = _tmp1_;
	if (_tmp2_) {
		gtk_tree_model_get ((GtkTreeModel*) _data2_->cat_model, &sel_iter, 1, &page, -1);
		g_object_set (_data2_->notebook, "page", page, NULL);
	}
}


static void __lambda2__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	_lambda2_ (self);
}


static void _lambda3_ (GtkButton* b, DejaDupPreferences* self) {
	GdkDisplay* _tmp0_ = NULL;
	GdkAppLaunchContext* _tmp1_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) b);
	_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
	deja_dup_run_deja_dup ("--restore", (GAppLaunchContext*) _tmp1_, NULL);
}


static void __lambda3__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _lambda4_ (GtkButton* b, DejaDupPreferences* self) {
	GdkDisplay* _tmp0_ = NULL;
	GdkAppLaunchContext* _tmp1_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) b);
	_tmp1_ = gdk_display_get_app_launch_context (_tmp0_);
	deja_dup_run_deja_dup ("--backup", (GAppLaunchContext*) _tmp1_, NULL);
}


static void __lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _lambda5_ (DejaDupPreferences* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	deja_dup_show_uri (GTK_IS_WINDOW (_tmp1_) ? ((GtkWindow*) _tmp1_) : NULL, "help:deja-dup");
}


static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda5_ (self);
}


static void _lambda6_ (DejaDupPreferences* self) {
	gtk_widget_set_sensitive (self->priv->restore_button, FALSE);
	gtk_widget_set_sensitive (self->priv->backup_button, FALSE);
}


static void __lambda6__gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	_lambda6_ (self);
}


static void _lambda7_ (DejaDupPreferences* self) {
	gtk_widget_set_sensitive (self->priv->restore_button, TRUE);
	gtk_widget_set_sensitive (self->priv->backup_button, TRUE);
}


static void __lambda7__gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	_lambda7_ (self);
}


static GtkWidget* deja_dup_preferences_make_settings_page (DejaDupPreferences* self) {
	GtkWidget* result = NULL;
	Block2Data* _data2_;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* settings_page;
	GtkNotebook* _tmp1_ = NULL;
	GtkWidget* w = NULL;
	GtkLabel* label = NULL;
	GtkGrid* table = NULL;
	gint row = 0;
	GtkTreeIter iter = {0};
	gint i;
	GtkSizeGroup* label_sizes = NULL;
	GtkListStore* _tmp2_ = NULL;
	GtkTreeView* _tmp3_ = NULL;
	AtkObject* _tmp4_ = NULL;
	AtkObject* _tmp5_;
	AtkObject* accessible;
	GtkCellRendererText* _tmp7_ = NULL;
	GtkCellRendererText* _tmp8_;
	GtkTreeSelection* _tmp9_ = NULL;
	GtkTreeSelection* _tmp10_ = NULL;
	GtkScrolledWindow* _tmp11_ = NULL;
	GtkScrolledWindow* scrollwin;
	GtkGrid* _tmp12_ = NULL;
	GtkSizeGroup* _tmp13_ = NULL;
	GtkAlignment* _tmp14_ = NULL;
	GtkWidget* _tmp15_;
	DejaDupConfigSwitch* _tmp16_ = NULL;
	DejaDupConfigSwitch* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkWidget* _tmp20_;
	GtkWidget* _tmp21_ = NULL;
	GtkEventBox* _tmp22_ = NULL;
	DejaDupConfigLabelLocation* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	DejaDupConfigLabelList* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	DejaDupConfigLabelList* _tmp31_ = NULL;
	GtkEventBox* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GtkLabel* _tmp34_ = NULL;
	GtkLabel* bdate_label;
	DejaDupConfigLabelBackupDate* _tmp35_ = NULL;
	DejaDupConfigLabelBackupDate* bdate;
	const gchar* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkLabel* ndate_label;
	DejaDupConfigLabelBackupDate* _tmp38_ = NULL;
	DejaDupConfigLabelBackupDate* ndate;
	GtkEventBox* _tmp39_ = NULL;
	GtkEventBox* _tmp40_ = NULL;
	DejaDupConfigLabelPolicy* _tmp41_ = NULL;
	GtkEventBox* _tmp42_ = NULL;
	GtkButtonBox* _tmp43_ = NULL;
	GtkButtonBox* bbox;
	const gchar* _tmp44_ = NULL;
	GtkButton* _tmp45_ = NULL;
	GtkWidget* _tmp46_;
	GtkWidget* _tmp47_;
	const gchar* _tmp48_ = NULL;
	GtkButton* _tmp49_ = NULL;
	GtkWidget* _tmp50_;
	GtkWidget* _tmp51_;
	GtkButton* _tmp52_ = NULL;
	GtkWidget* _tmp53_;
	guint _tmp54_;
	const gchar* _tmp55_ = NULL;
	GtkTreeIter _tmp56_ = {0};
	GtkGrid* _tmp57_ = NULL;
	DejaDupConfigLocation* _tmp58_ = NULL;
	DejaDupConfigLocation* location;
	const gchar* _tmp59_ = NULL;
	GtkLabel* _tmp60_ = NULL;
	GtkEventBox* _tmp61_ = NULL;
	GtkEventBox* _tmp62_ = NULL;
	DejaDupConfigLabelPolicy* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	GtkTreeIter _tmp65_ = {0};
	GtkRequisition req = {0};
	GtkRequisition hidden = {0};
	GtkRequisition _tmp66_ = {0};
	GtkRequisition _tmp67_ = {0};
	GtkRequisition _tmp68_ = {0};
	GtkGrid* _tmp69_ = NULL;
	DejaDupConfigList* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	GtkLabel* _tmp72_ = NULL;
	DejaDupConfigList* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GtkLabel* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkTreeIter _tmp77_ = {0};
	GtkGrid* _tmp78_ = NULL;
	DejaDupConfigPeriod* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	GtkLabel* _tmp81_ = NULL;
	DejaDupConfigDelete* _tmp82_ = NULL;
	const gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_;
	GtkLabel* _tmp86_ = NULL;
	DejaDupConfigLabelPolicy* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	GtkTreeIter _tmp89_ = {0};
	GtkTreeIter _tmp90_ = {0};
	GtkTreeSelection* _tmp91_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	settings_page = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkNotebook*) gtk_notebook_new ();
	_data2_->notebook = g_object_ref_sink (_tmp1_);
	i = 0;
	gtk_grid_set_column_spacing (settings_page, 12);
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_data2_->cat_model = _tmp2_;
	_tmp3_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data2_->cat_model);
	_data2_->tree = g_object_ref_sink (_tmp3_);
	_tmp4_ = gtk_widget_get_accessible ((GtkWidget*) _data2_->tree);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	accessible = _tmp5_;
	if (accessible != NULL) {
		const gchar* _tmp6_ = NULL;
		atk_object_set_name (accessible, "Categories");
		_tmp6_ = _ ("Categories");
		atk_object_set_description (accessible, _tmp6_);
	}
	gtk_tree_view_set_headers_visible (_data2_->tree, FALSE);
	gtk_widget_set_size_request ((GtkWidget*) _data2_->tree, 150, -1);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp8_ = g_object_ref_sink (_tmp7_);
	gtk_tree_view_insert_column_with_attributes (_data2_->tree, -1, NULL, (GtkCellRenderer*) _tmp8_, "text", 0, NULL);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = gtk_tree_view_get_selection (_data2_->tree);
	gtk_tree_selection_set_mode (_tmp9_, GTK_SELECTION_SINGLE);
	_tmp10_ = gtk_tree_view_get_selection (_data2_->tree);
	g_signal_connect_data (_tmp10_, "changed", (GCallback) __lambda2__gtk_tree_selection_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp11_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	scrollwin = g_object_ref_sink (_tmp11_);
	g_object_set (scrollwin, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set (scrollwin, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_shadow_type (scrollwin, GTK_SHADOW_IN);
	gtk_container_add ((GtkContainer*) scrollwin, (GtkWidget*) _data2_->tree);
	gtk_container_add ((GtkContainer*) settings_page, (GtkWidget*) scrollwin);
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
	_g_object_unref0 (table);
	table = g_object_ref_sink (_tmp12_);
	gtk_orientable_set_orientation ((GtkOrientable*) table, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (table, 6);
	gtk_grid_set_column_spacing (table, 12);
	row = 0;
	_tmp13_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (label_sizes);
	label_sizes = _tmp13_;
	_tmp14_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.0f, 0.0f);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp14_);
	_tmp15_ = w;
	_tmp16_ = deja_dup_config_switch_new (DEJA_DUP_PERIODIC_KEY, "");
	_tmp17_ = g_object_ref_sink (_tmp16_);
	gtk_container_add ((GtkContainer*) (GTK_IS_BIN (_tmp15_) ? ((GtkBin*) _tmp15_) : NULL), (GtkWidget*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = _ ("Automatic _backups");
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp19_);
	_tmp20_ = w;
	_tmp21_ = gtk_bin_get_child (GTK_IS_BIN (_tmp20_) ? ((GtkBin*) _tmp20_) : NULL);
	g_object_set ((GObject*) label, "mnemonic-widget", _tmp21_, "use-underline", TRUE, "xalign", 1.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) label);
	gtk_grid_attach (table, (GtkWidget*) label, 0, row, 1, 1);
	gtk_grid_attach (table, w, 1, row, 1, 1);
	row = row + 1;
	_tmp22_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp22_);
	g_object_set (w, "height-request", 12, NULL);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	_tmp23_ = deja_dup_config_label_location_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp23_);
	g_object_set ((GObject*) w, "hexpand", TRUE, NULL);
	_tmp24_ = _ ("Backup location");
	_tmp25_ = (GtkLabel*) gtk_label_new (_tmp24_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp25_);
	g_object_set ((GObject*) label, "xalign", 1.0f, "yalign", 0.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) label);
	gtk_grid_attach (table, (GtkWidget*) label, 0, row, 1, 1);
	gtk_grid_attach (table, w, 1, row, 1, 1);
	row = row + 1;
	_tmp26_ = _ ("Folders to back up");
	_tmp27_ = (GtkLabel*) gtk_label_new (_tmp26_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp27_);
	g_object_set ((GObject*) label, "xalign", 1.0f, "yalign", 0.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) label);
	_tmp28_ = deja_dup_config_label_list_new (DEJA_DUP_INCLUDE_LIST_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp28_);
	gtk_grid_attach (table, (GtkWidget*) label, 0, row, 1, 1);
	gtk_grid_attach (table, w, 1, row, 1, 1);
	row = row + 1;
	_tmp29_ = _ ("Folders to ignore");
	_tmp30_ = (GtkLabel*) gtk_label_new (_tmp29_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp30_);
	g_object_set ((GObject*) label, "xalign", 1.0f, "yalign", 0.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) label);
	_tmp31_ = deja_dup_config_label_list_new (DEJA_DUP_EXCLUDE_LIST_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp31_);
	gtk_grid_attach (table, (GtkWidget*) label, 0, row, 1, 1);
	gtk_grid_attach (table, w, 1, row, 1, 1);
	row = row + 1;
	_tmp32_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp32_);
	g_object_set (w, "height-request", 12, NULL);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	_tmp33_ = _ ("Most recent backup");
	_tmp34_ = (GtkLabel*) gtk_label_new (_tmp33_);
	bdate_label = g_object_ref_sink (_tmp34_);
	g_object_set ((GtkMisc*) bdate_label, "xalign", 1.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) bdate_label);
	_tmp35_ = deja_dup_config_label_backup_date_new (DEJA_DUP_CONFIG_LABEL_BACKUP_DATE_KIND_LAST);
	bdate = g_object_ref_sink (_tmp35_);
	gtk_grid_attach (table, (GtkWidget*) bdate_label, 0, row, 1, 1);
	gtk_grid_attach (table, (GtkWidget*) bdate, 1, row, 1, 1);
	row = row + 1;
	_tmp36_ = _ ("Next automatic backup");
	_tmp37_ = (GtkLabel*) gtk_label_new (_tmp36_);
	ndate_label = g_object_ref_sink (_tmp37_);
	g_object_set ((GtkMisc*) ndate_label, "xalign", 1.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) ndate_label);
	_tmp38_ = deja_dup_config_label_backup_date_new (DEJA_DUP_CONFIG_LABEL_BACKUP_DATE_KIND_NEXT);
	ndate = g_object_ref_sink (_tmp38_);
	gtk_grid_attach (table, (GtkWidget*) ndate_label, 0, row, 1, 1);
	gtk_grid_attach (table, (GtkWidget*) ndate, 1, row, 1, 1);
	row = row + 1;
	_tmp39_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp39_);
	g_object_set (w, "height-request", 12, NULL);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	_tmp40_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp40_);
	g_object_set (w, "height-request", 12, NULL);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	_tmp41_ = deja_dup_config_label_policy_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp41_);
	g_object_set (w, "expand", TRUE, NULL);
	gtk_widget_set_valign (w, GTK_ALIGN_END);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	_tmp42_ = (GtkEventBox*) gtk_event_box_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp42_);
	g_object_set (w, "height-request", 12, NULL);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	_tmp43_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	bbox = g_object_ref_sink (_tmp43_);
	g_object_set (bbox, "layout-style", GTK_BUTTONBOX_END, NULL);
	gtk_box_set_spacing ((GtkBox*) bbox, 12);
	_tmp44_ = _ ("_Restore…");
	_tmp45_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp44_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp45_);
	_tmp46_ = w;
	g_signal_connect_object (GTK_IS_BUTTON (_tmp46_) ? ((GtkButton*) _tmp46_) : NULL, "clicked", (GCallback) __lambda3__gtk_button_clicked, self, 0);
	_tmp47_ = _g_object_ref0 (w);
	_g_object_unref0 (self->priv->restore_button);
	self->priv->restore_button = _tmp47_;
	gtk_container_add ((GtkContainer*) bbox, w);
	_tmp48_ = _ ("Back Up _Now");
	_tmp49_ = (GtkButton*) gtk_button_new_with_mnemonic (_tmp48_);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp49_);
	_tmp50_ = w;
	g_signal_connect_object (GTK_IS_BUTTON (_tmp50_) ? ((GtkButton*) _tmp50_) : NULL, "clicked", (GCallback) __lambda4__gtk_button_clicked, self, 0);
	_tmp51_ = _g_object_ref0 (w);
	_g_object_unref0 (self->priv->backup_button);
	self->priv->backup_button = _tmp51_;
	gtk_container_add ((GtkContainer*) bbox, w);
	_tmp52_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_HELP);
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp52_);
	_tmp53_ = w;
	g_signal_connect_object (GTK_IS_BUTTON (_tmp53_) ? ((GtkButton*) _tmp53_) : NULL, "clicked", (GCallback) __lambda5__gtk_button_clicked, self, 0);
	gtk_container_add ((GtkContainer*) bbox, w);
	gtk_button_box_set_child_secondary (bbox, w, TRUE);
	_tmp54_ = g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.DejaDup.Operation", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((__lambda6__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __lambda6__gbus_name_appeared_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((__lambda7__gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __lambda7__gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
	self->priv->bus_watch_id = _tmp54_;
	gtk_grid_attach (table, (GtkWidget*) bbox, 0, row, 2, 1);
	gtk_notebook_append_page (_data2_->notebook, (GtkWidget*) table, NULL);
	_tmp55_ = _ ("Overview");
	gtk_list_store_insert_with_values (_data2_->cat_model, &_tmp56_, i, 0, _tmp55_, 1, i, -1);
	iter = _tmp56_;
	i = i + 1;
	_tmp57_ = (GtkGrid*) gtk_grid_new ();
	_g_object_unref0 (table);
	table = g_object_ref_sink (_tmp57_);
	gtk_grid_set_row_spacing (table, 6);
	gtk_grid_set_column_spacing (table, 12);
	row = 0;
	_tmp58_ = deja_dup_config_location_new (label_sizes);
	location = g_object_ref_sink (_tmp58_);
	_tmp59_ = _ ("_Backup location");
	_tmp60_ = (GtkLabel*) gtk_label_new (_tmp59_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp60_);
	g_object_set ((GObject*) label, "mnemonic-widget", location, "use-underline", TRUE, "xalign", 1.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) label);
	gtk_grid_attach (table, (GtkWidget*) label, 0, row, 1, 1);
	gtk_grid_attach (table, (GtkWidget*) location, 1, row, 1, 1);
	g_object_set ((GObject*) location, "hexpand", TRUE, NULL);
	row = row + 1;
	_tmp61_ = deja_dup_config_location_get_extras (location);
	g_object_set ((GObject*) _tmp61_, "hexpand", TRUE, NULL);
	_tmp62_ = deja_dup_config_location_get_extras (location);
	gtk_grid_attach (table, (GtkWidget*) _tmp62_, 0, row, 2, 1);
	row = row + 1;
	_tmp63_ = deja_dup_config_label_policy_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp63_);
	g_object_set ((GObject*) w, "expand", TRUE, NULL);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	gtk_notebook_append_page (_data2_->notebook, (GtkWidget*) table, NULL);
	_tmp64_ = _ ("Storage");
	gtk_list_store_insert_with_values (_data2_->cat_model, &_tmp65_, i, 0, _tmp64_, 1, i, -1);
	iter = _tmp65_;
	i = i + 1;
	gtk_widget_show_all ((GtkWidget*) table);
	gtk_widget_get_preferred_size ((GtkWidget*) table, NULL, &_tmp66_);
	req = _tmp66_;
	deja_dup_config_location_hidden_size (location, &_tmp67_);
	_tmp68_ = _tmp67_;
	hidden = _tmp68_;
	req.width = req.width + hidden.width;
	req.height = req.height + hidden.height;
	gtk_widget_set_size_request ((GtkWidget*) table, req.width, req.height);
	_tmp69_ = (GtkGrid*) gtk_grid_new ();
	_g_object_unref0 (table);
	table = g_object_ref_sink (_tmp69_);
	gtk_grid_set_row_spacing (table, 6);
	gtk_grid_set_column_spacing (table, 12);
	gtk_grid_set_column_homogeneous (table, TRUE);
	_tmp70_ = deja_dup_config_list_new (DEJA_DUP_INCLUDE_LIST_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp70_);
	g_object_set ((GObject*) w, "expand", TRUE, NULL);
	_tmp71_ = _ ("Folders to _back up");
	_tmp72_ = (GtkLabel*) gtk_label_new (_tmp71_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp72_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_grid_attach (table, (GtkWidget*) label, 0, 0, 1, 1);
	gtk_grid_attach (table, w, 0, 1, 1, 1);
	_tmp73_ = deja_dup_config_list_new (DEJA_DUP_EXCLUDE_LIST_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp73_);
	g_object_set ((GObject*) w, "expand", TRUE, NULL);
	_tmp74_ = _ ("Folders to _ignore");
	_tmp75_ = (GtkLabel*) gtk_label_new (_tmp74_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp75_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, "yalign", 0.0f, NULL);
	gtk_grid_attach (table, (GtkWidget*) label, 1, 0, 1, 1);
	gtk_grid_attach (table, w, 1, 1, 1, 1);
	gtk_notebook_append_page (_data2_->notebook, (GtkWidget*) table, NULL);
	_tmp76_ = _ ("Folders");
	gtk_list_store_insert_with_values (_data2_->cat_model, &_tmp77_, i, 0, _tmp76_, 1, i, -1);
	iter = _tmp77_;
	i = i + 1;
	_tmp78_ = (GtkGrid*) gtk_grid_new ();
	_g_object_unref0 (table);
	table = g_object_ref_sink (_tmp78_);
	gtk_grid_set_row_spacing (table, 6);
	gtk_grid_set_column_spacing (table, 12);
	row = 0;
	_tmp79_ = deja_dup_config_period_new (DEJA_DUP_PERIODIC_PERIOD_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp79_);
	gtk_widget_set_hexpand (w, TRUE);
	_tmp80_ = _ ("How _often to back up");
	_tmp81_ = (GtkLabel*) gtk_label_new (_tmp80_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp81_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 1.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) label);
	gtk_grid_attach (table, (GtkWidget*) label, 0, row, 1, 1);
	gtk_grid_attach (table, w, 1, row, 1, 1);
	row = row + 1;
	_tmp82_ = deja_dup_config_delete_new (DEJA_DUP_DELETE_AFTER_KEY, "");
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp82_);
	gtk_widget_set_hexpand (w, TRUE);
	_tmp83_ = _ ("_Keep backups");
	_tmp84_ = g_strdup_printf ("%s", _tmp83_);
	_tmp85_ = _tmp84_;
	_tmp86_ = (GtkLabel*) gtk_label_new (_tmp85_);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp86_);
	_g_free0 (_tmp85_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 1.0f, NULL);
	gtk_size_group_add_widget (label_sizes, (GtkWidget*) label);
	gtk_grid_attach (table, (GtkWidget*) label, 0, row, 1, 1);
	gtk_grid_attach (table, w, 1, row, 1, 1);
	row = row + 1;
	_tmp87_ = deja_dup_config_label_policy_new ();
	_g_object_unref0 (w);
	w = (GtkWidget*) g_object_ref_sink (_tmp87_);
	g_object_set ((GObject*) w, "expand", TRUE, NULL);
	gtk_grid_attach (table, w, 0, row, 2, 1);
	row = row + 1;
	gtk_notebook_append_page (_data2_->notebook, (GtkWidget*) table, NULL);
	_tmp88_ = _ ("Schedule");
	gtk_list_store_insert_with_values (_data2_->cat_model, &_tmp89_, i, 0, _tmp88_, 1, i, -1);
	iter = _tmp89_;
	i = i + 1;
	gtk_tree_model_get_iter_first ((GtkTreeModel*) _data2_->cat_model, &_tmp90_);
	iter = _tmp90_;
	_tmp91_ = gtk_tree_view_get_selection (_data2_->tree);
	gtk_tree_selection_select_iter (_tmp91_, &iter);
	gtk_notebook_set_show_tabs (_data2_->notebook, FALSE);
	gtk_notebook_set_show_border (_data2_->notebook, FALSE);
	g_object_set ((GtkWidget*) _data2_->notebook, "expand", TRUE, NULL);
	gtk_container_add ((GtkContainer*) settings_page, (GtkWidget*) _data2_->notebook);
	gtk_container_set_border_width ((GtkContainer*) settings_page, (guint) 12);
	gtk_widget_show ((GtkWidget*) settings_page);
	result = (GtkWidget*) settings_page;
	_g_object_unref0 (location);
	_g_object_unref0 (bbox);
	_g_object_unref0 (ndate);
	_g_object_unref0 (ndate_label);
	_g_object_unref0 (bdate);
	_g_object_unref0 (bdate_label);
	_g_object_unref0 (scrollwin);
	_g_object_unref0 (accessible);
	_g_object_unref0 (label_sizes);
	_g_object_unref0 (table);
	_g_object_unref0 (label);
	_g_object_unref0 (w);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static gboolean deja_dup_preferences_should_show_welcome (DejaDupPreferences* self) {
	gboolean result = FALSE;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* last_run;
	gboolean _tmp2_;
	gboolean welcomed;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_LAST_RUN_KEY);
	last_run = _tmp1_;
	_tmp2_ = g_settings_get_boolean ((GSettings*) settings, DEJA_DUP_WELCOMED_KEY);
	welcomed = _tmp2_;
	if (!welcomed) {
		_tmp3_ = g_strcmp0 (last_run, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	_g_free0 (last_run);
	_g_object_unref0 (settings);
	return result;
}


DejaDupPreferences* deja_dup_preferences_construct (GType object_type) {
	DejaDupPreferences * self = NULL;
	self = (DejaDupPreferences*) g_object_new (object_type, NULL);
	return self;
}


DejaDupPreferences* deja_dup_preferences_new (void) {
	return deja_dup_preferences_construct (DEJA_DUP_TYPE_PREFERENCES);
}


static GObject * deja_dup_preferences_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupPreferences * self;
	gboolean _tmp0_;
	parent_class = G_OBJECT_CLASS (deja_dup_preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_PREFERENCES (obj);
	_tmp0_ = deja_dup_preferences_should_show_welcome (self);
	if (_tmp0_) {
		GtkWidget* _tmp1_ = NULL;
		GtkWidget* _tmp2_;
		_tmp1_ = deja_dup_preferences_make_welcome_page (self);
		_tmp2_ = _tmp1_;
		gtk_container_add ((GtkContainer*) self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	} else {
		GtkWidget* _tmp3_ = NULL;
		GtkWidget* _tmp4_;
		_tmp3_ = deja_dup_preferences_make_settings_page (self);
		_tmp4_ = _tmp3_;
		gtk_container_add ((GtkContainer*) self, _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
	return obj;
}


static void deja_dup_preferences_class_init (DejaDupPreferencesClass * klass) {
	deja_dup_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupPreferencesPrivate));
	G_OBJECT_CLASS (klass)->constructor = deja_dup_preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_preferences_finalize;
}


static void deja_dup_preferences_instance_init (DejaDupPreferences * self) {
	self->priv = DEJA_DUP_PREFERENCES_GET_PRIVATE (self);
	self->priv->bus_watch_id = (guint) 0;
}


static void deja_dup_preferences_finalize (GObject* obj) {
	DejaDupPreferences * self;
	self = DEJA_DUP_PREFERENCES (obj);
	if (self->priv->bus_watch_id > 0) {
		g_bus_unwatch_name (self->priv->bus_watch_id);
		self->priv->bus_watch_id = (guint) 0;
	}
	_g_object_unref0 (self->priv->backup_button);
	_g_object_unref0 (self->priv->restore_button);
	G_OBJECT_CLASS (deja_dup_preferences_parent_class)->finalize (obj);
}


GType deja_dup_preferences_get_type (void) {
	static volatile gsize deja_dup_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupPreferences), 0, (GInstanceInitFunc) deja_dup_preferences_instance_init, NULL };
		GType deja_dup_preferences_type_id;
		deja_dup_preferences_type_id = g_type_register_static (GTK_TYPE_GRID, "DejaDupPreferences", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_preferences_type_id__volatile, deja_dup_preferences_type_id);
	}
	return deja_dup_preferences_type_id__volatile;
}



