# Copyright (C) 2010-2011  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Test common utilities."""

from __future__ import absolute_import, unicode_literals

__metaclass__ = type
__all__ = [
    'test_suite',
    ]


import unittest

from computerjanitorapp.utilities import format_size


class TestUtilities(unittest.TestCase):
    """Test common utilities."""

    def test_format_negative(self):
        self.assertRaises(AssertionError, format_size, -1)

    def test_format_zero(self):
        self.assertEqual(format_size(0), '0B')

    def test_format_small(self):
        self.assertEqual(format_size(500), '500B')

    def test_format_1k(self):
        self.assertEqual(format_size(1000), '1kB')

    def test_format_smallish(self):
        self.assertEqual(format_size(500000), '500kB')

    def test_format_1M(self):
        self.assertEqual(format_size(1000000), '1MB')

    def test_format_mediumish(self):
        self.assertEqual(format_size(500000000), '500MB')

    def test_format_1G(self):
        self.assertEqual(format_size(1000000000), '1GB')

    def test_format_bigish(self):
        self.assertEqual(format_size(500000000000), '500GB')

    def test_format_1T(self):
        self.assertEqual(format_size(1000000000000), '1TB')

    def test_format_hugish(self):
        self.assertEqual(format_size(500000000000000), '>1TB')


def test_suite():
    suite = unittest.TestSuite()
    suite.addTests(unittest.makeSuite(TestUtilities))
    return suite
