/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Canonical Ltd
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <unistd.h>
#include <clutk/clutk.h>

static void test_actor (void);

void
test_actor_create_suite (void)
{
#define DOMAIN "/Actor"

  g_test_add_func (DOMAIN"/StoredAllocatorBox", test_actor);
}

static void
test_actor (void)
{
  ClutterActor *stage;
  CtkActor     *actor;
  gchar        *filename;

  filename = g_build_filename (TESTDIR, "ubuntu.svg", NULL);

  stage = clutter_stage_get_default ();

  actor = (CtkActor *)ctk_image_new_from_filename (400, filename);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage),
                               CLUTTER_ACTOR (actor));
  clutter_actor_set_position (CLUTTER_ACTOR (actor), 25, 25);
 
  clutter_actor_show_all (stage);

  clutter_actor_hide (stage);

  ClutterActorBox box;
  ctk_actor_recurse_get_stored_allocation_box (CTK_ACTOR(actor), &box);
  
  g_assert (box.x1 == 25.0f);
  g_assert (box.y1 == 25.0f);
  g_assert (box.x2 - box.x1 == 400.0f);
  g_assert (box.y2 - box.y1 == 400.0f);

  clutter_container_remove_actor (CLUTTER_CONTAINER (stage),
                                  CLUTTER_ACTOR (actor));
  
  g_free (filename);
}

