/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jay.taoko@canonical.com>
 *
 */

#ifndef _CTK_GFX_PRIVATE_H_
#define _CTK_GFX_PRIVATE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-utils.h>
#include <clutk/ctk-actor.h>
#include <clutk/ctk-render-target.h>
#include <clutk/ctk-effect-context.h>

G_BEGIN_DECLS

typedef struct
{
	guint shvert;
	guint shfrag;
  guint shprog;
} ShaderProgram;

ShaderProgram* g_shTexture;
ShaderProgram* g_shTextureAlpha;
ShaderProgram* g_shBlurH0;
ShaderProgram* g_shBlurV0;
ShaderProgram* g_shBlurH1;
ShaderProgram* g_shBlurV1;
ShaderProgram* g_shExp;

char* ctk_read_shader_text_file(const char *filename);

ShaderProgram* ctk_create_shader_program_from_source(const char* vtx_filename, const char* frag_filename);
void ctk_delete_shader_program(ShaderProgram *sh);

/* GLSL */
void ctk_render_quad_rt(CtkRenderTarget* fbo, ShaderProgram *shader, int window_w, int window_h, int x, int y, int w, int h);

void ctk_render_quad(guint texid, guint texwidth, guint texheight, ShaderProgram *shader, int window_w, int window_h, int x, int y, int w, int h);

void ctk_render_custom_quad(guint texid, guint texwidth, guint texheight, ShaderProgram *shader, int window_w, int window_h, ClutterVertex vtx[4]);

void ctk_render_quad_alpha_mask(
      unsigned int texid,
      unsigned int texture_width,
      unsigned int texture_height,
      gfloat red, gfloat green, gfloat blue, gfloat alpha,
      int window_w, int window_h, int x, int y, int w, int h);

void custom_render_quad_gaussian_blur_separable(CtkRenderTarget* rt,
                                    ShaderProgram *shader, gfloat sigma,
                                    int window_w, int window_h, int x, int y, int w, int h);

void custom_render_quad_texture_mask(CtkRenderTarget* fbo,
      unsigned int texid,
      unsigned int texture_width,
      unsigned int texture_height,
      ShaderProgram *shader,
      int window_w,
      int window_h,
      int x,
      int y,
      int w,
      int h);

void ctk_copy_rendertarget_to_rendertarget(CtkRenderTarget* rt_src,
      float u0,
      float v0,
      float u1,
      float v1,
      CtkRenderTarget* rt_dst,
      int x_dst,
      int y_dst,
      int w_dst,
      int h_dst);

void ctk_copy_render_target_to_cached_texture(CtkEffectContext *fxctx, CtkRenderTarget* rt_src, guint texid);

void ctk_get_actor_screen_position (CtkActor* actor, gfloat *x, gfloat *y, gfloat *width, gfloat *height,   ClutterVertex vertex[4]);

G_END_DECLS

#endif /* _CTK_GFX_PRIVATE_H_ */

