# -*- perl -*-
use SGMLS;

#
# WARNING: the following defs REQUIRE that endtags be explicitely defined to
# '' when meaningful
#

sgml ("start_element", sub {
	my ($element,$event) = @_;
	output "<!-- FIXME: element ", $element->name, " was ignored.\nContent was:\n";
      });
sgml ('end_element', '-->');

#
# Shortcuts
#

sub sgml_blank ($) {
  my ($elt) = @_;
  sgml ("<$elt>", '');
  sgml ("</$elt>", '');
}

sub sgml_translate ($$) {
  my ($from, $to) = @_;
  sgml ("<$from>", "<$to>");
  sgml ("</$from>", "</$to>");
}

# replace chars not accepted in SGML IDs
sub sane_id ($) {
  my ($id) = @_;
  $id =~ tr/:/./;
  return $id;
}

#
# Entities
#

%entities = (
	     '&' => 'amp',
	     '<' => 'lt',
	     '>' => 'gt',
	    );

foreach my $char (keys %entities) {
  sgml ("|$char|", '&'.$entities{$char}.';');
}

#
#

sgml_blank ('ALCOVEDOC');

sgml ('<BOOK>', sub {
	my ($element,$event) = @_;

	output '<article';
	my $id = $element->attribute('ID')->value;
	output " ID=\"$id\"" if $id;
	output ">\n";
      });
# FIXME: this should be replaced by an emacs customisation
sgml ('</BOOK>',
      "</article>
<!-- Local Variables: -->
<!-- mode: sgml -->
<!-- End: -->
");

#
# Article Information
#

sgml ('<TITLEPAG>', "<ArticleInfo>\n");
sgml ('</TITLEPAG>', "</ArticleInfo>\n\n");

sgml ('<TITLE>', '<title>');
sgml ('</TITLE>', "</title>\n");

sgml ('<AUTHOR>', "<Author>\n");
sgml ('<NAME>', "<!-- FIXME: please set <FirstName> and <SurName> instead -->\n" . 
      '<OtherName>');
sgml ('</NAME>', "</OtherName>\n");
sgml ('<EMAIL>', sub {
	my ($element,$event) = @_;
	output "<Affiliation>\n<Address>\n" if $element->in('AUTHOR');
	output "<Email>";
      });
sgml ('</EMAIL>', sub {
	my ($element,$event) = @_;
	output "</Email>";
	output "</Address>\n</Affiliation>\n" if $element->in('AUTHOR');
      });
sgml ('</AUTHOR>', "</Author>\n");

sgml ('<VERSION>', '<ReleaseInfo>');
sgml ('</VERSION>', "</ReleaseInfo>\n");

sgml ('<DATE>', '<!-- FIXME: formatting-time date stamp not supported in DocBook -->');
sgml ('</DATE>', '');

# sgml ('<VERSION>', sub {
# 	$rev = ''; $date = '';
# 	output "<RevHistory>\n<Revision>";
#       });
# # see 'cdata' for $date and $rev
# sgml ('</VERSION>', sub {
# 	output "<RevNumber>", $rev ? $rev : '?', "</RevNumber>";
# 	output "<Date>", $date ? $date : '?', "</Date>";
# 	output "</Revision>\n</RevHistory>\n";
#       });

sgml ('<ABSTRACT>', "<Abstract>\n<Para>");
sgml ('</ABSTRACT>', "</Para>\n</Abstract>\n");

sgml_blank ('COPYRIGHT');
sgml ('<COPYRIGHTSUMMARY>', '<Copyright><Year><!-- FIXME: extract year manually and fill LegalNotice if appropriate -->');
sgml ('</COPYRIGHTSUMMARY>', '</Year><Holder>Alcove</Holder></Copyright>');

# The <Mission> and <Contrat> elements are just thrown away.  We still
# keep some of their contents:
sgml_blank ('MISSION');
sgml_blank ('CONTRAT');

sgml ('<DBID>', sub {
	my ($element,$event) = @_;
	output '<ContractNum Role="';
	if ($element->in('CONTRAT')) {
	  output 'Contract';
	} else {
	  output 'Mission';
	};
	output '">';
      });
sgml ('</DBID>', "</ContractNum>\n");

#
# Document hierarchy
#

sgml_blank ('TOC');		# ToC is autogenerated

%hier_map = (
	     'APPENDIX' => 'Appendix',
	    );

sub sect_hdr ($$) {
    my ($element, $event) = @_;
    my $to = $hier_map{$element->name} || 'Section';
    my $id = $element->attribute('ID')->value;

    output "<$to";
    output (' ID="', sane_id($id), '"') if $id;
    output '>';
}

foreach $sectlevel ('CHAPT', 'APPENDIX', 'SECT', 'SECT1', 'SECT2', 'SECT3', 'SECT4') {
  sgml ("<$sectlevel>", \&sect_hdr);
  sgml ("</$sectlevel>", "</" . ($hier_map{$sectlevel} || 'Section') . ">\n");
}

sgml ('<HEADING>', '<Title>');
sgml ('</HEADING>', "</Title>\n");

#
# Tables
#
# We need to compute the number of columns, so we output the table's
# content in a buffer string and write the table's header only when we're
# sure, that is when the whole table has been read.
#
# We count the number of cells in each row and keep the max of each row.
# Output buffering should work as is.
#
# FIXME: no support for nested tables (would need to keep track of nesting
# depth and use an array for $tablecols and $ncols.
#
sgml ('<TABLE>', sub {
	$tablecols = 0;		# we know nothing initially
	push_output ('string'); # buffer further output
      });
sgml ('<TR>', sub {
	$ncols = 0;
	output "<Row>\n";
      });
sgml ('<TD>', sub {
	$ncols++;
	output '<Entry>'; 
      });
sgml ('<TH>', sub {
	$ncols++;
	output '<Entry Remap="TH">'; 
      });
sgml ('</TD>', "</Entry>\n");
sgml ('</TH>', "</Entry>\n");
sgml ('</TR>', sub {
	$tablecols = $ncols if $ncols > $tablecols;
	output "</Row>\n";
      });
sgml ('</TABLE>', sub {
	my $tblstr = pop_output();	# flush buffered
	output ("<InformalTable>\n<TGroup cols=\"$tablecols\">\n<TBody>\n",
		"<!-- FIXME: you may want to move some rows into a <THead> -->\n",
		$tblstr,
		"</TBody>\n</TGroup>\n</InformalTable>\n");
      });

#
# Non-inline other stuff
#

sgml ('<EXAMPLE>', sub {
	# output '<LiteralLayout Remap="Example"><Literal Remap="Example>' . "\n";
	output '<ProgramListing Remap="Example">' . "\n";
	output "<![CDATA[\n" if $ENV{CDATA_EXAMPLES};
      });
sgml ('</EXAMPLE>', sub {
	output "\n]]>" if $ENV{CDATA_EXAMPLES};
	output "\n</ProgramListing>";
	# output "\n</Literal></LiteralLayout>\n";
      });

sgml ('<LIST>', "<ItemizedList>\n");
sgml ('</LIST>', "</ItemizedList>");

sgml ('<TAGLIST>', sub {
	$inentry = 0;
	output "<VariableList>\n";
      });
sgml ('</TAGLIST>', "</VariableList>\n");

%gloss = (None => 0,
	  Term => 1,
	  Defn => 2);
sgml ('<TAG>', sub {
	output "<VarListEntry>\n" unless $inentry;
	$inentry = 1;
	output "<Term>";
       });
sgml ('</TAG>', "</Term>\n");

sgml ('<ITEM>', sub {
	my ($element,$event) = @_;
	output "<ListItem>\n";
      });
sgml ('</ITEM>', sub {
	my ($element,$event) = @_;
	output "</ListItem>\n";
	if ($element->in('TAGLIST')) {
	  $inentry = 0;
	  output "</VarListEntry>\n";
	}
      });

sgml_translate ('COMMENT', 'Remark');
sgml_translate ('FOOTNOTE', "FootNote");

#
# Inline markup
#

#   sub sgml_ignored ($) {
#   my ($elt) = @_;

sgml_translate ('EM', 'Emphasis');
sgml_translate ('FILE', 'FileName');
sgml_translate ('VAR', 'VarName');

sgml ('<STRONG>', '<Emphasis Role="Strong">');
sgml ('</STRONG>', '</Emphasis>');
sgml ('<TT>', '<Literal Remap="tt">');
sgml ('</TT>', '</Literal>');

sgml ('<IMG>', sub {
	my ($element,$event) = @_;
	my $file = $element->attribute('SRC')->value;
	my $caption = $element->attribute('CAPTION')->value;

	output ("<MediaObject>\n",
		"<ImageObject>\n");
	if ($element->attribute('WIDTH')) {
	  # FIXME: should be Width="$width" ScaleFit="1" when stylesheets honor that
	  output ('<!-- FIXME: attribute WIDTH="', 
		  $element->attribute('WIDTH')->value,
		  '" should be converted to ImageData SCALE (percents) -->',
		  "\n");
	  output ("<ImageData FileRef=\"$file\">\n</ImageObject>\n",
		  "<TextObject><Para>$caption</Para></TextObject>\n",
		  "</MediaObject>\n");
	}
      });
sgml ('</IMG>', '');

sgml_blank ('IMAGE');		# see 'cdata' for content translation

sgml ('<URL>', sub {
	my ($element,$event) = @_;
	my $url = $element->attribute('ID')->value;
	my $name = $element->attribute('NAME')->value;
	$url .= $name ? "#$name" : '' if $name;
	output ('<Ulink url="', $url, '"><Literal>', $url, '</Literal></Ulink>');
      });
sgml ('</URL>', '');

sgml ('<REF>', sub {
	my ($element,$event) = @_;
	output ('<Xref LinkEnd="', sane_id($element->attribute('ID')->value), '">');
      });
sgml ('</REF>', '');

sgml ('<HTTPSITE>', '');
sgml ('</HTTPSITE>', '</ULink>');

#

# FIXME: <LegalNotice> should be inserted only once
sgml ('<P>', sub {
	my ($element,$event) = @_;

	output "\n" unless $element->in('ITEM');
	output "<LegalNotice>" if $element->in('COPYRIGHT');
	output "<Para>";
      });
sgml ('</P>', sub {
	my ($element,$event) = @_;

	output "</Para>\n";
	output "</LegalNotice>\n" if $element->in('COPYRIGHT');
      });

sgml ('cdata', sub {
	my ($element,$event) = @_;

	if 
# 	  ($event->element->name eq 'DATE') {
# 	  $date = $element;
# 	} elsif ($event->element->name eq 'VERSION') {
# 	  $rev = $element;
# 	} elsif 
	  ($event->element->name eq 'IMAGE') {
	  chomp $element;
	  output ("<MediaObject>\n",
		  "<ImageObject><ImageData FileRef=\"$element\"></ImageObject>\n",
		  "</MediaObject>\n");
	} elsif ($event->element->name eq 'HTTPSITE') {
	  output '<ULink Url="', $element, '">', $element;
	} else {
	  output $element;
	}
      });
