/***************************************************************************
 *   Copyright (C) 2006 by Vladimir Stefan   *
 *   vstefan85@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef UPGRADEWIZARD_H
#define UPGRADEWIZARD_H

#include <adept/kubuntu_upgrader/upgradewizardbase.h>

class QString;
class QTextIStream;
class QDateTime;
class KProcess;
class KURL;
class ErrorDialog;

// ** Represents an entry in the metafile ** //
class DistroEntry {
	public:
		DistroEntry(QString *d_field);
		~DistroEntry();
		QString *dist_field;
		QString *name_field;
		QString *version_field;
		QDateTime *date_field;
		bool supported_field;
		QString *desc_field;
		KURL *release_file_url;
		KURL *release_notes_url;
		KURL *upgrade_tool_url;
		KURL *upgrade_tool_sig_url;
};

class UpgradeWizard : public UpgradeWizardDlg
{
  Q_OBJECT

public:
  UpgradeWizard(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~UpgradeWizard();

  /*$PUBLIC_FUNCTIONS$*/
	bool 					checkForDistUpgrade(QString url=QString(""), bool developmentVersion = false);
	QPtrList<DistroEntry> 	*parseMetafile( QTextIStream *text_stream,
										 	QString my_distro_name );
	
public slots:
  /*$PUBLIC_SLOTS$*/
	void 					receiveDistroName( KProcess* p, char *buffer, int buflen );
	void 					launchDistUpdater();
	void					fetchReleaseAnnounce();
	void					fetchUpgradeTool();
	void					fetchUpgradeToolSig();
	void					verifyUpgradeTool();
	

	signals:
	void					killErrorDialog();

protected:
  /*$PROTECTED_FUNCTIONS$*/
	void					removeOldUpgradeTool();
	void					removeDirectory(QString directoryName);

protected slots:
  /*$PROTECTED_SLOTS$*/
  	virtual void   	    	back();
  	virtual void    	    next();

private:
	QString upgrade_tool_location;
	QString upgrade_tool_sig_location;
	QString distro_name;
	DistroEntry* upgrade_dist;
	DistroEntry* current_dist;
	ErrorDialog* err_dlg;
};

#endif

