/** -*- C++ -*-
    @file adept/application.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <vector>

#include <qobject.h>

#include <apt-front/cache/cache.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>

#ifndef EPT_APPLICATION_H
#define EPT_APPLICATION_H

class KStatusBar;

namespace adept {
using namespace aptFront;
using cache::Cache;

class Lister;

struct Application : cache::Observer {
    Application();
    void setAcceptReadOnly( bool ro ) { m_acceptReadOnly = ro; }
    bool writeable() { return cache::Global::get().writeable(); }
    Cache &cache() { return cache::Global::get(); }
    void openCache( unsigned flags = Cache::OpenDefault | Cache::OpenDebtags );
    void initialize();
    void initKDEDebconf();
    void initHistory();
    void setMainWidget( QWidget *w ) { m_main = w; }
    void setStatusBar( KStatusBar *s );
    void updateStatusbar();
    virtual void checkpoint();
    virtual void undo();
    virtual void redo();

    virtual void notifyPostChange( cache::component::Base * );

    QString changeString();
    QString statusString();
    QString sizesString();
protected:
    virtual void setHistoryEnabled( bool ) {}
    typedef cache::component::History< cache::component::State > History;
    virtual History *history() { return m_history; }
    bool m_acceptReadOnly;
    QWidget *m_main;
    KStatusBar *m_statusBar;
    History *m_history;
};

/* class WaitForLister : public QObject {
    Q_OBJECT
public:
    WaitForLister( QObject *a, const char *s )
        : obj( a ), slot( s )
        {
            waiting();
        }
    void addLister( Lister *l ) { listers.push_back( l ); }
protected slots:
    void waiting();
protected:
    QObject *obj;
    const char *slot;
    typedef std::vector< Lister * > Vector;
    Vector listers;
    }; */

}

#endif
