#!/bin/sh

# Lenovo are great.  They have changed the function of the Fn-F3
# combination on the LenovoPads from KEY_LOCK => KEY_BATTERY.
# Unfortunately they didn't bother to change the DMI strings
# consistently...  so some of the new machines say 'LENOVO' and some
# still say 'IBM'.  Yay for consistency(!).
#
# (And just to top that, LENOVO have started producing non-ThinkPad
# laptop computers).

# So:
# IBM && !Series60   => Lock
# IBM && Series60    => Battery
# LENOVO && ThinkPad => Battery

. /usr/share/acpi-support/key-constants

system_version=`dmidecode -s system-version`
system_manufactuer=`dmidecode -s system-manufacturer`

case "$system_manufactuer" in
    IBM*)
    case "$system_version" in
	ThinkPad\ [TXZ]60*)
	acpi_fakekey $KEY_BATTERY
	;;
	*)
	if [ -x /etc/acpi/screenblank.sh ] ; then
	    . /etc/acpi/screenblank.sh
	else
	    acpi_fakekey $KEY_COFFEE
	fi
	;;
    esac
    ;;
    LENOVO*)
    acpi_fakekey $KEY_BATTERY
    ;;
esac
