<?php

/* $id$ */

// This file will only be hit when the user installs WPMU first - when mod_rewrite
// isn't activated. Ask a few questions, set up .htaccess files, check perms, etc.
// 2004, Donncha O Caoimh, donncha@linux.ie

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
        <title>WordPress &rsaquo; Installation</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <style media="screen" type="text/css">
        <!--
        html {
                background: #eee;
        }
        body {
                background: #fff;
                color: #000;
                font-family: Georgia, "Times New Roman", Times, serif;
                margin-left: 20%;
                margin-right: 20%;
                padding: .2em 2em;
        }
        
        h1 {
                color: #006;
                font-size: 18px;
                font-weight: lighter;
        }
        
        h2 {
                font-size: 16px;
        }
        
        p, li, dt {
                line-height: 140%;
                padding-bottom: 2px;
        }

        ul, ol {
                padding: 5px 5px 5px 20px;
        }
        #logo {
                margin-bottom: 2em;
        }
.step a, .step input {
        font-size: 2em;
}
.step, th {
        text-align: right;
}
#footer {
text-align: center; border-top: 1px solid #ccc; padding-top: 1em; font-style: italic;
}
        -->
        </style>
</head>
<body>

<?php

print "<div align='center'><img src='wp-inst/wp-images/wordpress-mu.png'></div><br>";
print "Welcome to WordPress MU, the Multi User Weblog System built on WordPress.<br><br>";
print "You're probably seeing this message because you're installing WPMU!<br><br>";
print "If it's already installed, then <b>mod_rewrite</b> is disabled. Ask your administrator to enable that module, or look at the <a href='http://httpd.apache.org/docs/mod/mod_rewrite.html'>Apache documentation</a> or <a href='http://www.google.com/search?q=apache+mod_rewrite'>elsewhere</a> for help setting it up.<br><br>";

function check_writeable_dir( $dir, $ret )
{
    if( is_writeable( $dir  ) == false )
    {
        print $dir." : <b style='color: #f55'>FAILED</b><br>Quick Fix: <code>chmod 777 $dir</code><br>";
        return false;
    }
    else
    {
        print $dir." : <b>PASSED</b><br>";
        if( $ret == true )
        {
            return true;
        }
        else
        {
            return false;
        }
    }
}

function do_htaccess( $oldfilename, $newfilename, $realpath, $base, $url )
{
    $htaccess = '';
    if( is_file( $oldfilename ) )
    {
        $fp = fopen( $oldfilename, "r" );
        if( $fp )
        {
            while( !feof( $fp ) )
            {
                $htaccess .= fgets( $fp, 4096 );
            }
            fclose( $fp );
            $htaccess = str_replace( "REALPATH", $realpath, $htaccess );
            $htaccess = str_replace( "BASE", $base, $htaccess );
            $htaccess = str_replace( "HOST", $url, $htaccess );
            $fp = fopen( $newfilename, "w" );
            fwrite( $fp, $htaccess );
            fclose( $fp );
        }
    }
}

if( isset( $nosetup ) == false )
{
    $ret = true;
    $ret = check_writeable_dir( dirname(__FILE__), $ret );
    $ret = check_writeable_dir( dirname(__FILE__) . "/wp-inst", $ret );
    $ret = check_writeable_dir( dirname(__FILE__) . "/wp-inst/wp-content/", $ret );
    $ret = check_writeable_dir( dirname(__FILE__) . "/wp-inst/wp-content/smarty-templates", $ret );

    if( $ret == false )
    {
        print "<h2>Warning!</h2>";
        print "<div style='border: 1px solid #ccc'>";
        print "<p style='font-weight: bold; padding-left: 10px'>One or more of the above directories must be made writeable by the webserver.<br>";
        print "Please <code>chmod 777 <q>directory-name</q></code> or <code>chown</code> that directory to the user the web server runs as (usually nobody, apache, or www-data)<br>";
        print "Refresh this page when you're done!<br></p>";
        print "</div>";
        die();
    }

    // Create default template cache dirs
    @mkdir( dirname(__FILE__) . "/wp-inst/wp-content/smarty-cache" , 0777 );
    @mkdir( dirname(__FILE__) . "/wp-inst/wp-content/smarty-templates_c" , 0777 );

    // Create Blogs living area.
    @mkdir( dirname(__FILE__) . "/wp-inst/wp-content/blogs", 0777 );


    $url = "http://".$_SERVER["SERVER_NAME"] . dirname( $_SERVER[ "SCRIPT_NAME" ] );
    if( substr( $url, -1 ) == '/' )
        $url = substr( $url, 0, -1 );
    $base = dirname( $_SERVER["SCRIPT_NAME"] );
    if( $base == "/")
    {
           $base = "";
    } 
    $realpath = dirname(__FILE__);

    print "<br><br>Where WPMU will live: <b>$url</b><br>";
    print "The directory portion of the above url: <b>$base</b><br>";
    print "The filesystem path to this directory: <b>$realpath</b><br>";
    print "If any of the above is incorrect, please edit .htaccess and wp-inst/.htaccess!";

    do_htaccess( "htaccess.dist", ".htaccess", $realpath, $base, $url );
    do_htaccess( "wp-inst/htaccess.dist", "wp-inst/.htaccess", $realpath, $base, $url );

    if( is_dir( dirname(__FILE__) . "/wp-inst/wp-content/blogs/main/" ) == false )
    {
        // Setup default blog.
        @mkdir( "./wp-inst/wp-content/blogs/main", 0777 );
        @mkdir( "./wp-inst/wp-content/blogs/main/images", 0777 );
        @mkdir( "./wp-inst/wp-content/blogs/main/templates", 0777 );
        @mkdir( "./wp-inst/wp-content/blogs/main/templates_c", 0777 );
        @mkdir( "./wp-inst/wp-content/blogs/main/smartycache", 0777 );
        if ($dir = @opendir("./wp-inst/wp-content/sitetemplates/humancondition/templates")) {
            while ($file = readdir($dir)) 
            {
                if( $file != '.' && $file != '..' )
                {
                    copy( "./wp-inst/wp-content/sitetemplates/humancondition/templates/$file", "./wp-inst/wp-content/blogs/main/templates/$file" );
                }
            }  
            closedir($dir);
            // modify css file.
            $cssfile = '';
            $fp = fopen( "./wp-inst/wp-content/blogs/main/templates/wp-layout.css", "r" );
            while (!feof ($fp)) 
            {
                $cssfile .= fgets($fp, 4096);
            }
            fclose ($fp);
            $cssfile = str_replace( "BASE", $base, $cssfile );
            $fp = fopen( "./wp-inst/wp-content/blogs/main/templates/wp-layout.css", "w" );
            fwrite( $fp, $cssfile );
            fclose( $fp );
        }
    }

    if( is_file( dirname(__FILE__) . "./wp-inst/wpmu-settings.php" ) == false )
    {
        $configfile = '';
        $fp = fopen( "./wp-inst/wpmu-settings.php.dist", "r" );
        if( $fp )
        {
            while( !feof( $fp ) )
            {
                $configfile .= fgets( $fp, 4096 );
            }
            fclose( $fp );
        }
        $configfile = str_replace( "BASE", $base."/", $configfile );
        $fp = fopen( "./wp-inst/wpmu-settings.php", "w" );
        fwrite( $fp, $configfile );
        fclose( $fp );
    }
}

// create dummy setup-config.php - if mod_rewrite isn't working this will print helpful instructions.
@mkdir( dirname(__FILE__) . "/main" , 0777 );
@mkdir( dirname(__FILE__) . "/main/wp-admin" , 0777 );
$fp = fopen( dirname(__FILE__) . "/main/wp-admin/setup-config.php", "w" );
if( $fp )
{
    $msg = "
	<html>
	<head>
	<title>Please install mod_rewrite!</title>
	</head>
	<body>
	<h1>Mod Rewrite is not installed!</h1>
	<p>You must make sure that mod_rewrite is installed and configured correctly before WordpressMU will work.</p>
	<p>Instructions for setting it up on Debian with Apache 2, php4 and mysql is available at <a href='http://blogs.linux.ie/support/topic.php?id=4'>http://blogs.linux.ie/support/topic.php?id=4</a></p>
	<p>Here's what that page says:
	<blockquote style='border: 1px solid #999; background: #eee; padding: 10px;'>
	<p>If Apache 2, PHP and MySQL aren't installed then use apt-get to install them:<br />
	<code>apt-get install apache2 mysql-server php4-mysql php4</code></p>
	<p>The mod_rewrite module isn't installed by default so:<br />
	<code>cp /etc/apache2/mods-available/rewrite.load /etc/apache2/mods-enabled/</code><br />
	(On a non-Debian machine look for a line in httpd.conf that starts with <q>LoadModule rewrite_module</q> and uncomment it.)<br /><br />
	Edit /etc/apache2/sites-enabled/000-default and look for the section that starts with<br />
	&nbsp;&nbsp;<code>&lt;Directory /var/www/&gt;</code><br />
	Inside there edit the line<br />
	&nbsp;&nbsp;<code>AllowOverride None</code><br />
	and change to<br />
	&nbsp;&nbsp;<code>AllowOverride FileInfo</code></p>
	<p>Enable mysql in php.ini by editing /etc/php4/apache2/php.ini and uncommenting the following line:<br />
	&nbsp;&nbsp;<code>extension=mysql.so</code></p>
	<p>Now restart Apache 2:<br />
	&nbsp;&nbsp;<code>/etc/init.d/apache2 restart</code></p>

	<p>It's very important to login to the wp-admin backend at the end as a few more tables will be created.<br />
	You're encouraged to fix the file and directory permissions but that's optional if you remove the warnings from index.php<br />
	Well Done! WPMU is installed!
	</p>
	</blockquote>

	Please check the <a href='http://mu.wordpress.org/support/'>Support Forum</a> for more help.<br />
	If you've made those changes, reload this page and the proper setup page should load.

	</body>
	</html>
	";

	fwrite( $fp, $msg );
	fclose ( $fp );
}
    
if( is_file( dirname(__FILE__) . "/wp-inst/wp-config.php" ) == false )
{
    print "<h2>WPMU Is Almost Installed!</h2>";
    print "<div style='border: 1px solid #ccc'>";
    print "You need to setup WPMU so it can access your MySQL database!<br>";
    print "<div align='right'><a href='main/wp-admin/setup-config.php'>Setup WP Database and Blog</a></div>";
}
else
{
    print "Now, go to <a href='".$url."/main/wp-admin/install.php'>install.php</a> to complete the installation!";
}
?>
</body>
</html>
