\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ntueltr}
\RequirePackage{ifthen}

\DeclareOption*{\passOptionsToClass{\CurrentOption}{letter}}
\ProcessOptions
\LoadClass[12pt]{letter}
\voffset=-2.5cm
\textheight=8.6in

\renewcommand{\today}{\number\month-\number\day-\number\year}

%% input from ntueltr.tex: start
\ifx\z\undefined\def\z{\hskip 0.0pt plus0.2pt minus0.1pt} \fi
\ifx\Z\undefined\def\Z{\hskip 1.2pt plus0.4pt minus0.2pt} \fi
\ifx\zZ\undefined\def\zZ{\hskip 3.6pt plus1.2pt minus0.8pt} \fi
\ifx\cH\undefined\def\cH{\char} \fi
\providecommand{\MaQ}{\fontfamily{cwM0}\fontseries{m}\selectfont}
\providecommand{\cBcQ}{\fontfamily{cwBB2}\fontseries{m}\selectfont}
\providecommand{\cBaQ}{\fontfamily{cwBB0}\fontseries{m}\selectfont}
\providecommand{\cBbQ}{\fontfamily{cwBB1}\fontseries{m}\selectfont}
\providecommand{\cBhQ}{\fontfamily{cwBB7}\fontseries{m}\selectfont}
\providecommand{\MbQ}{\fontfamily{cwM1}\fontseries{m}\selectfont}
\providecommand{\MfQ}{\fontfamily{cwM5}\fontseries{m}\selectfont}
\providecommand{\McQ}{\fontfamily{cwM2}\fontseries{m}\selectfont}
\providecommand{\MdQ}{\fontfamily{cwM3}\fontseries{m}\selectfont}
\providecommand{\MiQ}{\fontfamily{cwM8}\fontseries{m}\selectfont}
\providecommand{\MhQ}{\fontfamily{cwM7}\fontseries{m}\selectfont}
% \documentclass{article}
% \usepackage{minion}
% \begin{document}
\newsavebox{\headlogo}
\newsavebox{\ltrhead}
\sbox{\headlogo}{\parbox[b]{8mm}{
 \fontfamily{cmss}\fontshape{sl}%
 \fontsize{17.28}{20}\selectfont III}}
\sbox{\ltrhead}{
 \begin{minipage}{16cm}
 \parbox[b]{.54\textwidth}{
 \usebox{\headlogo}
 {\LARGE{\cBcQ\cH67}\z{\cBaQ\cH215}\z{\cBcQ\cH37}\z%
   {\cBbQ\cH200}\z{\cBhQ\cH205}}\\[4pt]
 {{\MaQ\cH171}\z{\MaQ\cH148}\z{\MbQ\cH13}\z{\MfQ\cH15}\z{\MbQ\cH8}\z%
   {\McQ\cH152}21\Z{\McQ\cH85}}}
 \parbox[b]{.3\textwidth}{
 {\MdQ\cH216}\z{\MiQ\cH28}\z{\MfQ\cH220}\\ {\MaQ\cH171}\z{\MaQ\cH215}%
   \z{\McQ\cH37}\z{\MbQ\cH200}\z{\MhQ\cH205}\z{\MbQ\cH96}\z{\MfQ\cH164}}
 \hspace*{-.03\textwidth}\rule[4pt]{.95\textwidth}{.6pt}
 \hspace*{.46\textwidth}\parbox{.4\textwidth}{
 \raggedleft
  email: ntut019@ccms.ntu.edu.tw\\
  Tel: (02)2351--9641}
 \end{minipage}}
% \usebox{\ltrhead}
% \end{document}
%% input from ntueltr.tex: end

\renewcommand{\ps@firstpage}
  {\setlength{\headheight}{3cm}\setlength{\headsep}{.4cm}%
\renewcommand{\@oddhead}{\hspace*{-.6cm}%
  \raisebox{1cm}{\usebox{\ltrhead}}}}
\renewcommand{\ps@headings}
  {\renewcommand{\@oddhead}{}}
\renewcommand{\@oddfoot}{}
\renewcommand{\@evenhead}{\@oddhead}
\renewcommand{\@evenfoot}{\@oddfoot}
\providecommand{\@evenhead}{}\providecommand{\@oddhead}{}
\providecommand{\@evenfoot}{}\providecommand{\@oddfoot}{}
\pagestyle{headings}
