#!/usr/bin/env ruby
# vim:ts=2 sw=2 et
# mkhtf.rb : make TeX4ht htf file from afm file.
# Edward G.J. Lee (06/22/07)
#
# Copyright (C) 2007  Edward G.J. Lee <edt1023@info.sayya..org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program in doc/COPYING; if not, write to the Free
# Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301 USA
#
# p1(06/23/07) ץ htf 榡~AP granziliaoC
# p2(06/26/07) W[ -c ѼơAHK͹ڪr]w]O Unicode X^C
# p3(06/27/07) W[r agl W٦CAHK Type 1  rrW١C
# p4(06/28/07) ץ mkhtf() while j gap j 1 ɡAֺ@CC
# p5(06/28/07)  license  GNU GPLCVersion number 0.9C

$ver="0.9"
$pname = File.basename($0)
$t = Time.now.strftime("%Y.%m.%d %H:%M:%S")

# Adobe Glyph List
# ƨӷG
# http://www.adobe.com/devnet/opentype/archives/glyphlist.txt
# @ӥHWȪ̶ȨĤ@ȡC
$agl = {"wgrave" => "1E81",
	"nikatakana" => "30CB",
	"cedilla" => "00B8",
	"numeralsigngreek" => "0374",
	"iigujarati" => "0A88",
	"Zhearmenian" => "053A",
	"Ccircumflex" => "0108",
	"yen" => "00A5",
	"afii299" => "200E",
	"hehaltonearabic" => "06C1",
	"gcircumflex" => "011D",
	"lcircumflexbelow" => "1E3D",
	"itilde" => "0129",
	"braceleftmid" => "F8F2",
	"hatafqamatshebrew" => "05B3",
	"Nineroman" => "2168",
	"rvocalicbengali" => "098B",
	"mukatakanahalfwidth" => "FF91",
	"Feicoptic" => "03E4",
	"hehebrew" => "05D4",
	"circlepostalmark" => "3036",
	"patah" => "05B7",
	"akatakana" => "30A2",
	"sterling" => "00A3",
	"ehbopomofo" => "311D",
	"afii10040" => "0426",
	"gjecyrillic" => "0453",
	"fivegurmukhi" => "0A6B",
	"ugrave" => "00F9",
	"afii10041" => "0427",
	"nukatakana" => "30CC",
	"ghadarmenian" => "0572",
	"blacklowerrighttriangle" => "25E2",
	"thirteenparen" => "2480",
	"questiondownsmall" => "F7BF",
	"qubutswidehebrew" => "05BB",
	"dammatanarabic" => "064C",
	"afii10042" => "0428",
	"Udieresiscyrillic" => "04F0",
	"chbopomofo" => "3114",
	"afii10043" => "0429",
	"hehiragana" => "3078",
	"ideographwoodcircle" => "328D",
	"ydotaccent" => "1E8F",
	"tabengali" => "09A4",
	"afii10044" => "042A",
	"clickdental" => "01C0",
	"pssquare" => "33B0",
	"Fiveroman" => "2164",
	"afii10045" => "042B",
	"SF450000" => "2567",
	"mugreek" => "03BC",
	"Epsilon" => "0395",
	"eightinferior" => "2088",
	"afii10046" => "042C",
	"ideographicsecretcircle" => "3299",
	"hadeva" => "0939",
	"vagujarati" => "0AB5",
	"sioscirclekorean" => "3266",
	"afii10047" => "042D",
	"Zedescendercyrillic" => "0498",
	"vadeva" => "0935",
	"shevawidehebrew" => "05B0",
	"khahinitialarabic" => "FEA7",
	"afii10048" => "042E",
	"Zcircumflex" => "1E90",
	"cheharmenian" => "0573",
	"esuperior" => "F6EC",
	"Icircumflexsmall" => "F7EE",
	"glottalstopmod" => "02C0",
	"afii10049" => "042F",
	"Omegagreek" => "03A9",
	"zerowidthspace" => "200B",
	"yakatakana" => "30E4",
	"tagujarati" => "0AA4",
	"rcedilla" => "0157",
	"holam26" => "05B9",
	"onehangzhou" => "3021",
	"Ecircumflextilde" => "1EC4",
	"etnahtalefthebrew" => "0591",
	"wawhamzaabovearabic" => "0624",
	"hamzalowkasraarabic" => "0621",
	"guillemotleft" => "00AB",
	"ghhadeva" => "095A",
	"gradient" => "2207",
	"koroniscmb" => "0343",
	"pmsquare" => "33D8",
	"jeemfinalarabic" => "FE9E",
	"greaterorequivalent" => "2273",
	"aimatragurmukhi" => "0A48",
	"zerowidthjoiner" => "FEFF",
	"yehhamzaaboveinitialarabic" => "FE8B",
	"scedilla" => "015F",
	"quotereversed" => "201B",
	"Ucircumflex" => "00DB",
	"Upsilon" => "03A5",
	"zayindageshhebrew" => "FB36",
	"Iinvertedbreve" => "020A",
	"anusvaragujarati" => "0A82",
	"caroncmb" => "030C",
	"ycircumflex" => "0177",
	"onearabic" => "0661",
	"kikatakanahalfwidth" => "FF77",
	"visargadeva" => "0903",
	"atsmall" => "FE6B",
	"nokatakana" => "30CE",
	"yadeva" => "092F",
	"theta1" => "03D1",
	"Zdotaccent" => "017B",
	"ocircumflexacute" => "1ED1",
	"blackstar" => "2605",
	"Sigma" => "03A3",
	"sigmalunatesymbolgreek" => "03F2",
	"meemmeemisolatedarabic" => "FC48",
	"nabengali" => "09A8",
	"quotesinglemonospace" => "FF07",
	"onepersian" => "06F1",
	"holamhebrew" => "05B9",
	"anusvarabengali" => "0982",
	"saraileftthai" => "F885",
	"qofqamatshebrew" => "05E7",
	"parenright" => "0029",
	"ismallhiragana" => "3043",
	"dotmath" => "22C5",
	"Scircumflex" => "015C",
	"dollarsmall" => "FE69",
	"ogonek" => "02DB",
	"arrowupleftofdown" => "21C5",
	"mahapakhlefthebrew" => "05A4",
	"slashmonospace" => "FF0F",
	"rieulhieuhkorean" => "3140",
	"dehihebrew" => "05AD",
	"Beta" => "0392",
	"angkhankhuthai" => "0E5A",
	"nwsquare" => "33BB",
	"commainferior" => "F6E1",
	"mieumcirclekorean" => "3264",
	"notsucceeds" => "2281",
	"notgreaternorless" => "2279",
	"afii10020" => "0413",
	"IAcyrillic" => "042F",
	"Hungarumlautsmall" => "F6F8",
	"afii10021" => "0414",
	"ygrave" => "1EF3",
	"threehackarabic" => "0663",
	"radoverssquare" => "33AE",
	"musicalnotedbl" => "266B",
	"mieumkorean" => "3141",
	"Thook" => "01AC",
	"iivowelsigngujarati" => "0AC0",
	"horicoptic" => "03E9",
	"afii10022" => "0415",
	"whitetortoiseshellbracketright" => "3019",
	"ninegujarati" => "0AEF",
	"afii10023" => "0401",
	"sixteencurrencydenominatorbengali" => "09F9",
	"ocircumflex" => "00F4",
	"afii10024" => "0416",
	"sheva115" => "05B0",
	"igrave" => "00EC",
	"Scedilla" => "015E",
	"betrafehebrew" => "FB4C",
	"afii10025" => "0417",
	"arrowleftwhite" => "21E6",
	"threearabic" => "0663",
	"blackrightpointingtriangle" => "25B6",
	"Raarmenian" => "054C",
	"afii10026" => "0418",
	"rieulphieuphkorean" => "313F",
	"ncommaaccent" => "0146",
	"plusmod" => "02D6",
	"kiyeokkorean" => "3131",
	"increment" => "2206",
	"lamedholam" => "05DC",
	"afii10027" => "0419",
	"Yiwnarmenian" => "0552",
	"thorn" => "00FE",
	"pasquare" => "33A9",
	"Xi" => "039E",
	"dzcurl" => "02A5",
	"afii10028" => "041A",
	"zadeva" => "095B",
	"uhookabove" => "1EE7",
	"rhookturnedsuperior" => "02B5",
	"Njecyrillic" => "040A",
	"Tcedilla" => "0162",
	"afii10029" => "041B",
	"circleplus" => "2295",
	"daletsegol" => "05D3",
	"projective" => "2305",
	"eightcircle" => "2467",
	"shinhebrew" => "05E9",
	"Izhitsadblgravecyrillic" => "0476",
	"ovowelsigngujarati" => "0ACB",
	"hiriq14" => "05B4",
	"jcircumflex" => "0135",
	"lameddageshhebrew" => "FB3C",
	"habengali" => "09B9",
	"uhornhookabove" => "1EED",
	"Icircumflex" => "00CE",
	"Sevenroman" => "2166",
	"Adotmacron" => "01E0",
	"ascriptturned" => "0252",
	"wahiragana" => "308F",
	"jadeva" => "091C",
	"Hbrevebelow" => "1E2A",
	"holamquarterhebrew" => "05B9",
	"ntilde" => "00F1",
	"ukcyrillic" => "0479",
	"questionarmenian" => "055E",
	"cyrflex" => "F6D5",
	"notsuperset" => "2285",
	"twodotenleader" => "2025",
	"rdotaccent" => "1E59",
	"Udblacute" => "0170",
	"jeemmedialarabic" => "FEA0",
	"akatakanahalfwidth" => "FF71",
	"pagedown" => "21DF",
	"Acircumflex" => "00C2",
	"aarusquare" => "3303",
	"ecircumflex" => "00EA",
	"pdotaccent" => "1E57",
	"SF080000" => "251C",
	"vavholamhebrew" => "FB4B",
	"rabengali" => "09B0",
	"Rlinebelow" => "1E5E",
	"Ecircumflexgrave" => "1EC0",
	"revlogicalnot" => "2310",
	"finaltsadi" => "05E5",
	"afii10110" => "045E",
	"uhorndotbelow" => "1EF1",
	"thalfinalarabic" => "FEAC",
	"erbopomofo" => "3126",
	"Djecyrillic" => "0402",
	"madeva" => "092E",
	"controlHT" => "0009",
	"idieresisacute" => "1E2F",
	"sheqelhebrew" => "20AA",
	"ohornacute" => "1EDB",
	"kiyeokaparenkorean" => "320E",
	"nineteenperiod" => "249A",
	"colonsign" => "20A1",
	"umonospace" => "FF55",
	"dblanglebracketleft" => "300A",
	"heart" => "2665",
	"less" => "003C",
	"blackdiamond" => "25C6",
	"thieuthcirclekorean" => "326B",
	"ezh" => "0292",
	"babengali" => "09AC",
	"jaarmenian" => "0571",
	"vagurmukhi" => "0A35",
	"acutecomb" => "0301",
	"oubopomofo" => "3121",
	"smonospace" => "FF53",
	"sixinferior" => "2086",
	"otilde" => "00F5",
	"khahfinalarabic" => "FEA6",
	"SF380000" => "255A",
	"Acircumflexacute" => "1EA4",
	"kadeva" => "0915",
	"gravecmb" => "0300",
	"bracketleft" => "005B",
	"yoyingthai" => "0E0D",
	"whitecircleinverse" => "25D9",
	"Odblacute" => "0150",
	"lamedholamdagesh" => "05DC",
	"khomutthai" => "0E5B",
	"Ograve" => "00D2",
	"sevengujarati" => "0AED",
	"blackdownpointingtriangle" => "25BC",
	"wowaenthai" => "0E27",
	"wokatakanahalfwidth" => "FF66",
	"srsquare" => "33DB",
	"shadelight" => "2591",
	"controlFF" => "000C",
	"hatafpatahwidehebrew" => "05B2",
	"nineroman" => "2178",
	"Kcommaaccent" => "0136",
	"lammeemjeeminitialarabic" => "FEDF",
	"olehebrew" => "05AB",
	"commareversedabovecmb" => "0314",
	"labengali" => "09B2",
	"lamalefmaddaabovefinalarabic" => "FEF6",
	"semicolon" => "003B",
	"gcedilla" => "0123",
	"feicoptic" => "03E5",
	"btopbar" => "0183",
	"A" => "0041",
	"nadeva" => "0928",
	"minusplus" => "2213",
	"B" => "0042",
	"sarauethai" => "0E36",
	"notgreaternorequal" => "2271",
	"C" => "0043",
	"pointingindexrightwhite" => "261E",
	"D" => "0044",
	"wonmonospace" => "FFE6",
	"vavhebrew" => "05D5",
	"sevengurmukhi" => "0A6D",
	"blackleftpointingtriangle" => "25C0",
	"daletsegolhebrew" => "05D3",
	"overlinecmb" => "0305",
	"hcedilla" => "1E29",
	"E" => "0045",
	"tekatakanahalfwidth" => "FF83",
	"harpoonrightbarbup" => "21C0",
	"F" => "0046",
	"hatafqamats34" => "05B3",
	"uudeva" => "090A",
	"Tmonospace" => "FF34",
	"G" => "0047",
	"vavvavhebrew" => "05F0",
	"arrowdblboth" => "21D4",
	"H" => "0048",
	"finalkafsheva" => "05DA",
	"SF480000" => "2565",
	"hehfinalarabic" => "FEEA",
	"I" => "0049",
	"arrowupright" => "2197",
	"ladeva" => "0932",
	"J" => "004A",
	"Tecyrillic" => "0422",
	"circleot" => "2299",
	"dalethiriq" => "05D3 05B4",
	"K" => "004B",
	"tserehebrew" => "05B5",
	"KBsquare" => "3385",
	"nnabengali" => "09A3",
	"merkhakefulalefthebrew" => "05A6",
	"Ohm" => "2126",
	"controlFS" => "001C",
	"phinthuthai" => "0E3A",
	"L" => "004C",
	"threequarters" => "00BE",
	"corporationsquare" => "337F",
	"ninegurmukhi" => "0A6F",
	"afii57392" => "0660",
	"M" => "004D",
	"commasmall" => "FE50",
	"blacklenticularbracketright" => "3011",
	"afii57393" => "0661",
	"N" => "004E",
	"arrowleftdblstroke" => "21CD",
	"tahinitialarabic" => "FEC3",
	"ssangcieuckorean" => "3149",
	"sixteenperiod" => "2497",
	"dzcaron" => "01C6",
	"SF280000" => "255B",
	"afii57394" => "0662",
	"O" => "004F",
	"qamatsqatannarrowhebrew" => "05B8",
	"aadeva" => "0906",
	"kmsquaredsquare" => "33A2",
	"afii57395" => "0663",
	"P" => "0050",
	"whitelenticularbracketleft" => "3016",
	"Deicoptic" => "03EE",
	"oopen" => "0254",
	"afii57396" => "0664",
	"Q" => "0051",
	"control" => "2303",
	"nine" => "0039",
	"maitaikhuleftthai" => "F889",
	"dotaccentcmb" => "0307",
	"afii57397" => "0665",
	"R" => "0052",
	"whitecornerbracketleft" => "300E",
	"uhiragana" => "3046",
	"qafmedialarabic" => "FED8",
	"glottalstopstroke" => "02A1",
	"afii57398" => "0666",
	"S" => "0053",
	"venus" => "2640",
	"odblacute" => "0151",
	"afii57399" => "0667",
	"T" => "0054",
	"Hcedilla" => "1E28",
	"fourparen" => "2477",
	"IUcyrillic" => "042E",
	"U" => "0055",
	"afii10846" => "04D9",
	"pehinitialarabic" => "FB58",
	"V" => "0056",
	"Etilde" => "1EBC",
	"Gcircumflex" => "011C",
	"eightdeva" => "096E",
	"W" => "0057",
	"omegaroundcyrillic" => "047B",
	"shindageshshindothebrew" => "FB2C",
	"gereshaccenthebrew" => "059C",
	"chedescenderabkhasiancyrillic" => "04BF",
	"X" => "0058",
	"Ogoneksmall" => "F6FB",
	"pakatakana" => "30D1",
	"Omegaroundcyrillic" => "047A",
	"approxequalorimage" => "2252",
	"agrave" => "00E0",
	"kagujarati" => "0A95",
	"Y" => "0059",
	"rhook" => "027D",
	"parenleftbt" => "F8ED",
	"Z" => "005A",
	"Acircumflexhookabove" => "1EA8",
	"tikeutacirclekorean" => "3270",
	"thzsquare" => "3394",
	"telephoneblack" => "260E",
	"samekhdagesh" => "FB41",
	"khieukhcirclekorean" => "326A",
	"finalmemhebrew" => "05DD",
	"ograve" => "00F2",
	"nakatakana" => "30CA",
	"numbersign" => "0023",
	"atilde" => "00E3",
	"lmonospace" => "FF4C",
	"gershayimaccenthebrew" => "059E",
	"blackupperrighttriangle" => "25E5",
	"eukorean" => "3161",
	"sixthai" => "0E56",
	"reshhebrew" => "05E8",
	"magurmukhi" => "0A2E",
	"proportion" => "2237",
	"jheharmenian" => "057B",
	"yosmallhiragana" => "3087",
	"Ihookabove" => "1EC8",
	"postalmark" => "3012",
	"jmonospace" => "FF4A",
	"hatafpatah" => "05B2",
	"downtackbelowcmb" => "031E",
	"ordmasculine" => "00BA",
	"badeva" => "092C",
	"nuktadeva" => "093C",
	"yuyeokorean" => "318A",
	"kagurmukhi" => "0A15",
	"ecircumflexacute" => "1EBF",
	"threepersian" => "06F3",
	"qofpatah" => "05E7 05B7",
	"a" => "0061",
	"padeva" => "092A",
	"tchehinitialarabic" => "FB7C",
	"ordfeminine" => "00AA",
	"brokenbar" => "00A6",
	"hokatakanahalfwidth" => "FF8E",
	"b" => "0062",
	"afii08941" => "20A4",
	"ohiragana" => "304A",
	"twoperiod" => "2489",
	"jecyrillic" => "0458",
	"c" => "0063",
	"Vtilde" => "1E7C",
	"nunhebrew" => "05E0",
	"ypogegrammenigreekcmb" => "0345",
	"Fdotaccent" => "1E1E",
	"d" => "0064",
	"hahinitialarabic" => "FEA3",
	"fourhackarabic" => "0664",
	"e" => "0065",
	"yring" => "1E99",
	"Toarmenian" => "0539",
	"eokorean" => "3153",
	"f" => "0066",
	"anglebracketright" => "3009",
	"wehiragana" => "3091",
	"eightparen" => "247B",
	"Scarondotaccent" => "1E66",
	"numero" => "2116",
	"hungarumlautcmb" => "030B",
	"g" => "0067",
	"arrowheaddownmod" => "02C5",
	"h" => "0068",
	"eematragurmukhi" => "0A47",
	"udblacute" => "0171",
	"breveinverteddoublecmb" => "0361",
	"hhook" => "0266",
	"i" => "0069",
	"onedeva" => "0967",
	"j" => "006A",
	"deleteright" => "2326",
	"sixbengali" => "09EC",
	"seven" => "0037",
	"scarondotaccent" => "1E67",
	"noonhehinitialarabic" => "FEE7",
	"ideographichighcircle" => "32A4",
	"k" => "006B",
	"Kmonospace" => "FF2B",
	"l" => "006C",
	"whitedownpointingtriangle" => "25BD",
	"soliduslongoverlaycmb" => "0338",
	"hlinebelow" => "1E96",
	"nieunpansioskorean" => "3168",
	"m" => "006D",
	"maithothai" => "0E49",
	"beamedsixteenthnotes" => "266C",
	"n" => "006E",
	"afii300" => "200F",
	"Imonospace" => "FF29",
	"arc" => "2312",
	"fourpersian" => "06F4",
	"parenrightbt" => "F8F8",
	"o" => "006F",
	"cadeva" => "091A",
	"wohiragana" => "3092",
	"afii301" => "200D",
	"ainfinalarabic" => "FECA",
	"mekatakanahalfwidth" => "FF92",
	"p" => "0070",
	"qadeva" => "0958",
	"fourthai" => "0E54",
	"q" => "0071",
	"r" => "0072",
	"hehhamzaabovefinalarabic" => "FBA5",
	"pekatakana" => "30DA",
	"ihiragana" => "3044",
	"yekorean" => "3156",
	"underscorevertical" => "FE33",
	"ssangkiyeokkorean" => "3132",
	"s" => "0073",
	"ahookabove" => "1EA3",
	"afii57793" => "05B4",
	"afii57680" => "05E0",
	"t" => "0074",
	"questiongreek" => "037E",
	"firsttonechinese" => "02C9",
	"afii57794" => "05B5",
	"Iecyrillic" => "0415",
	"afii57681" => "05E1",
	"u" => "0075",
	"reshhatafsegol" => "05E8",
	"Ugrave" => "00D9",
	"etilde" => "1EBD",
	"afii57795" => "05B6",
	"overlinewavy" => "FE4B",
	"afii57682" => "05E2",
	"yiwnarmenian" => "0582",
	"v" => "0076",
	"clicklateral" => "01C1",
	"afii57796" => "05BB",
	"afii57683" => "05E3",
	"w" => "0077",
	"afii57797" => "05B8",
	"nakatakanahalfwidth" => "FF85",
	"afii57684" => "05E4",
	"x" => "0078",
	"afii57798" => "05B7",
	"afii57685" => "05E5",
	"y" => "0079",
	"seenfinalarabic" => "FEB2",
	"gdotaccent" => "0121",
	"nikhahitleftthai" => "F899",
	"afii57799" => "05B0",
	"Egrave" => "00C8",
	"afii57686" => "05E6",
	"dalfinalarabic" => "FEAA",
	"Utilde" => "0168",
	"z" => "007A",
	"dagger" => "2020",
	"curlyor" => "22CE",
	"holamnarrowhebrew" => "05B9",
	"eta" => "03B7",
	"afii57687" => "05E7",
	"maichattawalowrightthai" => "F894",
	"question" => "003F",
	"khokhwaithai" => "0E04",
	"afii57688" => "05E8",
	"DieresisAcute" => "F6CC",
	"ideographicmedicinecircle" => "32A9",
	"ninearabic" => "0669",
	"afii57689" => "05E9",
	"yukorean" => "3160",
	"sheva" => "05B0",
	"questionsmall" => "F73F",
	"qofholamhebrew" => "05E7",
	"controlBS" => "0008",
	"controlNAK" => "0015",
	"Obarreddieresiscyrillic" => "04EA",
	"ecandravowelsigndeva" => "0945",
	"tchehmedialarabic" => "FB7D",
	"pabengali" => "09AA",
	"reshpatah" => "05E8",
	"gakatakana" => "30AC",
	"dadeva" => "0926",
	"bagujarati" => "0AAC",
	"abengali" => "0985",
	"wihiragana" => "3090",
	"Koppacyrillic" => "0480",
	"Ohorndotbelow" => "1EE2",
	"NJ" => "01CA",
	"svsquare" => "33DC",
	"segoltahebrew" => "0592",
	"radeva" => "0930",
	"lamjeeminitialarabic" => "FCC9",
	"dollarinferior" => "F6E3",
	"eth" => "00F0",
	"dagurmukhi" => "0A26",
	"vavdagesh65" => "FB35",
	"ddagujarati" => "0AA1",
	"pisymbolgreek" => "03D6",
	"chedieresiscyrillic" => "04F5",
	"xdieresis" => "1E8D",
	"circumflex" => "02C6",
	"bracketrightbt" => "F8FB",
	"equal" => "003D",
	"yokorean" => "315B",
	"spacehackarabic" => "0020",
	"bagurmukhi" => "0A2C",
	"ideographicsuperviseparen" => "323C",
	"Pi" => "03A0",
	"hahfinalarabic" => "FEA2",
	"eightbengali" => "09EE",
	"hbrevebelow" => "1E2B",
	"tesh" => "02A7",
	"ieungparenkorean" => "3207",
	"merkhalefthebrew" => "05A5",
	"bulletinverse" => "25D8",
	"iivowelsigndeva" => "0940",
	"parallel" => "2225",
	"eighteencircle" => "2471",
	"denominatorminusonenumeratorbengali" => "09F8",
	"aringacute" => "01FB",
	"edot" => "0117",
	"fivegujarati" => "0AEB",
	"mssquare" => "33B3",
	"rvocalicvowelsigndeva" => "0943",
	"nehiragana" => "306D",
	"hatafqamats1b" => "05B3",
	"rukatakana" => "30EB",
	"nssquare" => "33B1",
	"yikorean" => "3162",
	"afii57664" => "05D0",
	"pukatakana" => "30D7",
	"afii57665" => "05D1",
	"afii57440" => "0640",
	"Igrave" => "00CC",
	"afii57666" => "05D2",
	"Ytilde" => "1EF8",
	"yr" => "01A6",
	"yehmedialarabic" => "FEF4",
	"verticallinelowmod" => "02CC",
	"tavhebrew" => "05EA",
	"cornerbracketright" => "300D",
	"afii57441" => "0641",
	"afii57667" => "05D3",
	"lolingthai" => "0E25",
	"Bmonospace" => "FF22",
	"afii57442" => "0642",
	"afii57668" => "05D4",
	"reshqubuts" => "05E8",
	"afii57443" => "0643",
	"asciitilde" => "007E",
	"chochanthai" => "0E08",
	"afii57669" => "05D5",
	"lamalefisolatedarabic" => "FEFB",
	"Wgrave" => "1E80",
	"squareupperlefttolowerrightfill" => "25A7",
	"rreharabic" => "0691",
	"rdblgrave" => "0211",
	"afii57444" => "0644",
	"Itilde" => "0128",
	"ideographicmetalparen" => "322E",
	"hatafqamats" => "05B3",
	"alefpatahhebrew" => "FB2E",
	"afii57445" => "0645",
	"chekhakassiancyrillic" => "04CC",
	"kaverticalstrokecyrillic" => "049D",
	"lesssmall" => "FE64",
	"nmsquare" => "339A",
	"afii57446" => "0646",
	"palatalizationcyrilliccmb" => "0484",
	"edeva" => "090F",
	"egrave" => "00E8",
	"elevenperiod" => "2492",
	"block" => "2588",
	"LJ" => "01C7",
	"Zhedescendercyrillic" => "0496",
	"Cheverticalstrokecyrillic" => "04B8",
	"afii57448" => "0648",
	"trademarksans" => "F8EA",
	"afii57449" => "0649",
	"istroke" => "0268",
	"tthabengali" => "09A0",
	"tserenarrowhebrew" => "05B5",
	"evowelsigndeva" => "0947",
	"LL" => "F6BF",
	"nlegrightlong" => "019E",
	"rupiah" => "F6DD",
	"quoteleftreversed" => "201B",
	"periodarmenian" => "0589",
	"Caronsmall" => "F6F5",
	"zerothai" => "0E50",
	"twothai" => "0E52",
	"rokatakana" => "30ED",
	"rikatakanahalfwidth" => "FF98",
	"finalkafdageshhebrew" => "FB3A",
	"Adieresissmall" => "F7E4",
	"dammalowarabic" => "064F",
	"onecircleinversesansserif" => "278A",
	"fadeva" => "095E",
	"SF210000" => "2556",
	"kgreenlandic" => "0138",
	"Nj" => "01CB",
	"pokatakana" => "30DD",
	"oomatragurmukhi" => "0A4B",
	"Ohorntilde" => "1EE0",
	"parenrightsuperior" => "207E",
	"oogurmukhi" => "0A13",
	"Iocyrillic" => "0401",
	"questionarabic" => "061F",
	"Chook" => "0187",
	"sekatakanahalfwidth" => "FF7E",
	"SF010000" => "250C",
	"whitecornerbracketright" => "300F",
	"rehfinalarabic" => "FEAE",
	"pehmedialarabic" => "FB59",
	"cosquare" => "33C7",
	"ellipsisvertical" => "22EE",
	"colonsmall" => "FE55",
	"Dzcaron" => "01C5",
	"weierstrass" => "2118",
	"shinshindot" => "FB2A",
	"aivowelsigngujarati" => "0AC8",
	"cieuckorean" => "3148",
	"Ocyrillic" => "041E",
	"rfishhook" => "027E",
	"afii57645" => "05BE",
	"dtopbar" => "018C",
	"khook" => "0199",
	"ahiragana" => "3042",
	"chabengali" => "099B",
	"afii57420" => "062C",
	"oekorean" => "315A",
	"amonospace" => "FF41",
	"Koppagreek" => "03DE",
	"threethai" => "0E53",
	"alefmaksuramedialarabic" => "FEF4",
	"afii57421" => "062D",
	"nasquare" => "3381",
	"afii57534" => "06D5",
	"afii57422" => "062E",
	"Rcedilla" => "0156",
	"nuhiragana" => "306C",
	"Nu" => "039D",
	"Lcircumflexbelow" => "1E3C",
	"secondtonechinese" => "02CA",
	"rikatakana" => "30EA",
	"afii57423" => "062F",
	"fiveparen" => "2478",
	"ghagurmukhi" => "0A18",
	"Gstroke" => "01E4",
	"periodmonospace" => "FF0E",
	"yhookabove" => "1EF7",
	"twelveparen" => "247F",
	"triagrt" => "25BA",
	"afii57424" => "0630",
	"Udieresisbelow" => "1E72",
	"eightideographicparen" => "3227",
	"deleteleft" => "232B",
	"iniarmenian" => "056B",
	"tehjeeminitialarabic" => "FCA1",
	"afii57425" => "0631",
	"osmallkatakanahalfwidth" => "FF6B",
	"qoftserehebrew" => "05E7",
	"percent" => "0025",
	"afii57426" => "0632",
	"pikatakana" => "30D4",
	"afii57427" => "0633",
	"underscoredbl" => "2017",
	"squarehorizontalfill" => "25A4",
	"afii57428" => "0634",
	"dalethatafpatahhebrew" => "05D3",
	"cieuccirclekorean" => "3268",
	"afii57429" => "0635",
	"bhagurmukhi" => "0A2D",
	"thothahanthai" => "0E17",
	"SF110000" => "2502",
	"Ygrave" => "1EF2",
	"etnahtahebrew" => "0591",
	"Kabashkircyrillic" => "04A0",
	"OEsmall" => "F6FA",
	"qofhebrew" => "05E7",
	"gukatakana" => "30B0",
	"squarediagonalcrosshatchfill" => "25A9",
	"kcommaaccent" => "0137",
	"Dcroat" => "0110",
	"thousandcyrillic" => "0482",
	"afii57841" => "05BF",
	"haharabic" => "062D",
	"greater" => "003E",
	"Icyrillic" => "0406",
	"ecyrillic" => "0454",
	"afii57842" => "05C0",
	"ivowelsignbengali" => "09BF",
	"Lj" => "01C8",
	"nikhahitthai" => "0E4D",
	"logicaland" => "2227",
	"palochkacyrillic" => "04C0",
	"saraaethai" => "0E41",
	"qofhatafsegolhebrew" => "05E7",
	"nohiragana" => "306E",
	"ringhalfleftarmenian" => "0559",
	"arrowtabright" => "21E5",
	"Ugravesmall" => "F7F9",
	"dalarabic" => "062F",
	"sioscieuckorean" => "317E",
	"shalshelethebrew" => "0593",
	"gekatakana" => "30B2",
	"Kahookcyrillic" => "04C3",
	"Btopbar" => "0182",
	"seenarabic" => "0633",
	"SF410000" => "2566",
	"ymonospace" => "FF59",
	"Ntilde" => "00D1",
	"audeva" => "0914",
	"hedagesh" => "FB34",
	"zagurmukhi" => "0A5B",
	"sevenpersian" => "06F7",
	"sevenperiod" => "248E",
	"Tbar" => "0166",
	"afii57511" => "0679",
	"wmonospace" => "FF57",
	"udieresisgrave" => "01DC",
	"acircumflexhookabove" => "1EA9",
	"Ocircumflexacute" => "1ED0",
	"afii57512" => "0688",
	"omgujarati" => "0AD0",
	"Ohorngrave" => "1EDC",
	"lamalefhamzabelowfinalarabic" => "FEFA",
	"afii57513" => "0691",
	"afii57400" => "0668",
	"ubengali" => "0989",
	"breveinvertedcmb" => "0311",
	"afii57514" => "06BA",
	"ncircumflexbelow" => "1E4B",
	"afii57401" => "0669",
	"cedillacmb" => "0327",
	"lsquare" => "2113",
	"eight" => "0038",
	"dmacron" => "0111",
	"kashidaautonosidebearingarabic" => "0640",
	"afii57403" => "061B",
	"gokatakana" => "30B4",
	"yehbarreearabic" => "06D2",
	"thagurmukhi" => "0A25",
	"shaddaarabic" => "0651",
	"Yuslittleiotifiedcyrillic" => "0468",
	"afii61289" => "2113",
	"Udieresissmall" => "F7FC",
	"Sdotaccent" => "1E60",
	"percentmonospace" => "FF05",
	"afii57519" => "06D2",
	"eng" => "014B",
	"afii57407" => "061F",
	"nihiragana" => "306B",
	"hatafqamatsquarterhebrew" => "05B3",
	"Atilde" => "00C3",
	"afii57409" => "0621",
	"tchehfinalarabic" => "FB7B",
	"mwsquare" => "33BD",
	"SF510000" => "2552",
	"phisymbolgreek" => "03D5",
	"Otilde" => "00D5",
	"allequal" => "224C",
	"ssagujarati" => "0AB7",
	"Xmonospace" => "FF38",
	"nun" => "05E0",
	"daletqubutshebrew" => "05D3",
	"dblprimemod" => "02BA",
	"holam" => "05B9",
	"squareln" => "33D1",
	"dalethatafpatah" => "05D3",
	"macronmonospace" => "FFE3",
	"threeinferior" => "2083",
	"phieuphacirclekorean" => "327A",
	"Vmonospace" => "FF36",
	"deltaturned" => "018D",
	"voicedmarkkana" => "309B",
	"Phook" => "01A4",
	"jhagurmukhi" => "0A1D",
	"yoyaekorean" => "3188",
	"yerudieresiscyrillic" => "04F9",
	"makatakanahalfwidth" => "FF8F",
	"hatafsegolquarterhebrew" => "05B1",
	"dcroat" => "0111",
	"gikatakana" => "30AE",
	"ucyrillic" => "0443",
	"ecircumflexdotbelow" => "1EC7",
	"Vecyrillic" => "0412",
	"three" => "0033",
	"Vewarmenian" => "054E",
	"Agravesmall" => "F7E0",
	"element" => "2208",
	"orthogonal" => "221F",
	"afii57716" => "05F0",
	"afii57717" => "05F1",
	"Tau" => "03A4",
	"yahiragana" => "3084",
	"afii57718" => "05F2",
	"plusminus" => "00B1",
	"tdotaccent" => "1E6B",
	"saraithai" => "0E34",
	"qofsheva" => "05E7",
	"hookretroflexbelowcmb" => "0322",
	"chagujarati" => "0A9B",
	"trademark" => "2122",
	"maiekthai" => "0E48",
	"upsilondieresistonos" => "03B0",
	"ssangsioskorean" => "3146",
	"bracketleftex" => "F8EF",
	"Uhorn" => "01AF",
	"shindageshsindot" => "FB2D",
	"saraueethai" => "0E37",
	"ninethai" => "0E59",
	"Gcedilla" => "0122",
	"Iniarmenian" => "053B",
	"rieultikeutkorean" => "316A",
	"maichattawathai" => "0E4B",
	"lmiddletilde" => "026B",
	"Hzsquare" => "3390",
	"takatakana" => "30BF",
	"qamatsde" => "05B8",
	"kiyeokparenkorean" => "3200",
	"iota" => "03B9",
	"Tlinebelow" => "1E6E",
	"qamatsqatanhebrew" => "05B8",
	"dieresis" => "00A8",
	"mmsquaredsquare" => "339F",
	"rcommaaccent" => "0157",
	"fofathai" => "0E1D",
	"asterisk" => "002A",
	"circlewithrighthalfblack" => "25D1",
	"Sheicoptic" => "03E2",
	"Fhook" => "0191",
	"dblgrave" => "F6D6",
	"lessequal" => "2264",
	"rakatakana" => "30E9",
	"SF040000" => "2518",
	"ainvertedbreve" => "0203",
	"Ohookabove" => "1ECE",
	"dblverticalbar" => "2016",
	"kukatakanahalfwidth" => "FF78",
	"paampssquare" => "3380",
	"plusbelowcmb" => "031F",
	"magujarati" => "0AAE",
	"yakorean" => "3151",
	"gstroke" => "01E5",
	"asterism" => "2042",
	"wavedash" => "301C",
	"thanthakhatlowrightthai" => "F897",
	"arrowright" => "2192",
	"dezh" => "02A4",
	"Kacyrillic" => "041A",
	"ideographicstudyparen" => "323B",
	"ideographiclaborparen" => "3238",
	"lamalefmaddaaboveisolatedarabic" => "FEF5",
	"ocyrillic" => "043E",
	"eightgujarati" => "0AEE",
	"backslash" => "005C",
	"Rdotbelowmacron" => "1E5C",
	"Ustraightcyrillic" => "04AE",
	"afii57800" => "05B2",
	"ehiragana" => "3048",
	"afii57801" => "05B1",
	"yamakkanthai" => "0E4E",
	"triaglf" => "25C4",
	"patahquarterhebrew" => "05B7",
	"Acircumflexdotbelow" => "1EAC",
	"afii61573" => "202C",
	"afii57802" => "05B3",
	"idieresiscyrillic" => "04E5",
	"thousandsseparatorpersian" => "066C",
	"sukatakanahalfwidth" => "FF7D",
	"rdotbelowmacron" => "1E5D",
	"qofsegolhebrew" => "05E7 05B6",
	"afii61574" => "202D",
	"afii57803" => "05C2",
	"Schwacyrillic" => "04D8",
	"cyrbreve" => "F6D4",
	"tsadidageshhebrew" => "FB46",
	"rdotbelow" => "1E5B",
	"Vdotbelow" => "1E7E",
	"afii61575" => "202E",
	"guramusquare" => "3318",
	"afii57804" => "05C1",
	"qofqubuts" => "05E7 05BB",
	"alefhamzaabovefinalarabic" => "FE84",
	"ereversedcyrillic" => "044D",
	"Caron" => "F6CA",
	"eightmonospace" => "FF18",
	"thieuthkorean" => "314C",
	"fivecircleinversesansserif" => "278E",
	"Agrave" => "00C0",
	"afii57806" => "05B9",
	"yetivhebrew" => "059A",
	"uogonek" => "0173",
	"afii61352" => "2116",
	"eightgurmukhi" => "0A6E",
	"afii57807" => "05BC",
	"Etatonos" => "0389",
	"two" => "0032",
	"qadmahebrew" => "05A8",
	"zaqefgadolhebrew" => "0595",
	"tsere2b" => "05B5",
	"tildeoverlaycmb" => "0334",
	"shademedium" => "2592",
	"Acutesmall" => "F7B4",
	"cheverticalstrokecyrillic" => "04B9",
	"nieunhieuhkorean" => "3136",
	"threemonospace" => "FF13",
	"sixgujarati" => "0AEC",
	"Voarmenian" => "0548",
	"lammeeminitialarabic" => "FCCC",
	"centinferior" => "F6DF",
	"hiriqquarterhebrew" => "05B4",
	"arrowleft" => "2190",
	"bracketrightmonospace" => "FF3D",
	"threeparen" => "2476",
	"Omonospace" => "FF2F",
	"minusmod" => "02D7",
	"psi" => "03C8",
	"phagujarati" => "0AAB",
	"Acircumflexsmall" => "F7E2",
	"llinebelow" => "1E3B",
	"ccurl" => "0255",
	"icyrillic" => "0456",
	"engbopomofo" => "3125",
	"eiotifiedcyrillic" => "0465",
	"ovowelsigndeva" => "094B",
	"Igravesmall" => "F7EC",
	"Mmonospace" => "FF2D",
	"afii61248" => "2105",
	"tteharabic" => "0679",
	"rupeesignbengali" => "09F3",
	"reshsheva" => "05E8 05B0",
	"patah2a" => "05B7",
	"oogonek" => "01EB",
	"tdieresis" => "1E97",
	"sixgurmukhi" => "0A6C",
	"infinity" => "221E",
	"Rinvertedbreve" => "0212",
	"Xdieresis" => "1E8C",
	"ssadeva" => "0937",
	"rieulpansioskorean" => "316C",
	"ldotbelow" => "1E37",
	"koppacyrillic" => "0481",
	"ohorndotbelow" => "1EE3",
	"dieresisgrave" => "F6D8",
	"ideographsuncircle" => "3290",
	"ssabengali" => "09B7",
	"khagujarati" => "0A96",
	"aleflamedhebrew" => "FB4F",
	"phagurmukhi" => "0A2B",
	"SF440000" => "256C",
	"okatakanahalfwidth" => "FF75",
	"blackrectangle" => "25AC",
	"sosalathai" => "0E28",
	"kasratanarabic" => "064D",
	"euro" => "20AC",
	"ezhtail" => "01BA",
	"pahiragana" => "3071",
	"zhedescendercyrillic" => "0497",
	"yicyrillic" => "0457",
	"vavdagesh" => "FB35",
	"Hdieresis" => "1E26",
	"oe" => "0153",
	"jcrossedtail" => "029D",
	"afii61664" => "200C",
	"ratio" => "2236",
	"Omacrongrave" => "1E50",
	"nhookretroflex" => "0273",
	"zeroarabic" => "0660",
	"reshdageshhebrew" => "FB48",
	"rekatakanahalfwidth" => "FF9A",
	"qofhatafsegol" => "05E7 05B1",
	"ohornhookabove" => "1EDF",
	"iogonek" => "012F",
	"arrowdblright" => "21D2",
	"nahiragana" => "306A",
	"ringhalfleft" => "02BF",
	"ereversed" => "0258",
	"asciicircum" => "005E",
	"SF240000" => "2551",
	"chi" => "03C7",
	"upsilonlatin" => "028A",
	"khagurmukhi" => "0A16",
	"oi" => "01A3",
	"etatonos" => "03AE",
	"cmsquaredsquare" => "33A0",
	"whitesmilingface" => "263A",
	"onequarter" => "00BC",
	"onehalf" => "00BD",
	"squaremsquared" => "33A1",
	"gimel" => "05D2",
	"Klinebelow" => "1E34",
	"pehebrew" => "05E4",
	"Schwadieresiscyrillic" => "04DA",
	"righttriangle" => "22BF",
	"rhabengali" => "09DD",
	"chagurmukhi" => "0A1B",
	"ezhreversed" => "01B9",
	"zeta" => "03B6",
	"viramabengali" => "09CD",
	"qofholam" => "05E7 05B9",
	"dieresistonos" => "0385",
	"bqsquare" => "33C3",
	"calsquare" => "3388",
	"dagujarati" => "0AA6",
	"Scommaaccent" => "0218",
	"phabengali" => "09AB",
	"DZ" => "01F1",
	"Rdblgrave" => "0210",
	"nmonospace" => "FF4E",
	"invbullet" => "25D8",
	"ideographichaveparen" => "3232",
	"uinvertedbreve" => "0217",
	"SF540000" => "256A",
	"khahmedialarabic" => "FEA8",
	"caarmenian" => "056E",
	"sevenhackarabic" => "0667",
	"qamats33" => "05B8",
	"hatafpatah16" => "05B2",
	"alefdageshhebrew" => "FB30",
	"seventhai" => "0E57",
	"fournumeratorbengali" => "09F7",
	"filledrect" => "25AC",
	"dcircumflexbelow" => "1E13",
	"perthousand" => "2030",
	"fourcircle" => "2463",
	"honokhukthai" => "0E2E",
	"Oogonekmacron" => "01EC",
	"onenumeratorbengali" => "09F4",
	"cieucacirclekorean" => "3276",
	"yuhiragana" => "3086",
	"vcircle" => "24E5",
	"geometricallyequal" => "2251",
	"integral" => "222B",
	"asterisksmall" => "FE61",
	"cornerbracketlefthalfwidth" => "FF62",
	"dadarabic" => "0636",
	"arrowdownleft" => "2199",
	"rrabengali" => "09DC",
	"Imacroncyrillic" => "04E2",
	"daggerdbl" => "2021",
	"wattosquare" => "3357",
	"sevencircleinversesansserif" => "2790",
	"scaron" => "0161",
	"arrowdashright" => "21E2",
	"braceleftsmall" => "FE5B",
	"AEsmall" => "F7E6",
	"segolhebrew" => "05B6",
	"Hdotaccent" => "1E22",
	"Acyrillic" => "0410",
	"odeva" => "0913",
	"imacroncyrillic" => "04E3",
	"Istroke" => "0197",
	"kiyeoksioskorean" => "3133",
	"sheva15" => "05B0",
	"mlonglegturned" => "0270",
	"tonebarlowmod" => "02E8",
	"theharabic" => "062B",
	"qamatsnarrowhebrew" => "05B8",
	"qafinitialarabic" => "FED7",
	"tukatakana" => "30C4",
	"Omegatonos" => "038F",
	"hdieresis" => "1E27",
	"daletqamatshebrew" => "05D3",
	"kasmallkatakana" => "30F5",
	"ivowelsigngujarati" => "0ABF",
	"wynn" => "01BF",
	"ringhalfrightbelowcmb" => "0339",
	"Ddotbelow" => "1E0C",
	"pcircle" => "24DF",
	"invcircle" => "25D9",
	"reshshevahebrew" => "05E8",
	"hehmedialaltonearabic" => "FBA9",
	"barmonospace" => "FF5C",
	"shagujarati" => "0AB6",
	"moverssquaredsquare" => "33A8",
	"openbullet" => "25E6",
	"period" => "002E",
	"dhook" => "0257",
	"ideographicclose" => "3006",
	"yukatakanahalfwidth" => "FF95",
	"tekatakana" => "30C6",
	"reversedtilde" => "223D",
	"alefmaksurafinalarabic" => "FEF0",
	"Dzhecyrillic" => "040F",
	"yohiragana" => "3088",
	"viramadeva" => "094D",
	"tehmeeminitialarabic" => "FCA4",
	"ideographiczero" => "3007",
	"ehookabove" => "1EBB",
	"Yerudieresiscyrillic" => "04F8",
	"Ogravesmall" => "F7F2",
	"Upsilondieresishooksymbolgreek" => "03D4",
	"logicalnotreversed" => "2310",
	"tcaron" => "0165",
	"rekatakana" => "30EC",
	"meemfinalarabic" => "FEE2",
	"lameddagesh" => "FB3C",
	"ring" => "02DA",
	"Yusbigiotifiedcyrillic" => "046C",
	"arrowdashdown" => "21E3",
	"dddhadeva" => "095C",
	"behfinalarabic" => "FE90",
	"qamats10" => "05B8",
	"dotbelowcomb" => "0323",
	"Ocircumflexdotbelow" => "1ED8",
	"HPsquare" => "33CB",
	"esmallkatakanahalfwidth" => "FF6A",
	"jcircle" => "24D9",
	"shagurmukhi" => "0A36",
	"onebengali" => "09E7",
	"Uhornhookabove" => "1EEC",
	"Dtopbar" => "018B",
	"newsheqelsign" => "20AA",
	"Cedillasmall" => "F7B8",
	"vokatakana" => "30FA",
	"one" => "0031",
	"reshholam" => "05E8",
	"alef" => "05D0",
	"asciitildemonospace" => "FF5E",
	"shadeva" => "0936",
	"tokatakana" => "30C8",
	"phieuphaparenkorean" => "321A",
	"arrowleftdbl" => "21D0",
	"vdotbelow" => "1E7F",
	"tenperiod" => "2491",
	"ddhadeva" => "0922",
	"gafmedialarabic" => "FB95",
	"lowlinecmb" => "0332",
	"Uhungarumlautcyrillic" => "04F2",
	"afii63167" => "066D",
	"mu" => "00B5",
	"bet" => "05D1",
	"yyadeva" => "095F",
	"yehthreedotsbelowarabic" => "06D1",
	"eighteenparen" => "2485",
	"Zdotbelow" => "1E92",
	"ngonguthai" => "0E07",
	"evowelsignbengali" => "09C7",
	"ideographearthcircle" => "328F",
	"Blinebelow" => "1E06",
	"Dz" => "01F2",
	"wawarabic" => "0648",
	"maqafhebrew" => "05BE",
	"kekatakanahalfwidth" => "FF79",
	"ampersandmonospace" => "FF06",
	"Ecyrillic" => "0404",
	"dcircle" => "24D3",
	"acyrillic" => "0430",
	"aringbelow" => "1E01",
	"fivedeva" => "096B",
	"Egravesmall" => "F7E8",
	"yaadosquare" => "334E",
	"tehhahisolatedarabic" => "FC0C",
	"arrowboth" => "2194",
	"fouroldstyle" => "F734",
	"Macronsmall" => "F7AF",
	"finalpe" => "05E3",
	"pieupacirclekorean" => "3273",
	"gcaron" => "01E7",
	"zero" => "0030",
	"Idieresisacute" => "1E2E",
	"ucaron" => "01D4",
	"tusmallkatakana" => "30C3",
	"tavdageshhebrew" => "FB4A",
	"ghabengali" => "0998",
	"emonospace" => "FF45",
	"aubopomofo" => "3120",
	"dhagujarati" => "0AA7",
	"glottalinvertedstroke" => "01BE",
	"tilde" => "02DC",
	"schwa" => "0259",
	"wawhamzaabovefinalarabic" => "FE86",
	"qubutsnarrowhebrew" => "05BB",
	"ddotbelow" => "1E0D",
	"ghagujarati" => "0A98",
	"ideographicfinancialcircle" => "3296",
	"exclamarmenian" => "055C",
	"eightarabic" => "0668",
	"fagurmukhi" => "0A5E",
	"Hdotbelow" => "1E24",
	"vikatakana" => "30F8",
	"vewarmenian" => "057E",
	"ruhiragana" => "308B",
	"finalkafdagesh" => "FB3A",
	"twoideographicparen" => "3221",
	"cmonospace" => "FF43",
	"hohipthai" => "0E2B",
	"vavyodhebrew" => "05F1",
	"logicalnot" => "00AC",
	"puhiragana" => "3077",
	"tikatakana" => "30C1",
	"rvocalicvowelsignbengali" => "09C3",
	"rafe" => "05BF",
	"dhagurmukhi" => "0A27",
	"udattadeva" => "0951",
	"shade" => "2592",
	"Tdotbelow" => "1E6C",
	"nineideographicparen" => "3228",
	"subset" => "2282",
	"bhagujarati" => "0AAD",
	"ninecircleinversesansserif" => "2792",
	"DZcaron" => "01C4",
	"wikorean" => "315F",
	"twoinferior" => "2082",
	"ghadeva" => "0918",
	"periodinferior" => "F6E7",
	"eshortdeva" => "090E",
	"tortoiseshellbracketrightsmall" => "FE5E",
	"Eogonek" => "0118",
	"alefhamzabelowarabic" => "0625",
	"zaharabic" => "0638",
	"twentyhangzhou" => "5344",
	"nnnadeva" => "0929",
	"pehiragana" => "307A",
	"whitelenticularbracketright" => "3017",
	"samekhdageshhebrew" => "FB41",
	"mahapakhhebrew" => "05A4",
	"controlESC" => "001B",
	"tevirhebrew" => "059B",
	"qubuts31" => "05BB",
	"ideographicprintcircle" => "329E",
	"bridgebelowcmb" => "032A",
	"tortoiseshellbracketleftsmall" => "FE5D",
	"hahmedialarabic" => "FEA4",
	"ideographicexcellentcircle" => "329D",
	"jis" => "3004",
	"endashvertical" => "FE32",
	"Dmonospace" => "FF24",
	"otcyrillic" => "047F",
	"zdotbelow" => "1E93",
	"rohiragana" => "308D",
	"SF270000" => "255C",
	"ivowelsigndeva" => "093F",
	"lmsquare" => "33D0",
	"Emacrongrave" => "1E14",
	"iotalatin" => "0269",
	"copyrightsans" => "F8E9",
	"Bdotbelow" => "1E04",
	"saraaimaimalaithai" => "0E44",
	"acircumflextilde" => "1EAB",
	"alefmaddaabovefinalarabic" => "FE82",
	"Eightroman" => "2167",
	"kekatakana" => "30B1",
	"slongdotaccent" => "1E9B",
	"lessequalorgreater" => "22DA",
	"pohiragana" => "307D",
	"peezisquare" => "333B",
	"otildedieresis" => "1E4F",
	"angle" => "2220",
	"Decyrillic" => "0414",
	"Lslashsmall" => "F6F9",
	"foursuperior" => "2074",
	"prescription" => "211E",
	"quotesinglbase" => "201A",
	"Shimacoptic" => "03EC",
	"Kadescendercyrillic" => "049A",
	"eopenreversedclosed" => "025E",
	"rukatakanahalfwidth" => "FF99",
	"gheupturncyrillic" => "0491",
	"Ndotbelow" => "1E46",
	"Ifraktur" => "2111",
	"muchgreater" => "226B",
	"nokatakanahalfwidth" => "FF89",
	"Becyrillic" => "0411",
	"sadmedialarabic" => "FEBC",
	"Gangiacoptic" => "03EA",
	"Ucyrillic" => "0423",
	"asymptoticallyequal" => "2243",
	"adeva" => "0905",
	"vehfinalarabic" => "FB6B",
	"thagujarati" => "0AA5",
	"taharabic" => "0637",
	"eshortvowelsigndeva" => "0946",
	"thonangmonthothai" => "0E11",
	"tavdagesh" => "FB4A",
	"sioskorean" => "3145",
	"qhook" => "02A0",
	"oharmenian" => "0585",
	"anglebracketleft" => "3008",
	"primereversed" => "2035",
	"alpha" => "03B1",
	"H18551" => "25AB",
	"icaron" => "01D0",
	"ij" => "0133",
	"aibopomofo" => "311E",
	"Acute" => "F6C9",
	"zdot" => "017C",
	"yehhamzaabovefinalarabic" => "FE8A",
	"whiteuppointingsmalltriangle" => "25B5",
	"arrowdashup" => "21E1",
	"tdotbelow" => "1E6D",
	"dblgravecmb" => "030F",
	"ideographicleftcircle" => "32A7",
	"prolongedkana" => "30FC",
	"zcircle" => "24E9",
	"sevenoldstyle" => "F737",
	"rihiragana" => "308A",
	"angbopomofo" => "3124",
	"kwsquare" => "33BE",
	"SF370000" => "255F",
	"Kappa" => "039A",
	"triagdn" => "25BC",
	"coarmenian" => "0581",
	"propersuperset" => "2283",
	"kpasquare" => "33AA",
	"qamats1a" => "05B8",
	"lessorgreater" => "2276",
	"candrabindugujarati" => "0A81",
	"grave" => "0060",
	"fehinitialarabic" => "FED3",
	"eighthnotebeamed" => "266B",
	"reshqamats" => "05E8 05B8",
	"pihiragana" => "3074",
	"rlonglegturned" => "027A",
	"qamats1c" => "05B8",
	"aogonek" => "0105",
	"yodhebrew" => "05D9",
	"shaddakasraarabic" => "FC62",
	"mars" => "2642",
	"khadeva" => "0916",
	"mulsquare" => "3395",
	"bar" => "007C",
	"nineparen" => "247C",
	"Sacutedotaccent" => "1E64",
	"zcaron" => "017E",
	"rrvocalicvowelsigngujarati" => "0AC4",
	"nineoldstyle" => "F739",
	"masquare" => "3383",
	"ibopomofo" => "3127",
	"periodhalfwidth" => "FF61",
	"jhagujarati" => "0A9D",
	"hehhamzaaboveisolatedarabic" => "FBA4",
	"Zmonospace" => "FF3A",
	"khieukhkorean" => "314B",
	"tcircle" => "24E3",
	"segol" => "05B6",
	"Esh" => "01A9",
	"sacutedotaccent" => "1E65",
	"yodyodpatahhebrew" => "FB1F",
	"twopersian" => "06F2",
	"takatakanahalfwidth" => "FF80",
	"qubuts18" => "05BB",
	"Ezhreversed" => "01B8",
	"hadescendercyrillic" => "04B3",
	"noonjeemisolatedarabic" => "FC4B",
	"aring" => "00E5",
	"jcaron" => "01F0",
	"oneinferior" => "2081",
	"yehmeemisolatedarabic" => "FC58",
	"second" => "2033",
	"dotbelowcmb" => "0323",
	"fifteenperiod" => "2496",
	"quoteright" => "2019",
	"fourteenparen" => "2481",
	"mufsquare" => "338C",
	"mcubedsquare" => "33A5",
	"araeaekorean" => "318E",
	"hamzalowarabic" => "0621",
	"tonos" => "0384",
	"Rdotbelow" => "1E5A",
	"ndotbelow" => "1E47",
	"apple" => "F8FF",
	"het" => "05D7",
	"whiterightpointingtriangle" => "25B7",
	"squarekmcapital" => "33CE",
	"Liwnarmenian" => "053C",
	"arighthalfring" => "1E9A",
	"fiveperiod" => "248C",
	"hieuhaparenkorean" => "321B",
	"SF470000" => "2564",
	"gehiragana" => "3052",
	"xdotaccent" => "1E8B",
	"quotedblprime" => "301E",
	"gafinitialarabic" => "FB94",
	"kukatakana" => "30AF",
	"hehinitialarabic" => "FEEB",
	"tikeutaparenkorean" => "3210",
	"Etarmenian" => "0538",
	"acircumflexgrave" => "1EA7",
	"ncircle" => "24DD",
	"arrowdown" => "2193",
	"hatafpatahnarrowhebrew" => "05B2",
	"spadesuitwhite" => "2664",
	"sarauuthai" => "0E39",
	"macronlowmod" => "02CD",
	"asmallkatakana" => "30A1",
	"blacksquare" => "25A0",
	"H18533" => "25CF",
	"omicron" => "03BF",
	"meizierasquare" => "337E",
	"cbopomofo" => "3118",
	"afii00208" => "2015",
	"yturned" => "028E",
	"sevensuperior" => "2077",
	"rieulkiyeokkorean" => "313A",
	"Uogonek" => "0172",
	"Zhedieresiscyrillic" => "04DC",
	"muvsquare" => "33B6",
	"heiseierasquare" => "337B",
	"Edieresissmall" => "F7EB",
	"wakorean" => "3158",
	"eopenreversedhook" => "025D",
	"zedieresiscyrillic" => "04DF",
	"ideographicearthparen" => "322F",
	"Lcommaaccent" => "013B",
	"twogurmukhi" => "0A68",
	"threebengali" => "09E9",
	"uhornacute" => "1EE9",
	"ramshorn" => "0264",
	"kcaron" => "01E9",
	"Zcaronsmall" => "F6FF",
	"Oslashsmall" => "F7F8",
	"hekutaarusquare" => "3336",
	"uacute" => "00FA",
	"saraaathai" => "0E32",
	"hcircle" => "24D7",
	"ampersand" => "0026",
	"Ncircumflexbelow" => "1E4A",
	"Upsilonhooksymbol" => "03D2",
	"spadesuitblack" => "2660",
	"hdotbelow" => "1E25",
	"Ldotbelow" => "1E36",
	"telishagedolahebrew" => "05A0",
	"shindagesh" => "FB49",
	"semicolonmonospace" => "FF1B",
	"atmonospace" => "FF20",
	"gimelhebrew" => "05D2",
	"ringhalfleftbelowcmb" => "031C",
	"exclamdown" => "00A1",
	"ninesuperior" => "2079",
	"kokatakana" => "30B3",
	"whitediamond" => "25C7",
	"eogonek" => "0119",
	"Wdotaccent" => "1E86",
	"Theta" => "0398",
	"Oogonek" => "01EA",
	"ttabengali" => "099F",
	"thehmedialarabic" => "FE9C",
	"gereshhebrew" => "05F3",
	"nineteencircle" => "2472",
	"dcedilla" => "1E11",
	"auvowelsigngujarati" => "0ACC",
	"jeeminitialarabic" => "FE9F",
	"amsquare" => "33C2",
	"tortoiseshellbracketrightvertical" => "FE3A",
	"blackuppointingsmalltriangle" => "25B4",
	"laminitialarabic" => "FEDF",
	"ncaron" => "0148",
	"bracketright" => "005D",
	"yeharabic" => "064A",
	"xcircle" => "24E7",
	"sixperiod" => "248D",
	"Ereversed" => "018E",
	"omacrongrave" => "1E51",
	"bcircle" => "24D1",
	"nieuntikeutkorean" => "3166",
	"ideographicstockparen" => "3231",
	"echyiwnarmenian" => "0587",
	"thetasymbolgreek" => "03D1",
	"fourbengali" => "09EA",
	"gihiragana" => "304E",
	"fehmedialarabic" => "FED4",
	"dsuperior" => "F6EB",
	"kiyeokcirclekorean" => "3260",
	"twelveperiod" => "2493",
	"escyrillic" => "0441",
	"tokatakanahalfwidth" => "FF84",
	"mturned" => "026F",
	"Iogonek" => "012E",
	"lcaron" => "013E",
	"zcurl" => "0291",
	"saraothai" => "0E42",
	"rfishhookreversed" => "027F",
	"Dieresis" => "F6CB",
	"obarred" => "0275",
	"kasraarabic" => "0650",
	"ibengali" => "0987",
	"bdotbelow" => "1E05",
	"controlEOT" => "0004",
	"Umacroncyrillic" => "04EE",
	"yodyodhebrew" => "05F2",
	"tortoiseshellbracketright" => "3015",
	"parenrightmonospace" => "FF09",
	"guhiragana" => "3050",
	"omegalatinclosed" => "0277",
	"zeromonospace" => "FF10",
	"siosparenkorean" => "3206",
	"rcircle" => "24E1",
	"quotedbl" => "0022",
	"notcontains" => "220C",
	"controlSYN" => "0016",
	"ghook" => "0260",
	"avagrahadeva" => "093D",
	"kikatakana" => "30AD",
	"tthagurmukhi" => "0A20",
	"slong" => "017F",
	"Zecyrillic" => "0417",
	"Eharmenian" => "0537",
	"ddalfinalarabic" => "FB89",
	"zeropersian" => "06F0",
	"umacroncyrillic" => "04EF",
	"thophuthaothai" => "0E12",
	"onehackarabic" => "0661",
	"acaron" => "01CE",
	"righttackbelowcmb" => "0319",
	"parenleftsuperior" => "207D",
	"hiriqnarrowhebrew" => "05B4",
	"maihanakatleftthai" => "F884",
	"angleleft" => "2329",
	"reshhiriqhebrew" => "05E8",
	"pfsquare" => "338A",
	"emdashvertical" => "FE31",
	"Encyrillic" => "041D",
	"chieuchkorean" => "314A",
	"hypheninferior" => "F6E5",
	"henghook" => "0267",
	"Chedieresiscyrillic" => "04F4",
	"ocaron" => "01D2",
	"yoddageshhebrew" => "FB39",
	"sbopomofo" => "3119",
	"fourmonospace" => "FF14",
	"bukatakana" => "30D6",
	"khorakhangthai" => "0E06",
	"blank" => "2423",
	"maitrilowleftthai" => "F892",
	"twodotleadervertical" => "FE30",
	"tahmedialarabic" => "FEC4",
	"rahiragana" => "3089",
	"threegujarati" => "0AE9",
	"oogonekmacron" => "01ED",
	"iacute" => "00ED",
	"lcircle" => "24DB",
	"Delta" => "2206",
	"maichattawaupperleftthai" => "F893",
	"emcyrillic" => "043C",
	"Vcircle" => "24CB",
	"mdotaccent" => "1E41",
	"controlUS" => "001F",
	"controlDLE" => "0010",
	"wacute" => "1E83",
	"underscorewavy" => "FE4F",
	"aivowelsignbengali" => "09C8",
	"maitholowleftthai" => "F88F",
	"alefmaddaabovearabic" => "0622",
	"holamwidehebrew" => "05B9",
	"wturned" => "028D",
	"usmallkatakana" => "30A5",
	"sixteencircle" => "246F",
	"eighthackarabic" => "0668",
	"aturned" => "0250",
	"intersection" => "2229",
	"vakatakana" => "30F7",
	"gohiragana" => "3054",
	"threegurmukhi" => "0A69",
	"nineteenparen" => "2486",
	"Upsilontonos" => "038E",
	"thabengali" => "09A5",
	"male" => "2642",
	"noonfinalarabic" => "FEE6",
	"chochingthai" => "0E09",
	"cyrFlex" => "F6D2",
	"yotgreek" => "03F3",
	"tsadihebrew" => "05E6",
	"rmonospace" => "FF52",
	"Ccedillaacute" => "1E08",
	"Ydieresissmall" => "F7FF",
	"Abrevedotbelow" => "1EB6",
	"hatafqamatswidehebrew" => "05B3",
	"spade" => "2660",
	"reshhatafsegolhebrew" => "05E8",
	"fcircle" => "24D5",
	"finalkafqamats" => "05DA",
	"Dcaron" => "010E",
	"khokhonthai" => "0E05",
	"shindageshhebrew" => "FB49",
	"sagurmukhi" => "0A38",
	"rieulaparenkorean" => "3211",
	"ninemonospace" => "FF19",
	"Pcircle" => "24C5",
	"lslash" => "0142",
	"whitecornerbracketleftvertical" => "FE43",
	"pmonospace" => "FF50",
	"Bhook" => "0181",
	"dzhecyrillic" => "045F",
	"zacute" => "017A",
	"rightangle" => "221F",
	"reshpatahhebrew" => "05E8",
	"pehfinalarabic" => "FB57",
	"percentsmall" => "FE6A",
	"notparallel" => "2226",
	"meemmedialarabic" => "FEE4",
	"bokatakana" => "30DC",
	"mbopomofo" => "3107",
	"hamzafathatanarabic" => "0621",
	"Rcaron" => "0158",
	"pieupsiostikeutkorean" => "3175",
	"aulengthmarkbengali" => "09D7",
	"tsuperior" => "F6F3",
	"candrabindudeva" => "0901",
	"greatermonospace" => "FF1E",
	"Ndotaccent" => "1E44",
	"equalsmall" => "FE66",
	"Ecircumflexacute" => "1EBE",
	"finalkafshevahebrew" => "05DA",
	"pecyrillic" => "043F",
	"ecandravowelsigngujarati" => "0AC5",
	"overline" => "203E",
	"propellor" => "2318",
	"maithoupperleftthai" => "F88D",
	"controlSI" => "000F",
	"ovowelsignbengali" => "09CB",
	"yusbigcyrillic" => "046B",
	"Ldotaccent" => "013F",
	"vavdageshhebrew" => "FB35",
	"squareorthogonalcrosshatchfill" => "25A6",
	"Jcircle" => "24BF",
	"thousandsseparatorarabic" => "066C",
	"Ercyrillic" => "0420",
	"oneroman" => "2170",
	"yiarmenian" => "0575",
	"cornerbracketrightvertical" => "FE42",
	"onedotenleader" => "2024",
	"exclamsmall" => "F721",
	"zainfinalarabic" => "FEB0",
	"twothirds" => "2154",
	"tonebarmidmod" => "02E7",
	"khieukhacirclekorean" => "3278",
	"nieunaparenkorean" => "320F",
	"controlSO" => "000E",
	"rvocalicdeva" => "090B",
	"Scaronsmall" => "F6FD",
	"hatafsegol30" => "05B1",
	"twocircle" => "2461",
	"ccaron" => "010D",
	"kturned" => "029E",
	"shimacoptic" => "03ED",
	"meemarabic" => "0645",
	"Qmonospace" => "FF31",
	"ideographiclaborcircle" => "3298",
	"Ecaron" => "011A",
	"ideographiclowcircle" => "32A6",
	"nlinebelow" => "1E49",
	"noonmedialarabic" => "FEE8",
	"shaddadammatanarabic" => "FC5E",
	"Oslash" => "00D8",
	"colontriangularhalfmod" => "02D1",
	"gbopomofo" => "310D",
	"sixteenparen" => "2483",
	"Scaron" => "0160",
	"parenleftaltonearabic" => "FD3E",
	"bikatakana" => "30D3",
	"blackleftpointingpointer" => "25C4",
	"controlSUB" => "001A",
	"SF100000" => "2500",
	"mokatakanahalfwidth" => "FF93",
	"tsere" => "05B5",
	"thanthakhatupperleftthai" => "F896",
	"abrevetilde" => "1EB5",
	"Zcircle" => "24CF",
	"Daarmenian" => "0534",
	"ihookabove" => "1EC9",
	"Dcircle" => "24B9",
	"arrowleftoverright" => "21C6",
	"nsuperior" => "207F",
	"vekatakana" => "30F9",
	"meetorusquare" => "334D",
	"pazerhebrew" => "05A1",
	"shindothebrew" => "05C1",
	"kheicoptic" => "03E7",
	"kacute" => "1E31",
	"Piwrarmenian" => "0553",
	"wekorean" => "315E",
	"chadeva" => "091B",
	"ideographmetalcircle" => "328E",
	"nundagesh" => "FB40",
	"Aogonek" => "0104",
	"ae" => "00E6",
	"yacute" => "00FD",
	"bracerighttp" => "F8FC",
	"eturned" => "01DD",
	"tehnoonfinalarabic" => "FC73",
	"segol2c" => "05B6",
	"ezhcaron" => "01EF",
	"circlemultiply" => "2297",
	"maiyamokthai" => "0E46",
	"maiekupperleftthai" => "F88A",
	"semicolonarabic" => "061B",
	"Elcyrillic" => "041B",
	"bracelefttp" => "F8F1",
	"tonebarhighmod" => "02E6",
	"tetdageshhebrew" => "FB38",
	"shinsindothebrew" => "FB2B",
	"qbopomofo" => "3111",
	"nnagurmukhi" => "0A23",
	"summation" => "2211",
	"xsuperior" => "02E3",
	"tehmarbutaarabic" => "0629",
	"Tcircle" => "24C9",
	"greateroverequal" => "2267",
	"ideographicselfparen" => "3242",
	"dcaron" => "010F",
	"solidusshortoverlaycmb" => "0337",
	"saraethai" => "0E40",
	"ideographicsunparen" => "3230",
	"squarebelowcmb" => "033B",
	"dialytikatonos" => "0385",
	"twobengali" => "09E8",
	"rcaron" => "0159",
	"finalkafqamatshebrew" => "05DA",
	"Tcaron" => "0164",
	"abopomofo" => "311A",
	"pvsquare" => "33B4",
	"maieklowleftthai" => "F88C",
	"nbspace" => "00A0",
	"zretroflexhook" => "0290",
	"sheenmedialarabic" => "FEB8",
	"makatakana" => "30DE",
	"fraction" => "2044",
	"hagujarati" => "0AB9",
	"ecircumflexbelow" => "1E19",
	"SF200000" => "2562",
	"schwahook" => "025A",
	"hsuperior" => "02B0",
	"mpasquare" => "33AB",
	"imonospace" => "FF49",
	"maitholowrightthai" => "F88E",
	"schwadieresiscyrillic" => "04DB",
	"lacute" => "013A",
	"kakatakana" => "30AB",
	"udeva" => "0909",
	"parenrightsmall" => "FE5A",
	"Ncircle" => "24C3",
	"oneperiod" => "2488",
	"careof" => "2105",
	"endescendercyrillic" => "04A3",
	"at" => "0040",
	"mieumsioskorean" => "316F",
	"jagurmukhi" => "0A1C",
	"phieuphcirclekorean" => "326C",
	"sakatakanahalfwidth" => "FF7B",
	"qamatsqatanquarterhebrew" => "05B8",
	"gmonospace" => "FF47",
	"blackupperlefttriangle" => "25E4",
	"lammedialarabic" => "FEE0",
	"middledotkatakanahalfwidth" => "FF65",
	"arrowrightdblstroke" => "21CF",
	"ttehmedialarabic" => "FB69",
	"Omicron" => "039F",
	"dblanglebracketleftvertical" => "FE3D",
	"Ezhcaron" => "01EE",
	"percentarabic" => "066A",
	"hagurmukhi" => "0A39",
	"squareupperrighttolowerleftfill" => "25A8",
	"qamatswidehebrew" => "05B8",
	"ideographmooncircle" => "328A",
	"Efcyrillic" => "0424",
	"zayin" => "05D6",
	"shindageshsindothebrew" => "FB2D",
	"kbopomofo" => "310E",
	"uumatragurmukhi" => "0A42",
	"sixdeva" => "096C",
	"afii10090" => "0448",
	"dzaltone" => "02A3",
	"anglebracketleftvertical" => "FE3F",
	"SF500000" => "2558",
	"approximatelyequal" => "2245",
	"blacklenticularbracketleftvertical" => "FE3B",
	"rsuperior" => "F6F1",
	"pedagesh" => "FB44",
	"afii10091" => "0449",
	"Uhungarumlaut" => "0170",
	"hatafsegol17" => "05B1",
	"thirteenperiod" => "2494",
	"rvocalicvowelsigngujarati" => "0AC3",
	"afii10092" => "044A",
	"ecaron" => "011B",
	"finalpehebrew" => "05E3",
	"tildecomb" => "0303",
	"rtblock" => "2590",
	"afii10093" => "044B",
	"aiecyrillic" => "04D5",
	"Gcaron" => "01E6",
	"oacute" => "00F3",
	"hyphen" => "002D",
	"tehiragana" => "3066",
	"afii10094" => "044C",
	"dnblock" => "2584",
	"oslash" => "00F8",
	"fiveoldstyle" => "F735",
	"Hcircle" => "24BD",
	"afii10095" => "044D",
	"Odieresissmall" => "F7F6",
	"imageorapproximatelyequal" => "2253",
	"Ucaron" => "01D3",
	"dalethatafsegolhebrew" => "05D3 05B1",
	"afii10096" => "044E",
	"arrowup" => "2191",
	"gimarmenian" => "0563",
	"Dafrican" => "0189",
	"glottalstopinverted" => "0296",
	"alefhamzabelowfinalarabic" => "FE88",
	"rehiragana" => "308C",
	"afii10097" => "044F",
	"notsubset" => "2284",
	"lvocalicvowelsigndeva" => "0962",
	"bobaimaithai" => "0E1A",
	"bsuperior" => "F6EA",
	"yosmallkatakanahalfwidth" => "FF6E",
	"yatcyrillic" => "0463",
	"vukatakana" => "30F4",
	"threeperiod" => "248A",
	"afii10098" => "0491",
	"gpasquare" => "33AC",
	"koreanstandardsymbol" => "327F",
	"Hmonospace" => "FF28",
	"afii10099" => "0452",
	"fehfinalarabic" => "FED2",
	"macute" => "1E3F",
	"Shchacyrillic" => "0429",
	"fourteenperiod" => "2495",
	"uugurmukhi" => "0A0A",
	"smileface" => "263A",
	"lfblock" => "258C",
	"abrevegrave" => "1EB1",
	"sevenbengali" => "09ED",
	"aivowelsigndeva" => "0948",
	"bridgeinvertedbelowcmb" => "033A",
	"peseta" => "20A7",
	"ocircumflextilde" => "1ED7",
	"Fmonospace" => "FF26",
	"colon" => "003A",
	"ohorn" => "01A1",
	"uring" => "016F",
	"syouwaerasquare" => "337C",
	"odieresiscyrillic" => "04E7",
	"hehfinalalttwoarabic" => "FEEA",
	"yesieungpansioskorean" => "3183",
	"sigmafinal" => "03C2",
	"ebopomofo" => "311C",
	"Bcircle" => "24B7",
	"kashidaautoarabic" => "0640",
	"squaremil" => "33D5",
	"lezh" => "026E",
	"mekatakana" => "30E1",
	"sixmonospace" => "FF16",
	"rittorusquare" => "3351",
	"integralex" => "F8F5",
	"lsuperior" => "F6EE",
	"Omega" => "2126",
	"tet" => "05D8",
	"hamzalowkasratanarabic" => "0621",
	"yuslittleiotifiedcyrillic" => "0469",
	"ubreve" => "016D",
	"twodotleader" => "2025",
	"dblanglebracketrightvertical" => "FE3E",
	"chedescendercyrillic" => "04B7",
	"Dslash" => "0110",
	"registered" => "00AE",
	"fourdeva" => "096A",
	"pacute" => "1E55",
	"Racute" => "0154",
	"dalet" => "05D3",
	"dong" => "20AB",
	"lowlinecenterline" => "FE4E",
	"thieuthparenkorean" => "320B",
	"ddotaccent" => "1E0B",
	"SF070000" => "2534",
	"SF400000" => "2569",
	"lvocalicbengali" => "098C",
	"tusmallhiragana" => "3063",
	"Ustraightstrokecyrillic" => "04B0",
	"gahiragana" => "304C",
	"lozenge" => "25CA",
	"eibopomofo" => "311F",
	"glottalstopreversed" => "0295",
	"capslock" => "21EA",
	"bdotaccent" => "1E03",
	"liwnarmenian" => "056C",
	"fourcircleinversesansserif" => "278D",
	"afii10070" => "0435",
	"nacute" => "0144",
	"llagujarati" => "0AB3",
	"Uhorntilde" => "1EEE",
	"tworoman" => "2171",
	"threeeighths" => "215C",
	"afii10071" => "0451",
	"acutebelowcmb" => "0317",
	"tehinitialarabic" => "FE97",
	"sokatakanahalfwidth" => "FF7F",
	"lamedholamdageshhebrew" => "05DC",
	"alefmaksuraarabic" => "0649",
	"afii10072" => "0436",
	"Dlinebelow" => "1E0E",
	"yeokorean" => "3155",
	"iucyrillic" => "044E",
	"afii10073" => "0437",
	"nkatakana" => "30F3",
	"tihiragana" => "3061",
	"Ncedilla" => "0145",
	"Kcaron" => "01E8",
	"fivesuperior" => "2075",
	"afii10074" => "0438",
	"khabengali" => "0996",
	"zeroinferior" => "2080",
	"Udieresismacron" => "01D5",
	"afii10075" => "0439",
	"hhooksuperior" => "02B1",
	"precedes" => "227A",
	"Alphatonos" => "0386",
	"bakatakana" => "30D0",
	"four" => "0034",
	"Omegacyrillic" => "0460",
	"afii10076" => "043A",
	"registerserif" => "F6DA",
	"kasquare" => "3384",
	"parenleftmonospace" => "FF08",
	"afii10077" => "043B",
	"dalethebrew" => "05D3",
	"paseqhebrew" => "05C0",
	"qoftsere" => "05E7 05B5",
	"cacute" => "0107",
	"hookabovecomb" => "0309",
	"afii10078" => "043C",
	"udieresismacron" => "01D6",
	"llvocalicvowelsigndeva" => "0963",
	"Udieresisgrave" => "01DB",
	"afii10079" => "043D",
	"tuhiragana" => "3064",
	"lcommaaccent" => "013C",
	"Icaron" => "01CF",
	"maitaikhuthai" => "0E47",
	"lessorequivalent" => "2272",
	"approaches" => "2250",
	"miribaarusquare" => "334A",
	"Sacute" => "015A",
	"overlinecenterline" => "FE4A",
	"controlACK" => "0006",
	"Zaarmenian" => "0536",
	"reviamugrashhebrew" => "0597",
	"gecyrillic" => "0433",
	"gereshmuqdamhebrew" => "059D",
	"hehmedialarabic" => "FEEC",
	"paragraph" => "00B6",
	"Cdotaccent" => "010A",
	"aacute" => "00E1",
	"tenroman" => "2179",
	"meeminitialarabic" => "FEE3",
	"chochangthai" => "0E0A",
	"sixroman" => "2175",
	"fivepersian" => "06F5",
	"Hoarmenian" => "0540",
	"kehiragana" => "3051",
	"Tworoman" => "2161",
	"getamark" => "3013",
	"arrowrightheavy" => "279E",
	"ccedillaacute" => "1E09",
	"hieuhacirclekorean" => "327B",
	"hatafpatahhebrew" => "05B2",
	"onefitted" => "F6DC",
	"Ringsmall" => "F6FC",
	"arrowrightwhite" => "21E8",
	"apaatosquare" => "3300",
	"verticalbar" => "007C",
	"arrowdownwhite" => "21E9",
	"iocyrillic" => "0451",
	"dammatanaltonearabic" => "064C",
	"udieresiscaron" => "01DA",
	"ocircumflexgrave" => "1ED3",
	"Lcaron" => "013D",
	"zdotaccent" => "017C",
	"whitetortoiseshellbracketleft" => "3018",
	"ubopomofo" => "3128",
	"braceleftvertical" => "FE37",
	"mukatakana" => "30E0",
	"sheqel" => "20AA",
	"qubutsquarterhebrew" => "05BB",
	"ibreve" => "012D",
	"Zcaron" => "017D",
	"threeideographicparen" => "3222",
	"llladeva" => "0934",
	"Utildeacute" => "1E78",
	"thieuthacirclekorean" => "3279",
	"eightcircleinversesansserif" => "2791",
	"afii10050" => "0490",
	"adieresiscyrillic" => "04D3",
	"twogujarati" => "0AE8",
	"tohiragana" => "3068",
	"sindothebrew" => "05C2",
	"racute" => "0155",
	"afii10051" => "0402",
	"ncedilla" => "0146",
	"Edot" => "0116",
	"ushortcyrillic" => "045E",
	"tonesix" => "0185",
	"schwacyrillic" => "04D9",
	"minusbelowcmb" => "0320",
	"Zlinebelow" => "1E94",
	"Xcircle" => "24CD",
	"ocandravowelsigngujarati" => "0AC9",
	"afii10052" => "0403",
	"behnoonfinalarabic" => "FC6D",
	"uuvowelsignbengali" => "09C2",
	"ideographicfireparen" => "322B",
	"macron" => "00AF",
	"afii10053" => "0404",
	"yparen" => "24B4",
	"notequal" => "2260",
	"afii10054" => "0405",
	"Threeroman" => "2162",
	"SF230000" => "2563",
	"afii10055" => "0406",
	"fourarabic" => "0664",
	"Thorn" => "00DE",
	"kokaithai" => "0E01",
	"holam32" => "05B9",
	"afii10056" => "0407",
	"Tenroman" => "2169",
	"Gimarmenian" => "0533",
	"nonuthai" => "0E19",
	"Mturned" => "019C",
	"afii10057" => "0408",
	"dollar" => "0024",
	"Chedescendercyrillic" => "04B6",
	"tonsquare" => "3327",
	"doubleyodpatahhebrew" => "FB1F",
	"Tildesmall" => "F6FE",
	"dottedcircle" => "25CC",
	"afii10058" => "0409",
	"nuktagujarati" => "0ABC",
	"Fitacyrillic" => "0472",
	"subsetorequal" => "2286",
	"raarmenian" => "057C",
	"Uhorngrave" => "1EEA",
	"afii10059" => "040A",
	"gammasuperior" => "02E0",
	"rrvocalicdeva" => "0960",
	"iicyrillic" => "0438",
	"eightoldstyle" => "F738",
	"overscore" => "00AF",
	"whitestar" => "2606",
	"elevencircle" => "246A",
	"pieupcieuckorean" => "3176",
	"obopomofo" => "311B",
	"Rcircle" => "24C7",
	"mokatakana" => "30E2",
	"qofdagesh" => "FB47",
	"Abrevetilde" => "1EB4",
	"copyright" => "00A9",
	"otildeacute" => "1E4D",
	"Ydotaccent" => "1E8E",
	"Upsilondieresis" => "03AB",
	"eacute" => "00E9",
	"sevencircle" => "2466",
	"seagullbelowcmb" => "033C",
	"Gacute" => "01F4",
	"nieunsioskorean" => "3167",
	"uhungarumlautcyrillic" => "04F3",
	"ghainfinalarabic" => "FECE",
	"mhook" => "0271",
	"Iebrevecyrillic" => "04D6",
	"nuktagurmukhi" => "0A3C",
	"tretroflexhook" => "0288",
	"sacute" => "015B",
	"commasuperior" => "F6E2",
	"controlSOT" => "0002",
	"aamatragurmukhi" => "0A3E",
	"upsilondieresis" => "03CB",
	"tau" => "03C4",
	"greaterequalorless" => "22DB",
	"Uacute" => "00DA",
	"breveinvertedbelowcmb" => "032F",
	"ideographicwaterparen" => "322C",
	"bhabengali" => "09AD",
	"ttehfinalarabic" => "FB67",
	"tav" => "05EA",
	"aemacron" => "01E3",
	"zparen" => "24B5",
	"tehmarbutafinalarabic" => "FE94",
	"sentosquare" => "3323",
	"Vhook" => "01B2",
	"product" => "220F",
	"iebrevecyrillic" => "04D7",
	"notgreater" => "226F",
	"fourhangzhou" => "3024",
	"Lcircle" => "24C1",
	"kapyeounmieumkorean" => "3171",
	"hikatakanahalfwidth" => "FF8B",
	"ideographicenterpriseparen" => "323D",
	"verticallineabovecmb" => "030D",
	"macroncmb" => "0304",
	"braceleftmonospace" => "FF5B",
	"muchless" => "226A",
	"ddhabengali" => "09A2",
	"upsilontonos" => "03CD",
	"kuhiragana" => "304F",
	"Rsmallinverted" => "0281",
	"tthagujarati" => "0AA0",
	"cabengali" => "099A",
	"afii10030" => "041C",
	"seventeenparen" => "2484",
	"afii10031" => "041D",
	"GBsquare" => "3387",
	"lamalefhamzaaboveisolatedarabic" => "FEF7",
	"afii10032" => "041E",
	"Ncaron" => "0147",
	"oinvertedbreve" => "020F",
	"afii10145" => "040F",
	"afii10033" => "041F",
	"glottalstop" => "0294",
	"asmallhiragana" => "3041",
	"afii10146" => "0462",
	"nyagujarati" => "0A9E",
	"mikatakana" => "30DF",
	"sevenmonospace" => "FF17",
	"afii10034" => "0420",
	"hiriq" => "05B4",
	"esmallkatakana" => "30A7",
	"afii10147" => "0472",
	"napostrophe" => "0149",
	"sentisquare" => "3322",
	"scommaaccent" => "0219",
	"hatafqamatsnarrowhebrew" => "05B3",
	"afii10035" => "0421",
	"dittomark" => "3003",
	"afii10148" => "0474",
	"Gamma" => "0393",
	"dtail" => "0256",
	"yerahbenyomolefthebrew" => "05AA",
	"Fcircle" => "24BB",
	"afii10036" => "0422",
	"Ccedilla" => "00C7",
	"afii10037" => "0423",
	"Idieresissmall" => "F7EF",
	"yoddagesh" => "FB39",
	"mparen" => "24A8",
	"afii10038" => "0424",
	"hiriq21" => "05B4",
	"ideographicsocietyparen" => "3233",
	"quotedblright" => "201D",
	"aekorean" => "3150",
	"afii10039" => "0425",
	"controlCAN" => "0018",
	"tedescendercyrillic" => "04AD",
	"sofpasuqhebrew" => "05C3",
	"Enghecyrillic" => "04A4",
	"eightsuperior" => "2078",
	"Dcedilla" => "1E10",
	"sukunarabic" => "0652",
	"seveneighths" => "215E",
	"nyagurmukhi" => "0A1E",
	"noonarabic" => "0646",
	"kapyeounphieuphkorean" => "3184",
	"onegujarati" => "0AE7",
	"plussmall" => "FE62",
	"SF430000" => "2550",
	"Ghemiddlehookcyrillic" => "0494",
	"wasmallkatakana" => "30EE",
	"vav" => "05D5",
	"integralbottom" => "2321",
	"bracketlefttp" => "F8EE",
	"elevenroman" => "217A",
	"pointingindexleftwhite" => "261C",
	"holam19" => "05B9",
	"daletqubuts" => "05D3",
	"Hungarumlaut" => "F6CF",
	"hotsprings" => "2668",
	"abrevecyrillic" => "04D1",
	"zakatakana" => "30B6",
	"yabengali" => "09AF",
	"wawfinalarabic" => "FEEE",
	"saraueleftthai" => "F887",
	"kohiragana" => "3053",
	"Acaron" => "01CD",
	"degree" => "00B0",
	"rieulthieuthkorean" => "313E",
	"rakatakanahalfwidth" => "FF97",
	"dekatakana" => "30C7",
	"daletshevahebrew" => "05D3",
	"hieuhcirclekorean" => "326D",
	"hedageshhebrew" => "FB34",
	"lakkhangyaothai" => "0E45",
	"Aiecyrillic" => "04D4",
	"xabovecmb" => "033D",
	"numeralsignlowergreek" => "0375",
	"ideographiciterationmark" => "3005",
	"whitesquare" => "25A1",
	"vmonospace" => "FF56",
	"sagujarati" => "0AB8",
	"harpoonleftbarbup" => "21BC",
	"Uhookabove" => "1EE6",
	"Ocaron" => "01D1",
	"chieuchaparenkorean" => "3217",
	"bekatakana" => "30D9",
	"Yacute" => "00DD",
	"patahnarrowhebrew" => "05B7",
	"bracerightmonospace" => "FF5D",
	"onegurmukhi" => "0A67",
	"jsuperior" => "02B2",
	"club" => "2663",
	"tmonospace" => "FF54",
	"dblarrowleft" => "21D4",
	"Yatcyrillic" => "0462",
	"gacute" => "01F5",
	"Yacutesmall" => "F7FD",
	"blacksmilingface" => "263B",
	"zaqefqatanhebrew" => "0594",
	"Ecedillabreve" => "1E1C",
	"Iacute" => "00CD",
	"underscore" => "005F",
	"Abrevegrave" => "1EB0",
	"Zedieresiscyrillic" => "04DE",
	"glottalstopreversedmod" => "02C1",
	"braceright" => "007D",
	"nparen" => "24A9",
	"hbar" => "0127",
	"dialytikatonoscmb" => "0344",
	"tecyrillic" => "0442",
	"Ohornhookabove" => "1EDE",
	"Oopen" => "0186",
	"nineperiod" => "2490",
	"dokatakana" => "30C9",
	"gabengali" => "0997",
	"Wacute" => "1E82",
	"reshtsere" => "05E8 05B5",
	"kastrokecyrillic" => "049F",
	"zerodeva" => "0966",
	"yyabengali" => "09DF",
	"twodeva" => "0968",
	"notelement" => "2209",
	"twentyperiod" => "249B",
	"sevenroman" => "2176",
	"ccedilla" => "00E7",
	"SF530000" => "256B",
	"adotmacron" => "01E1",
	"arrowvertex" => "F8E6",
	"minute" => "2032",
	"registersans" => "F8E8",
	"radical" => "221A",
	"kihiragana" => "304D",
	"kafmedialarabic" => "FEDC",
	"obreve" => "014F",
	"dblintegral" => "222C",
	"dbsquare" => "33C8",
	"usmallkatakanahalfwidth" => "FF69",
	"sevenhangzhou" => "3027",
	"sabengali" => "09B8",
	"rieulcirclekorean" => "3263",
	"momathai" => "0E21",
	"weokorean" => "315D",
	"ssangpieupkorean" => "3143",
	"omdeva" => "0950",
	"Lacute" => "0139",
	"finaltsadihebrew" => "05E5",
	"afii10017" => "0410",
	"earth" => "2641",
	"zhbopomofo" => "3113",
	"Lslash" => "0141",
	"afii10018" => "0411",
	"sixoldstyle" => "F736",
	"ringhalfrightcentered" => "02D2",
	"aumatragurmukhi" => "0A4C",
	"Ohornacute" => "1EDA",
	"dadinitialarabic" => "FEBF",
	"pashtahebrew" => "0599",
	"afii10019" => "0412",
	"hamzasukunarabic" => "0621",
	"Tiwnarmenian" => "054F",
	"rieulmieumkorean" => "313B",
	"Oacutesmall" => "F7F3",
	"Zacute" => "0179",
	"Umonospace" => "FF35",
	"rlinebelow" => "1E5F",
	"kiyeokacirclekorean" => "326E",
	"kafhebrew" => "05DB",
	"greaterorless" => "2277",
	"radoverssquaredsquare" => "33AF",
	"mansyonsquare" => "3347",
	"aigujarati" => "0A90",
	"cdot" => "010B",
	"Smonospace" => "FF33",
	"umatragurmukhi" => "0A41",
	"trademarkserif" => "F6DB",
	"Ocircumflexsmall" => "F7F4",
	"ninehangzhou" => "3029",
	"zekatakana" => "30BC",
	"evowelsigngujarati" => "0AC7",
	"equivalence" => "2261",
	"oparen" => "24AA",
	"parenleftex" => "F8EC",
	"commaarabic" => "060C",
	"Eopen" => "0190",
	"kohmsquare" => "33C0",
	"dikatakana" => "30C2",
	"aabengali" => "0986",
	"Idieresiscyrillic" => "04E4",
	"iacyrillic" => "044F",
	"tsadi" => "05E6",
	"threedeva" => "0969",
	"Idot" => "0130",
	"izhitsadblgravecyrillic" => "0477",
	"ghaininitialarabic" => "FECF",
	"daletpatah" => "05D3",
	"brevecmb" => "0306",
	"quotedblbase" => "201E",
	"Ereversedcyrillic" => "042D",
	"Digammagreek" => "03DC",
	"usmallhiragana" => "3045",
	"topatakthai" => "0E0F",
	"chook" => "0188",
	"nnagujarati" => "0AA3",
	"Tcommaaccent" => "0162",
	"rieulkorean" => "3139",
	"fongmanthai" => "0E4F",
	"aigurmukhi" => "0A10",
	"noonjeeminitialarabic" => "FCD2",
	"sigma" => "03C3",
	"segolwidehebrew" => "05B6",
	"Ccaron" => "010C",
	"afii10100" => "0453",
	"dukatakana" => "30C5",
	"mabengali" => "09AE",
	"afii10101" => "0454",
	"guilsinglright" => "203A",
	"Upsilon1" => "03D2",
	"Macute" => "1E3E",
	"house" => "2302",
	"controlGS" => "001D",
	"tipehahebrew" => "0596",
	"tahiragana" => "305F",
	"supersetorequal" => "2287",
	"afii10102" => "0455",
	"Thornsmall" => "F7FE",
	"Eacutesmall" => "F7E9",
	"nikatakanahalfwidth" => "FF86",
	"Horicoptic" => "03E8",
	"afii10103" => "0456",
	"afii10104" => "0457",
	"nvsquare" => "33B5",
	"afii10105" => "0458",
	"Oneroman" => "2160",
	"option" => "2325",
	"mmcubedsquare" => "33A3",
	"augurmukhi" => "0A14",
	"reshholamhebrew" => "05E8",
	"afii10106" => "0459",
	"dargalefthebrew" => "05A7",
	"einvertedbreve" => "0207",
	"lagujarati" => "0AB2",
	"bohiragana" => "307C",
	"seeninitialarabic" => "FEB3",
	"afii10107" => "045A",
	"periodcentered" => "00B7",
	"Eiotifiedcyrillic" => "0464",
	"Kacute" => "1E30",
	"bparen" => "249D",
	"tipehalefthebrew" => "0596",
	"thook" => "01AD",
	"squareverticalfill" => "25A5",
	"rhosymbolgreek" => "03F1",
	"qofdageshhebrew" => "FB47",
	"afii10108" => "045B",
	"fivehackarabic" => "0665",
	"pparen" => "24AB",
	"afii10109" => "045C",
	"bindigurmukhi" => "0A02",
	"ninepersian" => "06F9",
	"strokelongoverlaycmb" => "0336",
	"jagujarati" => "0A9C",
	"sixsuperior" => "2076",
	"Omicrontonos" => "038C",
	"khhadeva" => "0959",
	"parenrightaltonearabic" => "FD3F",
	"kakatakanahalfwidth" => "FF76",
	"hatafsegol" => "05B1",
	"Yhook" => "01B3",
	"cent" => "00A2",
	"gravedeva" => "0953",
	"lagurmukhi" => "0A32",
	"hiriq2d" => "05B4",
	"yesieungsioskorean" => "3182",
	"ugurmukhi" => "0A09",
	"qofhiriq" => "05E7 05B4",
	"zedescendercyrillic" => "0499",
	"tehjeemisolatedarabic" => "FC0B",
	"qofsegol" => "05E7 05B6",
	"parenrightex" => "F8F7",
	"pieupsioskiyeokkorean" => "3174",
	"Dcircumflexbelow" => "1E12",
	"Elevenroman" => "216A",
	"emacrongrave" => "1E15",
	"nieunkorean" => "3134",
	"zayinhebrew" => "05D6",
	"Adieresismacron" => "01DE",
	"coverkgsquare" => "33C6",
	"Iota" => "0399",
	"Nacute" => "0143",
	"yehnoonfinalarabic" => "FC94",
	"yehhamzaabovemedialarabic" => "FE8C",
	"Pdotaccent" => "1E56",
	"maieklowrightthai" => "F88B",
	"Tonesix" => "0184",
	"twonumeratorbengali" => "09F5",
	"sparen" => "24AE",
	"Phi" => "03A6",
	"abreve" => "0103",
	"llvocalicbengali" => "09E1",
	"fitacyrillic" => "0473",
	"Zeta" => "0396",
	"controlEM" => "0019",
	"reflexsubset" => "2286",
	"nyabengali" => "099E",
	"kirosquare" => "3314",
	"cieucuparenkorean" => "321C",
	"adieresismacron" => "01DF",
	"utildeacute" => "1E79",
	"bihiragana" => "3073",
	"cparen" => "249E",
	"kapyeounssangpieupkorean" => "3179",
	"Rfraktur" => "211C",
	"udieresisacute" => "01D8",
	"lira" => "20A4",
	"gangiacoptic" => "03EB",
	"bullet" => "2022",
	"hatafqamats28" => "05B3",
	"zukatakana" => "30BA",
	"uugujarati" => "0A8A",
	"qparen" => "24AC",
	"doubleyodpatah" => "FB1F",
	"ideographiccomma" => "3001",
	"totaothai" => "0E15",
	"DieresisGrave" => "F6CD",
	"meemmeeminitialarabic" => "FCD1",
	"afii57381" => "066A",
	"dblarrowright" => "21D2",
	"maitriupperleftthai" => "F890",
	"hardsigncyrillic" => "044A",
	"Tetsecyrillic" => "04B4",
	"mieumparenkorean" => "3204",
	"finalmem" => "05DD",
	"Otildeacute" => "1E4C",
	"Jmonospace" => "FF2A",
	"SF460000" => "2568",
	"Uacutesmall" => "F7FA",
	"afii10831" => "F6C7",
	"alefmaksurainitialarabic" => "FEF3",
	"zahfinalarabic" => "FEC6",
	"tehmedialarabic" => "FE98",
	"Aacute" => "00C1",
	"fivemonospace" => "FF15",
	"afii10832" => "F6C8",
	"moverssquare" => "33A7",
	"esdescendercyrillic" => "04AB",
	"whitesmallsquare" => "25AB",
	"shadedark" => "2593",
	"tcircumflexbelow" => "1E71",
	"shevaquarterhebrew" => "05B0",
	"Oacute" => "00D3",
	"afii57388" => "060C",
	"ldot" => "0140",
	"tparen" => "24AF",
	"thothanthai" => "0E10",
	"blacklowerlefttriangle" => "25E3",
	"compass" => "263C",
	"yoyakorean" => "3187",
	"ieungkorean" => "3147",
	"mahiragana" => "307E",
	"yuslittlecyrillic" => "0467",
	"siosnieunkorean" => "317B",
	"bracketrightex" => "F8FA",
	"noonghunnafinalarabic" => "FB9F",
	"circle" => "25CB",
	"ssanghieuhkorean" => "3185",
	"ringhalfleftcentered" => "02D3",
	"dparen" => "249F",
	"hdotaccent" => "1E23",
	"ocandragujarati" => "0A91",
	"kahiragana" => "304B",
	"lamed" => "05DC",
	"zokatakana" => "30BE",
	"rparen" => "24AD",
	"qofqamats" => "05E7 05B8",
	"afii57690" => "05EA",
	"haabkhasiancyrillic" => "04A9",
	"dlsquare" => "3397",
	"kabengali" => "0995",
	"yoikorean" => "3189",
	"tildeverticalcmb" => "033E",
	"nonbreakingspace" => "00A0",
	"fdotaccent" => "1E1F",
	"Ecircumflexbelow" => "1E18",
	"toarmenian" => "0569",
	"Rho" => "03A1",
	"ebreve" => "0115",
	"afii57694" => "FB2A",
	"Macron" => "F6D0",
	"dieresisacute" => "F6D7",
	"mhzsquare" => "3392",
	"Gbreve" => "011E",
	"Ocircumflexhookabove" => "1ED4",
	"thalarabic" => "0630",
	"reshsegol" => "05E8",
	"afii57695" => "FB2B",
	"commaturnedmod" => "02BB",
	"igurmukhi" => "0A07",
	"dageshhebrew" => "05BC",
	"ninedeva" => "096F",
	"leftangleabovecmb" => "031A",
	"afii57470" => "0647",
	"Otildedieresis" => "1E4E",
	"bethebrew" => "05D1",
	"Ubreve" => "016C",
	"Euro" => "20AC",
	"thanthakhatlowleftthai" => "F898",
	"saraathai" => "0E30",
	"pieuptikeutkorean" => "3173",
	"OE" => "0152",
	"Pacute" => "1E54",
	"yuyekorean" => "318B",
	"whiteuppointingtriangle" => "25B3",
	"kmonospace" => "FF4B",
	"controlCR" => "000D",
	"eopenclosed" => "029A",
	"uparen" => "24B0",
	"tencircle" => "2469",
	"osmallkatakana" => "30A9",
	"Omacronacute" => "1E52",
	"arrowupleft" => "2196",
	"bulletoperator" => "2219",
	"hamzaarabic" => "0621",
	"AEmacron" => "01E2",
	"commaaboverightcmb" => "0315",
	"commaabovecmb" => "0313",
	"parenrightvertical" => "FE36",
	"ringhalfright" => "02BE",
	"quotedblmonospace" => "FF02",
	"addakgurmukhi" => "0A71",
	"llvocalicvowelsignbengali" => "09E3",
	"finalkaf" => "05DA",
	"Gheupturncyrillic" => "0490",
	"Gsmallhook" => "029B",
	"perispomenigreekcmb" => "0342",
	"vuhiragana" => "3094",
	"colonmonospace" => "FF1A",
	"khaharabic" => "062E",
	"gscript" => "0261",
	"eparen" => "24A0",
	"ltshade" => "2591",
	"zikatakana" => "30B8",
	"Gdotaccent" => "0120",
	"aybarmenian" => "0561",
	"dbllowlinecmb" => "0333",
	"uhorn" => "01B0",
	"reshtserehebrew" => "05E8",
	"iecyrillic" => "0435",
	"Aacutesmall" => "F7E1",
	"zahinitialarabic" => "FEC7",
	"seventeenperiod" => "2498",
	"Edotaccent" => "0116",
	"pointingindexupwhite" => "261D",
	"invsmileface" => "263B",
	"paasentosquare" => "332B",
	"kesmallkatakana" => "30F6",
	"ghzsquare" => "3393",
	"dollaroldstyle" => "F724",
	"katahiraprolongmarkhalfwidth" => "FF70",
	"plus" => "002B",
	"downtackmod" => "02D5",
	"ecedillabreve" => "1E1D",
	"ddabengali" => "09A1",
	"Cacute" => "0106",
	"uvowelsigngujarati" => "0AC1",
	"eshcurl" => "0286",
	"aubengali" => "0994",
	"ascript" => "0251",
	"hparen" => "24A3",
	"viramagujarati" => "0ACD",
	"siluqlefthebrew" => "05BD",
	"lcedilla" => "013C",
	"afii57670" => "05D6",
	"vparen" => "24B1",
	"twooldstyle" => "F732",
	"lambda" => "03BB",
	"afii57671" => "05D7",
	"ngabengali" => "0999",
	"Khook" => "0198",
	"Ecircumflexsmall" => "F7EA",
	"afii57672" => "05D8",
	"afii57673" => "05D9",
	"circumflexbelowcmb" => "032D",
	"patahwidehebrew" => "05B7",
	"ghainarabic" => "063A",
	"alefhamzaabovearabic" => "0623",
	"Acircumflextilde" => "1EAA",
	"afii57674" => "05DA",
	"braceleft" => "007B",
	"yakatakanahalfwidth" => "FF94",
	"tonebarextralowmod" => "02E9",
	"ssangnieunkorean" => "3165",
	"fparen" => "24A1",
	"afii57675" => "05DB",
	"commaaccent" => "F6C3",
	"KKsquare" => "33CD",
	"uvowelsignbengali" => "09C1",
	"triagup" => "25B2",
	"chieuchparenkorean" => "3209",
	"afii57450" => "064A",
	"Jecyrillic" => "0408",
	"afii57676" => "05DC",
	"yehfinalarabic" => "FEF2",
	"bracerightsmall" => "FE5C",
	"caron" => "02C7",
	"afii57451" => "064B",
	"afii57677" => "05DD",
	"Aringacute" => "01FA",
	"Iishortcyrillic" => "0419",
	"afii57452" => "064C",
	"afii57678" => "05DE",
	"eshsquatreversed" => "0285",
	"verticallinemod" => "02C8",
	"ideographicreachparen" => "3243",
	"pieupkorean" => "3142",
	"mu1" => "00B5",
	"ecandragujarati" => "0A8D",
	"afii57453" => "064D",
	"afii57679" => "05DF",
	"nhiragana" => "3093",
	"afii57454" => "064E",
	"gbreve" => "011F",
	"yasmallkatakana" => "30E3",
	"tthadeva" => "0920",
	"Ibreve" => "012C",
	"afii57455" => "064F",
	"Upsilonacutehooksymbolgreek" => "03D3",
	"visargabengali" => "0983",
	"afii57456" => "0650",
	"iishortcyrillic" => "0439",
	"colonmonetary" => "20A1",
	"reshqubutshebrew" => "05E8",
	"noonmeemisolatedarabic" => "FC4E",
	"ngagurmukhi" => "0A19",
	"afii57457" => "0651",
	"aleph" => "2135",
	"florin" => "0192",
	"esh" => "0283",
	"afii57458" => "0652",
	"Hadescendercyrillic" => "04B2",
	"ocandradeva" => "0911",
	"Sixroman" => "2165",
	"perpendicular" => "22A5",
	"asciicircummonospace" => "FF3E",
	"iparen" => "24A4",
	"contourintegral" => "222E",
	"obarreddieresiscyrillic" => "04EB",
	"etnahtafoukhlefthebrew" => "0591",
	"kokatakanahalfwidth" => "FF7A",
	"wparen" => "24B2",
	"rrvocalicgujarati" => "0AE0",
	"reshhiriq" => "05E8",
	"rlongleg" => "027C",
	"parenrightinferior" => "208E",
	"SF030000" => "2510",
	"Ohungarumlaut" => "0150",
	"ubar" => "0289",
	"gravecomb" => "0300",
	"cdsquare" => "33C5",
	"dollarsuperior" => "F6E4",
	"tildecmb" => "0303",
	"Ecircumflexdotbelow" => "1EC6",
	"Oi" => "01A2",
	"aagujarati" => "0A86",
	"divides" => "2223",
	"bracerightbt" => "F8FE",
	"gparen" => "24A2",
	"zerohackarabic" => "0660",
	"dhabengali" => "09A7",
	"lamalefhamzabelowisolatedarabic" => "FEF9",
	"Ahookabove" => "1EA2",
	"birusquare" => "3331",
	"zerobengali" => "09E6",
	"xi" => "03BE",
	"tonefive" => "01BD",
	"tonebarextrahighmod" => "02E5",
	"samekh" => "05E1",
	"bmonospace" => "FF42",
	"hungarumlaut" => "02DD",
	"dakatakana" => "30C0",
	"zainarabic" => "0632",
	"tserequarterhebrew" => "05B5",
	"siostikeutkorean" => "317C",
	"braceleftbt" => "F8F3",
	"cagurmukhi" => "0A1A",
	"oangthai" => "0E2D",
	"twosuperior" => "00B2",
	"reharmenian" => "0580",
	"bracerightvertical" => "FE38",
	"Iacutesmall" => "F7ED",
	"ssangieungkorean" => "3180",
	"Ainvertedbreve" => "0202",
	"saraamthai" => "0E33",
	"questiondown" => "00BF",
	"Zdot" => "017B",
	"filledbox" => "25A0",
	"becyrillic" => "0431",
	"Eacute" => "00C9",
	"divisionslash" => "2215",
	"muhiragana" => "3080",
	"aagurmukhi" => "0A06",
	"hatafpatahquarterhebrew" => "05B2",
	"ecandradeva" => "090D",
	"Edieresis" => "00CB",
	"adieresis" => "00E4",
	"zerogujarati" => "0AE6",
	"sevendeva" => "096D",
	"jehfinalarabic" => "FB8B",
	"agujarati" => "0A85",
	"aavowelsignbengali" => "09BE",
	"Edblgrave" => "0204",
	"daletpatahhebrew" => "05D3",
	"adblgrave" => "0201",
	"siospieupkorean" => "317D",
	"afii57430" => "0636",
	"jparen" => "24A5",
	"uuvowelsigngujarati" => "0AC2",
	"saraaimaimuanthai" => "0E43",
	"afii57431" => "0637",
	"macronbelowcmb" => "0331",
	"clickretroflex" => "01C3",
	"xparen" => "24B3",
	"afii57432" => "0638",
	"overlinedblwavy" => "FE4C",
	"Iotatonos" => "038A",
	"afii57658" => "05C3",
	"qofshevahebrew" => "05E7",
	"afii57433" => "0639",
	"mehiragana" => "3081",
	"afii57434" => "063A",
	"fivehangzhou" => "3025",
	"zstroke" => "01B6",
	"daletdagesh" => "FB33",
	"Shhacyrillic" => "04BA",
	"vehinitialarabic" => "FB6C",
	"rhotichookmod" => "02DE",
	"acutecmb" => "0301",
	"ideographicspace" => "3000",
	"Acircumflexgrave" => "1EA6",
	"jdotlessstroke" => "025F",
	"agurmukhi" => "0A05",
	"pieupparenkorean" => "3205",
	"ohorntilde" => "1EE1",
	"memhebrew" => "05DE",
	"shaddakasratanarabic" => "FC5F",
	"ieungaparenkorean" => "3215",
	"echarmenian" => "0565",
	"Tonefive" => "01BC",
	"hookcmb" => "0309",
	"equalmonospace" => "FF1D",
	"apostrophearmenian" => "055A",
	"phi1" => "03D5",
	"Amonospace" => "FF21",
	"fifteencircle" => "246E",
	"yagujarati" => "0AAF",
	"ikatakanahalfwidth" => "FF72",
	"hekatakana" => "30D8",
	"psilipneumatacyrilliccmb" => "0486",
	"yehmeeminitialarabic" => "FCDD",
	"fivecircle" => "2464",
	"lvocalicdeva" => "090C",
	"mohiragana" => "3082",
	"caronbelowcmb" => "032C",
	"Yhookabove" => "1EF6",
	"wdieresis" => "1E85",
	"softhyphen" => "00AD",
	"commareversedmod" => "02BD",
	"parenleftsmall" => "FE59",
	"iideva" => "0908",
	"kparen" => "24A6",
	"Nhookleft" => "019D",
	"strokeshortoverlaycmb" => "0335",
	"roruathai" => "0E23",
	"quoteleft" => "2018",
	"eegurmukhi" => "0A0F",
	"lhookretroflex" => "026D",
	"clear" => "2327",
	"hatafsegolnarrowhebrew" => "05B1",
	"ekorean" => "3154",
	"ruthai" => "0E24",
	"Kaverticalstrokecyrillic" => "049C",
	"beta" => "03B2",
	"yagurmukhi" => "0A2F",
	"universal" => "2200",
	"noonmeeminitialarabic" => "FCD5",
	"phophungthai" => "0E1C",
	"reshqamatshebrew" => "05E8",
	"bahiragana" => "3070",
	"fathatanarabic" => "064B",
	"yenmonospace" => "FFE5",
	"uptackbelowcmb" => "031D",
	"tikeutcirclekorean" => "3262",
	"reshsegolhebrew" => "05E8",
	"Emacronacute" => "1E16",
	"araeakorean" => "318D",
	"lvocalicvowelsignbengali" => "09E2",
	"daletsheva" => "05D3",
	"tikeutparenkorean" => "3202",
	"uubengali" => "098A",
	"egujarati" => "0A8F",
	"edblgrave" => "0205",
	"Gammaafrican" => "0194",
	"dzeabkhasiancyrillic" => "04E1",
	"ukorean" => "315C",
	"twoarabic" => "0662",
	"afii57636" => "20AA",
	"candrabinducmb" => "0310",
	"Epsilontonos" => "0388",
	"afii57410" => "0622",
	"udieresiscyrillic" => "04F1",
	"piwrarmenian" => "0583",
	"cheabkhasiancyrillic" => "04BD",
	"hukatakanahalfwidth" => "FF8C",
	"asteriskmath" => "2217",
	"afii57411" => "0623",
	"gravemonospace" => "FF40",
	"yeorinhieuhkorean" => "3186",
	"sarauthai" => "0E38",
	"ebengali" => "098F",
	"khzsquare" => "3391",
	"Mu" => "039C",
	"afii57412" => "0624",
	"subsetnotequal" => "228A",
	"bullseye" => "25CE",
	"mlsquare" => "3396",
	"mihiragana" => "307F",
	"dblverticallineabovecmb" => "030E",
	"afii57413" => "0625",
	"whitetelephone" => "260F",
	"section" => "00A7",
	"poplathai" => "0E1B",
	"Udieresis" => "00DC",
	"afii57414" => "0626",
	"rragurmukhi" => "0A5C",
	"horizontalbar" => "2015",
	"afii57415" => "0627",
	"lparen" => "24A7",
	"hieuhkorean" => "314E",
	"Udblgrave" => "0214",
	"afii57416" => "0628",
	"alefqamatshebrew" => "FB2F",
	"uragurmukhi" => "0A73",
	"kenarmenian" => "056F",
	"afii57417" => "0629",
	"squaremg" => "338E",
	"IJ" => "0132",
	"dalethatafsegol" => "05D3",
	"numbersignmonospace" => "FF03",
	"afii57418" => "062A",
	"Wmonospace" => "FF37",
	"tlinebelow" => "1E6F",
	"siosaparenkorean" => "3214",
	"gravelowmod" => "02CE",
	"afii57419" => "062B",
	"oneparen" => "2474",
	"because" => "2235",
	"resh" => "05E8",
	"irigurmukhi" => "0A72",
	"Abreve" => "0102",
	"Ldotbelowmacron" => "1E38",
	"gimeldagesh" => "FB32",
	"paiyannoithai" => "0E2F",
	"Uinvertedbreve" => "0216",
	"wasmallhiragana" => "308E",
	"Obreve" => "014E",
	"twelvecircle" => "246B",
	"tusmallkatakanahalfwidth" => "FF6F",
	"squaremm" => "339C",
	"slash" => "002F",
	"mohmsquare" => "33C1",
	"sdotbelow" => "1E63",
	"nhookleft" => "0272",
	"ezhcurl" => "0293",
	"endash" => "2013",
	"minuscircle" => "2296",
	"zahiragana" => "3056",
	"rrvocalicbengali" => "09E0",
	"kcalsquare" => "3389",
	"ohorngrave" => "1EDD",
	"peharmenian" => "057A",
	"ldotbelowmacron" => "1E39",
	"dehiragana" => "3067",
	"hukatakana" => "30D5",
	"commaturnedabovecmb" => "0312",
	"nfsquare" => "338B",
	"hiriqwidehebrew" => "05B4",
	"ideographicallianceparen" => "323F",
	"iimatragurmukhi" => "0A40",
	"yokatakanahalfwidth" => "FF96",
	"afii57723" => "FB35",
	"bstroke" => "0180",
	"eightthai" => "0E58",
	"zerogurmukhi" => "0A66",
	"vehmedialarabic" => "FB6D",
	"kafinitialarabic" => "FEDB",
	"Odieresis" => "00D6",
	"behiragana" => "3079",
	"augujarati" => "0A94",
	"estimated" => "212E",
	"shevahebrew" => "05B0",
	"sdotaccent" => "1E61",
	"tsere12" => "05B5",
	"threeoldstyle" => "F733",
	"thereexists" => "2203",
	"sevenideographicparen" => "3226",
	"arrowupwhite" => "21E7",
	"Aybarmenian" => "0531",
	"alefhebrew" => "05D0",
	"Brevesmall" => "F6F4",
	"keharmenian" => "0584",
	"Odblgrave" => "020C",
	"ecircumflexgrave" => "1EC1",
	"ideographiccongratulationparen" => "3237",
	"afii57839" => "05BD",
	"umacron" => "016B",
	"mvsquare" => "33B7",
	"finalnunhebrew" => "05DF",
	"tevirlefthebrew" => "059B",
	"rieulparenkorean" => "3203",
	"mieumacirclekorean" => "3272",
	"ayinaltonehebrew" => "FB20",
	"whitedownpointingsmalltriangle" => "25BF",
	"kmcubedsquare" => "33A6",
	"tserewidehebrew" => "05B5",
	"ideographicfestivalparen" => "3240",
	"nagujarati" => "0AA8",
	"ghemiddlehookcyrillic" => "0495",
	"ecircumflextilde" => "1EC5",
	"ts" => "02A6",
	"Dieresissmall" => "F7A8",
	"afii57505" => "06A4",
	"mieumaparenkorean" => "3212",
	"SF060000" => "252C",
	"uhungarumlaut" => "0171",
	"afii57506" => "067E",
	"candrabindubengali" => "0981",
	"xmonospace" => "FF58",
	"udieresis" => "00FC",
	"afii57507" => "0686",
	"feharmenian" => "0586",
	"ocircumflexhookabove" => "1ED5",
	"dblarchinvertedbelowcmb" => "032B",
	"exclamdownsmall" => "F7A1",
	"ugujarati" => "0A89",
	"sadinitialarabic" => "FEBB",
	"afii57508" => "0698",
	"Ydieresis" => "0178",
	"udblgrave" => "0215",
	"tetsecyrillic" => "04B5",
	"afii57509" => "06AF",
	"patah11" => "05B7",
	"acircumflexacute" => "1EA5",
	"mdotbelow" => "1E43",
	"yinyang" => "262F",
	"exclammonospace" => "FF01",
	"gershayimhebrew" => "05F4",
	"threequartersemdash" => "F6DE",
	"squarekg" => "338F",
	"saraueeleftthai" => "F888",
	"omacron" => "014D",
	"Echarmenian" => "0535",
	"hokatakana" => "30DB",
	"rupeemarkbengali" => "09F2",
	"Tdotaccent" => "1E6A",
	"circlewithlefthalfblack" => "25D0",
	"yusmallkatakana" => "30E5",
	"afii64937" => "02BD",
	"eighthangzhou" => "3028",
	"vecyrillic" => "0432",
	"shchacyrillic" => "0449",
	"gravebelowcmb" => "0316",
	"Idieresis" => "00CF",
	"edieresis" => "00EB",
	"Ukcyrillic" => "0478",
	"glottalstopreversedsuperior" => "02E4",
	"dbllowline" => "2017",
	"etildebelow" => "1E1B",
	"nowarmenian" => "0576",
	"nabla" => "2207",
	"arrowheadleftmod" => "02C2",
	"chieuchcirclekorean" => "3269",
	"whitebullet" => "25E6",
	"diamondsuitwhite" => "2662",
	"dzecyrillic" => "0455",
	"Rdotaccent" => "1E58",
	"Idblgrave" => "0208",
	"squarekm" => "339E",
	"plussuperior" => "207A",
	"qarneyparahebrew" => "059F",
	"aavowelsigngujarati" => "0ABE",
	"iotatonos" => "03AF",
	"onethird" => "2153",
	"ttehinitialarabic" => "FB68",
	"afii57700" => "FB4B",
	"ideographicspecialparen" => "3235",
	"dieresiscmb" => "0308",
	"imacron" => "012B",
	"eightperiod" => "248F",
	"kafrafehebrew" => "FB4D",
	"succeeds" => "227B",
	"aideva" => "0910",
	"afii57929" => "02BC",
	"daletholam" => "05D3",
	"munahhebrew" => "05A3",
	"enhookcyrillic" => "04C8",
	"odieresis" => "00F6",
	"tippigurmukhi" => "0A70",
	"threesuperior" => "00B3",
	"afii57705" => "FB1F",
	"ogujarati" => "0A93",
	"maitrilowrightthai" => "F891",
	"arrowupdn" => "2195",
	"sixcircle" => "2465",
	"noonghunnaarabic" => "06BA",
	"issharbengali" => "09FA",
	"odblgrave" => "020D",
	"Kdotbelow" => "1E32",
	"ttadeva" => "091F",
	"Wsmall" => "F777",
	"dblanglebracketright" => "300B",
	"Menarmenian" => "0544",
	"duhiragana" => "3065",
	"okorean" => "3157",
	"xeharmenian" => "056D",
	"sheicoptic" => "03E3",
	"hikatakana" => "30D2",
	"asteriskarabic" => "066D",
	"ohungarumlaut" => "0151",
	"hieuhparenkorean" => "320D",
	"Jaarmenian" => "0541",
	"ohookabove" => "1ECF",
	"sixcircleinversesansserif" => "278F",
	"omacronacute" => "1E53",
	"buhiragana" => "3076",
	"blackcircle" => "25CF",
	"whitecircle" => "25CB",
	"tackleft" => "22A3",
	"aparen" => "249C",
	"kacyrillic" => "043A",
	"Endescendercyrillic" => "04A2",
	"lbelt" => "026C",
	"cornerbracketrighthalfwidth" => "FF63",
	"tortoiseshellbracketleftvertical" => "FE39",
	"iinvertedbreve" => "020B",
	"angstrom" => "212B",
	"kappa" => "03BA",
	"lamedholamhebrew" => "05DC",
	"centoldstyle" => "F7A2",
	"merkhahebrew" => "05A5",
	"seharmenian" => "057D",
	"lamarabic" => "0644",
	"seenmedialarabic" => "FEB4",
	"Reharmenian" => "0550",
	"maichattawalowleftthai" => "F895",
	"nieuncirclekorean" => "3261",
	"vavholam" => "FB4B",
	"omegacyrillic" => "0461",
	"clickalveolar" => "01C2",
	"ikorean" => "3163",
	"superset" => "2283",
	"ninehackarabic" => "0669",
	"SF260000" => "255D",
	"dkshade" => "2593",
	"blackrightpointingpointer" => "25BA",
	"twohackarabic" => "0662",
	"idieresis" => "00EF",
	"gysquare" => "33C9",
	"tethebrew" => "05D8",
	"rokatakanahalfwidth" => "FF9B",
	"mwmegasquare" => "33BF",
	"igujarati" => "0A87",
	"arrowtableft" => "21E4",
	"asmallkatakanahalfwidth" => "FF67",
	"shabengali" => "09B6",
	"pe" => "05E4",
	"idblgrave" => "0209",
	"Edotbelow" => "1EB8",
	"lammeemkhahinitialarabic" => "FEDF",
	"adotbelow" => "1EA1",
	"voarmenian" => "0578",
	"sixideographicparen" => "3225",
	"sakatakana" => "30B5",
	"Ocenteredtilde" => "019F",
	"Xsmall" => "F778",
	"dohiragana" => "3069",
	"underscoremonospace" => "FF3F",
	"Dhook" => "018A",
	"utildebelow" => "1E75",
	"rturnedsuperior" => "02B4",
	"minus" => "2212",
	"lbar" => "019A",
	"pi" => "03C0",
	"omonospace" => "FF4F",
	"thothungthai" => "0E16",
	"tehfinalarabic" => "FE96",
	"pieupsioskorean" => "3144",
	"ideographiccommaleft" => "FF64",
	"union" => "222A",
	"twoparen" => "2475",
	"titlocyrilliccmb" => "0483",
	"pagurmukhi" => "0A2A",
	"cruzeiro" => "20A2",
	"benarmenian" => "0562",
	"chochoethai" => "0E0C",
	"ideographnamecircle" => "3294",
	"ocandravowelsigndeva" => "0949",
	"reflexsuperset" => "2287",
	"fivebengali" => "09EB",
	"mmonospace" => "FF4D",
	"iubopomofo" => "3129",
	"phook" => "01A5",
	"ngadeva" => "0919",
	"guillemotright" => "00BB",
	"zuhiragana" => "305A",
	"nagurmukhi" => "0A28",
	"Yicyrillic" => "0407",
	"gravetonecmb" => "0340",
	"wbsquare" => "33DD",
	"sun" => "263C",
	"cornerbracketleftvertical" => "FE41",
	"bracketleftbt" => "F8F0",
	"hatafpatah23" => "05B2",
	"Ebreve" => "0114",
	"tsere1e" => "05B5",
	"oneeighth" => "215B",
	"pluscircle" => "2295",
	"SF360000" => "255E",
	"arrowrightoverleft" => "21C4",
	"oshortdeva" => "0912",
	"Idotaccent" => "0130",
	"Dzeabkhasiancyrillic" => "04E0",
	"kiroguramusquare" => "3315",
	"thadeva" => "0925",
	"Ksmall" => "F76B",
	"onethai" => "0E51",
	"zhecyrillic" => "0436",
	"yusbigiotifiedcyrillic" => "046D",
	"wdotbelow" => "1E89",
	"thothongthai" => "0E18",
	"ghhagurmukhi" => "0A5A",
	"Cheabkhasiancyrillic" => "04BC",
	"zehiragana" => "305C",
	"tavdages" => "FB4A",
	"hoonsquare" => "3342",
	"iibengali" => "0988",
	"ogonekcmb" => "0328",
	"centsuperior" => "F6E0",
	"ghainmedialarabic" => "FED0",
	"gafarabic" => "06AF",
	"luthai" => "0E26",
	"dihiragana" => "3062",
	"daletqamats" => "05D3",
	"Ysmall" => "F779",
	"gdot" => "0121",
	"Hardsigncyrillic" => "042A",
	"ideographiccallparen" => "323A",
	"shbopomofo" => "3115",
	"Ezh" => "01B7",
	"gmacron" => "1E21",
	"forall" => "2200",
	"ucircumflexbelow" => "1E77",
	"sheva22" => "05B0",
	"kahookcyrillic" => "04C4",
	"patah1d" => "05B7",
	"tsadidagesh" => "FB46",
	"sixhangzhou" => "3026",
	"Nmonospace" => "FF2E",
	"jeemarabic" => "062C",
	"whitediamondcontainingblacksmalldiamond" => "25C8",
	"tcheharabic" => "0686",
	"sixparen" => "2479",
	"Ccedillasmall" => "F7E7",
	"klinebelow" => "1E35",
	"kcedilla" => "0137",
	"thirteencircle" => "246C",
	"sixhackarabic" => "0666",
	"Schwa" => "018F",
	"ideographiccentrecircle" => "32A5",
	"zayindagesh" => "FB36",
	"threenumeratorbengali" => "09F6",
	"quarternote" => "2669",
	"Lmonospace" => "FF2C",
	"blacklenticularbracketleft" => "3010",
	"zohiragana" => "305E",
	"zarqahebrew" => "0598",
	"sekatakana" => "30BB",
	"rieulyeorinhieuhkorean" => "316D",
	"mirisquare" => "3349",
	"Chedescenderabkhasiancyrillic" => "04BE",
	"softsigncyrillic" => "044C",
	"Oinvertedbreve" => "020E",
	"Rsmallinvertedsuperior" => "02B6",
	"obengali" => "0993",
	"qaffinalarabic" => "FED6",
	"ttagujarati" => "0A9F",
	"threecircle" => "2462",
	"SF090000" => "2524",
	"dorusquare" => "3326",
	"SF420000" => "2560",
	"fourteencircle" => "246D",
	"lamkhahinitialarabic" => "FCCB",
	"amacron" => "0101",
	"cornerbracketleft" => "300C",
	"ydieresis" => "00FF",
	"rradeva" => "0931",
	"Adieresis" => "00C4",
	"integraltp" => "2320",
	"hethebrew" => "05D7",
	"nj" => "01CC",
	"Lsmall" => "F76C",
	"qofhatafpatahhebrew" => "05E7",
	"behmeemisolatedarabic" => "FC08",
	"ngagujarati" => "0A99",
	"Adblgrave" => "0200",
	"eshreversedloop" => "01AA",
	"hamzadammatanarabic" => "0621",
	"Udotbelow" => "1EE4",
	"yerahbenyomohebrew" => "05AA",
	"sevenarabic" => "0667",
	"Kenarmenian" => "053F",
	"sosuathai" => "0E2A",
	"Zsmall" => "F77A",
	"Ldot" => "013F",
	"Udieresiscaron" => "01D9",
	"qofhatafpatah" => "05E7",
	"blackuppointingtriangle" => "25B2",
	"haitusquare" => "332A",
	"Lambda" => "039B",
	"reshhatafpatah" => "05E8",
	"phieuphkorean" => "314D",
	"Xeharmenian" => "053D",
	"ttagurmukhi" => "0A1F",
	"tortoiseshellbracketleft" => "3014",
	"tenideographicparen" => "3229",
	"nyadeva" => "091E",
	"kafdageshhebrew" => "FB3B",
	"lowlinedashed" => "FE4D",
	"perafehebrew" => "FB4E",
	"thehinitialarabic" => "FE9B",
	"Kcedilla" => "0136",
	"acutelowmod" => "02CF",
	"twostroke" => "01BB",
	"quotesingle" => "0027",
	"Abrevecyrillic" => "04D0",
	"dalethiriqhebrew" => "05D3",
	"khieukhparenkorean" => "320A",
	"dadfinalarabic" => "FEBE",
	"Emacron" => "0112",
	"aleffinalarabic" => "FE8E",
	"shhacyrillic" => "04BB",
	"arrowupdownbase" => "21A8",
	"Ushortcyrillic" => "040E",
	"AE" => "00C6",
	"zihiragana" => "3058",
	"sterlingmonospace" => "FFE1",
	"Adieresiscyrillic" => "04D2",
	"Abrevehookabove" => "1EB2",
	"omegatonos" => "03CE",
	"Peharmenian" => "054A",
	"hasquare" => "33CA",
	"lambdastroke" => "019B",
	"Odieresiscyrillic" => "04E6",
	"betdageshhebrew" => "FB31",
	"Lcedilla" => "013B",
	"nu" => "03BD",
	"Ehookabove" => "1EBA",
	"qamats27" => "05B8",
	"hakatakana" => "30CF",
	"Zstroke" => "01B5",
	"dollarmonospace" => "FF04",
	"ayinhebrew" => "05E2",
	"cagujarati" => "0A9A",
	"dotlessjstrokehook" => "0284",
	"Seharmenian" => "054D",
	"rrehfinalarabic" => "FB8D",
	"overlinedashed" => "FE49",
	"bhadeva" => "092D",
	"akorean" => "314F",
	"gagurmukhi" => "0A17",
	"sigma1" => "03C2",
	"qamats29" => "05B8",
	"SF190000" => "2561",
	"lamfinalarabic" => "FEDE",
	"dmonospace" => "FF44",
	"SF520000" => "2553",
	"abrevehookabove" => "1EB3",
	"sioskiyeokkorean" => "317A",
	"Wdieresis" => "1E84",
	"Msmall" => "F76D",
	"Keharmenian" => "0554",
	"ideographwatercircle" => "328C",
	"dodekthai" => "0E14",
	"Obarredcyrillic" => "04E8",
	"Odotbelow" => "1ECC",
	"kdotbelow" => "1E33",
	"sallallahoualayhewasallamarabic" => "FDFA",
	"Umacron" => "016A",
	"phosamphaothai" => "0E20",
	"Iotadieresis" => "03AA",
	"enghecyrillic" => "04A5",
	"hekatakanahalfwidth" => "FF8D",
	"kappasymbolgreek" => "03F0",
	"fathalowarabic" => "064E",
	"delta" => "03B4",
	"middot" => "00B7",
	"obarredcyrillic" => "04E9",
	"ideographicfinancialparen" => "3236",
	"brevebelowcmb" => "032E",
	"Alpha" => "0391",
	"qubuts" => "05BB",
	"onecircle" => "2460",
	"tikatakanahalfwidth" => "FF81",
	"mussquare" => "33B2",
	"waekorean" => "3159",
	"greatersmall" => "FE65",
	"Feharmenian" => "0556",
	"divide" => "00F7",
	"notelementof" => "2209",
	"Yericyrillic" => "042B",
	"lj" => "01C9",
	"udotbelow" => "1EE5",
	"clubsuitwhite" => "2667",
	"copyrightserif" => "F6D9",
	"Ydotbelow" => "1EF4",
	"hehfinalaltonearabic" => "FBA7",
	"wring" => "1E98",
	"tenparen" => "247D",
	"sukatakana" => "30B9",
	"sosothai" => "0E0B",
	"qof" => "05E7",
	"acircumflexdotbelow" => "1EAD",
	"ll" => "F6C0",
	"Emonospace" => "FF25",
	"ismallkatakanahalfwidth" => "FF68",
	"blinebelow" => "1E07",
	"bracerightmid" => "F8FD",
	"thehfinalarabic" => "FE9A",
	"angleright" => "232A",
	"Etildebelow" => "1E1A",
	"controlETB" => "0017",
	"Nowarmenian" => "0546",
	"Nsmall" => "F76E",
	"emphasismarkarmenian" => "055B",
	"Ocircumflextilde" => "1ED6",
	"bhook" => "0253",
	"iotadieresistonos" => "0390",
	"lxsquare" => "33D3",
	"sadarabic" => "0635",
	"Dzecyrillic" => "0405",
	"oneoldstyle" => "F731",
	"hatafpatah2f" => "05B2",
	"longs" => "017F",
	"Idotbelow" => "1ECA",
	"Ostrokeacute" => "01FE",
	"edotbelow" => "1EB9",
	"Cmonospace" => "FF23",
	"taisyouerasquare" => "337D",
	"phieuphparenkorean" => "320C",
	"itildebelow" => "1E2D",
	"qafarabic" => "0642",
	"squarecc" => "33C4",
	"mbsquare" => "33D4",
	"clubsuitblack" => "2663",
	"fourroman" => "2173",
	"zaarmenian" => "0566",
	"omegatitlocyrillic" => "047D",
	"voicediterationkatakana" => "30FE",
	"ucircle" => "24E4",
	"tahfinalarabic" => "FEC2",
	"fourinferior" => "2084",
	"Aring" => "00C5",
	"dbloverlinecmb" => "033F",
	"tiwnarmenian" => "057F",
	"shaddadammaarabic" => "FC61",
	"elevenparen" => "247E",
	"Omegatitlocyrillic" => "047C",
	"intisquare" => "3305",
	"herutusquare" => "3339",
	"ffi" => "FB03",
	"curlyand" => "22CF",
	"veharabic" => "06A4",
	"visargagujarati" => "0A83",
	"shook" => "0282",
	"aibengali" => "0990",
	"Qsmall" => "F771",
	"abreveacute" => "1EAF",
	"Sdotbelow" => "1E62",
	"odotbelow" => "1ECD",
	"ffl" => "FB04",
	"sheva2e" => "05B0",
	"centmonospace" => "FFE0",
	"osmallhiragana" => "3049",
	"dahiragana" => "3060",
	"telishaqetanahebrew" => "05A9",
	"sokatakana" => "30BD",
	"fourthtonechinese" => "02CB",
	"Otildesmall" => "F7F5",
	"ghestrokecyrillic" => "0493",
	"zhebrevecyrillic" => "04C2",
	"yehhamzaabovearabic" => "0626",
	"sfthyphen" => "00AD",
	"rhookturned" => "027B",
	"Asmall" => "F761",
	"eopenreversed" => "025C",
	"Otcyrillic" => "047E",
	"yoyakthai" => "0E22",
	"tsecyrillic" => "0446",
	"squarecm" => "339D",
	"mieumpansioskorean" => "3170",
	"checkmark" => "2713",
	"ocircle" => "24DE",
	"SF390000" => "2554",
	"largecircle" => "25EF",
	"Osmall" => "F76F",
	"Einvertedbreve" => "0206",
	"gaffinalarabic" => "FB93",
	"aeacute" => "01FD",
	"upperdothebrew" => "05C4",
	"tcommaaccent" => "0163",
	"lochulathai" => "0E2C",
	"kafarabic" => "0643",
	"menarmenian" => "0574",
	"Tedescendercyrillic" => "04AC",
	"eighteenperiod" => "2499",
	"daletholamhebrew" => "05D3",
	"nnadeva" => "0923",
	"dotaccent" => "02D9",
	"blacklenticularbracketrightvertical" => "FE3C",
	"nkatakanahalfwidth" => "FF9D",
	"braceex" => "F8F4",
	"sevenparen" => "247A",
	"semivoicedmarkkanahalfwidth" => "FF9F",
	"apostrophemod" => "02BC",
	"noonnoonfinalarabic" => "FC8D",
	"hyphentwo" => "2010",
	"commamonospace" => "FF0C",
	"controlETX" => "0003",
	"tonetwo" => "01A8",
	"eightroman" => "2177",
	"peharabic" => "067E",
	"anglebracketrightvertical" => "FE40",
	"yusmallkatakanahalfwidth" => "FF6D",
	"segolquarterhebrew" => "05B6",
	"icircle" => "24D8",
	"Eta" => "0397",
	"onesuperior" => "00B9",
	"dblGrave" => "F6D3",
	"nuktabengali" => "09BC",
	"rafehebrew" => "05BF",
	"pieupaparenkorean" => "3213",
	"Rsmall" => "F772",
	"Mdotbelow" => "1E42",
	"halantgurmukhi" => "0A4D",
	"decyrillic" => "0434",
	"cmcubedsquare" => "33A4",
	"idotbelow" => "1ECB",
	"notidentical" => "2262",
	"Oharmenian" => "0555",
	"hyphenmonospace" => "FF0D",
	"sikatakana" => "30B7",
	"periodsuperior" => "F6E8",
	"alefarabic" => "0627",
	"therefore" => "2234",
	"rhadeva" => "095D",
	"Checyrillic" => "0427",
	"arrowhorizex" => "F8E7",
	"Utildebelow" => "1E74",
	"zinorhebrew" => "05AE",
	"tturned" => "0287",
	"ddalarabic" => "0688",
	"Bsmall" => "F762",
	"qubuts25" => "05BB",
	"SF490000" => "2559",
	"omicrontonos" => "03CC",
	"hookpalatalizedbelowcmb" => "0321",
	"Eth" => "00D0",
	"Psmall" => "F770",
	"Aringbelow" => "1E00",
	"Shacyrillic" => "0428",
	"notless" => "226E",
	"Benarmenian" => "0532",
	"Coarmenian" => "0551",
	"cyrBreve" => "F6D1",
	"mvmegasquare" => "33B9",
	"zbopomofo" => "3117",
	"wdotaccent" => "1E87",
	"tbar" => "0167",
	"Omacron" => "014C",
	"mikatakanahalfwidth" => "FF90",
	"Ocircumflexgrave" => "1ED2",
	"Udieresisacute" => "01D7",
	"anoteleia" => "0387",
	"nooninitialarabic" => "FEE7",
	"ideographicnameparen" => "3234",
	"emacron" => "0113",
	"Yusbigcyrillic" => "046A",
	"ycircle" => "24E8",
	"iterationkatakana" => "30FD",
	"exclam" => "0021",
	"arrowdblleft" => "21D0",
	"ninebengali" => "09EF",
	"germandbls" => "00DF",
	"ccircle" => "24D2",
	"commaarmenian" => "055D",
	"ukatakanahalfwidth" => "FF73",
	"pieupthieuthkorean" => "3177",
	"yasmallhiragana" => "3083",
	"qamatsquarterhebrew" => "05B8",
	"parenleftvertical" => "FE35",
	"he" => "05D4",
	"twohangzhou" => "3022",
	"Psicyrillic" => "0470",
	"logicalor" => "2228",
	"jeharabic" => "0698",
	"iivowelsignbengali" => "09C0",
	"nekatakanahalfwidth" => "FF88",
	"Deltagreek" => "0394",
	"Zhecyrillic" => "0416",
	"ringcmb" => "030A",
	"ellipsis" => "2026",
	"Ssmall" => "F773",
	"auvowelsignbengali" => "09CC",
	"fifteenparen" => "2482",
	"Imacron" => "012A",
	"H18543" => "25AA",
	"scircle" => "24E2",
	"multiply" => "00D7",
	"zmonospace" => "FF5A",
	"Ksicyrillic" => "046E",
	"Csmall" => "F763",
	"hangulfiller" => "3164",
	"timescircle" => "2297",
	"siluqhebrew" => "05BD",
	"ieungcirclekorean" => "3267",
	"lamaleffinalarabic" => "FEFC",
	"Xdotaccent" => "1E8A",
	"enspace" => "2002",
	"zecyrillic" => "0437",
	"tbopomofo" => "310A",
	"franc" => "20A3",
	"hturned" => "0265",
	"nineinferior" => "2089",
	"reviahebrew" => "0597",
	"fofanthai" => "0E1F",
	"numbersignsmall" => "FE5F",
	"colontriangularmod" => "02D0",
	"cieucaparenkorean" => "3216",
	"fahrenheit" => "2109",
	"kabashkircyrillic" => "04A1",
	"pefinaldageshhebrew" => "FB43",
	"yehbarreefinalarabic" => "FBAF",
	"wakatakanahalfwidth" => "FF9C",
	"encyrillic" => "043D",
	"masoracirclehebrew" => "05AF",
	"mcircle" => "24DC",
	"khokhaithai" => "0E02",
	"munahlefthebrew" => "05A3",
	"segolnarrowhebrew" => "05B6",
	"ocircumflexdotbelow" => "1ED9",
	"dieresisbelowcmb" => "0324",
	"Wcircle" => "24CC",
	"siosacirclekorean" => "3274",
	"nieunacirclekorean" => "326F",
	"anbopomofo" => "3122",
	"Fsmall" => "F766",
	"hv" => "0195",
	"lamhahinitialarabic" => "FCCA",
	"etarmenian" => "0568",
	"Aringsmall" => "F7E5",
	"ydotbelow" => "1EF5",
	"tatweelarabic" => "0640",
	"Tsmall" => "F774",
	"Adotbelow" => "1EA0",
	"muwsquare" => "33BC",
	"onemonospace" => "FF11",
	"fiveeighths" => "215D",
	"ampersandsmall" => "F726",
	"Uhornacute" => "1EE8",
	"ninecircle" => "2468",
	"Upsilonafrican" => "01B1",
	"omega" => "03C9",
	"arrowdownright" => "2198",
	"tccurl" => "02A8",
	"shinsindot" => "FB2B",
	"sheeninitialarabic" => "FEB7",
	"daletdageshhebrew" => "FB33",
	"won" => "20A9",
	"patahhebrew" => "05B7",
	"heartsuitwhite" => "2661",
	"currency" => "00A4",
	"twentycircle" => "2473",
	"sorusithai" => "0E29",
	"esmallhiragana" => "3047",
	"huhiragana" => "3075",
	"ddadeva" => "0921",
	"Stigmagreek" => "03DA",
	"Dsmall" => "F764",
	"shaddafathaarabic" => "FC60",
	"Ymonospace" => "FF39",
	"ismallkatakana" => "30A3",
	"gcircle" => "24D6",
	"pedageshhebrew" => "FB44",
	"dbldanda" => "0965",
	"Qcircle" => "24C6",
	"kooposquare" => "331E",
	"lladeva" => "0933",
	"ff" => "FB00",
	"nbopomofo" => "310B",
	"twomonospace" => "FF12",
	"shevanarrowhebrew" => "05B0",
	"quotedblprimereversed" => "301D",
	"parenlefttp" => "F8EB",
	"semicolonsmall" => "FE54",
	"phadeva" => "092B",
	"iigurmukhi" => "0A08",
	"fi" => "FB01",
	"greaterequal" => "2265",
	"parenleftinferior" => "208D",
	"yod" => "05D9",
	"questionmonospace" => "FF1F",
	"eightpersian" => "06F8",
	"cieucparenkorean" => "3208",
	"tehmeemisolatedarabic" => "FC0E",
	"ayin" => "05E2",
	"propersubset" => "2282",
	"dalettserehebrew" => "05D3",
	"fl" => "FB02",
	"Gsmall" => "F767",
	"heartsuitblack" => "2665",
	"acute" => "00B4",
	"whitecornerbracketrightvertical" => "FE44",
	"squarelog" => "33D2",
	"kvsquare" => "33B8",
	"Wdotbelow" => "1E88",
	"thieuthaparenkorean" => "3219",
	"Usmall" => "F775",
	"Kcircle" => "24C0",
	"H22073" => "25A1",
	"Ethsmall" => "F7F0",
	"Gcommaaccent" => "0122",
	"yericyrillic" => "044B",
	"sdotbelowdotaccent" => "1E69",
	"Izhitsacyrillic" => "0474",
	"dasiapneumatacyrilliccmb" => "0485",
	"phi" => "03C6",
	"wakatakana" => "30EF",
	"threehangzhou" => "3023",
	"ragujarati" => "0AB0",
	"hohiragana" => "307B",
	"jhadeva" => "091D",
	"behmeeminitialarabic" => "FC9F",
	"Esmall" => "F765",
	"sixpersian" => "06F6",
	"radsquare" => "33AD",
	"Umacrondieresis" => "1E7A",
	"kafdagesh" => "FB3B",
	"pageup" => "21DE",
	"Tshecyrillic" => "040B",
	"decimalseparatorarabic" => "066B",
	"chaarmenian" => "0579",
	"yusmallhiragana" => "3085",
	"yasmallkatakanahalfwidth" => "FF6C",
	"seveninferior" => "2087",
	"tackdown" => "22A4",
	"pagujarati" => "0AAA",
	"haaltonearabic" => "06C1",
	"heharabic" => "0647",
	"izhitsacyrillic" => "0475",
	"hbopomofo" => "310F",
	"suchthat" => "220B",
	"anusvaradeva" => "0902",
	"Atildesmall" => "F7E3",
	"yehinitialarabic" => "FEF3",
	"umacrondieresis" => "1E7B",
	"tcedilla" => "0163",
	"tagurmukhi" => "0A24",
	"controlVT" => "000B",
	"Gmacron" => "1E20",
	"imatragurmukhi" => "0A3F",
	"radicalex" => "F8E5",
	"qmonospace" => "FF51",
	"ideographiccorrectcircle" => "32A3",
	"anudattadeva" => "0952",
	"osuperior" => "F6F0",
	"Ecircle" => "24BA",
	"tpalatalhook" => "01AB",
	"Pemiddlehookcyrillic" => "04A6",
	"ostrokeacute" => "01FF",
	"ragurmukhi" => "0A30",
	"SF020000" => "2514",
	"arrowdblup" => "21D1",
	"sikatakanahalfwidth" => "FF7C",
	"referencemark" => "203B",
	"dammaarabic" => "064F",
	"Esdescendercyrillic" => "04AA",
	"hyphensmall" => "FE63",
	"Hsmall" => "F768",
	"teharabic" => "062A",
	"qamatshebrew" => "05B8",
	"dhadeva" => "0927",
	"bracketleftmonospace" => "FF3B",
	"figuredash" => "2012",
	"eharmenian" => "0567",
	"wcircumflex" => "0175",
	"ekatakana" => "30A8",
	"parenrighttp" => "F8F6",
	"Ghadarmenian" => "0542",
	"epsilon" => "03B5",
	"Kastrokecyrillic" => "049E",
	"Emcyrillic" => "041C",
	"Vsmall" => "F776",
	"Itildebelow" => "1E2C",
	"mem" => "05DE",
	"segol13" => "05B6",
	"controlENQ" => "0005",
	"partialdiff" => "2202",
	"hakatakanahalfwidth" => "FF8A",
	"sheenfinalarabic" => "FEB6",
	"kadescendercyrillic" => "049B",
	"hihiragana" => "3072",
	"dotkatakana" => "30FB",
	"Amacron" => "0100",
	"khacyrillic" => "0445",
	"fiveroman" => "2174",
	"five" => "0035",
	"ilde" => "02DC",
	"dargahebrew" => "05A7",
	"twelveroman" => "217B",
	"nieuncieuckorean" => "3135",
	"yaekorean" => "3152",
	"beharabic" => "0628",
	"maihanakatthai" => "0E31",
	"Haabkhasiancyrillic" => "04A8",
	"fmsquare" => "3399",
	"bbopomofo" => "3105",
	"plusmonospace" => "FF0B",
	"congruent" => "2245",
	"Hbar" => "0126",
	"Rmonospace" => "FF32",
	"pwsquare" => "33BA",
	"Abreveacute" => "1EAE",
	"isuperior" => "F6ED",
	"periodsmall" => "FE52",
	"ekonkargurmukhi" => "0A74",
	"existential" => "2203",
	"tikeutkorean" => "3137",
	"threecircleinversesansserif" => "278C",
	"hatafsegolhebrew" => "05B1",
	"Pmonospace" => "FF30",
	"rho" => "03C1",
	"asteriskaltonearabic" => "066D",
	"mieumpieupkorean" => "316E",
	"Tsecyrillic" => "0426",
	"Ismall" => "F769",
	"thanthakhatthai" => "0E4C",
	"notlessnorequal" => "2270",
	"fathaarabic" => "064E",
	"ustraightcyrillic" => "04AF",
	"Pecyrillic" => "041F",
	"khokhuatthai" => "0E03",
	"quoterightn" => "0149",
	"Eng" => "014A",
	"ideographicmoonparen" => "322A",
	"hyphensuperior" => "F6E6",
	"postalmarkface" => "3020",
	"Tcircumflexbelow" => "1E70",
	"whiterightpointingsmalltriangle" => "25B9",
	"shaarmenian" => "0577",
	"samekhhebrew" => "05E1",
	"rturned" => "0279",
	"lbopomofo" => "310C",
	"rrvocalicvowelsignbengali" => "09C4",
	"omega1" => "03D6",
	"MBsquare" => "3386",
	"Ntildesmall" => "F7F1",
	"Ljecyrillic" => "0409",
	"Circumflexsmall" => "F6F6",
	"theta" => "03B8",
	"six" => "0036",
	"sahiragana" => "3055",
	"finalnun" => "05DF",
	"ecircumflexhookabove" => "1EC3",
	"iotadieresis" => "03CA",
	"rvocalicgujarati" => "0A8B",
	"hcircumflex" => "0125",
	"khieukhaparenkorean" => "3218",
	"hamzadammaarabic" => "0621",
	"dz" => "01F3",
	"gammalatinsmall" => "0263",
	"blacksmallsquare" => "25AA",
	"bracketrighttp" => "F8F9",
	"Yiarmenian" => "0545",
	"ndotaccent" => "1E45",
	"wcircle" => "24E6",
	"ktsquare" => "33CF",
	"Tonetwo" => "01A7",
	"AEacute" => "01FC",
	"Cdot" => "010A",
	"acircle" => "24D0",
	"Escyrillic" => "0421",
	"xbopomofo" => "3112",
	"vhook" => "028B",
	"similar" => "223C",
	"shaddafathatanarabic" => "0651",
	"bilabialclick" => "0298",
	"nukatakanahalfwidth" => "FF87",
	"kaf" => "05DB",
	"ddhagujarati" => "0AA2",
	"fivethai" => "0E55",
	"ldotaccent" => "0140",
	"space" => "0020",
	"Gjecyrillic" => "0403",
	"nieunparenkorean" => "3201",
	"philatin" => "0278",
	"Nlinebelow" => "1E48",
	"oslashacute" => "01FF",
	"huiitosquare" => "3333",
	"zhearmenian" => "056A",
	"ercyrillic" => "0440",
	"ccircumflex" => "0109",
	"Sdotbelowdotaccent" => "1E68",
	"nonenthai" => "0E13",
	"SF220000" => "2555",
	"fourperiod" => "248B",
	"verticallinebelowcmb" => "0329",
	"saraiithai" => "0E35",
	"Jsmall" => "F76A",
	"Llinebelow" => "1E3A",
	"Ohorn" => "01A0",
	"Uring" => "016E",
	"llvocalicdeva" => "0961",
	"gagujarati" => "0A97",
	"uuvowelsigndeva" => "0942",
	"ukatakana" => "30A6",
	"rieulkiyeoksioskorean" => "3169",
	"qcircle" => "24E0",
	"notprecedes" => "2280",
	"fbopomofo" => "3108",
	"gamma" => "03B3",
	"shindageshshindot" => "FB2C",
	"Fourroman" => "2163",
	"checyrillic" => "0447",
	"maitrithai" => "0E4A",
	"dagesh" => "05BC",
	"udieresisbelow" => "1E73",
	"pieupkiyeokkorean" => "3172",
	"daarmenian" => "0564",
	"zhedieresiscyrillic" => "04DD",
	"shacyrillic" => "0448",
	"Yuslittlecyrillic" => "0466",
	"tetdagesh" => "FB38",
	"Mdotaccent" => "1E40",
	"equalsuperior" => "207C",
	"karoriisquare" => "330D",
	"reharabic" => "0631",
	"rbopomofo" => "3116",
	"carriagereturn" => "21B5",
	"zcircumflex" => "1E91",
	"backslashmonospace" => "FF3C",
	"ysuperior" => "02B8",
	"integraltop" => "2320",
	"kcircle" => "24DA",
	"Ycircumflex" => "0176",
	"nundageshhebrew" => "FB40",
	"proportional" => "221D",
	"yukatakana" => "30E6",
	"yosmallkatakana" => "30E7",
	"guilsinglleft" => "2039",
	"Uhorndotbelow" => "1EF0",
	"controlRS" => "001E",
	"Ucircle" => "24CA",
	"elcyrillic" => "043B",
	"primemod" => "02B9",
	"Ucircumflexbelow" => "1E76",
	"ideographicperiod" => "3002",
	"hatafsegol24" => "05B1",
	"sehiragana" => "305B",
	"Cheharmenian" => "0543",
	"psicyrillic" => "0471",
	"female" => "2640",
	"fivearabic" => "0665",
	"vturned" => "028C",
	"upsilon" => "03C5",
	"ucircumflex" => "00FB",
	"centigrade" => "2103",
	"okatakana" => "30AA",
	"sadfinalarabic" => "FEBA",
	"musicsharpsign" => "266F",
	"sheenarabic" => "0634",
	"Tretroflexhook" => "01AE",
	"betdagesh" => "FB31",
	"Chekhakassiancyrillic" => "04CB",
	"emacronacute" => "1E17",
	"abbreviationsigndeva" => "0970",
	"seventeencircle" => "2470",
	"emdash" => "2014",
	"merkhakefulahebrew" => "05A6",
	"hehinitialaltonearabic" => "FBA8",
	"Softsigncyrillic" => "042C",
	"Gdot" => "0120",
	"Sampigreek" => "03E0",
	"dlinebelow" => "1E0F",
	"wekatakana" => "30F1",
	"dotlessi" => "0131",
	"ecircle" => "24D4",
	"Grave" => "F6CE",
	"Ocircle" => "24C4",
	"ksicyrillic" => "046F",
	"whiteleftpointingsmalltriangle" => "25C3",
	"dotlessj" => "F6BE",
	"epsilontonos" => "03AD",
	"tildeoperator" => "223C",
	"kapyeounpieupkorean" => "3178",
	"Caarmenian" => "053E",
	"abbreviationmarkarmenian" => "055F",
	"segol1f" => "05B6",
	"Ocircumflex" => "00D4",
	"musicflatsign" => "266D",
	"wavyunderscorevertical" => "FE34",
	"rrvocalicvowelsigndeva" => "0944",
	"quotedblleft" => "201C",
	"kiromeetorusquare" => "3316",
	"qofhiriqhebrew" => "05E7",
	"ssuperior" => "F6F2",
	"dochadathai" => "0E0E",
	"yokatakana" => "30E8",
	"rieulsioskorean" => "313D",
	"ramiddlediagonalbengali" => "09F0",
	"ekatakanahalfwidth" => "FF74",
	"khhagurmukhi" => "0A59",
	"efcyrillic" => "0444",
	"edotaccent" => "0117",
	"arrowupdnbse" => "21A8",
	"behmedialarabic" => "FE92",
	"aavowelsigndeva" => "093E",
	"hahiragana" => "306F",
	"wokatakana" => "30F2",
	"squarewhitewithsmallblack" => "25A3",
	"ideographfirecircle" => "328B",
	"Icircle" => "24BE",
	"chieuchacirclekorean" => "3277",
	"Jcircumflex" => "0134",
	"lammeemhahinitialarabic" => "FD88",
	"Psi" => "03A8",
	"ypogegrammeni" => "037A",
	"ralowerdiagonalbengali" => "09F1",
	"ikatakana" => "30A4",
	"cdotaccent" => "010B",
	"twocircleinversesansserif" => "278B",
	"acutetonecmb" => "0341",
	"fisheye" => "25C9",
	"kjecyrillic" => "045C",
	"betasymbolgreek" => "03D0",
	"molsquare" => "33D6",
	"parenleft" => "0028",
	"behinitialarabic" => "FE91",
	"controlSTX" => "0001",
	"iluyhebrew" => "05AC",
	"njecyrillic" => "045A",
	"phophanthai" => "0E1E",
	"asuperior" => "F6E9",
	"uptackmod" => "02D4",
	"qofqubutshebrew" => "05E7",
	"etnahtafoukhhebrew" => "0591",
	"sixarabic" => "0666",
	"Ecircumflex" => "00CA",
	"Ncommaaccent" => "0145",
	"ideographicrepresentparen" => "3239",
	"jhabengali" => "099D",
	"ddhagurmukhi" => "0A22",
	"eopen" => "025B",
	"afii10192" => "F6C6",
	"Ucircumflexsmall" => "F7FB",
	"Kheicoptic" => "03E6",
	"fiveinferior" => "2085",
	"feharabic" => "0641",
	"hmonospace" => "FF48",
	"afii10193" => "045F",
	"afii10080" => "043E",
	"Ycircle" => "24CE",
	"afii10194" => "0463",
	"Ccircle" => "24B8",
	"afii10081" => "043F",
	"lessmonospace" => "FF1C",
	"diamond" => "2666",
	"msuperior" => "F6EF",
	"afii10195" => "0473",
	"afii10082" => "0440",
	"tehhahinitialarabic" => "FCA2",
	"semivoicedmarkkana" => "309C",
	"qofpatahhebrew" => "05E7",
	"fmonospace" => "FF46",
	"afii10196" => "0475",
	"afii10083" => "0441",
	"tildedoublecmb" => "0360",
	"lamedhebrew" => "05DC",
	"acircumflex" => "00E2",
	"afii10084" => "0442",
	"ideographicrightcircle" => "32A8",
	"suhiragana" => "3059",
	"Iotaafrican" => "0196",
	"Chi" => "03A7",
	"afii10085" => "0443",
	"wikatakana" => "30F0",
	"tukatakanahalfwidth" => "FF82",
	"rinvertedbreve" => "0213",
	"hamzafathaarabic" => "0621",
	"aininitialarabic" => "FECB",
	"Ghestrokecyrillic" => "0492",
	"afii10086" => "0444",
	"Ddotaccent" => "1E0A",
	"zahmedialarabic" => "FEC8",
	"threeroman" => "2172",
	"Chaarmenian" => "0549",
	"jabengali" => "099C",
	"afii10087" => "0445",
	"deicoptic" => "03EF",
	"afii10088" => "0446",
	"Bdotaccent" => "1E02",
	"arrowheadrightmod" => "02C3",
	"lefttackbelowcmb" => "0318",
	"bahtthai" => "0E3F",
	"afii10089" => "0447",
	"zerooldstyle" => "F730",
	"sadeva" => "0938",
	"Rcommaaccent" => "0156",
	"controlBEL" => "0007",
	"ainmedialarabic" => "FECC",
	"pbopomofo" => "3106",
	"djecyrillic" => "0452",
	"Scircle" => "24C8",
	"wsuperior" => "02B7",
	"uhorngrave" => "1EEB",
	"glottalstopstrokereversed" => "02A2",
	"breve" => "02D8",
	"tildebelowcmb" => "0330",
	"fiveideographicparen" => "3224",
	"voicediterationhiragana" => "309E",
	"uhorntilde" => "1EEF",
	"ideographicwoodparen" => "322D",
	"circumflexcmb" => "0302",
	"ideva" => "0907",
	"arrowheadupmod" => "02C4",
	"pieupcirclekorean" => "3265",
	"yesieungkorean" => "3181",
	"utilde" => "0169",
	"rieulpieupsioskorean" => "316B",
	"Wcircumflex" => "0174",
	"oshortvowelsigndeva" => "094A",
	"Enhookcyrillic" => "04C7",
	"Gmonospace" => "FF27",
	"Gravesmall" => "F760",
	"yhook" => "01B4",
	"abrevedotbelow" => "1EB7",
	"dalettsere" => "05D3",
	"whiteleftpointingtriangle" => "25C1",
	"ieungacirclekorean" => "3275",
	"Jheharmenian" => "054B",
	"saraiileftthai" => "F886",
	"qamatsqatanwidehebrew" => "05B8",
	"Mcircle" => "24C2",
	"danda" => "0964",
	"nekatakana" => "30CD",
	"sohiragana" => "305D",
	"alphatonos" => "03AC",
	"lamalefhamzaabovefinalarabic" => "FEF8",
	"comma" => "002C",
	"telephone" => "2121",
	"ssangtikeutkorean" => "3138",
	"rieulpieupkorean" => "313C",
	"Khacyrillic" => "0425",
	"Gecyrillic" => "0413",
	"tchehmeeminitialarabic" => "FB7C",
	"shin" => "05E9",
	"scircumflex" => "015D",
	"dabengali" => "09A6",
	"SF250000" => "2557",
	"finalkafhebrew" => "05DA",
	"mumsquare" => "339B",
	"Twelveroman" => "216B",
	"zerowidthnonjoiner" => "200C",
	"decimalseparatorpersian" => "066B",
	"afii10060" => "040B",
	"tadeva" => "0924",
	"horncmb" => "031B",
	"ainarabic" => "0639",
	"afii10061" => "040C",
	"jbopomofo" => "3110",
	"Ecircumflexhookabove" => "1EC2",
	"controlDC1" => "0011",
	"qamats" => "05B8",
	"pointingindexdownwhite" => "261F",
	"afii10062" => "040E",
	"Dotaccentsmall" => "F6F7",
	"controlDC2" => "0012",
	"Ghook" => "0193",
	"kaffinalarabic" => "FEDA",
	"afii10063" => "F6C4",
	"lessoverequal" => "2266",
	"controlDC3" => "0013",
	"ustraightstrokecyrillic" => "04B1",
	"hiriqhebrew" => "05B4",
	"controlDEL" => "007F",
	"SF050000" => "253C",
	"afii10064" => "F6C5",
	"Zhebrevecyrillic" => "04C1",
	"arrowdbldown" => "21D3",
	"controlDC4" => "0014",
	"voicedmarkkanahalfwidth" => "FF9E",
	"ringbelowcmb" => "0325",
	"dadmedialarabic" => "FEC0",
	"afii10065" => "0430",
	"Gcircle" => "24BC",
	"supersetnotequal" => "228B",
	"pemiddlehookcyrillic" => "04A7",
	"lamlamhehisolatedarabic" => "FDF2",
	"afii10066" => "0431",
	"acutedeva" => "0954",
	"upblock" => "2580",
	"reshhatafpatahhebrew" => "05E8",
	"hoarmenian" => "0570",
	"emptyset" => "2205",
	"afii10067" => "0432",
	"auvowelsigndeva" => "094C",
	"vtilde" => "1E7D",
	"gimeldageshhebrew" => "FB32",
	"pansioskorean" => "317F",
	"afii10068" => "0433",
	"exclamdbl" => "203C",
	"mugsquare" => "338D",
	"zerosuperior" => "2070",
	"shinshindothebrew" => "FB2A",
	"afii10069" => "0434",
	"memdagesh" => "FB3E",
	"controlLF" => "000A",
	"fourgujarati" => "0AEA",
	"enbopomofo" => "3123",
	"Shaarmenian" => "0547",
	"yuikorean" => "318C",
	"qubutshebrew" => "05BB",
	"approxequal" => "2248",
	"uvowelsigndeva" => "0941",
	"sihiragana" => "3057",
	"icircumflex" => "00EE",
	"integralbt" => "2321",
	"cstretched" => "0297",
	"gcommaaccent" => "0123",
	"rehyehaleflamarabic" => "0631",
	"klsquare" => "3398",
	"Hcircumflex" => "0124",
	"asteriskmonospace" => "FF0A",
	"hatafsegolwidehebrew" => "05B1",
	"fourideographicparen" => "3223",
	"twentyparen" => "2487",
	"oneideographicparen" => "3220",
	"gadeva" => "0917",
	"Acircle" => "24B6",
	"musicalnote" => "266A",
	"tshecyrillic" => "045B",
	"rieulacirclekorean" => "3271",
	"dbopomofo" => "3109",
	"ytilde" => "1EF9",
	"fourgurmukhi" => "0A6A",
	"ideographicresourceparen" => "323E",
	"zlinebelow" => "1E95",
	"memdageshhebrew" => "FB3E",
	"ljecyrillic" => "0459",
	"muasquare" => "3382",
	"ddagurmukhi" => "0A21",
	"Iicyrillic" => "0418",
	"arrowdashleft" => "21E0",
	"iterationhiragana" => "309D",
	"Kjecyrillic" => "040C",
	"Oslashacute" => "01FE"}

# check if this file is a afm file.
def ifAFM(file)
  f = IO.readlines(file)
  if f[0] =~ /StartFontMetrics/
    return true
  else
    return false
  end
end

# turn to real character
def uni(s)
  if s[0,3] == 'uni'
    s.sub(/uni(\w+)/){[$1.hex].pack('U*')}
  elsif s[0,1] == 'u' && s[0,3] != 'uni'
    s.sub(/u(\w+)/){[$1.hex].pack('U*')}
  else
    s.sub(/(\w+)/){[$1.hex].pack('U*')}
  end
end

# check if in AGL
def isagl(s)
  if $agl.key?(s)
    return true
  else
    return false
  end
end

def mkhtf(file)
  m = 0; a = []
  base = File.basename(file, File.extname(file))
  htf = base + ".htf"
  open(file).each do |line|
    one = line.split[7]
    two =line.split[1]
    if ARGV[0] == '-c' && line =~ /^C / && line !~ /^C -1/
      if line =~ /nounicode/
        a << "'' '' " + two
      elsif isagl(one)
        a << "'" + uni($agl[one]) + "' '' " + two
      else
        a << "'" + uni(one) + "' '' " + two
      end
    elsif line =~ /^C / && line !~ /^C -1/
      if line =~ /nounicode/
        a << "'' '' " + two
      elsif isagl(one)
        a << "'&#x" + $agl[one] + ";' '' " + two
      else
        a << one.sub(/uni|u/,"'&#x") + ";' '' " + two
      end
    end
  end
  be = a.first.split[2]
  en = a.last.split[2]
  num = a.size
  f = open(htf,'w')
  f.puts base + " " + be + " " + en
  f.puts a[m] + " % mkhtf.rb v#{$ver}, #{$t} Edward G.J. Lee."
  while m < num -1
    gap = a[m+1].split[2].to_i - a[m].split[2].to_i
    if gap == 1
      f.puts a[m+1]
    else
      (gap-1).times{f.puts "'' '' ''"}
      f.puts a[m+1]
    end
    m += 1
  end
  f.puts base + " " + be + " " + en
  f.close
end

def usage()
  puts "#{$pname} your.afm"
  puts "#{$pname} -c your.afm"
end

if ARGV.length == 2
  if ARGV[0] == '-c' && ifAFM(ARGV[1])
    mkhtf(ARGV[1])
  else
    usage()
    exit
  end
else
  if ARGV.length != 1
    usage()
    exit
  elsif !File.exist?(ARGV[0])
    puts 'File does not exist!'
    exit
  elsif !ifAFM(ARGV[0])
    puts 'Not a afm file!'
    exit
  else
    mkhtf(ARGV[0])
  end
end
