/* Copyright (C) 2009  Wen-Yen Chuang <caleb AT calno DOT com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <ctype.h>
#include <stdio.h>

#define PROGRAM_NAME "allutf8"
#define PROGRAM_VERSION "0.0.2"

#define PRINT_RANGE(head,tail) for (n = hex_to_number(head) ; n <= hex_to_number(tail) ; n++) { test = n; print_glyph(); }
#define PRINT_SINGLE(single) test = hex_to_number(single) ; print_glyph();

int i, j, k, l, test;

int hex_to_number(char *hex)
{
  int m = 0;
  while (*hex != '\0') {
    m <<= 4;
    if (*hex <= '9')
      m += *hex++ - '0';
    else if (*hex >= 'a')
      m += *hex++ - 'a' + 10;
    else
      m += *hex++ - 'A' + 10;
  }
  return m;
}

void cal_two_bytes()
{
  l += ((test &    1) ==    1) ?  1 : 0;
  l += ((test &    2) ==    2) ?  2 : 0;
  l += ((test &    4) ==    4) ?  4 : 0;
  l += ((test &    8) ==    8) ?  8 : 0;
  l += ((test &   16) ==   16) ? 16 : 0;
  l += ((test &   32) ==   32) ? 32 : 0;
  k += ((test &   64) ==   64) ?  1 : 0;
  k += ((test &  128) ==  128) ?  2 : 0;
  k += ((test &  256) ==  256) ?  4 : 0;
  k += ((test &  512) ==  512) ?  8 : 0;
  k += ((test & 1024) == 1024) ? 16 : 0;
}

void cal_three_bytes()
{
  k += ((test &  2048) ==  2048) ? 32 : 0;
  j += ((test &  4096) ==  4096) ?  1 : 0;
  j += ((test &  8192) ==  8192) ?  2 : 0;
  j += ((test & 16384) == 16384) ?  4 : 0;
  j += ((test & 32768) == 32768) ?  8 : 0;
}

void print_glyph()
{
  if (test > -1 && test < 128) {
    printf("%c\n", test);
    return;
  }

  if (test > 127 && test < 2048) {
    k = 192;
    l = 128;
    cal_two_bytes();
    printf("%c%c\n", k, l);
    return;
  }

  if (test > 2047 && test < 65536) {
    j = 224;
    k = 128;
    l = 128;
    cal_two_bytes();
    cal_three_bytes();
    printf("%c%c%c\n", j, k, l);
    return;
  }

  if (test > 65535 && test < 1114112) {
    i = 240;
    j = 128;
    k = 128;
    l = 128;
    cal_two_bytes();
    cal_three_bytes();
    j += ((test &   65536) ==   65536) ? 16 : 0;
    j += ((test &  131072) ==  131072) ? 32 : 0;
    i += ((test &  262144) ==  262144) ?  1 : 0;
    i += ((test &  524288) ==  524288) ?  2 : 0;
    i += ((test & 1048576) == 1048576) ?  4 : 0;
    printf("%c%c%c%c\n", i, j, k, l);
  }
}

int main(int argc, char **argv)
{
  int n;

  if (argc > 1) {
    if (!strncmp(argv[1], "-h", 3)) {
      printf("%s, version %s\n\nOptions:\n\t-h                show this help\n"
             "\t-p / -r [hex]     print the character\n"
             "\t-p / -r [hex hex] print those characters\n", PROGRAM_NAME, PROGRAM_VERSION);
      return;
    }
  }

  if (argc > 3) {
    if (!strncmp(argv[1], "-r", 3) || !strncmp(argv[1], "-p", 3)) {
      if (hex_to_number(argv[2]) < hex_to_number(argv[3]))
        PRINT_RANGE(argv[2],argv[3])
      else
        PRINT_RANGE(argv[3],argv[2])
      return;
    }
  }

  if (argc > 2) {
    if (!strncmp(argv[1], "-r", 3) || !strncmp(argv[1], "-p", 3)) {
      PRINT_SINGLE(argv[2])
      return;
    }
  }

  if (argc < 2) /* <control-0000>..<control-001F> */
    PRINT_RANGE("0000","001F")
  PRINT_RANGE("0020","007E")
  if (argc < 2) /* <control-007F>..<control-009F> */
    PRINT_RANGE("007F","009F")
  PRINT_RANGE("00A0","00AC")
  PRINT_SINGLE("00AD")
  PRINT_RANGE("00AE","01F5")
  PRINT_RANGE("01F6","01F9")
  PRINT_RANGE("01FA","0217")
  PRINT_RANGE("0218","021F")
  PRINT_SINGLE("0220")
  PRINT_SINGLE("0221")
  PRINT_RANGE("0222","0233")
  PRINT_RANGE("0234","0236")
  PRINT_RANGE("0237","0241")
  PRINT_RANGE("0242","024F")
  PRINT_RANGE("0250","02A8")
  PRINT_RANGE("02A9","02AD")
  PRINT_RANGE("02AE","02AF")
  PRINT_RANGE("02B0","02DE")
  PRINT_SINGLE("02DF")
  PRINT_RANGE("02E0","02E9")
  PRINT_RANGE("02EA","02EE")
  PRINT_RANGE("02EF","02FF")
  PRINT_RANGE("0300","0345")
  PRINT_RANGE("0346","034E")
  PRINT_SINGLE("034F")
  PRINT_RANGE("0350","0357")
  PRINT_RANGE("0358","035C")
  PRINT_RANGE("035D","035F")
  PRINT_RANGE("0360","0361")
  PRINT_SINGLE("0362")
  PRINT_RANGE("0363","036F")
  PRINT_RANGE("0370","0373")
  PRINT_RANGE("0374","0375")
  PRINT_RANGE("0376","0377")
  PRINT_SINGLE("037A")
  PRINT_RANGE("037B","037D")
  PRINT_SINGLE("037E")
  PRINT_RANGE("0384","038A")
  PRINT_SINGLE("038C")
  PRINT_RANGE("038E","03A1")
  PRINT_RANGE("03A3","03CE")
  PRINT_SINGLE("03CF")
  PRINT_RANGE("03D0","03D6")
  PRINT_SINGLE("03D7")
  PRINT_RANGE("03D8","03D9")
  PRINT_SINGLE("03DA")
  PRINT_SINGLE("03DB")
  PRINT_SINGLE("03DC")
  PRINT_SINGLE("03DD")
  PRINT_SINGLE("03DE")
  PRINT_SINGLE("03DF")
  PRINT_SINGLE("03E0")
  PRINT_SINGLE("03E1")
  PRINT_RANGE("03E2","03F3")
  PRINT_RANGE("03F4","03F5")
  PRINT_SINGLE("03F6")
  PRINT_RANGE("03F7","03FB")
  PRINT_RANGE("03FC","03FF")
  PRINT_SINGLE("0400")
  PRINT_RANGE("0401","040C")
  PRINT_SINGLE("040D")
  PRINT_RANGE("040E","044F")
  PRINT_SINGLE("0450")
  PRINT_RANGE("0451","045C")
  PRINT_SINGLE("045D")
  PRINT_RANGE("045E","0486")
  PRINT_SINGLE("0487")
  PRINT_RANGE("0488","0489")
  PRINT_RANGE("048A","048B")
  PRINT_RANGE("048C","048F")
  PRINT_RANGE("0490","04C4")
  PRINT_RANGE("04C5","04C6")
  PRINT_RANGE("04C7","04C8")
  PRINT_RANGE("04C9","04CA")
  PRINT_RANGE("04CB","04CC")
  PRINT_RANGE("04CD","04CE")
  PRINT_SINGLE("04CF")
  PRINT_RANGE("04D0","04EB")
  PRINT_RANGE("04EC","04ED")
  PRINT_RANGE("04EE","04F5")
  PRINT_RANGE("04F6","04F7")
  PRINT_RANGE("04F8","04F9")
  PRINT_RANGE("04FA","04FF")
  PRINT_RANGE("0500","050F")
  PRINT_RANGE("0510","0513")
  PRINT_RANGE("0514","0523")
  PRINT_RANGE("0531","0556")
  PRINT_RANGE("0559","055F")
  PRINT_RANGE("0561","0587")
  PRINT_SINGLE("0589")
  PRINT_SINGLE("058A")
  PRINT_RANGE("0591","05A1")
  PRINT_SINGLE("05A2")
  PRINT_RANGE("05A3","05AF")
  PRINT_RANGE("05B0","05B9")
  PRINT_SINGLE("05BA")
  PRINT_RANGE("05BB","05C3")
  PRINT_SINGLE("05C4")
  PRINT_RANGE("05C5","05C7")
  PRINT_RANGE("05D0","05EA")
  PRINT_RANGE("05F0","05F4")
  PRINT_RANGE("0600","0603")
  PRINT_RANGE("0606","060A")
  PRINT_SINGLE("060B")
  PRINT_SINGLE("060C")
  PRINT_RANGE("060D","0615")
  PRINT_RANGE("0616","061A")
  PRINT_SINGLE("061B")
  PRINT_SINGLE("061E")
  PRINT_SINGLE("061F")
  PRINT_RANGE("0621","063A")
  PRINT_RANGE("063B","063F")
  PRINT_RANGE("0640","0652")
  PRINT_RANGE("0653","0655")
  PRINT_RANGE("0656","0658")
  PRINT_RANGE("0659","065E")
  PRINT_RANGE("0660","066D")
  PRINT_RANGE("066E","066F")
  PRINT_RANGE("0670","06B7")
  PRINT_RANGE("06B8","06B9")
  PRINT_RANGE("06BA","06BE")
  PRINT_SINGLE("06BF")
  PRINT_RANGE("06C0","06CE")
  PRINT_SINGLE("06CF")
  PRINT_RANGE("06D0","06DC")
  PRINT_SINGLE("06DD")
  PRINT_RANGE("06DE","06ED")
  PRINT_RANGE("06EE","06EF")
  PRINT_RANGE("06F0","06F9")
  PRINT_RANGE("06FA","06FE")
  PRINT_SINGLE("06FF")
  PRINT_RANGE("0700","070D")
  PRINT_SINGLE("070F")
  PRINT_RANGE("0710","072C")
  PRINT_RANGE("072D","072F")
  PRINT_RANGE("0730","074A")
  PRINT_RANGE("074D","074F")
  PRINT_RANGE("0750","076D")
  PRINT_RANGE("076E","077F")
  PRINT_RANGE("0780","07B0")
  PRINT_SINGLE("07B1")
  PRINT_RANGE("07C0","07FA")
  PRINT_RANGE("0901","0903")
  PRINT_SINGLE("0904")
  PRINT_RANGE("0905","0939")
  PRINT_RANGE("093C","094D")
  PRINT_RANGE("0950","0954")
  PRINT_RANGE("0958","0970")
  PRINT_RANGE("0971","0972")
  PRINT_RANGE("097B","097C")
  PRINT_SINGLE("097D")
  PRINT_RANGE("097E","097F")
  PRINT_RANGE("0981","0983")
  PRINT_RANGE("0985","098C")
  PRINT_RANGE("098F","0990")
  PRINT_RANGE("0993","09A8")
  PRINT_RANGE("09AA","09B0")
  PRINT_SINGLE("09B2")
  PRINT_RANGE("09B6","09B9")
  PRINT_SINGLE("09BC")
  PRINT_SINGLE("09BD")
  PRINT_RANGE("09BE","09C4")
  PRINT_RANGE("09C7","09C8")
  PRINT_RANGE("09CB","09CD")
  PRINT_SINGLE("09CE")
  PRINT_SINGLE("09D7")
  PRINT_RANGE("09DC","09DD")
  PRINT_RANGE("09DF","09E3")
  PRINT_RANGE("09E6","09FA")
  PRINT_SINGLE("0A01")
  PRINT_SINGLE("0A02")
  PRINT_SINGLE("0A03")
  PRINT_RANGE("0A05","0A0A")
  PRINT_RANGE("0A0F","0A10")
  PRINT_RANGE("0A13","0A28")
  PRINT_RANGE("0A2A","0A30")
  PRINT_RANGE("0A32","0A33")
  PRINT_RANGE("0A35","0A36")
  PRINT_RANGE("0A38","0A39")
  PRINT_SINGLE("0A3C")
  PRINT_RANGE("0A3E","0A42")
  PRINT_RANGE("0A47","0A48")
  PRINT_RANGE("0A4B","0A4D")
  PRINT_SINGLE("0A51")
  PRINT_RANGE("0A59","0A5C")
  PRINT_SINGLE("0A5E")
  PRINT_RANGE("0A66","0A74")
  PRINT_SINGLE("0A75")
  PRINT_RANGE("0A81","0A83")
  PRINT_RANGE("0A85","0A8B")
  PRINT_SINGLE("0A8C")
  PRINT_SINGLE("0A8D")
  PRINT_RANGE("0A8F","0A91")
  PRINT_RANGE("0A93","0AA8")
  PRINT_RANGE("0AAA","0AB0")
  PRINT_RANGE("0AB2","0AB3")
  PRINT_RANGE("0AB5","0AB9")
  PRINT_RANGE("0ABC","0AC5")
  PRINT_RANGE("0AC7","0AC9")
  PRINT_RANGE("0ACB","0ACD")
  PRINT_SINGLE("0AD0")
  PRINT_SINGLE("0AE0")
  PRINT_RANGE("0AE1","0AE3")
  PRINT_RANGE("0AE6","0AEF")
  PRINT_SINGLE("0AF1")
  PRINT_RANGE("0B01","0B03")
  PRINT_RANGE("0B05","0B0C")
  PRINT_RANGE("0B0F","0B10")
  PRINT_RANGE("0B13","0B28")
  PRINT_RANGE("0B2A","0B30")
  PRINT_RANGE("0B32","0B33")
  PRINT_SINGLE("0B35")
  PRINT_RANGE("0B36","0B39")
  PRINT_RANGE("0B3C","0B43")
  PRINT_SINGLE("0B44")
  PRINT_RANGE("0B47","0B48")
  PRINT_RANGE("0B4B","0B4D")
  PRINT_RANGE("0B56","0B57")
  PRINT_RANGE("0B5C","0B5D")
  PRINT_RANGE("0B5F","0B61")
  PRINT_RANGE("0B62","0B63")
  PRINT_RANGE("0B66","0B70")
  PRINT_SINGLE("0B71")
  PRINT_RANGE("0B82","0B83")
  PRINT_RANGE("0B85","0B8A")
  PRINT_RANGE("0B8E","0B90")
  PRINT_RANGE("0B92","0B95")
  PRINT_RANGE("0B99","0B9A")
  PRINT_SINGLE("0B9C")
  PRINT_RANGE("0B9E","0B9F")
  PRINT_RANGE("0BA3","0BA4")
  PRINT_RANGE("0BA8","0BAA")
  PRINT_RANGE("0BAE","0BB5")
  PRINT_SINGLE("0BB6")
  PRINT_RANGE("0BB7","0BB9")
  PRINT_RANGE("0BBE","0BC2")
  PRINT_RANGE("0BC6","0BC8")
  PRINT_RANGE("0BCA","0BCD")
  PRINT_SINGLE("0BD0")
  PRINT_SINGLE("0BD7")
  PRINT_SINGLE("0BE6")
  PRINT_RANGE("0BE7","0BF2")
  PRINT_RANGE("0BF3","0BFA")
  PRINT_RANGE("0C01","0C03")
  PRINT_RANGE("0C05","0C0C")
  PRINT_RANGE("0C0E","0C10")
  PRINT_RANGE("0C12","0C28")
  PRINT_RANGE("0C2A","0C33")
  PRINT_RANGE("0C35","0C39")
  PRINT_SINGLE("0C3D")
  PRINT_RANGE("0C3E","0C44")
  PRINT_RANGE("0C46","0C48")
  PRINT_RANGE("0C4A","0C4D")
  PRINT_RANGE("0C55","0C56")
  PRINT_RANGE("0C58","0C59")
  PRINT_RANGE("0C60","0C61")
  PRINT_RANGE("0C62","0C63")
  PRINT_RANGE("0C66","0C6F")
  PRINT_RANGE("0C78","0C7F")
  PRINT_RANGE("0C82","0C83")
  PRINT_RANGE("0C85","0C8C")
  PRINT_RANGE("0C8E","0C90")
  PRINT_RANGE("0C92","0CA8")
  PRINT_RANGE("0CAA","0CB3")
  PRINT_RANGE("0CB5","0CB9")
  PRINT_RANGE("0CBC","0CBD")
  PRINT_RANGE("0CBE","0CC4")
  PRINT_RANGE("0CC6","0CC8")
  PRINT_RANGE("0CCA","0CCD")
  PRINT_RANGE("0CD5","0CD6")
  PRINT_SINGLE("0CDE")
  PRINT_RANGE("0CE0","0CE1")
  PRINT_RANGE("0CE2","0CE3")
  PRINT_RANGE("0CE6","0CEF")
  PRINT_RANGE("0CF1","0CF2")
  PRINT_RANGE("0D02","0D03")
  PRINT_RANGE("0D05","0D0C")
  PRINT_RANGE("0D0E","0D10")
  PRINT_RANGE("0D12","0D28")
  PRINT_RANGE("0D2A","0D39")
  PRINT_SINGLE("0D3D")
  PRINT_RANGE("0D3E","0D43")
  PRINT_SINGLE("0D44")
  PRINT_RANGE("0D46","0D48")
  PRINT_RANGE("0D4A","0D4D")
  PRINT_SINGLE("0D57")
  PRINT_RANGE("0D60","0D61")
  PRINT_RANGE("0D62","0D63")
  PRINT_RANGE("0D66","0D6F")
  PRINT_RANGE("0D70","0D75")
  PRINT_RANGE("0D79","0D7F")
  PRINT_RANGE("0D82","0D83")
  PRINT_RANGE("0D85","0D96")
  PRINT_RANGE("0D9A","0DB1")
  PRINT_RANGE("0DB3","0DBB")
  PRINT_SINGLE("0DBD")
  PRINT_RANGE("0DC0","0DC6")
  PRINT_SINGLE("0DCA")
  PRINT_RANGE("0DCF","0DD4")
  PRINT_SINGLE("0DD6")
  PRINT_RANGE("0DD8","0DDF")
  PRINT_RANGE("0DF2","0DF4")
  PRINT_RANGE("0E01","0E3A")
  PRINT_RANGE("0E3F","0E5B")
  PRINT_RANGE("0E81","0E82")
  PRINT_SINGLE("0E84")
  PRINT_RANGE("0E87","0E88")
  PRINT_SINGLE("0E8A")
  PRINT_SINGLE("0E8D")
  PRINT_RANGE("0E94","0E97")
  PRINT_RANGE("0E99","0E9F")
  PRINT_RANGE("0EA1","0EA3")
  PRINT_SINGLE("0EA5")
  PRINT_SINGLE("0EA7")
  PRINT_RANGE("0EAA","0EAB")
  PRINT_RANGE("0EAD","0EB9")
  PRINT_RANGE("0EBB","0EBD")
  PRINT_RANGE("0EC0","0EC4")
  PRINT_SINGLE("0EC6")
  PRINT_RANGE("0EC8","0ECD")
  PRINT_RANGE("0ED0","0ED9")
  PRINT_RANGE("0EDC","0EDD")
  PRINT_RANGE("0F00","0F47")
  PRINT_RANGE("0F49","0F69")
  PRINT_SINGLE("0F6A")
  PRINT_RANGE("0F6B","0F6C")
  PRINT_RANGE("0F71","0F8B")
  PRINT_RANGE("0F90","0F95")
  PRINT_SINGLE("0F96")
  PRINT_SINGLE("0F97")
  PRINT_RANGE("0F99","0FAD")
  PRINT_RANGE("0FAE","0FB0")
  PRINT_RANGE("0FB1","0FB7")
  PRINT_SINGLE("0FB8")
  PRINT_SINGLE("0FB9")
  PRINT_RANGE("0FBA","0FBC")
  PRINT_RANGE("0FBE","0FCC")
  PRINT_SINGLE("0FCE")
  PRINT_SINGLE("0FCF")
  PRINT_RANGE("0FD0","0FD1")
  PRINT_RANGE("0FD2","0FD4")
  PRINT_RANGE("1000","1021")
  PRINT_SINGLE("1022")
  PRINT_RANGE("1023","1027")
  PRINT_SINGLE("1028")
  PRINT_RANGE("1029","102A")
  PRINT_SINGLE("102B")
  PRINT_RANGE("102C","1032")
  PRINT_RANGE("1033","1035")
  PRINT_RANGE("1036","1039")
  PRINT_RANGE("103A","103F")
  PRINT_RANGE("1040","1059")
  PRINT_RANGE("105A","1099")
  PRINT_RANGE("109E","109F")
  PRINT_RANGE("10A0","10C5")
  PRINT_RANGE("10D0","10F6")
  PRINT_RANGE("10F7","10F8")
  PRINT_RANGE("10F9","10FA")
  PRINT_SINGLE("10FB")
  PRINT_SINGLE("10FC")
  PRINT_RANGE("1100","1159")
  PRINT_RANGE("115F","11A2")
  PRINT_RANGE("11A8","11F9")
  PRINT_RANGE("1200","1206")
  PRINT_SINGLE("1207")
  PRINT_RANGE("1208","1246")
  PRINT_SINGLE("1247")
  PRINT_SINGLE("1248")
  PRINT_RANGE("124A","124D")
  PRINT_RANGE("1250","1256")
  PRINT_SINGLE("1258")
  PRINT_RANGE("125A","125D")
  PRINT_RANGE("1260","1286")
  PRINT_SINGLE("1287")
  PRINT_SINGLE("1288")
  PRINT_RANGE("128A","128D")
  PRINT_RANGE("1290","12AE")
  PRINT_SINGLE("12AF")
  PRINT_SINGLE("12B0")
  PRINT_RANGE("12B2","12B5")
  PRINT_RANGE("12B8","12BE")
  PRINT_SINGLE("12C0")
  PRINT_RANGE("12C2","12C5")
  PRINT_RANGE("12C8","12CE")
  PRINT_SINGLE("12CF")
  PRINT_RANGE("12D0","12D6")
  PRINT_RANGE("12D8","12EE")
  PRINT_SINGLE("12EF")
  PRINT_RANGE("12F0","130E")
  PRINT_SINGLE("130F")
  PRINT_SINGLE("1310")
  PRINT_RANGE("1312","1315")
  PRINT_RANGE("1318","131E")
  PRINT_SINGLE("131F")
  PRINT_RANGE("1320","1346")
  PRINT_SINGLE("1347")
  PRINT_RANGE("1348","135A")
  PRINT_RANGE("135F","1360")
  PRINT_RANGE("1361","137C")
  PRINT_RANGE("1380","1399")
  PRINT_RANGE("13A0","13F4")
  PRINT_RANGE("1401","1676")
  PRINT_RANGE("1680","169C")
  PRINT_RANGE("16A0","16F0")
  PRINT_RANGE("1700","170C")
  PRINT_RANGE("170E","1714")
  PRINT_RANGE("1720","1736")
  PRINT_RANGE("1740","1753")
  PRINT_RANGE("1760","176C")
  PRINT_RANGE("176E","1770")
  PRINT_RANGE("1772","1773")
  PRINT_RANGE("1780","17B3")
  PRINT_RANGE("17B4","17B5")
  PRINT_RANGE("17B6","17DC")
  PRINT_SINGLE("17DD")
  PRINT_RANGE("17E0","17E9")
  PRINT_RANGE("17F0","17F9")
  PRINT_RANGE("1800","180E")
  PRINT_RANGE("1810","1819")
  PRINT_RANGE("1820","1877")
  PRINT_RANGE("1880","18A9")
  PRINT_SINGLE("18AA")
  PRINT_RANGE("1900","191C")
  PRINT_RANGE("1920","192B")
  PRINT_RANGE("1930","193B")
  PRINT_SINGLE("1940")
  PRINT_RANGE("1944","196D")
  PRINT_RANGE("1970","1974")
  PRINT_RANGE("1980","19A9")
  PRINT_RANGE("19B0","19C9")
  PRINT_RANGE("19D0","19D9")
  PRINT_RANGE("19DE","19DF")
  PRINT_RANGE("19E0","19FF")
  PRINT_RANGE("1A00","1A1B")
  PRINT_RANGE("1A1E","1A1F")
  PRINT_RANGE("1B00","1B4B")
  PRINT_RANGE("1B50","1B7C")
  PRINT_RANGE("1B80","1BAA")
  PRINT_RANGE("1BAE","1BB9")
  PRINT_RANGE("1C00","1C37")
  PRINT_RANGE("1C3B","1C49")
  PRINT_RANGE("1C4D","1C7F")
  PRINT_RANGE("1D00","1D6B")
  PRINT_RANGE("1D6C","1DC3")
  PRINT_RANGE("1DC4","1DCA")
  PRINT_RANGE("1DCB","1DE6")
  PRINT_RANGE("1DFE","1DFF")
  PRINT_RANGE("1E00","1E9A")
  PRINT_SINGLE("1E9B")
  PRINT_RANGE("1E9C","1E9F")
  PRINT_RANGE("1EA0","1EF9")
  PRINT_RANGE("1EFA","1EFF")
  PRINT_RANGE("1F00","1F15")
  PRINT_RANGE("1F18","1F1D")
  PRINT_RANGE("1F20","1F45")
  PRINT_RANGE("1F48","1F4D")
  PRINT_RANGE("1F50","1F57")
  PRINT_SINGLE("1F59")
  PRINT_SINGLE("1F5B")
  PRINT_SINGLE("1F5D")
  PRINT_RANGE("1F5F","1F7D")
  PRINT_RANGE("1F80","1FB4")
  PRINT_RANGE("1FB6","1FC4")
  PRINT_RANGE("1FC6","1FD3")
  PRINT_RANGE("1FD6","1FDB")
  PRINT_RANGE("1FDD","1FEF")
  PRINT_RANGE("1FF2","1FF4")
  PRINT_RANGE("1FF6","1FFE")
  PRINT_RANGE("2000","200A")
  PRINT_RANGE("200B","200F")
  PRINT_RANGE("2010","2027")
  PRINT_RANGE("2028","202E")
  PRINT_SINGLE("202F")
  PRINT_RANGE("2030","2046")
  PRINT_SINGLE("2047")
  PRINT_RANGE("2048","204D")
  PRINT_RANGE("204E","2052")
  PRINT_RANGE("2053","2054")
  PRINT_RANGE("2055","2056")
  PRINT_SINGLE("2057")
  PRINT_RANGE("2058","205E")
  PRINT_SINGLE("205F")
  PRINT_RANGE("2060","2063")
  PRINT_SINGLE("2064")
  PRINT_RANGE("206A","206F")
  PRINT_SINGLE("2070")
  PRINT_SINGLE("2071")
  PRINT_RANGE("2074","208E")
  PRINT_RANGE("2090","2094")
  PRINT_RANGE("20A0","20AA")
  PRINT_SINGLE("20AB")
  PRINT_SINGLE("20AC")
  PRINT_RANGE("20AD","20AF")
  PRINT_RANGE("20B0","20B1")
  PRINT_RANGE("20B2","20B5")
  PRINT_RANGE("20D0","20E1")
  PRINT_RANGE("20E2","20E3")
  PRINT_RANGE("20E4","20EA")
  PRINT_SINGLE("20EB")
  PRINT_RANGE("20EC","20EF")
  PRINT_SINGLE("20F0")
  PRINT_RANGE("2100","2138")
  PRINT_RANGE("2139","213A")
  PRINT_SINGLE("213B")
  PRINT_SINGLE("213C")
  PRINT_RANGE("213D","214B")
  PRINT_SINGLE("214C")
  PRINT_RANGE("214D","214E")
  PRINT_SINGLE("214F")
  PRINT_RANGE("2153","2182")
  PRINT_SINGLE("2183")
  PRINT_SINGLE("2184")
  PRINT_RANGE("2185","2188")
  PRINT_RANGE("2190","21EA")
  PRINT_RANGE("21EB","21F3")
  PRINT_RANGE("21F4","21FF")
  PRINT_RANGE("2200","22F1")
  PRINT_RANGE("22F2","22FF")
  PRINT_SINGLE("2300")
  PRINT_SINGLE("2301")
  PRINT_RANGE("2302","237A")
  PRINT_SINGLE("237B")
  PRINT_SINGLE("237C")
  PRINT_RANGE("237D","239A")
  PRINT_RANGE("239B","23CE")
  PRINT_RANGE("23CF","23D0")
  PRINT_RANGE("23D1","23DB")
  PRINT_RANGE("23DC","23E7")
  PRINT_RANGE("2400","2424")
  PRINT_RANGE("2425","2426")
  PRINT_RANGE("2440","244A")
  PRINT_RANGE("2460","24EA")
  PRINT_RANGE("24EB","24FE")
  PRINT_SINGLE("24FF")
  PRINT_RANGE("2500","2595")
  PRINT_RANGE("2596","259F")
  PRINT_RANGE("25A0","25EF")
  PRINT_RANGE("25F0","25F7")
  PRINT_RANGE("25F8","25FF")
  PRINT_RANGE("2600","2613")
  PRINT_RANGE("2614","2615")
  PRINT_RANGE("2616","2617")
  PRINT_SINGLE("2618")
  PRINT_SINGLE("2619")
  PRINT_RANGE("261A","266F")
  PRINT_RANGE("2670","2671")
  PRINT_RANGE("2672","267D")
  PRINT_RANGE("267E","267F")
  PRINT_RANGE("2680","2689")
  PRINT_RANGE("268A","2691")
  PRINT_RANGE("2692","269C")
  PRINT_SINGLE("269D")
  PRINT_RANGE("26A0","26A1")
  PRINT_RANGE("26A2","26B1")
  PRINT_SINGLE("26B2")
  PRINT_RANGE("26B3","26BC")
  PRINT_RANGE("26C0","26C3")
  PRINT_RANGE("2701","2704")
  PRINT_RANGE("2706","2709")
  PRINT_RANGE("270C","2727")
  PRINT_RANGE("2729","274B")
  PRINT_SINGLE("274D")
  PRINT_RANGE("274F","2752")
  PRINT_SINGLE("2756")
  PRINT_RANGE("2758","275E")
  PRINT_RANGE("2761","2767")
  PRINT_RANGE("2768","2775")
  PRINT_RANGE("2776","2794")
  PRINT_RANGE("2798","27AF")
  PRINT_RANGE("27B1","27BE")
  PRINT_RANGE("27C0","27C6")
  PRINT_RANGE("27C7","27CA")
  PRINT_SINGLE("27CC")
  PRINT_RANGE("27D0","27EB")
  PRINT_RANGE("27EC","27EF")
  PRINT_RANGE("27F0","27FF")
  PRINT_RANGE("2800","28FF")
  PRINT_RANGE("2900","2AFF")
  PRINT_RANGE("2B00","2B0D")
  PRINT_RANGE("2B0E","2B13")
  PRINT_RANGE("2B14","2B1A")
  PRINT_RANGE("2B1B","2B1F")
  PRINT_RANGE("2B20","2B23")
  PRINT_RANGE("2B24","2B4C")
  PRINT_RANGE("2B50","2B54")
  PRINT_RANGE("2C00","2C2E")
  PRINT_RANGE("2C30","2C5E")
  PRINT_RANGE("2C60","2C6C")
  PRINT_RANGE("2C6D","2C6F")
  PRINT_RANGE("2C71","2C73")
  PRINT_RANGE("2C74","2C77")
  PRINT_RANGE("2C78","2C7D")
  PRINT_RANGE("2C80","2CEA")
  PRINT_RANGE("2CF9","2D25")
  PRINT_RANGE("2D30","2D65")
  PRINT_SINGLE("2D6F")
  PRINT_RANGE("2D80","2D96")
  PRINT_RANGE("2DA0","2DA6")
  PRINT_RANGE("2DA8","2DAE")
  PRINT_RANGE("2DB0","2DB6")
  PRINT_RANGE("2DB8","2DBE")
  PRINT_RANGE("2DC0","2DC6")
  PRINT_RANGE("2DC8","2DCE")
  PRINT_RANGE("2DD0","2DD6")
  PRINT_RANGE("2DD8","2DDE")
  PRINT_RANGE("2DE0","2DFF")
  PRINT_RANGE("2E00","2E17")
  PRINT_RANGE("2E18","2E1B")
  PRINT_RANGE("2E1C","2E1D")
  PRINT_RANGE("2E1E","2E30")
  PRINT_RANGE("2E80","2E99")
  PRINT_RANGE("2E9B","2EF3")
  PRINT_RANGE("2F00","2FD5")
  PRINT_RANGE("2FF0","2FFB")
  PRINT_RANGE("3000","3037")
  PRINT_RANGE("3038","303A")
  PRINT_RANGE("303B","303D")
  PRINT_SINGLE("303E")
  PRINT_SINGLE("303F")
  PRINT_RANGE("3041","3094")
  PRINT_RANGE("3095","3096")
  PRINT_RANGE("3099","309E")
  PRINT_RANGE("309F","30A0")
  PRINT_RANGE("30A1","30FE")
  PRINT_SINGLE("30FF")
  PRINT_RANGE("3105","312C")
  PRINT_SINGLE("312D")
  PRINT_RANGE("3131","318E")
  PRINT_RANGE("3190","319F")
  PRINT_RANGE("31A0","31B7")
  PRINT_RANGE("31C0","31CF")
  PRINT_RANGE("31D0","31E3")
  PRINT_RANGE("31F0","31FF")
  PRINT_RANGE("3200","321C")
  PRINT_RANGE("321D","321E")
  PRINT_RANGE("3220","3243")
  PRINT_SINGLE("3250")
  PRINT_RANGE("3251","325F")
  PRINT_RANGE("3260","327B")
  PRINT_RANGE("327C","327D")
  PRINT_SINGLE("327E")
  PRINT_RANGE("327F","32B0")
  PRINT_RANGE("32B1","32BF")
  PRINT_RANGE("32C0","32CB")
  PRINT_RANGE("32CC","32CF")
  PRINT_RANGE("32D0","32FE")
  PRINT_RANGE("3300","3376")
  PRINT_RANGE("3377","337A")
  PRINT_RANGE("337B","33DD")
  PRINT_RANGE("33DE","33DF")
  PRINT_RANGE("33E0","33FE")
  PRINT_SINGLE("33FF")
  PRINT_RANGE("3400","4DB5")
  PRINT_RANGE("4DC0","4DFF")
  PRINT_RANGE("4E00","9FA5")
  PRINT_RANGE("9FA6","9FBB")
  PRINT_RANGE("9FBC","9FC3")
  PRINT_RANGE("A000","A48C")
  PRINT_RANGE("A490","A4A1")
  PRINT_RANGE("A4A2","A4A3")
  PRINT_RANGE("A4A4","A4B3")
  PRINT_SINGLE("A4B4")
  PRINT_RANGE("A4B5","A4C0")
  PRINT_SINGLE("A4C1")
  PRINT_RANGE("A4C2","A4C4")
  PRINT_SINGLE("A4C5")
  PRINT_SINGLE("A4C6")
  PRINT_RANGE("A500","A62B")
  PRINT_RANGE("A640","A65F")
  PRINT_RANGE("A662","A673")
  PRINT_RANGE("A67C","A697")
  PRINT_RANGE("A700","A716")
  PRINT_RANGE("A717","A71A")
  PRINT_RANGE("A71B","A71F")
  PRINT_RANGE("A720","A721")
  PRINT_RANGE("A722","A78C")
  PRINT_RANGE("A7FB","A7FF")
  PRINT_RANGE("A800","A82B")
  PRINT_RANGE("A840","A877")
  PRINT_RANGE("A880","A8C4")
  PRINT_RANGE("A8CE","A8D9")
  PRINT_RANGE("A900","A953")
  PRINT_SINGLE("A95F")
  PRINT_RANGE("AA00","AA36")
  PRINT_RANGE("AA40","AA4D")
  PRINT_RANGE("AA50","AA59")
  PRINT_RANGE("AA5C","AA5F")
  PRINT_RANGE("AC00","D7A3")
  if (argc < 2) /* <surrogate-D800>..<surrogate-DFFF> */
    PRINT_RANGE("D800","DFFF")
  if (argc < 2) /* <private-use-E000>..<private-use-F8FF> */
    PRINT_RANGE("E000","F8FF")
  PRINT_RANGE("F900","FA2D")
  PRINT_RANGE("FA30","FA6A")
  PRINT_RANGE("FA70","FAD9")
  PRINT_RANGE("FB00","FB06")
  PRINT_RANGE("FB13","FB17")
  PRINT_SINGLE("FB1D")
  PRINT_RANGE("FB1E","FB36")
  PRINT_RANGE("FB38","FB3C")
  PRINT_SINGLE("FB3E")
  PRINT_RANGE("FB40","FB41")
  PRINT_RANGE("FB43","FB44")
  PRINT_RANGE("FB46","FBB1")
  PRINT_RANGE("FBD3","FD3F")
  PRINT_RANGE("FD50","FD8F")
  PRINT_RANGE("FD92","FDC7")
  if (argc < 2) /* <noncharacter-FDD0>..<noncharacter-FDEF> */
    PRINT_RANGE("FDD0","FDEF")
  PRINT_RANGE("FDF0","FDFB")
  PRINT_SINGLE("FDFC")
  PRINT_SINGLE("FDFD")
  PRINT_RANGE("FE00","FE0F")
  PRINT_RANGE("FE10","FE19")
  PRINT_RANGE("FE20","FE23")
  PRINT_RANGE("FE24","FE26")
  PRINT_RANGE("FE30","FE44")
  PRINT_RANGE("FE45","FE46")
  PRINT_RANGE("FE47","FE48")
  PRINT_RANGE("FE49","FE52")
  PRINT_RANGE("FE54","FE66")
  PRINT_RANGE("FE68","FE6B")
  PRINT_RANGE("FE70","FE72")
  PRINT_SINGLE("FE73")
  PRINT_SINGLE("FE74")
  PRINT_RANGE("FE76","FEFC")
  PRINT_SINGLE("FEFF")
  PRINT_RANGE("FF01","FF5E")
  PRINT_RANGE("FF5F","FF60")
  PRINT_RANGE("FF61","FFBE")
  PRINT_RANGE("FFC2","FFC7")
  PRINT_RANGE("FFCA","FFCF")
  PRINT_RANGE("FFD2","FFD7")
  PRINT_RANGE("FFDA","FFDC")
  PRINT_RANGE("FFE0","FFE6")
  PRINT_RANGE("FFE8","FFEE")
  PRINT_RANGE("FFF9","FFFB")
  PRINT_SINGLE("FFFC")
  PRINT_SINGLE("FFFD")
  if (argc < 2) /* <noncharacter-FFFE>..<noncharacter-FFFF> */
    PRINT_RANGE("FFFE","FFFF")
  PRINT_RANGE("10000","1000B")
  PRINT_RANGE("1000D","10026")
  PRINT_RANGE("10028","1003A")
  PRINT_RANGE("1003C","1003D")
  PRINT_RANGE("1003F","1004D")
  PRINT_RANGE("10050","1005D")
  PRINT_RANGE("10080","100FA")
  PRINT_RANGE("10100","10102")
  PRINT_RANGE("10107","10133")
  PRINT_RANGE("10137","1013F")
  PRINT_RANGE("10140","1018A")
  PRINT_RANGE("10190","1019B")
  PRINT_RANGE("101D0","101FD")
  PRINT_RANGE("10280","1029C")
  PRINT_RANGE("102A0","102D0")
  PRINT_RANGE("10300","1031E")
  PRINT_RANGE("10320","10323")
  PRINT_RANGE("10330","1034A")
  PRINT_RANGE("10380","1039D")
  PRINT_SINGLE("1039F")
  PRINT_RANGE("103A0","103C3")
  PRINT_RANGE("103C8","103D5")
  PRINT_RANGE("10400","10425")
  PRINT_RANGE("10426","10427")
  PRINT_RANGE("10428","1044D")
  PRINT_RANGE("1044E","1049D")
  PRINT_RANGE("104A0","104A9")
  PRINT_RANGE("10800","10805")
  PRINT_SINGLE("10808")
  PRINT_RANGE("1080A","10835")
  PRINT_RANGE("10837","10838")
  PRINT_SINGLE("1083C")
  PRINT_SINGLE("1083F")
  PRINT_RANGE("10900","10919")
  PRINT_SINGLE("1091F")
  PRINT_RANGE("10920","10939")
  PRINT_SINGLE("1093F")
  PRINT_RANGE("10A00","10A03")
  PRINT_RANGE("10A05","10A06")
  PRINT_RANGE("10A0C","10A13")
  PRINT_RANGE("10A15","10A17")
  PRINT_RANGE("10A19","10A33")
  PRINT_RANGE("10A38","10A3A")
  PRINT_RANGE("10A3F","10A47")
  PRINT_RANGE("10A50","10A58")
  PRINT_RANGE("12000","1236E")
  PRINT_RANGE("12400","12462")
  PRINT_RANGE("12470","12473")
  PRINT_RANGE("1D000","1D0F5")
  PRINT_RANGE("1D100","1D126")
  PRINT_SINGLE("1D129")
  PRINT_RANGE("1D12A","1D172")
  PRINT_RANGE("1D173","1D17A")
  PRINT_RANGE("1D17B","1D1DD")
  PRINT_RANGE("1D200","1D245")
  PRINT_RANGE("1D300","1D356")
  PRINT_RANGE("1D360","1D371")
  PRINT_RANGE("1D400","1D454")
  PRINT_RANGE("1D456","1D49C")
  PRINT_RANGE("1D49E","1D49F")
  PRINT_SINGLE("1D4A2")
  PRINT_RANGE("1D4A5","1D4A6")
  PRINT_RANGE("1D4A9","1D4AC")
  PRINT_RANGE("1D4AE","1D4B9")
  PRINT_SINGLE("1D4BB")
  PRINT_RANGE("1D4BD","1D4C0")
  PRINT_SINGLE("1D4C1")
  PRINT_RANGE("1D4C2","1D4C3")
  PRINT_RANGE("1D4C5","1D505")
  PRINT_RANGE("1D507","1D50A")
  PRINT_RANGE("1D50D","1D514")
  PRINT_RANGE("1D516","1D51C")
  PRINT_RANGE("1D51E","1D539")
  PRINT_RANGE("1D53B","1D53E")
  PRINT_RANGE("1D540","1D544")
  PRINT_SINGLE("1D546")
  PRINT_RANGE("1D54A","1D550")
  PRINT_RANGE("1D552","1D6A3")
  PRINT_RANGE("1D6A4","1D6A5")
  PRINT_RANGE("1D6A8","1D7C9")
  PRINT_RANGE("1D7CA","1D7CB")
  PRINT_RANGE("1D7CE","1D7FF")
  PRINT_RANGE("1F000","1F02B")
  PRINT_RANGE("1F030","1F093")
  if (argc < 2) /* <noncharacter-1FFFE>..<noncharacter-1FFFF> */
    PRINT_RANGE("1FFFE","1FFFF")
  PRINT_RANGE("20000","2A6D6")
  PRINT_RANGE("2F800","2FA1D")
  if (argc < 2) /* <noncharacter-2FFFE>..<noncharacter-2FFFF> */
    PRINT_RANGE("2FFFE","2FFFF")
  if (argc < 2) /* <noncharacter-3FFFE>..<noncharacter-3FFFF> */
    PRINT_RANGE("3FFFE","3FFFF")
  if (argc < 2) /* <noncharacter-4FFFE>..<noncharacter-4FFFF> */
    PRINT_RANGE("4FFFE","4FFFF")
  if (argc < 2) /* <noncharacter-5FFFE>..<noncharacter-5FFFF> */
    PRINT_RANGE("5FFFE","5FFFF")
  if (argc < 2) /* <noncharacter-6FFFE>..<noncharacter-6FFFF> */
    PRINT_RANGE("6FFFE","6FFFF")
  if (argc < 2) /* <noncharacter-7FFFE>..<noncharacter-7FFFF> */
    PRINT_RANGE("7FFFE","7FFFF")
  if (argc < 2) /* <noncharacter-8FFFE>..<noncharacter-8FFFF> */
    PRINT_RANGE("8FFFE","8FFFF")
  if (argc < 2) /* <noncharacter-9FFFE>..<noncharacter-9FFFF> */
    PRINT_RANGE("9FFFE","9FFFF")
  if (argc < 2) /* <noncharacter-AFFFE>..<noncharacter-AFFFF> */
    PRINT_RANGE("AFFFE","AFFFF")
  if (argc < 2) /* <noncharacter-BFFFE>..<noncharacter-BFFFF> */
    PRINT_RANGE("BFFFE","BFFFF")
  if (argc < 2) /* <noncharacter-CFFFE>..<noncharacter-CFFFF> */
    PRINT_RANGE("CFFFE","CFFFF")
  if (argc < 2) /* <noncharacter-DFFFE>..<noncharacter-DFFFF> */
    PRINT_RANGE("DFFFE","DFFFF")
  PRINT_SINGLE("E0001")
  PRINT_RANGE("E0020","E007F")
  PRINT_RANGE("E0100","E01EF")
  if (argc < 2) /* <noncharacter-EFFFE>..<noncharacter-EFFFF> */
    PRINT_RANGE("EFFFE","EFFFF")
  if (argc < 2) /* <private-use-F0000>..<private-use-FFFFD> */
    PRINT_RANGE("F0000","FFFFD")
  if (argc < 2) /* <noncharacter-FFFFE>..<noncharacter-FFFFF> */
    PRINT_RANGE("FFFFE","FFFFF")
  if (argc < 2) /* <private-use-100000>..<private-use-10FFFD> */
    PRINT_RANGE("100000","10FFFD")
  if (argc < 2) /* <noncharacter-10FFFE>..<noncharacter-10FFFF> */
    PRINT_RANGE("10FFFE","10FFFF")

  return;
}
