#!/usr/bin/env sh
# vim:ts=2 sw=2 et
# Edward G.J. Lee <edt1023@cle.linux.org.tw> (2006.03.29)
# Uninstall nsung Type 1 fonts for GNU/linux/*BSD LaTeX CJK.

if [ ! $# -eq 0 ]
then
  echo
  echo "Usage: `basename $0`"
  echo
  exit
fi

if [ "`id -u`" = "0" ]; then
  echo
  echo "Don't use root to do install, abort!"
  echo
  exit
fi

FONTNAME=nsung
VER="1.3.2"
MYTEXMF=$HOME/texmf
MYFONT=$MYTEXMF/fonts
T1DIR=$MYFONT/type1/CJK/$FONTNAME
TFMDIR=$MYFONT/tfm/CJK/$FONTNAME
VFDIR=$MYFONT/vf/CJK/$FONTNAME
MAPDIR=$MYFONT/map/dvips/CJK
LTXDIR=$MYTEXMF/tex/latex/CJK

kpsewhich ${FONTNAME}u01.pfb > /dev/null
if [ $? = 1 ]; then
  echo
  echo "You didn't install New Sung Type 1."
  echo "Or you are not install by install.sh from"
  echo "New Sung 1.3.1, abort!"
  echo
  exit
fi

rm -f $MAPDIR/${FONTNAME}u.map
rm -rf $TFMDIR $T1DIR $VFDIR
rm -f $LTXDIR/UTF8/c70${FONTNAME}.*
rm -f $LTXDIR/Bg5/c00${FONTNAME}.*
rm -f $LTXDIR/GB/c10${FONTNAME}.*
rm -f $LTXDIR/GB/c19${FONTNAME}.*

texhash
echo "Please wait..."
updmap --disable ${FONTNAME}u.map
