#!/usr/bin/env sh
# vim:ts=2 sw=2 et
# Edward G.J. Lee <edt1023@cle.linux.org.tw> (2006.03.29)
# Modified U+89D2-U+89FF to fit Taiwan's convention.(2006.10.10)
# Add GBK virtual fonts.(2006.10.11)
# Install New Sung type 1 fonts for GNU/Linux/*BSD LaTeX CJK.

#FONTNAME=`echo $1 | cut -d- -f1`
FONTNAME=nsung
VER="1.3.3"

if [ ! $# -eq 0 ]; then
  echo
  echo "Install New Sung type 1 font for GNU/Linux/*BSD LaTeX CJK."
  echo "Site: ftp://cle.linux.org.tw/pub2/tex/cjk/fonts/nsungt1"
  echo
  echo "Usage: ./`basename $0`"
  echo
  exit
fi

if [ "`id -u`" = "0" ]; then
  echo
  echo "Don't use root to do install, abort!"
  echo
  exit
fi

kpsewhich ${FONTNAME}u01.pfb > /dev/null
if [ $? = 0 ]; then
  echo
  echo "You already install New Sung Type 1 font, abort!"
  echo
  exit
fi

MYTEXMF=$HOME/texmf
MYFONT=$MYTEXMF/fonts
T1DIR=$MYFONT/type1/CJK/$FONTNAME
TFMDIR=$MYFONT/tfm/CJK/$FONTNAME
VFDIR=$MYFONT/vf/CJK/$FONTNAME
MAPDIR=$MYFONT/map/dvips/CJK
LTXDIR=$MYTEXMF/tex/latex/CJK

mkdir -p $T1DIR $TFMDIR $VFDIR $MAPDIR $LTXDIR/UTF8 $LTXDIR/Bg5 $LTXDIR/GB

cp -f *.map $MAPDIR
cp -f ${FONTNAME}u/*.tfm $TFMDIR
cp -f ${FONTNAME}t/*.tfm $TFMDIR
cp -f ${FONTNAME}s/*.tfm $TFMDIR
cp -f ${FONTNAME}k/*.tfm $TFMDIR
cp -f ${FONTNAME}u/*.pfb $T1DIR
cp -f ${FONTNAME}s/*.pfb $T1DIR
cp -f ${FONTNAME}t/*.vf $VFDIR
cp -f ${FONTNAME}s/*.vf $VFDIR
cp -f ${FONTNAME}k/*.vf $VFDIR
cp -f c70*.* $LTXDIR/UTF8
cp -f c00*.* $LTXDIR/Bg5
cp -f c10*.* c19*.* $LTXDIR/GB

texhash
echo "Please wait..."
updmap --enable Map ${FONTNAME}u.map
echo
echo "New Sung Type 1 font $VER Install completely."
echo "Please use the fontname: $FONTNAME"
echo "For example:"
echo "\begin{CJK}{UTF8}{$FONTNAME}"
echo
echo "You can remove it using uninstall.sh"
echo "uninstall.sh"
echo
