#!/usr/bin/env sh
# vim:ts=2 sw=2 et
# Edward G.J. Lee <edt1023@cle.linux.org.tw> (2007.03.24)
# Install cwTeX type 1 fonts for GNU/Linux/*BSD LaTeX CJK.

BASEN="`basename $0`"
FONTN=cwk
VER="1.1"

if [ ! $# -eq 0 ]; then
  echo
  echo "Install cwTeX type 1 fonts(cwt1) $VER for GNU/Linux/*BSD LaTeX CJK."
  echo "Site1: ftp://cle.linux.org.tw/tex/cjk/fonts/cwt1"
  echo "Site2: http://edt1023.sayya.org/fonts/tex"
  echo
  echo "Usage: ./`basename $0`"
  echo
  exit
fi

if [ "`id -u`" = "0" ]; then
  echo
  echo "Don't use root to do install, abort!"
  echo
  exit
fi

MYTEXMF=$HOME/texmf
MYFONT=$MYTEXMF/fonts
T1DIR=$MYFONT/type1/CJK/$FONTN
TFMDIR=$MYFONT/tfm/CJK/$FONTN
AFMDIR=$MYFONT/afm/CJK/$FONTN
ENCDIR=$MYFONT/enc/CJK/$FONTN
VFDIR=$MYFONT/vf/CJK/$FONTN
MAPDIR=$MYFONT/map/dvips/CJK
LTXDIR=$MYTEXMF/tex/latex/CJK

if [ "$BASEN" != "uninstall.sh" ]; then
  kpsewhich ${FONTN}u01.pfb > /dev/null
  if [ $? = 0 ]; then
    echo
    echo "You already install cwTeX $FONTN Type 1 font, abort!"
    echo
    exit
  fi

  mkdir -p $T1DIR $TFMDIR $AFMDIR $ENCDIR $VFDIR $MAPDIR $LTXDIR/UTF8 $LTXDIR/Bg5
  cp -f *.map $MAPDIR
  cp -f ${FONTN}cu/*.tfm $TFMDIR
  cp -f ${FONTN}cu/*.afm $AFMDIR
  cp -f ${FONTN}cu/*.enc $ENCDIR
  cp -f ${FONTN}cu/*.pfb $T1DIR
  for i in bt bu ct
  do
    cp -f ${FONTN}$i/*.tfm $TFMDIR
    cp -f ${FONTN}$i/*.vf $VFDIR
    cp -f ${FONTN}$i/*.pfb $T1DIR > /dev/null 2>&1
  done
  cp -f c70*.* $LTXDIR/UTF8
  cp -f c00*.* $LTXDIR/Bg5

  texhash
  echo "Please wait..."
  updmap --enable Map ${FONTN}u.map
  echo
  echo "cwTeX $FONTN Type 1 font $VER Install completely."
  echo "Please use the fontname: ${FONTN}c or ${FONTN}b"
  echo "For example:"
  echo "\begin{CJK}{UTF8}{${FONTN}c}"
  echo
  echo "You can remove it using uninstall.sh"
  echo
else
  kpsewhich ${FONTN}u01.pfb > /dev/null
  if [ $? = 1 ]; then
    echo
    echo "You didn't install cwTeX $FONTN Type 1."
    echo "Or you are not install by install.sh from"
    echo "cwt1 1.1, abort!"
    echo
    exit
  fi

  rm -f $MAPDIR/${FONTN}u.map
  rm -rf $TFMDIR $T1DIR $VFDIR $AFMDIR $ENCDIR
  for i in c b
  do
    rm -f $LTXDIR/UTF8/c70${FONTN}$i.*
    rm -f $LTXDIR/Bg5/c00${FONTN}$i.*
  done

  texhash
  echo "Please wait..."
  updmap --disable ${FONTN}u.map
  echo
  echo "Uninstall cwt1 $VER Type 1 font finish."
  echo
fi
