/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */
#define NSUBEXP  10
typedef struct regexp {
        char *origstr;          /* copy of original string prior to compile */
        int fs;
        int strlen;
        int max_sub;
        char *startp[NSUBEXP];
        char *endp[NSUBEXP];
        char regstart;                /* Internal use only. */
        char reganch;                /* Internal use only. */
        char *regstr;               /* Infernal use only. */
        char *regsstart;            /* Infernal use only. */
        char *regmust;                /* Internal use only. */
        int regmlen;                /* Internal use only. */
        int regslen;                /* Infernal use only. */
        char program[1];        /* Unwarranted chumminess with compiler. */
} regexp;

#ifndef TRUE
#  define TRUE  1
#  define FALSE 0
#endif

extern regexp *awka_regcomp(char *, int);
extern int awka_regexec(regexp *, char *, char **, char **, int, char);
extern void regsub(); 
extern void awka_regfree(regexp *);

#ifdef _ERROR_H
#  define regerror(msg) awka_error("regular expression: %s\n", (msg))
#else
extern void regerror();
#endif
