/*------------------------------------------------------------*
 | rexp.c                                                     |
 | copyright 1999,  Andrew Sumner (andrew_sumner@bigfoot.com) |
 |                                                            |
 | This is a source file for the awka package, a translator   |
 | of the AWK programming language to ANSI C.                 |
 |                                                            |
 | This library is free software; you can redistribute it     |
 | and/or modify it under the terms of the Awka Library       |
 | License, which may be found in the file LIBLICENSE.txt.    |
 |                                                            |
 | This library is distributed in the hope that it will be    |
 | useful, but WITHOUT ANY WARRANTY; without even the implied |
 | warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    |
 | PURPOSE.                                                   |
 *------------------------------------------------------------*/

/*
 * The functions in this module act as a wrapper for calling
 * awka_regcomp(), and as a static storage for all compiled
 * regular expressions, preventing the same expression from
 * having to be compiled more than once.  The regexps are stored
 * in a fixed-size hash table.
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>

#include "libawka.h"

typedef struct regexp_list_struct regexp_list;

struct regexp_list_struct {
  regexp_list *next;
  regexp *re_nofs;
  regexp *re_fs;
  char *str;
  unsigned int hval;
};

regexp_list **re_list = NULL;
#define RE_LIST_SIZE 17

#define _return_re_SPLIT \
  if (list != re_list[idx]) \
  { \
    list->next = re_list[idx]; \
    re_list[idx] = list; \
  } \
  list->re_fs = awka_regcomp(list->str, TRUE); \
  return list->re_fs; 

#define _return_re_MATCH \
  if (list != toplist) \
  { \
    list->next = toplist; \
    re_list[idx] = list; \
  } \
  list->re_nofs = awka_regcomp(list->str, FALSE); \
  return list->re_nofs; 


regexp *
_awka_compile_regexp_SPLIT(char *str, unsigned int len)
{
  register unsigned int idx, hval;
  regexp_list *list = NULL, *prevlist = NULL;

  if (!str)
    return NULL;

  if (!re_list)
  {
    malloc(&re_list, RE_LIST_SIZE * sizeof(regexp_list *));
    memset(re_list, 0, RE_LIST_SIZE * sizeof(regexp_list *));
  }

  idx = (hval = _awka_hashstr(str, len)) % RE_LIST_SIZE;
  list = re_list[idx];

  while (list)
  {
    if (list->hval == hval)
    {
      if (!strncmp(str, list->str, len))
      {
        /* we have a match */
        if (list->re_fs)
        {
          if (list != re_list[idx])
          {
            prevlist->next = list->next;
            list->next = re_list[idx];
            re_list[idx] = list;
          }
          return list->re_fs;
        }
        if (prevlist)
          prevlist->next = list->next;

        _return_re_SPLIT;
      }
    }
    prevlist = list;
    list  = list->next;
  }

  /* this expression not yet created */
  malloc( &list, sizeof(regexp_list) );
  malloc( &list->str, len+1 );
  strcpy(list->str, str);
  list->re_fs = list->re_nofs = NULL;
  list->hval = hval;

  _return_re_SPLIT;
}


regexp *
_awka_compile_regexp_MATCH(char *str, unsigned int len)
{
  register unsigned int idx, hval;
  regexp_list *list = NULL, *prevlist = NULL, *toplist;

  if (!str)
    return NULL;

  if (!re_list)
  {
    malloc(&re_list, RE_LIST_SIZE * sizeof(regexp_list *));
    memset(re_list, 0, RE_LIST_SIZE * sizeof(regexp_list *));
  }

  idx = (hval = _awka_hashstr(str, len)) % RE_LIST_SIZE;
  list = toplist = re_list[idx];

  while (list)
  {
    if (list->hval == hval)
    {
      if (!strncmp(str, list->str, len))
      {
        /* we have a match */
        if (list->re_nofs)
        {
          if (list != toplist)
          {
            prevlist->next = list->next;
            list->next = toplist;
            re_list[idx] = list;
          }
          return list->re_nofs;
        }
        if (prevlist)
          prevlist->next = list->next;

        _return_re_MATCH;
      }
    }
    prevlist = list;
    list  = list->next;
  }

  /* this expression not yet created */
  malloc( &list, sizeof(regexp_list) );
  malloc( &list->str, len+1 );
  strcpy(list->str, str);
  list->re_fs = list->re_nofs = NULL;
  list->hval = hval;

  _return_re_MATCH;
}

