
/********************************************
code.h
copyright 1991, Michael D. Brennan

This is a source file for mawk, an implementation of
the AWK programming language.

Mawk is distributed without warranty under the terms of
the GNU General Public License, version 2, 1991.
********************************************/


/* $Log: code.h,v $
 * Revision 1.5  1995/06/18  19:42:15  mike
 * Remove some redundant declarations and add some prototypes
 *
 * Revision 1.4  1994/12/13  00:13:01  mike
 * delete A statement to delete all of A at once
 *
 * Revision 1.3  1993/12/01  14:25:06  mike
 * reentrant array loops
 *
 * Revision 1.2  1993/07/22  00:04:01  mike
 * new op code _LJZ _LJNZ
 *
 * Revision 1.1.1.1  1993/07/03  18:58:10  mike
 * move source to cvs
 *
 * Revision 5.3  1993/01/14  13:11:11  mike
 * code2() -> xcode2()
 *
 * Revision 5.2  1993/01/07  02:50:33  mike
 * relative vs absolute code
 *
 * Revision 5.1  1991/12/05  07:59:07  brennan
 * 1.1 pre-release
 *
*/


/*  code.h  */

#ifndef  CODE_H
#define  CODE_H

#ifndef _AWKA_EXE_H

#include "memory.h"

#define  PAGESZ        512
        /* number of code instructions allocated at one time */
#define  CODEWARN        16

/* coding scope */
#define   SCOPE_MAIN    0
#define   SCOPE_BEGIN   1  
#define   SCOPE_END     2
#define   SCOPE_FUNCT   3


typedef struct {
INST *base, *limit, *warn, *ptr ;
} CODEBLOCK ;

extern CODEBLOCK active_code ;
extern CODEBLOCK *main_code_p, *begin_code_p, *end_code_p ;

extern INST *main_start, *begin_start, *end_start  ;
extern unsigned main_size, begin_size  ;
extern INST *execution_start ;
extern INST *next_label ;  /* next statements jump to here */
extern int dump_code_flag ;

#define code_ptr  active_code.ptr
#define code_base active_code.base
#define code_warn active_code.warn
#define code_limit active_code.limit
#define code_offset (code_ptr-code_base)

#define INST_BYTES(x) (sizeof(INST)*(unsigned)(x))

extern  CELL  eval_stack[] ;
extern int exit_code ;


static void code1(int x) {
  code_ptr -> lineno = token_lineno ;
  code_ptr -> file = pfile_name ;
  code_ptr++ -> op = x ;
}

/* shutup picky compilers */
#define  code2(x,p)  xcode2(x,(PTR)(p))

void  PROTO(xcode2, (int, PTR)) ;
void  PROTO(code2op, (int, int)) ;
INST *PROTO(code_shrink, (CODEBLOCK*, unsigned*)) ;
void  PROTO(code_grow, (void)) ;
void  PROTO(set_code, (void)) ;
void  PROTO(be_setup, (int)) ;
void  PROTO(dump_code, (void)) ;

#endif  /* _AWKA_EXE_H */

/*  the machine opcodes  */
/* to avoid confusion with a ptr FE_PUSHA must have op code 0 */
/* unfortunately enums are less portable than defines */

#define FE_PUSHA     0

#define _ABORT       1
#define _ABORT0      2
#define A_CAT        3
#define A_DEL        4
#define A_PUSHA      5
#define A_TEST       6
#define _ADD         7
#define _ADD_ASG     8
#define AE_PUSHA     9
#define AE_PUSHI    10
#define ALOOP       11
#define _ASSIGN     12
#define _BREAK      13
#define _BUILTIN    14
#define _CALL       15
#define _CAT        16
#define _COLON      17
#define _CONTINUE   18
#define DEL_A       19
#define _DIV        20
#define _DIV_ASG    21
#define _EQ         22
#define _ELSE       23
#define _EXIT       24
#define _EXIT0      25
#define F_ADD_ASG   26
#define F_ASSIGN    27
#define F_DIV_ASG   28
#define F_MOD_ASG   29
#define F_MUL_ASG   30
#define F_POST_DEC  31
#define F_POST_INC  32
#define F_POW_ASG   33
#define F_PRE_DEC   34
#define F_PRE_INC   35
#define F_PUSHA     36
#define F_PUSHI     37
#define F_SUB_ASG   38
#define _FE_PUSHA   39
#define FE_PUSHI    40
#define _HALT       41
#define _GOTO       42
#define _GT         43
#define _GTE        44
#define _JMAIN      45
#define _JMP        46
#define _JNZ        47
#define _JZ         48
#define L_PUSHA     49
#define L_PUSHI     50
#define LA_PUSHA    51
#define LAE_PUSHA   52
#define LAE_PUSHI   53
#define _LJNZ       54
#define _LJZ        55
#define _LT         56
#define _LTE        57
#define _MATCH      58
#define _MATCH0     59
#define _MATCH1     60
#define _MATCH2     61
#define _MOD        62
#define _MOD_ASG    63
#define _MUL        64
#define _MUL_ASG    65
#define _NEQ        66
#define _NEXT       67
#define _NEXTFILE   68
#define NF_PUSHI    69
#define _NOT        70
#define OL_GL       71
#define OL_GL_NR    72
#define _OMAIN      73
#define _POP        74
#define POP_AL      75
#define _POST_DEC   76
#define _POST_INC   77
#define _POW        78
#define _POW_ASG    79
#define _PRE_DEC    80
#define _PRE_INC    81
#define _PRINT      82
#define _PRINTF     83
#define _PUSHA      84
#define _PUSHC      85
#define _PUSHD      86
#define _PUSHI      87
#define _PUSHINT    88
#define _PUSHS      89
#define _QMARK      90
#define _RANGE      91
#define _RET        92
#define _RET0       93
#define SET_ALOOP   94
#define _STOP       95
#define _SUB        96
#define _SUB_ASG    97
#define _TEST       98
#define _UMINUS     99
#define _UPLUS      100
#define _ALENGTH    101
#undef _AND  /* this shuts-up the cygnus compiler */
#define _AND        102
#define _ARGCOUNT   103
#define _ARGVAL     104
#define _ASCII      105
#define _ATAN2      106
#define _CHAR       107
#define _CLOSE      108
#define _COMPL      109
#define _COS        110
#define _EXP        111
#define _FFLUSH     112
#define _GENSUB     113
#define _GETAWKVAR  114
#define _GETLINE    115
#define a_GMTIME    116
#define _GSUB       117
#define _INDEX      118
#define a_INT       119
#define _LEFT       120
#define _LENGTH     121
#define a_LOCALTIME 122
#define _LOG        123
#define _LSHIFT     124
#define _LTRIM      125
#define _MAX        126
#define _MIN        127
#define _OR         128
#define _RAND       129
#define _RIGHT      130
#define _RSHIFT     131
#define _RTRIM      132
#define _SIN        133
#define _SPLIT      134
#define _SPRINTF    135
#define _SQRT       136
#define _SRAND      137
#define a_STRFTIME  138
#define _SUB_BI     139
#define _SUBSTR     140
#define _SYSTEM     141
#define _SYSTIME    142
#define a_TIME      143
#define _TOLOWER    144
#define _TOTITLE    145
#define _TOUPPER    146
#define _TRIM       147
#define _XOR        148

#define CODE_MIN 0
#define CODE_MAX 99 

#define BI_MIN 100
#define BI_MAX 147

#define _FUNCTION   149
#define _BEGIN      150
#define _MAIN       151
#define _END        152
#define END_CODE    153

#endif  /* CODE_H */
